/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.common.server.helpdesk.RestAPIAuthObject;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIAuthorization;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import com.adventnet.sym.adsm.mobilesso.Ticket;
import com.adventnet.sym.adsm.mobilesso.TicketHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ADMPRestAPIAuthorization
extends ADMPAPIAuthorization {
    private static Logger out = Logger.getLogger("APILogger");
    private static final Integer TIMEOUT = 900;

    @Override
    public boolean isAuthorized(HttpServletRequest request) throws Exception {
        try {
            HttpSession session = request.getSession();
            session.setMaxInactiveInterval(TIMEOUT.intValue());
            String uri = request.getRequestURI();
            String authToken = request.getParameter("AuthToken");
            Ticket authTokenObj = null;
            if (authToken == null) {
                authToken = request.getParameter("AUTH_TOKEN");
            }
            if (authToken != null) {
                TicketHandler ticketHandler = TicketHandler.getInstance();
                authTokenObj = ticketHandler.getTicketFrmCache(authToken);
            }
            if (uri != null && (uri.contains("MobileLogin") || uri.contains("RestAPI/APIAuthToken") || uri.contains("RestAPI/GetAuthToken") || uri.contains("RestAPI/RemoveAuthToken") || uri.contains("RestAPI/RemoveTrust"))) {
                return true;
            }
            if (uri != null && uri.contains("RestAPI/ConfigureTrust")) {
                return ADMPAPIUtil.isAuthorizedSuperAdmin(request);
            }
            if (authToken != null) {
                if (authTokenObj != null) {
                    Long loginId = authTokenObj.getLoginId();
                    if (authTokenObj.getValidDate() - System.currentTimeMillis() < 0L) {
                        TicketHandler.getInstance().removeTicket(authToken);
                        authTokenObj = null;
                        throw new Exception("00000007");
                    }
                    RestAPIAuthObject authObject = new RestAPIAuthObject(loginId, request);
                    if (authObject.getLoginName() != null && authObject.getLoginDomainName() != null) {
                        if (ADMPAPIUtil.isUserAccountActive(loginId)) {
                            request.setAttribute("ADMP_SESSION_LOGIN_ID", (Object)loginId);
                            request.setAttribute("ADMP_AUTH_OBJECT", (Object)authObject);
                            return true;
                        }
                        out.log(Level.INFO, "User Account Not Active :00000011 for loginId : " + loginId);
                        throw new Exception("00000011");
                    }
                    throw new LoginException();
                }
                if (uri.contains("GetAuthObject")) {
                    return true;
                }
                throw new Exception("00000007");
            }
            throw new Exception("00000007");
        }
        catch (LoginException e) {
            e.printStackTrace();
            throw new Exception("00000007");
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorCode = e.getMessage();
            if (errorCode.equals("00000011")) {
                throw new Exception("00000011");
            }
            throw new Exception("00000006");
        }
    }
}

