/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticatorForMobile;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import com.adventnet.sym.adsm.mobilesso.CustomSSOConstants;
import com.adventnet.sym.adsm.mobilesso.Ticket;
import com.adventnet.sym.adsm.mobilesso.TicketHandler;
import com.manageengine.ads.fw.mobile.pushnotification.PNEnrollmentHandler;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class MobileApiLoginAction
extends DispatchAction
implements CustomSSOConstants {
    public ActionForward mobileLogout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println("MobileLoginAction logout entered");
        Properties props = new Properties();
        TicketHandler ticketHandler = TicketHandler.getInstance();
        String authToken = request.getParameter("AuthToken");
        Ticket authTokenObj = null;
        if (authToken != null) {
            authTokenObj = ticketHandler.getTicketFrmCache(authToken);
        }
        if (authTokenObj == null) {
            props.put("AuthtokenFound", "false");
        } else if (authToken != null) {
            ticketHandler.removeTicket(authToken);
            System.out.print("Auth Token  " + authToken + " Removed ");
        }
        request.getSession().invalidate();
        String deviceId = request.getParameter("DEVICE_UNIQUE_ID");
        if (!deviceId.equals("") && deviceId != null) {
            PNEnrollmentHandler.removeOldTokenEntry((String)deviceId);
        }
        props.setProperty("success", "true");
        request.setAttribute("RESPONSE", (Object)ADMPAPIUtil.getJSONString(props));
        response.addHeader("Access-Control-Allow-Origin", "*");
        return mapping.findForward("result");
    }

    public ActionForward domainList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println("Mobile Api login Action called");
        Properties domainList = DomainUtil.getConfiguredDomainNamesVsDomainFLatNames();
        domainList.put("ADManager Plus Authentication", "ADManager Plus Authentication");
        String resultResponse = null;
        resultResponse = ADMPAPIUtil.getJSONString(domainList);
        request.setAttribute("RESPONSE", (Object)resultResponse);
        response.addHeader("Access-Control-Allow-Origin", "*");
        return mapping.findForward("result");
    }

    public ActionForward getAuthTicket(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println(" Get auth ticket in Mobile API called ");
        try {
            TicketHandler ticketHandler = TicketHandler.getInstance();
            String authToken = request.getParameter("AuthToken");
            if (authToken != null) {
                System.out.println(" authToken should not come since it is requesting for AuthToken ");
                ticketHandler.removeTicket(authToken);
            } else {
                authToken = "1";
            }
            String domainName = request.getParameter("domainName");
            String loginName = request.getParameter("username");
            String password = request.getParameter("pwd");
            String serviceName = "System";
            String authObjectString = "";
            Long loginId = 0L;
            String loginNameFromUserProp = "";
            System.out.println("domainName" + domainName);
            ADMPADAuthenticatorForMobile authenticator = new ADMPADAuthenticatorForMobile();
            authenticator.init(request, loginName, domainName, password, serviceName);
            authenticator.authenticateUser();
            Ticket ticketObj = null;
            if (authenticator.getAuthenticationSuccess()) {
                ticketObj = ticketHandler.setTicket(request, response, authenticator);
                ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
                authObjectString = admpAuthObject.toJSONStringForMobile();
                loginId = admpAuthObject.getLoginId();
                loginNameFromUserProp = admpAuthObject.getLoginName();
            }
            Properties prop = new Properties();
            prop.setProperty("LoginStatus", new Boolean(authenticator.getAuthenticationSuccess()).toString());
            prop.setProperty("AuthTicket", ticketObj.getTicket());
            prop.setProperty("LoginStatusMessage", authenticator.getLoginStatusMessage());
            prop.setProperty("ValidDate", new Date(ticketObj.getValidDate()).toString());
            prop.setProperty("AdmpAuthObject", authObjectString);
            prop.setProperty("LoginName", loginNameFromUserProp);
            prop.setProperty("LoginId", loginId.toString());
            String resultResponse = null;
            resultResponse = ADMPAPIUtil.getJSONString(prop);
            request.setAttribute("RESPONSE", (Object)resultResponse);
            response.addHeader("Access-Control-Allow-Origin", "*");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("result");
    }
}

