/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api.workflow;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFAttributeHandler;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlow;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIErrorHandler;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class WorkflowUtil
extends ADMPAPIErrorHandler {
    private static Logger out = Logger.getLogger("APILogger");
    public static final String MODIFY_USER_ATTRIBUTES = "MODIFY_USER_ATTRIBUTES";
    public static final String CHANGE_PASSWORD = "CHANGE_PASSWORD";
    public static final String ADD_GROUP = "ADD_GROUP";
    public static final String REMOVE_GROUP = "REMOVE_GROUP";
    public static final String[] REQUEST_ACTIONS = new String[]{"MODIFY_USER_ATTRIBUTES", "CHANGE_PASSWORD", "ADD_GROUP", "REMOVE_GROUP"};
    public static String ADSMRequestActionDetails = "ADSMRequestActionDetails";
    public static String ADSMRequestActionInputs = "ADSMRequestActionInputs";

    public static boolean isParametersPresent(HttpServletRequest request) throws Exception {
        try {
            String requestAction = request.getParameter("REQUEST_ACTION");
            if (requestAction != null && Arrays.asList(REQUEST_ACTIONS).contains(requestAction)) {
                if ("true".equals(request.getParameter("IS_MULTI_VALUED"))) {
                    JSONArray urlParams = new JSONArray(request.getParameter("PARAMS"));
                    if (requestAction.equals(ADD_GROUP) || requestAction.equals(REMOVE_GROUP)) {
                        for (int i = 0; i < urlParams.length(); ++i) {
                            String[] attributes;
                            JSONObject urlParam = urlParams.getJSONObject(i);
                            for (String attribute : attributes = new String[]{"GROUP_SID", "GROUP_NAME"}) {
                                if (urlParam.has(attribute)) continue;
                                throw new Exception("00000007");
                            }
                        }
                    }
                } else {
                    JSONObject urlParams = new JSONObject(request.getParameter("PARAMS"));
                    if (requestAction.equals(CHANGE_PASSWORD)) {
                        String[] attributes;
                        for (String attribute : attributes = new String[]{"PASSWORD"}) {
                            if (urlParams.has(attribute)) continue;
                            throw new Exception("00000007");
                        }
                    } else if (requestAction.equals(MODIFY_USER_ATTRIBUTES)) {
                        String[] attributes;
                        for (String attribute : attributes = new String[]{"SAMACCOUNTNAME"}) {
                            if (urlParams.has(attribute)) continue;
                            throw new Exception("00000007");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, "", e);
            throw new Exception("00000007");
        }
        return true;
    }

    public static JSONObject getActionParams(HttpServletRequest request) throws Exception {
        JSONObject params = new JSONObject();
        try {
            JSONObject urlParams;
            Long actionId = null;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONArray multipleInput = new JSONArray();
            String subject = null;
            String description = null;
            String priority = null;
            String inputName = null;
            String mode = null;
            String requestAction = request.getParameter("REQUEST_ACTION");
            Long loginId = ADMPAPIUtil.getLoginId(request);
            String domainName = request.getParameter("domainName");
            JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
            domainName = domainDetails.getString("DOMAIN_NAME");
            String guid = ADMPAPIUtil.getGUID(request);
            ArrayList<String> guidList = new ArrayList<String>();
            guidList.add(guid);
            subject = request.getParameter("subject");
            description = request.getParameter("description");
            priority = request.getParameter("priority");
            mode = request.getParameter("mode");
            if (requestAction.equals(MODIFY_USER_ATTRIBUTES)) {
                urlParams = new JSONObject(request.getParameter("PARAMS"));
                actionId = WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID;
                inputName = "";
                JSONObject inputDetails = WorkflowUtil.importMUAAndGetInputDetails(loginId, domainName, urlParams);
                params.put("userCreationId", inputDetails.getLong("userCreationId"));
                multipleInput = inputDetails.getJSONArray("multipleInput");
            } else if (requestAction.equals(CHANGE_PASSWORD)) {
                urlParams = new JSONObject(request.getParameter("PARAMS"));
                String isUMCPEnabled = urlParams.has("IS_UMCP_ENABLED") ? urlParams.getString("IS_UMCP_ENABLED") : "false";
                actionId = WorkFlowUtil.PASSWORD_ACTION_ID;
                inputName = "Password";
                JSONObject fieldObj = new JSONObject();
                fieldObj.put("label", (Object)"Password");
                fieldObj.put("value", (Object)urlParams.getString("PASSWORD"));
                fieldObj.put("isSelected", (Object)"false");
                multipleInput.put((Object)fieldObj);
                fieldObj = new JSONObject();
                fieldObj.put("label", (Object)"UserMustChangePwd");
                fieldObj.put("value", (Object)isUMCPEnabled);
                fieldObj.put("isSelected", (Object)"false");
                multipleInput.put((Object)fieldObj);
            } else if (requestAction.equals(ADD_GROUP)) {
                urlParams = new JSONArray(request.getParameter("PARAMS"));
                actionId = WorkFlowUtil.ADDTO_GROUP_ACTION_ID;
                inputName = "addToGroup";
                for (int i = 0; i < urlParams.length(); ++i) {
                    JSONObject urlParam = urlParams.getJSONObject(i);
                    JSONObject fieldObj = new JSONObject();
                    fieldObj.put("label", (Object)urlParam.getString("GROUP_NAME"));
                    fieldObj.put("value", (Object)urlParam.getString("GROUP_SID"));
                    fieldObj.put("isSelected", (Object)"false");
                    multipleInput.put((Object)fieldObj);
                }
            } else if (requestAction.equals(REMOVE_GROUP)) {
                urlParams = new JSONArray(request.getParameter("PARAMS"));
                actionId = WorkFlowUtil.REMOVEFROM_GROUP_ACTION_ID;
                inputName = "removeFromGroup";
                for (int i = 0; i < urlParams.length(); ++i) {
                    JSONObject urlParam = urlParams.getJSONObject(i);
                    JSONObject fieldObj = new JSONObject();
                    fieldObj.put("label", (Object)urlParam.getString("GROUP_NAME"));
                    fieldObj.put("value", (Object)urlParam.getString("GROUP_SID"));
                    fieldObj.put("isSelected", (Object)"false");
                    multipleInput.put((Object)fieldObj);
                }
                JSONObject fieldObj = new JSONObject();
                fieldObj.put("label", (Object)"isRemoveAllGroup");
                fieldObj.put("value", (Object)"false");
                fieldObj.put("isSelected", (Object)"false");
                multipleInput.put((Object)fieldObj);
            }
            JSONObject inputValue = new JSONObject();
            inputValue.put("name", (Object)inputName);
            inputValue.put("value", (Object)"");
            inputValue.put("isMultiple", (Object)"true");
            inputValue.put("singleInputId", (Object)"-1");
            inputValue.put("multipleInput", (Object)multipleInput);
            params.put("subject", (Object)subject);
            params.put("description", (Object)description);
            params.put("mode", (Object)mode);
            params.put("requestAction", (Object)actionId);
            params.put("domainName", (Object)domainName);
            params.put("categoryId", 1);
            params.put("priority", 1);
            params.put("inputValue", (Object)inputValue);
            params.put("guidList", guidList);
            params.put("loginId", (Object)loginId);
        }
        catch (Exception e) {
            out.log(Level.INFO, "", e);
            throw new Exception("00001005");
        }
        return params;
    }

    public static JSONObject importMUAAndGetInputDetails(Long loginId, String domainName, JSONObject params) throws Exception {
        JSONObject inputDetails = new JSONObject();
        try {
            Object attributeKey;
            ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
            ArrayList userDetailsList = new ArrayList();
            ArrayList customAttributeList = new ArrayList();
            ArrayList<Object> unKnownAttribtesList = new ArrayList<Object>();
            Hashtable userDetails = new Hashtable();
            ArrayList<Properties> customList = new ArrayList<Properties>();
            String attributeIds = "";
            String customAttributeIds = "";
            String samAccAttribId = "";
            Iterator paramList = params.keys();
            while (paramList.hasNext()) {
                attributeKey = paramList.next();
                Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", attributeKey);
                if (!attributesdetails.isEmpty()) {
                    if (attributeList.contains(attributesdetails)) continue;
                    attributeList.add(attributesdetails);
                    String attribId = ((Integer)attributesdetails.get("ATTRIB_ID")).toString();
                    attributeIds = attributeIds + (attributeIds.equals("") ? attribId : ";" + attribId);
                    if (!attributeKey.toString().equals("sAMAccountName")) continue;
                    samAccAttribId = attribId;
                    continue;
                }
                if (unKnownAttribtesList.contains(attributeKey)) continue;
                unKnownAttribtesList.add(attributeKey);
                customAttributeIds = customAttributeIds + (customAttributeIds.equals("") ? attributeKey.toString() : ";" + attributeKey.toString());
            }
            paramList = params.keys();
            while (paramList.hasNext()) {
                attributeKey = (String)paramList.next();
                String attributeValue = params.getString(attributeKey);
                if (unKnownAttribtesList.contains(attributeKey)) {
                    Properties properties = new Properties();
                    properties.setProperty("CUSTOM_ATTRIB_NAME", (String)attributeKey);
                    properties.setProperty("CUSTOM_ATTRIB_VALUE", attributeValue);
                    customList.add(properties);
                    continue;
                }
                for (Hashtable hashtable : attributeList) {
                    String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    Integer relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                    if (relationalType == 1) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(attributeValue);
                        if (!ldapName.equalsIgnoreCase((String)attributeKey)) continue;
                        userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), list);
                        continue;
                    }
                    if (!ldapName.equalsIgnoreCase((String)attributeKey)) continue;
                    userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), attributeValue);
                }
            }
            userDetailsList.add(userDetails);
            customAttributeList.add(customList);
            Long userCreationId = null;
            if (!userDetailsList.isEmpty()) {
                String defaultContainerName = UserMgmtUtil.getDefaultContainerName((String)DomainUtil.getDefaultNamingContext((String)domainName), new ArrayList());
                userCreationId = AddUserHandler.getInstance().addNewUserList("", domainName, defaultContainerName, Long.valueOf(0L), loginId);
                AddUserHandler.getInstance().addUserDetailsList(userCreationId, userDetailsList, attributeList, customAttributeList);
            }
            inputDetails.put("userCreationId", userCreationId);
            JSONArray multipleInput = new JSONArray();
            JSONObject fieldObj = new JSONObject();
            fieldObj.put("label", (Object)"validSelected");
            fieldObj.put("value", (Object)attributeIds);
            fieldObj.put("isSelected", (Object)"false");
            multipleInput.put((Object)fieldObj);
            fieldObj = new JSONObject();
            fieldObj.put("label", (Object)"validSelectedValues");
            fieldObj.put("value", (Object)samAccAttribId);
            fieldObj.put("isSelected", (Object)"false");
            multipleInput.put((Object)fieldObj);
            fieldObj = new JSONObject();
            fieldObj.put("label", (Object)"totalAttributes");
            fieldObj.put("value", (Object)attributeIds);
            fieldObj.put("isSelected", (Object)"false");
            multipleInput.put((Object)fieldObj);
            fieldObj = new JSONObject();
            fieldObj.put("label", (Object)"customAttributes");
            fieldObj.put("value", (Object)customAttributeIds);
            fieldObj.put("isSelected", (Object)"false");
            multipleInput.put((Object)fieldObj);
            inputDetails.put("multipleInput", (Object)multipleInput);
        }
        catch (Exception e) {
            out.log(Level.INFO, "", e);
            throw new Exception("00000007");
        }
        return inputDetails;
    }

    public static JSONObject getAllRequests(HttpServletRequest request, AdventNetResourceBundle rb) throws Exception {
        JSONObject result = new JSONObject();
        try {
            Long loginId = null;
            loginId = request.getAttribute("ADMP_SESSION_LOGIN_ID") != null ? (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID") : ADMPAPIUtil.getLoginId(request);
            JSONObject params = new JSONObject(request.getParameter("PARAMS"));
            String requestId = params.has("requestId") ? params.getString("requestId") : null;
            int attributeId = params.has("attributeId") ? params.getInt("attributeId") : 11001;
            boolean ascending = params.has("ascending") ? params.getBoolean("ascending") : true;
            String searchFilter = params.has("searchFilter") ? params.getString("searchFilter") : "0";
            int startIndex = params.has("startIndex") ? params.getInt("startIndex") : 1;
            int toIndex = params.has("toIndex") ? params.getInt("toIndex") : 25;
            JSONArray requestActions = params.has("requestActions") ? params.getJSONArray("requestActions") : null;
            Long requestMode = params.has("mode") ? Long.valueOf(params.getLong("mode")) : null;
            Long[] requestActionArray = null;
            if (requestActions != null && requestActions.length() > 0) {
                requestActionArray = new Long[requestActions.length()];
                for (int i = 0; i < requestActions.length(); ++i) {
                    requestActionArray[i] = requestActions.getLong(i);
                }
            }
            JSONObject requestDetailsList = WorkFlow.getAllRequests((int)startIndex, (int)toIndex, (String)searchFilter, (ArrayList)WFAttributeHandler.getInstance().listRequestsAllColumns(), (Integer)attributeId, (Boolean)ascending, (Long)loginId, (Object)requestId, (AdventNetResourceBundle)rb, (boolean)false, (Long[])requestActionArray, (boolean)true, (boolean)true, (Long)requestMode);
            JSONArray requestDetails = requestDetailsList.getJSONArray("REQUEST_LIST");
            result.put("REQUEST_COUNT", requestDetailsList.getInt("REQUEST_COUNT"));
            result.put("REQUEST_LIST", (Object)new JSONArray());
            for (int i = 0; i < requestDetails.length(); ++i) {
                JSONObject requestDetail = requestDetails.getJSONObject(i);
                Long reqId = requestDetail.getLong("REQUEST_ID");
                WFViewRequest wfViewRequest = new WFViewRequest(reqId, rb);
                wfViewRequest.updateWFTaskDetails();
                result.accumulate("REQUEST_LIST", (Object)wfViewRequest.getRequestDetails(rb).put("REQUEST_DETAILS", (Object)requestDetail));
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, "", e);
            throw new Exception("00000007");
        }
        return result;
    }

    public static JSONObject getRequestDetails(Long loginId, String requestId, AdventNetResourceBundle rb) throws Exception {
        JSONObject result = new JSONObject();
        try {
            JSONObject requestDetailsList = WorkFlow.getAllRequests((int)-1, (int)0, (String)"0", (ArrayList)WFAttributeHandler.getInstance().listRequestsAllColumns(), (Integer)11001, (Boolean)true, (Long)loginId, (Object)requestId, (AdventNetResourceBundle)rb, (boolean)true, null, (boolean)true, (boolean)true, null);
            JSONArray requestDetails = requestDetailsList.getJSONArray("REQUEST_LIST");
            if (requestDetails.length() > 0) {
                JSONObject requestDetail = requestDetails.getJSONObject(0);
                Long reqId = requestDetail.getLong("REQUEST_ID");
                WFViewRequest wfViewRequest = new WFViewRequest(reqId, rb);
                wfViewRequest.updateWFTaskDetails();
                result = wfViewRequest.getRequestDetails(rb).put("REQUEST_DETAILS", (Object)requestDetail);
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, "", e);
        }
        return result;
    }
}

