/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.audit;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.audit.AuditTask;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.audit.DelegationReportJRRewindableDataSource;
import com.adventnet.sym.adsm.common.webclient.audit.HDDAuditReportAction;
import com.adventnet.sym.adsm.common.webclient.delegation.HDTReportListener;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.ZipUtility;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class HDDAuditReportListener
implements AuditTask {
    static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static Integer reportId = 0;
    private static ArrayList techList = null;
    public static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String productHome = null;
    private static String basepath = null;
    private static int exportCount = 0;
    private static String exportFileName = "";

    public HDDAuditReportListener() {
        reportId = new Integer(7004);
        techList = new ArrayList();
    }

    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, ArrayList selectedColumnList) {
        return this.exportReport(schedulerName, filePath, attachmentType, format, techList, loginId, startTime, endTime, null, null, null, null, null, rb);
    }

    public void exportReport(String filePath, String attachmentType, String format, Long loginId, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList) {
    }

    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, AdventNetResourceBundle rb, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime) {
        return false;
    }

    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, AdventNetResourceBundle rb, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime, ArrayList selectedColumnList) {
        return false;
    }

    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, AdventNetResourceBundle rb) {
        String reportType = "standard";
        boolean isEmptyReport = true;
        HDDAuditReportListener.rb = rb;
        if (format.contains("_")) {
            String[] parts = format.split("_");
            format = parts[0];
            reportType = parts[1];
        }
        try {
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
            if (format == null) {
                format = "pdf";
            }
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String reportFileName = (String)r.get("REPORT_FILE_NAME");
            String reportName = (String)r.get("REPORT_NAME");
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("desc", rb.getString((String)r.get("DESCRIPTION")));
            inputs.put("date", DateTimeUtil.getDateFormat((Long)loginId).format(System.currentTimeMillis()));
            if (reportType.equals("standard")) {
                reportFileName = "DelegationAuditReport.xml";
            }
            if ((productHome = System.getProperty("product.home")) == null) {
                productHome = System.getProperty("server.home");
            }
            basepath = productHome + File.separator + "webapps" + File.separator + "adsm" + File.separator;
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            Long[] technicians = new Long[techList.size()];
            for (int i = 0; i < techList.size(); ++i) {
                technicians[i] = (Long)techList.get(i);
            }
            isEmptyReport = HDDAuditReportListener.exportAuditReport(reportFileName, format, attributelist, reportName, technicians, startTime, endTime, inputs, filePath, loginId, reportType, response, request, ascending, sortColumn, criteria);
            if (attachmentType.equalsIgnoreCase("zip") || attachmentType.equalsIgnoreCase("link")) {
                ZipUtility.addtoZip(new Long(0L), filePath);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isEmptyReport;
    }

    private static boolean exportAuditReport(String reportFileName, String format, ArrayList attributelist, String reportName, Long[] technicians, long fromTime, long toTime, HashMap inputs, String filePath, Long loginId, String reportType, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria) {
        if (reportType.equals("standard")) {
            return HDDAuditReportListener.exportStandardViewAuditReport(reportFileName, format, attributelist, reportName, technicians, fromTime, toTime, inputs, filePath, loginId, response, request, ascending, sortColumn, criteria);
        }
        return HDDAuditReportListener.exportSummaryViewAuditReport(reportFileName, format, attributelist, reportName, technicians, fromTime, toTime, inputs, filePath, loginId, response, request, ascending, sortColumn, criteria);
    }

    private static boolean exportSummaryViewAuditReport(String reportFileName, String format, ArrayList attributelist, String reportName, Long[] technicians, long fromTime, long toTime, HashMap inputs, String filePath, Long loginId, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria) {
        String reportType = "summary";
        Locale locale = I18NUtil.getDefaultLocale((Long)loginId);
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        if (request != null) {
            locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        }
        if (format.toLowerCase().indexOf("xls") != -1 || format.toLowerCase().indexOf("csv") != -1) {
            return HDDAuditReportListener.exportStandardViewAuditReport(reportFileName, format, attributelist, reportName, technicians, fromTime, toTime, inputs, filePath, loginId, response, request, ascending, sortColumn, criteria);
        }
        try {
            reportName = rb.getString(reportName);
            int count = HDDAuditReportAction.getCount(criteria);
            HDDAuditReportListener.setExportRowCount(count);
            ArrayList summaryResult = new ArrayList();
            Boolean hasSubReport = false;
            ArrayList<Object> summaryViewPrintList = new ArrayList<Object>();
            ArrayList<JasperPrint> detailsPrintList = new ArrayList<JasperPrint>();
            if (count != 0) {
                if (ascending == null) {
                    ascending = "false";
                }
            } else {
                return false;
            }
            Hashtable list = HDDAuditReportAction.getRows(attributelist, -1, -1, Boolean.valueOf(ascending), sortColumn, criteria, loginId, true);
            summaryResult = (ArrayList)list.get("resultList");
            hasSubReport = (Boolean)list.get("hasSubReport");
            ReportJRDataSource dataSource = new ReportJRDataSource(summaryResult, new Hashtable(), showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            HDTReportListener.setPDFFontForTitleBand(format, jasperDesign, locale);
            reportFileName = HDDAuditReportListener.getFormattedFileName("Admin AuditReport");
            if (format.toLowerCase().indexOf("pdf") != -1 || format.toLowerCase().indexOf("html") != -1) {
                inputs.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable columnWidths = JRDesignUtil.calculateWidthForDelegationAuditReport(attributelist, summaryResult, new Hashtable(), format, reportType, showSerialNo, hasSubReport);
            if (!columnWidths.isEmpty()) {
                JRDesignUtil.fillBandForAuditReport(columnWidths, jasperDesign, headerBand, detailBand, attributelist, format, null, 0, rb, loginId, reportType, showSerialNo, hasSubReport, locale);
                JRDesignField field = new JRDesignField();
                field.setName("-1");
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
            } else {
                JRDesignUtil.fillNoDataBand(jasperDesign, detailBand, format, rb, locale);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            JasperPrint print = null;
            if (reportName != null) {
                inputs.put("title", reportName);
            } else {
                inputs.put("title", " ");
            }
            inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            print = !columnWidths.isEmpty() ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs, (JRDataSource)dataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs);
            int AddToPgNumber = print.getPages().size();
            ArrayList configuredIamAppIds = O365MgmtHandler.getConfiguredIamAppIds();
            boolean fillAccountTypeDetails = configuredIamAppIds.size() != 1 || configuredIamAppIds.get(0) != Integer.valueOf(1);
            for (int i = 0; i < summaryResult.size(); ++i) {
                Long categoryId;
                Hashtable summaryRow = (Hashtable)summaryResult.get(i);
                ArrayList detailsList = null;
                Long audit_Id = (Long)summaryRow.get("AUDIT_ID");
                detailsList = HDDAuditReportAction.getPropertiesList(audit_Id, categoryId = (Long)summaryRow.get("CATEGORY_ID"));
                if (detailsList.size() == 0) {
                    summaryRow.put(new Integer(audit_Id.intValue()), "JR_PAGE_ANCHOR_0_1");
                    continue;
                }
                String xmlFileName = fillAccountTypeDetails ? "DelegationAuditReportDetailsWithAccountType.xml" : "DelegationAuditReportDetails.xml";
                DelegationReportJRRewindableDataSource datasrc = new DelegationReportJRRewindableDataSource(detailsList);
                String auditRepDetails = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + xmlFileName;
                JasperDesign jasperDes = JRXmlLoader.load((String)auditRepDetails);
                HDTReportListener.setPDFFontForTitleBand(format, jasperDes, locale);
                if (format.toLowerCase().indexOf("pdf") != -1) {
                    int i1;
                    JRElement[] elements1;
                    JRFont reportPDFFont = JRFieldDesignUtil.getPDFExporterFont(locale);
                    JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, 12, false, false);
                    if (jasperDes.getDetail() != null) {
                        JRDesignBand subDetailBand = (JRDesignBand)jasperDes.getDetail();
                        elements1 = subDetailBand.getElements();
                        for (i1 = 0; i1 < elements1.length; ++i1) {
                            if (!(elements1[i1] instanceof JRDesignTextField)) continue;
                            ((JRDesignTextField)elements1[i1]).setFont((JRFont)normalFont);
                        }
                    }
                    if (jasperDes.getSummary() != null) {
                        JRDesignBand summaryBand = (JRDesignBand)jasperDes.getSummary();
                        elements1 = summaryBand.getElements();
                        for (i1 = 0; i1 < elements1.length; ++i1) {
                            if (!(elements1[i1] instanceof JRDesignTextField)) continue;
                            ((JRDesignTextField)elements1[i1]).setFont((JRFont)normalFont);
                        }
                    }
                }
                JasperReport jasperRep = JasperCompileManager.compileReport((JasperDesign)jasperDes);
                if (reportName != null) {
                    inputs.put("title", reportName);
                } else {
                    inputs.put("title", " ");
                }
                if (summaryRow != null) {
                    inputs.put("Managed By", summaryRow.get(19001));
                    inputs.put("Managed On", summaryRow.get(19003));
                    inputs.put("Action Time", summaryRow.get(19004));
                    inputs.put("Action", summaryRow.get(19005));
                } else {
                    inputs.put("Managed By", rb.getString("admp.deleg.hdt_deleg.hdd_reports.technician_name"));
                    inputs.put("Managed On", rb.getString("admp.deleg.hdt_deleg.hdd_reports.object_name"));
                    inputs.put("Action Time", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.action_time"));
                    inputs.put("Action", rb.getString("admp.deleg.hdt_deleg.hdd_reports.action_name"));
                }
                inputs.put("ManagedByHeader", rb.getString("admp.deleg.hdt_deleg.hdd_reports.technician_name"));
                inputs.put("ManagedOnHeader", rb.getString("admp.deleg.hdt_deleg.hdd_reports.object_name"));
                inputs.put("StatusHeader", rb.getString("admp.deleg.hdt_deleg.hdd_reports.action_name"));
                inputs.put("ActTime", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.action_time"));
                inputs.put("summaryView", rb.getString("admp.deleg.hdt_deleg.hdt_reports.scheduler.summary_view").toLowerCase());
                inputs.put("SettingsHeader", rb.getString("admp.deleg.hdt_deleg.hdd_reports.action_settings"));
                inputs.put("AccountTypeHeader", rb.getString("admp.mgmt.fc_layout.common.account_type"));
                inputs.put("DomainNameHeader", rb.getString("admp.deleg.hdt_deleg.hdd_reports.domain_name"));
                inputs.put("ValuesHeader", rb.getString("admp.deleg.hdt_deleg.hdd_reports.values"));
                inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
                inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
                inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
                inputs.put("Audit_Id", Long.toString(audit_Id));
                inputs.put("AddToPgNumber", AddToPgNumber);
                JasperPrint jrPrintObject = JasperFillManager.fillReport((JasperReport)jasperRep, (Map)inputs, (JRDataSource)datasrc);
                detailsPrintList.add(jrPrintObject);
                AddToPgNumber += jrPrintObject.getPages().size();
            }
            summaryViewPrintList.add(print);
            summaryViewPrintList.addAll(detailsPrintList);
            HDDAuditReportListener.auditReportExporter(summaryViewPrintList, format, reportFileName, filePath, response, request, locale, loginId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private static boolean exportStandardViewAuditReport(String reportFileName, String format, ArrayList attributelist, String reportName, Long[] technicians, long fromTime, long toTime, HashMap inputs, String filePath, Long loginId, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria) {
        String reportType = "standard";
        Locale locale = I18NUtil.getDefaultLocale((Long)loginId);
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        if (request != null) {
            locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        }
        try {
            Hashtable columnWidths;
            reportName = rb.getString(reportName);
            int count = HDDAuditReportAction.getCount(criteria);
            HDDAuditReportListener.setExportRowCount(count);
            ArrayList result = new ArrayList();
            ArrayList objectIdList = new ArrayList();
            ArrayList<JasperPrint> printList = new ArrayList<JasperPrint>();
            if (count != 0) {
                if (ascending == null) {
                    ascending = "false";
                }
            } else {
                return false;
            }
            Hashtable list = HDDAuditReportAction.getRows(attributelist, -1, -1, Boolean.valueOf(ascending), sortColumn, criteria, loginId, true);
            result = (ArrayList)list.get("resultList");
            if (format.toLowerCase().indexOf("csv") != -1) {
                for (int ii = 0; ii < result.size(); ++ii) {
                    Hashtable resultHash = (Hashtable)result.get(ii);
                    ArrayList detailsList = null;
                    Long audit_Id = (Long)resultHash.get("AUDIT_ID");
                    Long categoryId = (Long)resultHash.get("CATEGORY_ID");
                    detailsList = HDDAuditReportAction.getPropertiesList(audit_Id, categoryId);
                    StringBuilder rowsString = new StringBuilder("");
                    for (int i = 0; i < detailsList.size(); ++i) {
                        Hashtable detailsRow = (Hashtable)detailsList.get(i);
                        rowsString.append(detailsRow.get("Settings"));
                        rowsString.append(" : ");
                        String dnName = detailsRow.get("Domain Name").toString();
                        if (dnName != null && dnName != "" && !dnName.equals("-")) {
                            String accountType;
                            rowsString.append(dnName);
                            if (detailsRow.containsKey("AccountType") && !(accountType = (String)detailsRow.get("AccountType")).equalsIgnoreCase(rb.getString("admp.mgmt.fc_layout.common.active_directory"))) {
                                rowsString.append("(" + accountType + ")");
                            }
                            rowsString.append(" : ");
                        }
                        rowsString.append(detailsRow.get("Values"));
                        rowsString.append(" ; ");
                    }
                    String rowValue = rowsString.toString();
                    rowValue = StrUtil.getHTMLUnescaped((String)rowValue);
                    rowValue = rowValue.replaceAll("\\<B>", "");
                    rowValue = rowValue.replaceAll("\\</B>", "");
                    rowValue = rowValue.replaceAll("\\<br/>", "");
                    rowValue = rowValue.replaceAll("\\<span*>", "");
                    rowValue = rowValue.replaceAll("\\<//span>", "");
                    if ((rowValue = rowValue.replaceAll("\\<BR/>", "")) == null || rowValue.equals("")) continue;
                    resultHash.put(19005, rowValue);
                }
            }
            ReportJRDataSource dataSource = new ReportJRDataSource(result, new Hashtable(), showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            HDTReportListener.setPDFFontForTitleBand(format, jasperDesign, locale);
            HashMap<String, DelegationReportJRRewindableDataSource> JrRewindDS = new HashMap<String, DelegationReportJRRewindableDataSource>();
            if (format.toLowerCase().indexOf("csv") == -1) {
                for (int ii = 0; ii < result.size(); ++ii) {
                    Hashtable resultHash = (Hashtable)result.get(ii);
                    ArrayList resArraylist = null;
                    Long audit_Id = (Long)resultHash.get("AUDIT_ID");
                    Long categoryId = (Long)resultHash.get("CATEGORY_ID");
                    resArraylist = HDDAuditReportAction.getPropertiesList(audit_Id, categoryId);
                    HDDAuditReportListener.addAccountType(resArraylist, rb);
                    if (resArraylist.size() == 0) {
                        Hashtable<String, String> rowHash = new Hashtable<String, String>();
                        rowHash.put(new String("Settings"), " ");
                        rowHash.put(new String("Domain Name"), " ");
                        rowHash.put(new String("Values"), (String)resultHash.get(19005));
                        resArraylist.add(rowHash);
                    }
                    JrRewindDS.put(audit_Id.toString(), new DelegationReportJRRewindableDataSource(resArraylist));
                }
                inputs.put("SubReportDS", JrRewindDS);
                String subReportLoc = basepath + "jasperreports" + File.separator + "jasper" + File.separator + "DelegationAuditReportStandardSubreport.jasper";
                File f = new File(subReportLoc);
                if (!f.exists()) {
                    String subReportjrXMLLoc = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "DelegationAuditReportStandardSubreport.xml ";
                    JasperDesign subJasperDesign = JRXmlLoader.load((String)subReportjrXMLLoc);
                    JasperCompileManager.compileReportToFile((JasperDesign)subJasperDesign, (String)subReportLoc);
                }
                inputs.put("SubReportName", subReportLoc);
            }
            reportFileName = HDDAuditReportListener.getFormattedFileName("AdminAuditReport");
            if (format.toLowerCase().indexOf("xls") != -1 || format.toLowerCase().indexOf("csv") != -1) {
                JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                JRElement[] elements = titleBand.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    titleBand.removeElement((JRDesignElement)elements[i]);
                }
                titleBand.setHeight(0);
                JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                elements = pageHeaderBand.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    pageHeaderBand.removeElement((JRDesignElement)elements[i]);
                }
                pageHeaderBand.setHeight(0);
                JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                elements = pageFooterBand.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    pageFooterBand.removeElement((JRDesignElement)elements[i]);
                }
                pageFooterBand.setHeight(0);
                if (format.toLowerCase().indexOf("xls") == -1) {
                    JRDesignBand summaryBand = (JRDesignBand)jasperDesign.getSummary();
                    elements = summaryBand.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        summaryBand.removeElement((JRDesignElement)elements[i]);
                    }
                    summaryBand.setHeight(0);
                }
                inputs.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            } else if (format.toLowerCase().indexOf("pdf") != -1 || format.toLowerCase().indexOf("html") != -1) {
                inputs.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRDesignElement subreportElement = null;
            JRElement[] elements = detailBand.getElements();
            subreportElement = (JRDesignElement)elements[elements.length - 1];
            detailBand.removeElement((JRDesignElement)elements[elements.length - 1]);
            if (format.toLowerCase().indexOf("csv") != -1) {
                detailBand.removeElement((JRDesignElement)elements[elements.length - 2]);
            }
            if (!(columnWidths = JRDesignUtil.calculateWidthForDelegationAuditReport(attributelist, result, new Hashtable(), format, reportType, showSerialNo, false)).isEmpty()) {
                JRDesignUtil.fillBandForAuditReport(columnWidths, jasperDesign, headerBand, detailBand, attributelist, format, null, 0, rb, loginId, reportType, showSerialNo, locale);
                JRDesignField field = new JRDesignField();
                field.setName("-1");
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                if (subreportElement != null && format.toLowerCase().indexOf("csv") == -1) {
                    detailBand.addElement(subreportElement);
                }
            } else {
                JRDesignUtil.fillNoDataBand(jasperDesign, detailBand, format, rb, locale);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            JasperPrint print = null;
            if (reportName != null) {
                inputs.put("title", reportName);
            } else {
                inputs.put("title", " ");
            }
            inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            print = !columnWidths.isEmpty() ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs, (JRDataSource)dataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs);
            printList.add(print);
            HDDAuditReportListener.auditReportExporter(printList, format, reportFileName, filePath, response, request, locale, loginId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private static void addAccountType(ArrayList resultArrayList, AdventNetResourceBundle rb) {
        for (Hashtable result : resultArrayList) {
            String domainName;
            String accountType;
            if (!result.containsKey("AccountType") || (accountType = (String)result.get("AccountType")).equalsIgnoreCase(rb.getString("admp.mgmt.fc_layout.common.active_directory")) || (domainName = (String)result.get("Domain Name")) == null) continue;
            result.put("Domain Name", domainName + "(" + accountType + ")");
        }
    }

    public static void auditReportExporter(ArrayList printList, String format, String reportFileName, String filePath, HttpServletResponse response, HttpServletRequest request, Locale locale, Long loginId) throws Exception {
        String password = PasswordUtil.getExportFilePassword((Long)loginId);
        ReportExporter exporter = new ReportExporter(format.toLowerCase(), password);
        if (format.toLowerCase().indexOf("pdf") != -1) {
            if (filePath != null) {
                exporter.exportAsPdf(printList, reportFileName, new Long(0L), filePath);
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsPdf(printList, reportFileName, response, locale);
            }
        } else if (format.toLowerCase().indexOf("html") != -1) {
            if (filePath != null) {
                exporter.exportAsHtml(printList, filePath + File.separator + reportFileName + ".html", new HashMap());
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsHtml(printList, reportFileName, response, request.getSession());
            }
        } else if (format.toLowerCase().indexOf("xlsx") != -1) {
            if (filePath != null) {
                exporter.exportAsExcelForXlsx(printList, filePath + File.separator + reportFileName + ".xlsx", null);
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsXlsx(printList, reportFileName, response);
            }
        } else if (format.toLowerCase().indexOf("xls") != -1) {
            exporter.exportAsExcel(printList, filePath + File.separator + reportFileName + ".xls");
        } else if (format.toLowerCase().indexOf("csv") != -1) {
            if (filePath != null) {
                exporter.exportAsCsv(printList, filePath + File.separator + reportFileName + ".csv", (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID"));
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsCsv(printList, reportFileName, response, (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID"));
            }
        } else {
            reportLogger.log(Level.INFO, "Invalid Report Type");
        }
        HDDAuditReportListener.setExportFileName(exporter.getExportFile());
    }

    private static String getFormattedFileName(String reportFileName) {
        if (reportFileName != null) {
            String reportFileName1 = reportFileName;
            Vector<String> vector = new Vector<String>();
            String strTemp = new String();
            for (int i = 0; i < reportFileName1.length(); ++i) {
                char c = '/';
                if (reportFileName1.charAt(i) == c) {
                    vector.add(strTemp);
                    strTemp = new String();
                    continue;
                }
                strTemp = strTemp + reportFileName1.charAt(i);
            }
            vector.add(strTemp);
            String newreportFileName = "";
            for (int j = 0; j < vector.size(); ++j) {
                String name = (String)vector.elementAt(j);
                newreportFileName = newreportFileName + name;
            }
            reportFileName = newreportFileName;
        }
        return reportFileName;
    }

    public static void setExportRowCount(int count) {
        System.out.println("Setting export count..." + count);
        exportCount = count;
    }

    public static int getExportRowCount() {
        return exportCount;
    }

    public static void setExportFileName(String fileName) {
        System.out.println("Setting export name..." + fileName);
        exportFileName = fileName;
    }

    public static String getExportFileName() {
        return exportFileName;
    }
}

