/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.audit;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.MetaTableHandler;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.audit.AuditTask;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.audit.HDTAuditReportListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.util.AuditUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class HDTAuditReportAction
extends DispatchAction {
    static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    static String[] creationIds = new String[]{"6001", "6002", "2006", "3001", "5004"};
    public static final Integer[] htmlNoEscapeListIds = new Integer[]{11149};

    public ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        DynaActionForm bean = (DynaActionForm)form;
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String isNavigate;
            Long cvId;
            int count = 0;
            long fromTime = 0L;
            long toTime = 0L;
            Hashtable result = new Hashtable();
            ArrayList resultList = new ArrayList();
            String action = request.getParameter("action");
            String search = request.getParameter("search");
            String searchString = (String)bean.get("searchString");
            String init = request.getParameter("init");
            if (init != null && init.equalsIgnoreCase("true")) {
                bean.set("FROM_INDEX", (Object)"");
            }
            int startIndex = 1;
            int range = 25;
            if (action == null || action.equalsIgnoreCase("")) {
                action = "showAll";
                this.init(bean);
                bean.initialize(mapping);
            }
            if (search == null || search.equalsIgnoreCase("")) {
                search = "false";
            }
            if ((cvId = ColumnConfiguration.getCVId((String)"Audit", (long)loginId)) == null) {
                cvId = ColumnConfiguration.getDefaultCvId((String)"Audit");
            }
            ArrayList viewColumnList = ColumnConfiguration.getViewColumnList((long)cvId);
            Iterator itr = viewColumnList.iterator();
            ArrayList<Integer> selColList = new ArrayList<Integer>();
            DataObject reportsDO = ReportAttributeHandler.getInstance().getViewColumnDO(new Integer(7003), loginId);
            while (itr.hasNext()) {
                HashMap details = (HashMap)itr.next();
                Criteria cri = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"), (Object)((String)details.get("TABLE_NAME")), 0);
                Row attrRow = reportsDO.getRow("ADSMAttributeDetails", cri = cri.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"), (Object)((String)details.get("COLUMN_NAME")), 0)));
                if (attrRow == null) continue;
                selColList.add((Integer)attrRow.get("ATTRIB_ID"));
            }
            ArrayList attributeList = ReportAttributeHandler.getInstance().getViewColumn(new Integer(7003), loginId);
            if (search.equalsIgnoreCase("true")) {
                bean.set("searchString", (Object)searchString);
                if (request.getParameter("FROM_INDEX") != null && request.getParameter("RANGE") != null) {
                    bean.set("FROM_INDEX", (Object)request.getParameter("FROM_INDEX"));
                }
            } else {
                bean.set("searchString", (Object)"");
            }
            String startIndexStr = request.getParameter("FROM_INDEX");
            String rangeStr = request.getParameter("RANGE");
            String ascending = (String)bean.get("isAscending");
            String sortColumn = (String)bean.get("sortColumn");
            if (sortColumn == null || sortColumn.equals("")) {
                sortColumn = "AUDIT_TIME";
            }
            if (startIndexStr != null && !startIndexStr.equals("")) {
                startIndex = new Integer(startIndexStr);
            }
            if (rangeStr != null) {
                range = Integer.parseInt(rangeStr);
            }
            if ((isNavigate = request.getParameter("isNavigate")) != null && isNavigate.equals("false")) {
                NavigateRangeUtil.setDefaultRange((String)"AuditReport", (int)range, (Long)loginId);
            } else if (isNavigate == null) {
                range = NavigateRangeUtil.getDefaultRange((String)"AuditReport", (Long)loginId);
                bean.set("RANGE", (Object)String.valueOf(range));
            }
            if (ascending == null) {
                ascending = "false";
            }
            ArrayList selectedHDT = (ArrayList)bean.get("selectedHDT");
            String period = (String)bean.get("period");
            long currentTime = System.currentTimeMillis();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (period.equalsIgnoreCase("")) {
                Long periodDiff = 2592000000L;
                fromTime = currentTime - periodDiff;
                toTime = currentTime;
            } else if (period.equalsIgnoreCase("customPeriod")) {
                String startDate = (String)bean.get("startDate");
                String toDate = (String)bean.get("endDate");
                fromTime = startDate != null ? sdf.parse(startDate).getTime() : cal.getTime().getTime();
                toTime = toDate != null ? sdf.parse(toDate).getTime() : cal.getTime().getTime();
                toTime += 86400000L;
            } else {
                String periodMills = (String)bean.get("period");
                long periodMillsec = Long.valueOf(periodMills);
                fromTime = currentTime - periodMillsec;
                toTime = currentTime;
            }
            int hdtLen = selectedHDT.size();
            Long[] hdtArray = new Long[hdtLen];
            if (hdtLen > 0) {
                for (int i = 0; i < hdtLen; ++i) {
                    hdtArray[i] = (Long)selectedHDT.get(i);
                }
            }
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList authorizedDomainNamesList = authObject.getDomainNameList();
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            List<String> additionalTables = HDTAuditReportAction.getAdditionalAuditTableInfo();
            boolean isAdditionalTableExists = additionalTables.size() > 0;
            System.out.println("Is Additional Tables exists = " + isAdditionalTableExists + "   No.of additionalTables = " + additionalTables.size());
            Criteria crit = HDTAuditReportAction.getCriteria(request, bean, attributeList, rb, search, authorizedDomainNamesList, "ADSMAuditObjs", false, null);
            criteriaList.add(crit);
            if (isAdditionalTableExists) {
                for (int i = 0; i < additionalTables.size(); ++i) {
                    String auditTimeStr = additionalTables.get(i);
                    Long auditTime = Long.parseLong(auditTimeStr);
                    String objsTable = "ADSMAuditObjs_" + auditTimeStr;
                    Criteria crit1 = HDTAuditReportAction.getCriteria(request, bean, attributeList, rb, search, authorizedDomainNamesList, objsTable, true, auditTime);
                    criteriaList.add(crit1);
                }
            }
            if (action != null && action.equalsIgnoreCase("showAll") || action.equalsIgnoreCase("generate")) {
                count = isAdditionalTableExists ? HDTAuditReportAction.getCountFromAllTables(hdtArray, fromTime, toTime, criteriaList, additionalTables) : HDTAuditReportAction.getCount(hdtArray, fromTime, toTime, crit);
            }
            if (count != 0 && count > 0) {
                result = isAdditionalTableExists ? HDTAuditReportAction.getRowsFromAllTables(hdtArray, fromTime, toTime, attributeList, startIndex, range, new Boolean(ascending), sortColumn, criteriaList, additionalTables) : HDTAuditReportAction.getRows(hdtArray, fromTime, toTime, attributeList, startIndex, range, new Boolean(ascending), sortColumn, crit, false, null);
                resultList = (ArrayList)result.get("resultList");
            }
            Hashtable actionList = HDTAuditReportAction.getActionList(hdtArray, fromTime, toTime, attributeList, startIndex, range, new Boolean(ascending), sortColumn, crit, false, null, rb);
            request.setAttribute("nameList", actionList.get("nameList"));
            request.setAttribute("categoryList", actionList.get("categoryList"));
            request.setAttribute("moduleList", actionList.get("moduleList"));
            request.setAttribute("selColList", selColList);
            request.setAttribute("resultList", (Object)resultList);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("htmlNoEscapeListIds", (Object)htmlNoEscapeListIds);
            request.setAttribute("isAdditionalTableExists", (Object)isAdditionalTableExists);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("AuditReport");
    }

    public static Hashtable getActionList(Long[] selectedHDT, long fromTime, long toTime, ArrayList attributeList, int startIndex, int range, boolean ascending, String sortColumn, Criteria criteria, boolean isArchiveTable, Long archiveTime, AdventNetResourceBundle rb) {
        Hashtable<String, ArrayList> actionList = new Hashtable<String, ArrayList>();
        String auditDetailsTable = isArchiveTable ? "ADSMAuditDetails_" + archiveTime : "ADSMAuditDetails";
        Criteria crit = new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)fromTime, 4);
        crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)toTime, 6));
        int hdtLen = selectedHDT.length;
        if (hdtLen > 0) {
            crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"), (Object)selectedHDT, 8));
        }
        actionList.put("nameList", HDTAuditReportAction.getAuditSearchValues(auditDetailsTable, "ACTION_NAME", crit));
        actionList.put("categoryList", HDTAuditReportAction.getAuditSearchValues(auditDetailsTable, "ACTION_CATEGORY", crit));
        actionList.put("moduleList", HDTAuditReportAction.getAuditSearchValues(auditDetailsTable, "MODULE_NAME", crit));
        return actionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getAuditSearchValues(String tableName, String columnName, Criteria crit) {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> duplicateCheck = new ArrayList<String>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"ADSMAuditDetails", (String)columnName).distinct());
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                String keyValue = (String)dataSet.getValue(1);
                String value = rb.getString((String)dataSet.getValue(1));
                if (!duplicateCheck.contains(value)) {
                    nameList.add(keyValue);
                    duplicateCheck.add(value);
                    continue;
                }
                if (nameList.contains(keyValue)) continue;
                int index = nameList.indexOf(value);
                if (!keyValue.contains(".") || index == -1) continue;
                nameList.remove(index);
                nameList.add(keyValue);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return nameList;
    }

    public static Criteria getCriteria(HttpServletRequest request, DynaActionForm bean, ArrayList attributeList, AdventNetResourceBundle rb, String search, ArrayList<String> authorizedDomainNamesList, String objsTable, boolean isArchive, Long archiveTime) {
        HttpSession session = request.getSession();
        Criteria crit = null;
        try {
            Criteria domainCriteria = new Criteria(Column.getColumn((String)objsTable, (String)"OBJECT_DOMAIN"), (Object)authorizedDomainNamesList.toArray(), 8);
            ArrayList o365WaadTenatIdList = O365MgmtHandler.getO365WaadTenantIdList((ADMPAuthObject)((ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT")));
            if (o365WaadTenatIdList != null && o365WaadTenatIdList.size() > 0) {
                domainCriteria = domainCriteria.or(new Criteria(Column.getColumn((String)objsTable, (String)"OBJECT_DOMAIN"), (Object)o365WaadTenatIdList.toArray(), 8));
            }
            if (search.equalsIgnoreCase("true")) {
                crit = AuditUtil.getSearchCriteria(request, bean, attributeList, isArchive, archiveTime, rb);
            }
            crit = crit == null ? domainCriteria : crit.and(domainCriteria);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return crit;
    }

    public static int getCount(Long[] hdtArray, long fromTime, long toTime, Criteria crit) {
        return HDTAuditReportAction.getCount(hdtArray, fromTime, toTime, crit, false, null);
    }

    public static int getCount(Long[] hdt, long fromTime, long toTime, Criteria criteria, boolean isArchiveTable, Long archiveTime) {
        int count = 0;
        try {
            int hdtLen;
            String auditDetailsTable = isArchiveTable ? "ADSMAuditDetails_" + archiveTime : "ADSMAuditDetails";
            String auditObjsTable = isArchiveTable ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)auditDetailsTable));
            Criteria crit = new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)toTime, 6);
            if (fromTime != 0L) {
                crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)fromTime, 4));
            }
            if ((hdtLen = hdt.length) > 0) {
                crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"), (Object)hdt, 8));
            }
            if (criteria != null) {
                crit = crit.and(criteria);
            }
            Join join = new Join(Table.getTable((String)auditDetailsTable), Table.getTable((String)auditObjsTable), new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            sq.addJoin(join);
            sq.setCriteria(crit);
            Integer tempCount = DBUtil.getCount((SelectQuery)sq);
            if (tempCount != null) {
                count = tempCount;
            }
            System.out.println("count ::" + count);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public static Integer getCountFromAllTables(Long[] hdt, long fromTime, long toTime, ArrayList criteriaList, List<String> additionalTables) {
        Integer totalCount = 0;
        try {
            Criteria criteria = (Criteria)criteriaList.get(0);
            String auditDetailsTable = "ADSMAuditDetails";
            String auditObjsTable = "ADSMAuditObjs";
            SelectQuery sq = HDTAuditReportAction.getSelectQuery(auditDetailsTable, auditObjsTable, hdt, fromTime, toTime, criteria);
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            Integer count = DBUtil.getCount((SelectQuery)sq);
            totalCount = count != null ? count : 0;
            for (int k = 0; k < additionalTables.size(); ++k) {
                Criteria finalCrit = (Criteria)criteriaList.get(k + 1);
                String auditTime = additionalTables.get(k);
                String detailsTable = "ADSMAuditDetails_" + auditTime;
                String objsTable = "ADSMAuditObjs_" + auditTime;
                SelectQuery selQuery = HDTAuditReportAction.getSelectQuery(detailsTable, objsTable, hdt, fromTime, toTime, finalCrit);
                selQuery.addSelectColumn(col);
                count = DBUtil.getCount((SelectQuery)selQuery);
                totalCount = count != null ? totalCount + count : totalCount;
            }
            System.out.println("count from all tables ::" + totalCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return totalCount;
    }

    private static SelectQuery getSelectQuery(String auditDetailsTable, String auditObjsTable, Long[] hdt, long fromTime, long toTime, Criteria criteria) {
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)auditDetailsTable));
        Criteria crit = new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)fromTime, 4);
        crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)toTime, 6));
        int hdtLen = hdt.length;
        if (hdtLen > 0) {
            crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"), (Object)hdt, 8));
        }
        if (criteria != null) {
            crit = crit.and(criteria);
        }
        Join join = new Join(Table.getTable((String)auditDetailsTable), Table.getTable((String)auditObjsTable), new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
        sq.setCriteria(crit);
        sq.addJoin(join);
        return sq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAdditionalAuditTableInfo() {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList<String> addlAuditList = new ArrayList<String>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMAuditMetaTable", (String)"IS_ARCHIVED"), (Object)false, 0);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMAuditMetaTable"));
            sq.setCriteria(crit);
            Column timeColumn = Column.getColumn((String)"ADSMAuditMetaTable", (String)"TIME").distinct();
            sq.addSelectColumn(timeColumn);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Long time = (Long)dataSet.getValue(1);
                addlAuditList.add(time.toString());
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return addlAuditList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable getRowsFromAllTables(Long[] selectedHDT, long fromTime, long toTime, ArrayList attributeList, int startIndex, int range, boolean ascending, String sortColumn, ArrayList criteriaList, List<String> additionalTables) {
        Hashtable result = new Hashtable();
        ArrayList resultList = new ArrayList();
        Connection connection = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            Criteria criteria = (Criteria)criteriaList.get(0);
            String auditDetailsTable = "ADSMAuditDetails";
            String auditObjsTable = "ADSMAuditObjs";
            SelectQuery sq = HDTAuditReportAction.getSelectQuery(auditDetailsTable, auditObjsTable, selectedHDT, fromTime, toTime, criteria);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Column column;
                Properties attributeProperties = (Properties)attributeList.get(i);
                String table = attributeProperties.getProperty("TABLE_NAME");
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                int attribId = (Integer)attributeProperties.get("ATTRIB_ID");
                if (attribId == 11146) {
                    column = Column.getColumn((String)table, (String)columnName, (String)"TIME");
                    selectColumnList.add(column);
                    continue;
                }
                column = Column.getColumn((String)table, (String)columnName);
                selectColumnList.add(column);
            }
            selectColumnList.add(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"));
            sq.addSelectColumns(selectColumnList);
            ArrayList<String> queryList = new ArrayList<String>();
            queryList.add(RelationalAPI.getInstance().getSelectSQL((Query)sq));
            int k = 0;
            while (true) {
                SelectQuery selQuery;
                String detailsTable;
                String auditTime;
                if (k < additionalTables.size()) {
                    Criteria finalCrit = (Criteria)criteriaList.get(k + 1);
                    auditTime = additionalTables.get(k);
                    detailsTable = "ADSMAuditDetails_" + auditTime;
                    String objsTable = "ADSMAuditObjs_" + auditTime;
                    selQuery = HDTAuditReportAction.getSelectQuery(detailsTable, objsTable, selectedHDT, fromTime, toTime, finalCrit);
                    selectColumnList = new ArrayList();
                } else {
                    QueryGenerator queryGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
                    String queryString = queryGen.getUnionQuery(startIndex, range, "TIME", true, queryList, true);
                    RelationalAPI relationalAPI = RelationalAPI.getInstance();
                    connection = relationalAPI.getConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(queryString);
                    Object columnList = null;
                    while (rs.next()) {
                        Hashtable resultHash = new Hashtable();
                        HDTAuditReportAction.fillResultHash(rs, resultHash, attributeList);
                        resultList.add(resultHash);
                    }
                    result.put("resultList", resultList);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    DBUtil.closeStmtAndConnection((Statement)stmt, (Connection)connection);
                    return result;
                }
                for (int i = 0; i < attributeList.size(); ++i) {
                    Column column;
                    Properties attributeProperties = (Properties)attributeList.get(i);
                    String table = attributeProperties.getProperty("TABLE_NAME") + "_" + auditTime;
                    String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                    int attribId = (Integer)attributeProperties.get("ATTRIB_ID");
                    if (attribId == 11146) {
                        column = Column.getColumn((String)table, (String)columnName, (String)"TIME");
                        selectColumnList.add(column);
                        continue;
                    }
                    column = Column.getColumn((String)table, (String)columnName);
                    selectColumnList.add(column);
                }
                selectColumnList.add(Column.getColumn((String)detailsTable, (String)"LOGIN_ID"));
                selQuery.addSelectColumns(selectColumnList);
                queryList.add(RelationalAPI.getInstance().getSelectSQL((Query)selQuery));
                ++k;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return result;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            DBUtil.closeStmtAndConnection(stmt, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getRows(Long[] selectedHDT, long fromTime, long toTime, ArrayList attributeList, int startIndex, int range, boolean ascending, String sortColumn, Criteria criteria, boolean isArchiveTable, Long archiveTime) {
        Hashtable result = new Hashtable();
        ArrayList resultList = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String auditDetailsTable = isArchiveTable ? "ADSMAuditDetails_" + archiveTime : "ADSMAuditDetails";
            String auditObjsTable = isArchiveTable ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)auditDetailsTable));
            Criteria crit = new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)fromTime, 4);
            crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)toTime, 6));
            int hdtLen = selectedHDT.length;
            if (hdtLen > 0) {
                crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"), (Object)selectedHDT, 8));
            }
            if (criteria != null) {
                crit = crit.and(criteria);
            }
            Join join = new Join(Table.getTable((String)auditDetailsTable), Table.getTable((String)auditObjsTable), new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
            sq.setCriteria(crit);
            sq.addJoin(join);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String table = isArchiveTable ? attributeProperties.getProperty("TABLE_NAME") + "_" + archiveTime : attributeProperties.getProperty("TABLE_NAME");
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Column column = Column.getColumn((String)table, (String)columnName);
                if (sortColumn != null && sortColumn.equals(columnName)) {
                    sq.addSortColumn(new SortColumn(Column.getColumn((String)table, (String)sortColumn), ascending));
                }
                selectColumnList.add(column);
            }
            selectColumnList.add(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"));
            sq.addSelectColumns(selectColumnList);
            if (startIndex != -1) {
                sq.setRange(new Range(startIndex, range));
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            Object columnList = null;
            while (dataSet.next()) {
                Hashtable resultHash = new Hashtable();
                HDTAuditReportAction.fillResultHash(dataSet, resultHash, attributeList);
                resultList.add(resultHash);
            }
            result.put("resultList", resultList);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return result;
    }

    public ActionForward setObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaActionForm bean = (DynaActionForm)session.getAttribute(beanName);
            ArrayList<Long> trusteesList = (ArrayList<Long>)bean.get("selectedHDT");
            String techIds = request.getParameter("techIds");
            String[] selectedObjects = techIds.split(";;;");
            if (trusteesList == null) {
                trusteesList = new ArrayList<Long>();
            }
            for (int i = 0; selectedObjects != null && i < selectedObjects.length; ++i) {
                Long selectObj = Long.parseLong(selectedObjects[i].trim());
                if (trusteesList.contains(selectObj)) continue;
                trusteesList.add(selectObj);
            }
            bean.set("selectedHDT", trusteesList);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward removeObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaActionForm bean = (DynaActionForm)session.getAttribute(beanName);
            ArrayList trusteesList = (ArrayList)bean.get("selectedHDT");
            if (trusteesList != null && trusteesList.size() >= 0) {
                String indexValue = request.getParameter("index");
                if (indexValue != null) {
                    int index = Integer.parseInt(indexValue);
                    if (index >= trusteesList.size()) {
                        trusteesList.clear();
                    }
                    trusteesList.remove(index);
                }
                bean.set("selectedHDT", (Object)trusteesList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AuditTask listener = null;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        DynaActionForm bean = (DynaActionForm)form;
        rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Long cvId = ColumnConfiguration.getCVId((String)"Audit", (long)loginId);
            if (cvId == null) {
                cvId = ColumnConfiguration.getDefaultCvId((String)"Audit");
            }
            ArrayList viewColumnList = ColumnConfiguration.getViewColumnList((long)cvId);
            Iterator itr = viewColumnList.iterator();
            ArrayList<Integer> selColList = new ArrayList<Integer>();
            DataObject reportsDO = ReportAttributeHandler.getInstance().getViewColumnDO(new Integer(7003), loginId);
            while (itr.hasNext()) {
                HashMap details = (HashMap)itr.next();
                Criteria cri = new Criteria(new Column("ADSMAttributeDetails", "TABLE_NAME"), (Object)((String)details.get("TABLE_NAME")), 0);
                Row attrRow = reportsDO.getRow("ADSMAttributeDetails", cri = cri.and(new Criteria(new Column("ADSMAttributeDetails", "ATTRIB_COLUMN_NAME"), (Object)((String)details.get("COLUMN_NAME")), 0)));
                if (attrRow == null) continue;
                selColList.add((Integer)attrRow.get("ATTRIB_ID"));
            }
            Integer HDT_AUDIT_REPORT_ID = 7003;
            DataObject obj = ReportHandler.getReportDetails((Integer)new Integer(HDT_AUDIT_REPORT_ID));
            Row r = obj.getFirstRow("ADSMReports");
            String className = (String)r.get("CLASS_NAME");
            Class<?> classToInvoke = Class.forName(className.trim());
            listener = (AuditTask)classToInvoke.newInstance();
            String format = request.getParameter("format");
            ArrayList techList = (ArrayList)bean.get("selectedHDT");
            String search = request.getParameter("search");
            String searchString = (String)bean.get("searchString");
            if (search == null || search.equalsIgnoreCase("")) {
                search = "false";
            }
            String archiveName = request.getParameter("archiveName");
            Long archiveTime = null;
            boolean fetchArchiveData = false;
            if (archiveName != null) {
                archiveTime = MetaTableHandler.getMetaTableTime((String)archiveName);
                fetchArchiveData = true;
            }
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(new Integer(7003), loginId);
            Criteria searchCrit = null;
            if (search.equalsIgnoreCase("true")) {
                bean.set("searchString", (Object)searchString);
                searchCrit = AuditUtil.getSearchCriteria(request, bean, attributelist, fetchArchiveData, archiveTime, rb);
            } else {
                bean.set("searchString", (Object)"");
            }
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList authorizedDomainNamesList = authObject.getDomainNameList();
            String auditObjsTable = fetchArchiveData ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            Criteria crit = new Criteria(Column.getColumn((String)auditObjsTable, (String)"OBJECT_DOMAIN"), (Object)authorizedDomainNamesList.toArray(), 8);
            ArrayList o365WaadTenatIdList = O365MgmtHandler.getO365WaadTenantIdList((ADMPAuthObject)((ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT")));
            if (o365WaadTenatIdList != null && o365WaadTenatIdList.size() > 0) {
                Criteria criteria = crit;
                crit = new Criteria(Column.getColumn((String)auditObjsTable, (String)"OBJECT_DOMAIN"), (Object)o365WaadTenatIdList.toArray(), 8);
                crit = criteria.or(crit);
            }
            if (searchCrit != null) {
                crit = crit.and(searchCrit);
            }
            String ascending = (String)bean.get("isAscending");
            String sortColumn = (String)bean.get("sortColumn");
            if (sortColumn == null || sortColumn.equals("")) {
                sortColumn = "AUDIT_TIME";
            }
            long currentTime = System.currentTimeMillis();
            long fromTime = 0L;
            long toTime = currentTime;
            String period = (String)bean.get("period");
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (period.equalsIgnoreCase("") && !fetchArchiveData) {
                Long periodDiff = 2592000000L;
                fromTime = currentTime - periodDiff;
            } else if (period.equalsIgnoreCase("customPeriod")) {
                String startDate = (String)bean.get("startDate");
                String toDate = (String)bean.get("endDate");
                fromTime = startDate != null ? sdf.parse(startDate).getTime() : cal.getTime().getTime();
                toTime = toDate != null ? sdf.parse(toDate).getTime() : cal.getTime().getTime();
                toTime += 86400000L;
            } else if (!fetchArchiveData) {
                String periodMills = (String)bean.get("period");
                long periodMillsec = Long.valueOf(periodMills);
                fromTime = currentTime - periodMillsec;
            }
            listener.exportReport(null, null, "FILES", format, techList, loginId, fromTime, toTime, response, request, ascending, sortColumn, crit, rb, null, null, null, fetchArchiveData, archiveTime, selColList);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.action_name.audit_reports", (String)((String)r.get("REPORT_NAME")), (Integer)HDT_AUDIT_REPORT_ID, (String)"-", (Boolean)Boolean.FALSE, (String)HDTAuditReportListener.getExportFileName(), (String)format.substring(0, format.indexOf("_")), (String)"-", (Integer)HDTAuditReportListener.getExportRowCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void init(DynaActionForm bean) {
        bean.set("selectedHDT", new ArrayList());
        bean.set("startDate", null);
        bean.set("endDate", null);
        bean.set("period", null);
        bean.set("sortColumn", (Object)"");
        bean.set("isAscending", (Object)"");
    }

    private static void fillResultHash(DataSet dataSet, Hashtable resultHash, ArrayList attributeList) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                Object obj = null;
                if (dataSet.getValue(columnName) == null) continue;
                obj = dataSet.getValue(columnName);
                if (attributeId == 11151 && (obj.toString().equalsIgnoreCase(" ") || obj.toString().equalsIgnoreCase(""))) {
                    obj = rb.getString(WorkFlowUtil.getFullName((Long)((Long)dataSet.getValue("LOGIN_ID"))));
                }
                resultHash.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fillResultHash(ResultSet rs, Hashtable resultHash, ArrayList attributeList) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                Object obj = null;
                obj = attributeId == 11146 ? rs.getObject("TIME") : rs.getObject(columnName);
                if (obj == null) continue;
                if (attributeId == 11151 && (obj.toString().equalsIgnoreCase(" ") || obj.toString().equalsIgnoreCase(""))) {
                    obj = rb.getString(WorkFlowUtil.getFullName((Long)rs.getLong("LOGIN_ID")));
                    resultHash.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                    continue;
                }
                if (attributeId == 11149 && obj instanceof Clob) {
                    Clob clob = (Clob)obj;
                    long pos = 1L;
                    String status = clob.getSubString(pos, (int)clob.length());
                    resultHash.put(attributeId, status);
                    continue;
                }
                resultHash.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isPropertiesAvailableForAuditRow(Long objectId, Long loginId, boolean isAdditionalTableExists, Long auditTime) {
        Long archiveTime = 0L;
        boolean returnValue = false;
        HashMap props = HDTAuditReportAction.getProperties(objectId, loginId, false, 0L, auditTime, isAdditionalTableExists);
        returnValue = !props.isEmpty();
        return returnValue;
    }

    public static boolean isWorkFlowPropsForAuditRow(Long objectId, Long loginId, boolean isAdditionalTableExists, Long auditTime) {
        String moduleName;
        Hashtable details;
        Long archiveTime = 0L;
        boolean returnValue = false;
        boolean fetchArchiveData = false;
        if (isAdditionalTableExists) {
            archiveTime = MetaTableHandler.getTempTableTime((Long)auditTime);
            fetchArchiveData = true;
        }
        Long requestId = (details = HDTAuditReportAction.checkCreateAction(objectId, fetchArchiveData, archiveTime)).containsKey("REQUEST_ID") ? (Long)details.get("REQUEST_ID") : 0L;
        String string = moduleName = details.containsKey("MODULE_NAME") ? (String)details.get("MODULE_NAME") : null;
        if (requestId != null && requestId != 0L && moduleName != null && !moduleName.equals("ManageEngine ServiceDesk Plus")) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean isPropertiesAvailable(Long objectId, Long loginId, boolean fetchArchiveData, Long archiveTime) {
        boolean returnValue = false;
        HashMap props = HDTAuditReportAction.getProperties(objectId, loginId, fetchArchiveData, archiveTime, null, false);
        returnValue = !props.isEmpty();
        return returnValue;
    }

    public static HashMap getProperties(Long objectId, Long loginId, boolean fetchArchiveData, Long archiveTime, Long auditTime, boolean isAdditionalTableExists) {
        return HDTAuditReportAction.getProperties(objectId, loginId, fetchArchiveData, archiveTime, auditTime, isAdditionalTableExists, rb);
    }

    public static HashMap getProperties(Long objectId, Long loginId, boolean fetchArchiveData, Long archiveTime, Long auditTime, boolean isAdditionalTableExists, AdventNetResourceBundle rb) {
        Hashtable details;
        HashMap props = new HashMap();
        Long userIndex = null;
        Long auditId = null;
        Long folderId = null;
        if (isAdditionalTableExists) {
            archiveTime = MetaTableHandler.getTempTableTime((Long)auditTime);
            fetchArchiveData = true;
        }
        if ((details = HDTAuditReportAction.checkCreateAction(objectId, fetchArchiveData, archiveTime)) != null) {
            userIndex = (Long)details.get("USER_INDEX");
            auditId = (Long)details.get("AUDIT_ID");
            folderId = (Long)details.get("FOLDER_INDEX");
        }
        props = userIndex != null ? (details.get("TEMPLATE_CATEGORY_ID") != null ? (((String)details.get("MODULE_NAME")).equalsIgnoreCase("WORKFLOW") ? FcExecuteFormFlow.getSingleObjPropsForAudit((Long)details.get("TEMPLATE_CATEGORY_ID"), userIndex, (String)details.get("OBJECT_DOMAIN"), loginId, rb, false, null) : FcExecuteFormFlow.getSingleObjPropsForAudit((Long)details.get("TEMPLATE_CATEGORY_ID"), userIndex, (String)details.get("OBJECT_DOMAIN"), loginId, rb, fetchArchiveData, archiveTime)) : AuditUtil.getUserProps(userIndex, auditId, fetchArchiveData, archiveTime, rb)) : (folderId != null ? (((Boolean)details.get("IS_WORKFLOW_MODE")).booleanValue() ? FileServerMgmtUtil.getWFModificationResults(folderId, (AdventNetResourceBundle)rb) : FileServerMgmtUtil.getModificationResults((Long)folderId, (AdventNetResourceBundle)rb, (Boolean)true, (boolean)fetchArchiveData, (Long)archiveTime)) : AuditUtil.getMgmtProps(objectId, rb, loginId, fetchArchiveData, archiveTime));
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable checkCreateAction(Long objectId, boolean fetchArchiveData, Long archiveTime) {
        Hashtable<String, Object> details = new Hashtable<String, Object>();
        Connection connection = null;
        DataSet dataSet = null;
        boolean hasRequestIdColumn = false;
        try {
            String detailsTable = fetchArchiveData ? "ADSMAuditDetails_" + archiveTime : "ADSMAuditDetails";
            String objsTable = fetchArchiveData ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)detailsTable);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)detailsTable));
            sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"REPORT_ID"));
            sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"AUDIT_ID"));
            sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"MODULE_NAME"));
            if (tableDef.hasColumn("REQUEST_ID")) {
                hasRequestIdColumn = true;
                sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"REQUEST_ID"));
            }
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"USER_INDEX"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"OBJECT_DOMAIN"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"TEMPLATE_CATEGORY_ID"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"FOLDER_INDEX"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"IS_WORKFLOW_MODE"));
            Criteria crit = null;
            Join join = new Join(Table.getTable((String)detailsTable), Table.getTable((String)objsTable), new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
            if (objectId != null) {
                crit = new Criteria(Column.getColumn((String)objsTable, (String)"OBJECT_ID"), (Object)objectId, 0);
            }
            sq.addJoin(join);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                String moduleName;
                Boolean isWorkFlow;
                String reportId = dataSet.getValue("REPORT_ID").toString();
                if (reportId != null) {
                    details.put("REPORT_ID", new Integer(reportId));
                }
                String domainName = dataSet.getValue("OBJECT_DOMAIN").toString();
                if (reportId != null) {
                    details.put("OBJECT_DOMAIN", domainName);
                }
                for (int i = 0; i < creationIds.length; ++i) {
                    if (!creationIds[i].equals(reportId)) continue;
                    details.put("USER_INDEX", (Long)dataSet.getValue("USER_INDEX"));
                    details.put("AUDIT_ID", (Long)dataSet.getValue("AUDIT_ID"));
                    if (dataSet.getValue("TEMPLATE_CATEGORY_ID") == null) continue;
                    details.put("TEMPLATE_CATEGORY_ID", (Long)dataSet.getValue("TEMPLATE_CATEGORY_ID"));
                }
                Long folderIndex = (Long)dataSet.getValue("FOLDER_INDEX");
                if (folderIndex != null) {
                    details.put("FOLDER_INDEX", folderIndex);
                }
                if ((isWorkFlow = (Boolean)dataSet.getValue("IS_WORKFLOW_MODE")) != null) {
                    details.put("IS_WORKFLOW_MODE", isWorkFlow);
                }
                if ((moduleName = (String)dataSet.getValue("MODULE_NAME")) != null) {
                    details.put("MODULE_NAME", moduleName);
                }
                Long requestId = null;
                if (hasRequestIdColumn) {
                    requestId = (Long)dataSet.getValue("REQUEST_ID");
                }
                if (requestId == null) continue;
                details.put("REQUEST_ID", requestId);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return details;
    }

    public ActionForward viewArchivedAudits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        DynaActionForm bean = (DynaActionForm)form;
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String isNavigate;
            Boolean isMounted;
            int count = 0;
            long fromTime = 0L;
            long toTime = 0L;
            Hashtable result = new Hashtable();
            ArrayList resultList = new ArrayList();
            String action = request.getParameter("action");
            String search = request.getParameter("search");
            String searchString = (String)bean.get("searchString");
            String init = request.getParameter("init");
            String archiveName = request.getParameter("archiveName");
            if (init != null && init.equalsIgnoreCase("true")) {
                bean.set("FROM_INDEX", (Object)"");
            }
            int startIndex = 1;
            int range = 25;
            if (action == null || action.equalsIgnoreCase("")) {
                action = "showAll";
                this.init(bean);
                bean.initialize(mapping);
            }
            if (search == null || search.equalsIgnoreCase("")) {
                search = "false";
            }
            DataObject mountedArchiveDO = HDTAuditReportAction.getMountedArchiveDO();
            boolean loadArchive = false;
            Hashtable archiveDetails = HDTAuditReportAction.getMountedArchiveDetails(mountedArchiveDO);
            if (action.equalsIgnoreCase("generate") && archiveName != null && !archiveName.equalsIgnoreCase((String)archiveDetails.get("ARCHIVE_NAME")) && !(isMounted = (Boolean)(archiveDetails = HDTAuditReportAction.getArchiveDetails(archiveName)).get("IS_MOUNTED")).booleanValue()) {
                loadArchive = true;
            }
            archiveName = (String)archiveDetails.get("ARCHIVE_NAME");
            Long archiveId = (Long)archiveDetails.get("ARCHIVE_ID");
            Long archiveTime = MetaTableHandler.getMetaTableTime((String)archiveName);
            String filePath = (String)archiveDetails.get("BACKUP_DIRECTORY");
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(new Integer(7003), loginId);
            Criteria crit = null;
            Criteria searchCrit = null;
            if (search.equalsIgnoreCase("true") && archiveTime != null) {
                bean.set("searchString", (Object)searchString);
                searchCrit = AuditUtil.getSearchCriteria(request, bean, attributelist, true, archiveTime, rb);
                if (request.getParameter("FROM_INDEX") != null && request.getParameter("RANGE") != null) {
                    bean.set("FROM_INDEX", (Object)request.getParameter("FROM_INDEX"));
                }
            } else {
                bean.set("searchString", (Object)"");
            }
            String startIndexStr = request.getParameter("FROM_INDEX");
            String rangeStr = request.getParameter("RANGE");
            String ascending = (String)bean.get("isAscending");
            String sortColumn = (String)bean.get("sortColumn");
            if (sortColumn == null || sortColumn.equals("")) {
                sortColumn = "AUDIT_TIME";
            }
            if (startIndexStr != null && !startIndexStr.equals("")) {
                startIndex = new Integer(startIndexStr);
            }
            if (rangeStr != null) {
                range = Integer.parseInt(rangeStr);
            }
            if ((isNavigate = request.getParameter("isNavigate")) != null && isNavigate.equals("false")) {
                NavigateRangeUtil.setDefaultRange((String)"AuditReport", (int)range, (Long)loginId);
            } else if (isNavigate == null) {
                range = NavigateRangeUtil.getDefaultRange((String)"AuditReport", (Long)loginId);
                bean.set("RANGE", (Object)String.valueOf(range));
            }
            if (ascending == null) {
                ascending = "false";
            }
            ArrayList selectedHDT = (ArrayList)bean.get("selectedHDT");
            String period = (String)bean.get("period");
            long currentTime = System.currentTimeMillis();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (period.equalsIgnoreCase("")) {
                fromTime = 0L;
                toTime = currentTime;
            } else if (period.equalsIgnoreCase("customPeriod")) {
                String startDate = (String)bean.get("startDate");
                String toDate = (String)bean.get("endDate");
                fromTime = startDate != null ? sdf.parse(startDate).getTime() : cal.getTime().getTime();
                toTime = toDate != null ? sdf.parse(toDate).getTime() : cal.getTime().getTime();
                toTime += 86400000L;
            } else {
                String periodMills = (String)bean.get("period");
                long periodMillsec = Long.valueOf(periodMills);
                fromTime = currentTime - periodMillsec;
                toTime = currentTime;
            }
            int hdtLen = selectedHDT.size();
            Long[] hdtArray = new Long[hdtLen];
            if (hdtLen > 0) {
                for (int i = 0; i < hdtLen; ++i) {
                    hdtArray[i] = (Long)selectedHDT.get(i);
                }
            }
            if (archiveTime != null) {
                String auditObjsTable = "ADSMAuditObjs_" + archiveTime;
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                ArrayList authorizedDomainNamesList = authObject.getDomainNameList();
                crit = new Criteria(Column.getColumn((String)auditObjsTable, (String)"OBJECT_DOMAIN"), (Object)authorizedDomainNamesList.toArray(), 8);
                ArrayList o365WaadTenatIdList = O365MgmtHandler.getO365WaadTenantIdList((ADMPAuthObject)((ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT")));
                if (o365WaadTenatIdList != null && o365WaadTenatIdList.size() > 0) {
                    Criteria criteria = crit;
                    crit = new Criteria(Column.getColumn((String)auditObjsTable, (String)"OBJECT_DOMAIN"), (Object)o365WaadTenatIdList.toArray(), 8);
                    crit = criteria.or(crit);
                }
                if (searchCrit != null) {
                    crit = crit.and(searchCrit);
                }
                if (loadArchive && filePath != null) {
                    MetaTableHandler.unZipAndLoadArchiveFile((String)archiveName, (Long)((Long)archiveDetails.get("ARCHIVE_ID")), (Long)archiveTime, (String)filePath);
                }
            }
            if (action != null && action.equalsIgnoreCase("showAll") && archiveTime != null || action.equalsIgnoreCase("generate")) {
                count = HDTAuditReportAction.getCount(hdtArray, fromTime, toTime, crit, true, archiveTime);
            }
            if (count != 0 && count > 0) {
                result = HDTAuditReportAction.getRows(hdtArray, fromTime, toTime, attributelist, startIndex, range, new Boolean(ascending), sortColumn, crit, true, archiveTime);
                resultList = (ArrayList)result.get("resultList");
            }
            request.setAttribute("archiveName", (Object)archiveName);
            request.setAttribute("archiveTime", (Object)archiveTime);
            if (archiveId != null) {
                request.setAttribute("archiveId", (Object)archiveId.toString());
            }
            request.setAttribute("resultList", resultList);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("htmlNoEscapeListIds", (Object)htmlNoEscapeListIds);
            Hashtable actionList = HDTAuditReportAction.getActionList(hdtArray, fromTime, toTime, attributelist, startIndex, range, new Boolean(ascending), sortColumn, crit, false, null, rb);
            request.setAttribute("nameList", actionList.get("nameList"));
            request.setAttribute("categoryList", actionList.get("categoryList"));
            request.setAttribute("moduleList", actionList.get("moduleList"));
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("errorMessage", (Object)rb.getString("admp.deleg.hdt_deleg.hdt_reports.text.error_occurred_importing_archive_file_file_not_exist_or_access_denied"));
        }
        return mapping.findForward("ArchivedAuditReport");
    }

    private static Hashtable getArchiveDetails(String archiveName) throws Exception {
        Hashtable<String, Object> archiveDetails = new Hashtable<String, Object>();
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMAuditArchive", (String)"ARCHIVE_NAME"), (Object)archiveName, 0);
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAuditArchive", crit);
        if (!dataObj.isEmpty()) {
            Row row = dataObj.getFirstRow("ADSMAuditArchive");
            List colNameList = row.getColumns();
            for (String colName : colNameList) {
                archiveDetails.put(colName, row.get(colName));
            }
        }
        return archiveDetails;
    }

    private static DataObject getMountedArchiveDO() throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMAuditArchive", (String)"IS_MOUNTED"), (Object)true, 0);
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAuditArchive", crit);
        if (!dataObj.isEmpty()) {
            return dataObj;
        }
        return null;
    }

    private static Hashtable getMountedArchiveDetails(DataObject dataObj) throws Exception {
        Hashtable<String, Object> archiveDetails = new Hashtable<String, Object>();
        if (dataObj != null) {
            Row row = dataObj.getFirstRow("ADSMAuditArchive");
            List colNameList = row.getColumns();
            for (String colName : colNameList) {
                archiveDetails.put(colName, row.get(colName));
            }
        }
        return archiveDetails;
    }

    public ActionForward saveArchiveInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String archiveInterval = request.getParameter("archiveInterval");
            String archiveLocation = request.getParameter("archiveLocation");
            String deleteInterval = request.getParameter("deleteInterval");
            ADSMPersUtil.updateSyMParameter((String)"AUDIT_ARCHIVE_INTERVAL", (String)archiveInterval);
            ADSMPersUtil.updateSyMParameter((String)"ARCHIVE_LOCATION", (String)archiveLocation);
            ADSMPersUtil.updateSyMParameter((String)"ARCHIVE_RETENTION_PERIOD", (String)deleteInterval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getArchiveSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObj = new JSONObject();
        try {
            String deleteInterval;
            String archiveLocation;
            String archiveInterval = ADSMPersUtil.getSyMParameter((String)"AUDIT_ARCHIVE_INTERVAL");
            if (archiveInterval == null || archiveInterval.equals("")) {
                archiveInterval = "90";
            }
            if ((archiveLocation = ADSMPersUtil.getSyMParameter((String)"ARCHIVE_LOCATION")) == null || archiveLocation.equals("")) {
                String basePath = new File(System.getProperty("server.home")).getAbsolutePath();
                basePath = basePath.lastIndexOf("bin") != -1 ? basePath.substring(0, basePath.lastIndexOf("bin")) : basePath.substring(0, basePath.lastIndexOf("webapps"));
                archiveLocation = basePath + "archive";
            }
            if ((deleteInterval = ADSMPersUtil.getSyMParameter((String)"ARCHIVE_RETENTION_PERIOD")) == null || deleteInterval.equals("")) {
                deleteInterval = "8";
            }
            jsonObj.put("archiveInterval", (Object)archiveInterval);
            jsonObj.put("archiveLocation", (Object)archiveLocation);
            jsonObj.put("deleteInterval", (Object)deleteInterval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }
}

