/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.audit;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.zoho.framework.utils.crypto.EnDecryptImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class HDTAuditSchedulerUtil {
    static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    static String[] creationIds = new String[]{"6001", "6002", "2006", "3001", "5004"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getRowsForAuditReport(Long[] selectedHDT, long fromTime, long toTime, ArrayList attributeList, int startIndex, int range, boolean ascending, String sortColumn, Criteria criteria, Long loginId, ArrayList object_ids, AdventNetResourceBundle rb, boolean fetchArchiveData, Long archiveTime) {
        HDTAuditSchedulerUtil.rb = rb;
        Hashtable result = new Hashtable();
        ArrayList resultList = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String auditDetailsTable = fetchArchiveData ? "ADSMAuditDetails_" + archiveTime : "ADSMAuditDetails";
            String auditObjsTable = fetchArchiveData ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)auditDetailsTable));
            Criteria crit = new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)fromTime, 4);
            crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), (Object)toTime, 6));
            int hdtLen = selectedHDT.length;
            if (hdtLen > 0) {
                crit = crit.and(new Criteria(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"), (Object)selectedHDT, 8));
            }
            if (criteria != null) {
                crit = crit.and(criteria);
            }
            Join join = new Join(Table.getTable((String)auditDetailsTable), Table.getTable((String)auditObjsTable), new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
            sq.setCriteria(crit);
            sq.addJoin(join);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String table = fetchArchiveData ? attributeProperties.getProperty("TABLE_NAME") + "_" + archiveTime : attributeProperties.getProperty("TABLE_NAME");
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Column column = Column.getColumn((String)table, (String)columnName);
                if (sortColumn != null && sortColumn.equals(columnName)) {
                    sq.addSortColumn(new SortColumn(Column.getColumn((String)table, (String)sortColumn), ascending));
                }
                selectColumnList.add(column);
            }
            if (sq.getSortColumns().isEmpty()) {
                sq.addSortColumn(new SortColumn(Column.getColumn((String)auditDetailsTable, (String)"AUDIT_TIME"), ascending));
            }
            selectColumnList.add(Column.getColumn((String)auditDetailsTable, (String)"LOGIN_ID"));
            sq.addSelectColumns(selectColumnList);
            if (startIndex != -1) {
                sq.setRange(new Range(startIndex, range));
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            Object columnList = null;
            while (dataSet.next()) {
                Hashtable resultHash = new Hashtable();
                HDTAuditSchedulerUtil.fillResultHashForAuditReport(dataSet, resultHash, attributeList, loginId, object_ids, rb);
                resultList.add(resultHash);
            }
            result.put("resultList", resultList);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return result;
    }

    private static void fillResultHashForAuditReport(DataSet dataSet, Hashtable resultHash, ArrayList attributeList, Long loginId, ArrayList objectIdList, AdventNetResourceBundle rb) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                Object obj = null;
                if (dataSet.getValue(columnName) == null) continue;
                obj = dataSet.getValue(columnName);
                if (attributeId == 11151 && (obj.toString().equalsIgnoreCase(" ") || obj.toString().equalsIgnoreCase(""))) {
                    obj = rb.getString(WorkFlowUtil.getFullName((Long)((Long)dataSet.getValue("LOGIN_ID"))));
                } else if (attributeId == 11149) {
                    String str = obj.toString();
                    str = str.replaceAll("\\<.*?>", "");
                    obj = str;
                } else if (attributeId == 11147) {
                    if (obj.toString().contains(":BACKSLASH:")) {
                        obj = ClientUtil.scriptEscape(obj.toString());
                    }
                } else if (attributeId == 11150) {
                    objectIdList.add(obj);
                }
                resultHash.put(attributeId, rb.getString(ListenerUtil.getUICustomizedValues(attributeId, obj)));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Hashtable getProperties(ArrayList<Long> objectIds, Long loginId, AdventNetResourceBundle rb, Hashtable resultList) {
        return HDTAuditSchedulerUtil.getProperties(objectIds, loginId, rb, resultList, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getProperties(ArrayList<Long> objectIds, Long loginId, AdventNetResourceBundle rb, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime) {
        HDTAuditSchedulerUtil.rb = rb;
        Long[] listObjId = new Long[objectIds.size()];
        listObjId = objectIds.toArray(listObjId);
        HashMap props = new HashMap();
        Long userIndex = null;
        Object auditId = null;
        Hashtable layoutDetailsHash = new Hashtable();
        Hashtable layoutWFDetailsHash = new Hashtable();
        ArrayList<Long> mgmtObjectsList = new ArrayList<Long>();
        Hashtable userDetailsHash = new Hashtable();
        ArrayList objectIdList = new ArrayList();
        Hashtable<Long, Long> wfRequestvsObjectIdHash = new Hashtable<Long, Long>();
        Hashtable<Long, Long> fsmDetailsHash = new Hashtable<Long, Long>();
        Hashtable<Long, Long> fsmWFDetailsHash = new Hashtable<Long, Long>();
        Hashtable<Long, String> objectIdVsName = new Hashtable<Long, String>();
        DataSet dataSet = null;
        RelationalAPI relAPI = RelationalAPI.getInstance();
        Connection connection = null;
        try {
            connection = relAPI.getConnection();
            boolean hasRequestColumn = false;
            dataSet = HDTAuditSchedulerUtil.checkCreateAction(listObjId, connection, fetchArchiveData, archiveTime);
            String detailsTable = fetchArchiveData ? "ADSMAuditDetails_" + archiveTime : "ADSMAuditDetails";
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)detailsTable);
            if (tableDef.hasColumn("REQUEST_ID")) {
                hasRequestColumn = true;
            }
            while (dataSet.next()) {
                Long folderIndex;
                Hashtable<String, Object> details = new Hashtable<String, Object>();
                if (hasRequestColumn && dataSet.getValue("REQUEST_ID") != null && (Long)dataSet.getValue("REQUEST_ID") != 0L) {
                    wfRequestvsObjectIdHash.put((Long)dataSet.getValue("OBJECT_ID"), (Long)dataSet.getValue("REQUEST_ID"));
                }
                details.put("OBJECT_ID", (Long)dataSet.getValue("OBJECT_ID"));
                objectIdVsName.put((Long)dataSet.getValue("OBJECT_ID"), dataSet.getValue("OBJECT_NAME").toString());
                String reportId = dataSet.getValue("REPORT_ID").toString();
                if (reportId != null) {
                    details.put("REPORT_ID", new Integer(reportId));
                }
                String domainName = dataSet.getValue("OBJECT_DOMAIN").toString();
                if (reportId != null) {
                    details.put("OBJECT_DOMAIN", domainName);
                }
                if ((folderIndex = (Long)dataSet.getValue("FOLDER_INDEX")) != null) {
                    details.put("FOLDER_INDEX", folderIndex);
                }
                Boolean isWorkFlowMode = (Boolean)dataSet.getValue("IS_WORKFLOW_MODE");
                String module = (String)dataSet.getValue("MODULE_NAME");
                for (int i = 0; i < creationIds.length; ++i) {
                    if (!creationIds[i].equals(reportId)) continue;
                    details.put("USER_INDEX", (Long)dataSet.getValue("USER_INDEX"));
                    details.put("AUDIT_ID", (Long)dataSet.getValue("AUDIT_ID"));
                    if (dataSet.getValue("TEMPLATE_CATEGORY_ID") == null) continue;
                    details.put("TEMPLATE_CATEGORY_ID", (Long)dataSet.getValue("TEMPLATE_CATEGORY_ID"));
                }
                if (details != null) {
                    userIndex = (Long)details.get("USER_INDEX");
                }
                if (userIndex != null) {
                    if (details.get("TEMPLATE_CATEGORY_ID") != null) {
                        if (module.equalsIgnoreCase("WORKFLOW")) {
                            layoutWFDetailsHash.put((Long)details.get("OBJECT_ID"), details);
                            continue;
                        }
                        layoutDetailsHash.put((Long)details.get("OBJECT_ID"), details);
                        continue;
                    }
                    userDetailsHash.put((Long)details.get("OBJECT_ID"), details);
                    continue;
                }
                if (folderIndex != null) {
                    if (isWorkFlowMode.booleanValue()) {
                        fsmWFDetailsHash.put((Long)details.get("OBJECT_ID"), folderIndex);
                        continue;
                    }
                    fsmDetailsHash.put((Long)details.get("OBJECT_ID"), folderIndex);
                    continue;
                }
                mgmtObjectsList.add((Long)details.get("OBJECT_ID"));
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
        ArrayList<String> columnNameList = null;
        ArrayList<String> displayNameList = null;
        ArrayList<String> ldapNameList = null;
        if (viewColumnList != null) {
            columnNameList = new ArrayList<String>();
            displayNameList = new ArrayList<String>();
            ldapNameList = new ArrayList<String>();
            for (Object obj : viewColumnList) {
                Map map;
                if (obj instanceof HashMap) {
                    map = (HashMap)obj;
                    columnNameList.add(((HashMap)map).get("COL_NAME").toString());
                    if (((HashMap)map).get("LDAP_NAME") != null) {
                        ldapNameList.add(((HashMap)map).get("LDAP_NAME").toString());
                        continue;
                    }
                    displayNameList.add(((HashMap)map).get("COLUMN_NAME").toString());
                    continue;
                }
                map = (Hashtable)obj;
                columnNameList.add(((Hashtable)map).get("ATTRIB_COLUMN_NAME").toString());
                if (((Hashtable)map).get("ATTRIB_LDAP_NAME") != null) {
                    ldapNameList.add(((Hashtable)map).get("ATTRIB_LDAP_NAME").toString());
                    continue;
                }
                displayNameList.add(((Hashtable)map).get("ATTRIB_DISP_NAME").toString());
            }
        }
        Hashtable resultHashTable = FcExecuteFormFlow.getMultipleObjPropsForAudit(layoutDetailsHash, loginId, rb, columnNameList, fetchArchiveData, archiveTime);
        resultHashTable.putAll(FcExecuteFormFlow.getMultipleObjPropsForAudit(layoutWFDetailsHash, loginId, rb, columnNameList, false, null));
        resultHashTable.putAll(HDTAuditSchedulerUtil.getMgmtProps(mgmtObjectsList, rb, loginId, resultList, objectIdVsName, displayNameList, ldapNameList, fetchArchiveData, archiveTime));
        resultHashTable.putAll(FileServerMgmtUtil.getModificationResultForAuditExport(fsmDetailsHash, (AdventNetResourceBundle)rb, (boolean)fetchArchiveData, (Long)archiveTime));
        resultHashTable.putAll(FileServerMgmtUtil.getWFModificationResultForAuditExport(fsmWFDetailsHash, (AdventNetResourceBundle)rb));
        resultHashTable.putAll(HDTAuditSchedulerUtil.getUserProps(userDetailsHash, rb, loginId, resultList, columnNameList, fetchArchiveData, archiveTime));
        resultHashTable.put("reqIdVsObjIdMapping", wfRequestvsObjectIdHash);
        ArrayList reqIdList = new ArrayList(wfRequestvsObjectIdHash.values());
        resultHashTable.put("requestorDetails", WorkFlowUtil.getRequestsDetails(reqIdList, (Long)loginId, (AdventNetResourceBundle)rb));
        resultHashTable.put("wfDetails", WorkFlowUtil.getRequestWorkFlowDetails(reqIdList, (Long)loginId, (AdventNetResourceBundle)rb));
        return resultHashTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getMgmtProps(ArrayList objectIdList, AdventNetResourceBundle rb, Long loginId, Hashtable resultList, Hashtable<Long, String> objectIdVsName, ArrayList displayNameList, ArrayList ldapNameList, boolean fetchArchiveData, Long archiveTime) {
        Connection connection = null;
        DataSet dataSet = null;
        Long[] objIds = new Long[objectIdList.size()];
        objIds = objectIdList.toArray(objIds);
        Hashtable detailsHashTable = new Hashtable();
        for (int i = 0; i < objIds.length; ++i) {
            detailsHashTable.put(objIds[i], new ArrayList());
        }
        try {
            String objsTable = fetchArchiveData ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            String propsTable = fetchArchiveData ? "ADSMAuditObjProps_" + archiveTime : "ADSMAuditObjProps";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)objsTable));
            sq.addSelectColumn(Column.getColumn((String)propsTable, (String)"PROP_LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"OBJECT_ID"));
            sq.addSelectColumn(Column.getColumn((String)propsTable, (String)"PROP_VALUE"));
            sq.addSelectColumn(Column.getColumn((String)propsTable, (String)"PROP_DISP_NAME"));
            Criteria crit = null;
            if (objIds != null) {
                crit = new Criteria(Column.getColumn((String)objsTable, (String)"OBJECT_ID"), (Object)objIds, 8);
            }
            Join join = new Join(Table.getTable((String)objsTable), Table.getTable((String)propsTable), new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2);
            sq.addJoin(join);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                String ldapName = (String)dataSet.getValue("PROP_LDAP_NAME");
                String dispName = (String)dataSet.getValue("PROP_DISP_NAME");
                Long objid = (Long)dataSet.getValue("OBJECT_ID");
                String propValue = (String)dataSet.getValue("PROP_VALUE");
                ArrayList objHashMap = (ArrayList)detailsHashTable.get(objid);
                if (!(displayNameList == null && ldapNameList == null || displayNameList != null && displayNameList.contains(dispName)) && (ldapNameList == null || !ldapNameList.contains(ldapName))) continue;
                if (ldapName.equalsIgnoreCase("accountExpires")) {
                    propValue = !propValue.equals("0") ? DateTimeUtil.getAccountExpiresDateFromFileTime((Long)Long.parseLong(propValue), (AdventNetResourceBundle)rb, (Long)loginId) : rb.getString("admp.reports.user.account_exp_date.never_expires");
                    propValue = ClientUtil.getLocalizedString(rb, propValue);
                } else if (ldapName.equalsIgnoreCase("pwdLastSet")) {
                    propValue = DateTimeUtil.getDaysSincePasswordSetForAudi((String)propValue);
                    propValue = ClientUtil.getLocalizedString(rb, propValue);
                } else if (ldapName.equalsIgnoreCase("memberOf") || ldapName.equalsIgnoreCase("members")) {
                    boolean flag = false;
                    for (int i = 0; i < objHashMap.size(); ++i) {
                        if (!((Hashtable)objHashMap.get(i)).get("AttrName").equals("memberOf")) continue;
                        Hashtable tmp = (Hashtable)objHashMap.get(i);
                        tmp.put("AttrValue", tmp.get("AttrValue") + ", [" + propValue + "]");
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    propValue = "[" + propValue + "]";
                } else if (ldapName.equalsIgnoreCase("userWorkstations")) {
                    if (propValue.equalsIgnoreCase("") || propValue == null) {
                        propValue = rb.getString("admp.mgmt.user_mgmt.user_workstats.input.allow_all_computers");
                    }
                } else if (ldapName.equalsIgnoreCase("password")) {
                    EnDecryptImpl enDecrypt = new EnDecryptImpl();
                    propValue = enDecrypt.decrypt(propValue);
                    if (PasswordUtil.getShowPasswordValue()) {
                        propValue = propValue.replaceAll(".", "*");
                    }
                } else {
                    propValue = ClientUtil.getLocalizedString(rb, propValue);
                }
                int i = 0;
                if (propValue.length() > 1000) {
                    while (i + 1000 < propValue.length()) {
                        Integer index = propValue.indexOf(32, i + 1000);
                        if (index.equals(-1) || index + 500 > propValue.length()) {
                            index = propValue.length();
                        }
                        String value = propValue.substring(i, index);
                        Hashtable<String, String> row = new Hashtable<String, String>();
                        row.put("AttrName", ldapName);
                        row.put("AttrValue", value);
                        objHashMap.add(row);
                        i = index;
                    }
                }
                if (i >= propValue.length()) continue;
                Hashtable<String, String> row = new Hashtable<String, String>();
                row.put("AttrName", ldapName);
                row.put("AttrValue", propValue.substring(i, propValue.length()));
                objHashMap.add(row);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return detailsHashTable;
    }

    private static DataSet checkCreateAction(Long[] listObjId, Connection connection, boolean fetchArchiveData, Long archiveTime) {
        DataSet dataSet = null;
        try {
            String detailsTable = fetchArchiveData ? "ADSMAuditDetails_" + archiveTime : "ADSMAuditDetails";
            String objsTable = fetchArchiveData ? "ADSMAuditObjs_" + archiveTime : "ADSMAuditObjs";
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)detailsTable);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)detailsTable));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"OBJECT_ID"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"OBJECT_NAME"));
            sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"REPORT_ID"));
            sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"AUDIT_ID"));
            if (tableDef.hasColumn("REQUEST_ID")) {
                sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"REQUEST_ID"));
            }
            sq.addSelectColumn(Column.getColumn((String)detailsTable, (String)"MODULE_NAME"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"USER_INDEX"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"FOLDER_INDEX"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"IS_WORKFLOW_MODE"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"OBJECT_DOMAIN"));
            sq.addSelectColumn(Column.getColumn((String)objsTable, (String)"TEMPLATE_CATEGORY_ID"));
            Criteria crit = null;
            Join join = new Join(Table.getTable((String)detailsTable), Table.getTable((String)objsTable), new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
            if (listObjId != null) {
                crit = new Criteria(Column.getColumn((String)objsTable, (String)"OBJECT_ID"), (Object)listObjId, 8);
            }
            sq.addJoin(join);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            dataSet = relAPI.executeQuery((Query)sq, connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getUserProps(Hashtable detailsTable, AdventNetResourceBundle rb, Long auditId, Hashtable resultList, ArrayList columnNameList, boolean fetchArchiveData, Long archiveTime) {
        Serializable key;
        ArrayList userProperties = null;
        Connection connection = null;
        DataSet dataSet = null;
        SelectQueryImpl sq = null;
        ArrayList<Long> userIndexVals = new ArrayList<Long>();
        ArrayList<Long> auditIdVals = new ArrayList<Long>();
        ArrayList<Long> objectIdVals = new ArrayList<Long>();
        Hashtable<Long, Long> objToUserindex = new Hashtable<Long, Long>();
        Hashtable objToResult = new Hashtable();
        Iterator i$ = detailsTable.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry ent;
            Map.Entry entry = ent = i$.next();
            key = (Long)entry.getKey();
            Hashtable value = (Hashtable)entry.getValue();
            if (value.get("USER_INDEX") == null) continue;
            userIndexVals.add((Long)value.get("USER_INDEX"));
            auditIdVals.add((Long)value.get("AUDIT_ID"));
            objToUserindex.put((Long)value.get("USER_INDEX"), (Long)value.get("OBJECT_ID"));
            objectIdVals.add((Long)value.get("OBJECT_ID"));
        }
        Long[] userIndexArr = new Long[userIndexVals.size()];
        userIndexArr = userIndexVals.toArray(userIndexArr);
        Long[] objectIdArr = new Long[objectIdVals.size()];
        objectIdArr = objectIdVals.toArray(objectIdArr);
        for (int i = 0; i < objectIdArr.length; ++i) {
            objToResult.put(objectIdArr[i], new ArrayList());
        }
        try {
            ArrayList attributeList = HDTAuditSchedulerUtil.getAttributeDetails(auditIdVals, fetchArchiveData, archiveTime);
            if (attributeList.isEmpty()) {
                key = objToResult;
                return key;
            }
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            ArrayList<String> tableNameList = new ArrayList<String>();
            HashMap<String, String> multipleTableNameList = new HashMap<String, String>();
            String baseTable = fetchArchiveData ? "ADSMAUNamingAttributes_" + archiveTime : "ADSMAUNamingAttributes";
            Criteria crit = new Criteria(Column.getColumn((String)baseTable, (String)"USER_INDEX"), (Object)userIndexArr, 8);
            Column columnTmp = Column.getColumn((String)baseTable, (String)"USER_INDEX");
            selectColumnList.add(columnTmp);
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProps = (Properties)attributeList.get(i);
                String tableName = fetchArchiveData ? attributeProps.getProperty("AU_TABLE_NAME") + "_" + archiveTime : attributeProps.getProperty("AU_TABLE_NAME");
                String columnName = attributeProps.getProperty("ATTRIB_COLUMN_NAME");
                if (columnNameList != null && !columnNameList.contains(columnName)) continue;
                Integer relationalType = (Integer)attributeProps.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(1))) {
                    if (multipleTableNameList.containsKey(tableName)) continue;
                    multipleTableNameList.put(tableName, columnName);
                    continue;
                }
                sq = new SelectQueryImpl(Table.getTable((String)tableName));
                Column column = Column.getColumn((String)tableName, (String)columnName);
                selectColumnList.add(column);
                if (tableNameList.contains(tableName)) continue;
                tableNameList.add(tableName);
            }
            sq.addSelectColumns(selectColumnList);
            sq.setCriteria(crit);
            for (int j = 0; tableNameList != null && tableNameList.size() > 1 && j < tableNameList.size(); ++j) {
                String joinTable = (String)tableNameList.get(j);
                if (tableNameList.contains(baseTable) && baseTable.equals(joinTable)) continue;
                Join join = new Join(baseTable, joinTable, new String[]{"USER_CREATION_ID"}, new String[]{"USER_CREATION_ID"}, 2);
                sq.addJoin(join);
            }
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery(sq, connection);
            Hashtable multValues = HDTAuditSchedulerUtil.getMultValues(multipleTableNameList, userIndexArr);
            while (dataSet.next()) {
                userProperties = (ArrayList)objToResult.get((Long)objToUserindex.get(dataSet.getValue("USER_INDEX")));
                String samAccountName = "";
                String fullName = "";
                for (int i = 0; i < attributeList.size(); ++i) {
                    Properties props = (Properties)attributeList.get(i);
                    String displayName = props.getProperty("ATTRIB_DISP_NAME");
                    String columnName = props.getProperty("ATTRIB_COLUMN_NAME");
                    if (columnNameList != null && !columnNameList.contains(columnName)) continue;
                    String mulTable = fetchArchiveData ? props.getProperty("AU_TABLE_NAME") + "_" + archiveTime : props.getProperty("AU_TABLE_NAME");
                    displayName = rb.getString(displayName);
                    Integer relType = (Integer)props.get("RELATIONAL_TYPE");
                    String value = "";
                    if (relType.equals(new Integer(1))) {
                        value = (String)((HashMap)multValues.get(columnName)).get((Long)dataSet.getValue("USER_INDEX"));
                    } else if (columnName.equalsIgnoreCase("PREVENT_DELETION")) {
                        value = String.valueOf(dataSet.getValue(columnName));
                    } else {
                        value = (String)dataSet.getValue(columnName);
                        if (columnName.equalsIgnoreCase("Password") && PasswordUtil.getShowPasswordValue()) {
                            value = value.replaceAll(".", "*");
                        }
                    }
                    if (value == null || value.equals("")) continue;
                    Hashtable<String, String> row = new Hashtable<String, String>();
                    row.put("AttrName", displayName);
                    row.put("AttrValue", value);
                    userProperties.add(row);
                }
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return objToResult;
    }

    private static Hashtable getMultValues(HashMap multipleTableNameList, Long[] userIndexArr) {
        Hashtable multValues = new Hashtable();
        Iterator i$ = multipleTableNameList.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry ent;
            Map.Entry entry = ent = i$.next();
            String tableName = (String)entry.getKey();
            String colName = (String)entry.getValue();
            try {
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)colName));
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)"USER_INDEX"));
                sq.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"USER_INDEX"), (Object)userIndexArr, 8));
                DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                Iterator it = dob.getRows(tableName);
                HashMap<Long, String> indexToVal = new HashMap<Long, String>();
                multValues.put(colName, indexToVal);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    String value = (String)row.get(colName);
                    Long useridx = (Long)row.get("USER_INDEX");
                    if (value.equalsIgnoreCase("")) continue;
                    if (indexToVal.containsKey(useridx)) {
                        String tmp = (String)indexToVal.get(useridx);
                        if (tmp == null) {
                            tmp = "";
                        }
                        indexToVal.put(useridx, tmp + ", [" + value + "]");
                        continue;
                    }
                    value = "[" + value + "] ";
                    indexToVal.put(useridx, value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return multValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getAttributeDetails(ArrayList<Long> auditIdVals, boolean isArchive, Long archiveTime) {
        Long[] auditIdArr = new Long[auditIdVals.size()];
        auditIdArr = auditIdVals.toArray(auditIdArr);
        ArrayList<Properties> attributeList = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMAttributeDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME").maximum();
            column.setColumnAlias("ATTRIB_DISP_NAME");
            sq.addSelectColumn(column);
            column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME").maximum();
            column.setColumnAlias("ATTRIB_COLUMN_NAME");
            sq.addSelectColumn(column);
            column = Column.getColumn((String)"ADSMAttributeDetails", (String)"AU_TABLE_NAME").maximum();
            column.setColumnAlias("AU_TABLE_NAME");
            sq.addSelectColumn(column);
            column = Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE").maximum();
            column.setColumnAlias("RELATIONAL_TYPE");
            sq.addSelectColumn(column);
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), true));
            String auditAttribsTable = isArchive ? "ADSMAuditAttribs_" + archiveTime : "ADSMAuditAttribs";
            Criteria criteria = new Criteria(Column.getColumn((String)auditAttribsTable, (String)"AUDIT_ID"), (Object)auditIdArr, 8);
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)auditAttribsTable);
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            sq.setCriteria(criteria);
            ArrayList<Column> groupList = new ArrayList<Column>();
            groupList.add(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            GroupByClause gr = new GroupByClause(groupList);
            sq.setGroupByClause(gr);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", dataSet.getValue("ATTRIB_ID"));
                prop.put("ATTRIB_DISP_NAME", dataSet.getValue("ATTRIB_DISP_NAME"));
                prop.put("ATTRIB_COLUMN_NAME", dataSet.getValue("ATTRIB_COLUMN_NAME"));
                prop.put("AU_TABLE_NAME", dataSet.getValue("AU_TABLE_NAME"));
                prop.put("RELATIONAL_TYPE", dataSet.getValue("RELATIONAL_TYPE"));
                attributeList.add(prop);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getRowsForNotification(Long[] objectIds, ArrayList attributeList, Boolean ascending, Long loginId, ArrayList<Long> objectIdList, AdventNetResourceBundle rb) {
        HDTAuditSchedulerUtil.rb = rb;
        Hashtable result = new Hashtable();
        ArrayList resultList = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMAuditDetails"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMAuditObjs", (String)"OBJECT_ID"), (Object)objectIds, 8);
            Join join = new Join(Table.getTable((String)"ADSMAuditDetails"), Table.getTable((String)"ADSMAuditObjs"), new String[]{"AUDIT_ID"}, new String[]{"AUDIT_ID"}, 2);
            sq.setCriteria(crit);
            sq.addJoin(join);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String table = attributeProperties.getProperty("TABLE_NAME");
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Column column = Column.getColumn((String)table, (String)columnName);
                selectColumnList.add(column);
            }
            if (sq.getSortColumns().isEmpty()) {
                sq.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMAuditDetails", (String)"AUDIT_TIME"), ascending.booleanValue()));
            }
            selectColumnList.add(Column.getColumn((String)"ADSMAuditDetails", (String)"LOGIN_ID"));
            sq.addSelectColumns(selectColumnList);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            Object columnList = null;
            while (dataSet.next()) {
                Hashtable resultHash = new Hashtable();
                HDTAuditSchedulerUtil.fillResultHashForAuditReport(dataSet, resultHash, attributeList, loginId, objectIdList, rb);
                resultList.add(resultHash);
            }
            result.put("resultList", resultList);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return result;
    }
}

