/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.audit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.AuditSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerInputsHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class HDTSchedulerAction
extends DispatchAction {
    public static AdventNetResourceBundle rb = null;

    public ActionForward schedulerCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "viewScheduler";
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        DynaActionForm bean = (DynaActionForm)form;
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String operation = request.getParameter("operation");
            String init = request.getParameter("init");
            Long taskId = SchedulerUtil.getTaskID((String)"HDTAuditReports");
            if (init != null && init.equalsIgnoreCase("true")) {
                bean.set("action", null);
                forwardPage = "viewScheduler";
            }
            String action = (String)bean.get("action");
            if (operation == null) {
                bean.initialize(mapping);
                HDTSchedulerAction.init(loginId, bean, rb);
            }
            int day = 0;
            int date = 0;
            int hours = 0;
            int minutes = 0;
            JSONObject time = new JSONObject();
            JSONArray timeArray = new JSONArray();
            Hashtable<String, Object> customProp = new Hashtable<String, Object>();
            String scheduleType = (String)bean.get("repSchedule");
            if (scheduleType != null) {
                if (scheduleType.equalsIgnoreCase("daily")) {
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    timeArray.put(hours);
                    timeArray.put(minutes);
                    time.put("client.reports.SchedulerAction.daily", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("weekly")) {
                    String[] weekDays = new String[]{"", "admp.common.days.sunday", "admp.common.days.monday", "admp.common.days.tuesday", "admp.common.days.wednesday", "admp.common.days.thursday", "admp.common.days.friday", "admp.common.days.saturday"};
                    day = (Integer)bean.get("weeklysel1");
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    timeArray.put((Object)weekDays[day]);
                    timeArray.put(hours);
                    timeArray.put(minutes);
                    time.put("client.reports.SchedulerAction.weekly_on", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("monthly")) {
                    date = (Integer)bean.get("monthsel1");
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    timeArray.put(date);
                    timeArray.put(hours);
                    timeArray.put(minutes);
                    time.put("client.reports.SchedulerAction.monthly_on", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("hourly")) {
                    hours = (Integer)bean.get("dailysel1");
                    timeArray.put(hours);
                    time.put("client.reports.SchedulerAction.for_each", (Object)timeArray);
                } else if (scheduleType.equalsIgnoreCase("Custom")) {
                    hours = (Integer)bean.get("dailysel1");
                    minutes = (Integer)bean.get("dailysel2");
                    String startingDate = (String)bean.get("startingDate");
                    String freqType = (String)bean.get("frequency");
                    String repType = (String)bean.get("repeatType");
                    if (freqType.equals("repnone")) {
                        repType = freqType;
                    }
                    int repInterval = (Integer)bean.get("repeatInterval");
                    String monthdaydate = (String)bean.get("monthdaydate");
                    if (monthdaydate.equalsIgnoreCase("date")) {
                        customProp.put("dayofmonth", bean.get("monthsel2"));
                    } else {
                        customProp.put("weekofmonth", bean.get("weekofmonth"));
                        customProp.put("dayofweek", bean.get("weeklysel2"));
                    }
                    customProp.put("monthdaydate", monthdaydate);
                    customProp.put("repType", repType);
                    customProp.put("skipFrequency", repInterval);
                    customProp.put("selectedDays", bean.get("selectedDayValues"));
                    customProp.put("selectedMonths", bean.get("selectedMonthValues"));
                    customProp.put("startingDate", startingDate);
                    time = SchedulerInputsUtil.getTimeString(repType, repInterval, startingDate, hours, minutes, (String)bean.get("selectedDayValues"), monthdaydate, (Integer)bean.get("monthsel2"), (Integer)bean.get("weekofmonth"), (Integer)bean.get("weeklysel2"), (String)bean.get("selectedMonthValues"), rb);
                }
                bean.set("timeDesc", (Object)time.toString());
            }
            Object mailType = null;
            String attachment_type = (String)bean.get("enableAttach");
            attachment_type = attachment_type != null && attachment_type.equalsIgnoreCase("link") ? "LINK" : (String)bean.get("mailType");
            bean.set("mailType", (Object)attachment_type);
            if (action != null) {
                Object scheduleId;
                if (action.equalsIgnoreCase("Create")) {
                    if (operation != null && operation.equalsIgnoreCase("save")) {
                        if (!CommonUtil.isAdmpTechAvailable()) {
                            request.setAttribute("Status", (Object)MessageFormat.format(rb.getString("admp.ad_deleg.license_restriction_module_message"), rb.getString(LicenseUtil.HIGHER_VERSION), rb.getString("admp.reports.schedule_reports.title.create_schedule")));
                            forwardPage = "createScheduler";
                        } else {
                            String schedulerName = (String)bean.get("schedulerName");
                            if (schedulerName != null && schedulerName.length() > 150) {
                                schedulerName = schedulerName.substring(0, 150);
                            }
                            boolean duplicate = SchedulerInputsUtil.checkForDuplicateScheduler(schedulerName);
                            System.out.println("schedulerName : " + schedulerName + " \t duplicate : " + duplicate);
                            if (!duplicate) {
                                scheduleId = SchedulerHandler.createScheduler((String)schedulerName, (String)scheduleType, (int)hours, (int)minutes, (int)day, (int)date, (String)"HDTAuditReports", customProp);
                                bean.set("scheduleId", (Object)((Long)scheduleId).toString());
                                if ((Long)scheduleId != 0L) {
                                    HDTSchedulerAction.addAuditSchedulerDetails(bean, loginId, rb, false);
                                }
                                request.setAttribute("Status", (Object)rb.getString("client.reports.SchedulerAction.successfully_created_the_scheduler"));
                            } else {
                                request.setAttribute("Status", (Object)rb.getString("admp.reports.scheduled_reports.error_occured_creating_check_scheduler_with_same_name"));
                                forwardPage = "createScheduler";
                            }
                        }
                    } else {
                        bean.initialize(mapping);
                        HDTSchedulerAction.init(loginId, bean, rb);
                        forwardPage = "createScheduler";
                    }
                } else if (action.equalsIgnoreCase("Edit")) {
                    String schedulerName1 = (String)bean.get("schedulerName");
                    String sch_id1 = request.getParameter("scheduleId");
                    if (operation == null) {
                        if (request.getParameter("scheduleId") != null) {
                            bean.set("scheduleId", (Object)request.getParameter("scheduleId"));
                        }
                        String sch_id = (String)bean.get("scheduleId");
                        Long scheduleId2 = Long.parseLong(sch_id);
                        ArrayList schedulerDetails = AuditSchedulerUtil.getSchedulerDetails((Long)scheduleId2);
                        String scheduleTypes = SchedulerUtil.getScheduleType((Long)scheduleId2);
                        HDTSchedulerAction.setScheduleTimeDetails(bean, scheduleTypes, scheduleId2);
                        if (schedulerDetails != null) {
                            for (int i = 0; i < schedulerDetails.size(); ++i) {
                                Hashtable schedulers = (Hashtable)schedulerDetails.get(i);
                                String format = (String)schedulers.get("MAILING_FORMAT");
                                String reportType = null;
                                reportType = format.equalsIgnoreCase("pdf") || format.equalsIgnoreCase("html") ? "summary" : "standard";
                                if (format.contains("_")) {
                                    String[] parts = format.split("_");
                                    format = parts[0];
                                    reportType = parts[1];
                                }
                                bean.set("formats", (Object)format);
                                bean.set("reportView", (Object)reportType);
                                bean.set("schedulerName", (Object)((String)schedulers.get("SCHEDULER_NAME")));
                                bean.set("description", (Object)((String)schedulers.get("DESCRIPTION")));
                                bean.set("FILE_SERVER_PATH", (Object)((String)schedulers.get("FILE_SERVER_PATH")));
                            }
                        }
                        ArrayList selectedHDT = AuditSchedulerUtil.getSchedulerTechnicians((Long)scheduleId2);
                        Hashtable mailSettings = SchedulerUtil.getMailSendingSettings((Long)scheduleId2, (String)"ADSMAuditScheduler");
                        bean.set("selectedHDT", (Object)selectedHDT);
                        bean.set("schedulerDetails", (Object)schedulerDetails);
                        bean.set("mailSettings", (Object)mailSettings);
                        request.setAttribute("schedulerStatus", (Object)"update");
                        forwardPage = "createScheduler";
                    } else if (operation.equalsIgnoreCase("save")) {
                        if (SchedulerUtil.getSchedulerName((long)Long.parseLong(sch_id1)).equalsIgnoreCase(schedulerName1) || !SchedulerInputsUtil.checkForDuplicateScheduler(schedulerName1)) {
                            if (request.getParameter("scheduleId") != null) {
                                bean.set("scheduleId", (Object)request.getParameter("scheduleId"));
                            }
                            scheduleId = (String)bean.get("scheduleId");
                            String schedulerName = (String)bean.get("schedulerName");
                            if (schedulerName != null && schedulerName.length() > 150) {
                                schedulerName = schedulerName.substring(0, 150);
                            }
                            boolean Status = SchedulerHandler.updateScheduler((Long)Long.parseLong((String)scheduleId), (String)schedulerName, (String)scheduleType, (int)hours, (int)minutes, (int)day, (int)date, customProp);
                            HDTSchedulerAction.addAuditSchedulerDetails(bean, loginId, rb, true);
                            if (Status) {
                                request.setAttribute("Status", (Object)rb.getString("client.reports.SchedulerAction.successfully_updated_the_scheduler"));
                            }
                        } else {
                            request.setAttribute("Status", (Object)rb.getString("admp.reports.sched_reports.sch_create.info.scheduler_already_exist"));
                            forwardPage = "createScheduler";
                            ArrayList schedulerDetails = (ArrayList)bean.get("schedulerDetails");
                            Hashtable schedulers = (Hashtable)schedulerDetails.get(0);
                            ArrayList mailIdList = (ArrayList)schedulers.get("MAIL_ADDRESS");
                            mailIdList.clear();
                            mailIdList.add(bean.get("mailIds"));
                            request.setAttribute("schedulerStatus", (Object)"update");
                        }
                    }
                } else if (action.equalsIgnoreCase("Disable")) {
                    SchedulerHandler.enableDisableScheduler((Long)Long.valueOf(request.getParameter("schedule_id")), (Long)taskId, (int)4);
                } else if (action.equalsIgnoreCase("Enable")) {
                    SchedulerHandler.enableDisableScheduler((Long)Long.valueOf(request.getParameter("schedule_id")), (Long)taskId, (int)3);
                } else if (action.equalsIgnoreCase("Delete")) {
                    System.out.println("Delete AuditReport scheduler, schedulerId " + request.getParameter("schedule_id") + " LoginId :: " + loginId);
                    SchedulerHandler.deleteScheduler((Long)Long.valueOf(request.getParameter("schedule_id")), null);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            request.setAttribute("Status", (Object)"Error in Scheduler");
        }
        return mapping.findForward(forwardPage);
    }

    public static void addAuditSchedulerDetails(DynaActionForm bean, Long loginId, AdventNetResourceBundle rb, boolean update) {
        String sch_id = (String)bean.get("scheduleId");
        ArrayList selectedHDT = (ArrayList)bean.get("selectedHDT");
        String timePeriod = (String)bean.get("period");
        try {
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row = new Row("ADSMAuditScheduler");
            row.set("SCHEDULE_ID", (Object)Long.valueOf(sch_id));
            row.set("LOGIN_ID", (Object)loginId);
            String schedulerName = (String)bean.get("schedulerName");
            if (schedulerName != null && schedulerName.length() > 150) {
                schedulerName = schedulerName.substring(0, 150);
            }
            row.set("SCHEDULER_NAME", (Object)schedulerName);
            row.set("DESCRIPTION", bean.get("description"));
            row.set("TIME_PERIOD", (Object)timePeriod);
            row.set("TIME", bean.get("timeDesc"));
            row.set("ATTACHMENT_TYPE", bean.get("mailType"));
            row.set("MAIL_SUBJECT", bean.get("subject"));
            row.set("MAIL_CONTENT", bean.get("mail_Content"));
            row.set("MAILING_FORMAT", (Object)(bean.get("formats") + "_" + bean.get("reportView")));
            row.set("FILE_SERVER_PATH", bean.get("FILE_SERVER_PATH"));
            boolean isCustom = false;
            if (((String)bean.get("repSchedule")).equalsIgnoreCase("Custom")) {
                isCustom = true;
            }
            row.set("CUSTOM_SCHEDULER", (Object)isCustom);
            if (timePeriod.equalsIgnoreCase("customPeriod")) {
                String startDate = (String)bean.get("startDate");
                String endDate = (String)bean.get("endDate");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                row.set("START_DATE", (Object)sdf.parse(startDate).getTime());
                row.set("END_DATE", (Object)sdf.parse(endDate).getTime());
            }
            if (update) {
                Criteria criteria = new Criteria(new Column("ADSMAuditScheduler", "SCHEDULE_ID"), (Object)sch_id, 0);
                dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAuditScheduler", criteria);
                if (!dob.isEmpty()) {
                    Row rowVal = dob.getFirstRow("ADSMAuditScheduler");
                    loginId = (Long)rowVal.get("LOGIN_ID");
                    row.set("LOGIN_ID", (Object)loginId);
                    dob.updateRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dob);
                }
                update = false;
            } else {
                dob.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dob);
            }
            SchedulerInputsHandler.addIDs((String)((String)bean.get("mailIds")), (Long)Long.valueOf(sch_id));
            SchedulerInputsUtil.addHDTforScheduler(Long.valueOf(sch_id), selectedHDT);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void init(Long loginId, DynaActionForm bean, AdventNetResourceBundle rb) {
        try {
            String[] hours = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
            Integer[] hourValues = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
            String[] minutes = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
            Integer[] minuteValues = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
            Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
            String[] dayValues = new String[]{rb.getString("admp.common.days.sunday"), rb.getString("admp.common.days.monday"), rb.getString("admp.common.days.tuesday"), rb.getString("admp.common.days.wednesday"), rb.getString("admp.common.days.thursday"), rb.getString("admp.common.days.friday"), rb.getString("admp.common.days.saturday")};
            String[] date = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"};
            Integer[] dateValues = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
            ArrayList<String> list = new ArrayList<String>(Arrays.asList("PDF", "HTML", "XLSX", "CSV", "XLS"));
            ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(rb.getString("admp.common.export_type.pdf"), rb.getString("admp.common.export_type.html"), rb.getString("admp.common.export_type.xlsx"), rb.getString("admp.common.export_type.csv"), rb.getString("admp.common.export_type.xls")));
            if (!CommonUtil.isIncludeXLSExportOption()) {
                list.remove("XLS");
                list1.remove(rb.getString("admp.common.export_type.xls"));
            }
            String[] formatNames = new String[list.size()];
            formatNames = list.toArray(formatNames);
            String[] displayFormats = new String[list1.size()];
            displayFormats = list1.toArray(displayFormats);
            String[] periodValues = new String[]{"3600000", "7200000", "21600000", "28800000", "43200000", "86400000", "604800000", "2592000000", "7776000000", "customPeriod"};
            String[] periodNames = new String[]{rb.getString("admp.reports.reportinput.last_one_hour"), rb.getString("admp.reports.reportinput.last_two_hour"), rb.getString("admp.reports.reportinput.last_six_hour"), rb.getString("admp.reports.reportinput.last_eight_hour"), rb.getString("admp.reports.reportinput.last_twelve_hour"), rb.getString("admp.reports.reportinput.last_twentyfour_hour"), rb.getString("admp.reports.reportinput.last_seven_days"), rb.getString("admp.reports.reportinput.last_thirty_days"), rb.getString("admp.reports.reportinput.last_ninety_days"), rb.getString("admp.reports.reportinput.custom_period")};
            String[] repeatValues = new String[]{rb.getString("admp.reports.sched_reports.sch_create.input_text.days"), rb.getString("admp.reports.sched_reports.sch_create.input_text.weeks"), rb.getString("admp.reports.sched_reports.sch_create.input_text.months"), rb.getString("admp.reports.sched_reports.sch_create.input_text.years"), rb.getString("admp.reports.sched_reports.sch_create.input_text.minutes")};
            String[] repeats = new String[]{"repdays", "repweeks", "repmonths", "repyears", "repminutes"};
            String[] frequencyType = new String[]{"repnone", "repeat"};
            String[] frequencyValues = new String[]{rb.getString("admp.reports.sched_reports.sch_create.input_text.run_once"), rb.getString("admp.reports.sched_reports.sch_create.input_text.repeat")};
            String[] weekValues = new String[]{rb.getString("admp.reports.sched_reports.sch_create.input_text.first_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.second_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.third_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.fourth_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.last_week")};
            Integer[] weeks = new Integer[]{1, 2, 3, 4, 5};
            bean.set("hours", (Object)hours);
            bean.set("hourValues", (Object)hourValues);
            bean.set("minutes", (Object)minutes);
            bean.set("minuteValues", (Object)minuteValues);
            bean.set("days", (Object)days);
            bean.set("dayValues", (Object)dayValues);
            bean.set("date", (Object)date);
            bean.set("dateValues", (Object)dateValues);
            bean.set("formatNames", (Object)formatNames);
            bean.set("displayFormats", (Object)displayFormats);
            bean.set("selectedHDT", new ArrayList());
            bean.set("periodValues", (Object)periodValues);
            bean.set("periodNames", (Object)periodNames);
            bean.set("repSchedule", (Object)"hourly");
            bean.set("enableAttach", (Object)"");
            bean.set("mailType", (Object)"");
            bean.set("subject", (Object)"");
            bean.set("mail_Content", (Object)"");
            bean.set("weeks", (Object)weeks);
            bean.set("weekValues", (Object)weekValues);
            bean.set("repeats", (Object)repeats);
            bean.set("repeatValues", (Object)repeatValues);
            bean.set("frequencyType", (Object)frequencyType);
            bean.set("frequencyValues", (Object)frequencyValues);
            bean.set("frequency", (Object)"repnone");
            bean.set("repeatType", (Object)"repdays");
            bean.set("selectedMonthValues", (Object)"");
            bean.set("selectedDayValues", (Object)"");
            bean.set("startDate", (Object)"");
            Calendar cal = Calendar.getInstance();
            int currentHour = cal.get(11);
            int currentMinute = cal.get(12);
            if (currentMinute >= 55) {
                currentMinute = 0;
                ++currentHour;
            } else {
                currentMinute = currentMinute - currentMinute % 5 + 5;
            }
            bean.set("dailysel1", (Object)currentHour);
            bean.set("dailysel2", (Object)currentMinute);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setScheduleTimeDetails(DynaActionForm bean, String scheduleType, Long scheduleId) {
        ArrayList timeDetails = SchedulerUtil.getScheduleTimeDetails((String)scheduleType, (Long)scheduleId);
        Hashtable hash = (Hashtable)timeDetails.get(0);
        boolean custom = SchedulerUtil.isCustomScheduler((Long)scheduleId, (String)"ADSMAuditScheduler");
        if (scheduleType.equalsIgnoreCase("hourly")) {
            String UNIT_OF_TIME = (String)hash.get("UNIT_OF_TIME");
            Long TIME_PERIOD = (Long)hash.get("TIME_PERIOD");
            if (custom) {
                bean.set("repeatInterval", (Object)TIME_PERIOD.intValue());
                bean.set("startDate", (Object)((String)hash.get("startDate")));
                bean.set("dailysel1", (Object)((Integer)hash.get("hours")));
                bean.set("dailysel2", (Object)((Integer)hash.get("minutes")));
                bean.set("repeatType", (Object)"repminutes");
                bean.set("frequency", (Object)"repeat");
                bean.set("repSchedule", (Object)"custom");
            } else {
                bean.set("dailysel1", (Object)TIME_PERIOD.intValue());
                bean.set("repSchedule", (Object)"hourly");
            }
        } else {
            Integer startDate = (Integer)hash.get("DATE_OF_MONTH");
            Integer startMonth = (Integer)hash.get("MONTH_OF_YEAR");
            Integer startYear = (Integer)hash.get("YEAR_OF_DECADE");
            Integer skipFrequency = (Integer)hash.get("SKIP_FREQUENCY");
            String executionTime = (String)hash.get("EXECUTION_TIME");
            String hrs = executionTime.substring(0, executionTime.indexOf(58));
            String mns = executionTime.substring(executionTime.indexOf(58) + 1, executionTime.lastIndexOf(58));
            Integer hours = Integer.parseInt(hrs);
            Integer minutes = Integer.parseInt(mns);
            bean.set("dailysel1", (Object)hours);
            bean.set("dailysel2", (Object)minutes);
            if (scheduleType.equalsIgnoreCase("Daily")) {
                if (custom) {
                    bean.set("repeatType", (Object)"repdays");
                    bean.set("frequency", (Object)"repeat");
                } else {
                    bean.set("repSchedule", (Object)"daily");
                }
            } else if (scheduleType.equalsIgnoreCase("Weekly")) {
                if (custom) {
                    int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                    Object[] seldayval = new Integer[daysOfWeek.length];
                    for (int i = 0; i < daysOfWeek.length; ++i) {
                        seldayval[i] = daysOfWeek[i];
                    }
                    String selDayVal = Arrays.toString(seldayval);
                    selDayVal = selDayVal.replaceAll(", ", ",").replace("[", "").replace("]", "");
                    bean.set("selectedDayValues", (Object)selDayVal);
                    bean.set("repeatType", (Object)"repweeks");
                    bean.set("frequency", (Object)"repeat");
                } else {
                    Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
                    Integer DAY_OF_WEEK = (Integer)hash.get("DAY_OF_WEEK");
                    bean.set("weeklysel1", (Object)days[DAY_OF_WEEK - 1]);
                    bean.set("repSchedule", (Object)"weekly");
                }
            } else if (scheduleType.equalsIgnoreCase("Monthly")) {
                Integer DATE_OF_MONTH = (Integer)hash.get("DATE_OF_MONTH");
                if (custom) {
                    startDate = 1;
                    if (DATE_OF_MONTH != -1) {
                        bean.set("monthsel2", (Object)DATE_OF_MONTH);
                        bean.set("monthdaydate", (Object)"date");
                    } else {
                        int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                        Long weekOfMonth = (Long)hash.get("WEEK_OF_MONTH");
                        bean.set("weekofmonth", (Object)weekOfMonth.intValue());
                        bean.set("weeklysel2", (Object)daysOfWeek[0]);
                        bean.set("monthdaydate", (Object)"day");
                    }
                    bean.set("repeatType", (Object)"repmonths");
                    bean.set("frequency", (Object)"repeat");
                } else {
                    bean.set("monthsel1", (Object)DATE_OF_MONTH);
                    bean.set("repSchedule", (Object)"monthly");
                }
            } else if (scheduleType.equalsIgnoreCase("Yearly")) {
                startMonth = 1;
                startDate = 1;
                int[] months = (int[])hash.get("MONTHS");
                Object[] selmonthval = new Integer[months.length];
                for (int i = 0; i < months.length; ++i) {
                    selmonthval[i] = months[i] + 1;
                }
                String selMonthVal = Arrays.toString(selmonthval);
                selMonthVal = selMonthVal.replaceAll(", ", ",").replace("[", "").replace("]", "");
                bean.set("selectedMonthValues", (Object)selMonthVal);
                bean.set("repeatType", (Object)"repyears");
                bean.set("frequency", (Object)"repeat");
                Integer DATE_OF_MONTH = (Integer)hash.get("DATE_OF_MONTH");
                if (DATE_OF_MONTH != -1) {
                    bean.set("monthsel2", (Object)DATE_OF_MONTH);
                    bean.set("monthdaydate", (Object)"date");
                } else {
                    int[] daysOfWeek = (int[])hash.get("DAYS_OF_WEEK");
                    Long weekOfMonth = (Long)hash.get("WEEK_OF_MONTH");
                    bean.set("weekofmonth", (Object)weekOfMonth.intValue());
                    bean.set("weeklysel2", (Object)daysOfWeek[0]);
                    bean.set("monthdaydate", (Object)"day");
                }
            } else if (scheduleType.equalsIgnoreCase("None")) {
                bean.set("frequency", (Object)"repnone");
            }
            if (custom) {
                String dateStr = startYear.toString() + "-" + startMonth.toString() + "-" + startDate.toString();
                bean.set("repeatInterval", (Object)(skipFrequency + 1));
                bean.set("startDate", (Object)dateStr);
                bean.set("repSchedule", (Object)"custom");
            }
        }
    }
}

