/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.automation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.automation.AdmpTask;
import com.adventnet.sym.adsm.common.server.automation.AdmpTaskSet;
import com.adventnet.sym.adsm.common.server.automation.AutomationPolicy;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.automation.AutomationPolicyUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class AutomationPolicyAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(AutomationPolicyAction.class.getName());

    public ActionForward viewAutomationPolicies(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String forwardPage = "viewAutomationPolicy";
        if (!ClientAuthorizationUtil.isAuthorized(request, AutomationConstants.AUTOMATION_POLICY_ACTION_ID).booleanValue()) {
            this.logger.log(Level.INFO, "Authorization Failer to view Mgmt Automation page for the loginId " + loginId);
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward createOrEditMgmtPolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String action = request.getParameter("action");
        String forwardPage = "createNewPolicy";
        AutomationPolicy automationPolicy = null;
        try {
            if (action.equalsIgnoreCase("edit")) {
                Long mgmtPolicyId = Long.valueOf(request.getParameter("mgmtPolicyId"));
                automationPolicy = new AutomationPolicy(mgmtPolicyId, rb);
                request.setAttribute("actionType", (Object)"Edit");
            } else {
                automationPolicy = new AutomationPolicy();
                automationPolicy.setPolicyName(rb.getString("admp.auto.auto_policy.create_policy.text.default_policy_name"));
            }
            request.setAttribute("automationPolicy", (Object)automationPolicy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward resetPolicyTasks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "policyTasks";
        AutomationPolicy automationPolicy = null;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String automationPolicyJSONString = request.getParameter("automationPolicyJson");
            JSONObject mgmtPolicyJson = new JSONObject(automationPolicyJSONString);
            automationPolicy = new AutomationPolicy();
            automationPolicy.updateDomainSpecific(mgmtPolicyJson, rb, loginId);
            request.setAttribute("domainUpdate", (Object)true);
            request.setAttribute("automationPolicy", (Object)automationPolicy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward deletePolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long mgmtPolicyId = Long.valueOf(request.getParameter("mgmtPolicyId"));
        String statusMessage = rb.getString("admp.auto.auto_policy.stat_msg.succssfully_deleted_policy");
        System.out.println("Going to delete the policy " + mgmtPolicyId);
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, AutomationConstants.AUTOMATION_POLICY_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            AutomationPolicyUtil.deletePolicy(mgmtPolicyId);
            System.out.println("Succssfully deleted the policy " + mgmtPolicyId + "  by the hdt " + loginId);
            ClientUtil.setStatusXMLElement(response, "Success", statusMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", e.getMessage());
        }
        return null;
    }

    public ActionForward checkTaskDetailsInPolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long mgmtPolicyId = Long.valueOf(request.getParameter("mgmtPolicyId"));
        try {
            AutomationPolicy automationPolicy = new AutomationPolicy(mgmtPolicyId, rb);
            JSONObject jsonObj = automationPolicy.isTaskAvailable(WorkFlowUtil.OBJECT_ACTION_IDS);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String statusMessage = rb.getString("admp.auto.auto_policy.create_policy.text.policy_successfully_created");
        String status = "Success";
        Long policyId = 0L;
        boolean duplicate = false;
        try {
            String automationPolicyJSONString = request.getParameter("automationPolicyJson");
            JSONObject mgmtPolicyJson = new JSONObject(automationPolicyJSONString);
            AutomationPolicy policy = new AutomationPolicy();
            policy.init(mgmtPolicyJson);
            String action = request.getParameter("action");
            if (action.equalsIgnoreCase("save")) {
                duplicate = AutomationPolicyUtil.checkForDuplicatePolicy(policy.getPolicyName(), rb);
                if (!duplicate) {
                    DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    policy.addMgmtPolicyRow(dataObject, false);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
                } else {
                    statusMessage = rb.getString("admp.auto.auto_policy.create_policy.text.error_occured_creating_check_policy_with_same_name");
                    status = "Error";
                }
            } else {
                policyId = policy.getAutoPolicyId();
                String currentPolicyName = AutomationPolicyUtil.getPolicyName(policyId);
                statusMessage = rb.getString("admp.auto.auto_policy.create_policy.text.policy_successfully_upated");
                duplicate = currentPolicyName.equals(policy.getPolicyName()) ? false : (policy.getPolicyName().equals(rb.getString(currentPolicyName)) ? false : AutomationPolicyUtil.checkForDuplicatePolicy(policy.getPolicyName(), rb));
                this.logger.log(Level.FINE, "Going to update the existing scheduler " + policyId + " :L " + duplicate);
                if (!duplicate) {
                    AutomationPolicyUtil.deletePolicyTasks(policyId);
                    Criteria updateCriteria = new Criteria(new Column("ADSMAutomationPolicy", "AUTO_POLICY_ID"), (Object)policyId, 0);
                    DataObject updateDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAutomationPolicy", updateCriteria);
                    policy.addMgmtPolicyRow(updateDO, true);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(updateDO);
                } else {
                    statusMessage = rb.getString("admp.auto.auto_policy.create_policy.text.error_occured_creating_check_policy_with_same_name");
                    status = "Error";
                }
            }
            ClientUtil.setStatusXMLElement(response, status, statusMessage, new Properties());
        }
        catch (Exception e) {
            e.printStackTrace();
            statusMessage = e.getMessage();
            ClientUtil.setStatusXMLElement(response, "Error", statusMessage, new Properties());
        }
        return null;
    }

    public ActionForward addNewAdmpTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        String forwardPage = "createNewAdmpTask";
        try {
            Long admpTaskSetId = 1L;
            if (request.getParameter("admpTaskSetId") != null) {
                admpTaskSetId = Long.parseLong(request.getParameter("admpTaskSetId"));
            }
            Long adTaskDetailsId = 1L;
            if (request.getParameter("adTaskDetailsId") != null) {
                adTaskDetailsId = Long.parseLong(request.getParameter("adTaskDetailsId"));
            }
            Integer objectCategory = 1;
            if (request.getParameter("subCategoryId") != null) {
                objectCategory = Integer.parseInt(request.getParameter("subCategoryId"));
            }
            AdmpTask admpTask = new AdmpTask();
            admpTask.setTaskSetId(admpTaskSetId);
            admpTask.setAdTaskDetailsId(adTaskDetailsId);
            request.setAttribute("AdmpTask", (Object)admpTask);
            request.setAttribute("subCategoryId", (Object)objectCategory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward addNewAdmpTaskSet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        String forwardPage = "createNewAdmpTaskSet";
        try {
            Long admpTaskSetId = 1L;
            if (request.getParameter("admpTaskSetId") != null) {
                admpTaskSetId = Long.parseLong(request.getParameter("admpTaskSetId"));
            }
            Long adTaskDetailsId = 1L;
            if (request.getParameter("adTaskDetailsId") != null) {
                adTaskDetailsId = Long.parseLong(request.getParameter("adTaskDetailsId"));
            }
            Integer objectCategory = 11;
            if (request.getParameter("subCategoryId") != null) {
                objectCategory = Integer.parseInt(request.getParameter("subCategoryId"));
            }
            String taskSetName = MessageFormat.format(rb.getString("admp.auto.auto_policy.create_policy.text.task_set_name"), admpTaskSetId);
            if (request.getParameter("taskSetName") != null) {
                taskSetName = request.getParameter("taskSetName");
            }
            AdmpTaskSet admpTaskSet = new AdmpTaskSet();
            admpTaskSet.setAdmpTaskSetId(admpTaskSetId);
            admpTaskSet.setTaskSetName(taskSetName);
            AdmpTask admpTask = new AdmpTask();
            admpTask.setAdTaskDetailsId(adTaskDetailsId);
            admpTask.setTaskSetId(admpTaskSetId);
            admpTaskSet.getAdmpTaskList().add(admpTask);
            request.setAttribute("subCategoryId", (Object)objectCategory);
            request.setAttribute("AdmpTaskSet", (Object)admpTaskSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getTaskSetFieldComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String fieldDetailsStr = request.getParameter("fieldDetailsStr");
        Long adTaskDetailsId = new Long(request.getParameter("adTaskDetailsId"));
        String domainName = request.getParameter("domainName");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            JSONObject fieldDetailsJsonObj = new JSONObject(fieldDetailsStr);
            if (fieldDetailsJsonObj.length() > 0) {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                JSONObject componentDetailsObj = AutomationUtil.getComponentDetails((JSONObject)fieldDetailsJsonObj, (String)domainName, (Long)loginId, (AdventNetResourceBundle)rb);
                request.setAttribute("componentDetails", (Object)componentDetailsObj);
                request.setAttribute("adTaskDetailsId", (Object)adTaskDetailsId);
                request.setAttribute("defaultComponentId", (Object)fieldDetailsJsonObj.getLong("componentId"));
                request.setAttribute("domainName", (Object)domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("taskSetFieldValue");
    }
}

