/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.automation;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class AutomationPolicyUtil {
    public static DataObject getMgmtPolicyDetails(Long autoPolicyId) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMAutomationPolicy", (String)"AUTO_POLICY_ID"), (Object)autoPolicyId, 0);
        DataObject dataObj = null;
        try {
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("AutomationPolicy", criteria);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public String getObjectCategory(int objectType) {
        Hashtable<Integer, String> objectIdVsObjectClass = new Hashtable<Integer, String>();
        objectIdVsObjectClass.put(1, "User");
        objectIdVsObjectClass.put(2, "Group");
        objectIdVsObjectClass.put(3, "Computer");
        objectIdVsObjectClass.put(4, "Contact");
        Hashtable<Integer, String> objectIdVsCategory = new Hashtable<Integer, String>();
        objectIdVsCategory.put(1, "User Automation");
        objectIdVsCategory.put(2, "Group Automation");
        objectIdVsCategory.put(3, "Computer Automation");
        objectIdVsCategory.put(4, "Contact Automation");
        String returnString = ClientUtil.getObjectImage((String)objectIdVsObjectClass.get(objectType)) + objectIdVsCategory.get(objectType);
        return "";
    }

    public static String getPolicyName(Long autoPolicyId) {
        String automationPolicyName = null;
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAutomationPolicy", new Criteria(Column.getColumn((String)"ADSMAutomationPolicy", (String)"AUTO_POLICY_ID"), (Object)autoPolicyId, 0));
            Row row = dataObj.getFirstRow("ADSMAutomationPolicy");
            automationPolicyName = (String)row.get("AUTO_POLICY_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return automationPolicyName;
    }

    public static boolean checkForDuplicatePolicy(String givenPolicyName, AdventNetResourceBundle rb) {
        boolean duplicate = false;
        try {
            if (givenPolicyName.equals(rb.getString("admp.auto.auto_policy.text.provisioning_policy")) || givenPolicyName.equals(rb.getString("admp.auto.auto_policy.text.deprovisioning_policy"))) {
                duplicate = true;
            } else {
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAutomationPolicy", new Criteria(Column.getColumn((String)"ADSMAutomationPolicy", (String)"AUTO_POLICY_NAME"), (Object)givenPolicyName, 0));
                if (!dataObj.isEmpty()) {
                    duplicate = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return duplicate;
    }

    public static void deletePolicyTasks(Long autoPolicyId) {
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"ADSMTaskSet", (String)"AUTO_POLICY_ID"), (Object)autoPolicyId, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(cri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<HashMap> getRequestTypes(Integer subCategory) {
        ArrayList<HashMap> requestTypes = new ArrayList<HashMap>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)AutomationConstants.ADSMWorkFlowActions));
            Criteria crit = new Criteria(Column.getColumn((String)AutomationConstants.ADSMWorkFlowActions, (String)"WF_ACTION_ID"), (Object)WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID, 1);
            if (subCategory != null) {
                crit = crit.and(new Criteria(new Column(AutomationConstants.AutomationActions, "SUB_CATEGORY"), (Object)subCategory, 0));
            }
            query.addJoin(new Join(Table.getTable((String)AutomationConstants.ADSMWorkFlowActions), Table.getTable((String)AutomationConstants.AutomationActions), new String[]{"WF_ACTION_ID"}, new String[]{"WF_ACTION_ID"}, 2));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.ADSMWorkFlowActions, (String)"WF_ACTION_ID"));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.ADSMWorkFlowActions, (String)"WF_ACTION_NAME"));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.ADSMWorkFlowActions, (String)"MGMT_ACTION_ID"));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.AutomationActions, (String)"SUB_CATEGORY"));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.AutomationActions, (String)"DISPLAY_PRIORITY"));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.AutomationActions, (String)"COMPONENT_ID"));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.AutomationActions, (String)"IS_DOMAIN_SPECIFIC_FIELD"));
            query.addSelectColumn(Column.getColumn((String)AutomationConstants.AutomationActions, (String)"DOMAIN_SPECIFIC_DP_CLASS"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)AutomationConstants.AutomationActions, (String)"DISPLAY_PRIORITY"), true));
            query.setCriteria(crit);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                HashMap<String, Object> hash = new HashMap<String, Object>();
                for (String columnName : AutomationConstants.AUTOMATION_ACTION_COLUMNS) {
                    hash.put(columnName, dataSet.getValue(columnName));
                }
                requestTypes.add(hash);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return requestTypes;
    }

    public static void deletePolicy(Long policyId) throws Exception {
        Criteria deleteCriteria = new Criteria(Column.getColumn((String)"ADSMAutomationPolicy", (String)"AUTO_POLICY_ID"), (Object)policyId, 0);
        CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria);
    }

    public static void updateTemplateId(Long singleInputId, String value) {
        try {
            Criteria updateCriteria = new Criteria(Column.getColumn((String)"ADSMTaskInputDetails", (String)"TASK_SINGLE_INPUT_ID"), (Object)singleInputId, 0);
            DataObject updateDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMTaskInputDetails", updateCriteria);
            Row objectDetailsRow = updateDO.getRow("ADSMTaskInputDetails");
            objectDetailsRow.set("VALUE", (Object)value);
            updateDO.updateRow(objectDetailsRow);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(updateDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

