/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.computermanagement.ModifyComputerListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ModifyComputersGeneral
extends ModifyComputerListener {
    public ModifyComputersGeneral() {
        this.reportId = new Integer(2002);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1035L})) {
            return this.rb.getString("client.computermanagement.ModifyComputersGeneral.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            ModifyComputerListener listener = (ModifyComputerListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            String sid = this.getValue(result, 3018);
            String dn = this.getValue(result, 3020);
            Hashtable<String, Object> logProps = new Hashtable<String, Object>();
            logProps.put(this.rb.getString("client.computermanagement.domainName"), domainName);
            logProps.put(this.rb.getString("client.computermanagement.computerName"), this.getValue(result, 3001));
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p = new Properties();
                String value = props.getProperty(selectedAttributes[j]);
                if (value.equals("")) {
                    p.put("DW_CONTROL_CODE", new Long(1L));
                }
                if (selectedAttributes[j].equals("MANAGER")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1705L)) continue;
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "managedBy");
                    p.put("ATTRIB_VALUE", value);
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    setAttributeList.add(p);
                    result.put("manager", value);
                    continue;
                }
                if (selectedAttributes[j].equals("desc")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1706L)) continue;
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "description");
                    p.put("ATTRIB_VALUE", value);
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    setAttributeList.add(p);
                    continue;
                }
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1704L)) continue;
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                p.put("ATTRIB_VALUE", value);
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                setAttributeList.add(p);
            }
            logProps.put(this.rb.getString("client.computermanagement.ModifyComputersGeneral.attributeList"), setAttributeList);
            logger.log(Level.INFO, "MODIFY Computer, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("client.computermanagement.ModifyComputersGeneral.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("client.computermanagement.ModifyComputersGeneral.successfully_modified_error"));
                    }
                } else {
                    message.insert(0, this.rb.getString("client.computermanagement.ModifyComputersGeneral.unable_to_modify_the_computer_error"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.ModifyComputersGeneral.unable_to_modify_the_computer") + " " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.ModifyComputersGeneral.unable_to_modify_the_computer") + " " + e.getMessage());
            }
            TechAuditAPI.getInstance().auditComputerModification(loginId, this.rb.getString("admp.mgmt.common.mgmtcategory.modify_gen_attribs"), this.getValue(result, 3001), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        String[] actionValues = new String[]{"desc", "location", "MANAGER"};
        String[] actionLabelsStr = new String[]{"admp.mgmt.comp_mgmt.mod_gen_attribs.input.desc", "admp.mgmt.comp_mgmt.mod_gen_attribs.input.location", "admp.mgmt.comp_mgmt.mod_gen_attribs.input.managed_by"};
        MgmtUtil.setEmptyFieldsMessage(request, bean, actionValues, actionLabelsStr);
    }
}

