/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.computermanagement.ModifyComputerListener;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MgmtActionIdConstants;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class ModifyComputersGroup
extends ModifyComputerListener {
    public ModifyComputersGroup() {
        this.cks = new String[]{"isRemoveFromAllGroup"};
        this.reportId = new Integer(2001);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{MgmtActionIdConstants.MODIFY_COMPUTER_GROUP_ATTRIBUTES})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuilder message = new StringBuilder();
        String status = "";
        int noOfFailure = 0;
        int noOfOperation = 0;
        ArrayList<Properties> modifyMembersList = new ArrayList<Properties>();
        try {
            Properties p;
            ArrayList<Properties> list;
            Enumeration groupMapKeys;
            ModifyComputerListener listener = (ModifyComputerListener)bean.getListener();
            String sid = this.getValue(result, 3018);
            String dn = this.getValue(result, 3020);
            String primaryGrp = this.getValue(result, 3022);
            Hashtable<String, String> logProps = new Hashtable<String, String>();
            logProps.put(this.rb.getString("client.computermanagement.domainName"), domainName);
            logProps.put(this.rb.getString("client.computermanagement.computerName"), dn);
            BeanMap props = (BeanMap)bean.get("props");
            Hashtable addToGroupSidVsNameMap = (Hashtable)props.get("addToGroupSidVsNameMap");
            Hashtable removeFromGroupSidVsNameMap = (Hashtable)props.get("removeFromGroupSidVsNameMap");
            String isRemoveFromAllGroup = (String)props.get("isRemoveAllGroup");
            ArrayList<String> modifiedMemberOfValues = new ArrayList<String>();
            ArrayList<String> addToGroupSidList = new ArrayList<String>();
            ArrayList<String> removeFromGroupSidList = new ArrayList<String>();
            ArrayList addToGroupNameList = new ArrayList();
            ArrayList<Object> removeFromGroupNameList = new ArrayList<Object>();
            String groupSid = "";
            if (addToGroupSidVsNameMap != null && addToGroupSidVsNameMap.size() > 0) {
                groupMapKeys = addToGroupSidVsNameMap.keys();
                while (groupMapKeys.hasMoreElements()) {
                    groupSid = (String)groupMapKeys.nextElement();
                    addToGroupSidList.add(groupSid);
                    addToGroupNameList.add(addToGroupSidVsNameMap.get(groupSid));
                }
            }
            if (removeFromGroupSidVsNameMap != null && removeFromGroupSidVsNameMap.size() > 0) {
                groupMapKeys = removeFromGroupSidVsNameMap.keys();
                while (groupMapKeys.hasMoreElements()) {
                    groupSid = (String)groupMapKeys.nextElement();
                    removeFromGroupSidList.add(groupSid);
                    removeFromGroupNameList.add(removeFromGroupSidVsNameMap.get(groupSid));
                }
            }
            String primaryGroup = props.getProperty("primaryGroup");
            ArrayList<Hashtable> handleErrorList = new ArrayList<Hashtable>();
            ArrayList groupList = new ArrayList();
            String groupModifyStatusMessage = "";
            if (!primaryGroup.equals("")) {
                logProps.put(this.rb.getString("client.computermanagement.ModifyComputersGroup.primaryGroup"), primaryGroup);
                if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, (long)MgmtActionIdConstants.COMPUTER_PRIMARYGROUP_ACTIONID)) {
                    ++noOfOperation;
                    handleErrorList = new ArrayList();
                    ArrayList<Properties> list1 = new ArrayList<Properties>();
                    Properties p1 = new Properties();
                    p1.put("ATTRIB_VALUE", dn);
                    p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p1.put("DATA_HANDLER_TYPE", new Long(1L));
                    p1.put("ATTRIB_LDAP_NAME", "member");
                    p1.put("DW_CONTROL_CODE", new Long(3L));
                    list1.add(p1);
                    logger.log(Level.INFO, "Modifying Group : Domain Name : " + domainName + ", SID : " + (String)props.get("primaryGroup") + ", list : " + list1);
                    try {
                        ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)((String)props.get("primaryGroupSID")), (String)dn, list1, null, (boolean)true);
                    }
                    catch (LocalizedException le) {
                        this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                        status = le.getMsgFromDetails(this.rb);
                    }
                    catch (Exception e) {
                        logger.log(Level.INFO, "Exception while Setting Py Group." + e.getMessage());
                        message.append(e.getMessage());
                        status = e.getMessage();
                    }
                    this.fillAttribs(list1, "memberOf", primaryGroup);
                    String groupSID = props.getProperty("primaryGroupSID");
                    groupSID = groupSID.substring(groupSID.lastIndexOf("-") + 1);
                    logger.log(Level.INFO, "Setting Primary Group : " + groupSID);
                    ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                    Properties p2 = new Properties();
                    p2.put("ATTRIB_LDAP_NAME", "primaryGroupID");
                    p2.put("ATTRIB_VALUE", groupSID);
                    p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p2.put("DATA_HANDLER_TYPE", new Long(3L));
                    setAttributeList.add(p2);
                    String successMsg = this.rb.getString("admp.mgmt.mod_grp_attribs.statmsg.primary_group_success");
                    logger.log(Level.INFO, "Setting Primary Group  : " + groupSID + " :List : " + setAttributeList);
                    try {
                        ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), null, null);
                        primaryGrp = primaryGroup;
                    }
                    catch (LocalizedException localizedException) {
                        Hashtable<String, String> primaryGroupErrorDetails = new Hashtable<String, String>();
                        primaryGroupErrorDetails.put("ERROR_MESSAGE", localizedException.getMessage(this.rb));
                        primaryGroupErrorDetails.put("NATIVE_ERROR_MESSAGE", localizedException.getMessage(this.rb));
                        handleErrorList.add(primaryGroupErrorDetails);
                        status = localizedException.getMsgFromDetails(this.rb);
                        successMsg = "";
                        ++noOfFailure;
                    }
                    catch (Exception exception) {
                        message.append(exception.getMessage());
                        status = exception.getMessage();
                        ++noOfFailure;
                        successMsg = "";
                    }
                    groupModifyStatusMessage = GroupErrorHandler.setPrimaryGroupStatusMessage(handleErrorList, successMsg, this.rb);
                    message.append(groupModifyStatusMessage);
                    logger.log(Level.INFO, "User Mgmt - Primary Group Message " + groupModifyStatusMessage);
                    if (primaryGroup != null) {
                        modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.common.attrib_disp_name.primary_group") + "</B> : <br/>" + primaryGroup);
                    }
                }
            }
            if (isRemoveFromAllGroup != null && isRemoveFromAllGroup.equals("on")) {
                String searchString = "(&(objectCategory=Group)(objectClass=group)(member=" + CommonUtil.escapeSpecialCharacters((String)dn) + "))";
                Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                ArrayList<String> groupAttributeList = new ArrayList<String>();
                groupAttributeList.add("cn");
                groupAttributeList.add("distinguishedName");
                groupAttributeList.add("objectSid");
                ArrayList grouplistProps = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), groupAttributeList, (String)searchString);
                removeFromGroupSidList = new ArrayList();
                removeFromGroupNameList = new ArrayList();
                ArrayList<Properties> authorizedGrouplistProps = new ArrayList<Properties>();
                if (!grouplistProps.isEmpty()) {
                    for (int index = 0; index < grouplistProps.size(); ++index) {
                        Properties properties = (Properties)grouplistProps.get(index);
                        if (properties == null) continue;
                        ArrayList ouDNList = (ArrayList)properties.get("distinguishedName");
                        String ouDN = (String)ouDNList.get(0);
                        if (!HelpdeskUtil.isExcludedGroup((String)ouDN, (ArrayList)this.groupExcludeList) && HelpdeskUtil.isAuthorizedGroup((String)ouDN, (ArrayList)this.groupIncludeList)) {
                            authorizedGrouplistProps.add(properties);
                            continue;
                        }
                        logger.log(Level.INFO, "Not Authorized Group- " + ouDN);
                    }
                }
                if (authorizedGrouplistProps.isEmpty()) {
                    if (message.length() != 0) {
                        message.append(". ");
                    }
                    if (!grouplistProps.isEmpty()) {
                        message.append((CharSequence)new StringBuilder(this.rb.getString("groupmanagement.messages.not_authorized_remove_group")));
                    } else {
                        message.append((CharSequence)new StringBuilder(this.rb.getString("admp.workflow.view_request.stat_msg.computer_not_part_of_any_group_other_than_primary")));
                    }
                    ++noOfFailure;
                } else {
                    for (int index = 0; index < authorizedGrouplistProps.size(); ++index) {
                        Properties properties = (Properties)authorizedGrouplistProps.get(index);
                        if (properties == null) continue;
                        ArrayList groupObjectSid = (ArrayList)properties.get("objectSid");
                        removeFromGroupSidList.add((String)groupObjectSid.get(0));
                        ArrayList groupObjectName = (ArrayList)properties.get("cn");
                        removeFromGroupNameList.add(groupObjectName.get(0));
                    }
                }
            }
            if (removeFromGroupSidList != null && !removeFromGroupSidList.isEmpty()) {
                int removeFailCount = 0;
                if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, (long)MgmtActionIdConstants.COMPUTER_REMOVEFROMGROUP_ACTIONID)) {
                    ++noOfOperation;
                    handleErrorList = new ArrayList();
                    list = new ArrayList();
                    p = new Properties();
                    p.put("ATTRIB_VALUE", dn);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(4L));
                    list.add(p);
                    boolean flag = false;
                    logger.log(Level.INFO, "Modifying Group :RemoveFromGroup,  Domain Name : " + domainName + ", DNList : " + removeFromGroupSidList + ", list : " + list);
                    for (int index = 0; index < removeFromGroupSidList.size(); ++index) {
                        try {
                            ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)((String)removeFromGroupSidList.get(index)), (String)dn, list, null, (boolean)true);
                            continue;
                        }
                        catch (LocalizedException le) {
                            this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                            status = le.getMsgFromDetails(this.rb);
                            flag = true;
                            ++removeFailCount;
                            continue;
                        }
                        catch (Exception ex) {
                            message.append(ex.getMessage());
                            status = ex.getMessage();
                            flag = true;
                            ++removeFailCount;
                        }
                    }
                    if (flag) {
                        ++noOfFailure;
                    }
                    groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, removeFromGroupSidList.size(), this.rb, removeFromGroupNameList, primaryGrp, "remove", removeFailCount);
                    message.append(groupModifyStatusMessage);
                    logger.log(Level.INFO, "User Mgmt - Remove from Group Message " + groupModifyStatusMessage);
                    this.fillAttribs(list, "memberOf", removeFromGroupNameList);
                    StringBuilder removeGroupStr = new StringBuilder();
                    if (removeFromGroupNameList != null && !removeFromGroupNameList.isEmpty()) {
                        for (String string : removeFromGroupNameList) {
                            if (removeGroupStr.length() > 0) {
                                removeGroupStr.append(", ");
                            }
                            removeGroupStr.append(string);
                        }
                    } else {
                        removeGroupStr.append("-");
                    }
                    modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B> : <br/>" + removeGroupStr);
                }
            } else if (isRemoveFromAllGroup != null && isRemoveFromAllGroup.equals("on") && removeFromGroupSidList.isEmpty()) {
                modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B> : - <br/>");
            }
            if (addToGroupSidList != null && addToGroupSidList.size() > 0 && ClientUtil.checkAuthorization(this.domainVsIds, domainName, (long)MgmtActionIdConstants.COMPUTER_ADDTOGROUP_ACTIONID)) {
                ++noOfOperation;
                groupList = GroupHandler.getDNList((String)domainName, addToGroupSidList);
            }
            if (groupList.size() > 0) {
                int errorFlag = 0;
                list = new ArrayList<Properties>();
                handleErrorList = new ArrayList();
                p = new Properties();
                p.put("ATTRIB_VALUE", groupList);
                p.put("ATTRIB_VALUE_COUNT", new Long(groupList.size()));
                p.put("DATA_HANDLER_TYPE", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", "member");
                p.put("DW_CONTROL_CODE", new Long(3L));
                list.add(p);
                logger.log(Level.INFO, "Modifying Group :AddToGroup,  Domain Name : " + domainName + ", DNList : " + addToGroupSidList + ", list: " + groupList);
                try {
                    NativeError errHdlr = ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)sid, (String)dn, new ArrayList(), (ArrayList)groupList, (boolean)true);
                    for (int index = 0; index < groupList.size(); ++index) {
                        String errorSeverity = errHdlr.getSeverityLevel(groupList.get(index));
                        if (errorSeverity == null || !errorSeverity.equals("WARNING")) continue;
                        Hashtable hashtable = errHdlr.getErrorDetails(groupList.get(index));
                        if (hashtable != null) {
                            handleErrorList.add(hashtable);
                        }
                        ++errorFlag;
                    }
                }
                catch (LocalizedException le) {
                    this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                    ++noOfFailure;
                    status = le.getMsgFromDetails(this.rb);
                    ++errorFlag;
                }
                catch (Exception ex) {
                    message.append(ex.getMessage());
                    ++noOfFailure;
                    if (ex.getMessage() != null) {
                        status = ex.getMessage();
                    }
                    ex.printStackTrace();
                    ++errorFlag;
                }
                if (groupList.size() == errorFlag) {
                    ++noOfFailure;
                }
                groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, groupList.size(), this.rb, removeFromGroupNameList, primaryGrp, "add", errorFlag);
                message.append(groupModifyStatusMessage);
                this.fillAttribs(list, "memberOf", addToGroupNameList);
                StringBuilder addedGroupsStr = new StringBuilder();
                if (addToGroupNameList != null && !addToGroupNameList.isEmpty()) {
                    for (String addedGroup : addToGroupNameList) {
                        if (addedGroupsStr.length() > 0) {
                            addedGroupsStr.append(", ");
                        }
                        addedGroupsStr.append(addedGroup);
                    }
                } else {
                    addedGroupsStr.append("-");
                }
                modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B> : <br/>" + addedGroupsStr);
            } else if (addToGroupSidList != null && addToGroupSidList.size() > 0) {
                ++noOfFailure;
                message = new StringBuilder();
                message.append(this.rb.getString("admp.mgmt.mod_grp_attribs.statmsg.addtogroup_operation_failed") + " - ");
                message.append(this.rb.getString("admp.mgmt.mod_grp_attribs.statmsg.cross_domain_not_supported") + ". ");
            }
            Properties p3 = new Properties();
            p3.put("ATTRIB_VALUE", modifiedMemberOfValues);
            p3.put("ATTRIB_VALUE_COUNT", new Long(modifiedMemberOfValues.size()));
            p3.put("DATA_HANDLER_TYPE", new Long(3L));
            p3.put("ATTRIB_LDAP_NAME", "member");
            p3.put("DW_CONTROL_CODE", new Long(4L));
            modifyMembersList.add(p3);
            this.fillAttribs(modifyMembersList, "memberOf", modifiedMemberOfValues);
            try {
                ADHandler.updateComputer((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
            }
            catch (LocalizedException le) {
                message.append(le.getMessage(this.rb));
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception Message " + e.getMessage());
            e.printStackTrace();
        }
        if (noOfFailure == noOfOperation) {
            message.insert(0, this.rb.getString("client.computermanagement.ModifyComputersGeneral.unable_to_modify_the_computer_error"));
        } else if (noOfFailure == 0) {
            message = new StringBuilder(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
        } else if (noOfFailure < noOfOperation) {
            message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.partially_modified") + ". ");
        }
        logger.log(Level.INFO, "Computer Mgmt - Modify Group Attributes Message message " + message.toString());
        if (message.length() > 1000) {
            message.insert(0, message.subSequence(0, 995) + " ...");
        }
        try {
            TechAuditAPI.getInstance().auditComputerModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.mgmtname.group_attribs"), this.getValue(result, 3001), domainName, modifyMembersList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    private void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }

    @Override
    public void populateIncludedAndExcludedGroup(String domainName, Long loginId) {
        Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)domainName);
        this.groupIncludeList = (ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU");
        this.groupExcludeList = (ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU");
    }
}

