/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.computermanagement.ModifyComputerListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;

public class MoveComputers
extends ModifyComputerListener {
    public MoveComputers() {
        this.reportId = new Integer(2003);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1037L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1037L)) {
            Hashtable<String, String> logProps = new Hashtable<String, String>();
            String dn = this.getValue(result, 3020);
            String sid = this.getValue(result, 3018);
            logProps.put(this.rb.getString("client.computermanagement.domainName"), domainName);
            logProps.put(this.rb.getString("client.computermanagement.computerName"), dn);
            BeanMap props = (BeanMap)bean.get("props");
            try {
                logProps.put(this.rb.getString("client.computermanagement.MoveComputers.moveComputerTo"), props.getProperty("moveUsersDN"));
                ADHandlerForMgmt.moveObject((String)domainName, (Long)loginId, (String)dn, (String)props.getProperty("moveUsersDN"));
                ADHandler.updateComputer((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                if (message.length() == 0) {
                    message.append(this.rb.getString("client.computermanagement.MoveComputers.successfully_modified"));
                } else {
                    message.insert(0, this.rb.getString("client.computermanagement.MoveComputers.successfully_modified_error"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.MoveComputers.unable_to_modify_the_computer_error") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.MoveComputers.unable_to_modify_the_computer_error" + e.getMessage()));
            }
            String sourceDN = StrUtil.getContainerDNFromDN((String)dn);
            TechAuditAPI.getInstance().auditMoveComputer(loginId, this.rb.getString("admp.mgmt.comp_mgmt.move_comps.mgmtname.move_comps"), this.getValue(result, 3001), domainName, sourceDN, props.getProperty("moveUsersDN"), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        return message.toString();
    }
}

