/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.contacts;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.contacts.ModifyContactListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class AddressAttributeListener
extends ModifyContactListener {
    public AddressAttributeListener() {
        this.reportId = new Integer(3003);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1072L})) {
            return this.rb.getString("client.contacts.AddressAttributeListener.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            BeanMap props = (BeanMap)bean.get("props");
            String guid = this.getValue(result, 10050);
            String dn = this.getValue(result, 10004);
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p = new Properties();
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                String beanValue = props.getProperty(selectedAttributes[j]);
                if (beanValue.equals("")) {
                    p.put("DW_CONTROL_CODE", new Long(1L));
                }
                if (selectedAttributes[j].equals("manager")) {
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    result.put("manager", beanValue);
                } else {
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                }
                p.put("ATTRIB_VALUE", beanValue);
                if (selectedAttributes[j].equals("co")) {
                    Properties coprop = new Properties();
                    coprop.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    coprop.put("ATTRIB_LDAP_NAME", "countryCode");
                    coprop.put("ATTRIB_VALUE", props.getProperty("countryCode"));
                    coprop.put("DATA_HANDLER_TYPE", new Long(3L));
                    Properties cprop = new Properties();
                    cprop.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    cprop.put("ATTRIB_LDAP_NAME", "c");
                    cprop.put("ATTRIB_VALUE", props.getProperty("c"));
                    cprop.put("DATA_HANDLER_TYPE", new Long(3L));
                    setAttributeList.add(coprop);
                    setAttributeList.add(cprop);
                }
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY Contact, DOMAIN :  " + domainName + " Guid : " + guid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandler.modifyContact((String)domainName, (Long)loginId, (String)guid, (String)dn, setAttributeList, (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("client.contacts.AddressAttributeListener.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("client.contacts.AddressAttributeListener.successfully_modified_error") + " : ");
                    }
                } else {
                    message.insert(0, this.rb.getString("client.contacts.AddressAttributeListener.unable_to_modify_the_contact_error") + " : ");
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("client.contacts.AddressAttributeListener.unable_to_modify_the_contact") + " " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.contacts.AddressAttributeListener.unable_to_modify_the_contact") + " " + e.getMessage());
            }
            TechAuditAPI.getInstance().auditContactModification(loginId, this.rb.getString("admp.mgmt.common.mgmtcategory.modify_add_org_attribs"), this.getValue(result, 10004), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        String[] actionValues = new String[]{"title", "department", "company", "manager", "streetAddress", "postOfficeBox", "l", "st", "postalCode", "co"};
        String[] actionLabelsStr = new String[]{"admp.contact_management.bulk_contact_modification.bulk_address_attributes.title", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.department", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.company", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.manager", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.street", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.P_O_Box", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.city", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.state_province", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.zip_postal_code", "admp.contact_management.bulk_contact_modification.bulk_address_attributes.country_region"};
        MgmtUtil.setEmptyFieldsMessage(request, bean, actionValues, actionLabelsStr);
    }
}

