/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.contacts;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.webclient.contacts.ModifyContactListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;

public class DeleteContactsListener
extends ModifyContactListener {
    public DeleteContactsListener() {
        this.reportId = new Integer(3006);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1071L})) {
            return this.rb.getString("admp.mgmt.contact_mgmt.delete_contacts.access_denied");
        }
        try {
            logger.log(Level.INFO, "Calling Modify User in the DeleteContactsListener");
            try {
                String dn = this.getValue(result, 10004);
                String guid = this.getValue(result, 10050);
                guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                logger.log(Level.INFO, "Starts deleting the contact,guid: " + guid + "dn: " + dn);
                ADHandler.deleteContact((String)domainName, (Long)loginId, (String)dn);
                UserHandler.deleteContact((String)dn);
                message.append(this.rb.getString("contacts.message.successfully_deleted_contact"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("contacts.message.unable_deleted_contact") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("contacts.message.unable_deleted_contact") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditDeleteContact(loginId, this.rb.getString("admp.management.contact_management.delete_contacts"), this.getValue(result, 10004), domainName, message.toString(), this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }
}

