/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.OUUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CSVOUListener
extends CSVUserListener {
    public CSVOUListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList groupList) {
        super(loginId, ids, domainVsIds, groupList);
    }

    @Override
    public AddUserHandler returnHandler() {
        OUUserHandler handler = OUUserHandler.getInstance();
        return handler;
    }

    @Override
    protected String[][] getMessages() {
        String[] messageKeys = new String[]{"heading", "query.string", "message.body", "message.match.criteria", "message.error_occured", "error.no.object", "link.sample"};
        String[] messages = new String[]{this.rb.getString("client.csv.CSVOUListener.modify_ous_using_CSV"), "(&(objectClass=organizationalUnit)(objectCategory=organizationalUnit))", this.rb.getString("client.csv.CSVOUListener.you_can_modify_ou_by_importing_data_from_csv_files"), this.rb.getString("client.csv.CSVOUListener.match_criteria_for_ou_in_AD"), this.rb.getString("client.csv.CSVOUListener.show_the_error_occured_ou_only"), this.rb.getString("client.csv.CSVOUListener.please_select_the_ou"), "/help/ou-management/active-directory-organizational-units-modification.html"};
        String[][] mess = new String[][]{messageKeys, messages};
        return mess;
    }

    @Override
    protected void performADSync() {
        DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"OU"}, (boolean)false);
    }

    @Override
    protected void modifyObject(String defaultNamingContext, Hashtable hashtable, Hashtable customAttributesList, boolean isLicenseExceeded, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Long userIndex = (Long)hashtable.get("USER_INDEX");
        ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
        ArrayList<Hashtable> propList = new ArrayList<Hashtable>();
        ArrayList customList = new ArrayList();
        ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
        Properties props = new Properties();
        String searchString = "(&(objectCategory=organizationalUnit)(objectClass=organizationalUnit)";
        for (int i = 0; i < valuesList.size(); ++i) {
            Hashtable prop = (Hashtable)valuesList.get(i);
            if (this.validSelectedValues != null) {
                for (int k = 0; k < this.validSelectedValues.length; ++k) {
                    String index;
                    String attributeName = (String)prop.get("ATTRIB_LDAP_NAME");
                    if (!attributeName.equals(index = this.validSelectedValues[k])) continue;
                    String attributeValue = (String)prop.get("ATTRIB_VALUE");
                    attributeValue = attributeName.equalsIgnoreCase("objectGUID") ? CSVOUListener.convertGuidToHexDecimal(attributeValue) : CommonUtil.escapeSpecialCharacters((String)attributeValue);
                    searchString = searchString + "(" + attributeName + "=" + attributeValue + ")";
                }
                continue;
            }
            searchString = searchString + "(" + this.keyLdapName + "=" + this.keyLdapValue + ")";
        }
        searchString = searchString + ")";
        mgmtLog.log(Level.INFO, "SearchString in the OU Updation : " + searchString);
        String objectName = "";
        objectName = this.getObjectName(valuesList);
        this.removeUnAuthorizedProps(valuesList);
        this.getProperties("modify", valuesList, propList, modifyList, null, null, null, props, "OU");
        String name = "";
        String distinguishedName = "";
        if (props.get("distinguishedName") != null) {
            distinguishedName = props.getProperty("distinguishedName");
        }
        String userName = "";
        if (props.get("userName") != null) {
            userName = props.getProperty("userName");
        }
        String manager = "";
        if (props.get("manager") != null) {
            manager = props.getProperty("manager");
        }
        Hashtable nameVsValues = (Hashtable)customAttributesList.get(userIndex);
        mgmtLog.log(Level.INFO, "Bulk OU modification Custom Attributes : " + customAttributesList);
        if (nameVsValues != null) {
            Enumeration e = nameVsValues.keys();
            while (e.hasMoreElements()) {
                String attributeName = (String)e.nextElement();
                ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                customTable.put("ATTRIB_LDAP_NAME", attributeName);
                customTable.put("DATA_HANDLER_TYPE", 3L);
                customTable.put("ATTRIB_VALUE_COUNT", 1L);
                if (values != null && values.size() > 0) {
                    customTable.put("ATTRIB_VALUE", values.get(0));
                } else {
                    customTable.put("ATTRIB_VALUE", "");
                    customTable.put("DW_CONTROL_CODE", 1L);
                }
                customList.add(customTable);
            }
        }
        mgmtLog.log(Level.FINE, "replacing.... " + userName);
        userName = CommonUtil.escapeString((String)userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
        mgmtLog.log(Level.FINE, "replaced userName " + userName);
        Hashtable<String, Object> logProps = new Hashtable<String, Object>();
        logProps.put("domainName", this.domainName);
        logProps.put("userName", userName);
        logProps.put("propList", propList);
        logProps.put("modifyList", modifyList);
        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (String)objectName, (String)this.domainName, (DataObject)auditDataObj);
        audit_info.put("object_id", object_id);
        audit_info.put("objectName", objectName);
        if (props.get("manager") != null) {
            audit_info.put("manager", manager);
        }
        Properties prop = new Properties();
        try {
            Properties grpList;
            String CREATION_STATUS;
            block51: {
                ArrayList ouList;
                block52: {
                    this.removeUnAuthorizedProps(customList);
                    CREATION_STATUS = "SUCCESS";
                    if (distinguishedName.equals("")) {
                        ArrayList userAttributeList = new ArrayList();
                        userAttributeList.add("distinguishedName");
                        userAttributeList.add("name");
                        Properties domainDetails = ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId);
                        userAttributeList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)defaultNamingContext, userAttributeList, (String)searchString);
                        if (userAttributeList != null && userAttributeList.size() > 0) {
                            Properties dnProp = (Properties)userAttributeList.get(0);
                            distinguishedName = StrUtil.getString((Properties)dnProp, (String)"distinguishedName");
                            name = StrUtil.getString((Properties)dnProp, (String)"name");
                        } else {
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.object_not_exist_access_denied"));
                            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                        }
                    }
                    if (propList.size() <= 0 && customList.size() <= 0) break block51;
                    ouList = (ArrayList)this.authorizedDomainOUHash.get(this.domainName);
                    mgmtLog.log(Level.INFO, "propList after authorize check " + propList);
                    logProps.put("customList", customList);
                    if (ouList != null && ouList.size() != 0) break block52;
                    NativeError error = ADHandler.searchAndModifyOU((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), propList);
                    prop = this.getBulkUserErrorMessage(this.domainName, searchString, null, error, userName, distinguishedName);
                    CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                    if (CREATION_STATUS.equalsIgnoreCase("SEVERE") || customList.isEmpty()) break block51;
                    NativeError customError = ADHandler.searchAndModifyOU((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), customList);
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                    CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                    break block51;
                }
                for (int i = 0; i < ouList.size(); ++i) {
                    NativeError error = ADHandler.searchAndModifyOU((String)this.domainName, (Long)this.loginId, (String)((String)ouList.get(i)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), propList);
                    prop = this.getBulkUserErrorMessage(this.domainName, searchString, null, error, userName, distinguishedName);
                    CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                    if (CREATION_STATUS.equalsIgnoreCase("SEVERE")) continue;
                    if (customList.isEmpty()) break;
                    NativeError customError = ADHandler.searchAndModifyOU((String)this.domainName, (Long)this.loginId, (String)((String)ouList.get(i)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), customList);
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                    CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                    break;
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("severe")) {
                try {
                    if (props.get("preventDeletion") != null) {
                        grpList = new Properties();
                        grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                        grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                        grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        if (((Boolean)props.get("preventDeletion")).booleanValue()) {
                            grpList.put("ATTRIB_VALUE", "true");
                            String rootName = StrUtil.getContainerDNFromDN((String)distinguishedName);
                            this.updatePreventDeletion(distinguishedName, "add");
                            if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                                this.updateParent(rootName);
                            }
                        } else {
                            grpList.put("ATTRIB_VALUE", "false");
                            this.updatePreventDeletion(distinguishedName, "delete");
                        }
                        propList.add(grpList);
                    }
                }
                catch (Exception e) {
                    CREATION_STATUS = "SEVERE";
                    prop.setProperty("CREATION_MESSAGE", e.getMessage());
                    prop.setProperty("CREATION_STATUS", "SEVERE");
                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
            }
            if (objectName.equals("")) {
                HDTAuditUtil.updateAuditData((Long)object_id, (String)name, (String)"OBJECT_NAME", (DataObject)auditDataObj);
                objectName = name;
            }
            if (!CREATION_STATUS.equalsIgnoreCase("severe") && this.checkSelected("name") && userName != null && !userName.equals("")) {
                mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + userName + " for the OU : " + distinguishedName);
                try {
                    ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)userName, (String)"OU", null);
                    grpList = new Properties();
                    grpList.put("ATTRIB_LDAP_NAME", "name");
                    grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.bulk_creation.common.text.name"));
                    grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    grpList.put("ATTRIB_VALUE", userName);
                    propList.add(grpList);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    StringBuffer message = new StringBuffer();
                    if (prop.getProperty("CREATION_MESSAGE") != null) {
                        message.append(prop.getProperty("CREATION_MESSAGE"));
                        if (message.length() > 0) {
                            message.append(" , ");
                        }
                    }
                    CREATION_STATUS = "SEVERE";
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_ous.statmsg.error_modifying_fullname"), le.getMessage(this.rb)));
                    prop.setProperty("CREATION_MESSAGE", message.toString());
                    prop.setProperty("CREATION_STATUS", "SEVERE");
                    prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("severe") && this.checkSelected("ouName") && !distinguishedName.equals("")) {
                String OUName = props.getProperty("OUName");
                if (OUName != null && !OUName.equals("")) {
                    String newdistinguishedName;
                    String processedOUName;
                    String oldDistinguishedName = null;
                    boolean isCreateNewOUActionAuthorized = false;
                    if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)DelegationUtil.CREATE_OU_ACTION_ID)) {
                        isCreateNewOUActionAuthorized = true;
                    }
                    if ((processedOUName = MgmtUtil.checkAndCreateParent(this.domainName, OUName, this.loginId, isCreateNewOUActionAuthorized)) != null) {
                        OUName = processedOUName;
                    } else {
                        mgmtLog.log(Level.INFO, "Seems given dn format is not valid DN or logged user doesn't have to create new option, so Move to container option might be fail " + isCreateNewOUActionAuthorized);
                    }
                    if (userName.equals("")) {
                        userName = StrUtil.getNameFromDN((String)distinguishedName);
                    }
                    if (!distinguishedName.equals(newdistinguishedName = "CN=" + userName + "," + OUName)) {
                        oldDistinguishedName = newdistinguishedName;
                        try {
                            mgmtLog.log(Level.INFO, "Move container option selected - SourceDN " + distinguishedName + " Destination DN : " + OUName);
                            ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)OUName);
                            prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                            prop.setProperty("CREATION_STATUS", "SUCCESS");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                            ArrayList<String> moveUserAudit = new ArrayList<String>();
                            if (oldDistinguishedName != null) {
                                String ouname = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
                                String movedFrom = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + " : </B><br/>" + ouname;
                                ouname = DirectoryObjectUtil.getOUNameFromDN((String)oldDistinguishedName);
                                String movedTo = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + " : </B><br/>" + ouname;
                                moveUserAudit.add(movedFrom);
                                moveUserAudit.add(movedTo);
                            }
                            if (!moveUserAudit.isEmpty()) {
                                Properties movedList = new Properties();
                                movedList.put("ATTRIB_LDAP_NAME", "container");
                                movedList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                                movedList.put("ATTRIB_VALUE", moveUserAudit);
                                propList.add(movedList);
                            }
                        }
                        catch (LocalizedException le) {
                            le.printStackTrace();
                            StringBuffer message = new StringBuffer();
                            if (prop.getProperty("CREATION_MESSAGE") != null) {
                                message.append(prop.getProperty("CREATION_MESSAGE"));
                                if (message.length() > 0) {
                                    message.append(" , ");
                                }
                            }
                            message.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_moving_objects"), le.getMessage(this.rb)));
                            prop.setProperty("CREATION_MESSAGE", message.toString());
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    mgmtLog.log(Level.INFO, "OUName is selected as toBeUpdateAttributeList but value might not be provided in csv file or HDT is not authorized to use this OU");
                    StringBuffer message = new StringBuffer();
                    if (prop.getProperty("CREATION_MESSAGE") != null) {
                        message.append(prop.getProperty("CREATION_MESSAGE"));
                        if (message.length() > 0) {
                            message.append(" , ");
                        }
                    }
                    message.append(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_unauth_OU"));
                    prop.setProperty("CREATION_MESSAGE", message.toString());
                    prop.setProperty("CREATION_STATUS", "SEVERE");
                    prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                prop.setProperty("CREATION_STATUS", "SUCCESS");
                prop.setProperty("CREATION_MESSAGE", this.rb.getString("client.csv.CSVContactListener.sucessfully_updated_the_ou"));
                prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            }
            mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
            prop.setProperty("userName", userName);
        }
        catch (Exception e) {
            e.printStackTrace();
            prop.setProperty("CREATION_MESSAGE", this.rb.getString(e.getMessage()));
            prop.setProperty("CREATION_STATUS", "SEVERE");
            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
        }
        prop.put("USER_INDEX", userIndex);
        if (prop.getProperty("CREATION_MESSAGE") == null) {
            prop.setProperty("CREATION_STATUS", "SEVERE");
            prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.csv_import.common.statmsg.no_changes_done_on_attribute"));
            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
        }
        this.addRow(prop);
        TechAuditAPI.getInstance().auditOUModification(this.loginId, this.rb.getString("admp.mgmt.csv_imp.mod_ou.mgmtname.mod_ou_csv"), objectName, this.domainName, null, propList, customList, prop.getProperty("CREATION_MESSAGE"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
        String objectOUName = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
        audit_info.put("OUName", objectOUName);
    }
}

