/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.csv;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.CategoryHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVComputerListener;
import com.adventnet.sym.adsm.common.webclient.csv.CSVContactListener;
import com.adventnet.sym.adsm.common.webclient.csv.CSVGroupListener;
import com.adventnet.sym.adsm.common.webclient.csv.CSVOUListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class CSVUserListener
extends AddUserListener {
    protected boolean stop = false;
    protected Hashtable authorizedDomainOUHash = null;
    private String[] validSelected = null;
    protected String[] validSelectedValues = null;
    protected boolean csvHasPwd = false;
    private Long[] ids = null;
    private ArrayList updateList = new ArrayList();
    private Properties messageProp = null;
    public AdventNetResourceBundle rb;
    protected Hashtable domainVsIds = new Hashtable();
    protected Integer reportId;
    protected int updatedCount = 0;
    protected Long requestId;
    protected boolean isWorkflowMode = false;
    ArrayList resultAttributeList = null;

    public void setWorkflowMode(boolean isWorkflowMode) {
        this.isWorkflowMode = isWorkflowMode;
    }

    public AddUserHandler returnHandler() {
        AddUserHandler handler = AddUserHandler.getInstance();
        return handler;
    }

    public CSVUserListener(Long loginId) {
        this.loginId = loginId;
    }

    public CSVUserListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList userCreationGroupList) {
        this.loginId = loginId;
        this.ids = ids;
        this.domainVsIds = domainVsIds;
        this.userCreationGroupList = userCreationGroupList;
    }

    public void init(Integer reportId, Long userCreationID, String domainName, ArrayList<Hashtable> userDetailsList, String keyLdapName) {
        this.init(reportId, userCreationID, domainName, userDetailsList, keyLdapName, null, null);
    }

    public void init(Integer reportId, Long userCreationID, String domainName, ArrayList<Hashtable> userDetailsList, String keyLdapName, ArrayList attribList) {
        this.init(reportId, userCreationID, domainName, userDetailsList, keyLdapName, null, attribList);
    }

    public void init(Integer reportId, Long userCreationID, String domainName, ArrayList<Hashtable> userDetailsList, String keyLdapName, Long requestId, ArrayList attribList) {
        this.userCreationID = userCreationID;
        this.reportId = reportId;
        this.domainName = domainName;
        this.userDetailsList = userDetailsList;
        this.keyLdapName = keyLdapName;
        this.requestId = requestId;
        this.resultAttributeList = attribList;
        try {
            Properties p = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)this.loginId);
            String defaultNamingContext = p.getProperty("DEFAULT_NAMING_CONTEXT");
            this.userCreationGroupList = UserMgmtUtil.getGroupList((Long)this.loginId, (String)defaultNamingContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String[][] getMessages() {
        String[] messageKeys = new String[]{"heading", "query.string", "message.body", "message.match.criteria", "message.error_occured", "error.no.object", "link.sample"};
        String[] messages = new String[]{this.rb.getString("client.csv.CSVUserListener.modify_users_using_CSV"), "(&(objectClass=user)(objectCategory=user)", this.rb.getString("client.csv.CSVUserListener.you_can_modify_users_by_importing_data_from_csv_files"), this.rb.getString("client.csv.CSVUserListener.match_criteria_for_users_in_AD"), this.rb.getString("client.csv.CSVUserListener.show_the_error_occured_users_only"), this.rb.getString("client.csv.CSVUserListener.please_select_the_user"), "/help/csv-import-management/active-directory-modify-users-csv.html"};
        String[][] mess = new String[][]{messageKeys, messages};
        return mess;
    }

    public String getObjectMessage(String key) {
        if (this.messageProp == null) {
            this.messageProp = new Properties();
            String[][] mess = this.getMessages();
            for (int i = 0; i < mess[0].length; ++i) {
                this.messageProp.put(mess[0][i], mess[1][i]);
            }
        }
        return this.messageProp.getProperty(key);
    }

    public String getObjectName(ArrayList valuesList) {
        String attribValue = "";
        for (int i = 0; i < valuesList.size(); ++i) {
            Hashtable hash = (Hashtable)valuesList.get(i);
            String attribName = (String)hash.get("ATTRIB_LDAP_NAME");
            if (!attribName.equalsIgnoreCase("sAMAccountName") && !attribName.equalsIgnoreCase("userName") && !attribName.equalsIgnoreCase("givenName") && !attribName.equalsIgnoreCase("distinguishedName") && !attribName.equalsIgnoreCase("name") || attribValue == null) continue;
            attribValue = (String)hash.get("ATTRIB_VALUE");
            return attribValue;
        }
        return attribValue;
    }

    public void updatePreventDeletion(String ouDN, String operation) throws Exception {
        ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
        everyOneTrusteeList.add("S-1-1-0");
        ArrayList aceList = new ArrayList();
        Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
        aceHash.put("ACCESS_MASK", 65600L);
        aceHash.put("PERMISSION_STRING", "Delete,Delete Subtree");
        aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
        aceHash.put("ACE_TYPE", 1L);
        aceHash.put("ACE_ID", new Long(1L));
        aceHash.put("operation", operation);
        aceList.add(aceHash);
        ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)ouDN);
    }

    public void updateParent(String ouDN) throws Exception {
        ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
        everyOneTrusteeList.add("S-1-1-0");
        ArrayList aceList = new ArrayList();
        Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
        aceHash.put("ACCESS_MASK", 2L);
        aceHash.put("PERMISSION_STRING", "Delete all child");
        aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
        aceHash.put("ACE_TYPE", 1L);
        aceHash.put("ACE_ID", new Long(1L));
        aceHash.put("operation", "add");
        aceList.add(aceHash);
        ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)ouDN);
    }

    public void modifyUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String hostId = request.getRemoteHost();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        this.validSelected = request.getParameterValues("validSelected");
        this.validSelectedValues = request.getParameterValues("validSelectedValues");
        String appendFlagStr = request.getParameter("appendvaluesfromCSV");
        this.isAppendMultiValue = appendFlagStr != null && appendFlagStr.equalsIgnoreCase("on");
        String csvEmptyFlagStr = request.getParameter("removeADValueCSVEmpty");
        this.isClearEmptyValue = csvEmptyFlagStr != null && csvEmptyFlagStr.equalsIgnoreCase("on");
        this.authorizedDomainOUHash = authObject.getDomainOUsMap();
        Action action = new Action(this, hostId);
        this.stop = false;
        this.isCompleted = false;
        this.errorMessage = "";
        action.start();
    }

    public void modifyUser() {
        Action action = new Action(this, this.hostId);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    public void setAuthorizedDomainOUHash(Hashtable authorizedDomainOUHash) {
        this.authorizedDomainOUHash = authorizedDomainOUHash;
    }

    public void setValidSelected(String[] validSelected) {
        this.validSelected = validSelected;
    }

    public String[] getValidSelected() {
        return this.validSelected;
    }

    public void setValidSelectedValues(String[] validSelectedValues) {
        this.validSelectedValues = validSelectedValues;
    }

    public String[] getValidSelectedValues() {
        return this.validSelectedValues;
    }

    public String getKeyLdapName() {
        return this.keyLdapName;
    }

    public void setAdvancedOptions(String isAppendValue, String isClearValue) {
        this.isAppendMultiValue = Boolean.parseBoolean(isAppendValue);
        this.isClearEmptyValue = Boolean.parseBoolean(isClearValue);
    }

    @Override
    public void stop() {
        this.stop = true;
        while (!this.isCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void performADSync() {
        DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"User"}, (boolean)false);
    }

    public static String convertGuidToHexDecimal(String guid) {
        guid = guid.replaceAll("[{}]+", "");
        int hypencount = guid.length() - guid.replaceAll("-", "").length();
        String[] parts = guid.split("-");
        if (hypencount == 4 && parts.length == 5) {
            int j = 0;
            char[] part1 = parts[0].toCharArray();
            char[] part2 = parts[1].toCharArray();
            char[] part3 = parts[2].toCharArray();
            String ans = CSVUserListener.guidConversion(part1);
            ans = ans + CSVUserListener.guidConversion(part2);
            ans = ans + CSVUserListener.guidConversion(part3);
            ans = ans + parts[3];
            ans = ans + parts[4];
            char[] ans1 = ans.toCharArray();
            char[] result = new char[48];
            int i = 0;
            while (i + 1 < ans1.length) {
                result[j++] = 92;
                result[j++] = ans1[i];
                result[j++] = ans1[i + 1];
                i += 2;
            }
            return String.valueOf(result);
        }
        return "";
    }

    private static String guidConversion(char[] part) {
        int j = 0;
        char[] result = new char[part.length];
        for (int i = part.length - 1; i >= 0; i -= 2) {
            result[j++] = part[i - 1];
            result[j++] = part[i];
        }
        return String.valueOf(result);
    }

    protected ArrayList splitMultiValues(ArrayList valuesList) {
        ArrayList<String> splitList = new ArrayList<String>();
        try {
            if (valuesList != null && !valuesList.isEmpty()) {
                for (String multiValue : valuesList) {
                    String[] valueArr;
                    if (multiValue == null) continue;
                    for (String value : valueArr = multiValue.split("(?<!\\\\);")) {
                        if (value == null || value.isEmpty() || splitList.contains(value = value.replace("\\;", ";"))) continue;
                        splitList.add(value);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return splitList;
    }

    /*
     * WARNING - void declaration
     */
    protected void modifyObject(String defaultNamingContext, Hashtable hashtable, Hashtable customAttributesList, boolean isLicenseExceeded, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Properties prop;
        String manager;
        String password;
        String distinguishedName;
        block119: {
            String samAccountName;
            String userName;
            Long userIndex;
            block116: {
                String archiveDomain;
                String archiveDB;
                boolean removeMemberOf;
                String objectName;
                Properties removeProps;
                ArrayList<String> groupList;
                ArrayList<Hashtable> winNTAttributeList;
                ArrayList<Hashtable> tsList;
                ArrayList<Hashtable> modifyList;
                ArrayList customList;
                ArrayList<Hashtable> propList;
                block115: {
                    String attributeName;
                    int i;
                    userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    propList = new ArrayList<Hashtable>();
                    customList = new ArrayList();
                    modifyList = new ArrayList<Hashtable>();
                    tsList = new ArrayList<Hashtable>();
                    winNTAttributeList = new ArrayList<Hashtable>();
                    groupList = new ArrayList<String>();
                    Properties props = new Properties();
                    removeProps = new Properties();
                    String searchString = "(&(objectClass=user)(objectCategory=user)";
                    String samName = "";
                    if (this.validSelectedValues != null) {
                        for (i = 0; i < valuesList.size(); ++i) {
                            Hashtable prop2 = (Hashtable)valuesList.get(i);
                            for (int k = 0; k < this.validSelectedValues.length; ++k) {
                                String index;
                                attributeName = (String)prop2.get("ATTRIB_LDAP_NAME");
                                if (attributeName.equalsIgnoreCase("password")) {
                                    this.csvHasPwd = true;
                                }
                                if (!attributeName.equals(index = this.validSelectedValues[k])) continue;
                                Object attributeObjVal = prop2.get("ATTRIB_VALUE");
                                if (attributeName.equalsIgnoreCase("sAMAccountName")) {
                                    samName = (String)attributeObjVal;
                                }
                                int relationalType = (Integer)prop2.get("RELATIONAL_TYPE");
                                String attributeValue = "";
                                if (relationalType == 1) continue;
                                attributeValue = (String)attributeObjVal;
                                Long dataType = (Long)prop2.get("DATA_HANDLER_TYPE");
                                if (dataType == 6L) {
                                    attributeValue = attributeValue.toUpperCase();
                                }
                                attributeValue = attributeName.equalsIgnoreCase("objectGUID") ? CSVUserListener.convertGuidToHexDecimal(attributeValue) : CommonUtil.escapeSpecialCharacters((String)attributeValue);
                                searchString = searchString + "(" + attributeName + "=" + attributeValue + ")";
                            }
                        }
                    } else {
                        for (i = 0; i < valuesList.size(); ++i) {
                            Hashtable prop2 = (Hashtable)valuesList.get(i);
                            String attributeName2 = (String)prop2.get("ATTRIB_LDAP_NAME");
                            if (attributeName2.equalsIgnoreCase("password")) {
                                this.csvHasPwd = true;
                            }
                            if (!attributeName2.equals(this.keyLdapName)) continue;
                            this.keyLdapValue = CommonUtil.escapeSpecialCharacters((String)((String)prop2.get("ATTRIB_VALUE")));
                        }
                        searchString = searchString + "(" + this.keyLdapName + "=" + this.keyLdapValue + ")";
                    }
                    searchString = searchString + ")";
                    System.out.println("searchString : : : : : : " + searchString);
                    objectName = "";
                    objectName = this.getObjectName(valuesList);
                    this.removeUnAuthorizedProps(valuesList);
                    this.getProperties("modify", valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, props, "User");
                    Hashtable nameVsValues = (Hashtable)customAttributesList.get(userIndex);
                    mgmtLog.log(Level.FINE, "Bulk User modification Custom Attributes : " + nameVsValues);
                    if (nameVsValues != null) {
                        Enumeration e = nameVsValues.keys();
                        while (e.hasMoreElements()) {
                            attributeName = (String)e.nextElement();
                            ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                            if (attributeName.equalsIgnoreCase("removeMemberOf")) {
                                removeProps.put("removeMemberOf", this.splitMultiValues(values));
                                continue;
                            }
                            if (attributeName.equalsIgnoreCase("removeProxyAddresses")) {
                                removeProps.put("removeProxyAddresses", this.splitMultiValues(values));
                                continue;
                            }
                            if (!this.isClearEmptyValue && values != null && values.size() == 0) continue;
                            Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                            customTable.put("ATTRIB_LDAP_NAME", attributeName);
                            customTable.put("DATA_HANDLER_TYPE", 3L);
                            customTable.put("ATTRIB_VALUE_COUNT", 1L);
                            boolean isMultiValue = false;
                            Hashtable attribDetails = this.returnHandler().getAttributeDetailsFromMap("ATTRIB_LDAP_NAME", (Object)attributeName);
                            if (attribDetails != null && attribDetails.get("RELATIONAL_TYPE") != null) {
                                boolean bl = isMultiValue = ((Integer)attribDetails.get("RELATIONAL_TYPE")).compareTo(1) == 0;
                            }
                            if (this.isAppendMultiValue && isMultiValue) {
                                customTable.put("DW_CONTROL_CODE", 3L);
                            } else {
                                customTable.put("DW_CONTROL_CODE", 2L);
                            }
                            if (values != null && values.size() > 1) {
                                ArrayList<String> list = new ArrayList<String>();
                                for (Object string : values) {
                                    list.add(string.toString().trim());
                                }
                                customTable.put("ATTRIB_VALUE", list);
                                customTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                            } else if (values != null && values.size() == 1) {
                                customTable.put("ATTRIB_VALUE", values.get(0));
                            } else {
                                customTable.put("ATTRIB_VALUE", "");
                                customTable.put("DW_CONTROL_CODE", 1L);
                            }
                            customList.add(customTable);
                        }
                    }
                    removeMemberOf = false;
                    String fullName = "";
                    if (props.containsKey("removeMemberOf")) {
                        removeMemberOf = true;
                    }
                    distinguishedName = "";
                    if (props.get("distinguishedName") != null) {
                        distinguishedName = props.getProperty("distinguishedName");
                    }
                    userName = "";
                    if (props.get("userName") != null) {
                        userName = props.getProperty("userName");
                    }
                    samAccountName = "";
                    if (props.get("samAccountName") != null) {
                        samAccountName = props.getProperty("samAccountName");
                    }
                    password = null;
                    if (props.get("password") != null) {
                        password = props.getProperty("password");
                    }
                    manager = "";
                    if (props.get("manager") != null) {
                        manager = props.getProperty("manager");
                    }
                    String remoteHomeDir = "";
                    if (props.get("remoteHomeDir") != null) {
                        remoteHomeDir = props.getProperty("remoteHomeDir");
                    }
                    String tsRemoteHomeDir = "";
                    if (props.get("tsRemoteHomeDir") != null) {
                        tsRemoteHomeDir = props.getProperty("tsRemoteHomeDir");
                    }
                    String profilePath = "";
                    if (props.get("profilePath") != null) {
                        profilePath = props.getProperty("profilePath");
                    }
                    String tsProfilePath = "";
                    if (props.get("tsProfilePath") != null) {
                        tsProfilePath = props.getProperty("tsProfilePath");
                    }
                    String tsWorkingDir = "";
                    if (props.get("tsWorkingDir") != null) {
                        tsWorkingDir = props.getProperty("tsWorkingDir");
                    }
                    archiveDB = "";
                    if (props.get("msExchArchiveDatabaseLink") != null) {
                        archiveDB = props.getProperty("msExchArchiveDatabaseLink");
                    }
                    archiveDomain = "";
                    if (props.get("msExchArchiveAddress") != null) {
                        archiveDomain = props.getProperty("msExchArchiveAddress");
                    }
                    samAccountName = CommonUtil.replaceSAMAccountSplChars((String)samAccountName);
                    if (samName.isEmpty()) {
                        samName = samAccountName;
                    }
                    if (!remoteHomeDir.equals("")) {
                        remoteHomeDir = FormatClientUtil.getFormatValue(this.domainName, remoteHomeDir, valuesList, samName, userName, customList);
                        CSVUserListener.setFormatValue(propList, "homeDirectory", remoteHomeDir);
                    }
                    profilePath = FormatClientUtil.getFormatValue(this.domainName, profilePath, valuesList, samName, userName, customList);
                    CSVUserListener.setFormatValue(propList, "profilePath", profilePath);
                    if (!tsRemoteHomeDir.equals("")) {
                        tsRemoteHomeDir = FormatClientUtil.getFormatValue(this.domainName, tsRemoteHomeDir, valuesList, samName, userName, customList);
                        CSVUserListener.setFormatValue(tsList, "tsHomeDir", tsRemoteHomeDir);
                    }
                    tsProfilePath = FormatClientUtil.getFormatValue(this.domainName, tsProfilePath, valuesList, samName, userName, customList);
                    CSVUserListener.setFormatValue(tsList, "tsProfilePath", tsProfilePath);
                    tsWorkingDir = FormatClientUtil.getFormatValue(this.domainName, tsWorkingDir, valuesList, samName, userName, customList);
                    CSVUserListener.setFormatValue(tsList, "tsWorkingDir", tsWorkingDir);
                    Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                    logProps.put("domainName", this.domainName);
                    logProps.put("userName", userName);
                    logProps.put("samAccountName", samAccountName);
                    if (password != null) {
                        logProps.put("password", password);
                    }
                    logProps.put("propList", propList);
                    logProps.put("modifyList", modifyList);
                    logProps.put("tsList", tsList);
                    logProps.put("winNTAttributeList", winNTAttributeList);
                    logProps.put("groupList", groupList);
                    logProps.put("remoteHomeDir", remoteHomeDir);
                    logProps.put("tsRemoteHomeDir", tsRemoteHomeDir);
                    logProps.put(" msExchArchiveDatabaseLink", archiveDB);
                    logProps.put("msExchArchiveAddress", archiveDomain);
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (String)objectName, (String)this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    audit_info.put("objectName", objectName);
                    if (props.get("manager") != null) {
                        audit_info.put("manager", manager);
                    }
                    prop = new Properties();
                    if (removeMemberOf) {
                        removeProps.put("isClearIfEmpty", (Object)removeMemberOf);
                    }
                    if (isLicenseExceeded) break block116;
                    try {
                        void var39_49;
                        StringBuffer message;
                        NativeError nativeError;
                        String CREATION_STATUS;
                        block117: {
                            ArrayList ouList;
                            block118: {
                                this.removeUnAuthorizedProps(customList);
                                this.checkRemovePropsSelected(removeProps);
                                this.fillProxyAddrMacroValues(removeProps, valuesList, samAccountName, userName, customList);
                                if (password == null && propList.size() == 0 && modifyList.size() == 0 && tsList.size() == 0 && winNTAttributeList.size() == 0 && groupList.size() == 0 && !removeMemberOf && removeProps != null && !removeProps.isEmpty()) {
                                    removeProps.put("HasRemoveProps", (Object)true);
                                }
                                CREATION_STATUS = "SUCCESS";
                                Object var39_46 = null;
                                if (distinguishedName.equals("")) {
                                    Properties domainDetails;
                                    ArrayList arrayList;
                                    String value;
                                    boolean isRemoveAllGroups = false;
                                    ArrayList<String> arrayList2 = new ArrayList<String>();
                                    arrayList2.add("distinguishedName");
                                    arrayList2.add("sAMAccountName");
                                    arrayList2.add("name");
                                    arrayList2.add("homeMDB");
                                    arrayList2.add("msExchHomeServerName");
                                    arrayList2.add("msExchArchiveDatabaseLink");
                                    arrayList2.add("msExchArchiveAddress");
                                    if (removeProps.containsKey("removeProxyAddresses")) {
                                        arrayList2.add("proxyAddresses");
                                    }
                                    if (removeProps.containsKey("removeMemberOf") && (value = (String)((ArrayList)removeProps.get("removeMemberOf")).get(0)).equalsIgnoreCase("true")) {
                                        isRemoveAllGroups = true;
                                        arrayList2.add("memberOf");
                                    }
                                    if ((arrayList = ADHandler.getObjectsWithOutListener((Properties)(domainDetails = ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId)), (String)defaultNamingContext, arrayList2, (String)searchString)) != null && arrayList.size() > 0) {
                                        Properties dnProp = (Properties)arrayList.get(0);
                                        distinguishedName = StrUtil.getString((Properties)dnProp, (String)"distinguishedName");
                                        samAccountName = StrUtil.getString((Properties)dnProp, (String)"sAMAccountName");
                                        fullName = StrUtil.getString((Properties)dnProp, (String)"name");
                                        if (removeProps.containsKey("removeProxyAddresses")) {
                                            this.checkAndRemovePrimaryProxyAddr(removeProps, dnProp);
                                        }
                                        if (removeProps.containsKey("removeMemberOf") && isRemoveAllGroups) {
                                            this.removeUnAuthorizedGroups(removeProps, dnProp, this.loginId, this.domainName);
                                        }
                                    } else {
                                        prop.setProperty("CREATION_STATUS", "SEVERE");
                                        prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.object_not_exist_access_denied"));
                                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                                        CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                                    }
                                }
                                if (removeProps != null && !removeProps.isEmpty()) {
                                    if (removeProps.containsKey("removeMemberOf")) {
                                        logProps.put("removeMemberOf", removeProps.get("removeMemberOf").toString());
                                    }
                                    if (removeProps.containsKey("removeProxyAddresses")) {
                                        logProps.put("removeProxyAddresses", removeProps.get("removeProxyAddresses").toString());
                                    }
                                }
                                ouList = (ArrayList)this.authorizedDomainOUHash.get(this.domainName);
                                if (password == null && propList.size() <= 0 && modifyList.size() <= 0 && tsList.size() <= 0 && winNTAttributeList.size() <= 0 && groupList.size() <= 0 && customList.size() <= 0 && !removeMemberOf && removeProps.size() <= 0) break block117;
                                mgmtLog.log(Level.INFO, "propList after authorize check " + propList);
                                logProps.put("customList", customList);
                                if (ouList != null && ouList.size() != 0) break block118;
                                NativeError error = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), (String)password, propList, modifyList, tsList, winNTAttributeList, groupList, (Properties)removeProps);
                                prop = this.getBulkUserErrorMessage(this.domainName, searchString, groupList, error, userName, distinguishedName);
                                CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                                if (CREATION_STATUS.equalsIgnoreCase("SEVERE") || customList.isEmpty()) break block117;
                                NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)defaultNamingContext, (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), null, customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                                break block117;
                            }
                            for (int i2 = 0; i2 < ouList.size(); ++i2) {
                                NativeError error = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)ouList.get(i2)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), (String)password, propList, modifyList, tsList, winNTAttributeList, groupList, (Properties)removeProps);
                                prop = this.getBulkUserErrorMessage(this.domainName, searchString, groupList, error, userName, distinguishedName);
                                CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                                if (CREATION_STATUS.equalsIgnoreCase("SEVERE")) continue;
                                if (customList.isEmpty()) break;
                                NativeError customError = ADHandler.searchAndModifyUser((String)this.domainName, (Long)this.loginId, (String)((String)ouList.get(i2)), (String)searchString, (String)StrUtil.getContainerDNFromDN((String)distinguishedName), null, customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                                break;
                            }
                        }
                        if (password == null) {
                            password = "";
                        }
                        mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
                        prop.setProperty("userName", userName);
                        prop.setProperty("logonName", samAccountName);
                        prop.setProperty("password", password);
                        ArrayList aceList = null;
                        if (objectName.equals("")) {
                            HDTAuditUtil.updateAuditData((Long)object_id, (String)samAccountName, (String)"OBJECT_NAME", (DataObject)auditDataObj);
                            objectName = samAccountName;
                            audit_info.put("objectName", samAccountName);
                        }
                        if (CREATION_STATUS.equalsIgnoreCase("SEVERE")) break block115;
                        mgmtLog.log(Level.INFO, "Search String :(sAMAccountName=" + samAccountName + ")");
                        System.out.println("Creation status is not severe (sAMAccountName=" + samAccountName + ")");
                        if (this.checkSelected("homeDirectory") && distinguishedName != null && !distinguishedName.equals("")) {
                            aceList = UserPermissionsHandler.getInstance().getDefaultACEList(null, distinguishedName, this.domainName);
                            if (!remoteHomeDir.equals("") && remoteHomeDir.startsWith("\\")) {
                                try {
                                    nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)remoteHomeDir, null, (String)distinguishedName, (ArrayList)aceList, (long)0x20000000L);
                                    AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)prop, (NativeError)nativeError, (String)"homeDir");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (this.checkSelected("tsHomeDir") && distinguishedName != null && !distinguishedName.equals("")) {
                            aceList = UserPermissionsHandler.getInstance().getDefaultACEList(null, distinguishedName, this.domainName);
                            if (!tsRemoteHomeDir.equals("") && tsRemoteHomeDir.startsWith("\\")) {
                                try {
                                    nativeError = ADHandlerForMgmt.createFolder((String)this.domainName, (Long)this.loginId, (String)tsRemoteHomeDir, null, (String)distinguishedName, (ArrayList)aceList, (long)0x20000000L);
                                    AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)this.rb, (String)this.domainName, (Properties)prop, (NativeError)nativeError, (String)"tsHomeDir");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        try {
                            if (props.get("preventDeletion") != null) {
                                Properties grpList = new Properties();
                                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                                grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                                grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                if (((Boolean)props.get("preventDeletion")).booleanValue()) {
                                    grpList.put("ATTRIB_VALUE", "true");
                                    String rootName = StrUtil.getContainerDNFromDN((String)distinguishedName);
                                    this.updatePreventDeletion(distinguishedName, "add");
                                    if (!rootName.equalsIgnoreCase(defaultNamingContext)) {
                                        this.updateParent(rootName);
                                    }
                                } else {
                                    grpList.put("ATTRIB_VALUE", "false");
                                    this.updatePreventDeletion(distinguishedName, "delete");
                                }
                                propList.add(grpList);
                                prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                                prop.setProperty("CREATION_STATUS", "SUCCESS");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                            }
                        }
                        catch (Exception e) {
                            prop.setProperty("CREATION_MESSAGE", e.getMessage());
                            prop.setProperty("CREATION_STATUS", "SEVERE");
                            prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                        }
                        if (this.checkSelected("name") && userName != null && !userName.equals("")) {
                            mgmtLog.log(Level.INFO, "Modifying Name Attribute :" + userName + " for the User : " + distinguishedName);
                            try {
                                ADHandlerForMgmt.modifyUserFullName((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)userName, null);
                                fullName = userName;
                                distinguishedName = StrUtil.updateFullNameToExistingDN((String)distinguishedName, (String)fullName);
                                Properties nameProp = new Properties();
                                nameProp.put("ATTRIB_LDAP_NAME", "name");
                                nameProp.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.full_name"));
                                nameProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                                nameProp.put("ATTRIB_VALUE", userName);
                                propList.add(nameProp);
                                prop.setProperty("CREATION_STATUS", "SUCCESS");
                                prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.admin.gen_settgs.connection.statmsg.successfully_updated"));
                                prop.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
                            }
                            catch (LocalizedException le) {
                                le.printStackTrace();
                                message = new StringBuffer();
                                if (prop.getProperty("CREATION_MESSAGE") != null) {
                                    message.append(prop.getProperty("CREATION_MESSAGE"));
                                    if (message.length() > 0) {
                                        message.append(" , ");
                                    }
                                }
                                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_modifying_fullname"), le.getMessage(this.rb)));
                                prop.setProperty("CREATION_MESSAGE", message.toString());
                                prop.setProperty("CREATION_STATUS", "SEVERE");
                                prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((this.checkSelected("msExchArchiveDatabaseLink") || this.checkSelected("msExchArchiveAddress") && distinguishedName != null && !distinguishedName.equals("")) && var39_49 != null && var39_49.size() > 0) {
                            Properties exProp = (Properties)var39_49.get(0);
                            String mailBoxServer = StrUtil.getString((Properties)exProp, (String)"msExchHomeServerName");
                            String homeMDB = StrUtil.getString((Properties)exProp, (String)"homeMDB");
                            String archDb = StrUtil.getString((Properties)exProp, (String)"msExchArchiveDatabaseLink");
                            String archDomain = StrUtil.getString((Properties)exProp, (String)"msExchArchiveAddress");
                            Integer exchVersion = ExchangeUtil.getExchangeServerType((String)mailBoxServer);
                            if (!archiveDB.equals("") || !archiveDomain.equals("")) {
                                if (exchVersion >= 2010) {
                                    boolean isRemote = false;
                                    if (!archiveDomain.equals("")) {
                                        isRemote = true;
                                    }
                                    if (archDb.equals("") && archDomain.equals("")) {
                                        mgmtLog.log(Level.INFO, "Creating archive mailbox for the User : " + distinguishedName);
                                        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailBoxServer);
                                        String msg = "";
                                        msg = ADHandler.enableArchiveMailbox((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)archiveDB, (String)archiveDomain, (Properties)exchangeServerDetails, (boolean)isRemote);
                                        if (msg.length() > 0) {
                                            prop.setProperty("CREATION_MESSAGE", msg);
                                            prop.setProperty("CREATION_STATUS", "WARNING");
                                            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                            prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                        }
                                    } else {
                                        String msg = MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_create_archive"), this.rb.getString(distinguishedName));
                                        prop.setProperty("CREATION_MESSAGE", msg);
                                        prop.setProperty("CREATION_STATUS", "WARNING");
                                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                        prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                    }
                                } else {
                                    String msg = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_archive_mail"), FcLayoutUtil.getDisplayNameFromDN((String)this.rb.getString(homeMDB)));
                                    prop.setProperty("CREATION_MESSAGE", msg);
                                    prop.setProperty("CREATION_STATUS", "WARNING");
                                    prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                    prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                }
                            }
                        }
                        if (!this.checkSelected("ouName") || distinguishedName.equals("")) break block115;
                        String OUName = props.getProperty("OUName");
                        if (OUName != null && !OUName.equals("")) {
                            String newdistinguishedName;
                            String processedOUName;
                            String oldDistinguishedName = null;
                            boolean isCreateNewOUActionAuthorized = false;
                            if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)DelegationUtil.CREATE_OU_ACTION_ID)) {
                                isCreateNewOUActionAuthorized = true;
                            }
                            if ((processedOUName = MgmtUtil.checkAndCreateParent(this.domainName, OUName, this.loginId, isCreateNewOUActionAuthorized)) != null) {
                                OUName = processedOUName;
                            } else {
                                mgmtLog.log(Level.INFO, "Seems given dn format is not valid DN or logged user doesn't have to create new option, so Move to container option might be fail " + isCreateNewOUActionAuthorized);
                            }
                            if (fullName.equals("")) {
                                fullName = StrUtil.getNameFromDN((String)distinguishedName);
                            }
                            if (distinguishedName.equals(newdistinguishedName = "CN=" + fullName + "," + OUName)) break block115;
                            oldDistinguishedName = newdistinguishedName;
                            try {
                                mgmtLog.log(Level.INFO, "Move container option selected - SourceDN " + distinguishedName + " Destination DN : " + OUName);
                                ADHandlerForMgmt.moveObject((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (String)OUName);
                                prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
                                prop.setProperty("CREATION_STATUS", "SUCCESS");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                                ArrayList<String> moveUserAudit = new ArrayList<String>();
                                if (oldDistinguishedName != null) {
                                    String ouname = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
                                    String movedFrom = "<B>" + this.rb.getString("admp.mgmt.common.text.move_from") + " : </B><br/>" + ouname;
                                    ouname = DirectoryObjectUtil.getOUNameFromDN((String)oldDistinguishedName);
                                    String movedTo = "<br/><B>" + this.rb.getString("admp.mgmt.common.text.move_to") + " : </B><br/>" + ouname;
                                    moveUserAudit.add(movedFrom);
                                    moveUserAudit.add(movedTo);
                                }
                                if (!moveUserAudit.isEmpty()) {
                                    Properties movedList = new Properties();
                                    movedList.put("ATTRIB_LDAP_NAME", "container");
                                    movedList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                                    movedList.put("ATTRIB_VALUE", moveUserAudit);
                                    propList.add(movedList);
                                }
                                break block115;
                            }
                            catch (LocalizedException le) {
                                le.printStackTrace();
                                StringBuffer message2 = new StringBuffer();
                                if (prop.getProperty("CREATION_MESSAGE") != null) {
                                    message2.append(prop.getProperty("CREATION_MESSAGE"));
                                    if (message2.length() > 0) {
                                        message2.append(" , ");
                                    }
                                }
                                message2.append(MessageFormat.format(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_moving_objects"), le.getMessage(this.rb)));
                                prop.setProperty("CREATION_MESSAGE", message2.toString());
                                prop.setProperty("CREATION_STATUS", "SEVERE");
                                prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block115;
                        }
                        mgmtLog.log(Level.INFO, "OUName is selected as toBeUpdateAttributeList but value might not be provided in csv file or HDT is not authorized to use this OU");
                        message = new StringBuffer();
                        if (prop.getProperty("CREATION_MESSAGE") != null) {
                            message.append(prop.getProperty("CREATION_MESSAGE"));
                            if (message.length() > 0) {
                                message.append(" , ");
                            }
                        }
                        message.append(this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.statmsg.error_unauth_OU"));
                        prop.setProperty("CREATION_MESSAGE", message.toString());
                        prop.setProperty("CREATION_STATUS", "SEVERE");
                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        prop.setProperty("CREATION_MESSAGE", e.getMessage());
                        prop.setProperty("CREATION_STATUS", "SEVERE");
                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    }
                }
                prop.put("USER_INDEX", userIndex);
                if (groupList != null && !groupList.isEmpty()) {
                    Properties grpList = new Properties();
                    grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                    grpList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                    grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                    grpList.put("ATTRIB_VALUE", groupList);
                    propList.add(grpList);
                }
                if (password != null && !password.equals("")) {
                    Properties pwdProps = new Properties();
                    pwdProps.put("ATTRIB_LDAP_NAME", "password");
                    pwdProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.password"));
                    pwdProps.put("ATTRIB_VALUE", password);
                    propList.add(pwdProps);
                }
                if (archiveDB != null && !archiveDB.equals("")) {
                    Properties arcDBList = new Properties();
                    arcDBList.put("ATTRIB_LDAP_NAME", "msExchArchiveDatabaseLink");
                    arcDBList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_database"));
                    arcDBList.put("ATTRIB_VALUE", archiveDB);
                    propList.add(arcDBList);
                }
                if (archiveDomain != null && !archiveDomain.equals("")) {
                    Properties arcDomainList = new Properties();
                    arcDomainList.put("ATTRIB_LDAP_NAME", "msExchArchiveAddress");
                    arcDomainList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.text.archive_domain"));
                    arcDomainList.put("ATTRIB_VALUE", archiveDomain);
                    propList.add(arcDomainList);
                }
                if (groupList != null && groupList.isEmpty() && removeMemberOf) {
                    Properties grpMemberOfList = new Properties();
                    grpMemberOfList.put("ATTRIB_LDAP_NAME", "memberOf");
                    grpMemberOfList.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.member_of"));
                    grpMemberOfList.put("ATTRIB_VALUE", "");
                    propList.add(grpMemberOfList);
                }
                if (removeProps != null && !removeProps.isEmpty()) {
                    Properties hdtRemoveProps = new Properties();
                    if (removeProps.containsKey("removeMemberOf")) {
                        hdtRemoveProps.put("ATTRIB_LDAP_NAME", "removeMemberOf");
                        hdtRemoveProps.put("ATTRIB_DISP_NAME", "admp.mgmt.user_mgmt.grp_attribs.input.remove_frm_grp");
                        ArrayList arrayList = (ArrayList)removeProps.get("removeMemberOf");
                        if (arrayList.contains("true")) {
                            hdtRemoveProps.put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                        } else {
                            hdtRemoveProps.put("ATTRIB_VALUE", removeProps.get("removeMemberOf").toString());
                        }
                        propList.add(hdtRemoveProps);
                    }
                    hdtRemoveProps = new Properties();
                    if (removeProps.containsKey("removeProxyAddresses")) {
                        hdtRemoveProps.put("ATTRIB_LDAP_NAME", "removeProxyAddresses");
                        hdtRemoveProps.put("ATTRIB_DISP_NAME", "admp.mgmt.csv_import.common.text.remove_proxy_addresses");
                        ArrayList arrayList = (ArrayList)removeProps.get("removeProxyAddresses");
                        if (arrayList.contains("true")) {
                            hdtRemoveProps.put("ATTRIB_VALUE", "admp.mgmt.user_mgmt.grp_attribs.input.clear_existing_groups");
                        } else {
                            hdtRemoveProps.put("ATTRIB_VALUE", removeProps.get("removeProxyAddresses").toString());
                        }
                        propList.add(hdtRemoveProps);
                    }
                }
                if (this.errorList != null && !this.errorList.isEmpty()) {
                    void var39_55;
                    Set keys = this.errorList.keySet();
                    String string = "";
                    for (String key : keys) {
                        String string2 = (String)var39_55 + (String)this.errorList.get(key);
                    }
                    String message = MessageFormat.format(this.rb.getString("admp.mgmt.csv_import.common.statmsg.attributes_not_updated_successfully"), keys);
                    message = message + (String)var39_55;
                    prop.setProperty("CREATION_STATUS", "SEVERE");
                    prop.setProperty("CREATION_MESSAGE", message);
                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                if (prop.getProperty("CREATION_MESSAGE") == null) {
                    prop.setProperty("CREATION_STATUS", "SEVERE");
                    prop.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.csv_import.common.statmsg.no_changes_done_on_attribute"));
                    prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                }
                for (Hashtable hashtable2 : customList) {
                    hashtable2.put("ATTRIB_VALUE_COUNT", 1L);
                }
                TechAuditAPI.getInstance().auditUserModification(this.loginId, this.rb.getString("admp.mgmt.csv_imp.mod_users_attribs.mgmtname.mod_user_csv"), objectName, this.domainName, propList, modifyList, winNTAttributeList, tsList, customList, prop.getProperty("CREATION_MESSAGE"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                this.addRow(prop);
                break block119;
            }
            if (password == null) {
                password = "";
            }
            prop.setProperty("CREATION_STATUS", "WARNING");
            prop.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.statmsg.could_not_create_license_level_exceeded"), LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers")));
            prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
            prop.put("USER_INDEX", userIndex);
            prop.setProperty("userName", userName);
            prop.setProperty("logonName", samAccountName);
            prop.setProperty("password", password);
            this.addRow(prop);
        }
        String objectOUName = DirectoryObjectUtil.getOUNameFromDN((String)distinguishedName);
        audit_info.put("OUName", objectOUName);
        audit_info.put("password", password);
        audit_info.put("manager", manager);
        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
        mgmtLog.log(Level.INFO, "After User Creation");
    }

    protected void checkAndRemovePrimaryProxyAddr(Properties removeProps, Properties dnProp) {
        try {
            ArrayList valueList = (ArrayList)removeProps.get("removeProxyAddresses");
            ArrayList adValueList = (ArrayList)dnProp.get("proxyAddresses");
            if (adValueList == null || adValueList.isEmpty()) {
                return;
            }
            ArrayList<String> toADList = new ArrayList<String>();
            for (Object strObj : adValueList) {
                String adVal = (String)strObj;
                if (adVal.contains("SMTP")) continue;
                for (Object str : valueList) {
                    String userVal = (String)str;
                    if (!userVal.equalsIgnoreCase(adVal) && !userVal.equalsIgnoreCase("true")) continue;
                    toADList.add(adVal);
                }
            }
            removeProps.put("removeProxyAddresses", toADList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void removeUnAuthorizedGroups(Properties removeProps, Properties dnProp, Long loginId, String domainName) {
        try {
            ArrayList adValueList = (ArrayList)dnProp.get("memberOf");
            if (adValueList == null || adValueList.isEmpty()) {
                return;
            }
            ArrayList dnList = new ArrayList();
            for (Object dnHashObj : adValueList) {
                Hashtable dnHash = (Hashtable)dnHashObj;
                dnList.add(dnHash.get("distinguishedName"));
            }
            ArrayList unAuthList = GroupHandler.getUnAuthorisedGroups((String)domainName, (Long)loginId, dnList);
            if (unAuthList != null && !unAuthList.isEmpty()) {
                dnList.removeAll(unAuthList);
                removeProps.put("removeMemberOf", dnList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void checkRemovePropsSelected(Properties removeProps) {
        if (this.validSelected != null) {
            boolean valuePresent = false;
            if (removeProps.containsKey("removeMemberOf")) {
                for (String selectedLdap : this.validSelected) {
                    if (!selectedLdap.equalsIgnoreCase("removeMemberOf")) continue;
                    valuePresent = true;
                    break;
                }
                if (!valuePresent) {
                    removeProps.remove("removeMemberOf");
                }
            }
            valuePresent = false;
            if (removeProps.containsKey("removeProxyAddresses")) {
                for (String selectedLdap : this.validSelected) {
                    if (!selectedLdap.equalsIgnoreCase("removeProxyAddresses")) continue;
                    valuePresent = true;
                    break;
                }
                if (!valuePresent) {
                    removeProps.remove("removeProxyAddresses");
                }
            }
        }
    }

    protected void fillProxyAddrMacroValues(Properties removeProps, ArrayList valueList, String samAccountName, String userName, ArrayList customList) {
        try {
            ArrayList<String> filledList = new ArrayList<String>();
            ArrayList proxyValList = (ArrayList)removeProps.get("removeProxyAddresses");
            if (proxyValList == null || proxyValList.isEmpty()) {
                return;
            }
            for (Object strObj : proxyValList) {
                String proxyVal = (String)strObj;
                if (proxyVal.equalsIgnoreCase("true")) {
                    filledList.add("true");
                    continue;
                }
                String filledValue = FormatClientUtil.getFormatValue(this.domainName, proxyVal, valueList, samAccountName, userName, customList);
                filledList.add(filledValue);
            }
            removeProps.put("removeProxyAddresses", filledList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeUnAuthorizedProps(ArrayList propList) throws Exception {
        if (this.validSelected != null) {
            ArrayList<String> selectedProps = new ArrayList<String>();
            for (String string : this.validSelected) {
                selectedProps.add(string);
            }
            for (int i = 0; i < propList.size(); ++i) {
                Hashtable hash = (Hashtable)propList.get(i);
                String ldapName = (String)hash.get("ATTRIB_LDAP_NAME");
                if (selectedProps.contains(ldapName)) {
                    Long actionId = (Long)hash.get("MODIFY_ID");
                    if (this.isWorkflowMode || actionId == null || ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)actionId)) continue;
                    throw new Exception(this.rb.getString("client.csv.CSVUserListener.the_attribute") + " " + ldapName + " " + this.rb.getString("client.csv.CSVUserListener.is_not_authorized_for_this_user"));
                }
                mgmtLog.log(Level.INFO, "Unchecked Attribute in proplist : " + ldapName);
                propList.remove(i);
                --i;
            }
        }
    }

    @Override
    public void addRow(Properties prop) {
        AddUserHandler.getInstance().updateCreationStatus(this.rb, prop);
        this.updateUI(prop);
    }

    protected void updateOutList() {
        if (this.updateList.size() > 0) {
            mgmtLog.log(Level.INFO, "Modify CSV Update Count : " + this.updateList.size());
            for (int i = 0; i < this.updateList.size() && i < 25; ++i) {
                this.out.write((String)this.updateList.get(i));
                this.out.flush();
            }
            this.updateList.clear();
        }
    }

    private void updateUI(Properties prop) {
        Long userIndex = (Long)prop.get("USER_INDEX");
        ++this.updatedCount;
        String message = "<script> updateUI('" + userIndex.toString() + "','" + prop.getProperty("CREATION_MESSAGE") + "','" + prop.getProperty("CREATION_STATUS") + "')</script>";
        if (this.out != null && !this.out.checkError() && !this.isCompleted) {
            this.updateOutList();
            if (this.updatedCount <= 25) {
                this.out.write(message);
            }
            this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
            this.out.flush();
        } else {
            this.updateList.add(message);
        }
    }

    protected void reloadUI() {
        try {
            if (this.out != null && !this.out.checkError() && this.isCompleted) {
                this.out.write("<script>window.location.href='CSVUserModification.do?methodToCall=bulkUser&selectedTab=admin&operation=ShowResult'</script>");
                this.out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void controlUI(PrintWriter o) {
        if (this.isCompleted) {
            return;
        }
        this.out = o;
        while (!this.isCompleted) {
            try {
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.out.write(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occurred_message"), e.getMessage()));
            }
        }
        boolean check = true;
        try {
            if (this.out == null || this.out.checkError() || !this.isCompleted) {
                check = false;
            }
        }
        catch (Exception e) {
            check = false;
            e.printStackTrace();
        }
        if (check) {
            try {
                this.updateOutList();
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.reloadUI();
        this.out = null;
    }

    public Properties getBulkUserErrorMessage(String domainName, String searchString, ArrayList groupList, NativeError errHdlr, String userName, String distinguishedName) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        Hashtable errors = errHdlr.getErrors();
        if (errors != null) {
            Enumeration e = errors.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                message = errHdlr.getErrorMessage((Object)key, this.rb);
                errorSeverity = errHdlr.getSeverityLevel((Object)key);
                if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                    statusProps.setProperty("CREATION_STATUS", errorSeverity);
                    statusProps.setProperty("CREATION_MESSAGE", message);
                    statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                    statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                    return statusProps;
                }
                messageBuilder.append(message);
            }
        }
        if (this.invalidGroups != null && this.invalidGroups.size() != 0) {
            StringBuilder invalidGroupsStr = new StringBuilder();
            for (int index = 0; index < this.invalidGroups.size(); ++index) {
                if (index > 0) {
                    invalidGroupsStr.append(", ");
                }
                invalidGroupsStr.append((String)this.invalidGroups.get(index));
            }
            messageBuilder.append(" " + MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_invalid_groups"), invalidGroupsStr.toString()));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", messageBuilder.toString());
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.common.statmsg.successfully_updated"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    protected boolean checkSelected(String attributeName) {
        boolean result = false;
        if (this.validSelected != null) {
            for (int i = 0; i < this.validSelected.length; ++i) {
                if (!attributeName.equalsIgnoreCase(this.validSelected[i])) continue;
                result = true;
            }
        }
        return result;
    }

    @Override
    protected boolean canUpdate(String attributeName) {
        if (this.validSelectedValues != null) {
            for (int k = 0; k < this.validSelectedValues.length; ++k) {
                if (!this.validSelectedValues[k].equalsIgnoreCase(attributeName)) continue;
                return false;
            }
        }
        return true;
    }

    protected void sendSysLogs(Hashtable logProps, Integer reportActionId, String status, String objTitle, AdventNetResourceBundle rb) {
        try {
            ArrayList customList;
            ArrayList tsList;
            ArrayList winNTAttributeList;
            ArrayList modifyList;
            DataObject reportObj = CategoryHandler.getReportDetails((Integer)reportActionId);
            Long reportActId = (Long)reportObj.getFirstRow("ADSMReports").get("ACTION_ID");
            Properties actionDetails = HDTAuditUtil.getActionDetails((Long)reportActId);
            JSONObject syslogMessage = new JSONObject();
            syslogMessage.put("ACTION", (Object)rb.getString((String)actionDetails.get("ACTION_CATEGORY")));
            syslogMessage.put(rb.getString("admp.mgmt.common.text.task"), (Object)rb.getString((String)actionDetails.get("ACTION_NAME")));
            syslogMessage.put(objTitle, logProps.get("userName"));
            syslogMessage.put(rb.getString("admp.mgmt.common.text.domain_name"), logProps.get("domainName"));
            ArrayList groupList = (ArrayList)logProps.get("groupList");
            if (!groupList.isEmpty()) {
                syslogMessage.put("memberOf", (Object)groupList);
            }
            String attribName = "";
            String attribValue = "";
            ArrayList propList = (ArrayList)logProps.get("propList");
            if (propList != null) {
                for (int i = 0; i < propList.size(); ++i) {
                    Hashtable prop = (Hashtable)propList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    if (attribName.equalsIgnoreCase("password")) {
                        attribValue = "********";
                    } else {
                        attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                        attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    }
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((modifyList = (ArrayList)logProps.get("modifyList")) != null) {
                for (int i = 0; i < modifyList.size(); ++i) {
                    Hashtable prop = (Hashtable)modifyList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((winNTAttributeList = (ArrayList)logProps.get("winNTAttributeList")) != null) {
                for (int i = 0; i < winNTAttributeList.size(); ++i) {
                    Hashtable prop = (Hashtable)winNTAttributeList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((tsList = (ArrayList)logProps.get("tsList")) != null) {
                for (int i = 0; i < tsList.size(); ++i) {
                    Hashtable prop = (Hashtable)tsList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if ((customList = (ArrayList)logProps.get("customList")) != null) {
                for (int i = 0; i < customList.size(); ++i) {
                    Hashtable prop = (Hashtable)customList.get(i);
                    attribName = prop.get("ATTRIB_LDAP_NAME").toString();
                    attribValue = prop.get("ATTRIB_VALUE").toString();
                    attribValue = CommonUtil.htmlEscapeForAuditReport((String)attribValue);
                    attribValue = CommonUtil.htmlDeEscape((String)attribValue);
                    syslogMessage.put(attribName, (Object)attribValue);
                }
            }
            if (status.contains(rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"))) {
                status = status.replace(rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot"), "");
            }
            syslogMessage.put(rb.getString("admp.common.text.status"), (Object)status);
            if (logProps.get("technicianName") != null) {
                syslogMessage.put("TechnicianName", logProps.get("technicianName"));
            } else {
                syslogMessage.put("TechnicianName", (Object)"");
            }
            LogForwarderAPI.getInstance().sendMessage(syslogMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void triggerNotification(DataObject auditDataObj, ArrayList<Long> auditObjectIdList, Integer objectId, Hashtable resultList, Long loginId, Integer reportId, String domainName, AdventNetResourceBundle rb, ArrayList viewColumnList, ArrayList objectOUList) {
        MgmtNotificationListener notifyListener = new MgmtNotificationListener();
        notifyListener.triggerNotification(auditDataObj, auditObjectIdList, objectId, resultList, loginId, reportId, domainName, rb, viewColumnList, this.requestId, objectOUList);
    }

    private class Action
    extends Thread {
        private CSVUserListener modifyUserListener;
        private String hostId;
        private Integer objectId;

        public Action(CSVUserListener modifyUserListener, String hostId) {
            this.modifyUserListener = modifyUserListener;
            this.hostId = hostId;
            this.objectId = modifyUserListener instanceof CSVComputerListener ? Integer.valueOf(3) : (modifyUserListener instanceof CSVContactListener ? Integer.valueOf(4) : (modifyUserListener instanceof CSVGroupListener ? Integer.valueOf(2) : (modifyUserListener instanceof CSVOUListener ? Integer.valueOf(5) : Integer.valueOf(1))));
        }

        @Override
        public void run() {
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                String moduleName = "";
                boolean isSSP_API_request = false;
                if (CSVUserListener.this.isWorkflowMode && CSVUserListener.this.requestId != null) {
                    Long requestMode = WorkFlowUtil.getWorkFlowType((Long)CSVUserListener.this.requestId);
                    if (requestMode == 2L) {
                        moduleName = CSVUserListener.this.rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request");
                        isSSP_API_request = true;
                    } else {
                        moduleName = requestMode == 1L ? CSVUserListener.this.rb.getString("admp.auto.automation.heading.automation") : (requestMode == 0L ? CSVUserListener.this.rb.getString("admp.home.feature.heading.workflow") : "");
                    }
                }
                Long audit_id = -1L;
                audit_id = isSSP_API_request ? HDTAuditUtil.fillAuditDetails((Long)CSVUserListener.this.loginId, (String)this.hostId, (Integer)CSVUserListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)CSVUserListener.this.rb, (String)moduleName, (Long)CSVUserListener.this.requestId) : HDTAuditUtil.fillAuditDetails((Long)CSVUserListener.this.loginId, (String)this.hostId, (Integer)CSVUserListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)CSVUserListener.this.rb, (String)moduleName);
                boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"userMgmt");
                Properties p = HDTDomainHandler.getConfiguredValues((String)CSVUserListener.this.domainName, (Long)CSVUserListener.this.loginId);
                String defaultNamingContext = p.getProperty("DEFAULT_NAMING_CONTEXT");
                Hashtable customAttributesList = AddUserHandler.getInstance().getCustomAttributesList(CSVUserListener.this.userCreationID);
                Hashtable resultList = new Hashtable();
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                for (Hashtable hashtable : CSVUserListener.this.userDetailsList) {
                    String errorMsg;
                    if (CSVUserListener.this.stop) continue;
                    Hashtable<String, Long> audit_info = new Hashtable<String, Long>();
                    audit_info.put("audit_id", audit_id);
                    CSVUserListener.this.modifyObject(defaultNamingContext, hashtable, customAttributesList, isLicenseExceeded, audit_info, auditDataObj);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    String string = errorMsg = audit_info.get("error_msg") != null ? audit_info.get("error_msg").toString().toLowerCase() : "";
                    if (errorMsg.toLowerCase().contains(CSVUserListener.this.rb.getString("admp.admin.notification_profile.audit_obj_check.successfully_updated").toLowerCase())) {
                        auditObjectIdList.add((Long)audit_info.get("object_id"));
                    }
                    Hashtable<String, String> managerAndPwd = new Hashtable<String, String>();
                    managerAndPwd.put("password", audit_info.get("password") != null ? (String)audit_info.get("password") : "");
                    managerAndPwd.put("manager", audit_info.get("manager") != null ? (String)audit_info.get("manager") : "");
                    resultList.put(audit_info.get("objectName"), managerAndPwd);
                    String ouName = (String)audit_info.get("OUName");
                    if (objectOUList.contains(ouName)) continue;
                    objectOUList.add(ouName);
                }
                CSVUserListener.this.performADSync();
                boolean savePassword = PasswordUtil.getSavePasswordValue();
                if (!savePassword) {
                    if (CSVUserListener.this.csvHasPwd) {
                        AddUserHandler.getInstance();
                        String tempTableName = AddUserHandler.createBulkUserLayoutTempTable((Long)CSVUserListener.this.userCreationID);
                        AddUserHandler.getInstance();
                        AddUserHandler.copyIntoBulkUserLayoutTempTable((Long)CSVUserListener.this.userCreationID, null, (String)tempTableName);
                    }
                    AddUserHandler.getInstance();
                    AddUserHandler.clearPwdForBUM((Long)CSVUserListener.this.userCreationID);
                }
                this.modifyUserListener.isCompleted = true;
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    CSVUserListener.this.triggerNotification(auditDataObj, auditObjectIdList, this.objectId, resultList, CSVUserListener.this.loginId, CSVUserListener.this.reportId, CSVUserListener.this.domainName, CSVUserListener.this.rb, this.modifyUserListener.resultAttributeList, objectOUList);
                }
            }
            catch (Exception e) {
                mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
                this.modifyUserListener.isCompleted = true;
                this.modifyUserListener.errorMessage = e.getMessage();
                e.printStackTrace();
            }
        }
    }
}

