/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.layout.ComponentDataProvider;
import com.manageengine.ads.fw.layout.ComponentGenerator;
import com.manageengine.ads.fw.layout.customization.WidgetsHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPChartComponentDataProvider
implements ComponentDataProvider,
ComponentGenerator {
    private boolean isDataAvailable = false;

    public boolean isDataAvailable() {
        return this.isDataAvailable;
    }

    public JSONObject getDataModel(HttpServletRequest request, JSONObject params) {
        JSONObject dataModel = new JSONObject();
        try {
            Long contHeight;
            String domName;
            Long containerId = params.getLong("containerId");
            Long loginId = params.getLong("loginId");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            boolean noData = false;
            String domainName = params.getString("domainName");
            if (domainName != null && (domName = (String)DomainInfoCache.getInstance().getDomainDNSNameVsDomainName().get(domainName)) != null) {
                domainName = domName;
            }
            Long height = (contHeight = Long.valueOf(WidgetsHandler.getContainerAttribute((long)containerId, (String)"HEIGHT"))) != null && contHeight != -1L ? contHeight : 270L;
            Criteria c = new Criteria(Column.getColumn((String)"ADMPChartComponent", (String)"CONTAINER_ID"), (Object)containerId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartComponent", c);
            Row chartRow = dO.getFirstRow("ADMPChartComponent");
            Long chartId = (Long)chartRow.get("CHART_ID");
            String chartType = (String)chartRow.get("TYPE");
            dataModel.put("xAxis", (Object)new JSONObject().put("type", (Object)"category"));
            dataModel.put("yAxis", (Object)new JSONObject().put("title", (Object)new JSONObject().put("text", (Object)rb.getString("admp.common.text.count")).put("align", (Object)"middle")));
            dataModel.put("credits", (Object)new JSONObject().put("enabled", false));
            dataModel.put("tooltip", (Object)new JSONObject().put("useHTML", true).put("headerFormat", (Object)"<span style=\"display:inline-block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;max-width:35em;font-size: 10px\">{point.key}</span><br>"));
            dataModel.put("title", (Object)"");
            dataModel.put("chart", (Object)new JSONObject().put("type", (Object)chartType).put("height", (Object)height));
            JSONArray dataArray = new JSONArray();
            if (chartType.equals("pie")) {
                noData = true;
            } else {
                Criteria sc = new Criteria(Column.getColumn((String)"ADMPChartSeries", (String)"CHART_ID"), (Object)chartId, 0);
                DataObject sdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartSeries", sc);
                Iterator seriesRows = sdO.getRows("ADMPChartSeries");
                int seriesNum = 0;
                while (seriesRows.hasNext()) {
                    Row seriesRow = (Row)seriesRows.next();
                    Long seriesId = (Long)seriesRow.get("SERIES_ID");
                    String seriesName = rb.getString((String)seriesRow.get("SERIES_NAME"));
                    Criteria pc = new Criteria(Column.getColumn((String)"ADMPChartPoints", (String)"SERIES_ID"), (Object)seriesId, 0);
                    if (domainName != null) {
                        pc = pc.and(new Criteria(Column.getColumn((String)"ADMPChartPoints", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                    }
                    DataObject pdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartPoints", pc);
                    pdO.sortRows("ADMPChartPoints", new SortColumn[]{new SortColumn(Column.getColumn((String)"ADMPChartPoints", (String)"PRIORITY_ID"), true)});
                    if (!pdO.isEmpty()) {
                        Row pointRow = pdO.getFirstRow("ADMPChartPoints");
                        Integer count = pointRow.get("COUNT") != null ? (Integer)pointRow.get("COUNT") : 0;
                        dataArray.put((Object)new JSONArray().put((Object)seriesName).put((Object)count));
                    }
                    ++seriesNum;
                }
            }
            dataModel.put("series", (Object)new JSONArray().put((Object)new JSONObject().put("name", (Object)rb.getString("admp.common.text.count")).put("data", (Object)dataArray)));
            JSONObject bar = new JSONObject().put("dataLabels", (Object)new JSONObject().put("enabled", true));
            JSONObject column = new JSONObject().put("dataLabels", (Object)new JSONObject().put("enabled", true)).put("pointWidth", 150 / dataArray.length());
            dataModel.put("plotOptions", (Object)new JSONObject().put("bar", (Object)bar).put("column", (Object)column));
            dataModel.put("IS_EMBER", params.has("IS_EMBER") ? params.getBoolean("IS_EMBER") : false);
            if (dataArray.length() == 0) {
                noData = true;
            }
            this.isDataAvailable = !noData;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataModel;
    }

    public JSONObject generate(JSONObject dataModel, ADSResourceBundle ... rb) throws Exception {
        if (dataModel.has("IS_EMBER") && dataModel.getBoolean("IS_EMBER")) {
            dataModel.remove("IS_EMBER");
            JSONObject componentDetails = new JSONObject();
            componentDetails.put("NAME", (Object)"chart-component");
            componentDetails.put("responseType", (Object)"JSON");
            componentDetails.put("DATA", (Object)dataModel);
            return componentDetails;
        }
        dataModel.remove("IS_EMBER");
        return dataModel;
    }
}

