/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardAction;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardRefreshHandler;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardUtil;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.layout.ComponentDataProvider;
import com.manageengine.ads.fw.layout.ComponentGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPSimplifiedChartComponentDataProvider
implements ComponentDataProvider,
ComponentGenerator {
    private boolean isDataAvailable = false;
    private String[] seriesColors = new String[]{"#00B9C9", "#69D750", "#F46F8F", "#5099E2", "#7E7FF0", "#F9D254", "#D76969", "#FF8053", "#D4AF79", "#60A1D2", "#9EAFA5", "#C1BE3A", "#BD9ACD", "#87C9DA", "#F63E41"};
    static Logger out = Logger.getLogger("ADSLayoutLogger");

    public boolean isDataAvailable() {
        return this.isDataAvailable;
    }

    public JSONObject getDataModel(HttpServletRequest request, JSONObject params) {
        JSONObject dataModel = new JSONObject();
        try {
            String domainName;
            Long containerId = params.getLong("containerId");
            Long loginId = params.getLong("loginId");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            boolean noData = false;
            boolean isDefaultTabCont = DashboardUtil.checkIfDefaultTabContainer(loginId, containerId);
            ArrayList<Long> mgmtRepIds = new ArrayList<Long>(Arrays.asList(DashboardAction.mgmtRepIds));
            String string = domainName = params.has("domainName") ? params.getString("domainName") : null;
            if (domainName == null && DashboardUtil.checkIfDefaultTabContainer(loginId, containerId)) {
                HttpSession session = request.getSession();
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                domainName = authObject.getDefaultDomainName();
            }
            Criteria c = new Criteria(Column.getColumn((String)"ADMPChartComponent", (String)"CONTAINER_ID"), (Object)containerId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartComponent", c);
            Row chartRow = dO.getFirstRow("ADMPChartComponent");
            Long chartId = (Long)chartRow.get("CHART_ID");
            String chartType = (String)chartRow.get("TYPE");
            JSONArray reportErrorData = new JSONArray();
            JSONArray mgmtTileData = new JSONArray();
            JSONArray series = new JSONArray();
            JSONObject chart = new JSONObject().put("type", (Object)chartType);
            JSONObject plotOptions = new JSONObject().put("series", (Object)new JSONObject().put("cursor", (Object)"pointer").put("point", (Object)new JSONObject().put("events", (Object)new JSONObject().put("click", (Object)"placeHolder"))).put("animation", (Object)new JSONObject("{\"duration\": 500,\"easing\": \"easeOutBounce\"}")));
            Criteria sc = new Criteria(Column.getColumn((String)"ADMPChartSeries", (String)"CHART_ID"), (Object)chartId, 0);
            DataObject sdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartSeries", sc);
            if (!chartType.equals("pie")) {
                chart.put("zoomType", (Object)"y");
                JSONArray categories = new JSONArray();
                JSONArray customLegend = new JSONArray();
                Iterator seriesRows = sdO.getRows("ADMPChartSeries");
                if (chartType.equals("bar")) {
                    JSONArray seriesData = new JSONArray();
                    int seriesNum = 0;
                    while (seriesRows.hasNext()) {
                        Row seriesRow = (Row)seriesRows.next();
                        Long seriesId = (Long)seriesRow.get("SERIES_ID");
                        String seriesName = this.breakLongString(rb.getString((String)seriesRow.get("SERIES_NAME")));
                        Criteria pc = new Criteria(Column.getColumn((String)"ADMPChartPoints", (String)"SERIES_ID"), (Object)seriesId, 0);
                        if (domainName != null) {
                            pc = pc.and(new Criteria(Column.getColumn((String)"ADMPChartPoints", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                        }
                        DataObject pdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartPoints", pc);
                        pdO.sortRows("ADMPChartPoints", new SortColumn[]{new SortColumn(Column.getColumn((String)"ADMPChartPoints", (String)"PRIORITY_ID"), true)});
                        if (!pdO.isEmpty()) {
                            categories.put((Object)seriesName.replace("<", "&lt;").replace(">", "&gt;"));
                            Row pointRow = pdO.getFirstRow("ADMPChartPoints");
                            Long pointId = (Long)pointRow.get("POINT_ID");
                            Long reportId = (Long)pointRow.get("REPORT_ID");
                            Long generationId = (Long)pointRow.get("REPORT_GENERATION_ID");
                            Integer count = pointRow.get("COUNT") != null ? (Integer)pointRow.get("COUNT") : 0;
                            String url = this.getURL(reportId, generationId, pointId, domainName != null ? domainName : (String)pointRow.get("DOMAIN_NAME"));
                            seriesData.put((Object)new JSONObject().put("y", (Object)count).put("url", (Object)url).put("color", (Object)this.seriesColors[seriesNum]));
                            this.fillReportErrorData(reportErrorData, seriesName, (String)pointRow.get("MESSAGE"));
                            if (isDefaultTabCont && mgmtRepIds.contains(reportId)) {
                                this.fillMgmtData(mgmtTileData, pointId, count, generationId);
                            }
                            if (!dataModel.optBoolean("CHECK_FOR_COMPLETION", false) && DashboardRefreshHandler.getInstance().checkStatus(loginId, containerId, domainName, pointId)) {
                                dataModel.put("CHECK_FOR_COMPLETION", true).put("CHECK_INTERVAL", 1000);
                                dataModel.put("refreshReportId", (Object)pointId);
                                JSONObject ckParams = new JSONObject().put("pointId", (Object)pointId);
                                if (domainName != null) {
                                    ckParams.put("domainName", (Object)domainName);
                                }
                                dataModel.put("CHECK_PARAMS", (Object)ckParams);
                            }
                            JSONObject legend = new JSONObject();
                            legend.put("color", (Object)this.seriesColors[seriesNum]).put("name", (Object)seriesName).put("value", (Object)count).put("id", (Object)pointId).put("url", (Object)url);
                            customLegend.put((Object)legend);
                        }
                        ++seriesNum;
                    }
                    series.put((Object)new JSONObject().put("data", (Object)seriesData).put("maxPointWidth", 50));
                    dataModel.put("tooltip", (Object)new JSONObject().put("pointFormat", (Object)"{point.y}"));
                    plotOptions.put("bar", (Object)new JSONObject().put("dataLabels", (Object)new JSONObject().put("enabled", true)));
                    if (seriesData.length() == 0) {
                        noData = true;
                    }
                } else {
                    int seriesNum = 0;
                    while (seriesRows.hasNext()) {
                        Row seriesRow = (Row)seriesRows.next();
                        Long seriesId = (Long)seriesRow.get("SERIES_ID");
                        String seriesName = this.breakLongString(rb.getString((String)seriesRow.get("SERIES_NAME")));
                        JSONArray seriesData = new JSONArray();
                        Criteria pc = new Criteria(Column.getColumn((String)"ADMPChartPoints", (String)"SERIES_ID"), (Object)seriesId, 0);
                        if (domainName != null) {
                            pc = pc.and(new Criteria(Column.getColumn((String)"ADMPChartPoints", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                        }
                        DataObject pdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartPoints", pc);
                        pdO.sortRows("ADMPChartPoints", new SortColumn[]{new SortColumn(Column.getColumn((String)"ADMPChartPoints", (String)"PRIORITY_ID"), true)});
                        if (!pdO.isEmpty()) {
                            Row pointRow = pdO.getFirstRow("ADMPChartPoints");
                            categories.put((Object)"");
                            Long pointId = (Long)pointRow.get("POINT_ID");
                            Long reportId = (Long)pointRow.get("REPORT_ID");
                            Long generationId = (Long)pointRow.get("REPORT_GENERATION_ID");
                            Integer count = (Integer)pointRow.get("COUNT");
                            String url = this.getURL(reportId, generationId, pointId, domainName != null ? domainName : (String)pointRow.get("DOMAIN_NAME"));
                            seriesData.put((Object)new JSONObject().put("y", (Object)count).put("url", (Object)url));
                            series.put((Object)new JSONObject().put("name", (Object)seriesName.replace("<", "&lt;").replace(">", "&gt;")).put("data", (Object)seriesData).put("color", (Object)this.seriesColors[seriesNum]).put("maxPointWidth", 50));
                            this.fillReportErrorData(reportErrorData, seriesName, (String)pointRow.get("MESSAGE"));
                            if (isDefaultTabCont && mgmtRepIds.contains(reportId)) {
                                this.fillMgmtData(mgmtTileData, pointId, count, generationId);
                            }
                            if (!dataModel.optBoolean("CHECK_FOR_COMPLETION", false) && DashboardRefreshHandler.getInstance().checkStatus(loginId, containerId, domainName, pointId)) {
                                dataModel.put("CHECK_FOR_COMPLETION", true).put("CHECK_INTERVAL", 1000);
                                dataModel.put("refreshReportId", (Object)pointId);
                                JSONObject ckParams = new JSONObject().put("pointId", (Object)pointId);
                                if (domainName != null) {
                                    ckParams.put("domainName", (Object)domainName);
                                }
                                dataModel.put("CHECK_PARAMS", (Object)ckParams);
                            }
                            JSONObject legend = new JSONObject();
                            legend.put("color", (Object)this.seriesColors[seriesNum]).put("name", (Object)seriesName).put("value", (Object)count).put("id", (Object)pointId).put("url", (Object)url);
                            customLegend.put((Object)legend);
                        }
                        ++seriesNum;
                    }
                    dataModel.put("customLegendEnabled", true);
                    if (customLegend.length() == 0) {
                        noData = true;
                    }
                }
                JSONObject xAxis = new JSONObject().put("categories", (Object)categories).put("title", (Object)new JSONObject().put("text", chartRow.get("X_TITLE")));
                JSONObject yAxis = new JSONObject().put("title", (Object)new JSONObject().put("text", chartRow.get("Y_TITLE")));
                dataModel.put("xAxis", (Object)xAxis);
                dataModel.put("yAxis", (Object)yAxis);
                dataModel.put("customLegend", (Object)customLegend);
            }
            dataModel.put("title", (Object)new JSONObject().put("text", chartRow.get("TITLE")));
            dataModel.put("credits", (Object)new JSONObject().put("enabled", false));
            dataModel.put("chart", (Object)chart);
            dataModel.put("plotOptions", (Object)plotOptions);
            dataModel.put("series", (Object)series);
            if (mgmtTileData.length() > 0) {
                dataModel.put("mgmtTileData", (Object)mgmtTileData);
            }
            if (reportErrorData.length() > 0) {
                dataModel.put("reportErrorData", (Object)reportErrorData);
            }
            dataModel.put("IS_EMBER", params.has("IS_EMBER") ? params.getBoolean("IS_EMBER") : false);
            this.isDataAvailable = !noData;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataModel;
    }

    public JSONObject generate(JSONObject dataModel, ADSResourceBundle ... rb) throws Exception {
        if (dataModel.has("IS_EMBER") && dataModel.getBoolean("IS_EMBER")) {
            dataModel.remove("IS_EMBER");
            JSONObject componentDetails = new JSONObject();
            componentDetails.put("NAME", (Object)"simplified-chart-component");
            componentDetails.put("responseType", (Object)"JSON");
            componentDetails.put("DATA", (Object)dataModel);
            return componentDetails;
        }
        dataModel.remove("IS_EMBER");
        return dataModel;
    }

    private String breakLongString(String toSplit) {
        StringBuilder ret = new StringBuilder();
        int noBreakFor = 0;
        for (int i = 0; i < toSplit.length(); ++i) {
            char c = toSplit.charAt(i);
            noBreakFor = c != ' ' ? ++noBreakFor : 0;
            ret.append(c);
            if (noBreakFor <= 49) continue;
            ret.append(' ');
            noBreakFor = 0;
        }
        return ret.toString();
    }

    private String getURL(Long reportId, Long generationId, Long dashboardReportMapping, String domainName) {
        String url = null;
        try {
            if (reportId != null) {
                Criteria uc = new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)reportId, 0);
                DataObject udO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", uc);
                if (!udO.isEmpty()) {
                    url = (String)udO.getFirstRow("ADSMReports").get("URL");
                    url = url.replace("methodToCall=report", "methodToCall=showReportResult") + "&action=generatedReports&generationId=" + generationId;
                    if (domainName != null) {
                        url = url + "&domainName=" + domainName;
                    }
                    url = url + "&dashboardReportMapping=" + dashboardReportMapping;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    private void fillMgmtData(JSONArray mgmtTileData, Long pointId, Integer count, Long generationId) throws Exception {
        JSONObject mgmtData = new JSONObject().put("POINT_ID", (Object)pointId);
        if (count != null && count > 0) {
            mgmtData.put("COUNT", (Object)count);
        }
        if (generationId != null) {
            mgmtData.put("GEN_ID_STR", (Object)("&oldGenerationId=" + generationId));
        }
        mgmtTileData.put((Object)mgmtData);
    }

    private void fillReportErrorData(JSONArray reportErrorData, String reportName, String jsonString) throws Exception {
        if (jsonString == null) {
            return;
        }
        JSONArray reportErrors = new JSONArray(jsonString);
        reportErrorData.put((Object)new JSONObject().put("name", (Object)reportName).put("errors", (Object)reportErrors));
    }
}

