/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardRefreshHandler;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardUtil;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.i18n.I18N;
import com.manageengine.ads.fw.i18n.I18NUtil;
import com.manageengine.ads.fw.layout.CustomizationHandler;
import com.manageengine.ads.fw.layout.LayoutAction;
import com.manageengine.ads.fw.layout.LayoutBean;
import com.manageengine.ads.fw.layout.customization.TabsHandler;
import com.manageengine.ads.fw.layout.customization.WidgetsHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

public class DashboardAction
extends LayoutAction {
    public static final Long[] mgmtRepIds = new Long[]{3L, 1L, 201L, 104L, 14L};
    Logger logger = Logger.getLogger("ADSLayoutLogger");
    private static int checkInterval = 1000;
    private static final Long[] workFlowActions = new Long[]{21L, 22L, 24L, -1L, 43L, -2L, -3L, 52L, -4L, 5001L};
    private static final String[] wFDisplayNames = new String[]{"admp.workflow.layout.createrequest.category_single_user_creation", "admp.workflow.layout.createrequest.category_bulk_user_creation", "admp.reports.report_actions.create_request.options.modify_user", "admp.workflow.layout.createrequest.category_user_modification", "admp.workflow.layout.createrequest.category_single_group_creation", "admp.workflow.layout.createrequest.category_group_modification", "admp.workflow.layout.createrequest.category_computer_modification", "admp.workflow.layout.createrequest.category_single_contact_creation", "admp.workflow.layout.createrequest.category_contact_modification", "admp.workflow.actions.perm_mgmt.set_folder_permission"};
    private static final String[] wFLinks = new String[]{"ExecuteForm.do?selectedTab=workflow&methodToCall=init&operation=execution&templateCategoryId=5&mode=workflow", "BulkExecuteForm.do?selectedTab=workflow&methodToCall=init&templateCategoryId=5&mode=workflow", "ModifySingleUser.do?selectedTab=workflow&methodToCall=modifySingleUser&action=modifyUserList&mode=workflow", "WFModificationRequest.do?selectedTab=workflow&selectedTile=CreateRequest&methodToCall=showModifyRequest&catagoryId=1", "ExecuteForm.do?selectedTab=workflow&methodToCall=init&operation=execution&templateCategoryId=7&mode=workflow", "WFModificationRequest.do?selectedTab=workflow&selectedTile=CreateRequest&methodToCall=showModifyRequest&catagoryId=2", "WFModificationRequest.do?selectedTab=workflow&selectedTile=CreateRequest&methodToCall=showModifyRequest&catagoryId=3", "ExecuteForm.do?selectedTab=workflow&methodToCall=init&operation=execution&templateCategoryId=1&mode=workflow", "WFModificationRequest.do?selectedTab=workflow&selectedTile=CreateRequest&methodToCall=showModifyRequest&catagoryId=4", "WFModificationRequest.do?selectedTab=workflow&selectedTile=CreateRequest&methodToCall=showModifyRequest&requestId=5001&catagoryId=5"};
    private static final Integer[] wFActionHeadingIndex = new Integer[]{0, 0, 0, 0, 1, 1, 2, 3, 3, 4};
    private static final String[] wFLinkHeadings = new String[]{"admp.mgmt.fc_layout_common.text_user", "admp.mgmt.fc_layout_title.text_group", "admp.mgmt.fc_layout_common.text_computer", "admp.mgmt.fc_layout_common.text_contact", "usermanagement.set_folder_permissions.permission"};

    public ActionForward loadUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String loginName = ((ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT")).getLoginName();
            JSONObject userDetails = new JSONObject().put("loginId", (Object)loginId).put("loginName", (Object)loginName).put("userId", (Object)com.adventnet.sym.adsm.common.server.util.CommonUtil.getUserId((Long)loginId));
            response.getWriter().write(userDetails.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(null);
    }

    public ActionForward loadLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            if (params.optBoolean("isEmber")) {
                Long loginId = Long.parseLong(params.getString("loginId"));
                String locale = params.has("locale") ? params.getString("locale") : null;
                String layoutName = "Ember_Dashboard_" + loginId;
                ADSResourceBundle rb = locale != null ? I18N.getInstance().getBundle(I18NUtil.getLocale((String)locale)) : I18N.getInstance().getBundle(request);
                HttpSession session = request.getSession();
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                String status = "";
                Long layoutId = null;
                Long defaultTabId = null;
                Criteria statusCri = new Criteria(Column.getColumn((String)"ADMPDashboard", (String)"LOGIN_ID"), (Object)loginId, 0);
                DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPDashboard", statusCri);
                if (dO.isEmpty()) {
                    status = "reset";
                } else {
                    Row row = dO.getFirstRow("ADMPDashboard");
                    status = row.get("STATUS") != null ? (String)row.get("STATUS") : "";
                    layoutId = (Long)row.get("LAYOUT_ID");
                    defaultTabId = (Long)row.get("DEFAULT_TAB_ID");
                }
                if (status.equalsIgnoreCase("reset")) {
                    DashboardUtil.resetLayout(loginId, layoutId, authObject);
                } else if (status.equalsIgnoreCase("checkPermission")) {
                    DashboardUtil.checkPermission(loginId, layoutId, defaultTabId, authObject);
                } else if (status.equalsIgnoreCase("checkDomain")) {
                    DashboardUtil.checkDomain(loginId, layoutId, defaultTabId, authObject);
                } else if (status.equalsIgnoreCase("checkWorkflow")) {
                    DashboardUtil.checkWorkflow(loginId, layoutId, defaultTabId, authObject);
                }
                LayoutBean layoutBean = new LayoutBean();
                Boolean fillComponentData = Boolean.parseBoolean(request.getParameter("fillComponentData"));
                JSONObject layoutDetails = layoutBean.getLayoutDetails(params.getString("userId"), layoutName, rb, fillComponentData, request);
                JSONObject lhsData = layoutDetails.getJSONObject("LHSDATA");
                Long tabId = lhsData.optLong("TAB_ID", -1L);
                JSONObject lhsHeader = this.getLHSHeader(tabId, defaultTabId, params, request);
                if (lhsHeader != null) {
                    lhsData.put("HEADER", (Object)lhsHeader);
                    lhsData.put("IS_CUSTOMIZABLE", false);
                }
                layoutDetails.put("LHS_FOOTER", (Object)new JSONObject().put("component", (Object)"dashboard-footer"));
                if (authObject.getActionList().contains(DashboardUtil.CUSTOMIZATION_ACTION_ID)) {
                    layoutDetails.put("ENABLE_MANAGE_DASHBOARD", true);
                    layoutDetails.put("ENABLE_MANAGE_RHS", true);
                }
                if (WorkFlowUserHandler.isRequester((Long)loginId, (Boolean)false).booleanValue()) {
                    layoutDetails.put("TAB_RHS_CUSTOM_COMPONENT", (Object)"create-request-dropdown");
                }
                response.getWriter().write(layoutDetails.toString());
                return null;
            }
            return super.loadLayout(mapping, form, request, response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ActionForward loadComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject ret;
            String domainName;
            JSONObject layoutParams = new JSONObject(request.getParameter("params"));
            Long loginId = layoutParams.getLong("loginId");
            Long containerId = layoutParams.getLong("containerId");
            String string = domainName = layoutParams.has("domainName") ? layoutParams.getString("domainName") : null;
            if (domainName == null && DashboardUtil.checkIfDefaultTabContainer(loginId, containerId)) {
                HttpSession session = request.getSession();
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                domainName = authObject.getDefaultDomainName();
            }
            boolean isRefreshed = layoutParams.optBoolean("isRefreshed");
            boolean refreshInProgress = DashboardRefreshHandler.getInstance().checkStatus(loginId, containerId, domainName, null);
            if (isRefreshed || refreshInProgress) {
                if (isRefreshed) {
                    ArrayList reportMappings = DashboardUtil.getReportMappings(containerId, domainName);
                    DashboardRefreshHandler.getInstance().refreshContainer(loginId, containerId, domainName, reportMappings);
                }
                ret = new JSONObject().put("CHECK_FOR_COMPLETION", true).put("CHECK_INTERVAL", checkInterval);
                if (domainName != null) {
                    ret.put("CHECK_PARAMS", (Object)new JSONObject().put("domainName", (Object)domainName));
                }
            } else {
                return super.loadComponent(mapping, form, request, response);
            }
            response.getWriter().write(ret.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getCreateRequestLinks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONArray links = new JSONArray();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            ArrayList actionListForRequestor = WorkFlowUserHandler.getAllAuthorizedRequestTypesList((Long)loginId, (String)"");
            ArrayList subCategoryListForRequestor = WorkFlowUserHandler.getSubCategoryForRequestor((Long)loginId);
            if (actionListForRequestor != null && !actionListForRequestor.isEmpty()) {
                ArrayList<Integer> wFLinkHeadingAdded = new ArrayList<Integer>();
                for (int i = 0; i < workFlowActions.length; ++i) {
                    boolean addLink = false;
                    addLink = workFlowActions[i] > 0L ? actionListForRequestor.contains(workFlowActions[i]) : subCategoryListForRequestor.contains(workFlowActions[i].intValue() * -1);
                    if (!addLink) continue;
                    JSONObject link = new JSONObject();
                    link.put("DISPLAY_NAME", (Object)rb.getString(wFDisplayNames[i]));
                    link.put("URL", (Object)wFLinks[i]);
                    if (!wFLinkHeadingAdded.contains(wFActionHeadingIndex[i])) {
                        JSONObject heading = new JSONObject();
                        heading.put("DISPLAY_NAME", (Object)rb.getString(wFLinkHeadings[wFActionHeadingIndex[i]]));
                        heading.put("IS_HEADING", true);
                        links.put((Object)heading);
                        wFLinkHeadingAdded.add(wFActionHeadingIndex[i]);
                    }
                    links.put((Object)link);
                }
            }
            response.getWriter().write(links.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward refreshDomain(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            if (params.optBoolean("isRefreshed")) {
                String domainName;
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                String string = domainName = params.has("domainName") ? params.getString("domainName") : null;
                if (domainName == null) {
                    ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                    domainName = authObject.getDefaultDomainName();
                }
                if (params.has("containers")) {
                    JSONArray contianers = params.getJSONArray("containers");
                    for (int i = 0; i < contianers.length(); ++i) {
                        Long containerId = contianers.getLong(i);
                        ArrayList reportMappings = DashboardUtil.getReportMappings(containerId, domainName);
                        DashboardRefreshHandler.getInstance().refreshContainer(loginId, containerId, domainName, reportMappings);
                    }
                    JSONObject ret = new JSONObject().put("CHECK_FOR_COMPLETION", true);
                    response.getWriter().write(ret.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward refreshReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject ckParams;
            JSONObject ret;
            JSONObject layoutParams = new JSONObject(request.getParameter("params"));
            if (layoutParams.optBoolean("isRefreshed")) {
                String domainName;
                Long loginId = layoutParams.getLong("loginId");
                Long containerId = layoutParams.getLong("containerId");
                Long pointId = layoutParams.getLong("id");
                String string = domainName = layoutParams.has("domainName") ? layoutParams.getString("domainName") : null;
                if (domainName == null && DashboardUtil.checkIfDefaultTabContainer(loginId, containerId)) {
                    HttpSession session = request.getSession();
                    ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                    domainName = authObject.getDefaultDomainName();
                }
                ArrayList reportMappings = new ArrayList();
                Criteria pc = new Criteria(Column.getColumn((String)"ADMPChartPoints", (String)"POINT_ID"), (Object)pointId, 0);
                DataObject pdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartPoints", pc);
                Row pointRow = pdO.getFirstRow("ADMPChartPoints");
                HashMap<String, Object> hash = new HashMap<String, Object>();
                hash.put("reportId", ((Long)pointRow.get("REPORT_ID")).intValue());
                hash.put("dashboardReportMapping", pointId);
                if (pointRow.get("DOMAIN_NAME") != null) {
                    hash.put("domainName", (String)pointRow.get("DOMAIN_NAME"));
                }
                reportMappings.add(hash);
                DashboardRefreshHandler.getInstance().refreshContainer(loginId, containerId, domainName, pointId, reportMappings, true);
                ret = new JSONObject().put("CHECK_FOR_COMPLETION", true).put("CHECK_INTERVAL", checkInterval);
                ckParams = new JSONObject().put("pointId", (Object)pointId);
                if (domainName != null) {
                    ckParams.put("domainName", (Object)domainName);
                }
            } else {
                return super.loadComponent(mapping, form, request, response);
            }
            ret.put("CHECK_PARAMS", (Object)ckParams);
            response.getWriter().write(ret.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward checkRefreshCompletion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Long pointId;
            JSONObject params = new JSONObject(request.getParameter("params"));
            Long loginId = params.getLong("loginId");
            String domainName = params.has("domainName") ? params.getString("domainName") : null;
            Long containerId = params.has("containerId") ? Long.valueOf(params.getLong("containerId")) : null;
            Long l = pointId = params.has("pointId") ? Long.valueOf(params.getLong("pointId")) : null;
            if (DashboardRefreshHandler.getInstance().checkStatus(loginId, containerId, domainName, pointId)) {
                response.getWriter().write("{\"CHECK_FOR_COMPLETION\":true}");
            } else {
                response.getWriter().write("{\"CHECK_FOR_COMPLETION\":false}");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward loadContainers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject tabContainers;
            JSONObject params = new JSONObject(request.getParameter("params"));
            if (params.optBoolean("isEmber")) {
                ADSResourceBundle rb = I18N.getInstance().getBundle(request);
                LayoutBean layout = new LayoutBean();
                Long tabId = params.getLong("tabId");
                tabContainers = layout.getTabContainerDetails(tabId, rb);
                JSONObject lhsHeader = this.getLHSHeader(tabId, null, params, request);
                if (lhsHeader != null) {
                    tabContainers.put("HEADER", (Object)lhsHeader);
                    tabContainers.put("IS_CUSTOMIZABLE", false);
                }
            } else {
                return super.loadContainers(mapping, form, request, response);
            }
            response.getWriter().write(tabContainers.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONObject getLHSHeader(Long tabId, Long defaultTabId, JSONObject params, HttpServletRequest request) {
        JSONObject header = null;
        try {
            boolean exist = false;
            if (defaultTabId == null) {
                Long loginId = params.getLong("loginId");
                Criteria cri = new Criteria(Column.getColumn((String)"ADMPDashboard", (String)"LOGIN_ID"), (Object)loginId, 0);
                cri = cri.and(new Criteria(Column.getColumn((String)"ADMPDashboard", (String)"DEFAULT_TAB_ID"), (Object)tabId, 0));
                DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPDashboard", cri);
                if (!dO.isEmpty()) {
                    exist = true;
                }
            } else if (tabId.longValue() == defaultTabId.longValue()) {
                exist = true;
            }
            if (exist) {
                HttpSession session = request.getSession();
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                JSONObject data = new JSONObject();
                data.put("domains", (Object)authObject.getDomainListJSON());
                String domainName = null;
                domainName = params.has("domainName") ? params.getString("domainName") : (params.has("domainName_" + defaultTabId) ? params.getString("domainName_" + defaultTabId) : authObject.getDefaultDomainName());
                data.put("selectedDomain", (Object)domainName);
                data.put("tabContainers", (Object)DashboardAction.getTabContainers(tabId, false));
                Long loginId = params.getLong("loginId");
                ArrayList actions = authObject.getActionList(domainName);
                data.put("showDomainEdit", actions.contains(7000L));
                HashMap<Long, HashMap> mgmtValues = DashboardUtil.getDomainMgmtValues(tabId, mgmtRepIds, domainName, false);
                JSONArray managementValues = new JSONArray();
                for (int i = 0; i < mgmtRepIds.length; ++i) {
                    Long repId = mgmtRepIds[i];
                    HashMap valueMap = mgmtValues.get(repId);
                    if (valueMap == null) continue;
                    Long genId = (Long)valueMap.get("REPORT_GENERATION_ID");
                    JSONObject mgmtValue = new JSONObject();
                    JSONArray options = new JSONArray();
                    switch (repId.intValue()) {
                        case 3: {
                            mgmtValue.put("ICON", (Object)"icn-userlock-md");
                            mgmtValue.put("STYLE", (Object)"locked-user-box");
                            mgmtValue.put("DISPLAY_NAME", (Object)rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.locked_out_users"));
                            if (!actions.contains(1015L)) break;
                            String url = this.getMgmtURL("ModifyBulkUserListView.do?methodToCall=reportAction&reportId=1021&selectedTab=admin&oldResultTableName=ADSMUserReportResult&operation=reportAction", domainName);
                            JSONObject option = new JSONObject().put("DISPLAY_NAME", (Object)rb.getString("reports.reportAction.unLock")).put("URL", (Object)url);
                            options.put((Object)option);
                            break;
                        }
                        case 1: {
                            JSONObject option;
                            String url;
                            if (actions.contains(1046L)) {
                                url = this.getMgmtURL("ModifyBulkUserListView.do?methodToCall=reportAction&selectedTab=admin&oldResultTableName=ADSMUserReportResult&operation=reportAction&reportId=1026", domainName);
                                option = new JSONObject().put("DISPLAY_NAME", (Object)rb.getString("admp.reports.report_actions.create_request.options.delete_users")).put("URL", (Object)url);
                                options.put((Object)option);
                            }
                            if (actions.contains(1208L)) {
                                url = this.getMgmtURL("ModifyBulkUserListView.do?methodToCall=reportAction&selectedTab=admin&oldResultTableName=ADSMUserReportResult&operation=reportAction&reportId=1002", domainName);
                                option = new JSONObject().put("DISPLAY_NAME", (Object)rb.getString("admp.reports.report_actions.create_request.options.disable_users")).put("URL", (Object)url);
                                options.put((Object)option);
                            }
                            mgmtValue.put("ICON", (Object)"icn-user-inactive-md");
                            mgmtValue.put("STYLE", (Object)"inactive-user-box");
                            mgmtValue.put("DISPLAY_NAME", (Object)rb.getString("admp.reports.dashboard.report.inactive_user_30_days"));
                            break;
                        }
                        case 201: {
                            JSONObject option;
                            String url;
                            if (actions.contains(1200L)) {
                                url = this.getMgmtURL("ModifyBulkUserListView.do?methodToCall=reportAction&selectedTab=admin&reportId=2005&oldResultTableName=ADSMComputerReportResult&operation=reportAction", domainName);
                                option = new JSONObject().put("DISPLAY_NAME", (Object)rb.getString("admp.reports.report_actions.create_request.options.delete_computers")).put("URL", (Object)url);
                                options.put((Object)option);
                            }
                            if (actions.contains(1036L)) {
                                url = this.getMgmtURL("ModifyBulkUserListView.do?methodToCall=reportAction&selectedTab=admin&reportId=2004&oldResultTableName=ADSMComputerReportResult&operation=reportAction", domainName);
                                option = new JSONObject().put("DISPLAY_NAME", (Object)rb.getString("admp.reports.report_actions.create_request.options.disable_computers")).put("URL", (Object)url);
                                options.put((Object)option);
                            }
                            mgmtValue.put("ICON", (Object)"icn-computer-inactive-md");
                            mgmtValue.put("STYLE", (Object)"inactive-com-box");
                            mgmtValue.put("DISPLAY_NAME", (Object)rb.getString("admp.reports.dashboard.report.inactive_comp_30_days"));
                            break;
                        }
                        case 104: {
                            mgmtValue.put("ICON", (Object)"icn-group-md");
                            mgmtValue.put("STYLE", (Object)"group-member-box");
                            mgmtValue.put("DISPLAY_NAME", (Object)rb.getString("admp.reports.dashboard.report.group_without_member"));
                            if (!actions.contains(1052L)) break;
                            String url = this.getMgmtURL("ModifyBulkUserListView.do?methodToCall=reportAction&selectedTab=admin&reportId=4003&oldResultTableName=ADSMGroupReportResult&operation=reportAction", domainName);
                            JSONObject option = new JSONObject().put("DISPLAY_NAME", (Object)rb.getString("reports.reportAction.delete")).put("URL", (Object)url);
                            options.put((Object)option);
                            break;
                        }
                        case 14: {
                            mgmtValue.put("ICON", (Object)"icn-password-md");
                            mgmtValue.put("STYLE", (Object)"inactive-com-box");
                            mgmtValue.put("DISPLAY_NAME", (Object)rb.getString("admp.home.layout.report_name.soon_to_pwd_expire_users_30_days"));
                            if (!actions.contains(1012L)) break;
                            String url = this.getMgmtURL("ModifyBulkUserListView.do?methodToCall=reportAction&reportId=1019&selectedTab=admin&oldResultTableName=ADSMUserReportResult&operation=reportAction", domainName);
                            JSONObject option = new JSONObject().put("DISPLAY_NAME", (Object)rb.getString("admp.change_pwd.text.change_pwd")).put("URL", (Object)url);
                            options.put((Object)option);
                        }
                    }
                    if (options.length() == 1) {
                        mgmtValue.put("IS_SINGLE", true);
                    }
                    if (options.length() > 0) {
                        mgmtValue.put("OPTIONS", (Object)options);
                    } else {
                        mgmtValue.put("IS_SINGLE", true);
                    }
                    mgmtValue.put("POINT_ID", valueMap.get("POINT_ID"));
                    managementValues.put((Object)mgmtValue);
                }
                data.put("managementValues", (Object)managementValues);
                header = new JSONObject().put("component", (Object)"dashboard-header");
                header.put("data", (Object)data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return header;
    }

    private String getMgmtURL(String url, Long generationId, String domainName) {
        if (generationId != null && !url.equals("")) {
            url = url + "&oldGenerationId=" + generationId + "&domains=" + DomainUtil.getDefaultNamingContext((String)domainName);
        }
        return url;
    }

    private String getMgmtURL(String url, String domainName) {
        if (!url.equals("")) {
            url = url + "&domains=" + DomainUtil.getDefaultNamingContext((String)domainName);
        }
        return url;
    }

    public ActionForward addTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String tabName = request.getParameter("TAB_NAME");
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
            long tabId = TabsHandler.addTab((long)layoutId, (String)tabName);
            JSONArray tabDetails = TabsHandler.getLayoutTabsDetails((Long)layoutId, (Long)tabId, (ADSResourceBundle)I18N.getInstance().getBundle(request));
            response.getWriter().write(tabDetails.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject result = new JSONObject();
        try {
            long tabId = Long.valueOf(request.getParameter("TAB_ID"));
            String tabName = request.getParameter("TAB_NAME");
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
            TabsHandler.updateTab((long)layoutId, (long)tabId, (String)tabName);
            result.put("status", (Object)"Updated successfully");
            response.getWriter().write(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward removeTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            long tabId = Long.parseLong(request.getParameter("TAB_ID"));
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
            this.removeFromLayout("TABS", tabId, layoutId);
            JSONArray tabDetails = TabsHandler.getLayoutTabsDetails((Long)layoutId, null, (ADSResourceBundle)I18N.getInstance().getBundle(request));
            response.getWriter().write(tabDetails.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward removeComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject result = new JSONObject();
        long containerId = Long.parseLong(request.getParameter("CONTAINER_ID"));
        String side = request.getParameter("SIDE");
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
        if ("RHS".equals(side)) {
            this.removeFromLayout(side, containerId, layoutId);
            result.put("RHSDATA", (Object)new LayoutBean().getRHSContainerDetails(layoutId, I18N.getInstance().getBundle(request)));
        } else if ("LHS".equals(side)) {
            this.removeFromLayout(side, containerId, Long.parseLong(request.getParameter("TAB_ID")));
        }
        result.put("status", (Object)"Updated successfully");
        response.getWriter().write(result.toString());
        return null;
    }

    public void removeFromLayout(String side, Long child_id, Long parent_id) {
        try {
            String[] sides = new String[]{"RHS", "LHS", "TABS"};
            String[] parentColumn = new String[]{"LAYOUT_ID", "TAB_ID", "LAYOUT_ID"};
            String[] childColumn = new String[]{"CONTAINER_ID", "CONTAINER_ID", "TAB_ID"};
            String[] parentTable = new String[]{"ADSLayoutContainers", "ADSLayoutContainers", "ADSLayoutTabs"};
            String[] mappingTable = new String[]{"ADSLayoutRHS", "ADSTabVsContainer", "ADSLayoutLHS"};
            int index = -1;
            for (int i = 0; i < sides.length; ++i) {
                if (!side.equals(sides[i])) continue;
                index = i;
            }
            Criteria c = new Criteria(Column.getColumn((String)parentTable[index], (String)childColumn[index]), (Object)child_id, 0);
            c = c.and(new Criteria(Column.getColumn((String)parentTable[index], (String)"IS_CUSTOMIZABLE"), (Object)true, 0));
            DataObject contDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(parentTable[index], c);
            if (contDO.isEmpty()) {
                c = new Criteria(Column.getColumn((String)mappingTable[index], (String)parentColumn[index]), (Object)parent_id, 0);
                c = c.and(new Criteria(Column.getColumn((String)mappingTable[index], (String)childColumn[index]), (Object)child_id, 0));
            } else if (index == 2) {
                Criteria tabCri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)child_id, 0);
                DataObject tabDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSTabVsContainer", tabCri);
                Iterator tabConts = tabDO.getRows("ADSTabVsContainer");
                while (tabConts.hasNext()) {
                    Row contRow = (Row)tabConts.next();
                    Criteria contDelCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), contRow.get("CONTAINER_ID"), 0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(contDelCri);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(c);
            this.logger.log(Level.INFO, "Container " + child_id + " Removed from" + mappingTable[index]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward getComponentsList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.getWidgets(request, response, null);
        return null;
    }

    public ActionForward getWidgets(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            this.getWidgets(request, response, params.getLong("COMPONENT_ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void getWidgets(HttpServletRequest request, HttpServletResponse response, Long optionsForWidgetId) {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
            JSONArray widgets = new JSONArray();
            JSONObject widgetOptions = new JSONObject();
            Criteria defWidCri = new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"LAYOUT_ID"), (Object)0L, 0);
            if (optionsForWidgetId != null) {
                defWidCri = defWidCri.and(new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"WIDGET_ID"), (Object)optionsForWidgetId, 0));
            }
            DataObject allWidgDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPWidgets", defWidCri);
            Iterator allWidgIter = allWidgDo.getRows("ADMPWidgets");
            while (allWidgIter.hasNext()) {
                Row widg = (Row)allWidgIter.next();
                Long widgetId = (Long)widg.get("WIDGET_ID");
                ArrayList actionsArray = DashboardUtil.getContainerActionList((Long)widg.get("CONTAINER_ID"));
                ArrayList domainNames = (ArrayList)authObject.getDomainNameList().clone();
                block3: for (int dn = 0; dn < domainNames.size(); ++dn) {
                    ArrayList actions = authObject.getActionList((String)domainNames.get(dn));
                    for (int i = 0; i < actionsArray.size(); ++i) {
                        if (actions.contains(actionsArray.get(i))) continue;
                        domainNames.remove(dn--);
                        continue block3;
                    }
                }
                if (domainNames.isEmpty()) continue;
                Criteria widCri = new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"WIDGET_ID"), (Object)widgetId, 0);
                widCri = widCri.and(new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"LAYOUT_ID"), (Object)layoutId, 0));
                DataObject widDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPWidgets", widCri);
                Iterator domIter = widDo.getRows("ADMPWidgets");
                while (domIter.hasNext()) {
                    Row domRow = (Row)domIter.next();
                    domainNames.remove(domRow.get("DOMAIN_NAME").toString());
                }
                if (domainNames.isEmpty()) continue;
                if (optionsForWidgetId == null) {
                    widgets.put((Object)new JSONObject().put("COMPONENT_ID", (Object)widgetId).put("COMPONENT_NAME", (Object)rb.getString(WidgetsHandler.getContainerDetails((long)((Long)widg.get("CONTAINER_ID")), (String)"CONTAINER_NAME"))));
                    continue;
                }
                for (String domain : domainNames) {
                    widgetOptions.put(domain, (Object)new JSONObject().put("WIDGET_ID", (Object)domain).put("WIDGET_NAME", (Object)domain));
                }
            }
            if (optionsForWidgetId == null) {
                response.getWriter().write(widgets.toString());
            } else {
                response.getWriter().write(widgetOptions.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward addOrUpdateComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
            if (params.optBoolean("IS_UPDATE")) {
                Long modContId = params.getLong("CONTAINER_ID");
                Criteria renameCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)modContId, 0);
                DataObject fullContDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", renameCri);
                if (!fullContDo.isEmpty()) {
                    Row renameRow = fullContDo.getFirstRow("ADSLayoutContainers");
                    renameRow.set("CONTAINER_NAME", (Object)params.getString("CONTAINER_NAME"));
                    fullContDo.updateRow(renameRow);
                    Criteria c = new Criteria(Column.getColumn((String)"ADMPChartComponent", (String)"CONTAINER_ID"), (Object)modContId, 0);
                    DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartComponent", c);
                    Row chartRow = dO.getFirstRow("ADMPChartComponent");
                    chartRow.set("TYPE", (Object)params.getString("chartType"));
                    fullContDo.updateBlindly(chartRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(fullContDo);
                }
            } else if (params.optBoolean("IS_ADD")) {
                String domainName = params.getString("WIDGET_ID");
                Long widgetId = params.getLong("COMPONENT_ID");
                Long tabId = params.getLong("TAB_ID");
                Criteria defWidCri = new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"LAYOUT_ID"), (Object)0L, 0);
                defWidCri = defWidCri.and(new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"WIDGET_ID"), (Object)widgetId, 0));
                Long defContId = (Long)CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPWidgets", defWidCri).getFirstRow("ADMPWidgets").get("CONTAINER_ID");
                String containerName = rb.getString(WidgetsHandler.getContainerDetails((long)defContId, (String)"CONTAINER_NAME"));
                Long moduleId = 14L;
                Long componentId = 14L;
                DataObject fullContDo = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Row contRow = new Row("ADSLayoutContainers");
                contRow.set("LAYOUT_ID", (Object)layoutId);
                contRow.set("CONTAINER_NAME", (Object)(containerName + " - " + domainName));
                contRow.set("WIDTH", (Object)(params.has("WIDTH") ? params.getLong("WIDTH") : 50L));
                if (!params.has("HEIGHT")) {
                    Criteria contHeightCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)defContId, 0);
                    DataObject contHeightDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", contHeightCri);
                    Row contHeightRow = contHeightDO.getFirstRow("ADSLayoutContainers");
                    Long defHeight = (Long)contHeightRow.get("HEIGHT");
                    if (defHeight != null) {
                        contRow.set("HEIGHT", (Object)defHeight);
                    }
                } else {
                    contRow.set("HEIGHT", (Object)params.getLong("HEIGHT"));
                }
                fullContDo.addRow(contRow);
                Row tabCont = new Row("ADSTabVsContainer");
                tabCont.set("TAB_ID", (Object)tabId);
                tabCont.set("CONTAINER_ID", contRow.get("CONTAINER_ID"));
                tabCont.set("PRIORITY_ID", (Object)(CustomizationHandler.getMaxPriorityId((String)"ADSTabVsContainer", (String)"TAB_ID", (String)String.valueOf(tabId)) + 1L));
                fullContDo.addRow(tabCont);
                Row usedWid = new Row("ADMPWidgets");
                usedWid.set("LAYOUT_ID", (Object)layoutId);
                usedWid.set("CONTAINER_ID", contRow.get("CONTAINER_ID"));
                usedWid.set("WIDGET_ID", (Object)widgetId);
                usedWid.set("DOMAIN_NAME", (Object)domainName);
                fullContDo.addRow(usedWid);
                DashboardUtil.cloneChartComponent(defContId, contRow.get("CONTAINER_ID"), fullContDo, loginId, domainName);
                Row contVsComp = new Row("ADSContainerVsComponent");
                contVsComp.set("CONTAINER_ID", contRow.get("CONTAINER_ID"));
                contVsComp.set("COMPONENT_ID", (Object)componentId);
                contVsComp.set("MODULE_ID", (Object)moduleId);
                DashboardUtil.setMenu(contRow, new Long[]{1L, 2L}, fullContDo);
                fullContDo.addRow(contVsComp);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(fullContDo);
                ArrayList<Long> newChartContIds = new ArrayList<Long>();
                newChartContIds.add((Long)contRow.get("CONTAINER_ID"));
                DashboardUtil.updateCountForContainers(null, newChartContIds, layoutId);
                ret.put("sSTATUS", (Object)rb.getString("admp.home.layout.dashboard.successfully_added_widget"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("eSTATUS", (Object)rb.getString("admp.home.layout.dashboard.error_adding_widget"));
        }
        response.getWriter().write(ret.toString());
        return null;
    }

    public ActionForward addOrUpdateQuickLinksComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject ret = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
            String containerName = params.getString("WIDGET_NAME");
            JSONArray qLIds = params.getJSONArray("QUICK_LINK_IDS");
            if (params.optBoolean("IS_UPDATE")) {
                Long modContId = params.getLong("CONTAINER_ID");
                Criteria renameCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)modContId, 0);
                DataObject fullContDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", renameCri);
                if (!fullContDo.isEmpty()) {
                    Row renameRow = fullContDo.getFirstRow("ADSLayoutContainers");
                    renameRow.set("CONTAINER_NAME", (Object)containerName);
                    fullContDo.updateRow(renameRow);
                    Criteria delCri = new Criteria(Column.getColumn((String)"ADMPQuickLinksMapping", (String)"CONTAINER_ID"), (Object)modContId, 0);
                    DataObject oldMap = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPQuickLinksMapping", delCri);
                    fullContDo.merge(oldMap);
                    fullContDo.deleteRows("ADMPQuickLinksMapping", delCri);
                    Long qlPriority = 1L;
                    for (int j = 0; j < qLIds.length(); ++j) {
                        Row qLRow = new Row("ADMPQuickLinksMapping");
                        qLRow.set("QUICK_LINK_ID", (Object)qLIds.getLong(j));
                        qLRow.set("CONTAINER_ID", (Object)modContId);
                        Long l = qlPriority;
                        Long l2 = qlPriority = Long.valueOf(qlPriority + 1L);
                        qLRow.set("PRIORITY_ID", (Object)l);
                        fullContDo.addRow(qLRow);
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(fullContDo);
                }
            } else if (params.optBoolean("IS_ADD")) {
                Long moduleId = 12L;
                Long componentId = 12L;
                DataObject fullContDo = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Row contRow = new Row("ADSLayoutContainers");
                contRow.set("LAYOUT_ID", (Object)layoutId);
                contRow.set("CONTAINER_NAME", (Object)containerName);
                contRow.set("WIDTH", (Object)(params.has("WIDTH") ? params.getLong("WIDTH") : 50L));
                fullContDo.addRow(contRow);
                Row layoutRHS = new Row("ADSLayoutRHS");
                layoutRHS.set("LAYOUT_ID", (Object)layoutId);
                layoutRHS.set("CONTAINER_ID", contRow.get("CONTAINER_ID"));
                layoutRHS.set("PRIORITY_ID", (Object)(CustomizationHandler.getMaxPriorityId((String)"ADSLayoutRHS", (String)"LAYOUT_ID", (String)String.valueOf(layoutId)) + 1L));
                fullContDo.addRow(layoutRHS);
                Long qlPriority = 1L;
                for (int j = 0; j < qLIds.length(); ++j) {
                    Row quickLinkRow = new Row("ADMPQuickLinksMapping");
                    quickLinkRow.set("CONTAINER_ID", contRow.get("CONTAINER_ID"));
                    quickLinkRow.set("QUICK_LINK_ID", (Object)qLIds.getLong(j));
                    Long l = qlPriority;
                    Long l3 = qlPriority = Long.valueOf(qlPriority + 1L);
                    quickLinkRow.set("PRIORITY_ID", (Object)l);
                    fullContDo.addRow(quickLinkRow);
                }
                Row contVsComp = new Row("ADSContainerVsComponent");
                contVsComp.set("CONTAINER_ID", contRow.get("CONTAINER_ID"));
                contVsComp.set("COMPONENT_ID", (Object)componentId);
                contVsComp.set("MODULE_ID", (Object)moduleId);
                DashboardUtil.setMenu(contRow, new Long[]{1L, 2L}, fullContDo);
                fullContDo.addRow(contVsComp);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(fullContDo);
            }
            ret.put("sSTATUS", (Object)rb.getString("admp.home.layout.dashboard.successfully_added_widget"));
            ret.put("RHSDATA", (Object)new LayoutBean().getRHSContainerDetails(layoutId, I18N.getInstance().getBundle(request)));
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.put("eSTATUS", (Object)rb.getString("admp.home.layout.dashboard.error_adding_widget"));
        }
        response.getWriter().write(ret.toString());
        return null;
    }

    public ActionForward getWidgetOptions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject layoutParams = new JSONObject(request.getParameter("params"));
            JSONObject containerData = layoutParams.getJSONObject("CONTAINER_DATA");
            JSONArray widgetOptions = new JSONArray();
            Criteria c = new Criteria(Column.getColumn((String)"ADMPChartComponent", (String)"CONTAINER_ID"), (Object)containerData.getLong("CONTAINER_ID"), 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPChartComponent", c);
            String chartType = (String)dO.getFirstRow("ADMPChartComponent").get("TYPE");
            JSONArray options = new JSONArray();
            options.put((Object)new JSONObject().put("SERVER_VALUE", (Object)"column").put("CLIENT_VALUE", (Object)rb.getString("admp.home.layout.dashboard.column")).put("ICON_STYLE", (Object)"admp-comm-icon icn-column-chart"));
            options.put((Object)new JSONObject().put("SERVER_VALUE", (Object)"bar").put("CLIENT_VALUE", (Object)rb.getString("admp.home.layout.dashboard.bar")).put("ICON_STYLE", (Object)"admp-comm-icon icn-bar-chart"));
            JSONObject widOption = new JSONObject().put("OPTIONS", (Object)options).put("SELECTED_VALUE", (Object)chartType).put("ID", (Object)"chartType").put("TYPE", (Object)"select").put("DISPLAY_NAME", (Object)rb.getString("admp.home.layout.dashboard.select_chart_type"));
            widgetOptions.put((Object)widOption);
            response.getWriter().write(widgetOptions.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getQuickLinksList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            ADSResourceBundle rb = I18N.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList actions = HelpdeskUtil.getActionsForRoles((Long)loginId);
            SelectQueryImpl qlQuery = new SelectQueryImpl(Table.getTable((String)"ADMPQuickLinks"));
            qlQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"QUICK_LINK_ID"));
            qlQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"ACTION_ID"));
            qlQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"DISPLAY_NAME"));
            qlQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"TAB_NAME"));
            qlQuery.addSelectColumn(Column.getColumn((String)"ADMPQuickLinks", (String)"CATEGORY_NAME"));
            qlQuery.addSortColumn(new SortColumn("ADMPQuickLinks", "TAB_NAME", true));
            qlQuery.addSortColumn(new SortColumn("ADMPQuickLinks", "CATEGORY_NAME", true));
            qlQuery.addSortColumn(new SortColumn("ADMPQuickLinks", "PRIORITY_ID", true));
            qlQuery.setCriteria(new Criteria(Column.getColumn((String)"ADMPQuickLinks", (String)"TAB_NAME"), (Object)"misc", 1));
            DataObject qlDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)qlQuery);
            JSONObject categoryVsQL = new JSONObject();
            JSONObject tabVsCategory = new JSONObject();
            JSONArray tabs = new JSONArray();
            JSONArray tempQLs = null;
            JSONArray tempCats = null;
            String tempCategory = "";
            String tempTab = "";
            String i18nKeyPrefix = "admp.ql.dashboard.";
            Iterator qlItr = qlDO.getRows("ADMPQuickLinks");
            while (qlItr.hasNext()) {
                Row qlRow = (Row)qlItr.next();
                Long qlActId = (Long)qlRow.get("ACTION_ID");
                if (!actions.contains(qlActId)) continue;
                JSONObject ql = new JSONObject();
                ql.put("UNIQUE_ID", qlRow.get("QUICK_LINK_ID"));
                ql.put("DISPLAY_NAME", (Object)rb.getString((String)qlRow.get("DISPLAY_NAME")));
                if (!tempCategory.equalsIgnoreCase((String)qlRow.get("CATEGORY_NAME"))) {
                    if (!tempCategory.equals("")) {
                        JSONObject categ = new JSONObject();
                        categ.put("CATEGORY_NAME", (Object)rb.getString(i18nKeyPrefix + tempCategory.substring(3)));
                        categ.put("CATEGORY_ID", (Object)tempCategory);
                        categ.put("QUICK_LINKS", (Object)tempQLs);
                        tempCats.put((Object)categ);
                    }
                    tempQLs = new JSONArray();
                    tempCategory = (String)qlRow.get("CATEGORY_NAME");
                }
                if (!tempTab.equalsIgnoreCase((String)qlRow.get("TAB_NAME"))) {
                    if (!tempTab.equals("")) {
                        JSONObject tab = new JSONObject();
                        tab.put("TAB_NAME", (Object)rb.getString(i18nKeyPrefix + tempTab.substring(3)));
                        tab.put("TAB_ID", (Object)tempTab);
                        tab.put("CATEGORIES", (Object)tempCats);
                        tabs.put((Object)tab);
                    }
                    tempCats = new JSONArray();
                    tempTab = (String)qlRow.get("TAB_NAME");
                }
                tempQLs.put((Object)ql);
            }
            if (!tempCategory.equals("")) {
                JSONObject categ = new JSONObject();
                categ.put("CATEGORY_NAME", (Object)rb.getString(i18nKeyPrefix + tempCategory.substring(3)));
                categ.put("CATEGORY_ID", (Object)tempCategory);
                categ.put("QUICK_LINKS", tempQLs);
                tempCats.put((Object)categ);
            }
            if (!tempTab.equals("")) {
                JSONObject tab = new JSONObject();
                tab.put("TAB_NAME", (Object)rb.getString(i18nKeyPrefix + tempTab.substring(3)));
                tab.put("TAB_ID", (Object)tempTab);
                tab.put("CATEGORIES", tempCats);
                tabs.put((Object)tab);
            }
            JSONObject ret = new JSONObject().put("TABS", (Object)tabs);
            response.getWriter().write(ret.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getLayoutTabsDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject ret = new JSONObject();
            Criteria statusCri = new Criteria(Column.getColumn((String)"ADMPDashboard", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPDashboard", statusCri);
            if (dO.isEmpty()) {
                ret.put("status", (Object)"error").put("message", (Object)rb.getString("admp.home.layout.dashboard.add_report_no_dashboard"));
            } else {
                Row row = dO.getFirstRow("ADMPDashboard");
                Long layoutId = (Long)row.get("LAYOUT_ID");
                Long defaultTabId = (Long)row.get("DEFAULT_TAB_ID");
                JSONArray tabs = TabsHandler.getLayoutTabsDetails((Long)layoutId, null, (ADSResourceBundle)I18N.getInstance().getBundle(request));
                JSONObject tabVsContainers = new JSONObject();
                for (int i = 0; i < tabs.length(); ++i) {
                    JSONObject tab = tabs.getJSONObject(i);
                    Long tabId = tab.getLong("TAB_ID");
                    if (tabId.longValue() == defaultTabId.longValue()) {
                        tabs = DashboardAction.removeFromJSONArrayAt(tabs, i--);
                        continue;
                    }
                    tabVsContainers.put(tabId.toString(), (Object)DashboardAction.getTabContainers(tabId, true));
                }
                ret.put("tabs", (Object)tabs);
                ret.put("tabVsContainers", (Object)tabVsContainers);
                Boolean warningShown = session.getAttribute("addToDashboardWarningShown") != null ? (Boolean)session.getAttribute("addToDashboardWarningShown") : false;
                if (!warningShown.booleanValue()) {
                    ret.put("status", (Object)"warning").put("message", (Object)rb.getString("admp.home.layout.dashboard.add_report_performance_warning"));
                } else {
                    ret.put("status", (Object)"ok");
                }
            }
            response.getWriter().write(ret.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static JSONArray getTabContainers(Long tabId, boolean forReportAddition) {
        JSONArray conts = new JSONArray();
        try {
            String tabVsContTable = "ADSTabVsContainer";
            SelectQueryImpl tabContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
            tabContQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"));
            tabContQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"));
            tabContQuery.addJoin(new Join("ADSLayoutContainers", tabVsContTable, new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
            tabContQuery.addSelectColumn(Column.getColumn((String)tabVsContTable, (String)"PRIORITY_ID"));
            tabContQuery.addSortColumn(new SortColumn(tabVsContTable, "PRIORITY_ID", true));
            Criteria tabCri = new Criteria(Column.getColumn((String)tabVsContTable, (String)"TAB_ID"), (Object)tabId, 0);
            tabContQuery.setCriteria(tabCri);
            DataObject tabContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)tabContQuery);
            Iterator tabRows = tabContDO.getRows("ADSLayoutContainers");
            if (forReportAddition) {
                while (tabRows.hasNext()) {
                    try {
                        Row contR = (Row)tabRows.next();
                        Long contId = (Long)contR.get("CONTAINER_ID");
                        if (DashboardUtil.getReportMappings(contId).size() >= 15) continue;
                        JSONObject cont = new JSONObject();
                        cont.put("CONTAINER_ID", (Object)contId);
                        cont.put("CONTAINER_NAME", (Object)((String)contR.get("CONTAINER_NAME")));
                        conts.put((Object)cont);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                while (tabRows.hasNext()) {
                    Row contR = (Row)tabRows.next();
                    JSONObject cont = new JSONObject();
                    cont.put("CONTAINER_ID", (Object)((Long)contR.get("CONTAINER_ID")));
                    cont.put("CONTAINER_NAME", (Object)((String)contR.get("CONTAINER_NAME")));
                    conts.put((Object)cont);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conts;
    }

    public static JSONArray removeFromJSONArrayAt(JSONArray jsonArray, int index) throws Exception {
        JSONArray retArray = new JSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (i == index) continue;
            retArray.put(jsonArray.get(i));
        }
        return retArray;
    }
}

