/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.dashboard;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.DashboardReportUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardRefreshHandler;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.manageengine.ads.fw.layout.CustomizationHandler;
import com.manageengine.ads.fw.layout.LayoutConstants;
import com.manageengine.ads.fw.layout.customization.TabsHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class DashboardUtil
implements LayoutConstants {
    public static final String LOGIN_ID = "LOGIN_ID";
    public static final String REPORT_ID = "REPORT_ID";
    public static final String CHART_ID = "CHART_ID";
    public static final String SERIES_ID = "SERIES_ID";
    public static final String POINT_ID = "POINT_ID";
    public static final String HEIGHT = "HEIGHT";
    public static final String WIDTH = "WIDTH";
    public static final String ADMPDASHBOARD = "ADMPDashboard";
    public static final String ADMPCHARTCOMPONENT = "ADMPChartComponent";
    public static final String ADMPCHARTSERIES = "ADMPChartSeries";
    public static final String ADMPCHARTPOINTS = "ADMPChartPoints";
    public static final String DASHBOARD_REPORT_MAPPING = "DASHBOARD_REPORT_MAPPING";
    public static final Long DASHBOARD_ACTION_ID = 1L;
    public static final Long CUSTOMIZATION_ACTION_ID = 70L;
    public static final Long DEFAULT_LAYOUT_ID = 0L;
    static Logger logger = Logger.getLogger("ADSLayoutLogger");
    private static final ArrayList<Integer> supportedReports = new ArrayList<Integer>(Arrays.asList(15, 27, 28, 4, 34, 30, 29, 2, 17, 210, 204, 216, 217, 203, 208, 209, 202, 601, 701, 705, 706, 702, 703, 12, 13, 31, 32, 6, 7, 37, 25, 26, 111, 113, 901, 902, 904, 905, 211, 207, 503, 506, 428, 423, 405, 106, 101, 102, 205, 414, 415, 410, 411, 504, 505, 426, 427, 404, 413, 430, 425, 429, 403, 424, 420, 421, 214, 41, 103, 16, 9, 19, 24, 107, 39, 109, 213, 201, 42, 1, 212, 21, 112, 903, 20, 5, 14));

    public static boolean isReportSupported(Integer reportId) {
        if (reportId != null) {
            return supportedReports.contains(reportId);
        }
        return false;
    }

    public static boolean isReportSupported(Integer reportId, HttpServletRequest request) {
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        if (authObject.getActionList().contains(CUSTOMIZATION_ACTION_ID)) {
            return DashboardUtil.isReportSupported(reportId);
        }
        return false;
    }

    public static Row getStatusRow(Long loginId) {
        return DashboardReportUtil.getStatusRow((Long)loginId);
    }

    public static void resetLayout(Long loginId, Long layoutId, ADMPAuthObject authObject) {
        try {
            ArrayList actions = authObject.getActionList();
            ArrayList domainNames = authObject.getDomainNameList();
            DataObject newLayout = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long defaultLayoutId = DEFAULT_LAYOUT_ID;
            Row adslayout = new Row("ADSLayout");
            adslayout.set("LAYOUT_NAME", (Object)("Ember_Dashboard_" + loginId));
            adslayout.set("USER_ID", (Object)com.adventnet.sym.adsm.common.server.util.CommonUtil.getUserId((Long)loginId));
            newLayout.addRow(adslayout);
            SelectQueryImpl rhsContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
            Column contNameCol = Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME");
            Column contIdCol = Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID");
            Column contIconCol = Column.getColumn((String)"ADSLayoutContainers", (String)"ICON_STYLE");
            rhsContQuery.addSelectColumn(contNameCol);
            rhsContQuery.addSelectColumn(contIdCol);
            rhsContQuery.addSelectColumn(contIconCol);
            rhsContQuery.addJoin(new Join("ADSLayoutContainers", "ADSLayoutRHS", new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
            rhsContQuery.addSortColumn(new SortColumn("ADSLayoutRHS", "PRIORITY_ID", true));
            Criteria rhsCri = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)defaultLayoutId, 0);
            rhsContQuery.setCriteria(rhsCri);
            DataObject rhsContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)rhsContQuery);
            Iterator rhsRows = rhsContDO.getRows("ADSLayoutContainers");
            long tempPriority = 1L;
            while (rhsRows.hasNext()) {
                Row cont = (Row)rhsRows.next();
                String contName = (String)cont.get("CONTAINER_NAME");
                Long contId = (Long)cont.get("CONTAINER_ID");
                if (contName.equalsIgnoreCase("ADSSP_advertisement")) {
                    boolean registered = LicenseMgr.getInstance().isRegisteredEdition();
                    if (registered) continue;
                    Row adssp = new Row("ADSLayoutRHS");
                    adssp.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                    adssp.set("CONTAINER_ID", (Object)contId);
                    adssp.set("PRIORITY_ID", (Object)tempPriority++);
                    newLayout.addRow(adssp);
                    continue;
                }
                if (contName.equalsIgnoreCase("admp.home.workflow.awaiting_requests")) {
                    if (!authObject.isReviewer().booleanValue() && !authObject.isApprover().booleanValue() && !authObject.isCommitter().booleanValue()) continue;
                    Row workflowSummaryRow = new Row("ADSLayoutRHS");
                    workflowSummaryRow.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                    workflowSummaryRow.set("CONTAINER_ID", (Object)contId);
                    workflowSummaryRow.set("PRIORITY_ID", (Object)tempPriority++);
                    newLayout.addRow(workflowSummaryRow);
                    continue;
                }
                if (contName.equalsIgnoreCase("admp.home.image_text.inside_admp")) {
                    if (!actions.contains(1012L)) continue;
                    Row resetPassRow = new Row("ADSLayoutRHS");
                    resetPassRow.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                    resetPassRow.set("CONTAINER_ID", (Object)contId);
                    resetPassRow.set("PRIORITY_ID", (Object)tempPriority++);
                    newLayout.addRow(resetPassRow);
                    continue;
                }
                SelectQueryImpl qlQuery = new SelectQueryImpl(Table.getTable((String)"ADMPQuickLinksMapping"));
                qlQuery.addJoin(new Join("ADMPQuickLinksMapping", "ADMPQuickLinks", new String[]{"QUICK_LINK_ID"}, new String[]{"QUICK_LINK_ID"}, 1));
                Column uniqIdCol = Column.getColumn((String)"ADMPQuickLinks", (String)"QUICK_LINK_ID");
                Column actionIdCol = Column.getColumn((String)"ADMPQuickLinks", (String)"ACTION_ID");
                qlQuery.addSelectColumn(uniqIdCol);
                qlQuery.addSelectColumn(actionIdCol);
                Criteria qlCri = new Criteria(Column.getColumn((String)"ADMPQuickLinksMapping", (String)"CONTAINER_ID"), (Object)contId, 0);
                qlQuery.setCriteria(qlCri);
                qlQuery.addSortColumn(new SortColumn("ADMPQuickLinksMapping", "PRIORITY_ID", true));
                DataObject qlDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)qlQuery);
                Row qlContRow = new Row("ADSLayoutContainers");
                long qlPri = 1L;
                Iterator qlItr = qlDO.getRows("ADMPQuickLinks");
                while (qlItr.hasNext()) {
                    Row qlRow = (Row)qlItr.next();
                    Long qlActId = (Long)qlRow.get("ACTION_ID");
                    if (!actions.contains(qlActId)) continue;
                    Row qlMap = new Row("ADMPQuickLinksMapping");
                    qlMap.set("CONTAINER_ID", qlContRow.get("CONTAINER_ID"));
                    qlMap.set("QUICK_LINK_ID", qlRow.get("QUICK_LINK_ID"));
                    qlMap.set("PRIORITY_ID", (Object)qlPri++);
                    newLayout.addRow(qlMap);
                }
                if (qlPri <= 1L) continue;
                Row qlContMap = new Row("ADSLayoutRHS");
                qlContMap.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                qlContMap.set("CONTAINER_ID", qlContRow.get("CONTAINER_ID"));
                qlContMap.set("PRIORITY_ID", (Object)tempPriority++);
                newLayout.addRow(qlContMap);
                qlContRow.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                qlContRow.set("CONTAINER_NAME", (Object)contName);
                qlContRow.set(WIDTH, (Object)4L);
                qlContRow.set("ICON_STYLE", cont.get("ICON_STYLE"));
                newLayout.addRow(qlContRow);
                Row contVsComp = new Row("ADSContainerVsComponent");
                contVsComp.set("CONTAINER_ID", qlContRow.get("CONTAINER_ID"));
                contVsComp.set("COMPONENT_ID", (Object)12L);
                contVsComp.set("MODULE_ID", (Object)12L);
                newLayout.addRow(contVsComp);
                DashboardUtil.setMenu(qlContRow, new Long[]{1L, 2L}, newLayout);
            }
            SelectQueryImpl tabQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutTabs"));
            tabQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutTabs", (String)"TAB_NAME"));
            tabQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutTabs", (String)"TAB_ID"));
            tabQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutTabs", (String)"ICON_STYLE"));
            tabQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutTabs", (String)"IS_CUSTOMIZABLE"));
            tabQuery.addJoin(new Join("ADSLayoutTabs", "ADSLayoutLHS", new String[]{"TAB_ID"}, new String[]{"TAB_ID"}, 1));
            tabQuery.setCriteria(new Criteria(Column.getColumn((String)"ADSLayoutLHS", (String)"LAYOUT_ID"), (Object)defaultLayoutId, 0));
            DataObject tabDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)tabQuery);
            Object defaultTabId = null;
            Iterator tabs = tabDO.getRows("ADSLayoutTabs");
            long tabPriority = 1L;
            while (tabs.hasNext()) {
                Row tab = (Row)tabs.next();
                String tabName = (String)tab.get("TAB_NAME");
                Long systemDefaultTabId = (Long)tab.get("TAB_ID");
                Row tabRow = new Row("ADSLayoutTabs");
                tabRow.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                tabRow.set("TAB_NAME", (Object)tabName);
                tabRow.set("ICON_STYLE", tab.get("ICON_STYLE"));
                tabRow.set("IS_CUSTOMIZABLE", tab.get("IS_CUSTOMIZABLE"));
                newLayout.addRow(tabRow);
                if (defaultTabId == null) {
                    defaultTabId = tabRow.get("TAB_ID");
                }
                Row tabMap = new Row("ADSLayoutLHS");
                tabMap.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                tabMap.set("TAB_ID", tabRow.get("TAB_ID"));
                tabMap.set("PRIORITY_ID", (Object)tabPriority++);
                newLayout.addRow(tabMap);
                SelectQueryImpl tabContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
                tabContQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutContainers", (String)"*"));
                tabContQuery.addJoin(new Join("ADSLayoutContainers", "ADSTabVsContainer", new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
                tabContQuery.addSelectColumn(Column.getColumn((String)"ADSTabVsContainer", (String)"PRIORITY_ID"));
                tabContQuery.addSortColumn(new SortColumn("ADSTabVsContainer", "PRIORITY_ID", true));
                Criteria tabCri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)systemDefaultTabId, 0);
                tabContQuery.setCriteria(tabCri);
                DataObject tabContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)tabContQuery);
                Iterator tabRows = tabContDO.getRows("ADSLayoutContainers");
                long contPri = 1L;
                while (tabRows.hasNext()) {
                    Row cont = (Row)tabRows.next();
                    Long contId = (Long)cont.get("CONTAINER_ID");
                    SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
                    chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
                    chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
                    chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"*"));
                    chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)"*"));
                    chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
                    Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)contId, 0);
                    chartQuery.setCriteria(chartCri);
                    chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
                    chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
                    DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
                    Row newChartCont = new Row("ADSLayoutContainers");
                    boolean addChartCont = false;
                    Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
                    while (chartItr.hasNext()) {
                        Row chartRow = (Row)chartItr.next();
                        Long chartId = (Long)chartRow.get(CHART_ID);
                        Row newChart = new Row(ADMPCHARTCOMPONENT);
                        long numOfSeries = 0L;
                        Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                        Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                        while (seriesItr.hasNext()) {
                            Row seriesRow = (Row)seriesItr.next();
                            Long seriesId = (Long)seriesRow.get(SERIES_ID);
                            Row newSeries = new Row(ADMPCHARTSERIES);
                            long pointPri = 0L;
                            Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                            Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                            while (pointItr.hasNext()) {
                                Row pointRow = (Row)pointItr.next();
                                Long actionId = (Long)pointRow.get("ACTION_ID");
                                if (!actions.contains(actionId)) continue;
                                ++pointPri;
                                for (int dn = 0; dn < domainNames.size(); ++dn) {
                                    ArrayList domainActions = authObject.getActionList((String)domainNames.get(dn));
                                    if (!domainActions.contains(actionId)) continue;
                                    Row newPoint = new Row(ADMPCHARTPOINTS);
                                    newPoint.set(SERIES_ID, newSeries.get(SERIES_ID));
                                    newPoint.set("DOMAIN_NAME", domainNames.get(dn));
                                    newPoint.set("PRIORITY_ID", (Object)pointPri);
                                    newPoint.set(LOGIN_ID, (Object)loginId);
                                    DashboardUtil.copyColumnValues(newPoint, pointRow, new String[]{REPORT_ID, "POINT_NAME", "ACTION_ID"});
                                    newLayout.addRow(newPoint);
                                    DashboardUtil.copyReportInputVals((Long)pointRow.get(POINT_ID), newPoint.get(POINT_ID), newLayout);
                                }
                            }
                            if (pointPri == 0L) continue;
                            newSeries.set(CHART_ID, newChart.get(CHART_ID));
                            newSeries.set("SERIES_NAME", seriesRow.get("SERIES_NAME"));
                            newLayout.addRow(newSeries);
                            ++numOfSeries;
                        }
                        if (numOfSeries == 0L) continue;
                        newChart.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
                        newChart.set("REFERENCE_CHART_ID", chartRow.get(CHART_ID));
                        DashboardUtil.copyColumnValues(newChart, chartRow, new String[]{"TITLE", "X_TITLE", "Y_TITLE", "TYPE", "STACKING"});
                        newLayout.addRow(newChart);
                        addChartCont = true;
                    }
                    if (!addChartCont) continue;
                    newChartCont.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
                    DashboardUtil.copyColumnValues(newChartCont, cont, new String[]{"CONTAINER_NAME", WIDTH, HEIGHT});
                    newLayout.addRow(newChartCont);
                    Row chartContMap = new Row("ADSTabVsContainer");
                    chartContMap.set("TAB_ID", tabRow.get("TAB_ID"));
                    chartContMap.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
                    chartContMap.set("PRIORITY_ID", (Object)contPri++);
                    newLayout.addRow(chartContMap);
                    Row contVsComp = new Row("ADSContainerVsComponent");
                    contVsComp.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
                    contVsComp.set("COMPONENT_ID", (Object)14L);
                    contVsComp.set("MODULE_ID", (Object)14L);
                    newLayout.addRow(contVsComp);
                    DashboardUtil.setMenu(newChartCont, new Long[]{2L}, newLayout);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(newLayout);
            if (layoutId != null) {
                Criteria del = new Criteria(Column.getColumn((String)"ADSLayout", (String)"LAYOUT_ID"), (Object)layoutId, 0);
                Criteria del2 = new Criteria(Column.getColumn((String)ADMPDASHBOARD, (String)"LAYOUT_ID"), (Object)layoutId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(del);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(del2);
            }
            DataObject admpDash = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row newStatus = new Row(ADMPDASHBOARD);
            newStatus.set(LOGIN_ID, (Object)loginId);
            newStatus.set("LAYOUT_ID", adslayout.get("LAYOUT_ID"));
            newStatus.set("DEFAULT_TAB_ID", defaultTabId);
            admpDash.addRow(newStatus);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(admpDash);
            logger.log(Level.INFO, "Dashboard layout reset successfully for loginId: " + loginId);
            ArrayList reportMappings = DashboardUtil.getNewReportMappings(loginId, true);
            DashboardRefreshHandler.getInstance().updateCount(loginId, reportMappings);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Error in resetting dashboard layout for loginId: " + loginId);
        }
    }

    public static void checkPermission(Long loginId, Long layoutId, Long defaultTabId, ADMPAuthObject authObject) {
        try {
            ArrayList actions = HelpdeskUtil.getActionsForRoles((Long)loginId);
            SelectQueryImpl rhsContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
            Column contNameCol = Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME");
            Column contIdCol = Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID");
            rhsContQuery.addSelectColumn(contNameCol);
            rhsContQuery.addSelectColumn(contIdCol);
            rhsContQuery.addJoin(new Join("ADSLayoutContainers", "ADSLayoutRHS", new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
            Criteria rhsCri = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)layoutId, 0);
            rhsContQuery.setCriteria(rhsCri);
            DataObject rhsContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)rhsContQuery);
            Iterator rhsRows = rhsContDO.getRows("ADSLayoutContainers");
            while (rhsRows.hasNext()) {
                Row cont = (Row)rhsRows.next();
                String contName = (String)cont.get("CONTAINER_NAME");
                Long contId = (Long)cont.get("CONTAINER_ID");
                Criteria del = null;
                if (!contName.equalsIgnoreCase("ADSSP_advertisement") && !contName.equalsIgnoreCase("admp.home.workflow.awaiting_requests")) {
                    if (contName.equalsIgnoreCase("admp.home.image_text.inside_admp")) {
                        if (!actions.contains(1012L)) {
                            del = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)layoutId, 0);
                            del = del.and(new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"CONTAINER_ID"), (Object)contId, 0));
                        }
                    } else {
                        SelectQueryImpl qlQuery = new SelectQueryImpl(Table.getTable((String)"ADMPQuickLinksMapping"));
                        qlQuery.addJoin(new Join("ADMPQuickLinksMapping", "ADMPQuickLinks", new String[]{"QUICK_LINK_ID"}, new String[]{"QUICK_LINK_ID"}, 1));
                        Column uniqIdCol = Column.getColumn((String)"ADMPQuickLinks", (String)"QUICK_LINK_ID");
                        Column actionIdCol = Column.getColumn((String)"ADMPQuickLinks", (String)"ACTION_ID");
                        qlQuery.addSelectColumn(uniqIdCol);
                        qlQuery.addSelectColumn(actionIdCol);
                        Criteria qlCri = new Criteria(Column.getColumn((String)"ADMPQuickLinksMapping", (String)"CONTAINER_ID"), (Object)contId, 0);
                        qlQuery.setCriteria(qlCri);
                        qlQuery.addSortColumn(new SortColumn("ADMPQuickLinksMapping", "PRIORITY_ID", true));
                        DataObject qlDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)qlQuery);
                        ArrayList<Long> removeMapIds = new ArrayList<Long>();
                        int qlCont = 0;
                        Iterator qlItr = qlDO.getRows("ADMPQuickLinks");
                        while (qlItr.hasNext()) {
                            ++qlCont;
                            Row qlRow = (Row)qlItr.next();
                            Long qlActId = (Long)qlRow.get("ACTION_ID");
                            if (actions.contains(qlActId)) continue;
                            removeMapIds.add((Long)qlRow.get("QUICK_LINK_ID"));
                        }
                        if (qlCont == removeMapIds.size()) {
                            del = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)contId, 0);
                        } else if (removeMapIds.size() > 0) {
                            del = new Criteria(Column.getColumn((String)"ADMPQuickLinksMapping", (String)"QUICK_LINK_ID"), (Object)removeMapIds.toArray(new Long[0]), 8);
                            del = del.and(new Criteria(Column.getColumn((String)"ADMPQuickLinksMapping", (String)"CONTAINER_ID"), (Object)contId, 0));
                        }
                    }
                }
                if (del == null) continue;
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(del);
            }
            SelectQueryImpl tabQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutTabs"));
            tabQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutTabs", (String)"TAB_ID"));
            tabQuery.addJoin(new Join("ADSLayoutTabs", "ADSLayoutLHS", new String[]{"TAB_ID"}, new String[]{"TAB_ID"}, 1));
            tabQuery.setCriteria(new Criteria(Column.getColumn((String)"ADSLayoutLHS", (String)"LAYOUT_ID"), (Object)layoutId, 0));
            DataObject tabDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)tabQuery);
            Iterator tabs = tabDO.getRows("ADSLayoutTabs");
            while (tabs.hasNext()) {
                Row tab = (Row)tabs.next();
                Long tabId = (Long)tab.get("TAB_ID");
                boolean isDefaultTab = false;
                if (tabId.compareTo(defaultTabId) == 0) {
                    isDefaultTab = true;
                }
                if (!isDefaultTab) {
                    SelectQueryImpl tabContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
                    tabContQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"));
                    tabContQuery.addJoin(new Join("ADSLayoutContainers", "ADSTabVsContainer", new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
                    Criteria tabCri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)tabId, 0);
                    tabContQuery.setCriteria(tabCri);
                    DataObject tabContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)tabContQuery);
                    Iterator tabRows = tabContDO.getRows("ADSLayoutContainers");
                    while (tabRows.hasNext()) {
                        Row cont = (Row)tabRows.next();
                        Long contId = (Long)cont.get("CONTAINER_ID");
                        SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
                        chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
                        chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
                        chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"*"));
                        chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)"*"));
                        chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
                        Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)contId, 0);
                        chartQuery.setCriteria(chartCri);
                        chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
                        chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
                        DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
                        boolean deleteChartCont = false;
                        Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
                        while (chartItr.hasNext()) {
                            Criteria delCri;
                            Row chartRow = (Row)chartItr.next();
                            Long chartId = (Long)chartRow.get(CHART_ID);
                            ArrayList<Long> seriesIds = new ArrayList<Long>();
                            int numOfSeries = 0;
                            Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                            Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                            while (seriesItr.hasNext()) {
                                ++numOfSeries;
                                Row seriesRow = (Row)seriesItr.next();
                                Long seriesId = (Long)seriesRow.get(SERIES_ID);
                                Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                                ArrayList<Long> pointIds = new ArrayList<Long>();
                                int pointCount = 0;
                                Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                                while (pointItr.hasNext()) {
                                    ++pointCount;
                                    Row pointRow = (Row)pointItr.next();
                                    Long reportId = (Long)pointRow.get(REPORT_ID);
                                    Long actionId = (Long)pointRow.get("ACTION_ID");
                                    if (actions.contains(actionId)) continue;
                                    pointIds.add((Long)pointRow.get(POINT_ID));
                                }
                                if (pointCount == pointIds.size()) {
                                    seriesIds.add(seriesId);
                                    continue;
                                }
                                if (pointIds.size() <= 0) continue;
                                Criteria delCri2 = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)POINT_ID), (Object)pointIds.toArray(new Long[0]), 8);
                                delCri2 = delCri2.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0));
                                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(delCri2);
                            }
                            if (numOfSeries == seriesIds.size()) {
                                delCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)contId, 0);
                                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(delCri);
                                continue;
                            }
                            if (seriesIds.size() <= 0) continue;
                            delCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)SERIES_ID), (Object)seriesIds.toArray(new Long[0]), 8);
                            delCri = delCri.and(new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0));
                            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(delCri);
                        }
                    }
                }
                if (isDefaultTab || !TabsHandler.isEmptyTab((long)tabId)) continue;
                TabsHandler.removeTab((Long)layoutId, (Long)tabId);
            }
            logger.log(Level.INFO, "Dashboard layout permission checked successfully for loginId: " + loginId);
            DashboardUtil.checkDomain(loginId, layoutId, defaultTabId, authObject);
            DashboardUtil.addDefaultWidgets(loginId, layoutId, defaultTabId, authObject);
            DashboardUtil.checkWorkflow(loginId, layoutId, defaultTabId, authObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Error in permission check in dashboard layout for loginId: " + loginId);
        }
    }

    public static void checkDomain(Long loginId, Long layoutId, Long defaultTabId, ADMPAuthObject authObject) {
        try {
            DataObject sysDefTabDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutLHS", new Criteria(Column.getColumn((String)"ADSLayoutLHS", (String)"LAYOUT_ID"), (Object)0L, 0));
            Long systemDefaultTabId = (Long)sysDefTabDO.getFirstRow("ADSLayoutLHS").get("TAB_ID");
            ArrayList actions = authObject.getActionList();
            ArrayList domainNames = authObject.getDomainNameList();
            HashMap<String, HashMap> domainReportValues = DashboardUtil.getDomainReportValues(defaultTabId, true);
            HashMap chartIdMap = domainReportValues.get("chartIdMap");
            DataObject newLayout = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            SelectQueryImpl tabContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
            tabContQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutContainers", (String)"*"));
            tabContQuery.addJoin(new Join("ADSLayoutContainers", "ADSTabVsContainer", new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
            tabContQuery.addSelectColumn(Column.getColumn((String)"ADSTabVsContainer", (String)"PRIORITY_ID"));
            tabContQuery.addSortColumn(new SortColumn("ADSTabVsContainer", "PRIORITY_ID", true));
            Criteria tabCri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)systemDefaultTabId, 0);
            tabContQuery.setCriteria(tabCri);
            Long contPri = CustomizationHandler.getMaxPriorityId((String)"ADSTabVsContainer", (String)"TAB_ID", (String)defaultTabId.toString()) + 1L;
            DataObject tabContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)tabContQuery);
            Iterator tabRows = tabContDO.getRows("ADSLayoutContainers");
            while (tabRows.hasNext()) {
                Long chartId;
                Row cont = (Row)tabRows.next();
                Long contId = (Long)cont.get("CONTAINER_ID");
                SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
                chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
                chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"*"));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)"*"));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
                Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)contId, 0);
                chartQuery.setCriteria(chartCri);
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
                DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
                Row newChartCont = new Row("ADSLayoutContainers");
                boolean addChartCont = false;
                Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
                while (chartItr.hasNext()) {
                    DataObject delContDO;
                    Row chartRow = (Row)chartItr.next();
                    chartId = (Long)chartRow.get(CHART_ID);
                    Row newChart = new Row(ADMPCHARTCOMPONENT);
                    Object newChartId = newChart.get(CHART_ID);
                    boolean addComponent = true;
                    if (chartIdMap.get(chartId) != null) {
                        addComponent = false;
                        newChartId = chartIdMap.get(chartId);
                    }
                    long numOfSeries = 0L;
                    Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                    Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                    while (seriesItr.hasNext()) {
                        Row seriesRow = (Row)seriesItr.next();
                        Long seriesId = (Long)seriesRow.get(SERIES_ID);
                        Row newSeries = new Row(ADMPCHARTSERIES);
                        long pointPri = 0L;
                        Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                        Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                        while (pointItr.hasNext()) {
                            Row pointRow = (Row)pointItr.next();
                            Long actionId = (Long)pointRow.get("ACTION_ID");
                            if (!actions.contains(actionId)) continue;
                            ++pointPri;
                            for (int dn = 0; dn < domainNames.size(); ++dn) {
                                String domainName = (String)domainNames.get(dn);
                                ArrayList domainActions = authObject.getActionList(domainName);
                                if (!domainActions.contains(actionId)) continue;
                                Row newPoint = new Row(ADMPCHARTPOINTS);
                                newPoint.set(SERIES_ID, newSeries.get(SERIES_ID));
                                newPoint.set("DOMAIN_NAME", (Object)domainName);
                                newPoint.set("PRIORITY_ID", (Object)pointPri);
                                newPoint.set(LOGIN_ID, (Object)loginId);
                                if (domainReportValues.get(domainName + "_" + pointRow.get(REPORT_ID)) != null) {
                                    HashMap countGenIdMap = domainReportValues.get(domainName + "_" + pointRow.get(REPORT_ID));
                                    newPoint.set("COUNT", countGenIdMap.get("COUNT"));
                                    newPoint.set("REPORT_GENERATION_ID", countGenIdMap.get("REPORT_GENERATION_ID"));
                                }
                                DashboardUtil.copyColumnValues(newPoint, pointRow, new String[]{REPORT_ID, "POINT_NAME", "ACTION_ID"});
                                newLayout.addRow(newPoint);
                                DashboardUtil.copyReportInputVals((Long)pointRow.get(POINT_ID), newPoint.get(POINT_ID), newLayout);
                            }
                        }
                        if (pointPri == 0L) continue;
                        newSeries.set(CHART_ID, newChartId);
                        newSeries.set("SERIES_NAME", seriesRow.get("SERIES_NAME"));
                        newLayout.addRow(newSeries);
                        ++numOfSeries;
                    }
                    if (numOfSeries != 0L && addComponent) {
                        newChart.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
                        newChart.set("REFERENCE_CHART_ID", chartRow.get(CHART_ID));
                        DashboardUtil.copyColumnValues(newChart, chartRow, new String[]{"TITLE", "X_TITLE", "Y_TITLE", "TYPE", "STACKING"});
                        newLayout.addRow(newChart);
                        addChartCont = true;
                        continue;
                    }
                    if (numOfSeries != 0L || addComponent || (delContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPCHARTCOMPONENT, new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)CHART_ID), newChartId, 0))).isEmpty()) continue;
                    Criteria c = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), delContDO.getFirstRow(ADMPCHARTCOMPONENT).get("CONTAINER_ID"), 0);
                    c = c.and(new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"IS_CUSTOMIZABLE"), (Object)true, 0));
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(c);
                }
                if (!addChartCont) continue;
                newChartCont.set("LAYOUT_ID", (Object)layoutId);
                DashboardUtil.copyColumnValues(newChartCont, cont, new String[]{"CONTAINER_NAME", WIDTH, HEIGHT});
                newLayout.addRow(newChartCont);
                Row chartContMap = new Row("ADSTabVsContainer");
                chartContMap.set("TAB_ID", (Object)defaultTabId);
                chartContMap.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
                chartId = contPri;
                Long l = contPri = Long.valueOf(contPri + 1L);
                chartContMap.set("PRIORITY_ID", (Object)chartId);
                newLayout.addRow(chartContMap);
                Row contVsComp = new Row("ADSContainerVsComponent");
                contVsComp.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
                contVsComp.set("COMPONENT_ID", (Object)14L);
                contVsComp.set("MODULE_ID", (Object)14L);
                newLayout.addRow(contVsComp);
                DashboardUtil.setMenu(newChartCont, new Long[]{2L}, newLayout);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(newLayout);
            Criteria statusCri = new Criteria(Column.getColumn((String)ADMPDASHBOARD, (String)LOGIN_ID), (Object)loginId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPDASHBOARD, statusCri);
            Row row = dO.getFirstRow(ADMPDASHBOARD);
            row.set("STATUS", null);
            dO.updateRow(row);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dO);
            DashboardUtil.checkWidget(loginId, layoutId, null, authObject);
            logger.log(Level.INFO, "Dashboard layout domains checked successfully for loginId: " + loginId);
            ArrayList reportMappings = DashboardUtil.getNewReportMappings(loginId, true);
            DashboardRefreshHandler.getInstance().updateCount(loginId, reportMappings);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Error in domains check in dashboard layout for loginId: " + loginId);
        }
    }

    public static void checkWidget(HttpServletRequest request, String domainName) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long layoutId = (Long)DashboardUtil.getStatusRow(loginId).get("LAYOUT_ID");
            DashboardUtil.checkWidget(loginId, layoutId, domainName, (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT"));
            Long adminLoginId = com.adventnet.sym.adsm.common.server.util.CommonUtil.ADMIN_LOGIN_ID;
            if (loginId.compareTo(adminLoginId) != 0) {
                DashboardUtil.checkWidget(adminLoginId, (Long)DashboardUtil.getStatusRow(adminLoginId).get("LAYOUT_ID"), domainName, new ADMPAuthObject(adminLoginId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkWidget(Long loginId, Long layoutId, String domainName, ADMPAuthObject authObject) {
        try {
            ArrayList actions = authObject.getActionList();
            Criteria widCri = new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"LAYOUT_ID"), (Object)layoutId, 0);
            DataObject widDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPWidgets", widCri);
            Iterator widRows = widDO.getRows("ADMPWidgets");
            while (widRows.hasNext()) {
                Row wid = (Row)widRows.next();
                Long contId = (Long)wid.get("CONTAINER_ID");
                SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
                chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
                chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)CHART_ID));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)SERIES_ID));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
                Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)contId, 0);
                chartQuery.setCriteria(chartCri);
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
                DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
                boolean deleteChartCont = false;
                Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
                while (chartItr.hasNext()) {
                    Criteria delCri;
                    Row chartRow = (Row)chartItr.next();
                    Long chartId = (Long)chartRow.get(CHART_ID);
                    ArrayList<Long> seriesIds = new ArrayList<Long>();
                    int numOfSeries = 0;
                    int allWidgetSeriesCount = 0;
                    int deleteWidgetSeriesCount = 0;
                    Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                    Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                    while (seriesItr.hasNext()) {
                        ++numOfSeries;
                        Row seriesRow = (Row)seriesItr.next();
                        Long seriesId = (Long)seriesRow.get(SERIES_ID);
                        Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                        ArrayList<Long> pointIds = new ArrayList<Long>();
                        int pointCount = 0;
                        int allWidgetPointCount = 0;
                        int deleteWidgetPointCount = 0;
                        Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                        while (pointItr.hasNext()) {
                            ++pointCount;
                            Row pointRow = (Row)pointItr.next();
                            Long actionId = (Long)pointRow.get("ACTION_ID");
                            String domain = (String)pointRow.get("DOMAIN_NAME");
                            if (domain == null) continue;
                            ++allWidgetPointCount;
                            ArrayList domainActions = authObject.getActionList(domain);
                            if (domainActions != null && domainActions.contains(actionId)) continue;
                            pointIds.add((Long)pointRow.get(POINT_ID));
                            ++deleteWidgetPointCount;
                        }
                        if (allWidgetPointCount > 0) {
                            ++allWidgetSeriesCount;
                            if (allWidgetPointCount == deleteWidgetPointCount) {
                                ++deleteWidgetSeriesCount;
                            }
                        }
                        if (pointCount == pointIds.size()) {
                            seriesIds.add(seriesId);
                            continue;
                        }
                        if (pointIds.size() <= 0) continue;
                        Criteria delCri2 = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)POINT_ID), (Object)pointIds.toArray(new Long[0]), 8);
                        delCri2 = delCri2.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0));
                        CommonUtil.getPersistence((boolean[])new boolean[0]).delete(delCri2);
                    }
                    if (allWidgetSeriesCount == deleteWidgetSeriesCount) {
                        Criteria delWidCri = new Criteria(Column.getColumn((String)"ADMPWidgets", (String)"CONTAINER_ID"), (Object)contId, 0);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).delete(delWidCri);
                    }
                    if (numOfSeries == seriesIds.size()) {
                        delCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)contId, 0);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).delete(delCri);
                        continue;
                    }
                    if (seriesIds.size() <= 0) continue;
                    delCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)SERIES_ID), (Object)seriesIds.toArray(new Long[0]), 8);
                    delCri = delCri.and(new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0));
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(delCri);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkWorkflow(Long loginId, Long layoutId, Long defaultTabId, ADMPAuthObject authObject) {
        try {
            boolean workflowRAE = authObject.isReviewer() != false || authObject.isApprover() != false || authObject.isCommitter() != false;
            boolean componentExist = false;
            SelectQueryImpl rhsContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
            Column contNameCol = Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME");
            Column contIdCol = Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID");
            rhsContQuery.addSelectColumn(contNameCol);
            rhsContQuery.addSelectColumn(contIdCol);
            rhsContQuery.addJoin(new Join("ADSLayoutContainers", "ADSLayoutRHS", new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
            Criteria rhsCri = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)layoutId, 0);
            rhsCri = rhsCri.and(new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"), (Object)"admp.home.workflow.awaiting_requests", 0));
            rhsContQuery.setCriteria(rhsCri);
            DataObject rhsContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)rhsContQuery);
            Iterator rhsRows = rhsContDO.getRows("ADSLayoutContainers");
            while (rhsRows.hasNext()) {
                Row cont = (Row)rhsRows.next();
                Long contId = (Long)cont.get("CONTAINER_ID");
                Criteria moduleCri = new Criteria(Column.getColumn((String)"ADSContainerVsComponent", (String)"CONTAINER_ID"), (Object)contId, 0);
                moduleCri = moduleCri.and(new Criteria(Column.getColumn((String)"ADSContainerVsComponent", (String)"MODULE_ID"), (Object)15L, 0));
                boolean tempComponentExist = !CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSContainerVsComponent", moduleCri).isEmpty();
                boolean bl = componentExist = componentExist || tempComponentExist;
                if (!tempComponentExist || workflowRAE) continue;
                Criteria del = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)layoutId, 0);
                del = del.and(new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"CONTAINER_ID"), (Object)contId, 0));
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(del);
            }
            if (!componentExist && workflowRAE) {
                Long workflowContId = null;
                Long aDSSPAdContId = null;
                Criteria layoutContCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"LAYOUT_ID"), (Object)DEFAULT_LAYOUT_ID, 0);
                layoutContCri = layoutContCri.and(new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"), (Object)"admp.home.workflow.awaiting_requests", 0));
                DataObject layoutContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", layoutContCri);
                Row cont = layoutContDO.getFirstRow("ADSLayoutContainers");
                workflowContId = (Long)cont.get("CONTAINER_ID");
                layoutContCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"LAYOUT_ID"), (Object)DEFAULT_LAYOUT_ID, 0);
                layoutContCri = layoutContCri.and(new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"), (Object)"ADSSP_advertisement", 0));
                layoutContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", layoutContCri);
                cont = layoutContDO.getFirstRow("ADSLayoutContainers");
                aDSSPAdContId = (Long)cont.get("CONTAINER_ID");
                rhsCri = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)layoutId, 0);
                DataObject rhsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutRHS", rhsCri);
                rhsDO.sortRows("ADSLayoutRHS", new SortColumn[]{new SortColumn(Column.getColumn((String)"ADSLayoutRHS", (String)"PRIORITY_ID"), true)});
                Iterator rhsItr = rhsDO.getRows("ADSLayoutRHS");
                long lowestAvailable = 1L;
                while (rhsItr.hasNext()) {
                    Row rhsRow = (Row)rhsItr.next();
                    Long priId = (Long)rhsRow.get("PRIORITY_ID");
                    if (((Long)rhsRow.get("CONTAINER_ID")).compareTo(aDSSPAdContId) == 0) {
                        if (lowestAvailable > priId) continue;
                        lowestAvailable = priId + 1L;
                        continue;
                    }
                    if (priId < lowestAvailable) continue;
                    priId = priId + 1L;
                    rhsRow.set("PRIORITY_ID", (Object)priId);
                    rhsDO.updateRow(rhsRow);
                }
                Row workflowSummaryRow = new Row("ADSLayoutRHS");
                workflowSummaryRow.set("LAYOUT_ID", (Object)layoutId);
                workflowSummaryRow.set("CONTAINER_ID", (Object)workflowContId);
                workflowSummaryRow.set("PRIORITY_ID", (Object)lowestAvailable);
                rhsDO.addRow(workflowSummaryRow);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(rhsDO);
            }
            Criteria statusCri = new Criteria(Column.getColumn((String)ADMPDASHBOARD, (String)LOGIN_ID), (Object)loginId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPDASHBOARD, statusCri);
            Row row = dO.getFirstRow(ADMPDASHBOARD);
            row.set("STATUS", null);
            dO.updateRow(row);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dO);
            logger.log(Level.INFO, "Dashboard layout workflow checked successfully for loginId: " + loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Error in workflow check in dashboard layout for loginId: " + loginId);
        }
    }

    public static void addDefaultWidgets(Long loginId, Long layoutId, Long defaultTabId, ADMPAuthObject authObject) {
        try {
            boolean hasResetPassPermission = authObject.getActionList().contains(1012L);
            if (hasResetPassPermission) {
                boolean componentExist = false;
                SelectQueryImpl rhsContQuery = new SelectQueryImpl(Table.getTable((String)"ADSLayoutContainers"));
                rhsContQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"));
                rhsContQuery.addSelectColumn(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"));
                rhsContQuery.addJoin(new Join("ADSLayoutContainers", "ADSLayoutRHS", new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
                Criteria rhsCri = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)layoutId, 0);
                rhsCri = rhsCri.and(new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"), (Object)"admp.home.image_text.inside_admp", 0));
                rhsContQuery.setCriteria(rhsCri);
                DataObject rhsContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)rhsContQuery);
                Iterator rhsRows = rhsContDO.getRows("ADSLayoutContainers");
                while (rhsRows.hasNext()) {
                    Row cont = (Row)rhsRows.next();
                    Long contId = (Long)cont.get("CONTAINER_ID");
                    Criteria moduleCri = new Criteria(Column.getColumn((String)"ADSContainerVsComponent", (String)"CONTAINER_ID"), (Object)contId, 0);
                    moduleCri = moduleCri.and(new Criteria(Column.getColumn((String)"ADSContainerVsComponent", (String)"MODULE_ID"), (Object)11L, 0));
                    boolean tempComponentExist = !CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSContainerVsComponent", moduleCri).isEmpty();
                    componentExist = componentExist || tempComponentExist;
                }
                if (!componentExist) {
                    Long aDSSPAdContId = null;
                    Long resetPassContId = null;
                    Criteria layoutContCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"LAYOUT_ID"), (Object)DEFAULT_LAYOUT_ID, 0);
                    layoutContCri = layoutContCri.and(new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"), (Object)"admp.home.image_text.inside_admp", 0));
                    DataObject layoutContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", layoutContCri);
                    Row cont = layoutContDO.getFirstRow("ADSLayoutContainers");
                    resetPassContId = (Long)cont.get("CONTAINER_ID");
                    layoutContCri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"LAYOUT_ID"), (Object)DEFAULT_LAYOUT_ID, 0);
                    layoutContCri = layoutContCri.and(new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_NAME"), (Object)"ADSSP_advertisement", 0));
                    layoutContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", layoutContCri);
                    cont = layoutContDO.getFirstRow("ADSLayoutContainers");
                    aDSSPAdContId = (Long)cont.get("CONTAINER_ID");
                    rhsCri = new Criteria(Column.getColumn((String)"ADSLayoutRHS", (String)"LAYOUT_ID"), (Object)layoutId, 0);
                    DataObject rhsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutRHS", rhsCri);
                    rhsDO.sortRows("ADSLayoutRHS", new SortColumn[]{new SortColumn(Column.getColumn((String)"ADSLayoutRHS", (String)"PRIORITY_ID"), true)});
                    Iterator rhsItr = rhsDO.getRows("ADSLayoutRHS");
                    long lowestAvailable = 1L;
                    while (rhsItr.hasNext()) {
                        Row rhsRow = (Row)rhsItr.next();
                        Long priId = (Long)rhsRow.get("PRIORITY_ID");
                        if (((Long)rhsRow.get("CONTAINER_ID")).compareTo(aDSSPAdContId) == 0) {
                            if (lowestAvailable > priId) continue;
                            lowestAvailable = priId + 1L;
                            continue;
                        }
                        if (priId < lowestAvailable) continue;
                        priId = priId + 1L;
                        rhsRow.set("PRIORITY_ID", (Object)priId);
                        rhsDO.updateRow(rhsRow);
                    }
                    Row resetPassRow = new Row("ADSLayoutRHS");
                    resetPassRow.set("LAYOUT_ID", (Object)layoutId);
                    resetPassRow.set("CONTAINER_ID", (Object)resetPassContId);
                    resetPassRow.set("PRIORITY_ID", (Object)lowestAvailable);
                    rhsDO.addRow(resetPassRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(rhsDO);
                }
            }
            logger.log(Level.INFO, "Default widgets (if not present and HDT has permission) are added in Dashboard layout successfully for loginId: " + loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Error in addding default widgets in dashboard layout for loginId: " + loginId);
        }
    }

    public static HashMap<Long, HashMap> getDomainMgmtValues(Long tabId, Long[] reportIds, String domainName, boolean hasCount) {
        HashMap<Long, HashMap> mgmtValues = new HashMap<Long, HashMap>();
        try {
            SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)"ADSTabVsContainer"));
            chartQuery.addJoin(new Join("ADSTabVsContainer", ADMPCHARTCOMPONENT, new String[]{"CONTAINER_ID"}, new String[]{"CONTAINER_ID"}, 1));
            chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
            chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)CHART_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)SERIES_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
            chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
            chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
            Criteria cri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)tabId, 0);
            cri = cri.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)REPORT_ID), (Object)reportIds, 8));
            cri = cri.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            if (hasCount) {
                cri = cri.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)"COUNT"), null, 1));
                cri = cri.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)"COUNT"), (Object)0, 1));
            }
            chartQuery.setCriteria(cri);
            DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
            Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS);
            while (pointItr.hasNext()) {
                Row pointRow = (Row)pointItr.next();
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                valueMap.put("COUNT", pointRow.get("COUNT"));
                valueMap.put("REPORT_GENERATION_ID", pointRow.get("REPORT_GENERATION_ID"));
                valueMap.put(POINT_ID, pointRow.get(POINT_ID));
                mgmtValues.put((Long)pointRow.get(REPORT_ID), valueMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mgmtValues;
    }

    private static HashMap<String, HashMap> getDomainReportValues(Long tabId, boolean deleteSeries) {
        HashMap<String, HashMap> domainReportValues = new HashMap<String, HashMap>();
        HashMap<Long, Long> chartIdMap = new HashMap<Long, Long>();
        try {
            ArrayList<Long> seriesList = new ArrayList<Long>();
            Criteria tabCri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)tabId, 0);
            DataObject tabContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSTabVsContainer", tabCri);
            Iterator tabRows = tabContDO.getRows("ADSTabVsContainer");
            while (tabRows.hasNext()) {
                Row cont = (Row)tabRows.next();
                Long contId = (Long)cont.get("CONTAINER_ID");
                SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
                chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
                chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)CHART_ID));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"REFERENCE_CHART_ID"));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)SERIES_ID));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
                Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)contId, 0);
                chartQuery.setCriteria(chartCri);
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
                DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
                Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
                while (chartItr.hasNext()) {
                    Row chartRow = (Row)chartItr.next();
                    Long chartId = (Long)chartRow.get(CHART_ID);
                    chartIdMap.put((Long)chartRow.get("REFERENCE_CHART_ID"), chartId);
                    Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                    Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                    while (seriesItr.hasNext()) {
                        Row seriesRow = (Row)seriesItr.next();
                        Long seriesId = (Long)seriesRow.get(SERIES_ID);
                        seriesList.add(seriesId);
                        Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                        Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                        while (pointItr.hasNext()) {
                            Row pointRow = (Row)pointItr.next();
                            HashMap<String, Object> countGenIdMap = new HashMap<String, Object>();
                            countGenIdMap.put("COUNT", pointRow.get("COUNT"));
                            countGenIdMap.put("REPORT_GENERATION_ID", pointRow.get("REPORT_GENERATION_ID"));
                            domainReportValues.put(pointRow.get("DOMAIN_NAME") + "_" + pointRow.get(REPORT_ID), countGenIdMap);
                        }
                    }
                }
            }
            if (deleteSeries) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)SERIES_ID), (Object)seriesList.toArray(new Long[0]), 8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        domainReportValues.put("chartIdMap", chartIdMap);
        return domainReportValues;
    }

    public static void copyReportInputVals(Long fromPointId, Object toPointId, DataObject dObj) {
        try {
            Criteria inputsCri = new Criteria(Column.getColumn((String)"DashboardReportInputVals", (String)DASHBOARD_REPORT_MAPPING), (Object)fromPointId, 0);
            DataObject inputsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("DashboardReportInputVals", inputsCri);
            if (!inputsDO.isEmpty()) {
                Iterator inputsItr = inputsDO.getRows("DashboardReportInputVals");
                while (inputsItr.hasNext()) {
                    Row inputRow = (Row)inputsItr.next();
                    Row newInput = new Row("DashboardReportInputVals");
                    newInput.set(DASHBOARD_REPORT_MAPPING, toPointId);
                    newInput.set("PROPERTY", inputRow.get("PROPERTY"));
                    newInput.set("VALUE", inputRow.get("VALUE"));
                    dObj.addRow(newInput);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMenu(Row containerRow, Long[] menuIds, DataObject dObj) {
        try {
            Long priorityId = 1L;
            boolean isCustomizable = false;
            boolean isDefault = true;
            for (Long menuId : menuIds) {
                if (menuId == 1L) {
                    isDefault = false;
                    continue;
                }
                if (menuId == 2L) {
                    isCustomizable = true;
                    continue;
                }
                Row contVsMenu = new Row("ADSContainerVsMenu");
                contVsMenu.set("CONTAINER_ID", containerRow.get("CONTAINER_ID"));
                contVsMenu.set("MENU_ID", (Object)menuId);
                Long l = priorityId;
                Long l2 = priorityId = Long.valueOf(priorityId + 1L);
                contVsMenu.set("PRIORITY_ID", (Object)l);
                dObj.addRow(contVsMenu);
            }
            containerRow.set("IS_CUSTOMIZABLE", (Object)isCustomizable);
            containerRow.set("IS_DEFAULT", (Object)isDefault);
            dObj.updateRow(containerRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyColumnValues(Row to, Row from, String[] cols) {
        try {
            for (String col : cols) {
                to.set(col, from.get(col));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkIfDefaultTabContainer(Long loginId, Long containerId) {
        try {
            Criteria statusCri = new Criteria(Column.getColumn((String)ADMPDASHBOARD, (String)LOGIN_ID), (Object)loginId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPDASHBOARD, statusCri);
            Row row = dO.getFirstRow(ADMPDASHBOARD);
            Criteria tabCri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)((Long)row.get("DEFAULT_TAB_ID")), 0);
            tabCri = tabCri.and(new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"CONTAINER_ID"), (Object)containerId, 0));
            dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSTabVsContainer", tabCri);
            if (!dO.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ArrayList getContainerActionList(Long containerId) {
        ArrayList<Long> actionList = new ArrayList<Long>();
        try {
            SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
            chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
            chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)CHART_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)SERIES_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)POINT_ID));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"ACTION_ID"));
            Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)containerId, 0);
            chartQuery.setCriteria(chartCri);
            chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
            DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
            Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
            while (chartItr.hasNext()) {
                Row chartRow = (Row)chartItr.next();
                Long chartId = (Long)chartRow.get(CHART_ID);
                Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                while (seriesItr.hasNext()) {
                    Row seriesRow = (Row)seriesItr.next();
                    Long seriesId = (Long)seriesRow.get(SERIES_ID);
                    Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                    Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                    while (pointItr.hasNext()) {
                        Row pointRow = (Row)pointItr.next();
                        actionList.add((Long)pointRow.get("ACTION_ID"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionList;
    }

    public static ArrayList getNewReportMappings(Long loginId, boolean forDefaultTabOnly) throws Exception {
        ArrayList reportMappings = new ArrayList();
        Criteria c = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)LOGIN_ID), (Object)loginId, 0);
        c = c.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)"COUNT"), null, 0));
        if (forDefaultTabOnly) {
            c = c.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)"DOMAIN_NAME"), null, 1));
        }
        DataObject pdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPCHARTPOINTS, c);
        Iterator pointRows = pdO.getRows(ADMPCHARTPOINTS);
        while (pointRows.hasNext()) {
            Row pointRow = (Row)pointRows.next();
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("reportId", ((Long)pointRow.get(REPORT_ID)).intValue());
            hash.put("dashboardReportMapping", (Long)pointRow.get(POINT_ID));
            if (pointRow.get("DOMAIN_NAME") != null) {
                hash.put("domainName", (String)pointRow.get("DOMAIN_NAME"));
            }
            reportMappings.add(hash);
        }
        return reportMappings;
    }

    public static ArrayList getReportMappings(Long containerId) throws Exception {
        return DashboardUtil.getReportMappings(containerId, null);
    }

    public static ArrayList getReportMappings(Long containerId, String domainName) throws Exception {
        ArrayList reportMappings = new ArrayList();
        Criteria c = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)containerId, 0);
        DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPCHARTCOMPONENT, c);
        Row chartRow = dO.getFirstRow(ADMPCHARTCOMPONENT);
        Long chartId = (Long)chartRow.get(CHART_ID);
        Criteria sc = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
        DataObject sdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPCHARTSERIES, sc);
        Iterator seriesRows = sdO.getRows(ADMPCHARTSERIES);
        while (seriesRows.hasNext()) {
            Row seriesRow = (Row)seriesRows.next();
            Long seriesId = (Long)seriesRow.get(SERIES_ID);
            Criteria pc = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
            if (domainName != null) {
                pc = pc.and(new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            }
            DataObject pdO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPCHARTPOINTS, pc);
            Iterator pointRows = pdO.getRows(ADMPCHARTPOINTS);
            while (pointRows.hasNext()) {
                Row pointRow = (Row)pointRows.next();
                HashMap<String, Object> hash = new HashMap<String, Object>();
                hash.put("reportId", ((Long)pointRow.get(REPORT_ID)).intValue());
                hash.put("dashboardReportMapping", (Long)pointRow.get(POINT_ID));
                if (pointRow.get("DOMAIN_NAME") != null) {
                    hash.put("domainName", (String)pointRow.get("DOMAIN_NAME"));
                }
                reportMappings.add(hash);
            }
        }
        return reportMappings;
    }

    public static void addChartPointsForDomain(Long loginId, String domainName) {
        try {
            boolean pointsAdded = false;
            Row statusRow = DashboardUtil.getStatusRow(loginId);
            Long tabId = (Long)statusRow.get("DEFAULT_TAB_ID");
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Criteria tabCri = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)tabId, 0);
            DataObject tabContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSTabVsContainer", tabCri);
            Iterator tabRows = tabContDO.getRows("ADSTabVsContainer");
            while (tabRows.hasNext()) {
                Row cont = (Row)tabRows.next();
                Long contId = (Long)cont.get("CONTAINER_ID");
                SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
                chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
                chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"*"));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)"*"));
                chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
                Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)contId, 0);
                chartQuery.setCriteria(chartCri);
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
                chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
                DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
                Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
                while (chartItr.hasNext()) {
                    Row chartRow = (Row)chartItr.next();
                    Long chartId = (Long)chartRow.get(CHART_ID);
                    Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                    Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                    while (seriesItr.hasNext()) {
                        Row seriesRow = (Row)seriesItr.next();
                        Long seriesId = (Long)seriesRow.get(SERIES_ID);
                        boolean seriesPointAdded = false;
                        Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                        Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                        while (pointItr.hasNext() && !seriesPointAdded) {
                            Row pointRow = (Row)pointItr.next();
                            Row newPoint = new Row(ADMPCHARTPOINTS);
                            newPoint.set("DOMAIN_NAME", (Object)domainName);
                            DashboardUtil.copyColumnValues(newPoint, pointRow, new String[]{SERIES_ID, REPORT_ID, "ACTION_ID", "POINT_NAME", "PRIORITY_ID", LOGIN_ID});
                            dataObj.addRow(newPoint);
                            DashboardUtil.copyReportInputVals((Long)pointRow.get(POINT_ID), newPoint.get(POINT_ID), dataObj);
                            seriesPointAdded = true;
                            pointsAdded = true;
                        }
                    }
                }
            }
            if (pointsAdded) {
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            } else if (loginId.compareTo(com.adventnet.sym.adsm.common.server.util.CommonUtil.ADMIN_LOGIN_ID) == 0) {
                Criteria statusCri = new Criteria(Column.getColumn((String)ADMPDASHBOARD, (String)LOGIN_ID), (Object)loginId, 0);
                DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPDASHBOARD, statusCri);
                Row row = dO.getFirstRow(ADMPDASHBOARD);
                row.set("STATUS", (Object)"reset");
                dO.updateRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dO);
            } else {
                DashboardUtil.checkDomain(loginId, (Long)statusRow.get("LAYOUT_ID"), tabId, new ADMPAuthObject(loginId));
            }
            tabContDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSTabVsContainer", tabCri);
            tabRows = tabContDO.getRows("ADSTabVsContainer");
            ArrayList<Long> newChartContIds = new ArrayList<Long>();
            while (tabRows.hasNext()) {
                Row cont = (Row)tabRows.next();
                newChartContIds.add((Long)cont.get("CONTAINER_ID"));
            }
            if (newChartContIds.size() > 0) {
                DashboardRefreshHandler.getInstance().updateCountForContainers(loginId, newChartContIds, domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cloneChartComponent(Long fromContId, Object toContId, DataObject dataObj, Long loginId, String domainName) {
        try {
            SelectQueryImpl chartQuery = new SelectQueryImpl(Table.getTable((String)ADMPCHARTCOMPONENT));
            chartQuery.addJoin(new Join(ADMPCHARTCOMPONENT, ADMPCHARTSERIES, new String[]{CHART_ID}, new String[]{CHART_ID}, 1));
            chartQuery.addJoin(new Join(ADMPCHARTSERIES, ADMPCHARTPOINTS, new String[]{SERIES_ID}, new String[]{SERIES_ID}, 1));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"*"));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTSERIES, (String)"*"));
            chartQuery.addSelectColumn(Column.getColumn((String)ADMPCHARTPOINTS, (String)"*"));
            Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)fromContId, 0);
            chartQuery.setCriteria(chartCri);
            chartQuery.addSortColumn(new SortColumn(ADMPCHARTSERIES, SERIES_ID, true));
            chartQuery.addSortColumn(new SortColumn(ADMPCHARTPOINTS, "PRIORITY_ID", true));
            DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)chartQuery);
            Iterator chartItr = chartDO.getRows(ADMPCHARTCOMPONENT);
            while (chartItr.hasNext()) {
                Row chartRow = (Row)chartItr.next();
                Long chartId = (Long)chartRow.get(CHART_ID);
                Row newChart = new Row(ADMPCHARTCOMPONENT);
                Criteria seriesCri = new Criteria(Column.getColumn((String)ADMPCHARTSERIES, (String)CHART_ID), (Object)chartId, 0);
                Iterator seriesItr = chartDO.getRows(ADMPCHARTSERIES, seriesCri);
                while (seriesItr.hasNext()) {
                    Row seriesRow = (Row)seriesItr.next();
                    Long seriesId = (Long)seriesRow.get(SERIES_ID);
                    Row newSeries = new Row(ADMPCHARTSERIES);
                    Criteria pointCri = new Criteria(Column.getColumn((String)ADMPCHARTPOINTS, (String)SERIES_ID), (Object)seriesId, 0);
                    Iterator pointItr = chartDO.getRows(ADMPCHARTPOINTS, pointCri);
                    while (pointItr.hasNext()) {
                        Row pointRow = (Row)pointItr.next();
                        Row newPoint = new Row(ADMPCHARTPOINTS);
                        newPoint.set(SERIES_ID, newSeries.get(SERIES_ID));
                        if (domainName == null) {
                            domainName = (String)pointRow.get("DOMAIN_NAME");
                        }
                        newPoint.set("DOMAIN_NAME", (Object)domainName);
                        newPoint.set(LOGIN_ID, (Object)loginId);
                        DashboardUtil.copyColumnValues(newPoint, pointRow, new String[]{REPORT_ID, "ACTION_ID", "POINT_NAME", "PRIORITY_ID"});
                        dataObj.addRow(newPoint);
                        DashboardUtil.copyReportInputVals((Long)pointRow.get(POINT_ID), newPoint.get(POINT_ID), dataObj);
                    }
                    newSeries.set(CHART_ID, newChart.get(CHART_ID));
                    newSeries.set("SERIES_NAME", seriesRow.get("SERIES_NAME"));
                    dataObj.addRow(newSeries);
                }
                newChart.set("CONTAINER_ID", toContId);
                newChart.set("REFERENCE_CHART_ID", chartRow.get(CHART_ID));
                DashboardUtil.copyColumnValues(newChart, chartRow, new String[]{"TITLE", "X_TITLE", "Y_TITLE", "TYPE", "STACKING"});
                dataObj.addRow(newChart);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addNewChartContainer(JSONObject containerParams, DataObject dataObj) throws Exception {
        Row newChartCont = new Row("ADSLayoutContainers");
        newChartCont.set("LAYOUT_ID", (Object)containerParams.getLong("LAYOUT_ID"));
        newChartCont.set("CONTAINER_NAME", (Object)containerParams.getString("CONTAINER_NAME"));
        newChartCont.set(WIDTH, (Object)(containerParams.has(WIDTH) ? containerParams.getLong(WIDTH) : 50L));
        dataObj.addRow(newChartCont);
        DashboardUtil.setMenu(newChartCont, new Long[]{1L, 2L}, dataObj);
        Row chartContMap = new Row("ADSTabVsContainer");
        chartContMap.set("TAB_ID", (Object)containerParams.getLong("TAB_ID"));
        chartContMap.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
        chartContMap.set("PRIORITY_ID", (Object)(CustomizationHandler.getMaxPriorityId((String)"ADSTabVsContainer", (String)"TAB_ID", (String)containerParams.getString("TAB_ID")) + 1L));
        dataObj.addRow(chartContMap);
        Row contVsComp = new Row("ADSContainerVsComponent");
        contVsComp.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
        contVsComp.set("COMPONENT_ID", (Object)14L);
        contVsComp.set("MODULE_ID", (Object)14L);
        dataObj.addRow(contVsComp);
        Row newChart = new Row(ADMPCHARTCOMPONENT);
        newChart.set("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
        newChart.set("TYPE", (Object)(containerParams.has("TYPE") ? containerParams.getString("TYPE") : "column"));
        dataObj.addRow(newChart);
        containerParams.put("CONTAINER_ID", newChartCont.get("CONTAINER_ID"));
        containerParams.put("newChartContRow", (Object)newChartCont);
        containerParams.put(CHART_ID, newChart.get(CHART_ID));
    }

    private static boolean addChartPoint(JSONObject containerParams, DataObject dataObj) {
        boolean chartAdded = false;
        try {
            boolean isNewTab = containerParams.optBoolean("isNewTab");
            boolean isNewCont = containerParams.optBoolean("isNewContainer");
            Long tabId = containerParams.has("TAB_ID") ? Long.valueOf(containerParams.getLong("TAB_ID")) : null;
            Long contId = containerParams.has("CONTAINER_ID") ? Long.valueOf(containerParams.getLong("CONTAINER_ID")) : null;
            Object chartId = null;
            if (isNewTab) {
                tabId = TabsHandler.addTab((long)containerParams.getLong("LAYOUT_ID"), (String)containerParams.getString("TAB_NAME"));
            }
            if (isNewCont) {
                containerParams.put("TAB_ID", (Object)tabId);
                DashboardUtil.addNewChartContainer(containerParams, dataObj);
                chartId = containerParams.get(CHART_ID);
            } else {
                Criteria chartCri = new Criteria(Column.getColumn((String)ADMPCHARTCOMPONENT, (String)"CONTAINER_ID"), (Object)contId, 0);
                DataObject chartDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPCHARTCOMPONENT, chartCri);
                chartId = chartDO.getFirstRow(ADMPCHARTCOMPONENT).get(CHART_ID);
            }
            Row newSeries = new Row(ADMPCHARTSERIES);
            newSeries.set(CHART_ID, chartId);
            newSeries.set("SERIES_NAME", (Object)containerParams.getString("SERIES_NAME"));
            dataObj.addRow(newSeries);
            Row newPoint = new Row(ADMPCHARTPOINTS);
            newPoint.set(SERIES_ID, newSeries.get(SERIES_ID));
            newPoint.set(REPORT_ID, (Object)containerParams.getLong(REPORT_ID));
            newPoint.set(LOGIN_ID, (Object)containerParams.getLong(LOGIN_ID));
            newPoint.set("ACTION_ID", (Object)ClientUtil.getActionId(containerParams.getInt(REPORT_ID)));
            newPoint.set("POINT_NAME", (Object)containerParams.optString("POINT_NAME", containerParams.getString("SERIES_NAME")));
            newPoint.set("PRIORITY_ID", (Object)1L);
            dataObj.addRow(newPoint);
            containerParams.put(POINT_ID, newPoint.get(POINT_ID));
            containerParams.put("newPointRow", (Object)newPoint);
            chartAdded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chartAdded;
    }

    public static String addReportToDashboard(Hashtable hash) {
        JSONObject result = new JSONObject();
        AdventNetResourceBundle rb = (AdventNetResourceBundle)hash.get("rb");
        try {
            Long loginId = (Long)hash.get(LOGIN_ID);
            Row statusRow = DashboardUtil.getStatusRow(loginId);
            if (statusRow == null) {
                result.put("status", (Object)rb.getString("admp.home.dashboard.no_dashboard"));
                return result.toString();
            }
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            JSONObject containerParams = (JSONObject)hash.get("containerParams");
            containerParams.put("LAYOUT_ID", (Object)((Long)statusRow.get("LAYOUT_ID")));
            containerParams.put(REPORT_ID, (Object)((Integer)hash.get(REPORT_ID)));
            containerParams.put(LOGIN_ID, (Object)loginId);
            if (DashboardUtil.addChartPoint(containerParams, dataObj)) {
                hash.put(DASHBOARD_REPORT_MAPPING, containerParams.get(POINT_ID));
                DashboardUtil.addDashboardReportDetails(hash, dataObj);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                result.put("status", (Object)rb.getString("admp.home.dashboard.report_to_dashboard_success"));
                HttpSession session = (HttpSession)hash.get("session");
                session.setAttribute("addToDashboardWarningShown", (Object)true);
                ArrayList reportMappings = new ArrayList();
                Long pointId = (Long)((Row)containerParams.get("newPointRow")).get(POINT_ID);
                Long containerId = containerParams.has("newChartContRow") ? ((Long)((Row)containerParams.get("newChartContRow")).get("CONTAINER_ID")).longValue() : containerParams.getLong("CONTAINER_ID");
                HashMap<String, Number> reportHash = new HashMap<String, Number>();
                reportHash.put("reportId", (Integer)hash.get(REPORT_ID));
                reportHash.put("dashboardReportMapping", pointId);
                reportMappings.add(reportHash);
                DashboardRefreshHandler.getInstance().updateCount(loginId, containerId, null, pointId, reportMappings);
            } else {
                result.put("status", (Object)(rb.getString("admp.home.dashboard.report_to_dashboard_fail") + rb.getString("admp.home.dashboard.add_chart_fail")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{\"status\":\"" + rb.getString("admp.home.dashboard.report_to_dashboard_fail") + rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occurred") + "\"}";
        }
        return result.toString();
    }

    public static void addDashboardReportDetails(Hashtable hash, DataObject dataObj) {
        Object drm = hash.get(DASHBOARD_REPORT_MAPPING);
        Integer reportId = (Integer)hash.get(REPORT_ID);
        try {
            String[] domainDNs = (String[])hash.get("domainNames");
            Hashtable domainOUList = (Hashtable)hash.get("domainOUList");
            Hashtable excludedOUListMap = (Hashtable)hash.get("excludedOUList");
            Hashtable exclChildOUListMap = (Hashtable)hash.get("domainVsExcludeChildOU");
            HashMap domainDetails = new HashMap();
            domainDetails.put(DASHBOARD_REPORT_MAPPING, drm);
            HashMap<String, ArrayList> selectedOUMap = new HashMap<String, ArrayList>();
            domainDetails.put("domainOUList", selectedOUMap);
            HashMap excludedOUMap = new HashMap();
            domainDetails.put("excludedOUList", excludedOUMap);
            HashMap exclChildOUMap = new HashMap();
            domainDetails.put("domainVsExcludeChildOU", exclChildOUMap);
            ArrayList<String> domains = new ArrayList<String>();
            domainDetails.put("domains", domains);
            for (int i = 0; i < domainDNs.length; ++i) {
                ArrayList selectedOUList = (ArrayList)domainOUList.get(domainDNs[i]);
                String domainName = DomainUtil.getDomainName((String)domainDNs[i]);
                domains.add(domainName);
                if (selectedOUList == null) continue;
                selectedOUMap.put(domainName, selectedOUList);
                excludedOUMap.put(domainName, excludedOUListMap.get(domainName));
                exclChildOUMap.put(domainName, exclChildOUListMap.get(domainName));
            }
            DashboardUtil.addDomainDetails(domainDetails, dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Row row;
            JSONArray reportInputs = (JSONArray)hash.get("reportInputs");
            for (int k = 0; k < reportInputs.length(); ++k) {
                JSONObject input = reportInputs.getJSONObject(k);
                row = new Row("DashboardReportInputVals");
                row.set("PROPERTY", (Object)input.getString("PROPERTY"));
                row.set(DASHBOARD_REPORT_MAPPING, drm);
                if (input.optBoolean("IS_MULTIPLE")) {
                    row.set("IS_MULTIPLE", (Object)true);
                    JSONArray multiInputs = input.getJSONArray("VALUE");
                    for (int m = 0; m < multiInputs.length(); ++m) {
                        JSONObject multiInput = multiInputs.getJSONObject(m);
                        Row multiRow = new Row("DashboardReportInputMultiVals");
                        multiRow.set("CLIENT_VALUE", (Object)multiInput.getString("CLIENT_VALUE"));
                        multiRow.set("SERVER_VALUE", (Object)multiInput.getString("SERVER_VALUE"));
                        multiRow.set("INPUT_ID", row.get("INPUT_ID"));
                        dataObj.addRow(multiRow);
                    }
                } else {
                    row.set("VALUE", (Object)input.getString("VALUE"));
                }
                dataObj.addRow(row);
            }
            if (reportId == 16) {
                DataObject obj = ReportHandler.getEmptyAttributeList((String)"1");
                Iterator selectedList = obj.getRows("ADSMEmptyAttributeList");
                row = new Row("DashboardReportInputVals");
                row.set("PROPERTY", (Object)"emptyAttributeList");
                row.set(DASHBOARD_REPORT_MAPPING, drm);
                row.set("IS_MULTIPLE", (Object)true);
                while (selectedList.hasNext()) {
                    Row attr = (Row)selectedList.next();
                    Row multiRow = new Row("DashboardReportInputMultiVals");
                    multiRow.set("CLIENT_VALUE", attr.get("ATTRIB_DISP_NAME"));
                    multiRow.set("SERVER_VALUE", (Object)attr.get("EMPTY_ATTRIB_ID").toString());
                    multiRow.set("INPUT_ID", row.get("INPUT_ID"));
                    dataObj.addRow(multiRow);
                }
                dataObj.addRow(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addDomainDetails(HashMap domainDetails, DataObject dataObj) {
        try {
            ArrayList domains = (ArrayList)domainDetails.get("domains");
            HashMap domainVsExcludeChildOU = (HashMap)domainDetails.get("domainVsExcludeChildOU");
            Object drm = domainDetails.get(DASHBOARD_REPORT_MAPPING);
            for (int i = 0; i < domains.size(); ++i) {
                String domain = (String)domains.get(i);
                Row domainRow = new Row("DashboardReportDomainMapping");
                domainRow.set(DASHBOARD_REPORT_MAPPING, drm);
                domainRow.set("DOMAIN_NAME", (Object)domain);
                dataObj.addRow(domainRow);
                if (domainVsExcludeChildOU.get(domain) == null) continue;
                Row row = new Row("DashboardReportExclChildMapping");
                row.set(DASHBOARD_REPORT_MAPPING, drm);
                row.set("IS_EXCLUDE_CHILD_OU", (Object)((Boolean)domainVsExcludeChildOU.get(domain)));
                row.set("DOMAIN_NAME", (Object)domain);
                dataObj.addRow(row);
            }
            String[] mappingTable = new String[]{"DashboardReportOUMapping", "DashboardReportExcludeOUMapping"};
            String[] mappingInput = new String[]{"domainOUList", "excludedOUList"};
            for (int i = 0; i < mappingTable.length; ++i) {
                HashMap hashmap = (HashMap)domainDetails.get(mappingInput[i]);
                Set keys = hashmap.keySet();
                for (String domainName : keys) {
                    ArrayList ous = (ArrayList)hashmap.get(domainName);
                    DataObject guidDO = OUUtil.getGUIDDataObjectFromDNs((ArrayList)ous);
                    for (int k = 0; k < ous.size(); ++k) {
                        String ouName = (String)ous.get(k);
                        Row row = new Row(mappingTable[i]);
                        row.set(DASHBOARD_REPORT_MAPPING, drm);
                        row.set("OU_NAME", (Object)ouName);
                        row.set("DOMAIN_NAME", (Object)domainName);
                        Row guidRow = guidDO.getRow("ADSMOUDetails", new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"), (Object)ouName, 0));
                        if (guidRow != null) {
                            row.set("OBJECT_GUID", guidRow.get("OBJECT_GUID"));
                        }
                        dataObj.addRow(row);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateCountForContainers(Long loginId, ArrayList<Long> newChartContIds, Long layoutId) {
        try {
            if (loginId == null && layoutId != null) {
                Criteria statusCri = new Criteria(Column.getColumn((String)ADMPDASHBOARD, (String)"LAYOUT_ID"), (Object)layoutId, 0);
                DataObject statusDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(ADMPDASHBOARD, statusCri);
                if (!statusDO.isEmpty()) {
                    loginId = (Long)statusDO.getFirstRow(ADMPDASHBOARD).get(LOGIN_ID);
                }
            }
            if (loginId != null) {
                DashboardRefreshHandler.getInstance().updateCountForContainers(loginId, newChartContIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

