/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delayedtask;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.webclient.delayedtask.ScheduleDelayedTaskListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class ExchOnlineDelayedTaskListener
extends ScheduleDelayedTaskListener {
    @Override
    protected void execute(Properties taskProp, HashMap taskDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String message = "";
        boolean isSuccess = false;
        String waadTenantId = (String)taskProp.get("DOMAIN_NAME");
        String objectName = (String)taskProp.get("OBJECT_NAME");
        logger.log(Level.FINE, "Executing delayed task for tenant: " + waadTenantId + " Object modified: " + objectName);
        String objectId = (String)taskProp.get("OBJECT_ID");
        String script = this.getScriptForExchOnlineTask(taskDetails, objectId);
        Properties o365Props = DomainInfoCache.getInstance().getWAADDomainProperties(waadTenantId);
        String tenantPass = (String)o365Props.get("WAAD_TENANT_PASSWD");
        message = tenantPass != null ? ADHandler.runCustomExchOnlineScript((String)waadTenantId, (String)tenantPass, (String)script) : "admp.mgmt.gpo_mgmt_some_err_occ";
        if (message.length() == 0) {
            isSuccess = true;
            message = "admp.mgmt.common.text.successfully_modified";
        }
        this.setExecutionStatus(isSuccess);
        this.setStatusMessage(message);
        logger.log(Level.FINE, "Completed execution of exchange online task. isSuccess: " + isSuccess);
        this.setAuditPropList(taskDetails, rb);
        TechAuditAPI.getInstance().auditO365Modification(loginId, rb.getString("admp.delayedtask.category.exch_online_mbx_mgmt"), objectName, waadTenantId, this.auditPropList, new ArrayList(), new ArrayList(), rb.getString(message), (Long)audit_info.get("object_id"), auditDataObj, rb);
    }

    private String getScriptForExchOnlineTask(HashMap inputMap, String objectId) {
        String script = new String();
        String setMailboxScript = new String();
        String addDistGroupMemCommonScript = "Add-DistributionGroupMember -Identity";
        String o365GroupCommonScript = "Add-UnifiedGroupLinks -Identity";
        if (inputMap.size() > 0) {
            ArrayList groupList;
            if (inputMap.get("InPlaceArchive") != null) {
                String archiveName;
                String enableMailboxScript = "Enable-Mailbox -Identity " + objectId + " -Archive ";
                if (inputMap.get("ArchiveName") != null && (archiveName = (String)inputMap.get("ArchiveName")).length() > 0) {
                    enableMailboxScript = enableMailboxScript + "-ArchiveName \"" + archiveName + "\"";
                }
                script = script + enableMailboxScript + ";";
            }
            if (inputMap.get("LitigationHoldEnabled") != null) {
                String duration;
                setMailboxScript = "Set-Mailbox -Identity " + objectId;
                setMailboxScript = setMailboxScript + " -LitigationHoldEnabled $true";
                if (inputMap.get("LitigationHoldDuration") != null && (duration = (String)inputMap.get("LitigationHoldDuration")).length() > 0) {
                    setMailboxScript = setMailboxScript + " -LitigationHoldDuration " + duration;
                }
            }
            if (inputMap.get("Alias") != null) {
                if (setMailboxScript.length() == 0) {
                    setMailboxScript = "Set-Mailbox -Identity " + objectId;
                }
                String alias = (String)inputMap.get("Alias");
                setMailboxScript = setMailboxScript + " -Alias \"" + alias + "\"";
            }
            if (inputMap.get("HiddenFromAddressListsEnabled") != null) {
                if (setMailboxScript.length() == 0) {
                    setMailboxScript = "Set-Mailbox -Identity " + objectId;
                }
                setMailboxScript = setMailboxScript + " -HiddenFromAddressListsEnabled $true";
            }
            if (inputMap.get("AuditEnabled") != null) {
                if (setMailboxScript.length() == 0) {
                    setMailboxScript = "Set-Mailbox -Identity " + objectId;
                }
                setMailboxScript = setMailboxScript + " -AuditEnabled $true";
            }
            script = script + setMailboxScript + ";";
            if (inputMap.get("DistributionGroupMember") != null) {
                groupList = (ArrayList)inputMap.get("DistributionGroupMember");
                for (int i = 0; i < groupList.size(); ++i) {
                    script = script + addDistGroupMemCommonScript + " " + (String)groupList.get(i) + " -Confirm:$false -Member " + objectId + ";";
                }
            }
            if (inputMap.get("O365GroupMember") != null) {
                groupList = (ArrayList)inputMap.get("O365GroupMember");
                for (int i = 0; i < groupList.size(); ++i) {
                    script = script + o365GroupCommonScript + " " + (String)groupList.get(i) + " -LinkType Members -Links " + objectId + ";";
                }
            }
        }
        return script;
    }

    private void setAuditPropList(HashMap inputMap, AdventNetResourceBundle rb) {
        for (Object key : inputMap.keySet()) {
            String keyStr = key.toString();
            Properties auditProp = new Properties();
            auditProp.put("ATTRIB_LDAP_NAME", rb.getString(keyStr));
            if (!keyStr.equalsIgnoreCase("DistributionGroupMember") && !keyStr.equalsIgnoreCase("O365GroupMember")) {
                auditProp.put("ATTRIB_VALUE", (String)inputMap.get(keyStr));
            } else {
                ArrayList listForAudit = O365MgmtHandler.getDisplayNameForAudit((ArrayList)((ArrayList)inputMap.get(keyStr)));
                auditProp.put("ATTRIB_VALUE", listForAudit);
            }
            this.auditPropList.add(auditProp);
        }
    }
}

