/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365InfoCache;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPActionDetailsHandler;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.ADMPGroupDelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.HelpDeskRoleHandler;
import com.adventnet.sym.adsm.common.server.delegation.HelpDeskRoleUtil;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianDataHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianGroupHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.filter.ColumnFilterHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.delegation.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.delegation.ReportJRRewindableDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class HDTReportListener {
    private static String productHome = null;
    private static String basepath = null;
    private ArrayList<String> delegatedDomain = new ArrayList();
    private ArrayList<String> nonADIAMAppDomains = new ArrayList();
    private static final int[] iamAppIdArray = new int[]{1, 3, 2};
    private int exportCount = 0;
    AdventNetResourceBundle rb = null;

    public void setReportRows(HttpServletRequest request, ArrayList attributeList, boolean isReportResult, boolean isExport) {
        try {
            DataObject dataObject;
            Criteria crit;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject jsonObject = new JSONObject();
            String params = request.getParameter("params");
            JSONObject jsonObj = new JSONObject(params);
            ArrayList<String> tableNames = new ArrayList<String>();
            this.delegatedDomain.clear();
            this.nonADIAMAppDomains.addAll(O365InfoCache.getInstance().getConfiguredWaadAccounts());
            this.nonADIAMAppDomains.addAll(DomainInfoCache.getInstance().getConfiguredGSuiteAccounts());
            Criteria filterCriteria = this.getReportResultFilterCriteria(jsonObj, tableNames, "User");
            Criteria searchCriteria = null;
            Long sessionLoginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            request.setAttribute("searchString", (Object)"");
            if (jsonObj.has("search") && ((Boolean)jsonObj.get("search")).booleanValue()) {
                searchCriteria = this.getColumnSearchCriteria(request, jsonObj, attributeList);
            }
            if ((crit = TechnicianHandler.getTechnicianSearchCriteria((String)"HelpDeskUser", null, null)) == null) {
                crit = filterCriteria;
            } else if (filterCriteria != null) {
                crit = crit.and(filterCriteria);
            }
            if (!sessionLoginId.equals(CommonUtil.ADMIN_LOGIN_ID) && this.delegatedDomain.isEmpty()) {
                this.delegatedDomain.addAll(HDTDomainHandler.getDomainNamesList((Long)sessionLoginId));
                this.delegatedDomain.addAll(HelpdeskUtil.getDelegatedIamAppAccounts((int)3, (int)DelegationUtil.RESULT_DATA, (Long)sessionLoginId, (String)"User"));
                this.delegatedDomain.addAll(HelpdeskUtil.getDelegatedIamAppAccounts((int)2, (int)DelegationUtil.RESULT_DATA, (Long)sessionLoginId, (String)"User"));
            }
            if (crit == null) {
                crit = searchCriteria;
            } else if (searchCriteria != null) {
                crit = crit.and(searchCriteria);
            }
            String baseTableName = "AaaLogin";
            SelectQuery query = QueryConstructor.getForPersonality((String)"HelpDeskTechnician", (Criteria)crit);
            query.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AaaUser", (String)"USER_ID", (String)"USERID"));
            query.addSelectColumn(Column.getColumn((String)"AaaUser", (String)"FULL_NAME"));
            query.addSortColumn(new SortColumn(new Column("AaaLogin", "NAME"), true));
            Integer startIndex = 1;
            Integer range = NavigateRangeUtil.getDefaultRange((String)"HDTReport", (Long)sessionLoginId);
            if (jsonObj.has("pageNavigation")) {
                JSONObject pageNavigate = (JSONObject)jsonObj.get("pageNavigation");
                startIndex = (Integer)pageNavigate.get("startIndex");
                range = (Integer)pageNavigate.get("range");
                Boolean isNavigate = (Boolean)pageNavigate.get("isNavigate");
                if (isNavigate != null && !isNavigate.booleanValue()) {
                    NavigateRangeUtil.setDefaultRange((String)"HDTReport", (int)range, (Long)sessionLoginId);
                }
            }
            int keySize = 0;
            int count = 0;
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(query);
            ArrayList directUserList = TechnicianDataHandler.getDirectUsers();
            if (!dataObj.isEmpty()) {
                Iterator ite = dataObj.getRows("AaaLogin");
                ArrayList<Long> keys = new ArrayList<Long>();
                while (ite.hasNext()) {
                    Row r = (Row)ite.next();
                    Long loginId = (Long)r.get("LOGIN_ID");
                    int totalDomainCount = 0;
                    Hashtable iamAppIdVsDomains = new Hashtable();
                    for (int iamAppId : iamAppIdArray) {
                        ArrayList<String> domains = this.getDelegatedDomainsForTechnician(loginId, Boolean.FALSE, iamAppId);
                        iamAppIdVsDomains.put(iamAppId, domains);
                        totalDomainCount += domains.size();
                    }
                    if (totalDomainCount == 0) {
                        ArrayList<String> domains = new ArrayList<String>();
                        domains.add("-");
                        iamAppIdVsDomains.put(1, domains);
                    }
                    if (keys.contains(loginId) || totalDomainCount == 0) continue;
                    keys.add(loginId);
                    if (isExport || keys.size() >= startIndex && keys.size() <= startIndex + range - 1) {
                        JSONObject json = new JSONObject();
                        String domName = (String)r.get("DOMAINNAME");
                        if (domName.equalsIgnoreCase("ADManager Plus Authentication")) {
                            domName = rb.getString("admp.deleg.hdt_deleg.view_hdt.text.built_in_technician");
                        }
                        json.put("DOMAINNAME", (Object)domName);
                        Row r1 = dataObj.getRow("AaaUser", new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)((Long)r.get("USER_ID")), 0));
                        String fullName = rb.getString((String)r1.get("FULL_NAME")) + " (" + domName + ")";
                        json.put(Integer.toString(19006), (Object)fullName);
                        json.put(Integer.toString(19008), iamAppIdVsDomains);
                        jsonObject.put("User_" + loginId.toString(), (Object)json);
                    }
                    ++count;
                }
                keySize = keys.size();
            }
            query = new SelectQueryImpl(Table.getTable((String)"ADMPGroupBasedHDT"));
            query.addJoin(new Join(Table.getTable((String)"ADMPGroupBasedHDT"), Table.getTable((String)"ADSMGroupGeneralDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1));
            query.addJoin(new Join(Table.getTable((String)"ADMPGroupBasedHDT"), Table.getTable((String)"ADMPGroupsRoleMapping"), new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 1));
            query.addSelectColumn(Column.getColumn((String)"ADMPGroupBasedHDT", (String)"GROUP_ID"));
            query.addSelectColumn(Column.getColumn((String)"ADMPGroupsRoleMapping", (String)"GROUP_ID"));
            query.addSelectColumn(Column.getColumn((String)"ADMPGroupBasedHDT", (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)"ADMPGroupBasedHDT", (String)"DOMAIN_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"GROUP_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"OBJECT_GUID"));
            Criteria admpGroupCrit = null;
            if (jsonObj.has("search") && ((Boolean)jsonObj.get("search")).booleanValue()) {
                admpGroupCrit = this.getColumnSearchCriteriaForGroup(request, jsonObj, attributeList);
            }
            if ((admpGroupCrit = admpGroupCrit != null ? admpGroupCrit.and(this.getReportResultFilterCriteria(jsonObj, new ArrayList<String>(), "Group")) : this.getReportResultFilterCriteria(jsonObj, new ArrayList<String>(), "Group")) != null) {
                query.setCriteria(admpGroupCrit);
            }
            if (!(dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(query)).isEmpty()) {
                Iterator ite = dataObject.getRows("ADMPGroupBasedHDT");
                ArrayList<Long> keys = new ArrayList<Long>();
                while (ite.hasNext()) {
                    Row r = (Row)ite.next();
                    Long groupId = (Long)r.get("GROUP_ID");
                    int totalDomainCount = 0;
                    Hashtable iamAppIdVsDomains = new Hashtable();
                    for (int iamAppId : iamAppIdArray) {
                        ArrayList<String> domains = this.getDelegatedDomainsForADMPGroup(groupId, iamAppId);
                        iamAppIdVsDomains.put(iamAppId, domains);
                        totalDomainCount += domains.size();
                    }
                    if (totalDomainCount == 0) {
                        ArrayList<String> domains = new ArrayList<String>();
                        domains.add("-");
                        iamAppIdVsDomains.put(1, domains);
                    }
                    if (keys.contains(groupId) || totalDomainCount == 0) continue;
                    keys.add(groupId);
                    if (isExport || keys.size() + keySize >= startIndex && keys.size() + keySize <= startIndex + range - 1) {
                        JSONObject json = new JSONObject();
                        String domName = (String)r.get("DOMAIN_NAME");
                        json.put("DOMAIN_NAME", (Object)domName);
                        Row r1 = dataObject.getRow("ADSMGroupGeneralDetails", new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"OBJECT_GUID"), (Object)((String)r.get("OBJECT_GUID")), 0));
                        String fullName = rb.getString((String)r1.get("GROUP_NAME")) + " (" + domName + ")";
                        json.put(Integer.toString(19006), (Object)fullName);
                        json.put(Integer.toString(19008), iamAppIdVsDomains);
                        jsonObject.put("Group_" + groupId.toString(), (Object)json);
                    }
                    ++count;
                }
            }
            count = this.getResultRows(attributeList, jsonObject, rb, isReportResult, count);
            request.setAttribute("resultList", (Object)jsonObject);
            request.setAttribute("loginIdList", (Object)jsonObject.keys());
            request.setAttribute("count", (Object)count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCount(SelectQuery query) {
        int count = 0;
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(query);
            count = dataObject.size("AaaLogin");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public int getResultRows(ArrayList attributeList, JSONObject jsonObject, AdventNetResourceBundle rb, boolean isReportResult, int count) {
        try {
            Boolean isHDTGroupAvailable = Boolean.FALSE;
            ArrayList<Long> keyList = new ArrayList<Long>();
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String[] strArray = key.split("_");
                String objectClass = strArray[0];
                if (objectClass.equalsIgnoreCase("User")) {
                    keyList.add(Long.parseLong(strArray[1]));
                    continue;
                }
                isHDTGroupAvailable = Boolean.TRUE;
            }
            Long[] loginIds = keyList.toArray(new Long[keyList.size()]);
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                Integer attribId = (Integer)attributeProp.get("ATTRIB_ID");
                Hashtable<Long, Object> loginIdVsDomainValues = new Hashtable<Long, Object>();
                switch (attribId) {
                    case 19007: {
                        loginIdVsDomainValues = HelpdeskUtil.getLoginIdVsDomainCredentials((Long[])loginIds);
                        break;
                    }
                    case 19021: {
                        loginIdVsDomainValues = HelpdeskUtil.getLoginIdVsAppendGroups((Long[])loginIds);
                        break;
                    }
                    case 19009: {
                        loginIdVsDomainValues = TechnicianHandler.getRoleListForHDT((Long[])loginIds, (AdventNetResourceBundle)rb, new ArrayList());
                        break;
                    }
                    case 19010: {
                        loginIdVsDomainValues = HelpdeskUtil.getOUList((Long[])loginIds);
                        break;
                    }
                    case 19025: {
                        loginIdVsDomainValues = HelpdeskUtil.getDelegatedO365LicensesForHDT((Long[])loginIds, (String)"User", (AdventNetResourceBundle)rb);
                        break;
                    }
                    case 19026: {
                        loginIdVsDomainValues = HelpdeskUtil.getDelegatedWaadDomainsForHDT((Long[])loginIds, (String)"User", (AdventNetResourceBundle)rb);
                        break;
                    }
                    case 19027: {
                        loginIdVsDomainValues = HelpdeskUtil.getApplyOURestrictionForHDT((Long[])loginIds, (String)"User");
                        break;
                    }
                    case 19014: {
                        loginIdVsDomainValues = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIds, (String)"group", (String)"INCLUDE");
                        break;
                    }
                    case 19015: {
                        loginIdVsDomainValues = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIds, (String)"organizationalUnit", (String)"INCLUDE");
                        break;
                    }
                    case 19016: {
                        loginIdVsDomainValues = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIds, (String)"group", (String)"EXCLUDE");
                        break;
                    }
                    case 19017: {
                        loginIdVsDomainValues = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIds, (String)"organizationalUnit", (String)"EXCLUDE");
                        break;
                    }
                    case 19018: {
                        loginIdVsDomainValues = FcLayoutViewHandler.getAuthorizedLayouts((Long[])loginIds, (AdventNetResourceBundle)rb);
                        break;
                    }
                    case 19022: {
                        loginIdVsDomainValues = ADMPGroupDelegationUtil.getUserGroupMapping((Long[])loginIds);
                        break;
                    }
                    case 19023: {
                        Hashtable<Long, Object> objectClassHash = new Hashtable<Long, Object>();
                        for (Long loginId : loginIds) {
                            objectClassHash.put(loginId, rb.getString("admp.mgmt.fc_layout_common.text_user"));
                        }
                        loginIdVsDomainValues = objectClassHash;
                        break;
                    }
                    case 19024: {
                        Hashtable fileServerListHash = HelpdeskUtil.getLoginIdVsFileServerList((Long[])loginIds, (String)"ADMPUserAllfileserverMap", (String)"ADMPUsersFileServerMap", (String)"LOGIN_ID");
                        for (Long fsLoginId : fileServerListHash.keySet()) {
                            Properties fsProp = (Properties)fileServerListHash.get(fsLoginId);
                            Boolean isAllSelected = (Boolean)fsProp.get("isAllSelected");
                            if (isAllSelected.booleanValue()) {
                                loginIdVsDomainValues.put(fsLoginId, rb.getString("admp.common.text.all"));
                                continue;
                            }
                            ArrayList fileServerNameList = (ArrayList)fsProp.get("fileServerNameList");
                            loginIdVsDomainValues.put(fsLoginId, fileServerNameList != null ? fileServerNameList.toString().substring(1, fileServerNameList.toString().length() - 1) : "-");
                        }
                        break;
                    }
                    case 19011: 
                    case 19012: 
                    case 19013: {
                        Hashtable<Object, Object> mgmtVsParentAction = new Hashtable();
                        ArrayList parentIds = new ArrayList();
                        Hashtable parentIdVsName = new Hashtable();
                        Hashtable tempLoginIdVsDomainValues = new Hashtable();
                        if (attribId == 19011) {
                            mgmtVsParentAction = this.getMgmtVsParentAction(parentIds, parentIdVsName);
                        } else if (attribId == 19012) {
                            mgmtVsParentAction = this.getReportVsParentAction(parentIds, parentIdVsName, DelegationUtil.REPORT_TAB_ACTION_ID);
                        } else if (attribId == 19013) {
                            mgmtVsParentAction = this.getReportVsParentAction(parentIds, parentIdVsName, DelegationUtil.ADMINISTRATION_TAB_ACTION_ID);
                        }
                        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADMPUsersRoleMapping"));
                        Join join1 = new Join("ADMPUsersRoleMapping", "ADMPRolePermissions", new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 1);
                        Join join2 = new Join("ADMPRolePermissions", "ADMPActionDetails", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 1);
                        Criteria crit = new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"LOGIN_ID"), (Object)loginIds, 8);
                        crit = crit.and(new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"TYPE_OF_DATA"), (Object)DelegationUtil.USER_DATA, 0));
                        crit = crit.and(new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"PARENT_ID"), (Object)parentIds.toArray(new Long[parentIds.size()]), 8));
                        query.addJoin(join1);
                        query.addJoin(join2);
                        query.addSelectColumn(Column.getColumn(null, (String)"*"));
                        query.setCriteria(crit);
                        DataObject dataObject = CommonUtil.getCachedPersistence().get((SelectQuery)query);
                        if (dataObject.isEmpty()) break;
                        Iterator ite = dataObject.getRows("ADMPUsersRoleMapping");
                        while (ite.hasNext()) {
                            Row row = (Row)ite.next();
                            Long loginId = (Long)row.get("LOGIN_ID");
                            String domainName = (String)row.get("ADMP_DOMAIN_NAME");
                            Long roleId = (Long)row.get("ADMP_ROLE_ID");
                            Iterator it = dataObject.getRows("ADMPRolePermissions", new Criteria(Column.getColumn((String)"ADMPRolePermissions", (String)"ADMP_ROLE_ID"), (Object)roleId, 0));
                            while (it.hasNext()) {
                                String value;
                                Long mgmtId;
                                Hashtable mgmtVsValue;
                                Hashtable domainVsValues;
                                Row r = (Row)it.next();
                                Long actionId = (Long)r.get("ACTION_ID");
                                Row r1 = dataObject.getRow("ADMPActionDetails", new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)actionId, 0));
                                Long parentId = (Long)r1.get("PARENT_ID");
                                String actionName = rb.getString((String)r1.get("ACTION_NAME"));
                                if (Arrays.asList(DelegationUtil.POPUP_REJECT_ACTION_IDS).contains(actionId)) continue;
                                if (tempLoginIdVsDomainValues.get(loginId) == null) {
                                    tempLoginIdVsDomainValues.put(loginId, new Hashtable());
                                }
                                if ((domainVsValues = (Hashtable)tempLoginIdVsDomainValues.get(loginId)).get(domainName) == null) {
                                    domainVsValues.put(domainName, new Hashtable());
                                }
                                if ((mgmtVsValue = (Hashtable)domainVsValues.get(domainName)).get(mgmtId = (Long)mgmtVsParentAction.get(parentId)) == null) {
                                    mgmtVsValue.put(mgmtId, "");
                                }
                                if ((value = (String)mgmtVsValue.get(mgmtId)).equals("")) {
                                    value = rb.getString(actionName) + ", ";
                                } else if (!value.contains(rb.getString(actionName))) {
                                    value = value + rb.getString(actionName) + ", ";
                                }
                                mgmtVsValue.put(mgmtId, value);
                            }
                        }
                        for (Long loginId : loginIds) {
                            Hashtable domainVsValues = (Hashtable)tempLoginIdVsDomainValues.get(loginId);
                            loginIdVsDomainValues.put(loginId, new Hashtable());
                            Hashtable finalDomainVsValue = (Hashtable)loginIdVsDomainValues.get(loginId);
                            if (domainVsValues == null) continue;
                            for (Object domain : domainVsValues.keySet()) {
                                Hashtable mgmtVsValue = (Hashtable)domainVsValues.get(domain.toString());
                                Hashtable<String, String> finalValue = (Hashtable<String, String>)finalDomainVsValue.get(domain.toString());
                                if (finalValue == null) {
                                    finalValue = new Hashtable<String, String>();
                                }
                                for (Object key : mgmtVsValue.keySet()) {
                                    String value = (String)mgmtVsValue.get(key);
                                    finalValue.put(rb.getString((String)parentIdVsName.get(key)), value.substring(0, value.length() - 2));
                                    finalDomainVsValue.put(domain.toString(), finalValue);
                                }
                            }
                        }
                        break;
                    }
                }
                if (attribId == 19008 || attribId == 19006) continue;
                for (Long loginId : loginIds) {
                    if (attribId != 19018 && attribId != 19022 && attribId != 19023 && loginIdVsDomainValues.get(loginId) == null) {
                        loginIdVsDomainValues.put(loginId, new Hashtable());
                    }
                    JSONObject json = (JSONObject)jsonObject.get("User_" + loginId.toString());
                    if (attribId == 19022 || attribId == 19023 || attribId == 19024) {
                        json.put(attribId.toString(), loginIdVsDomainValues.get(loginId));
                        continue;
                    }
                    Hashtable domainVsDetails = (Hashtable)loginIdVsDomainValues.get(loginId);
                    json.put(attribId.toString(), (Object)domainVsDetails);
                }
            }
            if (isHDTGroupAvailable.booleanValue()) {
                this.getResultRowsForADMPGroup(attributeList, jsonObject, rb, isReportResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public void getResultRowsForADMPGroup(ArrayList attributeList, JSONObject jsonObject, AdventNetResourceBundle rb, boolean isReportResult) {
        try {
            ArrayList<Long> keyList = new ArrayList<Long>();
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String[] strArray = key.split("_");
                String objectClass = strArray[0];
                if (!objectClass.equalsIgnoreCase("Group")) continue;
                keyList.add(Long.parseLong(strArray[1]));
            }
            Long[] groupIds = keyList.toArray(new Long[keyList.size()]);
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                String tableName = (String)attributeProp.get("TABLE_NAME");
                Integer attribId = (Integer)attributeProp.get("ATTRIB_ID");
                Hashtable<Long, Object> groupIdVsDomainValues = new Hashtable<Long, Object>();
                switch (attribId) {
                    case 19007: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getGroupIdVsDomainCredentials((Long[])groupIds);
                        break;
                    }
                    case 19021: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getGroupIdVsAppendGroups((Long[])groupIds);
                        break;
                    }
                    case 19009: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getRoleListForADMPGroup((Long[])groupIds, (AdventNetResourceBundle)rb);
                        break;
                    }
                    case 19010: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getOUListForADMPGroup((Long[])groupIds);
                        break;
                    }
                    case 19025: {
                        groupIdVsDomainValues = HelpdeskUtil.getDelegatedO365LicensesForHDT((Long[])groupIds, (String)"Group", (AdventNetResourceBundle)rb);
                        break;
                    }
                    case 19026: {
                        groupIdVsDomainValues = HelpdeskUtil.getDelegatedWaadDomainsForHDT((Long[])groupIds, (String)"Group", (AdventNetResourceBundle)rb);
                        break;
                    }
                    case 19027: {
                        groupIdVsDomainValues = HelpdeskUtil.getApplyOURestrictionForHDT((Long[])groupIds, (String)"Group");
                        break;
                    }
                    case 19014: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])groupIds, (String)"group", (String)"INCLUDE");
                        break;
                    }
                    case 19015: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])groupIds, (String)"organizationalUnit", (String)"INCLUDE");
                        break;
                    }
                    case 19016: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])groupIds, (String)"group", (String)"EXCLUDE");
                        break;
                    }
                    case 19017: {
                        groupIdVsDomainValues = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])groupIds, (String)"organizationalUnit", (String)"EXCLUDE");
                        break;
                    }
                    case 19018: {
                        groupIdVsDomainValues = FcLayoutViewHandler.getAuthorizedLayoutsForGroup((Long[])groupIds, (AdventNetResourceBundle)rb);
                        break;
                    }
                    case 19022: {
                        break;
                    }
                    case 19023: {
                        Hashtable<Long, Object> objectClassHash = new Hashtable<Long, Object>();
                        for (Long groupId : groupIds) {
                            objectClassHash.put(groupId, rb.getString("admp.mgmt.fc_layout_common.text_group"));
                        }
                        groupIdVsDomainValues = objectClassHash;
                        break;
                    }
                    case 19024: {
                        Hashtable fileServerListHash = HelpdeskUtil.getLoginIdVsFileServerList((Long[])groupIds, (String)"ADMPGroupAllfileserverMap", (String)"ADMPGroupFileServerMap", (String)"GROUP_ID", (String)"Group");
                        for (Long fsLoginId : fileServerListHash.keySet()) {
                            Properties fsProp = (Properties)fileServerListHash.get(fsLoginId);
                            Boolean isAllSelected = (Boolean)fsProp.get("isAllSelected");
                            if (isAllSelected.booleanValue()) {
                                groupIdVsDomainValues.put(fsLoginId, rb.getString("admp.common.text.all"));
                                continue;
                            }
                            ArrayList fileServerNameList = (ArrayList)fsProp.get("fileServerNameList");
                            groupIdVsDomainValues.put(fsLoginId, fileServerNameList.toString().substring(1, fileServerNameList.toString().length() - 1));
                        }
                        break;
                    }
                    case 19011: 
                    case 19012: 
                    case 19013: {
                        Hashtable<Object, Object> mgmtVsParentAction = new Hashtable();
                        ArrayList parentIds = new ArrayList();
                        Hashtable parentIdVsName = new Hashtable();
                        Hashtable tempGroupIdVsDomainValues = new Hashtable();
                        if (attribId == 19011) {
                            mgmtVsParentAction = this.getMgmtVsParentAction(parentIds, parentIdVsName);
                        } else if (attribId == 19012) {
                            mgmtVsParentAction = this.getReportVsParentAction(parentIds, parentIdVsName, DelegationUtil.REPORT_TAB_ACTION_ID);
                        } else if (attribId == 19013) {
                            mgmtVsParentAction = this.getReportVsParentAction(parentIds, parentIdVsName, DelegationUtil.ADMINISTRATION_TAB_ACTION_ID);
                        }
                        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADMPGroupsRoleMapping"));
                        Join join1 = new Join("ADMPGroupsRoleMapping", "ADMPRolePermissions", new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 1);
                        Join join2 = new Join("ADMPRolePermissions", "ADMPActionDetails", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 1);
                        Criteria crit = new Criteria(Column.getColumn((String)"ADMPGroupsRoleMapping", (String)"GROUP_ID"), (Object)groupIds, 8);
                        crit = crit.and(new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"PARENT_ID"), (Object)parentIds.toArray(new Long[parentIds.size()]), 8));
                        query.addJoin(join1);
                        query.addJoin(join2);
                        query.addSelectColumn(Column.getColumn(null, (String)"*"));
                        query.setCriteria(crit);
                        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                        if (dataObject.isEmpty()) break;
                        Iterator ite = dataObject.getRows("ADMPGroupsRoleMapping");
                        while (ite.hasNext()) {
                            Row row = (Row)ite.next();
                            Long groupId = (Long)row.get("GROUP_ID");
                            String domainName = (String)row.get("ADMP_DOMAIN_NAME");
                            Long roleId = (Long)row.get("ADMP_ROLE_ID");
                            Iterator it = dataObject.getRows("ADMPRolePermissions", new Criteria(Column.getColumn((String)"ADMPRolePermissions", (String)"ADMP_ROLE_ID"), (Object)roleId, 0));
                            while (it.hasNext()) {
                                String value;
                                Long mgmtId;
                                Hashtable mgmtVsValue;
                                Hashtable domainVsValues;
                                Row r = (Row)it.next();
                                Long actionId = (Long)r.get("ACTION_ID");
                                Row r1 = dataObject.getRow("ADMPActionDetails", new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)actionId, 0));
                                Long parentId = (Long)r1.get("PARENT_ID");
                                String actionName = rb.getString((String)r1.get("ACTION_NAME"));
                                if (Arrays.asList(DelegationUtil.POPUP_REJECT_ACTION_IDS).contains(actionId)) continue;
                                if (tempGroupIdVsDomainValues.get(groupId) == null) {
                                    tempGroupIdVsDomainValues.put(groupId, new Hashtable());
                                }
                                if ((domainVsValues = (Hashtable)tempGroupIdVsDomainValues.get(groupId)).get(domainName) == null) {
                                    domainVsValues.put(domainName, new Hashtable());
                                }
                                if ((mgmtVsValue = (Hashtable)domainVsValues.get(domainName)).get(mgmtId = (Long)mgmtVsParentAction.get(parentId)) == null) {
                                    mgmtVsValue.put(mgmtId, "");
                                }
                                if ((value = (String)mgmtVsValue.get(mgmtId)).equals("")) {
                                    value = rb.getString(actionName) + ", ";
                                } else if (!value.contains(rb.getString(actionName))) {
                                    value = value + rb.getString(actionName) + ", ";
                                }
                                mgmtVsValue.put(mgmtId, value);
                            }
                        }
                        for (Long groupId : groupIds) {
                            Hashtable domainVsValues = (Hashtable)tempGroupIdVsDomainValues.get(groupId);
                            groupIdVsDomainValues.put(groupId, new Hashtable());
                            Hashtable finalDomainVsValue = (Hashtable)groupIdVsDomainValues.get(groupId);
                            if (domainVsValues == null) continue;
                            for (Object domain : domainVsValues.keySet()) {
                                Hashtable mgmtVsValue = (Hashtable)domainVsValues.get(domain.toString());
                                Hashtable<String, String> finalValue = (Hashtable<String, String>)finalDomainVsValue.get(domain.toString());
                                if (finalValue == null) {
                                    finalValue = new Hashtable<String, String>();
                                }
                                for (Object key : mgmtVsValue.keySet()) {
                                    String value = (String)mgmtVsValue.get(key);
                                    finalValue.put(rb.getString((String)parentIdVsName.get(key)), value.substring(0, value.length() - 2));
                                    finalDomainVsValue.put(domain.toString(), finalValue);
                                }
                            }
                        }
                        break;
                    }
                }
                if (attribId == 19008 || attribId == 19006) continue;
                for (Long groupId : groupIds) {
                    if (attribId != 19018 && groupIdVsDomainValues.get(groupId) == null) {
                        groupIdVsDomainValues.put(groupId, new Hashtable());
                    }
                    JSONObject json = (JSONObject)jsonObject.get("Group_" + groupId.toString());
                    if (attribId == 19022 || attribId == 19023 || attribId == 19024) {
                        if (attribId == 19022) {
                            json.put(attribId.toString(), (Object)"-");
                            continue;
                        }
                        json.put(attribId.toString(), groupIdVsDomainValues.get(groupId));
                        continue;
                    }
                    Hashtable domainVsDetails = (Hashtable)groupIdVsDomainValues.get(groupId);
                    json.put(attribId.toString(), (Object)domainVsDetails);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getDelegatedDomainsForTechnician(Long technicianId, Boolean isUserData, int iamAppId) {
        ArrayList domains = new ArrayList();
        try {
            int typeOfData = isUserData != false ? DelegationUtil.USER_DATA : DelegationUtil.RESULT_DATA;
            if (iamAppId == 1) {
                domains = HDTDomainHandler.getDomainNamesList((Long)technicianId, (boolean)isUserData);
            } else if (iamAppId == 3 || iamAppId == 2) {
                domains = HelpdeskUtil.getDelegatedIamAppAccounts((int)iamAppId, (int)typeOfData, (Long)technicianId, (String)"User");
            }
            if (!domains.isEmpty()) {
                ArrayList<String> removeItems = new ArrayList<String>();
                if (!this.delegatedDomain.isEmpty()) {
                    for (String domain : domains) {
                        if (this.delegatedDomain.contains(domain) || domain.equals("All Domains")) continue;
                        removeItems.add(domain);
                    }
                    domains.removeAll(removeItems);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domains;
    }

    private ArrayList<String> getDelegatedDomainsForADMPGroup(Long groupId, int iamAppId) {
        ArrayList domains = new ArrayList();
        try {
            if (iamAppId == 1) {
                domains = ADMPGroupDelegationUtil.getADMPGroupVSDomainList((Long)groupId);
            } else if (iamAppId == 3 || iamAppId == 2) {
                domains = HelpdeskUtil.getDelegatedIamAppAccounts((int)iamAppId, (int)DelegationUtil.RESULT_DATA, (Long)groupId, (String)"Group");
            }
            if (!domains.isEmpty()) {
                ArrayList<String> removeItems = new ArrayList<String>();
                if (!this.delegatedDomain.isEmpty()) {
                    for (String domain : domains) {
                        if (this.delegatedDomain.contains(domain) || domain.equals("All Domains")) continue;
                        removeItems.add(domain);
                    }
                    domains.removeAll(removeItems);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domains;
    }

    private Hashtable<Long, Long> getReportVsParentAction(ArrayList parentIds, Hashtable parentIdVsName, Long tabActionId) {
        String actionName;
        Long actionId;
        Hashtable hash;
        int size;
        Hashtable<Long, Long> mgmtVsParentAction = new Hashtable<Long, Long>();
        ArrayList actionDetail = ADMPActionDetailsHandler.getActionDetails((Long)tabActionId);
        for (size = 0; size < actionDetail.size(); ++size) {
            hash = (Hashtable)actionDetail.get(size);
            actionId = (Long)hash.get("ACTION_ID");
            actionName = (String)hash.get("ACTION_NAME");
            parentIdVsName.put(actionId, actionName);
            if (actionId != 9000L) {
                ArrayList firstLevelDetail = ADMPActionDetailsHandler.getActionDetails((Long)actionId);
                for (int size1 = 0; size1 < firstLevelDetail.size(); ++size1) {
                    Hashtable hash1 = (Hashtable)firstLevelDetail.get(size1);
                    Long actionId1 = (Long)hash1.get("ACTION_ID");
                    ArrayList secondLevelDetail = ADMPActionDetailsHandler.getActionDetails((Long)actionId1);
                    mgmtVsParentAction.put(actionId1, actionId);
                    parentIds.add(actionId1);
                }
                continue;
            }
            mgmtVsParentAction.put(actionId, actionId);
            parentIds.add(actionId);
        }
        if (tabActionId.equals(DelegationUtil.REPORT_TAB_ACTION_ID)) {
            actionDetail = ADMPActionDetailsHandler.getActionDetails((Long)DelegationUtil.OMP_INT_REPORT_ACTION_ID);
            for (size = 0; size < actionDetail.size(); ++size) {
                hash = (Hashtable)actionDetail.get(size);
                actionId = (Long)hash.get("ACTION_ID");
                actionName = (String)hash.get("ACTION_NAME");
                parentIdVsName.put(actionId, actionName);
                parentIds.add(actionId);
                mgmtVsParentAction.put(actionId, DelegationUtil.ADMP_O365_REPORT_ACTION_ID);
            }
        }
        return mgmtVsParentAction;
    }

    private Hashtable<Long, Long> getMgmtVsParentAction(ArrayList parentIds, Hashtable parentIdVsName) {
        Long actionId1;
        Hashtable hash1;
        int size1;
        ArrayList firstLevelDetail;
        String actionName;
        Long actionId;
        Hashtable hash;
        int size;
        Hashtable<Long, Long> mgmtVsParentAction = new Hashtable<Long, Long>();
        ArrayList actionDetail = ADMPActionDetailsHandler.getActionDetails((Long)DelegationUtil.MANAGEMENT_TAB_ACTION_ID);
        for (size = 0; size < actionDetail.size(); ++size) {
            hash = (Hashtable)actionDetail.get(size);
            actionId = (Long)hash.get("ACTION_ID");
            actionName = (String)hash.get("ACTION_NAME");
            parentIdVsName.put(actionId, actionName);
            firstLevelDetail = ADMPActionDetailsHandler.getActionDetails((Long)actionId);
            for (size1 = 0; size1 < firstLevelDetail.size(); ++size1) {
                hash1 = (Hashtable)firstLevelDetail.get(size1);
                actionId1 = (Long)hash1.get("ACTION_ID");
                ArrayList secondLevelDetail = ADMPActionDetailsHandler.getActionDetails((Long)actionId1);
                for (int size2 = 0; size2 < secondLevelDetail.size(); ++size2) {
                    Hashtable hash2 = (Hashtable)secondLevelDetail.get(size2);
                    Long actionId2 = (Long)hash2.get("ACTION_ID");
                    mgmtVsParentAction.put(actionId2, actionId);
                    parentIds.add(actionId2);
                }
            }
        }
        actionDetail = ADMPActionDetailsHandler.getActionDetails((Long)DelegationUtil.OMP_INT_MGMT_ACTION_ID);
        for (size = 0; size < actionDetail.size(); ++size) {
            hash = (Hashtable)actionDetail.get(size);
            actionId = (Long)hash.get("ACTION_ID");
            actionName = (String)hash.get("ACTION_NAME");
            parentIdVsName.put(actionId, actionName);
            firstLevelDetail = ADMPActionDetailsHandler.getActionDetails((Long)actionId);
            for (size1 = 0; size1 < firstLevelDetail.size(); ++size1) {
                hash1 = (Hashtable)firstLevelDetail.get(size1);
                actionId1 = (Long)hash1.get("ACTION_ID");
                parentIds.add(actionId1);
                mgmtVsParentAction.put(actionId1, DelegationUtil.ADMP_O365_MGMT_ACTION_ID);
            }
        }
        return mgmtVsParentAction;
    }

    public Criteria getReportResultFilterCriteria(JSONObject jsonObj, ArrayList<String> tableNames, String objectClass) {
        Criteria crit = null;
        Criteria processCriteria = null;
        try {
            if (jsonObj.has("inputParams")) {
                JSONArray inputParams = (JSONArray)jsonObj.get("inputParams");
                for (int i = 0; i < inputParams.length(); ++i) {
                    String domain;
                    JSONObject jsonParams = (JSONObject)inputParams.get(i);
                    if ((Integer)jsonParams.get("attribId") == 19008 && (Integer)jsonParams.get("matchCriteriaId") == 28 && !(domain = (String)jsonParams.get("value")).equals("")) {
                        this.delegatedDomain.add(jsonParams.get("value").toString());
                    }
                    if ((processCriteria = this.getCriteria(jsonParams, tableNames, objectClass)) == null) continue;
                    if (crit == null) {
                        crit = processCriteria;
                        continue;
                    }
                    if (((String)jsonParams.get("processMatchCriteria")).equalsIgnoreCase("or")) {
                        crit = crit.or(processCriteria);
                        continue;
                    }
                    if (!((String)jsonParams.get("processMatchCriteria")).equalsIgnoreCase("and")) continue;
                    crit = crit.and(processCriteria);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public Criteria getCriteria(JSONObject critJSON, ArrayList<String> tableNames, String objectClass) {
        if (objectClass.equalsIgnoreCase("Group")) {
            return this.getCriteriaForADMPGroup(critJSON, tableNames);
        }
        return this.getCriteria(critJSON, tableNames);
    }

    public Criteria getCriteria(JSONObject critJSON, ArrayList<String> tableNames) {
        Criteria criteria = null;
        try {
            Integer attribId;
            Row row;
            if (critJSON.get("attribId") != null && !critJSON.get("attribId").equals("null") && (row = ReportAttributesUtil.getAttributeDetailsRow((Integer)(attribId = (Integer)critJSON.get("attribId")))) != null) {
                String tableName = (String)row.get("TABLE_NAME");
                String attribColumnName = (String)row.get("ATTRIB_COLUMN_NAME");
                Column column = Column.getColumn((String)tableName, (String)attribColumnName);
                Integer matchCriteriaId = (Integer)critJSON.get("matchCriteriaId");
                String value = (String)critJSON.get("value");
                if (attribId.equals(19020)) {
                    if (value != null && !value.equals("")) {
                        String[] multiValueArr = value.split(",");
                        criteria = new Criteria(column, (Object)multiValueArr, 8);
                    }
                    ArrayList<Long> list = new ArrayList<Long>();
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, criteria);
                    if (!dataObj.isEmpty()) {
                        Iterator ite = dataObj.getRows(tableName);
                        while (ite.hasNext()) {
                            Row r = (Row)ite.next();
                            list.add((Long)r.get("ADMP_ROLE_ID"));
                        }
                        criteria = new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_ROLE_ID"), (Object)list.toArray(new Long[list.size()]), 8);
                        list.clear();
                        DataObject dataObj1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPUsersRoleMapping", criteria);
                        if (!dataObj1.isEmpty()) {
                            Iterator ite1 = dataObj1.getRows("ADMPUsersRoleMapping");
                            while (ite1.hasNext()) {
                                Row r = (Row)ite1.next();
                                list.add((Long)r.get("LOGIN_ID"));
                            }
                            criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)list.toArray(new Long[list.size()]), ColumnFilterHandler.getComparator((int)matchCriteriaId));
                        }
                    }
                } else if (attribId.equals(19008)) {
                    String allDomains = "All Domains";
                    if (value != null && !value.equals("")) {
                        if (this.nonADIAMAppDomains.contains(value)) {
                            attribColumnName = "WAAD_TENANT_ID";
                            tableName = "ADMPUsersWAADAccountMapping";
                            column = Column.getColumn((String)tableName, (String)attribColumnName);
                            allDomains = "All Accounts";
                        }
                        criteria = new Criteria(column, (Object)value, 0);
                        criteria = criteria.or(new Criteria(column, (Object)allDomains, 0));
                    }
                    HashSet<Long> list = new HashSet<Long>();
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, criteria);
                    if (!dataObj.isEmpty()) {
                        Iterator ite = dataObj.getRows(tableName);
                        while (ite.hasNext()) {
                            Row r = (Row)ite.next();
                            list.add((Long)r.get("LOGIN_ID"));
                        }
                    }
                    criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)list.toArray(new Long[list.size()]), ColumnFilterHandler.getComparator((int)matchCriteriaId));
                } else if (attribId.equals(19019)) {
                    if (value != null && !value.equals("")) {
                        String[] multiValueArr = value.split(",");
                        criteria = new Criteria(column, (Object)multiValueArr, ColumnFilterHandler.getComparator((int)matchCriteriaId));
                    }
                } else if (attribId.equals(19010)) {
                    String domainName = null;
                    if (critJSON.has("selectedDomain")) {
                        domainName = (String)critJSON.get("selectedDomain");
                    }
                    if (value != null && !value.equals("")) {
                        String[] multiValue = value.split(";;;");
                        criteria = new Criteria(column, (Object)multiValue, 8);
                    }
                    HashSet<Long> list = new HashSet<Long>();
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, criteria);
                    if (!dataObj.isEmpty()) {
                        Iterator ite = dataObj.getRows(tableName);
                        while (ite.hasNext()) {
                            Row r = (Row)ite.next();
                            list.add((Long)r.get("LOGIN_ID"));
                        }
                    }
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADMPUsersRoleMapping"));
                    query.addJoin(new Join("ADMPUsersRoleMapping", "ADMPUsersOUMapping", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1));
                    criteria = new Criteria(Column.getColumn((String)"ADMPUsersOUMapping", (String)"LOGIN_ID"), null, 0);
                    Criteria domainCrit = new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_DOMAIN_NAME"), (Object)"All Domains", 0);
                    if (domainName != null) {
                        domainCrit = domainCrit.or(new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_DOMAIN_NAME"), (Object)domainName, 0));
                        criteria = criteria.and(domainCrit);
                    }
                    query.addSelectColumn(Column.getColumn(null, (String)"*"));
                    query.setCriteria(criteria);
                    dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                    if (!dataObj.isEmpty()) {
                        Iterator ite = dataObj.getRows("ADMPUsersRoleMapping");
                        while (ite.hasNext()) {
                            Row r = (Row)ite.next();
                            list.add((Long)r.get("LOGIN_ID"));
                        }
                    }
                    criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)list.toArray(new Long[list.size()]), ColumnFilterHandler.getComparator((int)matchCriteriaId));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteria;
    }

    public Criteria getCriteriaForADMPGroup(JSONObject critJSON, ArrayList<String> tableNames) {
        Criteria criteria = null;
        try {
            Integer attribId;
            Row row;
            if (critJSON.get("attribId") != null && !critJSON.get("attribId").equals("null") && (row = ReportAttributesUtil.getAttributeDetailsRow((Integer)(attribId = (Integer)critJSON.get("attribId")))) != null) {
                String tableName = (String)row.get("TABLE_NAME");
                String attribColumnName = (String)row.get("ATTRIB_COLUMN_NAME");
                Column column = Column.getColumn((String)tableName, (String)attribColumnName);
                Integer matchCriteriaId = (Integer)critJSON.get("matchCriteriaId");
                String value = (String)critJSON.get("value");
                if (attribId.equals(19020)) {
                    String[] multiValueArr = value.split(",");
                    ArrayList<Long> list = new ArrayList<Long>();
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, new Criteria(column, (Object)multiValueArr, 8));
                    if (!dataObj.isEmpty()) {
                        Iterator ite = dataObj.getRows(tableName);
                        while (ite.hasNext()) {
                            Row r = (Row)ite.next();
                            list.add((Long)r.get("ADMP_ROLE_ID"));
                        }
                        criteria = new Criteria(Column.getColumn((String)"ADMPGroupsRoleMapping", (String)"ADMP_ROLE_ID"), (Object)list.toArray(new Long[list.size()]), 8);
                        list.clear();
                        DataObject dataObj1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPGroupsRoleMapping", criteria);
                        if (!dataObj1.isEmpty()) {
                            Iterator ite1 = dataObj1.getRows("ADMPGroupsRoleMapping");
                            while (ite1.hasNext()) {
                                Row r = (Row)ite1.next();
                                list.add((Long)r.get("GROUP_ID"));
                            }
                            criteria = new Criteria(Column.getColumn((String)"ADMPGroupBasedHDT", (String)"GROUP_ID"), (Object)list.toArray(new Long[list.size()]), ColumnFilterHandler.getComparator((int)matchCriteriaId));
                        }
                    }
                } else if (attribId.equals(19008)) {
                    Criteria allAccountsCrit = null;
                    if (value != null && !value.equals("")) {
                        tableName = "ADMPGroupsRoleMapping";
                        attribColumnName = "ADMP_DOMAIN_NAME";
                        if (this.nonADIAMAppDomains.contains(value)) {
                            attribColumnName = "WAAD_TENANT_ID";
                            tableName = "ADMPGroupWAADAccountMapping";
                            column = Column.getColumn((String)tableName, (String)attribColumnName);
                            allAccountsCrit = new Criteria(Column.getColumn((String)tableName, (String)attribColumnName), (Object)"All Accounts", 0);
                        }
                        criteria = new Criteria(Column.getColumn((String)tableName, (String)attribColumnName), (Object)value, 0);
                        if (allAccountsCrit != null) {
                            criteria = criteria.or(allAccountsCrit);
                        }
                        HashSet<Long> list = new HashSet<Long>();
                        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, criteria);
                        if (!dataObj.isEmpty()) {
                            Iterator ite = dataObj.getRows(tableName);
                            while (ite.hasNext()) {
                                Row r = (Row)ite.next();
                                list.add((Long)r.get("GROUP_ID"));
                            }
                        }
                        criteria = new Criteria(Column.getColumn((String)"ADMPGroupBasedHDT", (String)"GROUP_ID"), (Object)list.toArray(new Long[list.size()]), ColumnFilterHandler.getComparator((int)matchCriteriaId));
                    }
                } else if (attribId.equals(19019)) {
                    String[] multiValueArr = value.split(",");
                    criteria = new Criteria(Column.getColumn((String)"ADMPGroupBasedHDT", (String)"DOMAIN_NAME"), (Object)multiValueArr, ColumnFilterHandler.getComparator((int)matchCriteriaId));
                } else if (attribId.equals(19010)) {
                    String[] multiValue = value.split(";;;");
                    String domainName = (String)critJSON.get("selectedDomain");
                    criteria = new Criteria(Column.getColumn((String)"ADMPGroupsOUMapping", (String)"DISTINGUISHED_NAME"), (Object)multiValue, 8);
                    HashSet<Long> list = new HashSet<Long>();
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPGroupsOUMapping", criteria);
                    if (!dataObj.isEmpty()) {
                        Iterator ite = dataObj.getRows("ADMPGroupsOUMapping");
                        while (ite.hasNext()) {
                            Row r = (Row)ite.next();
                            list.add((Long)r.get("GROUP_ID"));
                        }
                    }
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADMPGroupsRoleMapping"));
                    query.addJoin(new Join("ADMPGroupsRoleMapping", "ADMPGroupsOUMapping", new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 1));
                    criteria = new Criteria(Column.getColumn((String)"ADMPGroupsOUMapping", (String)"GROUP_ID"), null, 0);
                    Criteria domainCrit = new Criteria(Column.getColumn((String)"ADMPGroupsRoleMapping", (String)"ADMP_DOMAIN_NAME"), (Object)domainName, 0);
                    criteria = criteria.and(domainCrit);
                    query.addSelectColumn(Column.getColumn(null, (String)"*"));
                    query.setCriteria(criteria);
                    dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                    if (!dataObj.isEmpty()) {
                        Iterator ite = dataObj.getRows("ADMPGroupsRoleMapping");
                        while (ite.hasNext()) {
                            Row r = (Row)ite.next();
                            list.add((Long)r.get("GROUP_ID"));
                        }
                    }
                    criteria = new Criteria(Column.getColumn((String)"ADMPGroupBasedHDT", (String)"GROUP_ID"), (Object)list.toArray(new Long[list.size()]), ColumnFilterHandler.getComparator((int)matchCriteriaId));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteria;
    }

    public Criteria getDefaultCriteria(String tableName, String columnName, ArrayList<String> domainList) {
        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)domainList.toArray(new String[domainList.size()]), 8);
        return crit;
    }

    public Criteria getColumnSearchCriteria(HttpServletRequest request, JSONObject params, ArrayList totalColumnList) {
        Criteria searchCrit = null;
        try {
            String searchString = (String)params.get("searchText");
            Hashtable prop = ReportAttributeHandler.getInstance().getAttributeProps(Integer.toString(19006));
            String val = ReportResultUtil.getSearchString(searchString, (Integer)prop.get("ATTRIB_ID"));
            if (val != null && !val.equalsIgnoreCase("")) {
                request.setAttribute("searchString", (Object)searchString);
                val = "*" + val + "*";
                searchCrit = new Criteria(Column.getColumn((String)((String)prop.get("TABLE_NAME")), (String)((String)prop.get("ATTRIB_COLUMN_NAME"))), (Object)val, 2);
                searchCrit = searchCrit.or(new Criteria(Column.getColumn((String)"AaaUser", (String)"FULL_NAME"), (Object)val, 2));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchCrit;
    }

    public Criteria getColumnSearchCriteriaForGroup(HttpServletRequest request, JSONObject params, ArrayList totalColumnList) {
        Criteria searchCrit = null;
        try {
            String searchString = (String)params.get("searchText");
            Hashtable prop = ReportAttributeHandler.getInstance().getAttributeProps(Integer.toString(19006));
            String val = ReportResultUtil.getSearchString(searchString, (Integer)prop.get("ATTRIB_ID"));
            if (val != null && !val.equalsIgnoreCase("")) {
                request.setAttribute("searchString", (Object)searchString);
                val = "*" + val + "*";
                searchCrit = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"GROUP_NAME"), (Object)val, 2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchCrit;
    }

    public void exportReportForHDTReport(String reportFileName, String reportName, Integer reportId, String format, Long loginId, AdventNetResourceBundle rb, HttpServletResponse response, HttpServletRequest request, HashMap inputs) {
        try {
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            inputs.put("date", DateTimeUtil.getDateFormat((Long)loginId).format(System.currentTimeMillis()));
            inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputs.put("title", rb.getString("admp.deleg.hdd_reports.hdt_reports.hdt_reports"));
            inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            this.rb = rb;
            productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            basepath = productHome + File.separator + "webapps" + File.separator + "adsm" + File.separator;
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
            attributeList.add(ReportAttributeHandler.getInstance().getAttributeProps(Integer.toString(19006)));
            attributeList.addAll(ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId));
            this.setReportRows(request, attributeList, false, true);
            JSONObject resultList = (JSONObject)request.getAttribute("resultList");
            ArrayList dataSourceList = new ArrayList();
            ArrayList<JasperPrint> printList = new ArrayList<JasperPrint>();
            Iterator ite = resultList.keys();
            while (ite.hasNext()) {
                String hdtLoginId = (String)ite.next();
                JSONObject resultRow = (JSONObject)resultList.get(hdtLoginId);
                Hashtable iamAppIdVsDomainNames = (Hashtable)resultRow.get(Integer.toString(19008));
                Enumeration iamAppIds = iamAppIdVsDomainNames.keys();
                while (iamAppIds.hasMoreElements()) {
                    int iamAppId = (Integer)iamAppIds.nextElement();
                    ArrayList domains = (ArrayList)iamAppIdVsDomainNames.get(iamAppId);
                    if (domains.size() == 0) continue;
                    String iamAppName = "";
                    if (iamAppId == 3) {
                        iamAppName = rb.getString("admp.mgmt.fc_layout.common.text_o365");
                    } else if (iamAppId == 2) {
                        iamAppName = rb.getString("admp.mgmt.fc_layout.common.gsuite");
                    }
                    for (int j = 0; j < domains.size(); ++j) {
                        Hashtable<Integer, String> dataRow = new Hashtable<Integer, String>();
                        for (int k = 0; k < attributeList.size(); ++k) {
                            Properties prop = (Properties)attributeList.get(k);
                            Integer attribId = (Integer)prop.get("ATTRIB_ID");
                            String value = "";
                            if (attribId.equals(19006)) {
                                value = (String)resultRow.get(attribId.toString());
                            } else if (!attribId.equals(19006)) {
                                if (attribId.equals(19008)) {
                                    value = (String)domains.get(j);
                                    if (iamAppName.length() > 0) {
                                        value = value + " (" + iamAppName + ")";
                                    }
                                } else if (attribId == 19026 && (iamAppId == 3 || iamAppId == 2)) {
                                    Hashtable hash = (Hashtable)resultRow.get(attribId.toString());
                                    ArrayList delegatedDomains = (ArrayList)hash.get(domains.get(j));
                                    value = "";
                                    if (delegatedDomains != null) {
                                        for (String domain : delegatedDomains) {
                                            if (value.length() > 0) {
                                                value = value + ", ";
                                            }
                                            value = value + domain;
                                        }
                                    }
                                    if (value.equals("")) {
                                        value = "-";
                                    }
                                } else {
                                    int attribIamAppId = (Integer)prop.get("IAMAPP_ID");
                                    if (resultRow.has(attribId.toString()) && resultRow.get(attribId.toString()) != null && iamAppId == attribIamAppId) {
                                        Hashtable hash;
                                        if (attribId == 19007 || attribId == 19021) {
                                            hash = (Hashtable)resultRow.get(attribId.toString());
                                            value = (String)hash.get(domains.get(j));
                                            if (value == null && (value = (String)hash.get("All Domains")) == null) {
                                                value = "-";
                                            }
                                            if (value.equalsIgnoreCase("true")) {
                                                value = rb.getString("admp.mgmt.common.text.enabled");
                                            } else if (value.equalsIgnoreCase("false")) {
                                                value = rb.getString("admp.deleg.hdd_reports.hdt_reports.impersonate_admin_no");
                                            }
                                        } else if (attribId == 19023 || attribId == 19022 || attribId == 19024) {
                                            value = (String)resultRow.get(attribId.toString());
                                        } else if (attribId == 19025) {
                                            hash = (Hashtable)resultRow.get(attribId.toString());
                                            ArrayList valuesList = (ArrayList)hash.get(domains.get(j));
                                            if (valuesList == null || valuesList.isEmpty()) {
                                                value = "-";
                                            } else {
                                                JSONObject skuIdDet = (JSONObject)valuesList.get(0);
                                                if (skuIdDet.has("ALL_LICENSES_SELECTED")) {
                                                    value = skuIdDet.getString("ALL_LICENSES_SELECTED");
                                                } else {
                                                    for (JSONObject jsonObj : valuesList) {
                                                        if (value.length() > 0) {
                                                            value = value + "; ";
                                                        }
                                                        value = value + jsonObj.getString("ACCOUNT_SKU_ID") + jsonObj.getString("SERVICES");
                                                    }
                                                }
                                            }
                                        } else if (!(attribId.equals(19018) || attribId.equals(19011) || attribId.equals(19012) || attribId.equals(19013))) {
                                            hash = (Hashtable)resultRow.get(attribId.toString());
                                            value = (String)hash.get(domains.get(j));
                                            if (value == null || value.equals("")) {
                                                value = (String)hash.get("All Domains");
                                                if (((String)domains.get(j)).equalsIgnoreCase("-")) {
                                                    value = "-";
                                                }
                                            }
                                            if (value == null || value.equals("")) {
                                                value = attribId.equals(19010) ? rb.getString("admp.common.text.all") : "";
                                            }
                                        } else {
                                            hash = (Hashtable)resultRow.get(attribId.toString());
                                            Hashtable hashValue = (Hashtable)hash.get(domains.get(j));
                                            if (hashValue == null) {
                                                hashValue = (Hashtable)hash.get("All Domains");
                                            }
                                            if (hashValue != null) {
                                                for (Object tempCategory : hashValue.keySet()) {
                                                    String hValue = (String)hashValue.get(tempCategory.toString());
                                                    value = value + "<U>" + tempCategory.toString() + "</U>:" + hValue + "<br/>";
                                                }
                                            } else {
                                                value = hashValue == null && attribId.equals(19018) ? rb.getString("admp.deleg.hdt_deleg.hdt_export.all_templates") : "";
                                            }
                                        }
                                    }
                                }
                            } else {
                                value = "";
                            }
                            dataRow.put(attribId, value);
                        }
                        dataSourceList.add(dataRow);
                    }
                }
            }
            if (!dataSourceList.isEmpty()) {
                ReportJRDataSource dataSource = new ReportJRDataSource(dataSourceList, new Hashtable(), showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER);
                JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
                jasperDesign.setName(JRFieldDesignUtil.getReportName(reportName, rb));
                HDTReportListener.setPDFFontForTitleBand(format, jasperDesign, locale);
                if (format.toLowerCase().indexOf("pdf") != -1 || format.toLowerCase().indexOf("html") != -1) {
                    inputs.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
                } else {
                    inputs.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
                }
                JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
                JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
                Hashtable columnWidths = JRDesignUtil.calculateWidth(attributeList, dataSourceList, new Hashtable(), format, rb);
                if (!columnWidths.isEmpty()) {
                    JRDesignUtil.fillBandForHDTReport(columnWidths, jasperDesign, headerBand, detailBand, attributeList, format, null, 0, rb, loginId, showSerialNo, locale);
                } else {
                    JRDesignUtil.fillNoDataBand(jasperDesign, detailBand, format, rb, locale);
                }
                if (format.toLowerCase().indexOf("xlsx") != -1 || format.toLowerCase().indexOf("csv") != -1) {
                    int i;
                    JRElement[] elements;
                    if (format.toLowerCase().indexOf("csv") != -1) {
                        JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                        elements = titleBand.getElements();
                        for (i = 0; i < elements.length; ++i) {
                            titleBand.removeElement((JRDesignElement)elements[i]);
                        }
                        JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                        elements = pageHeaderBand.getElements();
                        for (int i2 = 0; i2 < elements.length; ++i2) {
                            pageHeaderBand.removeElement((JRDesignElement)elements[i2]);
                        }
                    }
                    JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                    elements = pageFooterBand.getElements();
                    for (i = 0; i < elements.length; ++i) {
                        pageFooterBand.removeElement((JRDesignElement)elements[i]);
                    }
                }
                JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
                JasperPrint print = null;
                print = !columnWidths.isEmpty() ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs, (JRDataSource)dataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs);
                printList.add(print);
                reportFileName = HDTReportListener.getFormattedFileName("HelpdeskTechniciansReports");
                ReportExportUtil.exportReporter(format, printList, reportFileName, response, request, locale, null, loginId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportReport(String reportFileName, String reportName, Integer reportId, String format, Long loginId, String selectedIdList, String searchText, String ascending, String sortColumn, AdventNetResourceBundle rb, HttpServletResponse response, HttpServletRequest request, HashMap inputs, DynaValidatorForm bean, Locale locale, String exportType) {
        try {
            ArrayList visibleColumnList = new ArrayList();
            ArrayList<HashMap> visibleColumns = new ArrayList<HashMap>();
            ArrayList<JasperPrint> printList = new ArrayList<JasperPrint>();
            Hashtable hdtList = new Hashtable();
            Hashtable hdtGroupList = new Hashtable();
            ArrayList<String> loginIds = new ArrayList<String>();
            ArrayList<String> groupIds = new ArrayList<String>();
            ArrayList rolesList = new ArrayList();
            Hashtable roleVsDetails = new Hashtable();
            ArrayList<Long> roleIds = new ArrayList<Long>();
            ArrayList resultList = new ArrayList();
            ArrayList<String> sheetNames = new ArrayList<String>();
            String subReportFileName = "";
            boolean isHDT = true;
            boolean isFullNameSelected = false;
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            Object jrPrintObject = null;
            int AddToPgNumber = 0;
            this.rb = rb;
            inputs.put("date", DateTimeUtil.getDateFormat((Long)loginId).format(System.currentTimeMillis()));
            inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputs.put("back", rb.getString("admp.deleg.hdt_deleg.hdt_export.back").toLowerCase());
            inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            basepath = productHome + File.separator + "webapps" + File.separator + "adsm" + File.separator;
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            if (exportType.equalsIgnoreCase("HelpDeskTechnician")) {
                isHDT = true;
                HashMap visibleNonVisibleMap = ColumnConfiguration.getCustomVisibleList((String)"HelpDeskTechnician", (Long)loginId);
                visibleColumnList = (ArrayList)visibleNonVisibleMap.get("visibleList");
                HashMap<String, String> statusMap = new HashMap<String, String>();
                statusMap.put("COL_NAME", "STATUS");
                statusMap.put("COLUMN_NAME", rb.getString("admp.deleg.hdt_deleg.hdt_export.status"));
                statusMap.put("TABLE_NAME", "AaaAccountStatus");
                visibleColumnList.add(statusMap);
                ArrayList invisibleColumnList = (ArrayList)visibleNonVisibleMap.get("nonVisibleList");
                ArrayList totalColumnList = new ArrayList();
                totalColumnList.addAll(visibleColumnList);
                totalColumnList.addAll(invisibleColumnList);
                String domainFilter = request.getParameter("domainFilters");
                String typeFilter = request.getParameter("typeFilters");
                String selectedUserList = "";
                String selectedGroupList = "";
                Boolean isGroupAvailable = Boolean.TRUE;
                Boolean isUserAvailable = Boolean.TRUE;
                if (selectedIdList != null && selectedIdList != "") {
                    String[] selectedIdListArray;
                    isGroupAvailable = Boolean.FALSE;
                    isUserAvailable = Boolean.FALSE;
                    for (String idList : selectedIdListArray = selectedIdList.split(",")) {
                        String[] strListArray = idList.split("_");
                        if (strListArray[0].equalsIgnoreCase("User")) {
                            isUserAvailable = Boolean.TRUE;
                            if (selectedUserList.length() == 0) {
                                selectedUserList = selectedUserList + strListArray[1];
                                continue;
                            }
                            selectedUserList = selectedUserList + "," + strListArray[1];
                            continue;
                        }
                        if (!strListArray[0].equalsIgnoreCase("Group")) continue;
                        isGroupAvailable = Boolean.TRUE;
                        selectedGroupList = selectedGroupList.length() == 0 ? selectedGroupList + strListArray[1] : selectedGroupList + "," + strListArray[1];
                    }
                }
                sheetNames.add(rb.getString("admp.deleg.hdt_deleg.hdt_export.title"));
                if (typeFilter != null && !typeFilter.equalsIgnoreCase("Group") && isUserAvailable.booleanValue()) {
                    hdtList = TechnicianHandler.getAvailableTechnicianForExport((String)"HelpDeskUser", totalColumnList, (String)selectedUserList, (String)searchText, (String)ascending, (String)sortColumn, loginIds, (String)domainFilter);
                    this.setDetailsListForExport(hdtList, resultList, sheetNames, visibleColumnList, loginIds);
                }
                if (typeFilter != null && !typeFilter.equalsIgnoreCase("User") && isGroupAvailable.booleanValue()) {
                    hdtGroupList = TechnicianGroupHandler.getAvailableTechnicianGroupForExport(totalColumnList, (String)selectedGroupList, (String)searchText, (String)ascending, (String)sortColumn, groupIds, (String)domainFilter);
                    this.setDetailsListForExport(hdtGroupList, resultList, sheetNames, visibleColumnList, groupIds);
                }
                inputs.put("title", rb.getString("admp.deleg.hdt_deleg.hdt_export.title"));
                this.setColumnListForHDTDetails(visibleColumns);
                subReportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "HDTReportDetails.xml";
                for (int i = 0; i < visibleColumnList.size(); ++i) {
                    HashMap attributeProp = (HashMap)visibleColumnList.get(i);
                    String columnName1 = (String)attributeProp.get("COL_NAME");
                    if (!columnName1.equalsIgnoreCase("FULL_NAME")) continue;
                    isFullNameSelected = true;
                    break;
                }
            } else if (exportType.equalsIgnoreCase("HelpDeskRoles")) {
                isHDT = false;
                String searchTxt = (String)bean.get("searchText");
                Boolean isAscending = (Boolean)bean.get("sortOrder");
                String sortedColumn = (String)bean.get("sortColumn");
                rolesList = HelpDeskRoleHandler.getHelpDeskRolesList((Integer)0, (Integer)0, (Boolean)isAscending, (String)sortedColumn, (String)searchTxt);
                this.initColumnList(visibleColumnList);
                sheetNames.add(rb.getString("admp.deleg.hdt_deleg.hdt_roles_export.title"));
                roleVsDetails = this.setDetailsForRoles(rolesList, visibleColumnList, resultList, sheetNames, roleIds);
                inputs.put("title", rb.getString("admp.deleg.hdt_deleg.hdt_roles_export.title"));
                this.setColumnListForRoleDetails(visibleColumns);
                subReportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "HDTRoles.xml";
            }
            this.setExportRowCount(resultList.size());
            if (!resultList.isEmpty()) {
                ReportJRRewindableDataSource dataSource = new ReportJRRewindableDataSource(resultList, showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER);
                JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
                HDTReportListener.setPDFFontForTitleBand(format, jasperDesign, locale);
                if (format.toLowerCase().indexOf("pdf") != -1 || format.toLowerCase().indexOf("html") != -1) {
                    inputs.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
                } else {
                    inputs.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
                    JRDesignBand footerBand = new JRDesignBand();
                    footerBand.setHeight(0);
                    jasperDesign.setPageFooter((JRBand)footerBand);
                }
                JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
                JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
                Hashtable columnWidths = JRDesignUtil.calculateWidthForHDTReport(visibleColumnList);
                if (!columnWidths.isEmpty()) {
                    JRDesignUtil.fillBandForHDTReport(columnWidths, jasperDesign, headerBand, detailBand, visibleColumnList, format, null, 0, rb, locale, isHDT, isFullNameSelected, showSerialNo, false, true);
                } else {
                    JRDesignUtil.fillNoDataBand(jasperDesign, detailBand, format, rb, locale);
                }
                JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
                HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
                JasperPrint print = null;
                print = !columnWidths.isEmpty() ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs, (JRDataSource)dataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs);
                AddToPgNumber += print.getPages().size();
                printList.add(print);
                JasperDesign jasperDes = JRXmlLoader.load((String)subReportFileName);
                HDTReportListener.setPDFFontForTitleBand(format, jasperDes, locale);
                JRDesignBand subHeaderBand = (JRDesignBand)jasperDes.getColumnHeader();
                JRDesignBand subDetailBand = (JRDesignBand)jasperDes.getDetail();
                if (format.toLowerCase().indexOf("xlsx") != -1 || isHDT && !isFullNameSelected) {
                    JRDesignBand summarBand = (JRDesignBand)jasperDes.getSummary();
                    JRElement[] elements = summarBand.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        summarBand.removeElement((JRDesignElement)elements[i]);
                    }
                    JRDesignBand footerBand = new JRDesignBand();
                    footerBand.setHeight(0);
                    jasperDes.setPageFooter((JRBand)footerBand);
                }
                Hashtable columnWidth = JRDesignUtil.calculateWidthForHDTDetails(visibleColumns);
                JRDesignUtil.fillBandForHDTReport(columnWidth, jasperDes, subHeaderBand, subDetailBand, visibleColumns, format, null, 0, rb, locale, isHDT, isFullNameSelected, false, true, false);
                JasperReport jasperRep = JasperCompileManager.compileReport((JasperDesign)jasperDes);
                ArrayList detailsList = new ArrayList();
                if (exportType.equalsIgnoreCase("HelpDeskTechnician")) {
                    this.fillDetailsForHDTExport(hdtList, detailsList, loginIds, "User");
                    this.fillDetailsForHDTExport(hdtGroupList, detailsList, groupIds, "Group");
                } else if (exportType.equalsIgnoreCase("HelpDeskRoles")) {
                    this.fillDetailsForRolesExport(roleVsDetails, detailsList, roleIds);
                }
                for (int i = 0; i < detailsList.size(); ++i) {
                    Hashtable details = (Hashtable)detailsList.get(i);
                    ArrayList techList = (ArrayList)details.get("detailsList");
                    HashMap input = (HashMap)details.get("inputs");
                    inputs.putAll(input);
                    inputs.put("AddToPgNumber", AddToPgNumber);
                    if (techList.isEmpty()) continue;
                    ReportJRRewindableDataSource dataSrc = new ReportJRRewindableDataSource(techList);
                    JasperPrint jrPrint = JasperFillManager.fillReport((JasperReport)jasperRep, (Map)inputs, (JRDataSource)dataSrc);
                    AddToPgNumber += jrPrint.getPages().size();
                    printList.add(jrPrint);
                }
            }
            reportFileName = HDTReportListener.getFormattedFileName(reportName);
            String[] sheetNamesArray = new String[sheetNames.size()];
            sheetNamesArray = sheetNames.toArray(sheetNamesArray);
            ReportExportUtil.exportReporter(format, printList, reportFileName, response, request, locale, sheetNamesArray, loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillDetailsForHDTExport(Hashtable reportList, ArrayList detailsList, ArrayList<String> loginIds, String objectClass) {
        try {
            Long[] loginIdsArr = new Long[loginIds.size()];
            int i = 0;
            for (String str : loginIds) {
                String[] strList = str.split("_");
                loginIdsArr[i] = Long.parseLong(strList[1]);
                ++i;
            }
            Hashtable loginIdVsDomainRoles = new Hashtable();
            Hashtable loginIdVsDomainCredential = new Hashtable();
            Hashtable loginIdVsOUList = new Hashtable();
            Hashtable loginIdVsTemplateList = new Hashtable();
            Hashtable loginIdVsIncludeGroups = new Hashtable();
            Hashtable loginIdVsIncludeOUs = new Hashtable();
            Hashtable loginIdVsExcludeGroups = new Hashtable();
            Hashtable loginIdVsExcludeOUs = new Hashtable();
            if (objectClass.equalsIgnoreCase("User")) {
                ArrayList directUserList = TechnicianDataHandler.getDirectUsers();
                loginIdVsDomainCredential = HelpdeskUtil.getLoginIdVsDomainCredentials((Long[])loginIdsArr, (boolean)Boolean.TRUE, (ArrayList)directUserList);
                loginIdVsDomainRoles = TechnicianHandler.getRoleListForHDT((Long[])loginIdsArr, (AdventNetResourceBundle)this.rb, (ArrayList)directUserList);
                loginIdVsOUList = HelpdeskUtil.getOUList((Long[])loginIdsArr, (Boolean)Boolean.TRUE, (ArrayList)directUserList);
                loginIdVsTemplateList = FcLayoutViewHandler.getAuthorizedLayouts((Long[])loginIdsArr, (AdventNetResourceBundle)this.rb, (Boolean)Boolean.TRUE, (ArrayList)directUserList);
                loginIdVsIncludeGroups = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIdsArr, (String)"group", (String)"INCLUDE", (Boolean)Boolean.TRUE, (ArrayList)directUserList);
                loginIdVsIncludeOUs = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIdsArr, (String)"organizationalUnit", (String)"INCLUDE", (Boolean)Boolean.TRUE, (ArrayList)directUserList);
                loginIdVsExcludeGroups = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIdsArr, (String)"group", (String)"EXCLUDE", (Boolean)Boolean.TRUE, (ArrayList)directUserList);
                loginIdVsExcludeOUs = HelpdeskUtil.getDelegatedGroupListName((Long[])loginIdsArr, (String)"organizationalUnit", (String)"EXCLUDE", (Boolean)Boolean.TRUE, (ArrayList)directUserList);
            } else if (objectClass.equalsIgnoreCase("Group")) {
                loginIdVsDomainCredential = ADMPGroupDelegationUtil.getGroupIdVsDomainCredentials((Long[])loginIdsArr);
                loginIdVsDomainRoles = ADMPGroupDelegationUtil.getRoleListForADMPGroup((Long[])loginIdsArr, (AdventNetResourceBundle)this.rb);
                loginIdVsOUList = ADMPGroupDelegationUtil.getOUListForADMPGroup((Long[])loginIdsArr);
                loginIdVsTemplateList = FcLayoutViewHandler.getAuthorizedLayoutsForGroup((Long[])loginIdsArr, (AdventNetResourceBundle)this.rb);
                loginIdVsIncludeGroups = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])loginIdsArr, (String)"group", (String)"INCLUDE");
                loginIdVsIncludeOUs = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])loginIdsArr, (String)"organizationalUnit", (String)"INCLUDE");
                loginIdVsExcludeGroups = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])loginIdsArr, (String)"group", (String)"EXCLUDE");
                loginIdVsExcludeOUs = ADMPGroupDelegationUtil.getDelegatedGroupListNameForADMPGroup((Long[])loginIdsArr, (String)"organizationalUnit", (String)"EXCLUDE");
            }
            String credentialActionName = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.impersonate_admin");
            String roleActionName = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.role_name");
            String ouActionName = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.delegated_ou");
            String templateActionName = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.templates");
            String includeGroup = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.include_group");
            String includeOU = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.include_ou");
            String excludeGroup = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.exclude_group");
            String excludeOU = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.exclude_ou");
            for (String str : loginIds) {
                String[] strList = str.split("_");
                Long loginId = Long.parseLong(strList[1]);
                Hashtable<String, Cloneable> resultList = new Hashtable<String, Cloneable>();
                Hashtable resultRow = (Hashtable)reportList.get(str);
                HashMap<String, String> inputs = new HashMap<String, String>();
                inputs.put("link", ClientUtil.htmlEscape(this.rb.getString((String)resultRow.get("FULL_NAME"))));
                inputs.put("Name", this.rb.getString((String)resultRow.get("FULL_NAME")));
                inputs.put("NameTitle", this.rb.getString("admp.deleg.hdt_deleg.hdt_export.name"));
                inputs.put("LoginName", this.rb.getString((String)resultRow.get("NAME")));
                inputs.put("LoginNameTitle", this.rb.getString("admp.deleg.hdt_deleg.hdt_export.login_name"));
                inputs.put("DomainName", this.rb.getString((String)resultRow.get("DOMAINNAME")));
                inputs.put("DomainNameTitle", this.rb.getString("admp.deleg.hdt_deleg.hdt_export.domain_name"));
                inputs.put("TechnicianDescriptionTitle", this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.description"));
                inputs.put("TechnicianDescription", this.rb.getString((String)resultRow.get("DESCRIPTION")));
                inputs.put("DomainNameHeader", this.rb.getString("admp.deleg.hdt_deleg.hdt_export.domain_name"));
                inputs.put("ActionName", this.rb.getString("admp.deleg.hdt_deleg.hdt_export.action_name"));
                inputs.put("Values", this.rb.getString("admp.deleg.hdt_deleg.hdt_export.values"));
                inputs.put("ObjectClass", this.rb.getString("admp.common.attrib_disp_name.obj_class"));
                if (objectClass.equalsIgnoreCase("Group")) {
                    inputs.put("ObjectClassValue", this.rb.getString("admp.common.objectclass.group"));
                } else {
                    inputs.put("ObjectClassValue", this.rb.getString("admp.common.objectclass.user"));
                }
                Hashtable domainVsCredential = (Hashtable)loginIdVsDomainCredential.get(loginId);
                Hashtable domainVsRoles = (Hashtable)loginIdVsDomainRoles.get(loginId);
                Hashtable domainVsOUs = (Hashtable)loginIdVsOUList.get(loginId);
                Hashtable domainVsTemplates = (Hashtable)loginIdVsTemplateList.get(loginId);
                Hashtable domainVsIncludeGroups = (Hashtable)loginIdVsIncludeGroups.get(loginId);
                Hashtable domainVsIncludeOUs = (Hashtable)loginIdVsIncludeOUs.get(loginId);
                Hashtable domainVsExcludeGroups = (Hashtable)loginIdVsExcludeGroups.get(loginId);
                Hashtable domainVsExcludeOUs = (Hashtable)loginIdVsExcludeOUs.get(loginId);
                if (domainVsRoles == null) continue;
                Enumeration configuredDomains = domainVsRoles.keys();
                ArrayList techList = new ArrayList();
                if (configuredDomains == null) continue;
                while (configuredDomains.hasMoreElements()) {
                    String credential;
                    String domainName = (String)configuredDomains.nextElement();
                    String rolesName = (String)domainVsRoles.get(domainName);
                    if (rolesName.equals("")) {
                        rolesName = "-";
                    }
                    if (domainName.equalsIgnoreCase("All Domains")) {
                        this.addToDetailsList(techList, this.rb.getString("admp.deleg.hdt_deleg.hdd_reports.all_domains"), roleActionName, rolesName);
                    } else {
                        this.addToDetailsList(techList, domainName, roleActionName, rolesName);
                    }
                    String ouNames = this.rb.getString("admp.common.text.all");
                    if (domainVsOUs != null && domainVsOUs.get(domainName) != null) {
                        ouNames = (String)domainVsOUs.get(domainName);
                    }
                    this.addToDetailsList(techList, "", ouActionName, ouNames);
                    String templateNames = this.rb.getString("admp.deleg.hdt_deleg.hdt_export.all_templates");
                    if (domainVsTemplates != null && domainVsTemplates.get(domainName) != null) {
                        Hashtable templatesHash = (Hashtable)domainVsTemplates.get(domainName);
                        if (templatesHash.size() > 0) {
                            templateNames = "";
                        }
                        for (Object tempCategory : templatesHash.keySet()) {
                            templateNames = templateNames + "<U>" + tempCategory.toString() + "</U>:" + (String)templatesHash.get(tempCategory.toString()) + "<br/>";
                        }
                    }
                    this.addToDetailsList(techList, "", templateActionName, templateNames);
                    if (domainVsIncludeGroups != null && domainVsIncludeGroups.get(domainName) != null) {
                        this.addToDetailsList(techList, "", includeGroup, (String)domainVsIncludeGroups.get(domainName));
                    }
                    if (domainVsIncludeOUs != null && domainVsIncludeOUs.get(domainName) != null) {
                        this.addToDetailsList(techList, "", includeOU, (String)domainVsIncludeOUs.get(domainName));
                    }
                    if (domainVsExcludeGroups != null && domainVsExcludeGroups.get(domainName) != null) {
                        this.addToDetailsList(techList, "", excludeGroup, (String)domainVsExcludeGroups.get(domainName));
                    }
                    if (domainVsExcludeOUs != null && domainVsExcludeOUs.get(domainName) != null) {
                        this.addToDetailsList(techList, "", excludeOU, (String)domainVsExcludeOUs.get(domainName));
                    }
                    credential = (credential = domainVsCredential.get(domainName).toString()).equalsIgnoreCase("true") ? this.rb.getString("admp.deleg.hdt_deleg.hdt_export.yes") : this.rb.getString("admp.deleg.hdt_deleg.hdt_export.no");
                    this.addToDetailsList(techList, "", credentialActionName, credential);
                }
                resultList.put("detailsList", techList);
                resultList.put("inputs", inputs);
                detailsList.add(resultList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillDetailsForRolesExport(Hashtable roleVsDetails, ArrayList detailsList, ArrayList<Long> roleIds) {
        Hashtable actionIdVsName = new Hashtable();
        Hashtable detailsHash = HelpDeskRoleUtil.getRoleActionsIds((Long[])roleIds.toArray(new Long[roleIds.size()]), actionIdVsName);
        for (Long roleId : roleIds) {
            Hashtable<String, Cloneable> resultList = new Hashtable<String, Cloneable>();
            HashMap<String, String> inputs = new HashMap<String, String>();
            ArrayList roleList = new ArrayList();
            HashMap resultRow = (HashMap)roleVsDetails.get(roleId);
            inputs.put("link", ClientUtil.htmlEscape(this.rb.getString((String)resultRow.get("ADMP_ROLE_NAME"))));
            inputs.put("Name", this.rb.getString((String)resultRow.get("ADMP_ROLE_NAME")));
            inputs.put("NameTitle", this.rb.getString("admp.deleg.hdt_deleg.hdt_roles_export.role_name"));
            String desc = (String)resultRow.get("ADMP_ROLE_DESCRIPTION");
            if (desc == null || desc.equals("")) {
                desc = " - ";
            }
            inputs.put("roleDesc", this.rb.getString(desc));
            inputs.put("roleDescription", this.rb.getString("admp.deleg.hdt_deleg.hdt_roles_export.role_description"));
            inputs.put("Level", this.rb.getString("admp.deleg.hdt_deleg.hdt_roles_export.role_description"));
            inputs.put("ActionName", this.rb.getString("admp.deleg.hdt_deleg.hdt_roles_export.role_description"));
            inputs.put("Values", this.rb.getString("admp.deleg.hdt_deleg.hdt_roles_export.role_description"));
            this.setListForRoleDetails(roleList, (Hashtable)detailsHash.get(roleId), actionIdVsName, roleId);
            resultList.put("detailsList", roleList);
            resultList.put("inputs", inputs);
            detailsList.add(resultList);
        }
    }

    private void setListForRoleDetails(ArrayList detailsList, Hashtable detailsHash, Hashtable actionIdVsName, Long roleId) {
        ArrayList parentIds = (ArrayList)detailsHash.get(0L);
        ArrayList actionIdsList = Collections.list(detailsHash.keys());
        ArrayList<Long> mgmtActionIdList = new ArrayList<Long>();
        ArrayList<String> mgmtActionNameList = new ArrayList<String>();
        ArrayList actionDetail = ADMPActionDetailsHandler.getActionDetails((Long)DelegationUtil.MANAGEMENT_TAB_ACTION_ID);
        for (int size = 0; size < actionDetail.size(); ++size) {
            Hashtable hash = (Hashtable)actionDetail.get(size);
            mgmtActionIdList.add((Long)hash.get("ACTION_ID"));
            mgmtActionNameList.add((String)hash.get("ACTION_NAME"));
        }
        ArrayList<Long> reportActionIdList = new ArrayList<Long>();
        ArrayList<String> reportActionNameList = new ArrayList<String>();
        actionDetail = ADMPActionDetailsHandler.getActionDetails((Long)DelegationUtil.REPORT_TAB_ACTION_ID);
        for (int size = 0; size < actionDetail.size(); ++size) {
            Hashtable hash = (Hashtable)actionDetail.get(size);
            reportActionIdList.add((Long)hash.get("ACTION_ID"));
            reportActionNameList.add((String)hash.get("ACTION_NAME"));
        }
        ArrayList<Long> adminActionIdList = new ArrayList<Long>();
        ArrayList<String> adminActionNameList = new ArrayList<String>();
        actionDetail = ADMPActionDetailsHandler.getActionDetails((Long)DelegationUtil.ADMINISTRATION_TAB_ACTION_ID);
        for (int size = 0; size < actionDetail.size(); ++size) {
            Hashtable hash = (Hashtable)actionDetail.get(size);
            adminActionIdList.add((Long)hash.get("ACTION_ID"));
            adminActionNameList.add((String)hash.get("ACTION_NAME"));
        }
        if (parentIds != null) {
            Collections.sort(parentIds);
            for (int i = 0; i < parentIds.size(); ++i) {
                int j;
                Long parentId = (Long)parentIds.get(i);
                if (parentId == 2L) {
                    for (j = 0; j < mgmtActionIdList.size(); ++j) {
                        ArrayList mgmtList = new ArrayList();
                        this.getMgmtChildSelectedIds((Long)mgmtActionIdList.get(j), (String)mgmtActionNameList.get(j), actionIdsList, actionIdVsName, mgmtList, detailsHash);
                        detailsList.addAll(mgmtList);
                    }
                    continue;
                }
                if (parentId == 3000L) {
                    for (j = 0; j < reportActionIdList.size(); ++j) {
                        ArrayList reportList = new ArrayList();
                        this.getReportChildSelectedIds((Long)reportActionIdList.get(j), (String)reportActionNameList.get(j), actionIdsList, actionIdVsName, reportList, detailsHash);
                        detailsList.addAll(reportList);
                    }
                    continue;
                }
                for (j = 0; j < adminActionIdList.size(); ++j) {
                    ArrayList adminList = new ArrayList();
                    this.getReportChildSelectedIds((Long)adminActionIdList.get(j), (String)adminActionNameList.get(j), actionIdsList, actionIdVsName, adminList, detailsHash);
                    detailsList.addAll(adminList);
                }
            }
        } else {
            for (int j = 0; j < mgmtActionIdList.size(); ++j) {
                ArrayList mgmtList = new ArrayList();
                this.getMgmtChildSelectedIds((Long)mgmtActionIdList.get(j), (String)mgmtActionNameList.get(j), actionIdsList, actionIdVsName, mgmtList, detailsHash);
                detailsList.addAll(mgmtList);
            }
        }
    }

    private void getMgmtChildSelectedIds(Long adMgmtId, String adMgmtName, ArrayList actionIdsList, Hashtable actionIdVsName, ArrayList dataList, Hashtable detailsHash) {
        try {
            ArrayList<Long> childIds = this.getChildIds(adMgmtId);
            for (int i = 0; i < childIds.size(); ++i) {
                Long childId = childIds.get(i);
                if (!actionIdsList.contains(childId)) continue;
                ArrayList<Long> firstLevelChildIds = this.getChildIds(childId);
                for (int j = 0; j < firstLevelChildIds.size(); ++j) {
                    ArrayList list;
                    Long firstLevelId = firstLevelChildIds.get(j);
                    if (actionIdsList.contains(firstLevelId)) {
                        Long thirdLevelId;
                        ArrayList thirdLevelChildIds;
                        Long secondLevelId;
                        String firstLevelChild;
                        ArrayList secondLevelChildIds;
                        if (firstLevelId.equals(DelegationUtil.CREATE_USER_ACTION_ID) || firstLevelId.equals(DelegationUtil.CREATE_CONTACT_ACTION_ID) || firstLevelId.equals(DelegationUtil.CREATE_GROUP_ACTION_ID) || firstLevelId.equals(DelegationUtil.CREATE_OU_ACTION_ID) || firstLevelId.equals(DelegationUtil.CREATE_SHARED_MAILBOX_ACTION_ID)) {
                            secondLevelChildIds = (ArrayList)detailsHash.get(firstLevelId);
                            firstLevelChild = "";
                            String secondLevelChild = "";
                            Hashtable<Long, ArrayList> categoryVsAttributes = new Hashtable<Long, ArrayList>();
                            for (int k = 0; k < secondLevelChildIds.size(); ++k) {
                                secondLevelId = (Long)secondLevelChildIds.get(k);
                                if (secondLevelId.equals(DelegationUtil.CREATE_SINLGLE_USER_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_BULK_USER_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_SINLGLE_CONTACT_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_BULK_CONTACT_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_SINLGLE_GROUP_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_BULK_GROUP_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_SINLGLE_OU_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_BULK_OU_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_SINGLE_SHARED_MAILBOX_ACTION_ID) || secondLevelId.equals(DelegationUtil.MODIFY_SHARED_MAILBOX_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_SINLGLE_COMPUTER_ACTION_ID) || secondLevelId.equals(DelegationUtil.CREATE_BULK_COMPUTER_ACTION_ID)) {
                                    if (!firstLevelChild.equals("")) {
                                        firstLevelChild = firstLevelChild + " , ";
                                    }
                                    if (actionIdVsName.get(secondLevelId) != null) {
                                        firstLevelChild = firstLevelChild + this.rb.getString((String)actionIdVsName.get(secondLevelId));
                                        continue;
                                    }
                                    firstLevelChild = firstLevelChild + "";
                                    continue;
                                }
                                thirdLevelChildIds = (ArrayList)detailsHash.get(secondLevelId);
                                if (thirdLevelChildIds == null) continue;
                                for (int l = 0; l < thirdLevelChildIds.size(); ++l) {
                                    ArrayList actionIds;
                                    thirdLevelId = (Long)thirdLevelChildIds.get(l);
                                    if (categoryVsAttributes.get(secondLevelId) == null) {
                                        actionIds = new ArrayList();
                                        actionIds.add(thirdLevelId);
                                        categoryVsAttributes.put(secondLevelId, actionIds);
                                        continue;
                                    }
                                    actionIds = (ArrayList)categoryVsAttributes.get(secondLevelId);
                                    actionIds.add(thirdLevelId);
                                }
                            }
                            Enumeration keys = categoryVsAttributes.keys();
                            while (keys.hasMoreElements()) {
                                Long key = (Long)keys.nextElement();
                                if (!secondLevelChild.equals("")) {
                                    secondLevelChild = secondLevelChild + "<BR/>";
                                }
                                secondLevelChild = key.equals(DelegationUtil.OFFICE_365_ID) || key.equals(DelegationUtil.SHARED_MAILBOX_OFFICE_365_ID) ? secondLevelChild + "<U>" + this.rb.getString("admp.mgmt.fc_layout.common.text_o365") + "</U> : " : (actionIdVsName.get(key) != null ? secondLevelChild + "<U>" + this.rb.getString((String)actionIdVsName.get(key)) + "</U> : " : secondLevelChild + "");
                                ArrayList list2 = (ArrayList)categoryVsAttributes.get(key);
                                String ids = "";
                                for (Long id : list2) {
                                    if (!ids.equals("")) {
                                        ids = ids + " , ";
                                    }
                                    if (actionIdVsName.get(id) != null) {
                                        ids = ids + this.rb.getString((String)actionIdVsName.get(id));
                                        continue;
                                    }
                                    ids = ids + "";
                                }
                                secondLevelChild = secondLevelChild + ids;
                            }
                            String action = "";
                            if (dataList.size() == 0) {
                                action = this.rb.getString(adMgmtName);
                            }
                            this.addToDetailsList(dataList, action, firstLevelChild, secondLevelChild);
                            continue;
                        }
                        secondLevelChildIds = (ArrayList)detailsHash.get(firstLevelId);
                        firstLevelChild = "";
                        for (int k = 0; k < secondLevelChildIds.size(); ++k) {
                            Hashtable data = new Hashtable();
                            String secondLevelChild = "";
                            secondLevelId = (Long)secondLevelChildIds.get(k);
                            firstLevelChild = actionIdVsName.get(secondLevelId) != null ? this.rb.getString((String)actionIdVsName.get(secondLevelId)) : "";
                            if (detailsHash.get(secondLevelId) != null) {
                                thirdLevelChildIds = (ArrayList)detailsHash.get(secondLevelId);
                                for (int l = 0; l < thirdLevelChildIds.size(); ++l) {
                                    thirdLevelId = (Long)thirdLevelChildIds.get(l);
                                    if (!secondLevelChild.equals("")) {
                                        secondLevelChild = secondLevelChild + " , ";
                                    }
                                    secondLevelChild = actionIdVsName.get(thirdLevelId) != null ? secondLevelChild + this.rb.getString((String)actionIdVsName.get(thirdLevelId)) : secondLevelChild + "";
                                }
                            }
                            String action = "";
                            if (dataList.size() == 0) {
                                action = this.rb.getString(adMgmtName);
                            }
                            this.addToDetailsList(dataList, action, firstLevelChild, secondLevelChild);
                        }
                        continue;
                    }
                    if (!firstLevelId.equals(DelegationUtil.DENY_BULK_MODIFY_ACTION_ID) && !firstLevelId.equals(DelegationUtil.DENY_BULK_USER_CSV_ACTION_ID) && !firstLevelId.equals(DelegationUtil.DENY_BULK_COMP_CSV_ACTION_ID) && !firstLevelId.equals(DelegationUtil.DENY_BULK_CONTACT_CSV_ACTION_ID) && !firstLevelId.equals(DelegationUtil.DENY_BULK_GROUP_CSV_ACTION_ID) && !firstLevelId.equals(DelegationUtil.DENY_BULK_OU_CSV_ACTION_ID) && !firstLevelId.equals(DelegationUtil.DENY_BULK_MODIFY_GROUP_ACTION_ID) || !(list = (ArrayList)detailsHash.get(childId)).contains(firstLevelId)) continue;
                    String action = "";
                    if (dataList.size() == 0) {
                        action = this.rb.getString(adMgmtName);
                    }
                    if (actionIdVsName.get(firstLevelId) != null) {
                        this.addToDetailsList(dataList, action, this.rb.getString((String)actionIdVsName.get(firstLevelId)), "-");
                        continue;
                    }
                    this.addToDetailsList(dataList, action, "", "-");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getReportChildSelectedIds(Long adReportId, String adReportsName, ArrayList actionIdsList, Hashtable actionIdVsName, ArrayList dataList, Hashtable detailsHash) {
        try {
            if (adReportId == 9000L) {
                ArrayList childIds = (ArrayList)detailsHash.get(adReportId);
                for (int j = 0; childIds != null && j < childIds.size(); ++j) {
                    Long childId = (Long)childIds.get(j);
                    String action = "";
                    if (dataList.size() == 0) {
                        action = this.rb.getString(adReportsName);
                    }
                    if (actionIdVsName.get(childId) != null) {
                        this.addToDetailsList(dataList, action, this.rb.getString((String)actionIdVsName.get(childId)), "");
                        continue;
                    }
                    this.addToDetailsList(dataList, action, "", "");
                }
            } else {
                ArrayList<Long> childIds = this.getChildIds(adReportId);
                for (int i = 0; i < childIds.size(); ++i) {
                    Long childId = childIds.get(i);
                    if (!actionIdsList.contains(childId)) continue;
                    ArrayList childIdsLevel1 = (ArrayList)detailsHash.get(childId);
                    Hashtable data = new Hashtable();
                    String values = "";
                    for (int j = 0; j < childIdsLevel1.size(); ++j) {
                        Long level1Id = (Long)childIdsLevel1.get(j);
                        if (j != 0) {
                            values = values + " , ";
                        }
                        String val = "";
                        if (actionIdVsName.get(level1Id) != null) {
                            val = this.rb.getString((String)actionIdVsName.get(level1Id));
                        }
                        values = values + val;
                    }
                    String action = "";
                    if (dataList.size() == 0) {
                        action = this.rb.getString(adReportsName);
                    }
                    if (actionIdVsName.get(childId) != null) {
                        this.addToDetailsList(dataList, action, this.rb.getString((String)actionIdVsName.get(childId)), values);
                        continue;
                    }
                    this.addToDetailsList(dataList, action, "", values);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<Long> getChildIds(Long actionId) {
        ArrayList<Long> childIdList = new ArrayList<Long>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"PARENT_ID"), (Object)actionId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPActionDetails", crit);
            if (!dataObj.isEmpty()) {
                Iterator ite = dataObj.getRows("ADMPActionDetails");
                while (ite.hasNext()) {
                    Row row = (Row)ite.next();
                    Long childId = (Long)row.get("ACTION_ID");
                    childIdList.add(childId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childIdList;
    }

    private Hashtable setDetailsForRoles(ArrayList reportList, ArrayList visibleColumnList, ArrayList resultList, ArrayList sheetNames, ArrayList<Long> roleIds) {
        Hashtable<Long, HashMap> roleVsDetails = new Hashtable<Long, HashMap>();
        for (int i = 0; i < reportList.size(); ++i) {
            HashMap hash = (HashMap)reportList.get(i);
            roleIds.add((Long)hash.get("ADMP_ROLE_ID"));
            roleVsDetails.put((Long)hash.get("ADMP_ROLE_ID"), hash);
            sheetNames.add(this.rb.getString((String)hash.get("ADMP_ROLE_NAME")));
            ArrayList list = (ArrayList)hash.get("ADMP_ROLE_USERS");
            String users = "";
            for (int j = 0; j < list.size(); ++j) {
                users = users + ClientUtil.htmlEscape(this.rb.getString((String)list.get(j)));
                if (j >= list.size() - 1) continue;
                users = users + " , ";
            }
            if (users.equals("")) {
                users = "-";
            }
            hash.put("ADMP_ROLE_USERS", users);
            Hashtable<String, String> detailsHash = new Hashtable<String, String>();
            for (int j = 0; j < visibleColumnList.size(); ++j) {
                HashMap columnMap = (HashMap)visibleColumnList.get(j);
                String key = (String)columnMap.get("COL_NAME");
                String value = (String)hash.get(key);
                if (value == null || value.equals("")) {
                    value = " -";
                }
                detailsHash.put(key, this.rb.getString(value));
            }
            resultList.add(detailsHash);
        }
        return roleVsDetails;
    }

    public void setDetailsListForExport(Hashtable reportList, ArrayList resultList, ArrayList sheetNames, ArrayList visibleColumnList, ArrayList<String> loginIds) {
        for (String loginId : loginIds) {
            String roleListString = "";
            Hashtable hash = (Hashtable)reportList.get(loginId);
            ArrayList roleList = (ArrayList)hash.get("ADMP_ROLE_NAME");
            for (int j = 0; j < roleList.size(); ++j) {
                Hashtable detailsHash = (Hashtable)roleList.get(j);
                String value = (String)detailsHash.get("ADMP_ROLE_NAME");
                roleListString = roleListString + this.rb.getString(value);
                if (j == roleList.size() - 1) continue;
                roleListString = roleListString + ",";
            }
            if (roleListString.length() == 0) {
                roleListString = "-";
            }
            Hashtable<String, String> detailsHash = new Hashtable<String, String>();
            for (int j = 0; j < visibleColumnList.size(); ++j) {
                HashMap visibleColumn = (HashMap)visibleColumnList.get(j);
                String key = (String)visibleColumn.get("COL_NAME");
                if (hash.get(key) == null) continue;
                if (key.equalsIgnoreCase("ADMP_ROLE_NAME")) {
                    detailsHash.put(key, roleListString);
                } else if (key.equalsIgnoreCase("STATUS")) {
                    String status = (String)hash.get(key);
                    status = status.equalsIgnoreCase("DEACTIVATED") ? this.rb.getString("admp.deleg.hdt_deleg.hdd_reports.disabled") : (status.equalsIgnoreCase("FORCEDOUT") ? this.rb.getString("admp.deleg.hdt_deleg.hdd_reports.forced_out") : this.rb.getString("admp.deleg.hdt_deleg.hdd_reports.enabled"));
                    detailsHash.put(key, status);
                } else if (key.equalsIgnoreCase("DESCRIPTION")) {
                    detailsHash.put(key, ClientUtil.htmlEscape(this.rb.getString((String)hash.get(key))));
                } else {
                    detailsHash.put(key, this.rb.getString((String)hash.get(key)));
                }
                if (!key.equalsIgnoreCase("FULL_NAME") || ((String)hash.get("STATUS")).equalsIgnoreCase("FORCEDOUT")) continue;
                sheetNames.add(ClientUtil.htmlEscape(this.rb.getString((String)hash.get(key))));
            }
            resultList.add(detailsHash);
        }
    }

    private void setColumnListForRoleDetails(ArrayList<HashMap> visibleColumns) {
        String[] col_name = new String[]{"field1", "field2", "field3"};
        String[] column_name = new String[]{"admp.deleg.hdt_deleg.hdt_roles_export.level", "admp.deleg.hdt_deleg.hdt_roles_export.action_name", "admp.deleg.hdt_deleg.hdt_roles_export.values"};
        for (int i = 0; i < col_name.length; ++i) {
            HashMap<String, String> columnMap = new HashMap<String, String>();
            columnMap.put("COL_NAME", col_name[i]);
            columnMap.put("COLUMN_NAME", column_name[i]);
            visibleColumns.add(columnMap);
        }
    }

    private void setColumnListForHDTDetails(ArrayList<HashMap> visibleColumns) {
        String[] col_name = new String[]{"field1", "field2", "field3"};
        String[] column_name = new String[]{"admp.deleg.hdt_deleg.hdt_export.domain_name", "admp.deleg.hdt_deleg.hdt_export.action_name", "admp.deleg.hdt_deleg.hdt_export.values"};
        for (int i = 0; i < col_name.length; ++i) {
            HashMap<String, String> columnMap = new HashMap<String, String>();
            columnMap.put("COL_NAME", col_name[i]);
            columnMap.put("COLUMN_NAME", column_name[i]);
            visibleColumns.add(columnMap);
        }
    }

    private void addToDetailsList(ArrayList detailsList, String domainName, String actionName, String values) {
        Hashtable<String, String> row = new Hashtable<String, String>();
        row.put("field1", domainName);
        row.put("field2", actionName);
        row.put("field3", values);
        detailsList.add(row);
    }

    private static String getFormattedFileName(String reportFileName) {
        if (reportFileName != null) {
            String reportFileName1 = reportFileName;
            Vector<String> vector = new Vector<String>();
            String strTemp = new String();
            for (int i = 0; i < reportFileName1.length(); ++i) {
                char c = '/';
                if (reportFileName1.charAt(i) == c) {
                    vector.add(strTemp);
                    strTemp = new String();
                    continue;
                }
                strTemp = strTemp + reportFileName1.charAt(i);
            }
            vector.add(strTemp);
            String newreportFileName = "";
            for (int j = 0; j < vector.size(); ++j) {
                String name = (String)vector.elementAt(j);
                newreportFileName = newreportFileName + name;
            }
            reportFileName = newreportFileName;
        }
        return reportFileName;
    }

    public void initColumnList(ArrayList visibleColumnList) {
        String[] col_names = new String[]{"ADMP_ROLE_NAME", "ADMP_ROLE_DESCRIPTION", "ADMP_ROLE_USERS"};
        String[] column_names = new String[]{"admp.deleg.hdt_deleg.hdt_roles_export.role_name", "admp.deleg.hdt_deleg.hdt_roles_export.role_description", "admp.deleg.hdt_deleg.hdt_roles_export.technicians"};
        for (int i = 0; i < 3; ++i) {
            HashMap<String, String> columnMap = new HashMap<String, String>();
            columnMap.put("COL_NAME", this.rb.getString(col_names[i]));
            columnMap.put("COLUMN_NAME", this.rb.getString(column_names[i]));
            visibleColumnList.add(columnMap);
        }
    }

    public static void setPDFFontForTitleBand(String reportType, JasperDesign jasperDesign, Locale locale) {
        if (reportType.toLowerCase().indexOf("pdf") != -1) {
            int i;
            JRFont reportPDFFont = JRFieldDesignUtil.getPDFExporterFont(locale);
            JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, 12, false, false);
            if (jasperDesign.getTitle() != null) {
                JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                JRElement[] elements = titleBand.getElements();
                for (i = 0; i < elements.length; ++i) {
                    if (!(elements[i] instanceof JRDesignTextField)) continue;
                    ((JRDesignTextField)elements[i]).setFont((JRFont)normalFont);
                }
            }
            if (jasperDesign.getPageHeader() != null) {
                JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                JRElement[] elements1 = pageHeaderBand.getElements();
                for (i = 0; i < elements1.length; ++i) {
                    if (!(elements1[i] instanceof JRDesignTextField)) continue;
                    ((JRDesignTextField)elements1[i]).setFont((JRFont)normalFont);
                }
            }
        }
    }

    public void setExportRowCount(int count) {
        this.exportCount = count;
    }

    public int getExportRowCount() {
        return this.exportCount;
    }
}

