/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.sym.adsm.common.server.delegation.ADMPGroupDelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.HelpDeskRoleHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianDataHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianGroupHandler;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.DWRUtil;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcTemplateAuthorization;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.net.URLCodec;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class TechnicianConfig {
    private static Logger logger = Logger.getLogger(TechnicianConfig.class.getName());

    public static void setUserDetails(HttpServletRequest request, DynaValidatorForm bean, Hashtable hash, AdventNetResourceBundle rb) throws Exception {
        Properties properties = null;
        ArrayList configuredDomainList = (ArrayList)hash.get("ADMP_CONFIGURED_DOMAINS");
        Hashtable ouDetails = (Hashtable)hash.get("ADMP_OU_DETAILS");
        Hashtable<String, ArrayList> domainVsOUList = new Hashtable<String, ArrayList>();
        String[] configuredDomains = new String[configuredDomainList.size()];
        HttpSession session = request.getSession();
        int i = 0;
        for (String domain : configuredDomainList) {
            properties = DomainUtil.getDomainDetails((String)domain, (String)"DOMAIN_NAME");
            String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            ArrayList domainOuDetails = (ArrayList)ouDetails.get(domain);
            domainVsOUList.put(defaultNamingContext, domainOuDetails);
            configuredDomains[i] = domain;
            ++i;
        }
        String domainName = (String)hash.get("DOMAIN_NAME");
        Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("AddOus");
        if (!errorId.booleanValue() && domainName.equalsIgnoreCase("ADManager Plus Authentication")) {
            domainName = DomainUtil.getDefaultDomain();
        }
        String objectClass = "User";
        if (request.getParameter("classType") != null) {
            objectClass = request.getParameter("classType");
        }
        Hashtable credentials = new Hashtable();
        credentials = (Hashtable)hash.get("ADMIN_CREDENTIAL");
        String templateList = (String)hash.get("ADMP_TEMPLATE_DETAILS");
        ArrayList allDomains = DomainUtil.getConfiguredDomainNamesList();
        templateList = TechnicianConfig.addLayouIdsOfAllSelectedTemplateCategories(Long.parseLong(request.getParameter("loginID")), objectClass, templateList, allDomains, rb);
        Hashtable domainAndOuList = HDTDomainHandler.getDomainsAndOUs((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
        bean.set("description", (Object)rb.getString((String)hash.get("DESCRIPTION")));
        bean.set("emailAddress", hash.get("EMAIL_ADDRESS"));
        bean.set("configuredDomains", (Object)configuredDomains);
        bean.set("domainName", (Object)domainName);
        bean.set("userNameString", hash.get("NAME"));
        bean.set("userDN", hash.get("NAME"));
        bean.set("objectClass", (Object)objectClass);
        bean.set("domainOUList", domainVsOUList);
        bean.set("domainVsRoleID", hash.get("DOMAIN_ROLE_ID"));
        bean.set("UserDomainName", hash.get("DOMAIN_NAME"));
        bean.set("adminCredential", (Object)credentials);
        bean.set("templateList", (Object)templateList);
        bean.set("appendIncludedExcludedGroupOU", (Object)((String)hash.get("APPEND_GROUPS")));
        bean.set("includeGroupsMap", (Object)((HashMap)hash.get("INCLUDE_GROUP")));
        bean.set("excludeGroupsMap", (Object)((HashMap)hash.get("EXCLUDE_GROUP")));
        bean.set("rolesList", (Object)HelpDeskRoleHandler.getADMPRoles());
        bean.set("domainList", (Object)domainAndOuList);
        Hashtable waadAccountDetails = (Hashtable)hash.get("WAAD_ACCOUNT_DETAILS");
        TechnicianConfig.removeUnAuthorizedAccountDetails(waadAccountDetails, (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT"));
        bean.set("WAADDomainList", (Object)waadAccountDetails);
        Hashtable<String, String> domainVsFirstLayoutName = new Hashtable<String, String>();
        if (objectClass.equalsIgnoreCase("Group")) {
            for (String domain : allDomains) {
                String firstLayoutName = TechnicianConfig.getFirstLayoutName(templateList, rb, Long.parseLong(request.getParameter("loginID")), new String[]{domain}, "Group");
                domainVsFirstLayoutName.put(domain, firstLayoutName);
            }
        } else {
            for (String domain : allDomains) {
                String firstLayoutName = TechnicianConfig.getFirstLayoutName(templateList, rb, Long.parseLong(request.getParameter("loginID")), new String[]{domain}, "User");
                domainVsFirstLayoutName.put(domain, firstLayoutName);
            }
            if (!TechnicianDataHandler.isDirectUser((Long)Long.parseLong(request.getParameter("loginID"))).booleanValue()) {
                bean.set("excludeFromADMPGroup", (Object)new String("true"));
            } else {
                bean.set("excludeFromADMPGroup", hash.get("EXCLUDE_FROM_ADMP_GROUP"));
            }
        }
        request.setAttribute("firstLayoutName", domainVsFirstLayoutName);
        request.setAttribute("fileServerListHash", hash.get("fileServerListHash"));
    }

    public static void removeUnAuthorizedAccountDetails(Hashtable waadAccountDetails, ADMPAuthObject authObj) {
        try {
            Hashtable iamAppAccountsVsDetails = authObj.getAuthorizedIamAppAccountDetails();
            Enumeration iamAppAccounts = iamAppAccountsVsDetails.keys();
            while (iamAppAccounts.hasMoreElements()) {
                Hashtable authorizedLicenseDetails;
                String iamAppAccount = (String)iamAppAccounts.nextElement();
                Hashtable iamAccountDetails = (Hashtable)iamAppAccountsVsDetails.get(iamAppAccount);
                int iamAppId = (Integer)iamAccountDetails.get("iamAppId");
                if (!((Boolean)iamAccountDetails.get("isWaadAccountSelected")).booleanValue()) {
                    waadAccountDetails.remove(iamAppAccount);
                    continue;
                }
                Hashtable authorizedDomainsHash = (Hashtable)iamAccountDetails.get("WaadSelectedDomainsHash");
                Hashtable toBeDisplayedAccDetails = (Hashtable)waadAccountDetails.get(iamAppAccount);
                Hashtable toBeDisplayedDomainsHash = (Hashtable)toBeDisplayedAccDetails.get("WaadSelectedDomainsHash");
                Enumeration domains = authorizedDomainsHash.keys();
                while (domains.hasMoreElements()) {
                    String domain = (String)domains.nextElement();
                    if (((Boolean)authorizedDomainsHash.get(domain)).booleanValue()) continue;
                    toBeDisplayedDomainsHash.remove(domain);
                }
                if (iamAppId != 3 || (authorizedLicenseDetails = (Hashtable)iamAccountDetails.get("SelectedLicenseServiceHash")) == null) continue;
                Hashtable authorizedLicenseCountDetails = (Hashtable)iamAccountDetails.get("SelectedLicenseServiceCountHash");
                Hashtable toBeDisplayedLicenseDetails = (Hashtable)toBeDisplayedAccDetails.get("SelectedLicenseServiceHash");
                Hashtable toBeDisplayedLicenseCountDetails = (Hashtable)toBeDisplayedAccDetails.get("SelectedLicenseServiceCountHash");
                Enumeration skuIds = authorizedLicenseDetails.keys();
                while (skuIds.hasMoreElements()) {
                    String skuId = (String)skuIds.nextElement();
                    Hashtable countDetails = (Hashtable)authorizedLicenseCountDetails.get(skuId);
                    boolean noServicesSelected = (Boolean)countDetails.get("NoServicesSelected");
                    boolean allServicesSelected = (Boolean)countDetails.get("AllServicesSelected");
                    Hashtable toBeDisplayedCountDetails = (Hashtable)toBeDisplayedLicenseCountDetails.get(skuId);
                    if (allServicesSelected) {
                        toBeDisplayedCountDetails.put("UnAuthorizedServices", new JSONArray().toString());
                        continue;
                    }
                    if (noServicesSelected) {
                        toBeDisplayedCountDetails.put("UnAuthorizedServices", "All Services");
                        continue;
                    }
                    Hashtable authorizedServicesHash = (Hashtable)authorizedLicenseDetails.get(skuId);
                    Enumeration services = authorizedServicesHash.keys();
                    JSONArray unAuthorizedServices = new JSONArray();
                    while (services.hasMoreElements()) {
                        String service = (String)services.nextElement();
                        if (((Boolean)authorizedServicesHash.get(service)).booleanValue()) continue;
                        unAuthorizedServices.put((Object)service);
                    }
                    toBeDisplayedCountDetails.put("UnAuthorizedServices", unAuthorizedServices.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String addLayouIdsOfAllSelectedTemplateCategories(Long id, String objectClass, String templateList, ArrayList configuredDomains, AdventNetResourceBundle rb) {
        try {
            JSONObject layoutsJSONObj = new JSONObject(templateList);
            JSONObject userLayoutsObj = (JSONObject)layoutsJSONObj.get("user");
            JSONObject userCreationTemplatesObj = (JSONObject)userLayoutsObj.get("creation");
            JSONObject userModificationTemplatesObj = (JSONObject)userLayoutsObj.get("modification");
            JSONObject groupLayoutsObj = (JSONObject)layoutsJSONObj.get("group");
            JSONObject groupCreationTemplatesObj = (JSONObject)groupLayoutsObj.get("creation");
            JSONObject groupModificationTemplatesObj = (JSONObject)groupLayoutsObj.get("modification");
            JSONObject computerLayoutsObj = (JSONObject)layoutsJSONObj.get("computer");
            JSONObject computerCreationTemplatesObj = (JSONObject)computerLayoutsObj.get("creation");
            JSONObject contactLayoutsObj = (JSONObject)layoutsJSONObj.get("contact");
            JSONObject contactCreationTemplatesObj = (JSONObject)contactLayoutsObj.get("creation");
            JSONObject contactModificationTemplatesObj = (JSONObject)contactLayoutsObj.get("modification");
            JSONObject ouLayoutsObj = (JSONObject)layoutsJSONObj.get("OU");
            JSONObject ouCreationTemplatesObj = (JSONObject)ouLayoutsObj.get("creation");
            JSONObject ouModificationTemplatesObj = (JSONObject)ouLayoutsObj.get("modification");
            JSONObject dlGroupLayoutsObj = (JSONObject)layoutsJSONObj.get("dlGroup");
            JSONObject dlGroupCreationTemplatesObj = (JSONObject)dlGroupLayoutsObj.get("creation");
            JSONObject sharedLayoutsObj = (JSONObject)layoutsJSONObj.get("shared");
            JSONObject sharedCreationTemplatesObj = (JSONObject)sharedLayoutsObj.get("creation");
            JSONObject sharedModificationTemplatesObj = (JSONObject)sharedLayoutsObj.get("modification");
            JSONObject roomLayoutsObj = (JSONObject)layoutsJSONObj.get("room");
            JSONObject roomCreationTemplatesObj = (JSONObject)roomLayoutsObj.get("creation");
            JSONObject linkedLayoutsObj = (JSONObject)layoutsJSONObj.get("linked");
            JSONObject linkedCreationTemplatesObj = (JSONObject)linkedLayoutsObj.get("creation");
            JSONObject roomModificationTemplatesObj = (JSONObject)roomLayoutsObj.get("modification");
            JSONObject equipmentLayoutsObj = (JSONObject)layoutsJSONObj.get("equipment");
            JSONObject equipmentCreationTemplatesObj = (JSONObject)equipmentLayoutsObj.get("creation");
            JSONObject equipmentModificationTemplatesObj = (JSONObject)equipmentLayoutsObj.get("modification");
            Hashtable<Long, String[]> templateObjVsCategoryId = new Hashtable<Long, String[]>();
            if (((Boolean)userCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.userCreationTemplateCategoryId, new String[]{"user", "creation"});
            }
            if (((Boolean)userModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.userModificationTemplateCategoryId, new String[]{"user", "modification"});
            }
            if (((Boolean)groupCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.groupCreationTemplateCategoryId, new String[]{"group", "creation"});
            }
            if (((Boolean)groupModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.groupModificationTemplateCategoryId, new String[]{"group", "modification"});
            }
            if (((Boolean)computerCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.computerCreationTemplateCategoryId, new String[]{"computer", "creation"});
            }
            if (((Boolean)contactCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.contactCreationTemplateCategoryId, new String[]{"contact", "creation"});
            }
            if (((Boolean)contactModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.contactModificationTemplateCategoryId, new String[]{"contact", "modification"});
            }
            if (((Boolean)ouCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.ouCreationTemplateCategoryId, new String[]{"OU", "creation"});
            }
            if (((Boolean)ouModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.ouModificationTemplateCategoryId, new String[]{"OU", "modification"});
            }
            if (((Boolean)dlGroupCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.dlGroupCreationTemplateCategoryId, new String[]{"dlGroup", "creation"});
            }
            if (((Boolean)sharedCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId, new String[]{"shared", "creation"});
            }
            if (((Boolean)sharedModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId, new String[]{"shared", "modification"});
            }
            if (((Boolean)linkedCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId, new String[]{"linked", "creation"});
            }
            if (((Boolean)roomCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId, new String[]{"room", "creation"});
            }
            if (((Boolean)roomModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.roomMailboxModificationTemplateCategoryId, new String[]{"room", "modification"});
            }
            if (((Boolean)equipmentCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId, new String[]{"equipment", "creation"});
            }
            if (((Boolean)equipmentModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.equipmentMailboxModificationTemplateCategoryId, new String[]{"equipment", "modification"});
            }
            Set keys = templateObjVsCategoryId.keySet();
            for (Long templateCategoryId : keys) {
                String[] templateCategory = (String[])templateObjVsCategoryId.get(templateCategoryId);
                JSONObject templatesObj = new JSONObject();
                templatesObj = objectClass.equalsIgnoreCase("Group") ? FcTemplateAuthorization.getAuthorizedLayouts((Long)id, (Long)templateCategoryId, (AdventNetResourceBundle)rb, (boolean)true, (String)"FcHDTGroupToAllLayoutMapping", (String)"FcHDTGroupToLayoutMapping", (String)"GROUP_ID", (ArrayList)configuredDomains) : FcTemplateAuthorization.getAuthorizedLayouts((Long)id, (Long)templateCategoryId, (AdventNetResourceBundle)rb, (boolean)true, (String)"FcHDTtoAllLayoutMapping", (String)"FcHDTtoLayoutMapping", (String)"LOGIN_ID", (ArrayList)configuredDomains);
                JSONObject layoutsObj = (JSONObject)layoutsJSONObj.get(templateCategory[0]);
                layoutsObj.put(templateCategory[1], (Object)templatesObj);
            }
            return layoutsJSONObj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return templateList;
        }
    }

    public static String updateHelpDeskTechnician(HttpServletRequest request, DynaValidatorForm bean, AdventNetResourceBundle rb) throws Exception {
        String statusMessage = null;
        Long technicianId = (Long)bean.get("loginID");
        String technicianObjectClass = (String)bean.get("objectClass");
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String[] configuredDomains = request.getParameterValues("configuredDomains");
        String[] impersonateAsAdminDomainArray = request.getParameterValues("impersonateAsAdmin");
        ArrayList<Object> impersonateAsAdminDomainList = new ArrayList();
        if (impersonateAsAdminDomainArray != null) {
            impersonateAsAdminDomainList = new ArrayList<String>(Arrays.asList(impersonateAsAdminDomainArray));
        }
        Hashtable adminCredential = new Hashtable();
        if (configuredDomains != null) {
            for (String domain : configuredDomains) {
                String isImpersonate = "false";
                if (impersonateAsAdminDomainList.contains(domain)) {
                    isImpersonate = "true";
                }
                adminCredential.put(domain, isImpersonate);
            }
        } else {
            adminCredential = HelpdeskUtil.getDomainVsCredential((Long)technicianId, (boolean)true);
        }
        String[] configuredWaadAccounts = request.getParameterValues("configuredWaadAccounts");
        Hashtable waadAccountsVsDetails = TechnicianConfig.getWaadAccountsVsDetails(configuredWaadAccounts, request);
        String description = (String)bean.get("description");
        String mail = (String)bean.get("emailAddress");
        statusMessage = rb.getString("admp.deleg.hdt_deleg.cre_hdt.statmsg.success_updated_helpdesk_technician");
        String appendIncludedExcludedGroupOU = request.getParameter("appendIncludedExcludedGroupOU");
        String fileServerListJSONStr = request.getParameter("fileServerList");
        ArrayList<Properties> fileServerPropList = new ArrayList<Properties>();
        Boolean isAllFileServerSelected = false;
        if (fileServerListJSONStr != null && !fileServerListJSONStr.equals("")) {
            JSONObject fileServerListJSON = new JSONObject(fileServerListJSONStr);
            isAllFileServerSelected = fileServerListJSON.has("isAllSelected") ? fileServerListJSON.getBoolean("isAllSelected") : false;
            String fileServerListReqStr = fileServerListJSON.has("fileServerList") ? fileServerListJSON.getString("fileServerList") : "{}";
            String fileServerListStr = new URLCodec().decode(fileServerListReqStr);
            JSONObject fileServerList = new JSONObject(fileServerListStr);
            Iterator fsIt = fileServerList.keys();
            while (fsIt.hasNext()) {
                String fsGuid = (String)fsIt.next();
                String fsName = fileServerList.getString(fsGuid);
                Properties fsProp = new Properties();
                fsProp.put("OBJECT_GUID", fsGuid);
                fsProp.put("NAME", fsName);
                fileServerPropList.add(fsProp);
            }
        }
        HashMap includeGroupsMap = new HashMap();
        if (bean.get("includeGroupsMap") != null) {
            includeGroupsMap = (HashMap)bean.get("includeGroupsMap");
        }
        HashMap excludeGroupsMap = new HashMap();
        if (bean.get("excludeGroupsMap") != null) {
            excludeGroupsMap = (HashMap)bean.get("excludeGroupsMap");
        }
        appendIncludedExcludedGroupOU = appendIncludedExcludedGroupOU != null ? "true" : "false";
        Properties technicianDefaultTemplates = new Properties();
        String layoutDetailsList = (String)bean.get("templateList");
        String domainName = (String)bean.get("domainName");
        Hashtable domainVsRoleId = TechnicianConfig.getDomainVsRoleId(domainName, request);
        Long accountId = TechnicianHandler.getAccountId((Long)technicianId);
        Long adminRoleId = AuthUtil.getRoleId((String)"Administrator");
        Long sdpRoleId = AuthUtil.getRoleId((String)"SdpUser");
        if (TechnicianHandler.hasTechRoleIds((Hashtable)domainVsRoleId) && TechnicianHandler.hasAAAAuthorizedId((Long)accountId, (Long)sdpRoleId).booleanValue()) {
            TechnicianHandler.checkLicenseRestriction((AdventNetResourceBundle)rb);
        } else if (!TechnicianHandler.hasTechRoleIds((Hashtable)domainVsRoleId) && TechnicianHandler.hasAAAAuthorizedId((Long)accountId, (Long)adminRoleId).booleanValue()) {
            TechnicianHandler.checkSDPLicenseRestriction((AdventNetResourceBundle)rb);
        }
        Hashtable domainVsOUList = (Hashtable)bean.get("domainOUList");
        String excludeFromADMPGroup = (String)bean.get("excludeFromADMPGroup");
        if (!technicianId.equals(DelegationUtil.ADMIN_LOGIN_ID)) {
            logger.log(Level.FINE, "Update the user for the loginId : " + technicianId + " roles " + domainVsRoleId + " admincredentails : " + adminCredential + " append group:" + appendIncludedExcludedGroupOU);
            TechnicianHandler.updateHelpDeskTechnician((Long)technicianId, (String)description, (String)mail, (Hashtable)domainVsRoleId, (Hashtable)domainVsOUList, (String)layoutDetailsList, (Hashtable)adminCredential, (String)appendIncludedExcludedGroupOU, (HashMap)includeGroupsMap, (HashMap)excludeGroupsMap, (String[])configuredDomains, (Boolean)isAllFileServerSelected, fileServerPropList, (Hashtable)waadAccountsVsDetails, (Long)sessionLoginId, (AdventNetResourceBundle)rb, (String)"EDIT_TECHNICIAN", (String)excludeFromADMPGroup);
        } else {
            logger.log(Level.INFO, "Trying to update the default admin configuration for the sessionlogin id: " + sessionLoginId + " Technician Id " + technicianId);
            statusMessage = DWRUtil.getMessageString((String)"admp.deleg.hdt_deleg.mod_hdt.alert_mandatory_user_account_cant_modified_deleted", (String)"", (Locale)locale);
        }
        logger.log(Level.INFO, "Status message for the update technician (login id :" + technicianId + " ) is : " + statusMessage);
        return statusMessage;
    }

    public static String updateADMPGroup(HttpServletRequest request, DynaValidatorForm bean, AdventNetResourceBundle rb) throws Exception {
        String statusMessage = null;
        Long groupID = (Long)bean.get("loginID");
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String[] configuredDomains = request.getParameterValues("configuredDomains");
        String description = (String)bean.get("description");
        String appendIncludedExcludedGroupOU = request.getParameter("appendIncludedExcludedGroupOU");
        appendIncludedExcludedGroupOU = appendIncludedExcludedGroupOU != null ? "true" : "false";
        statusMessage = rb.getString("admp.deleg.hdt_deleg.cre_hdt.statmsg.success_updated_helpdesk_technician");
        String[] impersonateAsAdminDomainArray = request.getParameterValues("impersonateAsAdmin");
        ArrayList<Object> impersonateAsAdminDomainList = new ArrayList();
        if (impersonateAsAdminDomainArray != null) {
            impersonateAsAdminDomainList = new ArrayList<String>(Arrays.asList(impersonateAsAdminDomainArray));
        }
        Hashtable adminCredential = new Hashtable();
        if (configuredDomains != null) {
            for (String domain : configuredDomains) {
                String isImpersonate = "false";
                if (impersonateAsAdminDomainList.contains(domain)) {
                    isImpersonate = "true";
                }
                adminCredential.put(domain, isImpersonate);
            }
        } else {
            adminCredential = ADMPGroupDelegationUtil.getCredentialForGroup((Long)groupID);
        }
        String[] configuredWaadAccounts = request.getParameterValues("configuredWaadAccounts");
        Hashtable waadAccountsVsDetails = TechnicianConfig.getWaadAccountsVsDetails(configuredWaadAccounts, request);
        HashMap includeGroupsMap = new HashMap();
        if (bean.get("includeGroupsMap") != null) {
            includeGroupsMap = (HashMap)bean.get("includeGroupsMap");
        }
        HashMap excludeGroupsMap = new HashMap();
        if (bean.get("excludeGroupsMap") != null) {
            excludeGroupsMap = (HashMap)bean.get("excludeGroupsMap");
        }
        Properties technicianDefaultTemplates = new Properties();
        String templateIdArray = request.getParameter("technicianTemplateIDs");
        String layoutDetailsList = (String)bean.get("templateList");
        String domainName = (String)bean.get("domainName");
        Hashtable domainVsRoleId = TechnicianConfig.getDomainVsRoleId(domainName, request);
        Hashtable domainVsOUList = (Hashtable)bean.get("domainOUList");
        String fileServerListJSONStr = request.getParameter("fileServerList");
        JSONObject fileServerListJSON = new JSONObject(fileServerListJSONStr);
        Boolean isAllFileServerSelected = fileServerListJSON.has("isAllSelected") ? fileServerListJSON.getBoolean("isAllSelected") : false;
        String fileServerListReqStr = fileServerListJSON.has("fileServerList") ? fileServerListJSON.getString("fileServerList") : "{}";
        String fileServerListStr = new URLCodec().decode(fileServerListReqStr);
        JSONObject fileServerList = new JSONObject(fileServerListStr);
        ArrayList<Properties> fileServerPropList = new ArrayList<Properties>();
        Iterator fsIt = fileServerList.keys();
        while (fsIt.hasNext()) {
            String fsGuid = (String)fsIt.next();
            String fsName = fileServerList.getString(fsGuid);
            Properties fsProp = new Properties();
            fsProp.put("OBJECT_GUID", fsGuid);
            fsProp.put("NAME", fsName);
            fileServerPropList.add(fsProp);
        }
        logger.log(Level.FINE, "Update the user for the loginId : " + groupID + " roles " + domainVsRoleId + " admincredentails : " + adminCredential);
        TechnicianGroupHandler.updateADMPGroup((Long)groupID, (String)description, (Hashtable)domainVsRoleId, (Hashtable)domainVsOUList, (String)layoutDetailsList, (Hashtable)adminCredential, (String)appendIncludedExcludedGroupOU, (HashMap)includeGroupsMap, (HashMap)excludeGroupsMap, (String[])configuredDomains, (Boolean)isAllFileServerSelected, fileServerPropList, (Hashtable)waadAccountsVsDetails, (Long)sessionLoginId, (AdventNetResourceBundle)rb, (String)"EDIT_TECHNICIAN");
        logger.log(Level.INFO, "Status message for the update technician (login id :" + groupID + " ) is : " + statusMessage);
        return statusMessage;
    }

    public static String getFirstLayoutName(String templateList, AdventNetResourceBundle rb, Long loginId, String[] configuredDomains, String objectClass) {
        try {
            JSONObject layoutsJSONObj = new JSONObject(templateList);
            JSONObject userLayoutsObj = (JSONObject)layoutsJSONObj.get("user");
            JSONObject userCreationTemplatesObj = (JSONObject)userLayoutsObj.get("creation");
            JSONObject userModificationTemplatesObj = (JSONObject)userLayoutsObj.get("modification");
            JSONObject groupLayoutsObj = (JSONObject)layoutsJSONObj.get("group");
            JSONObject groupCreationTemplatesObj = (JSONObject)groupLayoutsObj.get("creation");
            JSONObject groupModificationTemplatesObj = (JSONObject)groupLayoutsObj.get("modification");
            JSONObject computerLayoutsObj = (JSONObject)layoutsJSONObj.get("computer");
            JSONObject computerCreationTemplatesObj = (JSONObject)computerLayoutsObj.get("creation");
            JSONObject contactLayoutsObj = (JSONObject)layoutsJSONObj.get("contact");
            JSONObject contactCreationTemplatesObj = (JSONObject)contactLayoutsObj.get("creation");
            JSONObject contactModificationTemplatesObj = (JSONObject)contactLayoutsObj.get("modification");
            JSONObject ouLayoutsObj = (JSONObject)layoutsJSONObj.get("OU");
            JSONObject ouCreationTemplatesObj = (JSONObject)ouLayoutsObj.get("creation");
            JSONObject ouModificationTemplatesObj = (JSONObject)ouLayoutsObj.get("modification");
            JSONObject dlGroupLayoutsObj = (JSONObject)layoutsJSONObj.get("dlGroup");
            JSONObject dlGroupCreationTemplatesObj = (JSONObject)dlGroupLayoutsObj.get("creation");
            JSONObject sharedLayoutsObj = (JSONObject)layoutsJSONObj.get("shared");
            JSONObject sharedCreationTemplatesObj = (JSONObject)sharedLayoutsObj.get("creation");
            JSONObject sharedModificationTemplatesObj = (JSONObject)sharedLayoutsObj.get("modification");
            JSONObject linkedLayoutsObj = (JSONObject)layoutsJSONObj.get("linked");
            JSONObject linkedCreationTemplatesObj = (JSONObject)linkedLayoutsObj.get("creation");
            JSONObject roomLayoutsObj = (JSONObject)layoutsJSONObj.get("room");
            JSONObject roomCreationTemplatesObj = (JSONObject)roomLayoutsObj.get("creation");
            JSONObject roomModificationTemplatesObj = (JSONObject)roomLayoutsObj.get("modification");
            JSONObject equipmentLayoutsObj = (JSONObject)layoutsJSONObj.get("equipment");
            JSONObject equipmentCreationTemplatesObj = (JSONObject)equipmentLayoutsObj.get("creation");
            JSONObject equipmentModificationTemplatesObj = (JSONObject)equipmentLayoutsObj.get("modification");
            Hashtable<Long, JSONObject> templateObjVsCategoryId = new Hashtable<Long, JSONObject>();
            if (!((Boolean)userCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.userCreationTemplateCategoryId, userCreationTemplatesObj);
            }
            if (!((Boolean)userModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.userModificationTemplateCategoryId, userModificationTemplatesObj);
            }
            if (!((Boolean)groupCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.groupCreationTemplateCategoryId, groupCreationTemplatesObj);
            }
            if (!((Boolean)groupModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.groupModificationTemplateCategoryId, groupModificationTemplatesObj);
            }
            if (!((Boolean)computerCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.computerCreationTemplateCategoryId, computerCreationTemplatesObj);
            }
            if (!((Boolean)contactCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.contactCreationTemplateCategoryId, contactCreationTemplatesObj);
            }
            if (!((Boolean)contactModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.contactModificationTemplateCategoryId, contactModificationTemplatesObj);
            }
            if (!((Boolean)ouCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.ouCreationTemplateCategoryId, ouCreationTemplatesObj);
            }
            if (!((Boolean)ouModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.ouModificationTemplateCategoryId, ouModificationTemplatesObj);
            }
            if (!((Boolean)dlGroupCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.dlGroupCreationTemplateCategoryId, dlGroupCreationTemplatesObj);
            }
            if (!((Boolean)sharedCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId, sharedCreationTemplatesObj);
            }
            if (!((Boolean)sharedModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId, sharedModificationTemplatesObj);
            }
            if (!((Boolean)linkedCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId, linkedCreationTemplatesObj);
            }
            if (!((Boolean)roomCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId, roomCreationTemplatesObj);
            }
            if (!((Boolean)roomModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.roomMailboxModificationTemplateCategoryId, roomModificationTemplatesObj);
            }
            if (!((Boolean)equipmentCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId, equipmentCreationTemplatesObj);
            }
            if (!((Boolean)equipmentModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.equipmentMailboxModificationTemplateCategoryId, equipmentModificationTemplatesObj);
            }
            Set keys = templateObjVsCategoryId.keySet();
            for (Long templateCategoryId : keys) {
                JSONObject layoutDetailsObj = (JSONObject)templateObjVsCategoryId.get(templateCategoryId);
                ArrayList layoutList = FcTemplateAuthorization.getLayoutsForHDT((Long)templateCategoryId, (Long)DelegationUtil.ADMIN_LOGIN_ID, (String[])configuredDomains, (String)"", (String)"FcHDTtoAllLayoutMapping", (String)"FcHDTtoLayoutMapping", (String)"LOGIN_ID");
                ArrayList<Long> allLayoutIds = new ArrayList<Long>();
                for (Properties prop : layoutList) {
                    allLayoutIds.add(Long.parseLong(prop.get("LAYOUT_ID").toString()));
                }
                int totalSize = allLayoutIds.size();
                JSONArray jsonLayoutsList = layoutDetailsObj.getJSONArray("layoutList");
                ArrayList<Long> selectedLayoutIds = new ArrayList<Long>();
                for (int i = 0; i < jsonLayoutsList.length(); ++i) {
                    selectedLayoutIds.add(Long.parseLong(jsonLayoutsList.getJSONObject(i).get("layoutId").toString()));
                }
                allLayoutIds.retainAll(selectedLayoutIds);
                int intersectionSize = allLayoutIds.size();
                if (totalSize > selectedLayoutIds.size() || totalSize != intersectionSize) break;
                layoutDetailsObj.put("isAllSelected", true);
            }
            if (!(((Boolean)userCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)userModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)groupCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)groupModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)computerCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)contactCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)contactModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)ouCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)ouModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)dlGroupCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)sharedCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)sharedModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)roomCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)roomModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)equipmentCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)equipmentModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)linkedCreationTemplatesObj.get("isAllSelected")).booleanValue())) {
                JSONObject userTemplateDetailsObj;
                JSONObject templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.userCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                JSONArray userTemplateObj = (JSONArray)templateObj.get("layoutList");
                String firstLayoutName = "";
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.userModificationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.contactCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.contactModificationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.computerCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.groupCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.groupModificationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.dlGroupCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.roomMailboxModificationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.equipmentMailboxModificationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.ouCreationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                templateObj = TechnicianConfig.getAuthorizedLayouts(loginId, FcExecuteActionConstants.ouModificationTemplateCategoryId, rb, true, configuredDomains, objectClass);
                userTemplateObj = (JSONArray)templateObj.get("layoutList");
                if (userTemplateObj.length() > 0 && (userTemplateDetailsObj = (JSONObject)userTemplateObj.get(0)).length() > 0) {
                    firstLayoutName = (String)userTemplateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
                return "-";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rb.getString("admp.common.text.all");
    }

    private static JSONObject getAuthorizedLayouts(Long id, Long templateCategoryId, AdventNetResourceBundle rb, Boolean isLayoutNameRequired, String[] configuredDomains, String objectClass) {
        if (objectClass.equalsIgnoreCase("Group")) {
            return FcLayoutViewHandler.getAuthorizedLayoutsForGroup((Long)id, (Long)templateCategoryId, (AdventNetResourceBundle)rb, (boolean)isLayoutNameRequired, (String[])configuredDomains);
        }
        Boolean isDirectUser = TechnicianDataHandler.isDirectUser((Long)id);
        return FcLayoutViewHandler.getAuthorizedLayouts((Long)id, (Long)templateCategoryId, (AdventNetResourceBundle)rb, (boolean)isLayoutNameRequired, (String[])configuredDomains, (Boolean)isDirectUser);
    }

    private static ArrayList getOUList(DynaValidatorForm bean, HttpServletRequest request) throws Exception {
        ArrayList<String> ouList = new ArrayList<String>();
        Properties properties = null;
        String[] configuredDomains = request.getParameterValues("configuredDomains");
        Hashtable domainVsOUList = (Hashtable)bean.get("domainOUList");
        for (int i = 0; configuredDomains != null && i < configuredDomains.length; ++i) {
            String domainName = configuredDomains[i];
            properties = DomainUtil.getDomainDetails((String)domainName, (String)"DOMAIN_NAME");
            String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            ArrayList domainOUList = (ArrayList)domainVsOUList.get(defaultNamingContext);
            if (domainOUList == null || domainOUList.isEmpty()) continue;
            for (String ouName : domainOUList) {
                ouList.add(ouName);
            }
        }
        return ouList;
    }

    private static Hashtable getDomainVsRoleId(String domainName, HttpServletRequest request) throws Exception {
        Hashtable domainVsRoleId = new Hashtable();
        Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("AddOus");
        String[] configuredDomains = request.getParameterValues("configuredDomains");
        if (errorId.booleanValue()) {
            int i;
            ArrayList<Long> roleidsList = new ArrayList<Long>();
            ArrayList domainNamesList = DomainUtil.getConfiguredDomainNamesList();
            Collections.sort(domainNamesList);
            ArrayList<String> selecteddomainsList = new ArrayList<String>();
            for (i = 0; configuredDomains != null && i < configuredDomains.length; ++i) {
                selecteddomainsList.add(configuredDomains[i]);
            }
            if (domainNamesList != null && domainNamesList.size() > 0) {
                for (i = 0; domainNamesList != null && i < domainNamesList.size(); ++i) {
                    String[] admp_roles;
                    String domain = (String)domainNamesList.get(i);
                    String admp_role = "admp_roles" + domain;
                    if (!selecteddomainsList.contains(domain) || (admp_roles = request.getParameterValues(admp_role)) == null || admp_roles.length <= 0) continue;
                    roleidsList = new ArrayList();
                    for (int j = 0; admp_roles != null && j < admp_roles.length; ++j) {
                        if (roleidsList.contains(Long.parseLong(admp_roles[j]))) continue;
                        roleidsList.add(Long.parseLong(admp_roles[j]));
                    }
                    domainVsRoleId.put(domain, roleidsList);
                }
            }
        } else {
            ArrayList<Long> roleidsList = new ArrayList<Long>();
            String admp_role = "admp_roles" + domainName;
            String[] admp_roles = request.getParameterValues(admp_role);
            if (admp_roles != null) {
                roleidsList = new ArrayList();
                for (int j = 0; admp_roles != null && j < admp_roles.length; ++j) {
                    roleidsList.add(Long.parseLong(admp_roles[j]));
                }
            }
            domainVsRoleId.put(domainName, roleidsList);
        }
        return domainVsRoleId;
    }

    private static Hashtable getWaadAccountsVsDetails(String[] waadAccountsList, HttpServletRequest request) throws Exception {
        boolean applyOURestriction;
        Hashtable accountNameVsDetails = new Hashtable();
        String applyOURestrictionString = request.getParameter("applyOURestriction");
        boolean bl = applyOURestriction = applyOURestrictionString != null;
        if (waadAccountsList == null) {
            waadAccountsList = new String[]{};
        }
        for (String accountName : waadAccountsList) {
            Hashtable<String, Serializable> details = new Hashtable<String, Serializable>();
            String[] domainList = request.getParameterValues(accountName + "domaincheckbox") == null ? new String[]{} : request.getParameterValues(accountName + "domaincheckbox");
            JSONArray waadDomainsList = new JSONArray();
            for (String waadDomain : domainList) {
                waadDomainsList.put((Object)waadDomain);
            }
            String[] accountSkuIds = request.getParameterValues(accountName + "skuids");
            String waadDomId = request.getParameter(accountName + "domainId");
            Long waadDomainId = Long.parseLong(waadDomId);
            String iamAppIdString = request.getParameter(accountName + "iamAppId");
            int iamAppId = Integer.parseInt(iamAppIdString);
            if (accountSkuIds == null) {
                accountSkuIds = new String[]{};
            }
            Hashtable<String, String> accountSkuIdVsServices = new Hashtable<String, String>();
            for (String accountSkuId : accountSkuIds) {
                Integer totalServicesCount = Integer.parseInt(request.getParameter(accountName + accountSkuId + "totalservicecount"));
                String[] selectedServices = request.getParameterValues(accountName + accountSkuId + "service");
                if (selectedServices != null) {
                    if (selectedServices.length == totalServicesCount) {
                        accountSkuIdVsServices.put(accountSkuId, "All Services");
                        continue;
                    }
                    JSONArray servicesJSONArray = new JSONArray();
                    for (String service : selectedServices) {
                        servicesJSONArray.put((Object)service);
                    }
                    accountSkuIdVsServices.put(accountSkuId, servicesJSONArray.toString());
                    continue;
                }
                accountSkuIdVsServices.put(accountSkuId, new JSONArray().toString());
            }
            Integer totalDomainCount = Integer.parseInt(request.getParameter(accountName + "totaldomaincount"));
            details.put("waadDomainId", waadDomainId);
            details.put("iamAppId", Integer.valueOf(iamAppId));
            if (totalDomainCount > 0) {
                details.put("waadDomainList", (Serializable)waadDomainsList);
            }
            details.put("totalDomainCount", totalDomainCount);
            details.put("licenseDetails", accountSkuIdVsServices);
            details.put("applyOURestriction", Boolean.valueOf(applyOURestriction));
            accountNameVsDetails.put(accountName, details);
        }
        return accountNameVsDetails;
    }

    public static void setSelfServiceConfDetails(HttpServletRequest request, AdventNetResourceBundle rb) throws Exception {
        HttpSession session = request.getSession();
        String domainFlatName = null;
        if (request.getParameter("domainFlatName") != null && !request.getParameter("domainFlatName").equals("ALL")) {
            domainFlatName = request.getParameter("domainFlatName");
        }
        ArrayList domainList = HDTDomainHandler.getConfiguredList((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
        Properties p = new Properties();
        p.put("DOMAIN_FLAT_NAME", "ALL");
        domainList.add(p);
        String searchName = null;
        if (request.getParameter("searchName") != null && !request.getParameter("searchName").equals("")) {
            searchName = request.getParameter("searchName");
        }
        Long recordsCount = null;
        String range = "25";
        if (request.getParameter("RANGE") != null) {
            range = request.getParameter("RANGE");
        }
        long startIndex = 1L;
        long endIndex = new Long(range);
        if (request.getParameter("FROM_INDEX") != null) {
            startIndex = new Long(request.getParameter("FROM_INDEX"));
            endIndex = new Long(request.getParameter("TO_INDEX"));
        }
        request.setAttribute("range", (Object)range);
        request.setAttribute("domainList", (Object)domainList);
        request.setAttribute("FROM_INDEX", (Object)new Long(startIndex));
        request.setAttribute("TO_INDEX", (Object)new Long(endIndex));
        ArrayList selfServiceList = TechnicianHandler.getADMPUsers((String)"SelfServiceUser", (String)domainFlatName, (String)searchName);
        recordsCount = new Long(selfServiceList.size());
        if (domainFlatName == null) {
            domainFlatName = "ALL";
        }
        request.setAttribute("ListingDomain", (Object)domainFlatName);
        request.setAttribute("selfServiceList", (Object)selfServiceList);
        request.setAttribute("TOTAL_RECORDS", (Object)recordsCount);
    }
}

