/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation.workflow;

import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.RequesterListener;
import com.adventnet.sym.adsm.common.server.delegation.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.delegation.workflow.RequesterHandler;
import com.adventnet.sym.adsm.common.server.delegation.workflow.RequesterPolicyHandler;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequester;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcTemplateAuthorization;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.delegation.workflow.MyComparator;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPRequesterAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(ADMPRequesterAction.class.getName());

    public ActionForward viewRequestors(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        ArrayList authorizedDomainList = HDTDomainHandler.getDomainNamesList((Long)loginId);
        request.setAttribute("domainName", (Object)((String)authorizedDomainList.get(0)));
        request.setAttribute("domainOUList", new Hashtable());
        request.setAttribute("domainList", (Object)HDTDomainHandler.getDomainsAndOUs((Long)loginId));
        request.setAttribute("rolesList", (Object)RequesterHandler.getADMPRequesterRoles());
        request.setAttribute("RANGE", (Object)NavigateRangeUtil.getDefaultRange((String)"WorkFlowView", (Long)loginId));
        return mapping.findForward("viewADMPRequestors");
    }

    public ActionForward listRequesterRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long cvId = ColumnConfiguration.getCVId((String)"Requesters", (long)loginId);
            if (cvId == null) {
                cvId = ColumnConfiguration.getDefaultCvId((String)"Requesters");
                this.logger.log(Level.INFO, "CustomView ID for this technician " + loginId + "is empty. So getting default view configuration : " + cvId);
            }
            ArrayList viewColumnList = ColumnConfiguration.getViewColumnList((long)cvId);
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            Integer fromIndex = (Integer)json.get("startIndex");
            Integer toIndex = (Integer)json.get("toIndex");
            Integer range = (Integer)json.get("range");
            Boolean isAscending = json.getBoolean("ascending");
            Boolean isNavigation = json.getBoolean("isNavigation");
            Boolean isNewRange = json.getBoolean("isNewRange");
            String sortColumn = (String)json.get("sortColumn");
            JSONObject outputFilters = json.getJSONObject("outputFilters");
            if (isNewRange.booleanValue()) {
                NavigateRangeUtil.setDefaultRange((String)"WorkFlowView", (int)range, (Long)loginId);
            }
            ArrayList totalTechnicianList = RequesterPolicyHandler.getRequestersAndPolicyDetails((JSONObject)json, (ArrayList)viewColumnList);
            Integer totalCount = totalTechnicianList.size();
            List technicianList = new ArrayList();
            Collections.sort(totalTechnicianList, new MyComparator(sortColumn, isAscending));
            technicianList = totalCount > range ? totalTechnicianList.subList(fromIndex - 1, toIndex) : totalTechnicianList;
            request.setAttribute("totalCount", (Object)totalCount);
            request.setAttribute("viewColumnList", (Object)viewColumnList);
            request.setAttribute("usersList", (Object)technicianList);
            request.setAttribute("searchText", (Object)((String)json.get("searchText")));
            request.setAttribute("sortOrder", (Object)(isAscending == false ? 1 : 0));
            request.setAttribute("sortColumn", (Object)sortColumn);
            request.setAttribute("isNavigation", (Object)isNavigation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("ListRequestorsRows");
    }

    public ActionForward getOutputFilters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            JSONArray filtersList = WFRequesterUtil.getOutputFilterJsonArray((AdventNetResourceBundle)rb);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("outputFilters", (Object)filtersList);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward addRequester(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String defaultNamingContext = (String)json.get("domainName");
        Properties domainproperties = DomainUtil.getDomainDetails((String)defaultNamingContext, (String)"DEFAULT_NAMING_CONTEXT");
        String domainName = domainproperties.getProperty("DOMAIN_NAME");
        String selectedRequesterlist = request.getParameter("selectedlist");
        JSONObject selectedListJson = new JSONObject(selectedRequesterlist);
        Hashtable hash = RequesterHandler.getTechnicianListenerDetails((String)"Requester");
        String className = "";
        String statusMessage = null;
        ArrayList statusList = new ArrayList();
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
            if (!errorId.booleanValue()) {
                statusMessage = LicenseMgr.getInstance().getlicenseMessage("Workflow", rb);
                request.setAttribute("statusMessage", (Object)statusMessage);
                return mapping.findForward("ShowSuccessStatus");
            }
            Iterator itr = selectedListJson.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                Properties prop = (Properties)hash.get(key);
                className = prop.getProperty("className");
                JSONObject guidListJson = (JSONObject)selectedListJson.get(key);
                Class<?> dataProviderClass = Class.forName(className);
                RequesterListener listener = (RequesterListener)dataProviderClass.newInstance();
                ArrayList errormsglist = listener.addNewObject(request, json, guidListJson, key);
                statusList.addAll(errormsglist);
            }
            String successStatus = WFRequesterUtil.isAllSuccessFull(statusList);
            statusMessage = successStatus.equals("AllSuccess") ? rb.getString("admp.workflow.requesters.add_requester_msg.successfully_added") : (successStatus.equals("AllFailed") ? rb.getString("admp.workflow.requesters.add_requester_msg.Failed") : rb.getString("admp.workflow.requesters.add_requester_msg.partial_successfully_added"));
            this.logger.log(Level.INFO, "Status message for add new technician is " + statusMessage + " LoginId for newly created technician : " + statusList);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.INFO, "Exception occurs while adding new technician");
            statusMessage = e.getMessage();
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("statusList", statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward associateTechToRequester(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String selectedRequesterlist = request.getParameter("selectedlist");
        JSONObject selectedListJson = new JSONObject(selectedRequesterlist);
        String statusMessage = null;
        ArrayList statusList = new ArrayList();
        try {
            Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
            if (!errorId.booleanValue()) {
                statusMessage = LicenseMgr.getInstance().getlicenseMessage("Workflow", rb);
                request.setAttribute("statusMessage", (Object)statusMessage);
                return mapping.findForward("ShowSuccessStatus");
            }
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            statusList = WFRequester.associateTechToRequester((HttpServletRequest)request, (JSONObject)json, (JSONObject)selectedListJson);
            String successStatus = WFRequesterUtil.isAllSuccessFull((ArrayList)statusList);
            statusMessage = successStatus.equals("AllSuccess") ? rb.getString("admp.workflow.requesters.add_requester_msg.successfully_added") : (successStatus.equals("AllFailed") ? rb.getString("admp.workflow.requesters.add_requester_msg.Failed") : rb.getString("admp.workflow.requesters.add_requester_msg.partial_successfully_added"));
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Exception occurs while adding new technician");
            e.printStackTrace();
            String message = e.getMessage();
            if (message != null) {
                this.logger.log(Level.SEVERE, "!! Error in Adding User :" + message);
                if (!message.startsWith("License")) {
                    message = MessageFormat.format(rb.getString("admp.workflow.requesters.add_requester_msg.Failed"), rb.getString(message));
                }
            }
            request.setAttribute("statusMessage", (Object)message);
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("statusList", (Object)statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward deleteAccount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<Properties> statusList;
        String statusMessage;
        block10: {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            statusMessage = null;
            statusList = new ArrayList<Properties>();
            try {
                if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                String params = request.getParameter("params");
                JSONObject json = new JSONObject(params);
                Hashtable hash = RequesterHandler.getTechnicianListenerDetails((String)"Requester");
                Iterator itr = json.keys();
                while (itr.hasNext()) {
                    String classType = (String)itr.next();
                    JSONArray uniqueIdArray = json.getJSONArray(classType);
                    for (int index = 0; index < uniqueIdArray.length(); ++index) {
                        String key = (String)uniqueIdArray.get(index);
                        Properties prop = (Properties)hash.get(classType);
                        String className = prop.getProperty("className");
                        String tableName = prop.getProperty("baseTableName");
                        Class<?> dataProviderClass = Class.forName(className);
                        RequesterListener listener = (RequesterListener)dataProviderClass.newInstance();
                        Hashtable accountDetailsHash = listener.modifyTechnician(request, new Long(key), classType, tableName);
                        String domainName = (String)accountDetailsHash.get("DOMAIN_NAME");
                        String name = (String)accountDetailsHash.get("NAME");
                        Boolean isSuccess = false;
                        if (domainName.equals("ADManager Plus Authentication") && ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue() && !key.equals("1")) {
                            isSuccess = listener.delete(new Long(key));
                        } else if (ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                            isSuccess = listener.delete(new Long(key));
                        }
                        Properties statusprop = new Properties();
                        statusprop.setProperty("Name", name);
                        statusprop.put("isSuccess", isSuccess);
                        statusprop.setProperty("Type", classType);
                        if (isSuccess.booleanValue()) {
                            statusprop.setProperty("statusMessage", rb.getString("client.admin.CustomTitles.successfully_removed"));
                        } else {
                            statusprop.setProperty("statusMessage", rb.getString("admp.mgmt.common.statmsg.access_denied"));
                        }
                        statusList.add(statusprop);
                    }
                }
                String successStatus = WFRequesterUtil.isAllSuccessFull(statusList);
                statusMessage = successStatus.equals("AllSuccess") ? rb.getString("admp.workflow.requesters.delete_requester_msg.successfully_removed") : (successStatus.equals("AllFailed") ? rb.getString("admp.workflow.requesters.delete_requester_msg.access_denied") : rb.getString("admp.workflow.requesters.delete_requester_msg.partial_successfully_removed"));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception occurs while updating the account status");
                e.printStackTrace();
                String message = e.getMessage();
                if (message == null) break block10;
                this.logger.log(Level.SEVERE, "!! Error in Adding User :" + message);
                if (message.startsWith("License")) break block10;
                statusMessage = MessageFormat.format(rb.getString("admp.workflow.requesters.add_requester_msg.Failed"), rb.getString(message));
            }
        }
        request.setAttribute("statusMessage", statusMessage);
        request.setAttribute("statusList", statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward updateAccountStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<Properties> statusList;
        String statusMessage;
        block16: {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            statusMessage = "";
            String operationTxt = "";
            statusList = new ArrayList<Properties>();
            try {
                if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                String operation = request.getParameter("operation");
                statusMessage = operation.equals("enable") ? rb.getString("admp.admin.custom_settgs.common.statmsg.success_enabled") : rb.getString("admp.admin.custom_settgs.common.statmsg.success_disabled");
                String params = request.getParameter("params");
                JSONObject json = new JSONObject(params);
                System.out.println("json params " + params);
                Hashtable hash = RequesterHandler.getTechnicianListenerDetails((String)"Requester");
                Iterator itr = json.keys();
                while (itr.hasNext()) {
                    String classType = (String)itr.next();
                    JSONArray uniqueIdArray = json.getJSONArray(classType);
                    for (int index = 0; index < uniqueIdArray.length(); ++index) {
                        String key = (String)uniqueIdArray.get(index);
                        Properties prop = (Properties)hash.get(classType);
                        String className = prop.getProperty("className");
                        String tableName = prop.getProperty("baseTableName");
                        Class<?> dataProviderClass = Class.forName(className);
                        RequesterListener listener = (RequesterListener)dataProviderClass.newInstance();
                        Hashtable accountDetailsHash = listener.modifyTechnician(request, new Long(key), classType, tableName);
                        String domainName = (String)accountDetailsHash.get("DOMAIN_NAME");
                        String name = (String)accountDetailsHash.get("NAME");
                        Boolean isSuccess = false;
                        Boolean isAuthorized = false;
                        if (domainName.equals("ADManager Plus Authentication") && ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue() && !key.equals("1")) {
                            isAuthorized = true;
                        } else if (ClientAuthorizationUtil.isAuthorized(request, domainName, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                            isAuthorized = true;
                        }
                        if (isAuthorized.booleanValue()) {
                            String successStatus = new String();
                            try {
                                if (classType.equals("User") && operation.equals("enable") && !RequesterHandler.isEnabledRequester((Long)Long.parseLong(key))) {
                                    if (LicenseMgr.getInstance().isWorkflowRequesterModuleLicensed() || !TechnicianHandler.isEnabledHDT((String)key)) {
                                        RequesterHandler.checkLicenseRestriction((AdventNetResourceBundle)rb);
                                    }
                                    successStatus = listener.changeStatus(key, operation);
                                } else {
                                    System.out.println("Going to disable ");
                                    successStatus = listener.changeStatus(key, operation);
                                }
                            }
                            catch (Exception e) {
                                String message = e.getMessage();
                                System.out.println("Catch block " + message);
                                if (message == null) continue;
                                Properties statusprop = new Properties();
                                statusprop.setProperty("Name", name);
                                statusprop.put("isSuccess", isSuccess);
                                statusprop.setProperty("Type", classType);
                                statusprop.setProperty("statusMessage", message);
                                statusList.add(statusprop);
                                continue;
                            }
                            isSuccess = Boolean.parseBoolean(successStatus);
                        }
                        Properties statusprop = new Properties();
                        statusprop.setProperty("Name", name);
                        statusprop.put("isSuccess", isSuccess);
                        statusprop.setProperty("Type", classType);
                        if (isSuccess.booleanValue()) {
                            statusprop.setProperty("statusMessage", statusMessage);
                        } else {
                            statusprop.setProperty("statusMessage", rb.getString("admp.mgmt.common.statmsg.access_denied"));
                        }
                        statusList.add(statusprop);
                    }
                }
                String successStatus = WFRequesterUtil.isAllSuccessFull(statusList);
                statusMessage = successStatus.equals("AllSuccess") ? (operation.equals("enable") ? rb.getString("admp.workflow.requesters.delete_requester_msg.successfully_enable") : rb.getString("admp.workflow.requesters.delete_requester_msg.successfully_disable")) : (successStatus.equals("AllFailed") ? (operation.equals("enable") ? rb.getString("admp.workflow.requesters.status_requester_msg.error_successfully_enable") : rb.getString("admp.workflow.requesters.status_requester_msg.error_successfully_disable")) : (operation.equals("enable") ? rb.getString("admp.workflow.requesters.delete_requester_msg.partial_successfully_enable") : rb.getString("admp.workflow.requesters.delete_requester_msg.partial_successfully_disable")));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Exception occurs while updating the account status");
                e.printStackTrace();
                String message = e.getMessage();
                if (message == null) break block16;
                this.logger.log(Level.SEVERE, "!! Error in Adding User :" + message);
                if (message.startsWith("License")) break block16;
                message = MessageFormat.format(rb.getString("admp.workflow.requesters.add_requester_msg.Failed"), rb.getString(message));
            }
        }
        request.setAttribute("statusMessage", (Object)statusMessage);
        request.setAttribute("statusList", statusList);
        return mapping.findForward("ShowSuccessStatus");
    }

    public ActionForward updateRequester(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String statusMessage;
        block8: {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            statusMessage = null;
            Long loginID = new Long(request.getParameter("loginID"));
            String classType = request.getParameter("classType");
            String params = request.getParameter("params");
            JSONObject requestJson = new JSONObject(params);
            Long sessionLoginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Hashtable listenerHash = RequesterHandler.getTechnicianListenerDetails((String)"Requester");
            try {
                if (!sessionLoginId.equals(DelegationUtil.ADMIN_LOGIN_ID) && !ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                ArrayList<String> authorizedDomainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, DelegationUtil.WF_CONFIG_ACTION_ID);
                String[] authDomainList = new String[authorizedDomainList.size()];
                int i = 0;
                for (String s : authorizedDomainList) {
                    authDomainList[i++] = s;
                }
                Properties prop = (Properties)listenerHash.get(classType);
                String className = prop.getProperty("className");
                Class<?> dataProviderClass = Class.forName(className);
                RequesterListener listener = (RequesterListener)dataProviderClass.newInstance();
                Boolean isSuccess = listener.updateValues(loginID, requestJson, authDomainList);
                statusMessage = "admp.workflow.requester.update.updatesuccess" + isSuccess.toString();
            }
            catch (LocalizedException le) {
                String message = le.getMessage(rb);
                if (message != null) {
                    this.logger.log(Level.SEVERE, "!! Error in Adding User :" + message);
                    if (!message.startsWith("License")) {
                        message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_user"), rb.getString(message));
                    }
                    request.setAttribute("ErrorMessage", (Object)message);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = e.getMessage();
                if (message == null) break block8;
                this.logger.log(Level.SEVERE, "!! Error in Adding User :" + message);
                if (!message.startsWith("License")) {
                    message = MessageFormat.format(rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_user"), rb.getString(message));
                }
                request.setAttribute("ErrorMessage", (Object)message);
            }
        }
        request.setAttribute("statusMessage", statusMessage);
        AjaxUtil.writeResponse(response, "Success");
        return null;
    }

    public ActionForward editRequester(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String statusMessage = new String();
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        Long loginID = new Long(request.getParameter("loginID"));
        String classType = request.getParameter("classType");
        Hashtable listenerHash = RequesterHandler.getTechnicianListenerDetails((String)"Requester");
        System.out.println("LoginId " + loginID + "classType" + classType);
        try {
            if (loginID != null) {
                Properties prop = (Properties)listenerHash.get(classType);
                String className = prop.getProperty("className");
                String tableName = prop.getProperty("baseTableName");
                Class<?> dataProviderClass = Class.forName(className);
                RequesterListener listener = (RequesterListener)dataProviderClass.newInstance();
                Hashtable hash = listener.modifyTechnician(request, loginID, classType, tableName);
                Properties properties = null;
                ArrayList configuredDomainList = (ArrayList)hash.get("ADMP_CONFIGURED_DOMAINS");
                Hashtable ouDetails = (Hashtable)hash.get("ADMP_OU_DETAILS");
                Hashtable<String, ArrayList> domainVsOUList = new Hashtable<String, ArrayList>();
                Hashtable isExcludeChildOUDetails = (Hashtable)hash.get("ADMP_ISEXCLUDECHILDOU_DETAILS");
                Hashtable domainVsIsExcludeChildOUList = new Hashtable();
                String[] configuredDomains = new String[configuredDomainList.size()];
                HttpSession session = request.getSession();
                int i = 0;
                for (String domain : configuredDomainList) {
                    properties = DomainUtil.getDomainDetails((String)domain, (String)"DOMAIN_NAME");
                    String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                    ArrayList domainOuDetails = (ArrayList)ouDetails.get(domain);
                    domainVsOUList.put(defaultNamingContext, domainOuDetails);
                    domainVsIsExcludeChildOUList.put(defaultNamingContext, isExcludeChildOUDetails.get(domain));
                    configuredDomains[i] = domain;
                    ++i;
                }
                String domainName = (String)hash.get("DOMAIN_NAME");
                Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("AddOus");
                if (!errorId.booleanValue() && domainName.equalsIgnoreCase("ADManager Plus Authentication")) {
                    domainName = DomainUtil.getDefaultDomain();
                }
                Hashtable domainAndOuList = HDTDomainHandler.getDomainsAndOUs((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
                request.setAttribute("description", (Object)rb.getString((String)hash.get("DESCRIPTION")));
                request.setAttribute("configuredDomains", (Object)configuredDomains);
                request.setAttribute("domainName", (Object)domainName);
                request.setAttribute("userNameString", hash.get("NAME"));
                request.setAttribute("userDN", hash.get("NAME"));
                request.setAttribute("emailID", hash.get("emailID"));
                request.setAttribute("objectClass", (Object)classType);
                request.setAttribute("domainOUList", domainVsOUList);
                request.setAttribute("domainVsIsExcludeChildOUList", domainVsIsExcludeChildOUList);
                request.setAttribute("domainVsRoleID", hash.get("DOMAIN_ROLE_ID"));
                request.setAttribute("UserDomainName", hash.get("DOMAIN_NAME"));
                request.setAttribute("templateList", (Object)((String)hash.get("ADMP_TEMPLATE_DETAILS")));
                request.setAttribute("rolesList", (Object)RequesterHandler.getADMPRequesterRoles());
                request.setAttribute("domainList", (Object)domainAndOuList);
                request.setAttribute("fileServerListHash", hash.get("fileServerListHash"));
                Hashtable<String, String> domainVsFirstLayoutName = new Hashtable<String, String>();
                ArrayList allDomains = HDTDomainHandler.getDomainNamesList((Long)DelegationUtil.ADMIN_LOGIN_ID);
                for (String domain : allDomains) {
                    String firstLayoutName = ADMPRequesterAction.getFirstLayoutName((String)hash.get("ADMP_TEMPLATE_DETAILS"), rb, new String[]{domain});
                    domainVsFirstLayoutName.put(domain, firstLayoutName);
                }
                request.setAttribute("firstLayoutName", domainVsFirstLayoutName);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mapping.findForward("editRequester");
    }

    public static String getFirstLayoutName(String templateList, AdventNetResourceBundle rb, String[] configuredDomains) {
        try {
            JSONObject layoutsJSONObj = new JSONObject(templateList);
            JSONObject userLayoutsObj = (JSONObject)layoutsJSONObj.get("user");
            JSONObject userCreationTemplatesObj = (JSONObject)userLayoutsObj.get("creation");
            JSONObject userModificationTemplatesObj = (JSONObject)userLayoutsObj.get("modification");
            JSONObject groupLayoutsObj = (JSONObject)layoutsJSONObj.get("group");
            JSONObject groupCreationTemplatesObj = (JSONObject)groupLayoutsObj.get("creation");
            JSONObject contactLayoutsObj = (JSONObject)layoutsJSONObj.get("contact");
            JSONObject contactCreationTemplatesObj = (JSONObject)contactLayoutsObj.get("creation");
            Hashtable<Long, JSONObject> templateObjVsCategoryId = new Hashtable<Long, JSONObject>();
            if (!((Boolean)userCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.userCreationTemplateCategoryId, userCreationTemplatesObj);
            }
            if (!((Boolean)userModificationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.userModificationTemplateCategoryId, userModificationTemplatesObj);
            }
            if (!((Boolean)groupCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.groupCreationTemplateCategoryId, groupCreationTemplatesObj);
            }
            if (!((Boolean)contactCreationTemplatesObj.get("isAllSelected")).booleanValue()) {
                templateObjVsCategoryId.put(FcExecuteActionConstants.contactCreationTemplateCategoryId, contactCreationTemplatesObj);
            }
            Set keys = templateObjVsCategoryId.keySet();
            for (Long templateCategoryId : keys) {
                JSONObject layoutDetailsObj = (JSONObject)templateObjVsCategoryId.get(templateCategoryId);
                ArrayList layoutList = FcTemplateAuthorization.getLayoutsForHDT((Long)templateCategoryId, (Long)DelegationUtil.ADMIN_LOGIN_ID, (String[])configuredDomains, (String)"", (String)"FcHDTtoAllLayoutMapping", (String)"FcHDTtoLayoutMapping", (String)"LOGIN_ID");
                ArrayList<Long> allLayoutIds = new ArrayList<Long>();
                for (Properties prop : layoutList) {
                    allLayoutIds.add(Long.parseLong(prop.get("LAYOUT_ID").toString()));
                }
                int totalSize = allLayoutIds.size();
                JSONArray jsonLayoutsList = layoutDetailsObj.getJSONArray("layoutList");
                ArrayList<Long> selectedLayoutIds = new ArrayList<Long>();
                for (int i = 0; i < jsonLayoutsList.length(); ++i) {
                    selectedLayoutIds.add(Long.parseLong(jsonLayoutsList.getJSONObject(i).get("layoutId").toString()));
                }
                allLayoutIds.retainAll(selectedLayoutIds);
                int intersectionSize = allLayoutIds.size();
                if (totalSize > selectedLayoutIds.size() || totalSize != intersectionSize) break;
                layoutDetailsObj.put("isAllSelected", true);
            }
            if (!(((Boolean)userCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)userModificationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)groupCreationTemplatesObj.get("isAllSelected")).booleanValue() && ((Boolean)contactCreationTemplatesObj.get("isAllSelected")).booleanValue())) {
                String firstLayoutName = "";
                firstLayoutName = ADMPRequesterAction.getFirstLayoutNameForTemplateCategory(userCreationTemplatesObj, FcExecuteActionConstants.userCreationTemplateCategoryId, configuredDomains);
                if (firstLayoutName.equals("")) {
                    firstLayoutName = ADMPRequesterAction.getFirstLayoutNameForTemplateCategory(userModificationTemplatesObj, FcExecuteActionConstants.userModificationTemplateCategoryId, configuredDomains);
                }
                if (firstLayoutName.equals("")) {
                    firstLayoutName = ADMPRequesterAction.getFirstLayoutNameForTemplateCategory(contactCreationTemplatesObj, FcExecuteActionConstants.contactCreationTemplateCategoryId, configuredDomains);
                }
                if (firstLayoutName.equals("")) {
                    firstLayoutName = ADMPRequesterAction.getFirstLayoutNameForTemplateCategory(groupCreationTemplatesObj, FcExecuteActionConstants.groupCreationTemplateCategoryId, configuredDomains);
                }
                if (firstLayoutName.equals("")) {
                    return "-";
                }
                return firstLayoutName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rb.getString("admp.common.text.all");
    }

    public static String getFirstLayoutNameForTemplateCategory(JSONObject templatesObj, Long templateCategoryId, String[] configuredDomains) {
        String firstLayoutName = "";
        try {
            if (((JSONArray)templatesObj.get("layoutList")).length() > 0) {
                ArrayList layoutList = FcTemplateAuthorization.getLayoutsForHDT((Long)templateCategoryId, (Long)DelegationUtil.ADMIN_LOGIN_ID, (String[])configuredDomains, (String)"", (String)"FcHDTtoAllLayoutMapping", (String)"FcHDTtoLayoutMapping", (String)"LOGIN_ID");
                ArrayList<Long> allLayoutIds = new ArrayList<Long>();
                for (Properties prop : layoutList) {
                    allLayoutIds.add(Long.parseLong(prop.get("LAYOUT_ID").toString()));
                }
                JSONArray templateObjArray = (JSONArray)templatesObj.get("layoutList");
                for (int i = 0; i < templateObjArray.length(); ++i) {
                    JSONObject templateDetailsObj = (JSONObject)templateObjArray.get(i);
                    if (templateDetailsObj.length() <= 0 || !allLayoutIds.contains(Long.parseLong(templateDetailsObj.get("layoutId").toString()))) continue;
                    firstLayoutName = (String)templateDetailsObj.get("layoutName");
                    return firstLayoutName;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return firstLayoutName;
    }
}

