/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.delegation.workflow;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.workflow.RequesterRoleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class RequesterRoleAction
extends DispatchAction {
    private Logger logger = Logger.getLogger(RequesterRoleAction.class.getName());

    public ActionForward viewRequestersRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("viewRequesterRoles");
    }

    public ActionForward ShowReqRoleResultRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            ArrayList viewColumnList = RequesterRoleHandler.getViewColumnList();
            List<HashMap<String, Object>> roleList = this.getRolesList(request, json);
            request.setAttribute("searchText", json.get("searchText"));
            request.setAttribute("viewColumnList", (Object)viewColumnList);
            request.setAttribute("roleList", roleList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("RequesterRolesResultRows");
    }

    public ActionForward getSearchCount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = request.getParameter("operation");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (operation.equals("loadRoles")) {
            request.setAttribute("RANGE", (Object)NavigateRangeUtil.getDefaultRange((String)"WorkFlowView", (Long)loginId));
            return mapping.findForward("listRequesterRoles");
        }
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String searchText = (String)json.get("searchText");
        Integer totalCount = RequesterRoleHandler.getRequesterRolesCount((String)searchText);
        AjaxUtil.writeResponse(response, totalCount.toString());
        return null;
    }

    private List<HashMap<String, Object>> getRolesList(HttpServletRequest request, JSONObject json) {
        List rolesList = new ArrayList();
        try {
            Integer startIndex = (Integer)json.get("startIndex");
            Integer range = (Integer)json.get("range");
            Boolean isAscending = (Boolean)json.get("ascending");
            String sortColumn = (String)json.get("sortColumn");
            String searchText = (String)json.get("searchText");
            Integer toIndex = (Integer)json.get("toIndex");
            Boolean isNewRange = json.getBoolean("isNewRange");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (isNewRange.booleanValue()) {
                NavigateRangeUtil.setDefaultRange((String)"WorkFlowView", (int)range, (Long)loginId);
            }
            if ((rolesList = RequesterRoleHandler.getRequesterRolesList((Boolean)isAscending, (String)sortColumn, (String)searchText, (Integer)startIndex, (Integer)range)).size() > range) {
                rolesList = rolesList.subList(startIndex - 1, toIndex);
            }
            request.setAttribute("isAscending", (Object)isAscending);
            request.setAttribute("sortColumn", (Object)sortColumn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rolesList;
    }

    public ActionForward createOrEditRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String operation;
            Long roleID = null;
            if (request.getParameter("roleID") != null && !request.getParameter("roleID").equals("")) {
                roleID = new Long(request.getParameter("roleID"));
                this.logger.log(Level.INFO, "Trying to create new role, so setting roleid to111");
            }
            if ((operation = request.getParameter("operation")).equals("createRole")) {
                this.logger.log(Level.INFO, "Trying to create new role, so setting roleid to 0.");
                request.setAttribute("roleID", (Object)0L);
            } else {
                this.logger.log(Level.INFO, "Trying to change the existing role " + roleID);
                Hashtable hashtable = RequesterRoleHandler.getRoleDetails((Long)roleID);
                request.setAttribute("roleID", (Object)roleID);
                request.setAttribute("ROLE_DETAILS", (Object)hashtable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("createRequesterRole");
    }

    public ActionForward saveRequesterRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = null;
        String statusMsgImage = null;
        Boolean isSuccess = Boolean.FALSE;
        try {
            Long roleID = null;
            if (request.getParameter("roleID") != null && !request.getParameter("roleID").equals("")) {
                roleID = new Long(request.getParameter("roleID"));
            }
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            String roleName = json.getString("roleName");
            String roleDesc = json.getString("roleDesc");
            if (RequesterRoleHandler.isRoleNameUnique((Long)roleID, (String)roleName)) {
                String actionIdList = request.getParameter("actionIdList");
                JSONObject jsonActionIdList = new JSONObject(actionIdList);
                Iterator itr = jsonActionIdList.keys();
                ArrayList<Long> actionList = new ArrayList<Long>();
                while (itr.hasNext()) {
                    actionList.add(jsonActionIdList.getLong((String)itr.next()));
                }
                if (roleID != null && roleID != 0L) {
                    RequesterRoleHandler.updateADMPRole((Long)roleID, (String)roleName, (String)roleDesc, actionList);
                    message = rb.getString("admp.workflow.requester_role.createrequester.update_success");
                    isSuccess = Boolean.TRUE;
                } else {
                    RequesterRoleHandler.saveADMPRole((String)roleName, (String)roleDesc, actionList);
                    message = rb.getString("admp.workflow.requester_role.createrequester.create_success");
                    isSuccess = Boolean.TRUE;
                }
                statusMsgImage = "images/green/info_icon1.gif";
            } else {
                message = rb.getString("admp.workflow.requester_role.createrequester.already_exist");
                statusMsgImage = "images/error_icon.gif";
            }
        }
        catch (DataAccessException e) {
            message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.helpDesk_role_size_exceeds");
            statusMsgImage = "images/error_icon.gif";
        }
        catch (Exception e) {
            message = rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_saving_helpDesk_role");
            e.printStackTrace();
            if (e.getMessage() != null) {
                message = message + ":" + e.getMessage();
            }
            this.logger.log(Level.INFO, "Error while saving the role : " + message);
        }
        request.setAttribute("statusMessage", (Object)message);
        request.setAttribute("isSuccess", (Object)isSuccess);
        request.setAttribute("statusMsgImage", (Object)statusMsgImage);
        return mapping.findForward("showSuccessStatus");
    }

    public ActionForward deleteRequesterRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = null;
        try {
            if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.WF_CONFIG_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            Long roleID = new Long(request.getParameter("roleID"));
            RequesterRoleHandler.deleteRequesterRole((Long)roleID);
            request.setAttribute("statusMessage", (Object)rb.getString("admp.workflow.requester_role.createrequester.delete_success"));
            request.setAttribute("isSuccess", (Object)true);
            request.setAttribute("statusMsgImage", (Object)"images/green/info_icon1.gif");
        }
        catch (Exception exception) {
            request.setAttribute("statusMessage", (Object)rb.getString("admp.workflow.requester_role.createrequester.delete_error"));
            request.setAttribute("isSuccess", (Object)false);
            request.setAttribute("statusMsgImage", (Object)"images/error_icon.gif");
            exception.printStackTrace();
            message = exception.getMessage();
        }
        return mapping.findForward("showSuccessStatus");
    }
}

