/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.export;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;

public class ADMPPdfExporter {
    protected AdventNetResourceBundle rb = null;
    private ArrayList bookMarkParams = null;
    private ArrayList filesList = new ArrayList();
    private boolean tocEnabled = false;
    private int tocPages = 1;
    protected String storageDir = null;
    private Locale locale = null;
    private String password = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToc(JasperPrint print) {
        FileOutputStream out = null;
        try {
            print.setDefaultFont((JRReportFont)((JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(this.getLocale())));
            String fileName = this.storageDir + File.separator + System.currentTimeMillis() + "_toc.pdf";
            out = new FileOutputStream(new File(fileName));
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)out);
            if (this.password != null) {
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)this.password);
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)this.password);
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)Boolean.TRUE);
            }
            exporter.exportReport();
            this.tocPages = print.getPages().size();
            this.filesList.add(0, fileName);
            this.tocEnabled = true;
            this.closeStream(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintList(JasperPrint print) {
        FileOutputStream out = null;
        try {
            String name = print.getName();
            print.setDefaultFont((JRReportFont)((JRDesignReportFont)JRFieldDesignUtil.getPDFExporterFont(this.getLocale())));
            String fileName = this.storageDir + File.separator + CommonUtil.replaceFolderSplChars((String)name) + ".pdf";
            out = new FileOutputStream(new File(fileName));
            JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)out);
            this.filesList.add(fileName);
            this.closeStream(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeStream(out);
        }
    }

    public void setBookMarkParams(ArrayList list) {
        this.bookMarkParams = list;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = I18NUtil.getServerLocale();
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport(OutputStream outputStream) {
        FileOutputStream out = null;
        try {
            if (this.bookMarkParams == null) {
                this.concatPDFs(this.filesList, outputStream, true);
            } else {
                String concatFileName = this.storageDir + File.separator + "concatnated_" + System.currentTimeMillis() + ".pdf";
                out = new FileOutputStream(new File(concatFileName));
                this.concatPDFs(this.filesList, out, true);
                this.filesList.add(concatFileName);
                this.generateBookmarks(concatFileName, outputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeStream(out);
            DeleteUtil.deleteFile(this.filesList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportAsPdf(String inputFileName, OutputStream out) {
        FileInputStream fis = null;
        try {
            int readNum;
            fis = new FileInputStream(new File(inputFileName));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1000024];
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
            byte[] bytes = bos.toByteArray();
            out.write(bytes, 0, bytes.length);
            out.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.closeStream(out);
            this.closeStream(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concatPDFs(List<String> pdfFilesList, OutputStream outputStream, boolean paginate) {
        Document document = new Document();
        Rectangle maxRect = null;
        PdfWriter writer = null;
        float maxWidth = 0.0f;
        try {
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            Iterator<String> iteratorPDFs = pdfFilesList.iterator();
            while (iteratorPDFs.hasNext()) {
                FileInputStream pdfFileInput = new FileInputStream(iteratorPDFs.next());
                PdfReader pdfReader = this.password != null ? new PdfReader((InputStream)pdfFileInput, this.password.getBytes()) : new PdfReader((InputStream)pdfFileInput);
                readers.add(pdfReader);
                totalPages += pdfReader.getNumberOfPages();
                for (int indx = 1; indx <= pdfReader.getNumberOfPages(); ++indx) {
                    Rectangle curPageRect = pdfReader.getPageSize(indx);
                    if (!(curPageRect.getWidth() > maxWidth)) continue;
                    maxRect = curPageRect;
                    maxWidth = curPageRect.getWidth();
                }
                ((InputStream)pdfFileInput).close();
                pdfReader.close();
            }
            if (maxRect != null) {
                document = new Document(maxRect);
            }
            writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            if (this.password != null) {
                writer.setEncryption(this.password.getBytes(), this.password.getBytes(), 2052, 1);
            }
            document.open();
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            Iterator iteratorPDFReader = readers.iterator();
            HashMap map = new HashMap();
            while (iteratorPDFReader.hasNext()) {
                PdfReader pdfReader = (PdfReader)iteratorPDFReader.next();
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    ++currentPageNumber;
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb.showTextAligned(1, MessageFormat.format(this.rb.getString("admp.reports.common.export.footer_page_number"), currentPageNumber, totalPages), (float)((int)(maxWidth - 62.0f)), 5.0f, 0.0f);
                    cb.endText();
                }
                pageOfCurrentReaderPDF = 0;
                pdfReader.close();
            }
            outputStream.flush();
            document.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            try {
                if (!writer.isCloseStream()) {
                    writer.close();
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateBookmarks(String inputFileName, OutputStream outputStream) {
        PdfReader reader = null;
        PdfStamper stamper = null;
        try {
            reader = this.password != null ? new PdfReader(inputFileName, this.password.getBytes()) : new PdfReader(inputFileName);
            stamper = new PdfStamper(reader, outputStream);
            if (this.password != null) {
                stamper.setEncryption(this.password.getBytes(), this.password.getBytes(), 2052, 1);
            }
            ArrayList outlines = new ArrayList();
            int page = 1;
            if (this.tocEnabled) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("Title", this.rb.getString("admp.reports.common.export.report_summary"));
                map.put("Action", "GoTo");
                map.put("Page", String.format("%d FitH 825", page));
                page = this.tocPages;
                outlines.add(map);
            }
            for (int i = 0; i < this.bookMarkParams.size(); ++i) {
                Hashtable parentHash = (Hashtable)this.bookMarkParams.get(i);
                String parentName = (String)parentHash.get("Key");
                HashMap<String, Object> map = new HashMap<String, Object>();
                outlines.add(map);
                map.put("Title", parentName);
                if (parentHash.get("Kids") != null) {
                    ArrayList kids = new ArrayList();
                    map.put("Kids", kids);
                    ArrayList childs = (ArrayList)parentHash.get("Kids");
                    for (int j = 0; j < childs.size(); ++j) {
                        Hashtable childDetails = (Hashtable)childs.get(j);
                        String childKeyName = (String)childDetails.get("Key");
                        HashMap<String, String> kid = new HashMap<String, String>();
                        kids.add(kid);
                        kid.put("Title", childKeyName);
                        kid.put("Action", "GoTo");
                        kid.put("Page", String.format("%d FitH 825", page + 1));
                        if (j == 0) {
                            map.put("Action", "GoTo");
                            map.put("Page", String.format("%d FitH 830", page + 1));
                        }
                        page += ((Integer)childDetails.get("Count")).intValue();
                    }
                    continue;
                }
                map.put("Action", "GoTo");
                map.put("Page", String.format("%d FitH 825", page + 1));
                if (i == 0) {
                    map.put("Action", "GoTo");
                    map.put("Page", String.format("%d FitH 830", page + 1));
                }
                page += ((Integer)parentHash.get("Count")).intValue();
            }
            stamper.setOutlines(outlines);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stamper != null) {
                    stamper.close();
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

