/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.export;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.SelectionTableModel;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.webclient.export.ADMPPdfExporter;
import com.adventnet.sym.adsm.common.webclient.export.JasperDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.customreport.CustomReportResultUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JasperPrint;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportPdfExporter
extends ADMPPdfExporter {
    private boolean showSummaryView = false;
    private boolean showPageNo = true;
    private boolean isForScheduler = false;
    private boolean isCreateBookMark = true;
    private boolean isExportCurrentViewOnly = false;
    private HashMap jrParameter = new HashMap();
    DataObject rvcDO = null;
    private RVReqParams reqParams = null;
    ArrayList filesList = new ArrayList();
    private Integer rvId = 0;
    private int exportCount = 0;

    public void init(HashMap jrReportParameter, DataObject dataObject, RVReqParams reqParam, AdventNetResourceBundle rb) {
        this.jrParameter = jrReportParameter;
        this.rvcDO = dataObject;
        this.reqParams = reqParam;
        this.rb = rb;
    }

    public void init(HashMap jrReportParameter, AdventNetResourceBundle rb) {
        this.jrParameter = jrReportParameter;
        this.rb = rb;
    }

    public void setIsForScheduler(boolean isScheduler) {
        this.isForScheduler = isScheduler;
    }

    public void setExportCurrentViewOnly(boolean isExportCurrentViewOnly) {
        this.isExportCurrentViewOnly = isExportCurrentViewOnly;
    }

    public void setRvId(Integer rvId) {
        this.rvId = rvId;
    }

    public void exportReport(HttpServletResponse response, String storageDir) throws Exception {
        response.setContentType("application/pdf");
        response.setHeader("content-disposition", "attachment; filename=ADMPReport.pdf");
        this.storageDir = storageDir;
        if (!this.isExportCurrentViewOnly) {
            this.exportAllReportView((OutputStream)response.getOutputStream(), storageDir);
        } else {
            this.exportSingleReportView((OutputStream)response.getOutputStream(), storageDir);
        }
    }

    public void exportIntersectReport(HttpServletResponse response, String storageDir, ArrayList<Hashtable<String, Object>> exportViewsList) throws Exception {
        response.setContentType("application/pdf");
        response.setHeader("content-disposition", "attachment; filename=ADMPReport.pdf");
        if (!this.isExportCurrentViewOnly) {
            this.exportAllReportView((OutputStream)response.getOutputStream(), storageDir, exportViewsList);
        }
    }

    public void exportReport(HttpServletResponse response, ArrayList tablist, Hashtable params, JSONObject searchProp, String storageDir) throws Exception {
        response.setContentType("application/pdf");
        response.setHeader("content-disposition", "attachment; filename=ADMPReport.pdf");
        this.storageDir = storageDir;
        this.exportAllReportView((OutputStream)response.getOutputStream(), tablist, params, searchProp, storageDir);
    }

    public String exportReportAsFile(String storageDir) throws Exception {
        String resultFileName = (String)this.jrParameter.get("REPORT_NAME");
        resultFileName = storageDir + File.separator + resultFileName.replaceAll(" ", "_") + ".pdf";
        if (!this.isExportCurrentViewOnly) {
            FileOutputStream outputStream = new FileOutputStream(resultFileName);
            this.exportAllReportView(outputStream, storageDir);
            outputStream.close();
        }
        return resultFileName;
    }

    private void exportAllReportView(OutputStream outputStream, String storageDir, ArrayList<Hashtable<String, Object>> expViewsList) throws Exception {
        this.storageDir = storageDir;
        String fileName = "";
        String heading = "admp.reports.common.common_export_page_heading_in";
        JSONObject obj = CVCDataUtil.getCheckBoxData((Long)this.reqParams.getCvcDataId());
        if (obj.has("IsExcludeNestedGroups")) {
            boolean isExcludeNestedGroups = (Boolean)obj.get("IsExcludeNestedGroups");
            if (isExcludeNestedGroups) {
                heading = "admp.reports.common.common_members_of_groups_with_exclude_nested_groups";
                this.jrParameter.put("DESCRIPTION", this.rb.getString("admp.reports.user_reports.adv_grp_members.reportdesc_view_common_members_with_excluding_nested_groups"));
            } else {
                heading = "admp.reports.common.common_members_of_groups_withOut_exclude_nested_groups";
                this.jrParameter.put("DESCRIPTION", this.rb.getString("admp.reports.user_reports.adv_grp_members.reportdesc_view_common_members_withOut_excluding_nested_groups"));
            }
        }
        ArrayList bookMarkInputDetails = new ArrayList();
        ArrayList<ArrayList> outputFilterVsViewsResultCount = new ArrayList<ArrayList>();
        ArrayList<Hashtable<String, Object>> exportViewsList = expViewsList;
        ArrayList cvcOutputFilters = null;
        cvcOutputFilters = CVCUtil.getCVCSelectedInputList((Long)this.reqParams.getCvcDataId());
        ArrayList summaryHeaders = new ArrayList();
        boolean cvcInputEmpty = false;
        try {
            ArrayList<JSONObject> reqOutputFiltersList = new ArrayList<JSONObject>();
            ArrayList kidsList = new ArrayList();
            if (cvcOutputFilters.isEmpty()) {
                cvcInputEmpty = true;
                Hashtable<String, String> hash1 = new Hashtable<String, String>();
                hash1.put("objectName", (String)this.jrParameter.get("REPORT_NAME"));
                cvcOutputFilters.add(hash1);
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("filterName", "Object Type");
                summaryHeaders.add(hash);
                hash = new Hashtable();
                hash.put("filterName", "Count");
                summaryHeaders.add(hash);
            } else {
                summaryHeaders.addAll(exportViewsList);
                Hashtable<String, String> dummyViewConfig = new Hashtable<String, String>();
                dummyViewConfig.put("filterName", this.rb.getString("admp.common.attrib_disp_name.group_name"));
                summaryHeaders.add(0, dummyViewConfig);
            }
            for (int opFilterIndex = 0; opFilterIndex < cvcOutputFilters.size(); ++opFilterIndex) {
                Hashtable filterDetails = (Hashtable)cvcOutputFilters.get(opFilterIndex);
                String filterObjectName = (String)filterDetails.get("objectName");
                if (filterDetails.get("inputId") != null) {
                    Long inputId = (Long)filterDetails.get("inputId");
                    JSONObject json = new JSONObject().put(inputId.toString(), (Object)filterObjectName);
                    reqOutputFiltersList.add(json);
                }
                ArrayList<String> viewsResultCount = new ArrayList<String>();
                if (cvcInputEmpty) continue;
                viewsResultCount.add(filterObjectName);
                outputFilterVsViewsResultCount.add(viewsResultCount);
            }
            Hashtable<String, Object> objectDetails = new Hashtable<String, Object>();
            for (int viewIndex = 0; viewIndex < exportViewsList.size(); ++viewIndex) {
                Hashtable<String, Object> viewConfig = exportViewsList.get(viewIndex);
                String viewName = (String)viewConfig.get("filterName");
                this.exportView(viewConfig, objectDetails, reqOutputFiltersList, kidsList, null, "", heading, cvcInputEmpty, outputFilterVsViewsResultCount);
                objectDetails.put("Key", viewName);
                if (kidsList.size() <= 0) continue;
                if (cvcInputEmpty) {
                    bookMarkInputDetails = kidsList;
                    continue;
                }
                objectDetails.put("Kids", kidsList);
                bookMarkInputDetails.add(objectDetails);
            }
            JasperPrint tocPrintObject = JasperDesignUtil.getTocPrintObject("ExportReport.jrxml", exportViewsList, outputFilterVsViewsResultCount, this.jrParameter, this.rb, this.reqParams.getLoginId(), "pdf", this.getLocale(), true);
            String password = PasswordUtil.getExportFilePassword((Long)this.reqParams.getLoginId());
            if (password != null && !password.equals("")) {
                this.setPassword(password);
            }
            this.setToc(tocPrintObject);
            this.setBookMarkParams(bookMarkInputDetails);
            super.exportReport(outputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void exportAllReportView(OutputStream outputStream, String storageDir) throws Exception {
        this.storageDir = storageDir;
        String fileName = "";
        ArrayList bookMarkInputDetails = new ArrayList();
        ArrayList<ArrayList> outputFilterVsViewsResultCount = new ArrayList<ArrayList>();
        ArrayList exportViewsList = RVHandler.getViewsListForExport((DataObject)this.rvcDO, (AdventNetResourceBundle)this.rb);
        ArrayList cvcOutputFilters = null;
        cvcOutputFilters = CVCUtil.getCVCSelectedInputList((Long)this.reqParams.getCvcDataId());
        ArrayList summaryHeaders = new ArrayList();
        boolean cvcInputEmpty = false;
        JSONObject obj = CVCDataUtil.getCheckBoxData((Long)this.reqParams.getCvcDataId());
        if (obj.has("IsExcludeNestedGroups")) {
            boolean isExcludeNestedGroups = (Boolean)obj.get("IsExcludeNestedGroups");
            if (isExcludeNestedGroups) {
                this.jrParameter.put("DESCRIPTION", this.rb.getString("admp.reports.user_reports.adv_grp_members.reportdesc_view_members_with_excluding_nested_groups"));
            } else {
                this.jrParameter.put("DESCRIPTION", this.rb.getString("admp.reports.user_reports.adv_grp_members.reportdesc_view_members_withOut_excluding_nested_groups"));
            }
        }
        try {
            String password;
            if (cvcOutputFilters.isEmpty()) {
                cvcInputEmpty = true;
                Hashtable<String, String> hash1 = new Hashtable<String, String>();
                hash1.put("objectName", (String)this.jrParameter.get("REPORT_NAME"));
                cvcOutputFilters.add(hash1);
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("filterName", "Object Type");
                summaryHeaders.add(hash);
                hash = new Hashtable();
                hash.put("filterName", "Count");
                summaryHeaders.add(hash);
            } else {
                summaryHeaders.addAll(exportViewsList);
                Hashtable<String, String> dummyViewConfig = new Hashtable<String, String>();
                dummyViewConfig.put("filterName", this.rb.getString("admp.common.attrib_disp_name.group_name"));
                summaryHeaders.add(0, dummyViewConfig);
            }
            for (int opFilterIndex = 0; opFilterIndex < cvcOutputFilters.size(); ++opFilterIndex) {
                Hashtable filterDetails = (Hashtable)cvcOutputFilters.get(opFilterIndex);
                String filterObjectName = (String)filterDetails.get("objectName");
                ArrayList<JSONObject> reqOutputFiltersList = new ArrayList<JSONObject>();
                ArrayList<String> viewsResultCount = new ArrayList<String>();
                if (filterDetails.get("inputId") != null) {
                    Long inputId = (Long)filterDetails.get("inputId");
                    JSONObject json = new JSONObject().put(inputId.toString(), (Object)filterObjectName);
                    reqOutputFiltersList.add(json);
                }
                if (!cvcInputEmpty) {
                    viewsResultCount.add(filterObjectName);
                    outputFilterVsViewsResultCount.add(viewsResultCount);
                }
                Hashtable<String, Object> objectDetails = new Hashtable<String, Object>();
                objectDetails.put("Key", filterObjectName);
                ArrayList kidsList = new ArrayList();
                for (int viewIndex = 0; viewIndex < exportViewsList.size(); ++viewIndex) {
                    Hashtable viewConfig = (Hashtable)exportViewsList.get(viewIndex);
                    String rvFilterHeading = (String)viewConfig.get("exportPageHeader");
                    if (rvFilterHeading == null) {
                        rvFilterHeading = "admp.reports.common.export_page_heading_in";
                        if (obj.has("IsExcludeNestedGroups")) {
                            boolean isExcludeNestedGroups = (Boolean)obj.get("IsExcludeNestedGroups");
                            rvFilterHeading = isExcludeNestedGroups ? "admp.reports.common.members_of_group_with_exclude_nested_groups" : "admp.reports.common.members_of_group_withOut_exclude_nested_groups";
                        }
                    }
                    this.exportView(viewConfig, objectDetails, reqOutputFiltersList, kidsList, viewsResultCount, filterObjectName, rvFilterHeading, cvcInputEmpty, outputFilterVsViewsResultCount);
                }
                if (kidsList.size() <= 0) continue;
                if (cvcInputEmpty) {
                    bookMarkInputDetails = kidsList;
                    continue;
                }
                objectDetails.put("Kids", kidsList);
                bookMarkInputDetails.add(objectDetails);
            }
            JasperPrint tocPrintObject = JasperDesignUtil.getTocPrintObject("ExportReport.jrxml", summaryHeaders, outputFilterVsViewsResultCount, this.jrParameter, this.rb, this.reqParams.getLoginId(), "pdf", this.getLocale(), false);
            if (!this.isForScheduler && (password = PasswordUtil.getExportFilePassword((Long)this.reqParams.getLoginId())) != null && !password.equals("")) {
                this.setPassword(password);
            }
            this.setToc(tocPrintObject);
            this.setBookMarkParams(bookMarkInputDetails);
            super.exportReport(outputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void exportView(Hashtable viewConfig, Hashtable objectDetails, ArrayList reqOutputFiltersList, ArrayList kidsList, ArrayList viewsResultCount, String filterObjectName, String heading, boolean cvcInputEmpty, ArrayList<ArrayList> outputFilterVsViewsResultCount) {
        String viewName = (String)viewConfig.get("filterName");
        this.reqParams.setFilterId(((Integer)viewConfig.get("filterId")).intValue());
        this.reqParams.setRvId(((Integer)viewConfig.get("rvId")).intValue());
        this.reqParams.setViewModelId(((Integer)viewConfig.get("viewModelId")).intValue());
        this.reqParams.setObjectIdList((JSONArray)viewConfig.get("objectIdList"));
        this.reqParams.setFilterFlagId(((Long)viewConfig.get("filterFlagId")).longValue());
        if (cvcInputEmpty) {
            viewsResultCount = new ArrayList<Object>();
            viewsResultCount.add(viewName);
            outputFilterVsViewsResultCount.add(viewsResultCount);
        } else {
            this.reqParams.setOutputFilters(reqOutputFiltersList);
        }
        SelectionTableModel dataModel = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)this.rb, (RVReqParams)this.reqParams, (DataObject)this.rvcDO, (boolean)true, (boolean)this.isForScheduler);
        this.setExportRowCount(this.exportCount + dataModel.getRowCount());
        if (viewsResultCount != null) {
            viewsResultCount.add(dataModel.getRowCount());
        }
        if (dataModel.getRowCount() > 0) {
            String headingStr = MessageFormat.format(this.rb.getString(heading), viewName, filterObjectName);
            String jrDesignName = viewName + "_" + System.currentTimeMillis();
            JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, headingStr, this.rb, "pdf", jrDesignName, this.reqParams.getLoginId(), this.getLocale());
            this.addPrintList(objectJRPrint);
            Hashtable<String, Object> childDetails = new Hashtable<String, Object>();
            childDetails.put("Key", viewName);
            childDetails.put("Count", objectJRPrint.getPages().size());
            kidsList.add(childDetails);
        }
    }

    public void exportAllReportView(OutputStream outputStream, ArrayList tablist, Hashtable params, JSONObject searchProp, String storageDir) throws Exception {
        this.storageDir = storageDir;
        String fileName = "";
        ArrayList bookMarkInputDetails = new ArrayList();
        ArrayList<ArrayList> outputFilterVsViewsResultCount = new ArrayList<ArrayList>();
        ArrayList cvcOutputFilters = new ArrayList();
        ArrayList summaryHeaders = new ArrayList();
        boolean cvcInputEmpty = false;
        try {
            if (cvcOutputFilters.isEmpty()) {
                cvcInputEmpty = true;
                Hashtable<String, String> hash1 = new Hashtable<String, String>();
                hash1.put("objectName", (String)this.jrParameter.get("REPORT_NAME"));
                cvcOutputFilters.add(hash1);
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put("filterName", this.rb.getString("admp.reports.export.selected_objects"));
                summaryHeaders.add(hash);
                hash = new Hashtable();
                hash.put("filterName", this.rb.getString("admp.reports.export.object_count"));
                summaryHeaders.add(hash);
            }
            for (int opFilterIndex = 0; opFilterIndex < cvcOutputFilters.size(); ++opFilterIndex) {
                Hashtable filterDetails = (Hashtable)cvcOutputFilters.get(opFilterIndex);
                String filterObjectName = (String)filterDetails.get("objectName");
                ArrayList reqOutputFiltersList = new ArrayList();
                ArrayList<String> viewsResultCount = new ArrayList<String>();
                if (!cvcInputEmpty) {
                    viewsResultCount.add(filterObjectName);
                    outputFilterVsViewsResultCount.add(viewsResultCount);
                }
                Hashtable<String, Object> objectDetails = new Hashtable<String, Object>();
                objectDetails.put("Key", filterObjectName);
                ArrayList kidsList = new ArrayList();
                for (int viewIndex = 0; viewIndex < tablist.size(); ++viewIndex) {
                    Hashtable tabProp = (Hashtable)tablist.get(viewIndex);
                    this.exportView(tabProp, searchProp, params, objectDetails, kidsList, viewsResultCount, filterObjectName, cvcInputEmpty, outputFilterVsViewsResultCount);
                }
                if (kidsList.size() <= 0) continue;
                if (cvcInputEmpty) {
                    bookMarkInputDetails = kidsList;
                    continue;
                }
                objectDetails.put("Kids", kidsList);
                bookMarkInputDetails.add(objectDetails);
            }
            JasperPrint tocPrintObject = JasperDesignUtil.getTocPrintObject("ExportReport.jrxml", summaryHeaders, outputFilterVsViewsResultCount, this.jrParameter, this.rb, (Long)params.get("loginId"), "pdf", this.getLocale(), false);
            String password = PasswordUtil.getExportFilePassword((Long)((Long)params.get("loginId")));
            if (password != null && !password.equals("")) {
                this.setPassword(password);
            }
            this.setToc(tocPrintObject);
            this.setBookMarkParams(bookMarkInputDetails);
            super.exportReport(outputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void exportView(Hashtable tabProp, JSONObject searchProp, Hashtable params, Hashtable objectDetails, ArrayList kidsList, ArrayList viewsResultCount, String filterObjectName, boolean cvcInputEmpty, ArrayList<ArrayList> outputFilterVsViewsResultCount) throws Exception {
        String viewName = (String)tabProp.get("TAB_NAME");
        Integer tabId = (Integer)tabProp.get("TAB_ID");
        params.put("objectId", tabId);
        SelectionTableModel dataModel = (SelectionTableModel)CustomReportResultUtil.getDataModel(params, (JSONObject)searchProp.get(Integer.toString(tabId)), this.rb);
        if (cvcInputEmpty) {
            viewsResultCount = new ArrayList<Integer>();
            viewsResultCount.add((Integer)((Object)viewName));
            outputFilterVsViewsResultCount.add(viewsResultCount);
        }
        if (viewsResultCount != null) {
            viewsResultCount.add(dataModel.getRowCount());
        }
        this.setExportRowCount(this.exportCount + dataModel.getRowCount());
        if (dataModel.getRowCount() > 0) {
            JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, viewName, this.rb, "pdf", viewName, (Long)params.get("loginId"), this.getLocale());
            this.addPrintList(objectJRPrint);
            Hashtable<String, Object> childDetails = new Hashtable<String, Object>();
            childDetails.put("Key", viewName);
            childDetails.put("Count", objectJRPrint.getPages().size());
            kidsList.add(childDetails);
        }
    }

    private void exportSingleReportView(OutputStream outputStream, String storageDir) throws Exception {
        try {
            Hashtable viewConfig = RVHandler.getViewsDetailsForExport((DataObject)this.rvcDO, (Integer)this.rvId, (AdventNetResourceBundle)this.rb);
            String viewName = (String)viewConfig.get("filterName");
            this.reqParams.setFilterId(((Integer)viewConfig.get("filterId")).intValue());
            this.reqParams.setRvId(this.rvId.intValue());
            this.reqParams.setViewModelId(((Integer)viewConfig.get("viewModelId")).intValue());
            this.reqParams.setObjectIdList((JSONArray)viewConfig.get("objectIdList"));
            this.reqParams.setFilterFlagId(((Long)viewConfig.get("filterFlagId")).longValue());
            SelectionTableModel dataModel = (SelectionTableModel)RVHandler.getDataModel((AdventNetResourceBundle)this.rb, (RVReqParams)this.reqParams, (DataObject)this.rvcDO, (boolean)true, (boolean)this.isForScheduler);
            this.setExportRowCount(this.exportCount + dataModel.getRowCount());
            String rvFilterHeading = (String)viewConfig.get("exportPageHeader");
            if (rvFilterHeading == null) {
                rvFilterHeading = "admp.reports.common.export_page_heading_in";
                JSONObject obj = CVCDataUtil.getCheckBoxData((Long)this.reqParams.getCvcDataId());
                if (obj.has("IsExcludeNestedGroups")) {
                    boolean isExcludeNestedGroups = (Boolean)obj.get("IsExcludeNestedGroups");
                    rvFilterHeading = isExcludeNestedGroups ? "admp.reports.common.members_of_group_with_exclude_nested_groups" : "admp.reports.common.members_of_group_withOut_exclude_nested_groups";
                }
            }
            String heading = MessageFormat.format(this.rb.getString(rvFilterHeading), viewName);
            String jrDesignName = viewName + "_" + System.currentTimeMillis();
            JasperPrint objectJRPrint = JasperDesignUtil.createJRPrintForView(dataModel, heading, this.rb, "pdf", jrDesignName, this.reqParams.getLoginId(), this.getLocale());
            this.addPrintList(objectJRPrint);
            super.exportReport(outputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setExportRowCount(int count) {
        this.exportCount = count;
    }

    public int getExportRowCount() {
        return this.exportCount;
    }
}

