/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.gpomgmt;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.PersistenceUtil;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtBean;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class EditGPOAction
extends DispatchAction {
    static boolean isPopulatating = false;
    static int populatedTables = 0;
    static String[] gpoXML = new String[]{"gpomgmt/GPOSettingsStateConfig.xml", "gpomgmt/GPOSettingFolderDetails.xml", "gpomgmt/GPORegSetting.xml", "gpomgmt/GPORegSettingKey.xml", "gpomgmt/RegSettingKeyValName.xml", "gpomgmt/RegSettingKeyDynaVal.xml", "gpomgmt/RegSettingCheckBoxCompDetails.xml", "gpomgmt/RegSettingConstValConfig.xml", "gpomgmt/RegSettingConstValMapping.xml", "gpomgmt/RegSettingListValConfig.xml", "gpomgmt/RegSettingListValMapping.xml", "gpomgmt/RegSettingListValSubValConfig.xml", "gpomgmt/RegSettingListValSubValDetails.xml", "gpomgmt/RegSettingRangeComponentConfig.xml", "gpomgmt/RegSettingRangeCompMapping.xml", "gpomgmt/RegSettingTextBoxCompDetails.xml", "gpomgmt/RegSettingComponentDetails.xml", "gpomgmt/RegSettingUIDetails.xml", "gpomgmt/RegSettingUIDynaValDetails.xml", "gpomgmt/RegSettingUITextDetails.xml", "gpomgmt/RegSettingMultiTextCompDetails.xml"};
    static int totalTables = gpoXML.length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String details = "<script>window.opener.GPOMgmt.editgpoRefresh('" + request.getParameter("gpoGuid") + "')</script>";
        String[] gpoTables = new String[]{"GPOSettingsStateConfig", "GPOSettingFolderDetails", "GPORegSetting", "GPORegSettingKey", "RegSettingKeyValName", "RegSettingKeyDynaVal", "RegSettingCheckBoxCompDetails", "RegSettingConstValConfig", "RegSettingConstValMapping", "RegSettingListValConfig", "RegSettingListValMapping", "RegSettingListValSubValConfig", "RegSettingListValSubValDetails", "RegSettingRangeComponentConfig", "RegSettingRangeCompMapping", "RegSettingTextBoxCompDetails", "RegSettingComponentDetails", "RegSettingUIDetails", "RegSettingUIDynaValDetails", "RegSettingUITextDetails", "RegSettingMultiTextCompDetails"};
        if (isPopulatating) {
            request.setAttribute("status", (Object)"populating");
            request.setAttribute("totalTables", (Object)totalTables);
            request.setAttribute("populatedTables", (Object)populatedTables);
            return mapping.findForward("editgpo");
        }
        int temp = 0;
        int rowCount = 0;
        Connection connection = null;
        DataSet dataSet = null;
        Class<EditGPOAction> clazz = EditGPOAction.class;
        synchronized (EditGPOAction.class) {
            GPOMgmtBean gpoMgmtBean;
            HashMap<String, String> tableDetails;
            try {
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                for (temp = 0; temp < gpoXML.length; ++temp) {
                    rowCount = 0;
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)gpoTables[temp]));
                    Column col = new Column(null, "*").count();
                    query.addSelectColumn(col);
                    dataSet = relAPI.executeQuery((Query)query, connection);
                    while (dataSet.next()) {
                        rowCount = (Integer)dataSet.getValue(1);
                    }
                    if (dataSet != null) {
                        dataSet.close();
                    }
                    if (rowCount != 0) continue;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
            }
            if (rowCount == 0) {
                System.out.println("Error in table : " + gpoTables[temp]);
                PrintWriter writer = response.getWriter();
                writer.print(details);
                writer.flush();
                GPODbDataPopulation populate = new GPODbDataPopulation(temp);
                Thread dataPopulation = new Thread(populate);
                dataPopulation.start();
                // ** MonitorExit[var13_13] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            Criteria crit = new Criteria(Column.getColumn((String)"GPOSettingsState", (String)"SESSION_ID"), (Object)request.getSession().getId(), 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"GPOSettingsState", (String)"OBJECT_GUID"), (Object)request.getParameter("gpoGuid"), 0));
            CommonUtil.getPersistenceNT().delete(crit);
            HttpSession session = request.getSession();
            if (session.getAttribute("GPOMgmtBean") == null) {
                session.setAttribute("GPOMgmtBean", (Object)new GPOMgmtBean());
            }
            if ((tableDetails = (gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean")).getGpoTableDetails()) == null) {
                GPOMgmtBean gPOMgmtBean = gpoMgmtBean;
                synchronized (gPOMgmtBean) {
                    tableDetails = gpoMgmtBean.getGpoTableDetails();
                    if (tableDetails == null) {
                        String resourceFileName;
                        File propFile;
                        Locale buildLocale = I18NUtil.getBuildLocale();
                        String buildLanguage = buildLocale.getLanguage();
                        String buildCountry = buildLocale.getCountry();
                        String gpoFolderNamesTable = "GPOSettingFolderDetails_" + buildLanguage + "_" + buildCountry;
                        String gpoSettingNamesTable = "GPORegSetting_" + buildLanguage + "_" + buildCountry;
                        String gpoSettingsStateConfigTable = "GPOSettingsStateConfig_" + buildLanguage + "_" + buildCountry;
                        String language = locale.getLanguage();
                        String country = locale.getCountry();
                        if (country != null && !country.equals("") && language != null && !language.equals("") && (propFile = new File(resourceFileName = System.getProperty("server.dir") + File.separator + "resources" + File.separator + "adsm" + File.separator + "gpomgmt" + File.separator + "GpoMgmtMessage" + "_" + language + "_" + country + ".properties")).exists()) {
                            gpoFolderNamesTable = "GPOSettingFolderDetails_" + language + "_" + country;
                            gpoSettingNamesTable = "GPORegSetting_" + language + "_" + country;
                            gpoSettingsStateConfigTable = "GPOSettingsStateConfig_" + language + "_" + country;
                        }
                        tableDetails = new HashMap<String, String>();
                        tableDetails.put("GPOSettingFolderDetails", gpoFolderNamesTable);
                        tableDetails.put("GPORegSetting", gpoSettingNamesTable);
                        tableDetails.put("GPOSettingsStateConfig", gpoSettingsStateConfigTable);
                        gpoMgmtBean.setGpoTableDetails(tableDetails);
                        GPOMgmtUtil.chkAndCreateGpoTables((AdventNetResourceBundle)rb, (String)"GPOSettingsStateConfig", (String)gpoSettingsStateConfigTable);
                        GPOMgmtUtil.chkAndCreateGpoTables((AdventNetResourceBundle)rb, (String)"GPOSettingFolderDetails", (String)gpoFolderNamesTable);
                        GPOMgmtUtil.chkAndCreateGpoTables((AdventNetResourceBundle)rb, (String)"GPORegSetting", (String)gpoSettingNamesTable);
                    }
                }
            }
            Properties gpoDetails = GPOMgmtUtil.getGPODetails((String)request.getParameter("gpoGuid"));
            request.setAttribute("gpoName", (Object)gpoDetails.getProperty("displayName"));
            request.setAttribute("status", (Object)"success");
            return mapping.findForward("editgpo");
        }
    }

    public ActionForward getRegSettingPopulationStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject details = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String msg = MessageFormat.format(rb.getString("admp.mgmt.intialiazing_the_neccessary_tables_for_gpo_settings"), Integer.toString(populatedTables), Integer.toString(totalTables));
            details.put("isPopulatating", isPopulatating);
            details.put("msg", (Object)msg);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getRegSettingDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            long regSettingId = Long.valueOf(request.getParameter("regSettingId"));
            String gpoGuid = request.getParameter("gpoGuid");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
            JSONObject details = GPOMgmtUtil.getRegSettingDetails((long)regSettingId, (String)gpoGuid, (String)session.getId(), (AdventNetResourceBundle)rb, (GPOMgmtBean)gpoMgmtBean, (Long)loginId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getSubFoldersAndSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            long folderId = Long.valueOf(request.getParameter("folderId"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
            JSONObject details = GPOMgmtUtil.getSubFoldersAndSettings((long)folderId, (String)request.getParameter("gpoGuid"), (String)request.getParameter("viewParams"), (String)session.getId(), (AdventNetResourceBundle)rb, (GPOMgmtBean)gpoMgmtBean, (Long)loginId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateGpoRegSetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            String hostId = request.getRemoteHost();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONObject details = GPOMgmtUtil.updateGpoRegSetting((String)request.getParameter("gpoGuid"), (String)request.getParameter("settingDetails"), (String)session.getId(), (AdventNetResourceBundle)rb, (Long)loginId, (String)hostId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward createGPO(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String gpoName = request.getParameter("gpoName");
            String domainName = request.getParameter("domainName");
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String hostId = request.getRemoteHost();
            JSONObject details = GPOMgmtUtil.createGPO((String)domainName, (Long)loginId, (String)hostId, (String)gpoName, (AdventNetResourceBundle)rb);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(details);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private class GPODbDataPopulation
    implements Runnable {
        int indexToStart = 0;

        GPODbDataPopulation(int index) {
            this.indexToStart = index;
        }

        @Override
        public void run() {
            isPopulatating = true;
            try {
                for (int i = this.indexToStart; i < gpoXML.length; ++i) {
                    populatedTables = i + 1;
                    PersistenceUtil.populate((String)"adsm", (String)gpoXML[i]);
                }
                ++populatedTables;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            isPopulatating = false;
        }
    }
}

