/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.gpomgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtBean;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtHandler;
import com.adventnet.sym.adsm.common.server.gpomgmt.GPOMgmtUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class GPOMgmtAction
extends DispatchAction {
    private static Logger out = Logger.getLogger("ADMangLogger");

    public ActionForward updateGPOs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            String domainName = request.getParameter("domainName");
            String operation = request.getParameter("operation");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String[] arrGpcGuids = null;
            ArrayList<String> gpcGuids = null;
            boolean anyError = false;
            if (!operation.equalsIgnoreCase("gpoDelete") && !operation.equalsIgnoreCase("gpoRename")) {
                arrGpcGuids = request.getParameterValues("gpcGuid");
                gpcGuids = new ArrayList<String>(Arrays.asList(arrGpcGuids));
                int count = gpcGuids.size();
                for (int i = 0; i < count; ++i) {
                    String guid = gpcGuids.get(i);
                    String guidStr = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    gpcGuids.set(i, guidStr);
                }
            }
            ArrayList<Properties> results = null;
            String userconfig = null;
            String computerconfig = null;
            String gpoFlags = null;
            JSONObject returnMsg = new JSONObject();
            if (operation.equalsIgnoreCase("gpoStatus")) {
                int action = Integer.parseInt(request.getParameter("action"));
                try {
                    results = ADHandler.gpoEnableDisable((String)domainName, (Long)loginId, (int)action, gpcGuids);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    results = new ArrayList<Properties>();
                    for (String curGpcGuid : gpcGuids) {
                        Properties curProp = new Properties();
                        curProp.put("msgtype", "error");
                        curProp.put("msg", le.getMessage(rb));
                        curProp.put("gpoid", curGpcGuid);
                        results.add(curProp);
                    }
                }
                returnMsg.put("overAllMsgType", (Object)"success");
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_succ_modi_gpo_status"));
                switch (action) {
                    case 0: {
                        userconfig = "admp.ad_explorer.view_props.user.common.statmsg.enabled";
                        computerconfig = "admp.ad_explorer.view_props.user.common.statmsg.enabled";
                        gpoFlags = "0";
                        break;
                    }
                    case 1: {
                        userconfig = "admp.ad_explorer.view_props.user.common.statmsg.disabled";
                        computerconfig = "admp.ad_explorer.view_props.user.common.statmsg.enabled";
                        gpoFlags = "1";
                        break;
                    }
                    case 2: {
                        userconfig = "admp.ad_explorer.view_props.user.common.statmsg.enabled";
                        computerconfig = "admp.ad_explorer.view_props.user.common.statmsg.disabled";
                        gpoFlags = "2";
                        break;
                    }
                    case 3: {
                        userconfig = "admp.ad_explorer.view_props.user.common.statmsg.disabled";
                        computerconfig = "admp.ad_explorer.view_props.user.common.statmsg.disabled";
                        gpoFlags = "3";
                    }
                }
            } else if (operation.equalsIgnoreCase("gpoDelete")) {
                String[] gpoDn = request.getParameterValues("gpoDn");
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMGPODetails"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"OBJECT_GUID"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"DISPLAY_NAME"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"GPO_DN"));
                sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"GPO_DN"), (Object)gpoDn, 8));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                returnMsg.put("overAllMsgType", (Object)"success");
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.common.text.successfully_deleted"));
                JSONArray detailsArr = new JSONArray();
                returnMsg.put("details", (Object)detailsArr);
                ArrayList<String> delGPOs = new ArrayList<String>();
                String errorMessage = rb.getString("admp.mgmt.common.statmsg.successfully_deleted");
                String msgType = "success";
                for (int i = 0; i < gpoDn.length; ++i) {
                    String gpDn = gpoDn[i];
                    JSONObject curDetail = new JSONObject();
                    try {
                        ADHandler.deleteGPO((String)domainName, (Long)loginId, (String)gpDn);
                        delGPOs.add(gpDn);
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        errorMessage = e.getMessage(rb);
                        anyError = true;
                        msgType = "error";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errorMessage = e.getMessage();
                        anyError = true;
                        msgType = "error";
                    }
                    curDetail.put("msgType", (Object)msgType);
                    curDetail.put("msg", (Object)errorMessage);
                    Row r = dataObj.getRow("ADSMGPODetails", new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"GPO_DN"), (Object)gpDn, 0));
                    curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)r.get("DISPLAY_NAME")));
                    detailsArr.put((Object)curDetail);
                    Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)11000, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)r.get("DISPLAY_NAME")), (String)domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    ArrayList modifyAttributeList = new ArrayList();
                    TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), (String)r.get("DISPLAY_NAME"), domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), errorMessage, (Long)audit_info.get("object_id"), auditDataObj, rb);
                    audit_info.put("error_msg", errorMessage);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"GPO_DN"), (Object)delGPOs.toArray(), 8));
            } else if (operation.equalsIgnoreCase("gpoRename")) {
                String gpoDn = request.getParameter("gpoDn");
                String newName = request.getParameter("newName");
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMGPODetails"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"OBJECT_GUID"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"DISPLAY_NAME"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"GPO_DN"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"DOMAIN_NAME"));
                sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"GPO_DN"), (Object)gpoDn, 0));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                Row r = dataObj.getFirstRow("ADSMGPODetails");
                domainName = (String)r.get("DOMAIN_NAME");
                returnMsg.put("overAllMsgType", (Object)"success");
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.common.text.successfully_modified"));
                JSONObject curDetail = new JSONObject();
                JSONArray detailsArr = new JSONArray();
                returnMsg.put("details", (Object)detailsArr);
                String errorMessage = rb.getString("admp.mgmt.common.text.successfully_modified");
                String msgType = "success";
                try {
                    ADHandler.renameGPO((String)domainName, (Long)loginId, (String)gpoDn, (String)newName);
                }
                catch (LocalizedException e) {
                    e.printStackTrace();
                    errorMessage = e.getMessage(rb);
                    anyError = true;
                    msgType = "error";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errorMessage = e.getMessage();
                    anyError = true;
                    msgType = "error";
                }
                curDetail.put("msgType", (Object)msgType);
                curDetail.put("msg", (Object)errorMessage);
                String gpoDisplayName = (String)r.get("DISPLAY_NAME");
                curDetail.put("objName", (Object)ClientUtil.htmlEscape(gpoDisplayName));
                detailsArr.put((Object)curDetail);
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)11004, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)gpoDisplayName, (String)domainName, (DataObject)auditDataObj);
                audit_info.put("object_id", object_id);
                ArrayList modifyAttributeList = new ArrayList();
                TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.mgmt.gpo_mgmt.rename_GPO"), gpoDisplayName, domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), errorMessage, (Long)audit_info.get("object_id"), auditDataObj, rb);
                audit_info.put("error_msg", errorMessage);
                HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            }
            if (operation.equalsIgnoreCase("gpoStatus")) {
                if (results != null && results.size() > 0) {
                    SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMGPODetails"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"OBJECT_GUID"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMGPODetails", (String)"DISPLAY_NAME"));
                    sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"OBJECT_GUID"), (Object)arrGpcGuids, 8));
                    DataObject detailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                    JSONArray detailsArr = new JSONArray();
                    returnMsg.put("details", (Object)detailsArr);
                    int resSize = results.size();
                    ArrayList<String> updateGpcGuids = new ArrayList<String>();
                    for (int i = 0; i < resSize; ++i) {
                        JSONObject curDetail = new JSONObject();
                        String msgtype = ((Properties)results.get(i)).getProperty("msgtype");
                        curDetail.put("msgType", (Object)msgtype);
                        curDetail.put("msg", (Object)rb.getString(((Properties)results.get(i)).getProperty("msg")));
                        if (msgtype != null && msgtype.equalsIgnoreCase("success")) {
                            updateGpcGuids.add("{" + ((Properties)results.get(i)).getProperty("gpoid") + "}");
                        } else {
                            anyError = true;
                        }
                        Row r = detailsDO.getRow("ADSMGPODetails", new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"OBJECT_GUID"), (Object)("{" + ((Properties)results.get(i)).getProperty("gpoid") + "}"), 0));
                        curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)r.get("DISPLAY_NAME")));
                        detailsArr.put((Object)curDetail);
                        Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)11001, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)r.get("DISPLAY_NAME")), (String)domainName, (DataObject)auditDataObj);
                        audit_info.put("object_id", object_id);
                        ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
                        Properties p = new Properties();
                        p.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.comp_conf_settings"));
                        p.put("ATTRIB_VALUE", rb.getString(computerconfig));
                        modifyAttributeList.add(p);
                        p = new Properties();
                        p.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.user_conf_settings"));
                        p.put("ATTRIB_VALUE", rb.getString(userconfig));
                        modifyAttributeList.add(p);
                        TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), (String)r.get("DISPLAY_NAME"), domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (String)curDetail.get("msg"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                        audit_info.put("error_msg", curDetail.get("msg"));
                        HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    }
                    if (updateGpcGuids.size() > 0 && operation.equalsIgnoreCase("gpoStatus")) {
                        GPOMgmtHandler.updateGpoStatus(updateGpcGuids, (String)userconfig, (String)computerconfig, (String)gpoFlags, (String)domainName);
                    }
                } else {
                    anyError = true;
                    out.log(Level.INFO, "!!!!!!!!!!!!There may be errors in updateGPOs (" + operation + ") for all gpos.");
                }
            }
            if (anyError) {
                returnMsg.put("overAllMsgType", (Object)"error");
                if (operation.equalsIgnoreCase("gpoStatus")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_mod_gpo_status"));
                } else if (operation.equalsIgnoreCase("gpoDelete")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt.some_error_in_gpo_deletion"));
                } else if (operation.equalsIgnoreCase("gpoRename")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt.some_error_in_gpo_rename"));
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(returnMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward linkGPOToLocations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Row r;
            Iterator it;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainDefaultNamingContext = request.getParameter("domainName");
            String domainName = (String)DomainInfoCache.getInstance().getDefaultNamingContextVsDomainName().get(domainDefaultNamingContext);
            String gpoDomainName = request.getParameter("gpoDomainName");
            String gpoDn = request.getParameter("gpoDn");
            String gpcGuid = request.getParameter("gpcGuid");
            String[] locGuids = request.getParameterValues("locGuid");
            ArrayList<String> selectedGPOs = new ArrayList<String>();
            selectedGPOs.add(gpoDn);
            boolean anyError = false;
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)6057, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
            JSONObject returnMsg = new JSONObject();
            returnMsg.put("overAllMsgType", (Object)"success");
            returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpos_linked_success"));
            JSONArray detailsArr = new JSONArray();
            returnMsg.put("details", (Object)detailsArr);
            Properties locNames = new Properties();
            DomainHandler.updateDomainDatas((String)domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"OU"});
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"NAME"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)locGuids, 8);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            sq.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                it = dataObj.getRows("ADSMOUDetails");
                while (it.hasNext()) {
                    r = (Row)it.next();
                    locNames.put(r.get("OBJECT_GUID"), r.get("NAME"));
                }
            }
            if (locNames.size() < locGuids.length) {
                DomainUtil.updateDomainGuids();
                sq = new SelectQueryImpl(Table.getTable((String)"ADSMDomainConfiguration"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_GUID"));
                sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_GUID"), (Object)locGuids, 8));
                dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Row r2 = dataObj.getRow("ADSMDomainConfiguration");
                    locNames.put(r2.get("DOMAIN_GUID"), r2.get("DOMAIN_NAME"));
                }
                if (locNames.size() < locGuids.length) {
                    sq = new SelectQueryImpl(Table.getTable((String)"ADSMForestSites"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"FOREST_ID"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"OBJECT_GUID"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"SITE_NAME"));
                    sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMForestSites", (String)"OBJECT_GUID"), (Object)locGuids, 8));
                    dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                    if (!dataObj.isEmpty()) {
                        it = dataObj.getRows("ADSMForestSites");
                        while (it.hasNext()) {
                            r = (Row)it.next();
                            locNames.put(r.get("OBJECT_GUID"), r.get("SITE_NAME"));
                        }
                    }
                }
            }
            for (int i = 0; i < locGuids.length; ++i) {
                String curLocGuid = locGuids[i];
                String nativeGuid = curLocGuid.substring(curLocGuid.indexOf("{") + 1, curLocGuid.indexOf("}"));
                Properties results = new Properties();
                try {
                    results = ADHandler.linkGPOs((String)domainName, (Long)loginId, (String)nativeGuid, selectedGPOs);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    results.put("msgtype", "error");
                    results.put("msg", le.getMessage(rb));
                }
                String[] gpoDns = new String[]{gpoDn};
                ArrayList gpoNames = GPOMgmtHandler.getGpoNamesOf((String[])gpoDns);
                JSONObject curDetail = new JSONObject();
                if (results != null) {
                    String msgtype = results.getProperty("msgtype");
                    String msg = results.getProperty("msg");
                    String objName = (String)locNames.get(curLocGuid);
                    curDetail.put("msg", (Object)rb.getString(msg));
                    curDetail.put("msgtype", (Object)msgtype);
                    curDetail.put("objName", (Object)ClientUtil.htmlEscape(objName));
                    detailsArr.put((Object)curDetail);
                    if (msgtype.equals("error")) {
                        anyError = true;
                    }
                } else {
                    anyError = true;
                    curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_some_err_occ"));
                    curDetail.put("msgtype", (Object)"error");
                    curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)locNames.get(curLocGuid)));
                    detailsArr.put((Object)curDetail);
                }
                Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)locNames.get(curLocGuid)), (String)domainName, (DataObject)auditDataObj);
                audit_info.put("object_id", object_id);
                ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
                String gPOString = "";
                for (Properties gpoDetail : gpoNames) {
                    gPOString = gPOString + ", " + gpoDetail.get("DISPLAY_NAME");
                }
                gPOString = gPOString.replaceFirst(", ", "");
                Properties prop = new Properties();
                prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                prop.put("ATTRIB_VALUE", rb.getString("admp.mgmt.gpo_mgmt.link_gpos"));
                modifyAttributeList.add(prop);
                prop = new Properties();
                prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                prop.put("ATTRIB_VALUE", gPOString);
                modifyAttributeList.add(prop);
                TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), gPOString, domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (String)curDetail.get("msg"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                audit_info.put("error_msg", (String)curDetail.get("msg"));
                HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            }
            if (anyError) {
                returnMsg.put("overAllMsgType", (Object)"error");
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_linking_gpos"));
            }
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList allDomInForest = GPOMgmtHandler.getAllDomInForest((String)gpoDomainName);
            ArrayList delegatedDomainNameList = authObject.getDomainNameList();
            ArrayList<String> delegatedDomInForest = new ArrayList<String>();
            for (Properties prop : allDomInForest) {
                if (!delegatedDomainNameList.contains(prop.getProperty("DOMAIN_NAME"))) continue;
                delegatedDomInForest.add(prop.getProperty("DOMAIN_NAME"));
            }
            delegatedDomInForest.add("admp.mgmt.gpo_mgmt.all_sites");
            for (String curdom : delegatedDomInForest) {
                ArrayList gpolinkdetails;
                boolean isSite = false;
                if (curdom.equalsIgnoreCase("admp.mgmt.gpo_mgmt.all_sites")) {
                    isSite = true;
                }
                Properties gpodetails = null;
                try {
                    gpodetails = isSite ? ADHandler.getGPODetails((String)gpoDomainName, (Long)loginId, (String)gpoDn, (int)1, (String)gpoDomainName) : ADHandler.getGPODetails((String)gpoDomainName, (Long)loginId, (String)gpoDn, (int)0, (String)curdom);
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                }
                if (isSite) {
                    GPOMgmtHandler.delfromGpoToLinkedObjs((String)gpcGuid, (String)gpoDomainName, (boolean)isSite);
                } else {
                    GPOMgmtHandler.delfromGpoToLinkedObjs((String)gpcGuid, (String)curdom, (boolean)isSite);
                }
                if (gpodetails == null || gpodetails.get("gpodetails") == null || (gpolinkdetails = (ArrayList)gpodetails.get("gpodetails")).size() <= 0) continue;
                if (isSite) {
                    GPOMgmtHandler.fillGpoToLinkedObjs((ArrayList)gpolinkdetails, (String)gpoDomainName, (String)gpcGuid);
                    continue;
                }
                GPOMgmtHandler.fillGpoToLinkedObjs((ArrayList)gpolinkdetails, (String)curdom, (String)gpcGuid);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(returnMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward manageGPOs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ArrayList<String> authDomList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1815L);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject domActionDetails = new JSONObject();
            String selDomain = DomainUtil.getDefaultDomain();
            if (request.getParameter("selectedDomain") != null) {
                selDomain = request.getParameter("selectedDomain");
            }
            if (!authDomList.contains(selDomain)) {
                selDomain = authDomList.get(0);
            }
            request.setAttribute("selDomain", (Object)selDomain);
            request.setAttribute("allDomains", authDomList);
            ArrayList authDomProps = ClientAuthorizationUtil.getAuthorizedDomainPropList(request, 1817L);
            for (Properties prop : authDomProps) {
                JSONObject actionJson = new JSONObject();
                actionJson.put("site", (Object)ClientAuthorizationUtil.isAuthorized(request, prop.getProperty("DOMAIN_NAME"), (Long)1810L));
                actionJson.put("domainOrOu", (Object)ClientAuthorizationUtil.isAuthorized(request, prop.getProperty("DOMAIN_NAME"), (Long)1809L));
                domActionDetails.put(prop.getProperty("DOMAIN_NAME"), (Object)actionJson);
            }
            request.setAttribute("domActionDetails", (Object)domActionDetails);
            request.setAttribute("range", (Object)NavigateRangeUtil.getDefaultRange((String)"AllGPOs", (Long)loginId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("manageGPOs");
    }

    public ActionForward getAllGpoDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (session.getAttribute("GPOMgmtBean") == null) {
                session.setAttribute("GPOMgmtBean", (Object)new GPOMgmtBean());
            }
            GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
            String selDomain = request.getParameter("domainName");
            Long genId = (Long)gpoMgmtBean.getGenId(selDomain);
            String refresh = request.getParameter("refresh");
            Boolean doRefresh = false;
            if (genId == null || refresh != null) {
                doRefresh = true;
                genId = GPOMgmtHandler.runGpoDetailsReport((String)selDomain);
                gpoMgmtBean.addGenId(selDomain, genId);
            }
            JSONObject navigJson = new JSONObject(request.getParameter("pageNavigation"));
            JSONObject searchJson = null;
            if (request.getParameter("searchDetails") != null) {
                searchJson = new JSONObject(request.getParameter("searchDetails"));
            }
            Properties prop = GPOMgmtHandler.getAllGPODetails((String)selDomain, (Long)genId, (JSONObject)navigJson, (JSONObject)searchJson, (Long)loginId, (AdventNetResourceBundle)rb, (HttpServletRequest)request, (Boolean)doRefresh);
            ArrayList allGpoDetails = (ArrayList)prop.get("allgpodetails");
            request.setAttribute("allGpoDetails", (Object)allGpoDetails);
            request.setAttribute("totalCount", prop.get("totalCount"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("gposList");
    }

    public ActionForward showGPODetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject domActionDetails = new JSONObject();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList allDomInForest = GPOMgmtHandler.getAllDomInForest((String)domainName);
            ArrayList delegatedDomainNameList = authObject.getDomainNameList();
            ArrayList<Properties> delegatedDomInForest = new ArrayList<Properties>();
            for (Properties prop : allDomInForest) {
                if (!delegatedDomainNameList.contains(prop.getProperty("DOMAIN_NAME")) || !ClientAuthorizationUtil.isAuthorized(request, prop.getProperty("DOMAIN_NAME"), (Long)1816L).booleanValue()) continue;
                Properties curProp = new Properties();
                curProp.put("DOMAIN_NAME", prop.getProperty("DOMAIN_NAME"));
                curProp.put("DEFAULT_NAMING_CONTEXT", prop.getProperty("DEFAULT_NAMING_CONTEXT"));
                delegatedDomInForest.add(curProp);
                JSONObject actionJson = new JSONObject();
                actionJson.put("site", (Object)ClientAuthorizationUtil.isAuthorized(request, prop.getProperty("DOMAIN_NAME"), (Long)1810L));
                actionJson.put("domainOrOu", (Object)ClientAuthorizationUtil.isAuthorized(request, prop.getProperty("DOMAIN_NAME"), (Long)1809L));
                domActionDetails.put(prop.getProperty("DEFAULT_NAMING_CONTEXT"), (Object)actionJson);
            }
            if (ClientAuthorizationUtil.isAuthorized(request, domainName, (Long)1810L).booleanValue()) {
                Properties siteProp = new Properties();
                siteProp.put("DOMAIN_NAME", "admp.mgmt.gpo_mgmt.all_sites");
                delegatedDomInForest.add(siteProp);
            }
            request.setAttribute("delegatedDomInForest", delegatedDomInForest);
            request.setAttribute("gpoDomainName", (Object)domainName);
            DataObject data = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMGPODetails", new Criteria(Column.getColumn((String)"ADSMGPODetails", (String)"OBJECT_GUID"), (Object)request.getParameter("gpcGuid"), 0));
            String gpoName = (String)data.getFirstRow("ADSMGPODetails").get("DISPLAY_NAME");
            request.setAttribute("gpoName", (Object)gpoName);
            request.setAttribute("gpoDn", (Object)request.getParameter("gpoDn"));
            request.setAttribute("gpcGuid", (Object)request.getParameter("gpcGuid"));
            request.setAttribute("domActionDetails", (Object)domActionDetails);
            request.setAttribute("range", (Object)NavigateRangeUtil.getDefaultRange((String)"AllGPOs", (Long)loginId));
            ArrayList<Properties> manageOptions = new ArrayList<Properties>();
            String domName = request.getParameter("dispFromDomainName");
            if (domName.equals("All Sites")) {
                domName = domainName;
            }
            if (ClientAuthorizationUtil.isAuthorized(request, domName, (Long)1816L).booleanValue()) {
                Properties prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.enable_links"));
                prop.put("iconName", "icn-enable-md");
                prop.put("onClick", "javascript:GPOMgmt.processLinks('LinkEnable')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.disable_links"));
                prop.put("iconName", "icn-disable-md");
                prop.put("onClick", "javascript:GPOMgmt.processLinks('LinkDisable')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.remove_links"));
                prop.put("iconName", "icn-close-md");
                prop.put("onClick", "javascript:GPOMgmt.processLinks('RemoveLinks')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.enforce"));
                prop.put("iconName", "icn-enforce-md");
                prop.put("onClick", "javascript:GPOMgmt.processLinks('Enforce')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.remove_enforce"));
                prop.put("iconName", "icn-dntenforce-md");
                prop.put("onClick", "javascript:GPOMgmt.processLinks('RemoveEnforce')");
                manageOptions.add(prop);
            }
            request.setAttribute("manageOptions", manageOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("showGPO");
    }

    public ActionForward getLinkedGPOs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONArray objectGuid = new JSONArray(request.getParameter("objectGuid"));
            ArrayList<String> objectList = new ArrayList<String>();
            for (int i = 0; i < objectGuid.length(); ++i) {
                objectList.add(objectGuid.getString(i));
            }
            JSONArray gposArray = new JSONArray();
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"LinkedObjectToGPOs"));
            selectQuery.addSelectColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"LINK_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"GPO_DOMAIN_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"GPO_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"GPO_DN"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"LinkedObjectToGPOs", (String)"LINKED_OBJECT_GUID"), (Object)objectList.toArray(new String[objectList.size()]), 8));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            Iterator it = dataObject.getRows("LinkedObjectToGPOs");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject gpoObject = new JSONObject();
                gpoObject.put("domainName", (Object)((String)r.get("GPO_DOMAIN_NAME")));
                gpoObject.put("dName", (Object)((String)r.get("GPO_NAME")));
                gpoObject.put("gpoDN", (Object)((String)r.get("GPO_DN")));
                gposArray.put((Object)gpoObject);
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(gposArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getGPOLinkedDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String dispFromDomainName;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String fromNative = request.getParameter("fromNative");
            String gpoDomainName = request.getParameter("gpoDomainName");
            String domName = dispFromDomainName = request.getParameter("dispFromDomainName");
            if (dispFromDomainName.equalsIgnoreCase("All Sites")) {
                domName = gpoDomainName;
            }
            String gpoDn = request.getParameter("gpoDn");
            String gpcGuid = request.getParameter("gpcGuid");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (fromNative != null && fromNative.equalsIgnoreCase("true")) {
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                ArrayList allDomInForest = GPOMgmtHandler.getAllDomInForest((String)gpoDomainName);
                ArrayList delegatedDomainNameList = authObject.getDomainNameList();
                ArrayList delegatedDomInForest = new ArrayList();
                GPOMgmtHandler.populateGPOToLinkedObjects((ArrayList)allDomInForest, (ArrayList)delegatedDomainNameList, delegatedDomInForest, (String)gpoDomainName, (Long)loginId, (String)gpoDn, (String)gpcGuid);
            }
            String tableName = "GPOToLinkedObjects";
            ArrayList totalColList = ColumnConfiguration.getTotalColumnList((long)ColumnConfiguration.getDefaultCvId((String)"GPODetails"));
            ArrayList viewColList = ColumnConfiguration.getViewColumnList((long)ColumnConfiguration.getDefaultCvId((String)"GPODetails"));
            ArrayList<Properties> actionItems = new ArrayList<Properties>();
            if (ClientAuthorizationUtil.isAuthorized(request, domName, (Long)1816L).booleanValue()) {
                Properties curActionItem = new Properties();
                curActionItem.put("onClick", "GPOMgmt.changeLinkStatus(this)");
                curActionItem.put("type", "variable");
                ArrayList<Properties> detailProps = new ArrayList<Properties>();
                Properties curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "guid");
                curDetailProp.put("dbColName", "GPO_LINK_OBJECT_GUID");
                detailProps.add(curDetailProp);
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "linkStatus");
                curDetailProp.put("dbColName", "LINK_STATUS");
                detailProps.add(curDetailProp);
                curActionItem.put("details", detailProps);
                curActionItem.put("COL_NAME", "LINK_STATUS");
                curActionItem.put("admp.mgmt.common.text.enabled", "enable-icon");
                curActionItem.put("admp.mgmt.common.text.disabled", "disable-icon");
                curActionItem.put("admp.mgmt.common.text.enabled_toolTip", rb.getString("admp.mgmt.common.text.enabled"));
                curActionItem.put("admp.mgmt.common.text.disabled_toolTip", rb.getString("admp.mgmt.common.text.disabled"));
                actionItems.add(curActionItem);
                curActionItem = new Properties();
                curActionItem.put("onClick", "GPOMgmt.changeEnforceStatus(this)");
                curActionItem.put("type", "variable");
                detailProps = new ArrayList();
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "guid");
                curDetailProp.put("dbColName", "GPO_LINK_OBJECT_GUID");
                detailProps.add(curDetailProp);
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "enforceStatus");
                curDetailProp.put("dbColName", "ENFORCE_STATUS");
                detailProps.add(curDetailProp);
                curActionItem.put("details", detailProps);
                curActionItem.put("COL_NAME", "ENFORCE_STATUS");
                curActionItem.put("admp.mgmt.gpo_mgmt_not_enforced", "dntenforce-icon");
                curActionItem.put("admp.mgmt.gpo_mgmt_enforced", "enforce-icon");
                curActionItem.put("admp.mgmt.gpo_mgmt_not_enforced_toolTip", rb.getString("admp.mgmt.gpo_mgmt_not_enforced"));
                curActionItem.put("admp.mgmt.gpo_mgmt_enforced_toolTip", rb.getString("admp.mgmt.gpo_mgmt_enforced"));
                actionItems.add(curActionItem);
                curActionItem = new Properties();
                curActionItem.put("onClick", "GPOMgmt.removeGPOLink(this)");
                curActionItem.put("type", "const");
                detailProps = new ArrayList();
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "guid");
                curDetailProp.put("dbColName", "GPO_LINK_OBJECT_GUID");
                detailProps.add(curDetailProp);
                curActionItem.put("details", detailProps);
                curActionItem.put("iconName", "close-icon-pop");
                curActionItem.put("toolTip", rb.getString("admp.mgmt.gpo_mgmt.remove_gpo_link"));
                actionItems.add(curActionItem);
            }
            ArrayList<Properties> paramDetails = new ArrayList<Properties>();
            Properties prop = new Properties();
            prop.put("dbColName", "GPO_LINK_OBJECT_GUID");
            prop.put("uiAttrName", "guid");
            paramDetails.add(prop);
            Properties imageColProps = new Properties();
            Properties imgProp = new Properties();
            imgProp.put("IMG_TYPE", "criteriaBased");
            imgProp.put("COL_NAME", "OBJECT_CLASS");
            imgProp.put("site", "gry-building");
            imgProp.put("domainDNS", "gry-server");
            imgProp.put("organizationalUnit", "gry-folder");
            imgProp.put("site_toolTip", rb.getString("admp.mgmt.gpo_mgmt.site"));
            imgProp.put("domainDNS_toolTip", rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.text_domain"));
            imgProp.put("organizationalUnit_toolTip", rb.getString("admp.mgmt.fc_layout_common.text_OU"));
            imageColProps.put("GPO_LINK_OBJECT_NAME", imgProp);
            JSONObject navigJson = new JSONObject(request.getParameter("pageNavigation"));
            JSONObject searchJson = null;
            if (request.getParameter("searchDetails") != null) {
                searchJson = new JSONObject(request.getParameter("searchDetails"));
            }
            boolean applyJoin = false;
            ArrayList ouList = HelpdeskUtil.getOUList((String)domName, (Long)loginId);
            Join splJoin = null;
            if (ouList != null && !ouList.isEmpty()) {
                applyJoin = true;
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"GPOToLinkedObjects"));
            sq.addSelectColumn(Column.getColumn((String)"GPOToLinkedObjects", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"GPOToLinkedObjects", (String)"OBJECT_GUID"), (Object)gpcGuid, 0);
            if (dispFromDomainName.equalsIgnoreCase("All Sites")) {
                crit = crit.and(new Criteria(Column.getColumn((String)"GPOToLinkedObjects", (String)"OBJECT_CLASS"), (Object)"site", 0));
                applyJoin = false;
            } else {
                crit = crit.and(new Criteria(Column.getColumn((String)"GPOToLinkedObjects", (String)"OBJECT_CLASS"), (Object)"site", 1));
            }
            crit = crit.and(new Criteria(Column.getColumn((String)"GPOToLinkedObjects", (String)"DOMAIN_NAME"), (Object)domName, 0));
            if (searchJson != null) {
                Iterator keyIter = searchJson.keys();
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    crit = crit.and(new Criteria(Column.getColumn((String)"GPOToLinkedObjects", (String)key), searchJson.get(key), 12));
                }
            }
            Criteria ouCriteria = null;
            if (applyJoin) {
                crit = crit.and(new Criteria(Column.getColumn((String)"GPOToLinkedObjects", (String)"OBJECT_CLASS"), (Object)"domainDNS", 1));
                Criteria joinCrit = new Criteria(Column.getColumn((String)tableName, (String)"GPO_LINK_OBJECT_GUID"), (Object)Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), 0);
                ouCriteria = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"), ouList.get(0), 11);
                for (int i = 1; i < ouList.size(); ++i) {
                    ouCriteria = ouCriteria.or(new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"), ouList.get(i), 11));
                }
                splJoin = new Join(tableName, "ADSMOUDetails", joinCrit, 2);
                sq.addJoin(splJoin);
            }
            crit = ouCriteria != null ? ouCriteria.and(crit) : crit;
            sq.setCriteria(crit);
            if (navigJson != null) {
                int startIndex = navigJson.getInt("startIndex");
                int numOfObjects = navigJson.getInt("range");
                sq.setRange(new Range(startIndex, numOfObjects));
                if (navigJson.getBoolean("isNewRange")) {
                    NavigateRangeUtil.setDefaultRange((String)"AllGPOs", (int)numOfObjects, (Long)loginId);
                }
            }
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"GPOToLinkedObjects", (String)"GPO_LINK_OBJECT_NAME"), true));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            SelectQueryImpl countQuery = new SelectQueryImpl(Table.getTable((String)"GPOToLinkedObjects"));
            countQuery.addSelectColumn(Column.getColumn((String)"GPOToLinkedObjects", (String)"LINK_ID").count());
            countQuery.setCriteria(crit);
            if (applyJoin) {
                countQuery.addJoin(splJoin);
            }
            int totalCount = DBUtil.getCount((SelectQuery)countQuery);
            ArrayList<Properties> rowDetails = new ArrayList<Properties>();
            Iterator iter = dataObj.getRows(tableName);
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                Properties rowProp = new Properties();
                for (int i = 0; i < totalColList.size(); ++i) {
                    HashMap curColProp = (HashMap)totalColList.get(i);
                    String colName = (String)curColProp.get("COLUMN_NAME");
                    if (r.get(colName) != null) {
                        rowProp.put(colName, r.get(colName));
                        continue;
                    }
                    rowProp.put(colName, "-");
                }
                rowDetails.add(rowProp);
            }
            ArrayList<String> searchCols = new ArrayList<String>();
            searchCols.add("GPO_LINK_OBJECT_NAME");
            searchCols.add("GPO_LINK_OBJ_CANONICAL_NAME");
            request.setAttribute("actionItems", actionItems);
            request.setAttribute("imageColProps", (Object)imageColProps);
            request.setAttribute("totalColList", (Object)totalColList);
            request.setAttribute("viewColList", (Object)viewColList);
            request.setAttribute("rowDetails", rowDetails);
            request.setAttribute("paramDetails", paramDetails);
            request.setAttribute("totalCount", (Object)totalCount);
            request.setAttribute("searchCols", searchCols);
            request.setAttribute("domainName", (Object)gpoDomainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("gpoLinkDetails");
    }

    public ActionForward processGPOLinks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Properties prop;
            ArrayList<Properties> modifyAttributeList;
            Long object_id;
            Hashtable<String, Object> audit_info;
            ArrayList results;
            String domName;
            JSONArray detailsArr;
            JSONObject returnMsg;
            String col;
            String colData;
            String oprtn;
            Long audit_id;
            DataObject auditDataObj;
            String gpoName;
            ArrayList<String> gpoLocGuids;
            String[] arr_locguids;
            String operation;
            String gpoDn;
            String domainName;
            Long loginId;
            AdventNetResourceBundle rb;
            block35: {
                rb = ResourceBundleMgr.getInstance().getBundle(request);
                HttpSession session = request.getSession();
                loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                domainName = request.getParameter("domainName");
                String gpoDomainName = request.getParameter("gpoDomainName");
                gpoDn = request.getParameter("gpoDn");
                String gpcGuid = request.getParameter("gpcGuid");
                operation = request.getParameter("operation");
                arr_locguids = request.getParameterValues("locGuid");
                ArrayList<String> curGpoLdapArrLst = new ArrayList<String>();
                curGpoLdapArrLst.add("LDAP://" + gpoDn);
                gpoLocGuids = new ArrayList<String>(Arrays.asList(arr_locguids));
                gpoName = GPOMgmtUtil.getGPODetails((String)gpcGuid.substring(gpcGuid.indexOf("{") + 1, gpcGuid.indexOf("}"))).getProperty("displayName");
                String hostId = request.getRemoteHost();
                auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)6057, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
                oprtn = null;
                int count = gpoLocGuids.size();
                for (int i = 0; i < count; ++i) {
                    String guid = gpoLocGuids.get(i);
                    String guidStr = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    gpoLocGuids.set(i, guidStr);
                }
                colData = "";
                col = "";
                returnMsg = new JSONObject();
                detailsArr = new JSONArray();
                returnMsg.put("details", (Object)detailsArr);
                returnMsg.put("overAllMsgType", (Object)"success");
                domName = domainName;
                if (domainName.equalsIgnoreCase("All Sites")) {
                    domName = gpoDomainName;
                }
                results = new ArrayList();
                try {
                    if (operation.equals("RemoveLinks")) {
                        results = ADHandler.gpoRemoveLinksFrom((String)domName, (Long)loginId, (String)gpoDn, gpoLocGuids);
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_links_removed_successfully"));
                        break block35;
                    }
                    if (operation.equals("LinkDisable")) {
                        results = ADHandler.gpoLinkDisableInLocs((String)domName, (Long)loginId, curGpoLdapArrLst, gpoLocGuids);
                        colData = "admp.mgmt.common.text.disabled";
                        col = "LINK_STATUS";
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpo_links_disabled_successfully"));
                        oprtn = rb.getString("admp.mgmt.gpo_mgmt.disable_links");
                        break block35;
                    }
                    if (operation.equals("LinkEnable")) {
                        results = ADHandler.gpoLinkEnableInLocs((String)domName, (Long)loginId, curGpoLdapArrLst, gpoLocGuids);
                        colData = "admp.mgmt.common.text.enabled";
                        col = "LINK_STATUS";
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpo_links_are_enabled_success"));
                        oprtn = rb.getString("admp.mgmt.gpo_mgmt.enable_links");
                        break block35;
                    }
                    if (operation.equals("Enforce")) {
                        results = ADHandler.gpoLinkEnforceInLocs((String)domName, (Long)loginId, curGpoLdapArrLst, gpoLocGuids);
                        colData = "admp.mgmt.gpo_mgmt_enforced";
                        col = "ENFORCE_STATUS";
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpo_links_are_enforced_success"));
                        oprtn = rb.getString("admp.mgmt.gpo_mgmt.enforce");
                        break block35;
                    }
                    if (!operation.equals("RemoveEnforce")) break block35;
                    results = ADHandler.gpoLinkRemoveEnforceInLocs((String)domName, (Long)loginId, curGpoLdapArrLst, gpoLocGuids);
                    colData = "admp.mgmt.gpo_mgmt_not_enforced";
                    col = "ENFORCE_STATUS";
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_suc_now_gpolinks_not_enforced"));
                    oprtn = rb.getString("admp.mgmt.gpo_mgmt.remove_enforce");
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    for (String curLocGuid : gpoLocGuids) {
                        Properties curProp = new Properties();
                        curProp.put("msg", le.getMessage(rb));
                        curProp.put("msgtype", "error");
                        curProp.put("locguid", curLocGuid);
                        results.add(curProp);
                    }
                }
            }
            if (results != null && results.size() > 0) {
                JSONObject curDetail;
                int resSize = results.size();
                ArrayList<String> locGuids = new ArrayList<String>();
                ArrayList<String> failedLocGuids = new ArrayList<String>();
                for (int i = 0; i < resSize; ++i) {
                    String msgtype = ((Properties)results.get(i)).getProperty("msgtype");
                    if (msgtype != null && msgtype.equalsIgnoreCase("success")) {
                        locGuids.add("{" + ((Properties)results.get(i)).getProperty("locguid") + "}");
                        continue;
                    }
                    failedLocGuids.add("{" + ((Properties)results.get(i)).getProperty("locguid") + "}");
                }
                if (locGuids.size() > 0) {
                    if (operation.equals("RemoveLinks")) {
                        ArrayList removedLinks = GPOMgmtHandler.getGpoLinkedLocNamesOf((String)gpoDn, locGuids);
                        GPOMgmtHandler.delfromGpoToLinkedObj((String)gpoDn, locGuids);
                        for (Properties p : removedLinks) {
                            curDetail = new JSONObject();
                            curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_rem_link_suc"));
                            curDetail.put("msgtype", (Object)"success");
                            curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)p.get("GPO_LINK_OBJECT_NAME")));
                            detailsArr.put((Object)curDetail);
                            audit_info = new Hashtable();
                            object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)p.get("GPO_LINK_OBJECT_NAME")), (String)domName, (DataObject)auditDataObj);
                            audit_info.put("object_id", object_id);
                            modifyAttributeList = new ArrayList();
                            prop = new Properties();
                            prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                            prop.put("ATTRIB_VALUE", rb.getString("admp.mgmt.gpo_mgmt.remove_links"));
                            modifyAttributeList.add(prop);
                            prop = new Properties();
                            prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                            prop.put("ATTRIB_VALUE", gpoName);
                            modifyAttributeList.add(prop);
                            TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), gpoName, domName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), rb.getString("admp.mgmt.gpo_mgmt_rem_link_suc"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                            audit_info.put("error_msg", rb.getString("admp.mgmt.gpo_mgmt_rem_link_suc"));
                            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                        }
                    } else {
                        GPOMgmtHandler.updateGpoToLinkedObjDet((String)gpoDn, locGuids, (String)col, (String)colData);
                    }
                } else {
                    out.log(Level.INFO, "All locations failed. Operation " + operation + " on all objects " + gpoLocGuids + " might be failed for gpo link: " + gpoDn);
                }
                if (failedLocGuids.size() != 0 && operation.equals("RemoveLinks")) {
                    returnMsg.put("overAllMsgType", (Object)"error");
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_errors_rem_links"));
                    ArrayList unremovedLinks = GPOMgmtHandler.getGpoLinkedLocNamesOf((String)gpoDn, failedLocGuids);
                    for (Properties p : unremovedLinks) {
                        curDetail = new JSONObject();
                        curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_prob_in_rem_gpo_link"));
                        curDetail.put("msgtype", (Object)"error");
                        curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)p.get("GPO_LINK_OBJECT_NAME")));
                        detailsArr.put((Object)curDetail);
                        audit_info = new Hashtable();
                        object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)p.get("GPO_LINK_OBJECT_NAME")), (String)domName, (DataObject)auditDataObj);
                        audit_info.put("object_id", object_id);
                        modifyAttributeList = new ArrayList();
                        prop = new Properties();
                        prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                        prop.put("ATTRIB_VALUE", rb.getString("admp.mgmt.gpo_mgmt.remove_links"));
                        modifyAttributeList.add(prop);
                        prop = new Properties();
                        prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                        prop.put("ATTRIB_VALUE", gpoName);
                        modifyAttributeList.add(prop);
                        TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), gpoName, domName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), rb.getString("admp.mgmt.gpo_mgmt_prob_in_rem_gpo_link"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                        audit_info.put("error_msg", rb.getString("admp.mgmt.gpo_mgmt_prob_in_rem_gpo_link"));
                        HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    }
                }
            } else {
                out.log(Level.INFO, "Operation " + operation + " on all objects " + gpoLocGuids + " might be failed for gpo link: " + gpoDn);
            }
            if (!operation.equals("RemoveLinks")) {
                ArrayList showResults = GPOMgmtHandler.getSelectedGpoToLinkedObjDet((String)gpoDn, (String[])arr_locguids);
                boolean anyError = false;
                for (Properties pr : showResults) {
                    String curLocGuid = pr.getProperty("GPO_LINK_OBJECT_GUID");
                    String msg = "admp.mgmt.common.text.error";
                    String msgtype = "error";
                    if (results != null) {
                        int resSize = results.size();
                        for (int i = 0; i < resSize; ++i) {
                            String thisLocGuid = "{" + ((Properties)results.get(i)).getProperty("locguid") + "}";
                            if (!thisLocGuid.equalsIgnoreCase(curLocGuid)) continue;
                            msgtype = ((Properties)results.get(i)).getProperty("msgtype");
                            msg = ((Properties)results.get(i)).getProperty("msg");
                            results.remove(i);
                            break;
                        }
                    }
                    audit_info = new Hashtable<String, Object>();
                    object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)pr.get("GPO_LINK_OBJECT_NAME")), (String)domName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    modifyAttributeList = new ArrayList<Properties>();
                    prop = new Properties();
                    prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                    prop.put("ATTRIB_VALUE", oprtn);
                    modifyAttributeList.add(prop);
                    prop = new Properties();
                    prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                    prop.put("ATTRIB_VALUE", gpoName);
                    modifyAttributeList.add(prop);
                    if (msgtype.equals("error")) {
                        anyError = true;
                    }
                    JSONObject curDetail = new JSONObject();
                    curDetail.put("msg", (Object)rb.getString(msg));
                    curDetail.put("msgtype", (Object)msgtype);
                    curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)pr.get("GPO_LINK_OBJECT_NAME")));
                    detailsArr.put((Object)curDetail);
                    TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), gpoName, domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), rb.getString(msg), (Long)audit_info.get("object_id"), auditDataObj, rb);
                    audit_info.put("error_msg", rb.getString(msg));
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                if (anyError) {
                    out.log(Level.INFO, "Operation " + operation + " on some / all objects " + gpoLocGuids + " might be failed for gpo link: " + gpoDn);
                    returnMsg.put("overAllMsgType", (Object)"error");
                    if (operation.equals("LinkDisable")) {
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_errors_disabling_links"));
                    } else if (operation.equals("LinkEnable")) {
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_errors_in_enabling_links"));
                    } else if (operation.equals("Enforce")) {
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_enforcing_links"));
                    } else if (operation.equals("RemoveEnforce")) {
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_rem_enforce_of_links"));
                    }
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(returnMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward manageGPOLinks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String objTypesStr;
            HttpSession session = request.getSession();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList<String> authDomList = ClientAuthorizationUtil.getAuthorizedDomainList(request, (Long)1816L);
            JSONObject domActionDetails = new JSONObject();
            String selDomain = DomainUtil.getDefaultDomain();
            if (!authDomList.contains(selDomain)) {
                selDomain = authDomList.get(0);
            }
            if (request.getParameter("domainName") != null) {
                selDomain = request.getParameter("domainName");
            }
            request.setAttribute("domainName", (Object)selDomain);
            ArrayList<String> locNames = new ArrayList<String>();
            ArrayList<Object> objectTypes = new ArrayList();
            boolean locNamesPopulated = false;
            ArrayList ouList = HelpdeskUtil.getOUList((String)selDomain, (Long)loginId);
            if (request.getParameter("curGuids") != null) {
                request.setAttribute("guidsStr", (Object)request.getParameter("curGuids"));
            } else {
                request.setAttribute("guidsStr", (Object)"");
                ArrayList gpoEnabledObjects = ADHandler.getAllGPOEnabledObjects((String)selDomain, (Long)loginId);
                String objGuids = "";
                Boolean ouAndDomainDelegated = ClientAuthorizationUtil.isAuthorized(request, selDomain, (Long)1809L);
                Boolean siteDelegated = ClientAuthorizationUtil.isAuthorized(request, selDomain, (Long)1810L);
                if (ouAndDomainDelegated.booleanValue() || siteDelegated.booleanValue()) {
                    if (gpoEnabledObjects != null) {
                        Properties objProps;
                        int i;
                        if (ouList != null && !ouList.isEmpty()) {
                            for (i = 0; i < gpoEnabledObjects.size(); ++i) {
                                objProps = (Properties)gpoEnabledObjects.get(i);
                                String string = (String)objProps.get("objectClass");
                                String ouDN = (String)objProps.get("dn");
                                if (string.equalsIgnoreCase("organizationalUnit")) {
                                    if (!ouAndDomainDelegated.booleanValue()) continue;
                                    boolean isFound = false;
                                    for (int j = 0; j < ouList.size(); ++j) {
                                        if (!ouDN.endsWith(ouList.get(j).toString())) continue;
                                        isFound = true;
                                        break;
                                    }
                                    if (!isFound) {
                                        continue;
                                    }
                                } else if (string.equalsIgnoreCase("domainDNS") && !ouAndDomainDelegated.booleanValue() || string.equalsIgnoreCase("site") && !siteDelegated.booleanValue()) continue;
                                if (!objGuids.equals("")) {
                                    objGuids = objGuids + ",";
                                }
                                objGuids = objGuids + objProps.get("objGuid");
                                locNames.add((String)objProps.get("name"));
                                objectTypes.add(string);
                                locNamesPopulated = true;
                            }
                        } else {
                            for (i = 0; i < gpoEnabledObjects.size(); ++i) {
                                objProps = (Properties)gpoEnabledObjects.get(i);
                                String string = (String)objProps.get("objectClass");
                                if ((string.equalsIgnoreCase("domainDNS") || string.equalsIgnoreCase("organizationalUnit")) && !ouAndDomainDelegated.booleanValue() || string.equalsIgnoreCase("site") && !siteDelegated.booleanValue()) continue;
                                if (!objGuids.equals("")) {
                                    objGuids = objGuids + ",";
                                }
                                objGuids = objGuids + objProps.get("objGuid");
                                locNames.add((String)objProps.get("name"));
                                objectTypes.add(string);
                                locNamesPopulated = true;
                            }
                        }
                    }
                    request.setAttribute("guidsStr", (Object)objGuids);
                } else {
                    request.setAttribute("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt.sel_loc_to_view_links"));
                }
            }
            ArrayList authDomProps = ClientAuthorizationUtil.getAuthorizedDomainPropList(request, 1816L);
            for (Properties prop : authDomProps) {
                JSONObject actionJson = new JSONObject();
                actionJson.put("site", (Object)ClientAuthorizationUtil.isAuthorized(request, prop.getProperty("DOMAIN_NAME"), (Long)1810L));
                actionJson.put("domainOrOu", (Object)ClientAuthorizationUtil.isAuthorized(request, prop.getProperty("DOMAIN_NAME"), (Long)1809L));
                domActionDetails.put(prop.getProperty("DEFAULT_NAMING_CONTEXT"), (Object)actionJson);
            }
            request.setAttribute("domainPropList", (Object)authDomProps);
            request.setAttribute("domActionDetails", (Object)domActionDetails);
            ArrayList<Properties> manageOptions = new ArrayList<Properties>();
            if (ClientAuthorizationUtil.isAuthorized(request, selDomain, (Long)1816L).booleanValue()) {
                Properties prop;
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.enable_links"));
                prop.put("iconName", "icn-enable-md");
                prop.put("onClick", "javascript:GPOMgmt.manageGPOLinks('LinkEnable')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.disable_links"));
                prop.put("iconName", "icn-disable-md");
                prop.put("onClick", "javascript:GPOMgmt.manageGPOLinks('LinkDisable')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.remove_links"));
                prop.put("iconName", "icn-close-md");
                prop.put("onClick", "javascript:GPOMgmt.manageGPOLinks('RemoveLinks')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("isSeparator", "true");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.enforce"));
                prop.put("iconName", "icn-enforce-md");
                prop.put("onClick", "javascript:GPOMgmt.manageGPOLinks('Enforce')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.remove_enforce"));
                prop.put("iconName", "icn-dntenforce-md");
                prop.put("onClick", "javascript:GPOMgmt.manageGPOLinks('RemoveEnforce')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("isSeparator", "true");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.block_inheritance"));
                prop.put("iconName", "icn-disable-enforce-md");
                prop.put("onClick", "javascript:GPOMgmt.manageGPOLinks('BlockInheritance')");
                manageOptions.add(prop);
                prop = new Properties();
                prop.put("uiText", rb.getString("admp.mgmt.gpo_mgmt.unblock_inheritance"));
                prop.put("iconName", "icn-enable-enforce-md");
                prop.put("onClick", "javascript:GPOMgmt.manageGPOLinks('UnblockInheritance')");
                manageOptions.add(prop);
            }
            request.setAttribute("manageOptions", manageOptions);
            request.setAttribute("range", (Object)NavigateRangeUtil.getDefaultRange((String)"AllGPOs", (Long)loginId));
            ArrayList<Object> currentlyViewingGuids = new ArrayList();
            String guidsStr = (String)request.getAttribute("guidsStr");
            if (guidsStr.length() > 0) {
                String[] arr = guidsStr.split(",");
                currentlyViewingGuids = new ArrayList<String>(Arrays.asList(arr));
                if (!locNamesPopulated) {
                    for (String string : currentlyViewingGuids) {
                        locNames.add(request.getParameter(string));
                    }
                }
            }
            if ((objTypesStr = request.getParameter("objectTypes")) != null && objTypesStr.length() > 0) {
                String[] arr = objTypesStr.split(",");
                objectTypes = new ArrayList<String>(Arrays.asList(arr));
            }
            request.setAttribute("currentlyViewingGuids", currentlyViewingGuids);
            request.setAttribute("locNames", locNames);
            request.setAttribute("objectTypes", objectTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("manageGPOLinks");
    }

    public ActionForward displayLinks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String[] arr_locguids = request.getParameterValues("locGuid");
            String curDomainName = request.getParameter("curDomainName");
            String fromNative = request.getParameter("fromNative");
            if (arr_locguids.length > 0 && fromNative != null && fromNative.equalsIgnoreCase("false") && !GPOMgmtHandler.isLinkedObjToGposAvailable((String[])arr_locguids).booleanValue()) {
                fromNative = "true";
            }
            if (fromNative != null && fromNative.equalsIgnoreCase("true")) {
                ArrayList<String> locGuids = new ArrayList<String>(Arrays.asList(arr_locguids));
                int count = locGuids.size();
                for (int i = 0; i < count; ++i) {
                    String guid = locGuids.get(i);
                    String guidStr = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    locGuids.set(i, guidStr);
                }
                ArrayList allDomInForest = GPOMgmtHandler.getAllDomInForest((String)curDomainName);
                Properties domDetails = new Properties();
                for (Properties prop : allDomInForest) {
                    Properties curDomDetails = HDTDomainHandler.getConfiguredValues((String)((String)prop.get("DOMAIN_NAME")), (Long)loginId);
                    domDetails.put(curDomDetails.get("DEFAULT_NAMING_CONTEXT"), curDomDetails);
                }
                for (int i = 0; i < locGuids.size(); ++i) {
                    ArrayList algpodetails;
                    String guidOfCurLoc = locGuids.get(i);
                    Properties gpodetails = ADHandler.getLinkedGPODetails((String)curDomainName, (Long)loginId, (String)guidOfCurLoc, (Properties)domDetails);
                    GPOMgmtHandler.delfromLinkedObjToGpos((String)("{" + guidOfCurLoc + "}"));
                    if (gpodetails == null || gpodetails.get("Results") == null || (algpodetails = (ArrayList)gpodetails.get("Results")).size() <= 0) continue;
                    String objClass = "";
                    String objName = "";
                    if (gpodetails.getProperty("objClass") != null) {
                        objClass = gpodetails.getProperty("objClass");
                    }
                    if (gpodetails.getProperty("objName") != null) {
                        objName = gpodetails.getProperty("objName");
                    }
                    GPOMgmtHandler.fillLinkedObjToGpos((String)("{" + guidOfCurLoc + "}"), (ArrayList)algpodetails, (String)rb.getString(gpodetails.getProperty("blkInher")), (String)objClass, (String)objName);
                }
            }
            ArrayList details = GPOMgmtHandler.getLinkedObjToGpos((String[])arr_locguids, null);
            String tableName = "LinkedObjectToGPOs";
            ArrayList totalColList = ColumnConfiguration.getTotalColumnList((long)ColumnConfiguration.getDefaultCvId((String)"ManageGPOLinks"));
            ArrayList viewColList = ColumnConfiguration.getViewColumnList((long)ColumnConfiguration.getDefaultCvId((String)"ManageGPOLinks"));
            ArrayList<Properties> actionItems = new ArrayList<Properties>();
            if (ClientAuthorizationUtil.isAuthorized(request, curDomainName, (Long)1816L).booleanValue()) {
                Properties curActionItem = new Properties();
                curActionItem.put("onClick", "GPOMgmt.manageLinkStatus(this)");
                curActionItem.put("type", "variable");
                ArrayList<Properties> detailProps = new ArrayList<Properties>();
                Properties curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "guid");
                curDetailProp.put("dbColName", "LINKED_OBJECT_GUID");
                detailProps.add(curDetailProp);
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "gpoDn");
                curDetailProp.put("dbColName", "GPO_DN");
                detailProps.add(curDetailProp);
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "linkStatus");
                curDetailProp.put("dbColName", "LINK_STATUS");
                detailProps.add(curDetailProp);
                curActionItem.put("details", detailProps);
                curActionItem.put("COL_NAME", "LINK_STATUS");
                curActionItem.put("admp.mgmt.common.text.enabled", "enable-icon");
                curActionItem.put("admp.mgmt.common.text.disabled", "disable-icon");
                curActionItem.put("admp.mgmt.common.text.enabled_toolTip", rb.getString("admp.mgmt.common.text.enabled"));
                curActionItem.put("admp.mgmt.common.text.disabled_toolTip", rb.getString("admp.mgmt.common.text.disabled"));
                actionItems.add(curActionItem);
                curActionItem = new Properties();
                curActionItem.put("onClick", "GPOMgmt.manageEnforceStatus(this)");
                curActionItem.put("type", "variable");
                detailProps = new ArrayList();
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "guid");
                curDetailProp.put("dbColName", "LINKED_OBJECT_GUID");
                detailProps.add(curDetailProp);
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "gpoDn");
                curDetailProp.put("dbColName", "GPO_DN");
                detailProps.add(curDetailProp);
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "enforceStatus");
                curDetailProp.put("dbColName", "ENFORCE_STATUS");
                detailProps.add(curDetailProp);
                curActionItem.put("details", detailProps);
                curActionItem.put("COL_NAME", "ENFORCE_STATUS");
                curActionItem.put("admp.mgmt.gpo_mgmt_not_enforced", "dntenforce-icon");
                curActionItem.put("admp.mgmt.gpo_mgmt_enforced", "enforce-icon");
                curActionItem.put("admp.mgmt.gpo_mgmt_not_enforced_toolTip", rb.getString("admp.mgmt.gpo_mgmt_not_enforced"));
                curActionItem.put("admp.mgmt.gpo_mgmt_enforced_toolTip", rb.getString("admp.mgmt.gpo_mgmt_enforced"));
                actionItems.add(curActionItem);
                curActionItem = new Properties();
                curActionItem.put("onClick", "GPOMgmt.manageGPOLink(this)");
                curActionItem.put("type", "const");
                detailProps = new ArrayList();
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "guid");
                curDetailProp.put("dbColName", "LINKED_OBJECT_GUID");
                detailProps.add(curDetailProp);
                curDetailProp = new Properties();
                curDetailProp.put("uiAttrName", "gpoDn");
                curDetailProp.put("dbColName", "GPO_DN");
                detailProps.add(curDetailProp);
                curActionItem.put("details", detailProps);
                curActionItem.put("iconName", "close-icon-pop");
                curActionItem.put("toolTip", rb.getString("admp.mgmt.gpo_mgmt.remove_gpo_link"));
                actionItems.add(curActionItem);
            }
            ArrayList<Properties> paramDetails = new ArrayList<Properties>();
            Properties prop = new Properties();
            prop.put("dbColName", "LINKED_OBJECT_GUID");
            prop.put("uiAttrName", "guid");
            paramDetails.add(prop);
            prop = new Properties();
            prop.put("dbColName", "GPO_DN");
            prop.put("uiAttrName", "gpoDn");
            paramDetails.add(prop);
            prop = new Properties();
            prop.put("dbColName", "LINKED_OBJECT_CLASS");
            prop.put("uiAttrName", "objClass");
            paramDetails.add(prop);
            prop = new Properties();
            prop.put("dbColName", "GPO_NAME");
            prop.put("uiAttrName", "gpoName");
            paramDetails.add(prop);
            Properties imageColProps = new Properties();
            Properties imgProp = new Properties();
            imgProp.put("IMG_TYPE", "criteriaBased");
            imgProp.put("COL_NAME", "LINKED_OBJECT_CLASS");
            imgProp.put("site", "gry-building");
            imgProp.put("domainDNS", "gry-server");
            imgProp.put("organizationalUnit", "gry-folder");
            imgProp.put("site_toolTip", rb.getString("admp.mgmt.gpo_mgmt.site"));
            imgProp.put("domainDNS_toolTip", rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.text_domain"));
            imgProp.put("organizationalUnit_toolTip", rb.getString("admp.mgmt.fc_layout_common.text_OU"));
            imageColProps.put("LINKED_OBJECT_NAME", imgProp);
            JSONObject navigJson = new JSONObject(request.getParameter("pageNavigation"));
            JSONObject searchJson = null;
            if (request.getParameter("searchDetails") != null) {
                searchJson = new JSONObject(request.getParameter("searchDetails"));
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"LinkedObjectToGPOs"));
            sq.addSelectColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"LinkedObjectToGPOs", (String)"LINKED_OBJECT_GUID"), (Object)arr_locguids, 8, false);
            if (searchJson != null) {
                Iterator keyIter = searchJson.keys();
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    crit = crit.and(new Criteria(Column.getColumn((String)"LinkedObjectToGPOs", (String)key), searchJson.get(key), 12));
                }
            }
            sq.setCriteria(crit);
            if (navigJson != null) {
                int startIndex = navigJson.getInt("startIndex");
                int numOfObjects = navigJson.getInt("range");
                sq.setRange(new Range(startIndex, numOfObjects));
                if (navigJson.getBoolean("isNewRange")) {
                    NavigateRangeUtil.setDefaultRange((String)"AllGPOs", (int)numOfObjects, (Long)loginId);
                }
            }
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"LINKED_OBJECT_NAME"), true));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"LINK_PRIORITY"), false));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            SelectQueryImpl countQuery = new SelectQueryImpl(Table.getTable((String)"LinkedObjectToGPOs"));
            countQuery.addSelectColumn(Column.getColumn((String)"LinkedObjectToGPOs", (String)"LINK_ID").count());
            countQuery.setCriteria(crit);
            int totalCount = DBUtil.getCount((SelectQuery)countQuery);
            ArrayList<Properties> rowDetails = new ArrayList<Properties>();
            Iterator iter = dataObj.getRows(tableName);
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                Properties rowProp = new Properties();
                for (int i = 0; i < totalColList.size(); ++i) {
                    HashMap curColProp = (HashMap)totalColList.get(i);
                    String colName = (String)curColProp.get("COLUMN_NAME");
                    if (r.get(colName) != null) {
                        rowProp.put(colName, r.get(colName));
                        continue;
                    }
                    rowProp.put(colName, "-");
                }
                rowDetails.add(rowProp);
            }
            ArrayList<String> searchCols = new ArrayList<String>();
            searchCols.add("LINKED_OBJECT_NAME");
            searchCols.add("GPO_NAME");
            searchCols.add("GPO_DOMAIN_NAME");
            request.setAttribute("actionItems", actionItems);
            request.setAttribute("imageColProps", (Object)imageColProps);
            request.setAttribute("totalColList", (Object)totalColList);
            request.setAttribute("viewColList", (Object)viewColList);
            request.setAttribute("rowDetails", rowDetails);
            request.setAttribute("paramDetails", paramDetails);
            request.setAttribute("searchCols", searchCols);
            request.setAttribute("totalCount", (Object)totalCount);
            request.setAttribute("domainName", (Object)curDomainName);
        }
        catch (LocalizedException le) {
            request.setAttribute("msg", (Object)le.getMessage(rb));
            request.setAttribute("totalCount", (Object)0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("gpoLinkDetails");
    }

    public ActionForward manageLinks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String domainName = request.getParameter("domainName");
            String details = request.getParameter("details");
            String operation = request.getParameter("operation");
            JSONArray linkDetArr = new JSONArray(details);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject returnMsg = new JSONObject();
            JSONArray detailsArr = new JSONArray();
            returnMsg.put("details", (Object)detailsArr);
            returnMsg.put("overAllMsgType", (Object)"success");
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)6057, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
            String oprtn = null;
            String colData = "";
            String col = "";
            boolean anyError = false;
            if (operation.equals("LinkDisable")) {
                colData = "admp.mgmt.common.text.disabled";
                col = "LINK_STATUS";
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpo_links_disabled_successfully"));
                oprtn = rb.getString("admp.mgmt.gpo_mgmt.disable_links");
            } else if (operation.equals("LinkEnable")) {
                colData = "admp.mgmt.common.text.enabled";
                col = "LINK_STATUS";
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpo_links_are_enabled_success"));
                oprtn = rb.getString("admp.mgmt.gpo_mgmt.enable_links");
            } else if (operation.equals("Enforce")) {
                colData = "admp.mgmt.gpo_mgmt_enforced";
                col = "ENFORCE_STATUS";
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpo_links_are_enforced_success"));
                oprtn = rb.getString("admp.mgmt.gpo_mgmt.enforce");
            } else if (operation.equals("RemoveEnforce")) {
                colData = "admp.mgmt.gpo_mgmt_not_enforced";
                col = "ENFORCE_STATUS";
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_suc_now_gpolinks_not_enforced"));
                oprtn = rb.getString("admp.mgmt.gpo_mgmt.remove_enforce");
            } else if (operation.equals("BlockInheritance")) {
                colData = "admp.mgmt.gpo_mgmt_blocked";
                col = "GPO_INHERITANCE_STATUS";
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt.blocked_gpo_inher_successfully"));
                oprtn = rb.getString("admp.mgmt.gpo_mgmt.block_inheritance");
            } else if (operation.equals("UnblockInheritance")) {
                colData = "admp.mgmt.gpo_mgmt_not_blocked";
                col = "GPO_INHERITANCE_STATUS";
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt.unblocked_gpo_inher_successfully"));
                oprtn = rb.getString("admp.mgmt.gpo_mgmt.unblock_inheritance");
            }
            ArrayList<String> locGuids = new ArrayList<String>();
            ArrayList<String> failedLocGuids = new ArrayList<String>();
            for (int j = 0; j < linkDetArr.length(); ++j) {
                JSONObject curDetail;
                String errmsg;
                ArrayList<Properties> modifyAttributeList;
                Hashtable<String, Object> audit_info;
                ArrayList<String> gpoLdaps;
                String locName;
                String curLocGuid;
                ArrayList results;
                block57: {
                    results = null;
                    JSONObject jsonObj = linkDetArr.getJSONObject(j);
                    curLocGuid = jsonObj.getString("locGuid");
                    String curLocNativeGuid = curLocGuid.substring(curLocGuid.indexOf("{") + 1, curLocGuid.indexOf("}"));
                    String gpoDn = jsonObj.getString("gpoDn");
                    locName = GPOMgmtHandler.getLinkedObjLocName((String)curLocGuid);
                    gpoLdaps = new ArrayList<String>();
                    gpoLdaps.add("LDAP://" + gpoDn);
                    audit_info = new Hashtable<String, Object>();
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)locName, (String)domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    modifyAttributeList = new ArrayList<Properties>();
                    errmsg = null;
                    if (operation.equals("BlockInheritance") || operation.equals("UnblockInheritance")) {
                        Properties resProp = null;
                        try {
                            resProp = operation.equals("UnblockInheritance") ? ADHandler.gpoInheritance((String)domainName, (Long)loginId, (String)curLocNativeGuid, (int)0) : ADHandler.gpoInheritance((String)domainName, (Long)loginId, (String)curLocNativeGuid, (int)1);
                        }
                        catch (LocalizedException le) {
                            le.printStackTrace();
                            resProp = new Properties();
                            resProp.put("msgtype", "error");
                            resProp.put("msg", le.getMessage(rb));
                        }
                        if (resProp != null && resProp.get("msgtype") != null) {
                            if (resProp.getProperty("msgtype").equals("success")) {
                                locGuids.add(curLocGuid);
                            } else {
                                failedLocGuids.add(curLocGuid);
                                anyError = true;
                            }
                            JSONObject curDetail2 = new JSONObject();
                            curDetail2.put("msg", (Object)rb.getString(resProp.getProperty("msg")));
                            curDetail2.put("msgtype", (Object)resProp.getProperty("msgtype"));
                            curDetail2.put("objName", (Object)ClientUtil.htmlEscape(locName));
                            detailsArr.put((Object)curDetail2);
                            Properties prop = new Properties();
                            prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                            prop.put("ATTRIB_VALUE", oprtn);
                            modifyAttributeList.add(prop);
                            TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), locName, domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), rb.getString(resProp.getProperty("msg")), (Long)audit_info.get("object_id"), auditDataObj, rb);
                            audit_info.put("error_msg", rb.getString(resProp.getProperty("msg")));
                            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                            continue;
                        }
                        anyError = true;
                        out.log(Level.INFO, "Block / Unblock GPO inheritance Failed for obj: " + curLocNativeGuid);
                        continue;
                    }
                    try {
                        if (operation.equals("RemoveLinks")) {
                            results = ADHandler.gpoLinkRemove((String)domainName, (Long)loginId, (String)curLocNativeGuid, gpoLdaps);
                            break block57;
                        }
                        if (operation.equals("LinkDisable")) {
                            results = ADHandler.gpoLinkDisable((String)domainName, (Long)loginId, (String)curLocNativeGuid, gpoLdaps);
                            break block57;
                        }
                        if (operation.equals("LinkEnable")) {
                            results = ADHandler.gpoLinkEnable((String)domainName, (Long)loginId, (String)curLocNativeGuid, gpoLdaps);
                            break block57;
                        }
                        if (operation.equals("Enforce")) {
                            results = ADHandler.gpoLinkEnforce((String)domainName, (Long)loginId, (String)curLocNativeGuid, gpoLdaps);
                            break block57;
                        }
                        if (!operation.equals("RemoveEnforce")) break block57;
                        results = ADHandler.gpoLinkRemoveEnforce((String)domainName, (Long)loginId, (String)curLocNativeGuid, gpoLdaps);
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        results = new ArrayList();
                        for (String curLdap : gpoLdaps) {
                            Properties curProp = new Properties();
                            curProp.put("gpoldap", curLdap);
                            curProp.put("msgtype", "error");
                            curProp.put("msg", le.getMessage(rb));
                            results.add(curProp);
                        }
                    }
                }
                if (results != null && results.size() > 0) {
                    Properties prop;
                    int resSize = results.size();
                    ArrayList<String> gpoDns = new ArrayList<String>();
                    ArrayList<String> failedGpoDns = new ArrayList<String>();
                    for (int i = 0; i < resSize; ++i) {
                        String msgtype = ((Properties)results.get(i)).getProperty("msgtype");
                        if (msgtype != null && msgtype.equalsIgnoreCase("success")) {
                            gpoDns.add(((Properties)results.get(i)).getProperty("gpoldap").substring(7));
                            continue;
                        }
                        failedGpoDns.add(((Properties)results.get(i)).getProperty("gpoldap").substring(7));
                        anyError = true;
                    }
                    if (gpoDns.size() > 0) {
                        if (operation.equals("RemoveLinks")) {
                            returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_links_removed_successfully"));
                            ArrayList removedLinks = GPOMgmtHandler.getLinkedObjToGpoNamesOf((String)curLocGuid, gpoDns);
                            GPOMgmtHandler.delfromLinkedObjToGpos((String)curLocGuid, gpoDns);
                            for (Properties p : removedLinks) {
                                curDetail = new JSONObject();
                                curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_rem_link_suc"));
                                curDetail.put("msgtype", (Object)"success");
                                curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)p.get("LINKED_OBJECT_NAME")));
                                detailsArr.put((Object)curDetail);
                                prop = new Properties();
                                prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                                prop.put("ATTRIB_VALUE", rb.getString("admp.mgmt.gpo_mgmt.remove_links"));
                                modifyAttributeList.add(prop);
                                prop = new Properties();
                                prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                                prop.put("ATTRIB_VALUE", p.get("GPO_NAME"));
                                modifyAttributeList.add(prop);
                                errmsg = rb.getString("admp.mgmt.gpo_mgmt_rem_link_suc");
                            }
                        } else {
                            GPOMgmtHandler.updateLinkedObjToGpos((String)curLocGuid, gpoDns, (String)col, (String)colData);
                        }
                    }
                    if (failedGpoDns.size() != 0 && operation.equals("RemoveLinks")) {
                        returnMsg.put("overAllMsgType", (Object)"error");
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_unable_to_rem_some_gpo_links"));
                        ArrayList unremovedLinks = GPOMgmtHandler.getLinkedObjToGpoNamesOf((String)curLocGuid, failedGpoDns);
                        for (Properties p : unremovedLinks) {
                            curDetail = new JSONObject();
                            curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_prob_in_rem_gpo_link"));
                            curDetail.put("msgtype", (Object)"error");
                            curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)p.get("LINKED_OBJECT_NAME")));
                            detailsArr.put((Object)curDetail);
                            prop = new Properties();
                            prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                            prop.put("ATTRIB_VALUE", rb.getString("admp.mgmt.gpo_mgmt.remove_links"));
                            modifyAttributeList.add(prop);
                            prop = new Properties();
                            prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                            prop.put("ATTRIB_VALUE", p.get("GPO_NAME"));
                            modifyAttributeList.add(prop);
                            errmsg = rb.getString("admp.mgmt.gpo_mgmt_prob_in_rem_gpo_link");
                        }
                    }
                } else {
                    anyError = true;
                    out.log(Level.INFO, "Operation " + operation + " on obj " + curLocGuid + " might be failed: " + gpoLdaps);
                    errmsg = rb.getString("admp.mgmt.gpo_mgmt_unable_to_do_the_req_operation");
                    JSONObject curDetail3 = new JSONObject();
                    curDetail3.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_unable_to_do_the_req_operation"));
                    curDetail3.put("msgtype", (Object)"error");
                    curDetail3.put("objName", (Object)ClientUtil.htmlEscape(locName));
                    detailsArr.put((Object)curDetail3);
                }
                if (!operation.equals("RemoveLinks")) {
                    gpoLdaps.set(0, ((String)gpoLdaps.get(0)).substring(7));
                    ArrayList showResults = GPOMgmtHandler.getSelectedLinkedObjToGpoDet((String)curLocGuid, gpoLdaps);
                    for (Properties pr : showResults) {
                        String curGpoDn = pr.getProperty("GPO_DN");
                        String msg = "admp.mgmt.common.text.error";
                        String msgtype = "error";
                        if (results != null) {
                            int resSize = results.size();
                            for (int i = 0; i < resSize; ++i) {
                                String thisGpoDn = ((Properties)results.get(i)).getProperty("gpoldap").substring(7);
                                if (!thisGpoDn.equalsIgnoreCase(curGpoDn)) continue;
                                msgtype = ((Properties)results.get(i)).getProperty("msgtype");
                                msg = ((Properties)results.get(i)).getProperty("msg");
                                results.remove(i);
                                break;
                            }
                        }
                        if (msgtype.equals("error")) {
                            anyError = true;
                        }
                        curDetail = new JSONObject();
                        curDetail.put("msg", (Object)rb.getString(msg));
                        curDetail.put("msgtype", (Object)msgtype);
                        curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)pr.get("LINKED_OBJECT_NAME")));
                        detailsArr.put((Object)curDetail);
                        Properties p = new Properties();
                        p.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                        p.put("ATTRIB_VALUE", oprtn);
                        modifyAttributeList.add(p);
                        p = new Properties();
                        p.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                        p.put("ATTRIB_VALUE", pr.get("GPO_NAME"));
                        modifyAttributeList.add(p);
                        errmsg = rb.getString(msg);
                    }
                }
                TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), locName, domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), errmsg, (Long)audit_info.get("object_id"), auditDataObj, rb);
                audit_info.put("error_msg", errmsg);
                HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            }
            if ((operation.equals("BlockInheritance") || operation.equals("UnblockInheritance")) && locGuids.size() > 0) {
                GPOMgmtHandler.updateBlockInheritanceInfo(locGuids, (String)col, (String)colData);
            }
            if (anyError) {
                returnMsg.put("overAllMsgType", (Object)"error");
                if (operation.equals("LinkDisable")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_errors_disabling_links"));
                } else if (operation.equals("LinkEnable")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_errors_in_enabling_links"));
                } else if (operation.equals("Enforce")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_enforcing_links"));
                } else if (operation.equals("RemoveEnforce")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_rem_enforce_of_links"));
                } else if (operation.equals("BlockInheritance")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_block_inherit"));
                } else if (operation.equals("UnblockInheritance")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_unblock_inherit"));
                } else if (operation.equals("RemoveLinks")) {
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_unable_to_rem_some_gpo_links"));
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(returnMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getGPOs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            GPOMgmtBean gpoMgmtBean;
            Long genId;
            HttpSession session = request.getSession();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String showGposFromDom = request.getParameter("showGposFromDom");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList domainNameList = authObject.getDomainNameList();
            String searchText = request.getParameter("searchText");
            request.setAttribute("showGposFromDom", (Object)showGposFromDom);
            request.setAttribute("searchText", (Object)request.getParameter("searchText"));
            ArrayList allDomInForest = GPOMgmtHandler.getAllDomInForest((String)showGposFromDom);
            ArrayList<String> gpoDelegatedDomains = new ArrayList<String>();
            for (Properties p : allDomInForest) {
                if (!domainNameList.contains(p.getProperty("DOMAIN_NAME"))) continue;
                gpoDelegatedDomains.add(p.getProperty("DOMAIN_NAME"));
            }
            request.setAttribute("gpoDelegatedDomains", gpoDelegatedDomains);
            if (session.getAttribute("GPOMgmtBean") == null) {
                session.setAttribute("GPOMgmtBean", (Object)new GPOMgmtBean());
            }
            if ((genId = (Long)(gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean")).getGenId(showGposFromDom)) == null) {
                genId = GPOMgmtHandler.runGpoDetailsReport((String)showGposFromDom);
                gpoMgmtBean.addGenId(showGposFromDom, genId);
            }
            ArrayList gpos = GPOMgmtHandler.getAllGPODetails((String)showGposFromDom, (Long)genId, (String)searchText, (AdventNetResourceBundle)rb);
            request.setAttribute("gpolist", (Object)gpos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("getGpos");
    }

    public ActionForward linkObjectsToGpos(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Row r;
            Iterator it;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            String[] locGuids = request.getParameterValues("locGuid");
            String[] gpoDns = request.getParameterValues("selectedGpoDn");
            ArrayList<String> selectedGPOs = new ArrayList<String>(Arrays.asList(gpoDns));
            boolean anyError = false;
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)6057, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
            JSONObject returnMsg = new JSONObject();
            returnMsg.put("overAllMsgType", (Object)"success");
            returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_gpos_linked_success"));
            JSONArray detailsArr = new JSONArray();
            returnMsg.put("details", (Object)detailsArr);
            Properties locNames = new Properties();
            DomainHandler.updateDomainDatas((String)domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"OU"});
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"NAME"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)locGuids, 8);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            sq.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                it = dataObj.getRows("ADSMOUDetails");
                while (it.hasNext()) {
                    r = (Row)it.next();
                    locNames.put(r.get("OBJECT_GUID"), r.get("NAME"));
                }
            }
            if (locNames.size() < locGuids.length) {
                DomainUtil.updateDomainGuids();
                sq = new SelectQueryImpl(Table.getTable((String)"ADSMDomainConfiguration"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"));
                sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_GUID"));
                sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_GUID"), (Object)locGuids, 8));
                dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Row r2 = dataObj.getRow("ADSMDomainConfiguration");
                    locNames.put(r2.get("DOMAIN_GUID"), r2.get("DOMAIN_NAME"));
                }
                if (locNames.size() < locGuids.length) {
                    sq = new SelectQueryImpl(Table.getTable((String)"ADSMForestSites"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"FOREST_ID"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"OBJECT_GUID"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"SITE_NAME"));
                    sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMForestSites", (String)"OBJECT_GUID"), (Object)locGuids, 8));
                    dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                    if (!dataObj.isEmpty()) {
                        it = dataObj.getRows("ADSMForestSites");
                        while (it.hasNext()) {
                            r = (Row)it.next();
                            locNames.put(r.get("OBJECT_GUID"), r.get("SITE_NAME"));
                        }
                    }
                }
            }
            String firstGpoDn = selectedGPOs.get(0);
            String gpoDomainName = (String)DomainInfoCache.getInstance().getDefaultNamingContextVsDomainName().get(firstGpoDn.substring(firstGpoDn.indexOf("DC=")));
            ArrayList validGpos = new ArrayList();
            ArrayList inValidGpos = new ArrayList();
            try {
                ADHandler.getValidGPOsList((String)gpoDomainName, (Long)CommonUtil.ADMIN_LOGIN_ID, selectedGPOs, validGpos, inValidGpos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList invalidGPOProps = GPOMgmtHandler.getGpoNamesOf((String[])inValidGpos.toArray(new String[inValidGpos.size()]));
            String invalidGpoNames = "";
            if (invalidGPOProps != null) {
                for (Properties gpoDetail : invalidGPOProps) {
                    invalidGpoNames = invalidGpoNames + ", " + gpoDetail.get("DISPLAY_NAME");
                }
                invalidGpoNames = invalidGpoNames.replaceFirst(", ", "");
            }
            for (int i = 0; i < locGuids.length; ++i) {
                String curLocGuid = locGuids[i];
                String nativeGuid = curLocGuid.substring(curLocGuid.indexOf("{") + 1, curLocGuid.indexOf("}"));
                Properties results = null;
                try {
                    if (validGpos.size() > 0) {
                        results = ADHandler.linkGPOs((String)domainName, (Long)loginId, (String)nativeGuid, validGpos);
                    }
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    results.put("msgtype", "error");
                    results.put("msg", le.getMessage(rb));
                }
                ArrayList gpoNames = GPOMgmtHandler.getGpoNamesOf((String[])validGpos.toArray(new String[validGpos.size()]));
                JSONObject curDetail = new JSONObject();
                if (results != null) {
                    String msgtype = results.getProperty("msgtype");
                    String msg = results.getProperty("msg");
                    String objName = (String)locNames.get(curLocGuid);
                    curDetail.put("msg", (Object)rb.getString(msg));
                    curDetail.put("msgtype", (Object)msgtype);
                    curDetail.put("objName", (Object)ClientUtil.htmlEscape(objName));
                    detailsArr.put((Object)curDetail);
                    if (msgtype.equals("error")) {
                        anyError = true;
                    }
                } else {
                    anyError = true;
                    curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_some_err_occ"));
                    curDetail.put("msgtype", (Object)"error");
                    curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)locNames.get(curLocGuid)));
                    detailsArr.put((Object)curDetail);
                    if (validGpos.size() == 0) {
                        curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_selected_gpos_not_found"));
                    }
                }
                Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)((String)locNames.get(curLocGuid)), (String)domainName, (DataObject)auditDataObj);
                audit_info.put("object_id", object_id);
                ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
                String gPOString = "";
                if (gpoNames != null) {
                    for (Properties gpoDetail : gpoNames) {
                        gPOString = gPOString + ", " + gpoDetail.get("DISPLAY_NAME");
                    }
                    gPOString = gPOString.replaceFirst(", ", "");
                }
                Properties prop = new Properties();
                prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                prop.put("ATTRIB_VALUE", rb.getString("admp.mgmt.gpo_mgmt.link_gpos"));
                modifyAttributeList.add(prop);
                prop = new Properties();
                prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.gpo_name"));
                String auditGpoString = "";
                if (gpoNames != null) {
                    auditGpoString = gPOString;
                }
                if (invalidGPOProps != null && invalidGPOProps.size() > 0) {
                    auditGpoString = !auditGpoString.equals("") ? auditGpoString + " [" + rb.getString("admp.mgmt.gpo_mgmt.unavailable_gpos") + " : " + invalidGpoNames + "]" : rb.getString("admp.mgmt.gpo_mgmt.unavailable_gpos") + " : " + invalidGpoNames;
                }
                prop.put("ATTRIB_VALUE", auditGpoString);
                modifyAttributeList.add(prop);
                TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), gPOString, domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (String)curDetail.get("msg"), (Long)audit_info.get("object_id"), auditDataObj, rb);
                audit_info.put("error_msg", (String)curDetail.get("msg"));
                HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            }
            if (anyError) {
                returnMsg.put("overAllMsgType", (Object)"error");
                returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt_there_are_err_in_linking_gpos"));
            }
            if (inValidGpos.size() > 0) {
                if (validGpos.size() == 0) {
                    returnMsg.put("overAllMsgType", (Object)"error");
                    returnMsg.put("overAllMsg", (Object)(rb.getString("admp.mgmt.gpo_mgmt_selected_gpos_not_found") + " - " + invalidGpoNames));
                } else {
                    returnMsg.put("overAllMsg", (Object)(returnMsg.get("overAllMsg") + " [" + rb.getString("admp.mgmt.gpo_mgmt_some_gpos_not_found") + " - " + invalidGpoNames + "]"));
                }
                GPOMgmtHandler.deleteInvalidGPOs((String[])inValidGpos.toArray(new String[inValidGpos.size()]));
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(returnMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getFolderDetailsJson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject json = GPOMgmtUtil.getFolderDetailsJson();
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward createGPO(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String gpoName = request.getParameter("gpoName");
            String domainName = request.getParameter("domainName");
            String hostId = request.getRemoteHost();
            Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String[] locGuids = request.getParameterValues("locGuid");
            JSONObject returnMsg = GPOMgmtUtil.createGPO((String)domainName, (Long)loginId, (String)hostId, (String)gpoName, (AdventNetResourceBundle)rb);
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)11003, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)gpoName, (String)domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
            Properties gpoDetails = (Properties)returnMsg.remove("gpoDetails");
            if (returnMsg.getString("overAllMsgType").equals("success") && locGuids != null && locGuids.length > 0) {
                if (gpoDetails.get("ldapGpoDn") != null) {
                    Row r;
                    Iterator it;
                    String ldapGpoDn;
                    Properties prop = new Properties();
                    prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.operation"));
                    prop.put("ATTRIB_VALUE", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.create_gpo"));
                    modifyAttributeList.add(prop);
                    String gpoDn = ldapGpoDn = gpoDetails.getProperty("ldapGpoDn");
                    if (gpoDn.startsWith("LDAP://")) {
                        gpoDn = gpoDn.substring(7);
                    }
                    ArrayList<String> selectedGPOs = new ArrayList<String>();
                    selectedGPOs.add(gpoDn);
                    boolean anyError = false;
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt.gpo_created_and_linked_to_selected_places"));
                    JSONArray detailsArr = new JSONArray();
                    returnMsg.put("details", (Object)detailsArr);
                    Properties locNames = new Properties();
                    DomainHandler.updateDomainDatas((String)domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"OU"});
                    SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"));
                    sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"NAME"));
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)locGuids, 8);
                    crit = crit.and(new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                    sq.setCriteria(crit);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                    if (!dataObj.isEmpty()) {
                        it = dataObj.getRows("ADSMOUDetails");
                        while (it.hasNext()) {
                            r = (Row)it.next();
                            locNames.put(r.get("OBJECT_GUID"), r.get("NAME"));
                        }
                    }
                    if (locNames.size() < locGuids.length) {
                        DomainUtil.updateDomainGuids();
                        sq = new SelectQueryImpl(Table.getTable((String)"ADSMDomainConfiguration"));
                        sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"));
                        sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_GUID"));
                        sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_GUID"), (Object)locGuids, 8));
                        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                        if (!dataObj.isEmpty()) {
                            Row r2 = dataObj.getRow("ADSMDomainConfiguration");
                            locNames.put(r2.get("DOMAIN_GUID"), r2.get("DOMAIN_NAME"));
                        }
                        if (locNames.size() < locGuids.length) {
                            sq = new SelectQueryImpl(Table.getTable((String)"ADSMForestSites"));
                            sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"FOREST_ID"));
                            sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"OBJECT_GUID"));
                            sq.addSelectColumn(Column.getColumn((String)"ADSMForestSites", (String)"SITE_NAME"));
                            sq.setCriteria(new Criteria(Column.getColumn((String)"ADSMForestSites", (String)"OBJECT_GUID"), (Object)locGuids, 8));
                            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                            if (!dataObj.isEmpty()) {
                                it = dataObj.getRows("ADSMForestSites");
                                while (it.hasNext()) {
                                    r = (Row)it.next();
                                    locNames.put(r.get("OBJECT_GUID"), r.get("SITE_NAME"));
                                }
                            }
                        }
                    }
                    StringBuffer auditLocNames = new StringBuffer();
                    for (int i = 0; i < locGuids.length; ++i) {
                        String curLocGuid = locGuids[i];
                        String nativeGuid = curLocGuid.substring(curLocGuid.indexOf("{") + 1, curLocGuid.indexOf("}"));
                        Properties results = new Properties();
                        try {
                            results = ADHandler.linkGPOs((String)domainName, (Long)loginId, (String)nativeGuid, selectedGPOs);
                        }
                        catch (LocalizedException le) {
                            le.printStackTrace();
                            results.put("msgtype", "error");
                            results.put("msg", le.getMessage(rb));
                        }
                        if (results != null) {
                            String msgtype = results.getProperty("msgtype");
                            String msg = results.getProperty("msg");
                            String objName = (String)locNames.get(curLocGuid);
                            JSONObject curDetail = new JSONObject();
                            curDetail.put("msg", (Object)rb.getString(msg));
                            curDetail.put("msgtype", (Object)msgtype);
                            curDetail.put("objName", (Object)ClientUtil.htmlEscape(objName));
                            detailsArr.put((Object)curDetail);
                            if (msgtype.equals("error")) {
                                anyError = true;
                            }
                        } else {
                            anyError = true;
                            JSONObject curDetail = new JSONObject();
                            curDetail.put("msg", (Object)rb.getString("admp.mgmt.gpo_mgmt_some_err_occ"));
                            curDetail.put("msgtype", (Object)"error");
                            curDetail.put("objName", (Object)ClientUtil.htmlEscape((String)locNames.get(curLocGuid)));
                            detailsArr.put((Object)curDetail);
                        }
                        if (i == 0) {
                            auditLocNames.append(locNames.get(curLocGuid));
                            continue;
                        }
                        auditLocNames.append(", " + locNames.get(curLocGuid));
                    }
                    if (anyError) {
                        returnMsg.put("overAllMsgType", (Object)"error");
                        returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt.gpo_created_and_some_error_in_linking_to_sel_places"));
                    }
                    prop = new Properties();
                    prop.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.gpo_mgmt.link_to"));
                    prop.put("ATTRIB_VALUE", auditLocNames);
                    modifyAttributeList.add(prop);
                } else {
                    returnMsg.put("overAllMsgType", (Object)"error");
                    returnMsg.put("overAllMsg", (Object)rb.getString("admp.mgmt.gpo_mgmt.gpo_created_but_error_in_linking_to_sel_places"));
                }
                returnMsg.put("overAllStatusMsg", returnMsg.get("overAllMsg"));
            }
            TechAuditAPI.getInstance().auditObjectModification(loginId, rb.getString("admp.mgmt.license.license_restriction.gpo"), rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.manage_gpos"), gpoName, domainName, modifyAttributeList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), returnMsg.get("overAllStatusMsg").toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
            audit_info.put("error_msg", returnMsg.get("overAllStatusMsg"));
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(returnMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getSubFolderDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            GPOMgmtBean gpoMgmtBean = (GPOMgmtBean)session.getAttribute("GPOMgmtBean");
            JSONArray jsonArr = GPOMgmtUtil.getSubFolderDetails((Long)Long.valueOf(request.getParameter("folderId")), (GPOMgmtBean)gpoMgmtBean);
            PrintWriter writer = null;
            response.setContentType("application/json");
            writer = response.getWriter();
            JSONObject obj = new JSONObject();
            obj.put("nodes", (Object)jsonArr);
            writer.print(obj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

