/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs;

import de.laures.cewolf.ChartPostProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.TextTitle;

public class ADMPChartPostProcessor
implements ChartPostProcessor {
    public static String chartType = "";

    public synchronized void processChart(Object chart, Map params) {
        JFreeChart jfc = (JFreeChart)chart;
        Plot plot = jfc.getPlot();
        if (plot instanceof CategoryPlot) {
            this.setCategoryPlotProps(jfc, plot, params);
        } else if (plot instanceof PiePlot) {
            this.setPiePlotProps(jfc, plot, params);
        }
    }

    private void setCategoryPlotProps(JFreeChart jfc, Plot plot, Map params) {
        TextTitle title = jfc.getTitle();
        if (chartType.endsWith("ja") || chartType.endsWith("zh")) {
            title.setFont(new Font("Sans-serif", 1, 12));
        } else {
            title.setFont(new Font("Verdana", 1, 9));
        }
        String titleText = title.getText();
        CategoryPlot cPlot = (CategoryPlot)plot;
        cPlot.setBackgroundAlpha(0.5f);
        cPlot.setForegroundAlpha(0.8f);
        CategoryAxis domainAxis = cPlot.getDomainAxis();
        domainAxis.setCategoryMargin(0.08);
        cPlot.setRangeGridlinesVisible(true);
        CategoryItemRenderer ciRenderer = cPlot.getRenderer();
        if (chartType.startsWith("userReports")) {
            ciRenderer.setSeriesPaint(0, (Paint)new Color(51, 147, 216));
            ciRenderer.setSeriesPaint(1, (Paint)new Color(231, 82, 31));
            ciRenderer.setSeriesPaint(2, (Paint)new Color(236, 207, 4));
            ciRenderer.setSeriesPaint(3, (Paint)new Color(82, 176, 51));
            ciRenderer.setSeriesPaint(4, (Paint)new Color(251, 148, 11));
        } else if (chartType.startsWith("systemReports")) {
            ciRenderer.setSeriesPaint(0, (Paint)new Color(51, 147, 216));
            ciRenderer.setSeriesPaint(1, (Paint)new Color(231, 82, 31));
            ciRenderer.setSeriesPaint(2, (Paint)new Color(236, 207, 4));
            ciRenderer.setSeriesPaint(3, (Paint)new Color(82, 176, 51));
        } else if (chartType.startsWith("otherReports")) {
            ciRenderer.setSeriesPaint(0, (Paint)new Color(51, 147, 216));
            ciRenderer.setSeriesPaint(1, (Paint)new Color(231, 82, 31));
            ciRenderer.setSeriesPaint(2, (Paint)new Color(236, 207, 4));
            ciRenderer.setSeriesPaint(3, (Paint)new Color(82, 176, 51));
        }
        NumberAxis rangeAxis = (NumberAxis)cPlot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxis rAxis = cPlot.getRangeAxis();
        rangeAxis.setLabelFont(new Font("Verdana", 0, 12));
        domainAxis.setLabelFont(new Font("Verdana", 0, 12));
    }

    private void setPiePlotProps(JFreeChart jfc, Plot plot, Map params) {
        PiePlot pPlot = (PiePlot)plot;
        TextTitle title = jfc.getTitle();
        String titleText = title.getText();
        pPlot.setSectionOutlinePaint((Paint)Color.white);
        ((PiePlot3D)pPlot).setDepthFactor(0.25);
        pPlot.setStartAngle(271.0);
        ((PiePlot3D)jfc.getPlot()).setInteriorGap(0.2);
        pPlot.setLabelFont(new Font("Verdana", 0, 10));
        pPlot.setOutlinePaint((Paint)Color.white);
        jfc.setBackgroundPaint((Paint)Color.white);
        if (titleText.equalsIgnoreCase("User Reports")) {
            pPlot.setSectionPaint(0, (Paint)new Color(127, 127, 255));
            pPlot.setSectionPaint(1, (Paint)new Color(245, 80, 47));
            pPlot.setSectionPaint(2, (Paint)new Color(127, 127, 127));
            pPlot.setSectionPaint(3, (Paint)new Color(140, 130, 166));
            pPlot.setSectionPaint(4, (Paint)new Color(242, 102, 73));
        } else if (titleText.equalsIgnoreCase("System Reports")) {
            pPlot.setSectionPaint(0, (Paint)new Color(147, 94, 255));
            pPlot.setSectionPaint(1, (Paint)new Color(208, 101, 30));
            pPlot.setSectionPaint(2, (Paint)new Color(31, 195, 189));
            pPlot.setSectionPaint(3, (Paint)new Color(218, 56, 151));
        } else if (titleText.equalsIgnoreCase("Other Reports")) {
            pPlot.setSectionPaint(0, (Paint)new Color(150, 162, 51));
            pPlot.setSectionPaint(1, (Paint)new Color(31, 143, 185));
            pPlot.setSectionPaint(2, (Paint)new Color(112, 152, 220));
            pPlot.setSectionPaint(3, (Paint)new Color(255, 51, 51));
        }
        pPlot.setLabelGenerator(null);
    }

    public static void setValueForParam(String param, String value) {
        chartType = value;
    }
}

