/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.reports.SchedulerAction;
import com.manageengine.ads.fw.i18n.I18NUtil;
import com.manageengine.ads.fw.layout.ComponentDataProvider;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class GraphDataProvider
implements ComponentDataProvider {
    private boolean isDataAvailable = false;

    public boolean isDataAvailable() {
        return this.isDataAvailable;
    }

    public JSONObject getDataModel(HttpServletRequest request, JSONObject dataModel) {
        try {
            JSONObject graphModel = this.getGraphModel(dataModel.getLong("containerId"));
            String domainName = dataModel.getString("domainName");
            JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
            if (domainDetails.length() != 0) {
                domainName = domainDetails.getString("DOMAIN_NAME");
            }
            graphModel.put("GRAPH_TYPE", (Object)dataModel.getString("type"));
            graphModel.put("DOMAIN_NAME", (Object)domainName);
            graphModel.put("DURATION", (Object)dataModel.getString("duration"));
            graphModel.put("USER_ID", dataModel.getLong("userId"));
            graphModel.put("LOCALE", dataModel.has("locale") ? dataModel.get("locale") : null);
            if (dataModel.has("isRefreshed")) {
                graphModel.put("isRefreshed", dataModel.getBoolean("isRefreshed"));
            }
            dataModel.put("GRAPH_MODEL", (Object)graphModel);
            dataModel.put("GRAPH_DATA", (Object)this.getGraphData(graphModel, request));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataModel;
    }

    private JSONObject getGraphData(JSONObject graphModel, HttpServletRequest request) {
        JSONObject graphData = new JSONObject();
        JSONObject graphReportCounts = new JSONObject();
        JSONObject graphReportURLs = new JSONObject();
        JSONObject graphNames = new JSONObject();
        JSONObject graphIds = new JSONObject();
        JSONObject graphOrder = new JSONObject();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String userName = request.getParameter("userName");
        String loggedInDomainName = null;
        String isProductUser = request.getParameter("isProductUser");
        try {
            Long loginId;
            ArrayList roleIdList;
            boolean showReports;
            if (graphModel.has("LOCALE")) {
                rb = ResourceBundleMgr.getInstance().getResourceBundle(I18NUtil.getLocale((String)graphModel.getString("LOCALE")));
            }
            if (request.getParameter("domainName") == null) {
                Credential credential = AuthUtil.getUserCredential();
                if (credential != null) {
                    loggedInDomainName = credential.getDomainName();
                    userName = credential.getLoginName();
                }
            } else if ("true".equalsIgnoreCase(isProductUser)) {
                loggedInDomainName = "ADManager Plus Authentication";
            } else {
                JSONObject domainProperties = DomainHandler.getDomainDetails((String)request.getParameter("domainName"));
                loggedInDomainName = domainProperties.getString("DOMAIN_FLAT_NAME");
            }
            if (userName == null || userName.equals("")) {
                userName = "admin";
                loggedInDomainName = "ADManager Plus Authentication";
            }
            if (showReports = HelpdeskUtil.isReportsTabDelegated((ArrayList)(roleIdList = HelpdeskUtil.getHelpdeskRoleList((Long)(loginId = CommonUtil.getLoginId((String)userName, (String)loggedInDomainName)))), (Long)loginId)) {
                Hashtable hash;
                Hashtable h;
                String domainName = graphModel.getString("DOMAIN_NAME");
                String graphName = graphModel.getString("GRAPH_NAME");
                graphData.put("DOMAIN_NAME", (Object)domainName);
                graphData.put("LOGIN_ID", (Object)loginId);
                graphData.put("isProductUser", (Object)isProductUser);
                if (graphModel.has("isRefreshed") && graphModel.getBoolean("isRefreshed")) {
                    SchedulerAction.refreshGraph(domainName, loginId, graphName);
                }
                if ((h = (Hashtable)(hash = ReportHandler.getDailyReportResults((String)domainName, (Long)loginId)).get(domainName)) != null) {
                    Properties genId = (Properties)h.get("generationIds");
                    Properties count = (Properties)h.get("count");
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSDataProvider", (String)"GRAPH_ID"), (Object)graphModel.getString("GRAPH_ID"), 0);
                    DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSDataProvider", criteria);
                    if (!dO.isEmpty()) {
                        Iterator it = dO.getRows("ADSDataProvider");
                        while (it.hasNext()) {
                            Row r = (Row)it.next();
                            String reportUrl = (String)r.get("URL");
                            String directUrl = (String)r.get("DIRECT_URL");
                            String reportName = (String)r.get("REPORT_NAME");
                            String url = CommonUtil.getFQPURL((String)directUrl, (HttpServletRequest)request);
                            reportUrl = reportUrl.replace("${UR}", url);
                            reportUrl = reportUrl.replace("${GID}", genId.containsKey(reportName) ? ((Long)genId.get(reportName)).toString() : "null");
                            reportUrl = reportUrl.replace("${DN}", domainName);
                            graphReportURLs.put(r.get("PRIORITY_ID").toString(), (Object)reportUrl);
                            graphReportCounts.put(r.get("PRIORITY_ID").toString(), count.containsKey(reportName) ? (Integer)count.get(reportName) : 0);
                            if (count.containsKey(reportName)) {
                                this.isDataAvailable = true;
                            }
                            graphNames.put(r.get("PRIORITY_ID").toString(), (Object)rb.getString((String)r.get("DISPLAY_NAME")));
                            graphIds.put(r.get("PRIORITY_ID").toString(), r.get("REPORT_ID"));
                            graphOrder.put(r.get("PRIORITY_ID").toString(), (Object)r.get("PRIORITY_ID").toString());
                        }
                    }
                }
                graphData.put("REPORT_COUNTS", (Object)graphReportCounts);
                graphData.put("REPORT_URLS", (Object)graphReportURLs);
                graphData.put("REPORT_DISPLAY_NAMES", (Object)graphNames);
                graphData.put("REPORT_IDS", (Object)graphIds);
                graphData.put("REPORT_ORDER", (Object)graphOrder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphData;
    }

    private JSONObject getGraphModel(Long graphId) {
        JSONObject graphModel = new JSONObject();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSGraphs", (String)"GRAPH_ID"), (Object)graphId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSGraphs", c);
            Row graphRow = dO.getRow("ADSGraphs");
            List columns = graphRow.getColumns();
            for (String col : columns) {
                graphModel.put(col, graphRow.get(col));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphModel;
    }
}

