/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.GroupUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserAction;
import com.adventnet.sym.adsm.common.webclient.groups.CSVGroupBean;
import com.adventnet.sym.adsm.common.webclient.groups.CSVGroupsListener;
import com.adventnet.sym.adsm.common.webclient.groups.GroupMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;

public class CSVGroupAction
extends CSVUserAction {
    public ActionForward bulkGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(this.bulkGroup(form, request, response, GroupUserHandler.getInstance()));
    }

    public String bulkGroup(ActionForm form, HttpServletRequest request, HttpServletResponse response, GroupUserHandler userHandler) {
        String forward = "bulkUser";
        try {
            CSVGroupBean bean = (CSVGroupBean)form;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String init = request.getParameter("init");
            if (init != null && init.equals("true")) {
                if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.BULK_GROUP_CREATION_ACTION_ID).booleanValue()) {
                    return null;
                }
                bean.init(request);
                this.init(bean, loginId);
            }
            String operation = (String)bean.get("operation");
            Integer range = (Integer)bean.get("RANGE");
            Long startIndex = (Long)bean.get("FROM_INDEX");
            Long count = null;
            String isNavigate = request.getParameter("isNavigate");
            if (isNavigate != null && isNavigate.equals("false")) {
                bean.setRange(loginId);
            }
            if (operation.equals("Create")) {
                String domainName;
                if (((String)bean.get("containsOU")).equalsIgnoreCase("true") && (domainName = request.getParameter("domainName")) != null) {
                    request.getSession().setAttribute("userCreationDomain", (Object)domainName);
                    if (((String)bean.get("isGroupType")).equalsIgnoreCase("true")) {
                        bean.set("groupType", request.getParameter("groupType"));
                        bean.set("groupScope", request.getParameter("groupScope"));
                    }
                    bean.set("domainName", domainName);
                }
                if (((String)bean.get("isGroupType")).equalsIgnoreCase("true")) {
                    Integer groupType = GroupMgmtUtil.getGroupType(bean);
                    Hashtable groupTypeProps = this.getTypeProps(groupType);
                    request.setAttribute("groupTypeProps", (Object)groupTypeProps);
                } else {
                    request.setAttribute("groupTypeProps", (Object)((Hashtable)bean.get("groupTypeProps")));
                }
                bean.addGroups(request);
                CSVGroupsListener listener = (CSVGroupsListener)bean.getListener();
                if (!listener.isCompleted()) {
                    listener.setWriter(response.getWriter());
                    request.setAttribute("listener", (Object)listener);
                }
                ArrayList userDetailsList = (ArrayList)request.getAttribute("userDetailsList");
                count = new Long(userDetailsList.size());
                this.init(bean, loginId);
                forward = "modifyResult";
            } else if (operation.equals("ShowResult")) {
                ArrayList userDetailsList = userHandler.getUserDetailsList((Long)bean.get("userCreationID"), (ArrayList)bean.get("resultAttributeList"), (int)startIndex.longValue(), range.intValue(), null);
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID")).intValue());
                request.setAttribute("userDetailsList", (Object)userDetailsList);
                forward = "modifyResult";
            } else if (operation.equalsIgnoreCase("Stop")) {
                CSVGroupsListener listener = (CSVGroupsListener)bean.getListener();
                if (!listener.isCompleted()) {
                    listener.stop();
                }
                ArrayList userDetailsList = userHandler.getUserDetailsList((Long)bean.get("userCreationID"), (ArrayList)bean.get("resultAttributeList"), (int)startIndex.longValue(), range.intValue(), null);
                request.setAttribute("userDetailsList", (Object)userDetailsList);
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID")).intValue());
                forward = "modifyResult";
            } else if (operation.equalsIgnoreCase("ReCreate")) {
                bean.reCreateList(request);
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID")).intValue());
            } else {
                count = new Long(userHandler.getCount((Long)bean.get("userCreationID")).intValue());
            }
            request.setAttribute("count", (Object)count);
            request.setAttribute("domainList", (Object)HDTDomainHandler.getConfiguredList((Long)loginId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return forward;
    }

    @Override
    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            CSVGroupBean userBean = (CSVGroupBean)form;
            HttpSession session = request.getSession();
            String sessionID = session.getId();
            String domainName = (String)userBean.get("domainName");
            Properties p = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
            String defaultNamingContext = p.getProperty("DEFAULT_NAMING_CONTEXT");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = "CN=Users," + defaultNamingContext;
            if (ouList.size() > 0) {
                containerName = (String)ouList.get(0);
            }
            Long userCreationID = GroupUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, null, loginId);
            userBean.set("userCreationID", userCreationID);
            request.setAttribute("isCreation", (Object)"true");
            ArrayList customAttributesList = new ArrayList();
            FormFile formFile = (FormFile)userBean.get("browse");
            ArrayList userDetailsList = this.csvImport(request, userBean, (AddUserHandler)GroupUserHandler.getInstance(), customAttributesList);
            if (userDetailsList != null) {
                ArrayList attributeList = (ArrayList)userBean.get("attributeList");
                if (!userDetailsList.isEmpty()) {
                    GroupUserHandler.getInstance().addUserDetailsList(userCreationID, userDetailsList, attributeList, customAttributesList);
                }
                Integer count = GroupUserHandler.getInstance().getCount(userCreationID);
                request.setAttribute("count", (Object)new Long(count.intValue()));
                if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                    DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.mgmt", (String)"admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_groups", (Integer)ReportsUtil.BULK_GROUP_CREATION_REPORT_ID, (String)"-", (Boolean)Boolean.TRUE, (String)formFile.getFileName(), (String)"csv", (String)"-", (Integer)count);
                }
            }
        }
        catch (DataAccessException dAE) {
            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("client.groups.CSVGroupAction.db_error_occured_please_check_the_LDAP_attribute_names_their_values_in_the_CSV_file")));
            dAE.printStackTrace();
        }
        catch (Exception e) {
            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("client.groups.CSVGroupAction.unknown_error_occured_please_check_the_LDAP_attribute_names_their_values_in_the_CSV_file")));
            e.printStackTrace();
        }
        return mapping.findForward("bulkUser");
    }

    @Override
    public ActionForward getUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ArrayList attributeList;
            HttpSession session = request.getSession();
            CSVGroupBean bean = (CSVGroupBean)form;
            String operation = (String)bean.get("operation");
            if (operation.equals("UpdateColumns")) {
                bean.updateColumns(request);
            }
            if ((attributeList = (ArrayList)bean.get("attributeList")) == null) {
                attributeList = new ArrayList();
            }
            Integer range = (Integer)bean.get("RANGE");
            Long startIndex = (Long)bean.get("FROM_INDEX");
            ArrayList userDetailsList = GroupUserHandler.getInstance().getUserDetailsList((Long)bean.get("userCreationID"), attributeList, (int)startIndex.longValue(), range.intValue(), null);
            int attribSize = 0;
            attribSize = attributeList.size();
            request.setAttribute("attribSize", (Object)attribSize);
            request.setAttribute("userDetailsList", (Object)userDetailsList);
            request.setAttribute("customAttributes", (Object)AddUserHandler.getInstance().getCustomAttributesList((Long)bean.get("userCreationID")));
            if (userDetailsList.isEmpty()) {
                request.setAttribute("listEmpty", (Object)"true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("userDetails");
    }

    @Override
    public ActionForward modifyAttribute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean saveFlag = true;
        CSVGroupBean userBean = (CSVGroupBean)form;
        try {
            String index = request.getParameter("index");
            String attribute = request.getParameter("attribute");
            String value = request.getParameter("value");
            ArrayList attributeList = (ArrayList)userBean.get("attributeList");
            Hashtable attributeDetails = GroupUserHandler.getInstance().getAttributeDetails(attribute, attributeList);
            String tableName = (String)attributeDetails.get("AU_TABLE_NAME");
            Long actionId = (Long)attributeDetails.get("ACTION_ID");
            HttpSession session = request.getSession();
            String domainName = (String)userBean.get("domainName");
            if (actionId == null || ClientUtil.checkAuthorization(request, domainName, (long)actionId)) {
                Long longIndex = new Long(index);
                UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
                Criteria criteria = new Criteria(new Column(tableName, "USER_INDEX"), (Object)longIndex, 0);
                updateQuery.setCriteria(criteria);
                updateQuery.setUpdateColumn(attribute, (Object)value);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
            }
        }
        catch (Exception e) {
            saveFlag = false;
            e.printStackTrace();
        }
        if (saveFlag) {
            ClientUtil.setStatusXMLElement(response, "Success", "");
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward selectContainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        if (domainName != null) {
            CSVGroupBean bean = (CSVGroupBean)form;
            request.getSession().setAttribute("userCreationDomain", (Object)domainName);
            if (((String)bean.get("isGroupType")).equalsIgnoreCase("true")) {
                bean.set("groupType", request.getParameter("groupType"));
                bean.set("groupScope", request.getParameter("groupScope"));
            }
            bean.set("domainName", domainName);
        }
        return mapping.findForward("selectContainer");
    }

    public Hashtable getTypeProps(Integer value) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            hash.put("DATA_HANDLER_TYPE", 7L);
            hash.put("ATTRIB_VALUE", String.valueOf(value));
            hash.put("ATTRIB_VALUE_COUNT", new Long(1L));
            hash.put("ATTRIB_LDAP_NAME", "groupType");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    private void init(CSVGroupBean bean, Long loginId) {
        bean.set("RANGE", NavigateRangeUtil.getDefaultRange((String)"CSVModification", (Long)loginId));
        bean.set("PAGE_NUMBER", "1");
        bean.set("FROM_INDEX", new Long(1L));
    }
}

