/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.groups.ModifyGroupListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;

public class DeleteGroupsListener
extends ModifyGroupListener {
    public DeleteGroupsListener() {
        this.reportId = new Integer(4003);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            logger.log(Level.INFO, "Calling Modify User in the DeleteGroupsListener");
            try {
                String sid = this.getValue(result, 2023);
                String dn = this.getValue(result, 2003);
                if (HelpdeskUtil.isExcludedGroup((String)dn, (ArrayList)this.groupExcludeList) || !HelpdeskUtil.isAuthorizedGroup((String)dn, (ArrayList)this.groupIncludeList)) {
                    message.append(this.rb.getString("groupmanagement.messages.not_authorized_group"));
                } else {
                    dn = CommonUtil.escapeDN((String)dn);
                    ModifyGroupListener listener = (ModifyGroupListener)bean.getListener();
                    logger.log(Level.INFO, "Starts deleting the user,Sid: " + sid + "dn: " + dn);
                    ADHandler.deleteGroup((String)domainName, (Long)loginId, (String)dn);
                    GroupHandler.deleteGroup((String)domainName, (Long)loginId, (String)dn);
                    message.append(this.rb.getString("client.groups.DeleteGroupListener.successfully_deleted"));
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("client.groups.DeleteGroupListener.unable_to_delete_the_group") + " " + le.getMessage(this.rb));
                if (le.getErrorMsgList().contains("80071392")) {
                    message = new StringBuffer(this.rb.getString("client.groups.DeleteGroupListener.unable_to_delete_the_group") + " " + this.rb.getString("client.groups.DeleteGroupListener.primary_group_for_users"));
                }
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.groups.DeleteGroupListener.unable_to_delete_the_group") + " " + e.getMessage());
            }
            TechAuditAPI.getInstance().auditDeleteGroup(loginId, this.rb.getString("admp.mgmt.grp_mgmt.del_grps.mgmtname.del_grps"), this.getValue(result, 2001), domainName, message.toString(), this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }
}

