/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class GroupErrorHandler {
    public static Properties getBulkGroupErrorMessage(String domainName, ArrayList groupList, NativeError errHdlr, String objectName, String containerName, AdventNetResourceBundle rb) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        if (errHdlr.getErrorMessage((Object)domainName, rb) != null) {
            message = errHdlr.getErrorMessage((Object)domainName, rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)domainName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)objectName, rb) != null) {
            message = errHdlr.getErrorMessage((Object)objectName, rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)objectName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)containerName, rb) != null) {
            message = errHdlr.getErrorMessage((Object)containerName, rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)containerName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : groupList) {
            if (errHdlr.getErrorMessage(object, rb) == null) continue;
            messageBuilder.append(errHdlr.getErrorMessage(object, rb));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", rb.getString("admp.mgmt.grp_mgmt.cre_single_grp.warning.successfully_created_group") + messageBuilder.toString());
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", "admp.mgmt.grp_mgmt.cre_single_grp.text.successfully_created_group");
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public static String handleModifyGroupError(ArrayList<Hashtable> modifyGroupErrorMsgList, int totalCount, AdventNetResourceBundle rb, ArrayList removeGroupList, String primaryGroup, String operation, int failCount) {
        StringBuilder statusMessage = new StringBuilder();
        ArrayList<String> messageList = new ArrayList<String>();
        int counter = 0;
        if (modifyGroupErrorMsgList != null && !modifyGroupErrorMsgList.isEmpty()) {
            for (Hashtable hashtable : modifyGroupErrorMsgList) {
                String errorCode;
                String message = (String)hashtable.get("NATIVE_ERROR_MESSAGE");
                if (!messageList.contains(message)) {
                    messageList.add(message);
                    if (hashtable.get("ERROR_CODE") == null || hashtable.get("ERROR_CODE").equals("0")) continue;
                    errorCode = (String)hashtable.get("ERROR_CODE");
                    if (errorCode.equals("80071392")) {
                        ++counter;
                    } else {
                        statusMessage.append(rb.getString((String)hashtable.get("ERROR_MESSAGE")));
                        statusMessage.append(" - ");
                        statusMessage.append(message);
                        statusMessage.append(" - ");
                        statusMessage.append(rb.getString("admp.common.native.error_text.error_code"));
                        statusMessage.append(" : ");
                        statusMessage.append((String)hashtable.get("ERROR_CODE"));
                        statusMessage.append(". ");
                    }
                    if (!errorCode.equals("80072035") || !operation.equals("remove")) continue;
                    ++counter;
                    if (removeGroupList.contains(primaryGroup)) {
                        if (failCount == totalCount) {
                            statusMessage.insert(0, rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.remove_failed_cannot_remove_primary_group"));
                            continue;
                        }
                        statusMessage.insert(0, rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.remove_partial_successful_cannot_remove_primary_group"));
                        continue;
                    }
                    if (failCount == totalCount) {
                        statusMessage.insert(0, rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.remove_failed_object_not_belong_to_specified_group"));
                        continue;
                    }
                    statusMessage.insert(0, rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.remove_partial_successful_object_not_belong_to_specified_group"));
                    continue;
                }
                if (hashtable.get("ERROR_CODE") == null || hashtable.get("ERROR_CODE").equals("0") || !(errorCode = (String)hashtable.get("ERROR_CODE")).equals("80071392")) continue;
                ++counter;
            }
            if (operation.equals("add")) {
                if (counter > 0) {
                    if (failCount == totalCount) {
                        statusMessage.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.addtogroup_failed_object_already_exists"), counter, totalCount));
                    } else {
                        statusMessage.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.addtogroup_partial_successful_object_already_exists"), counter, totalCount));
                    }
                    statusMessage.append(" ");
                } else if (failCount == totalCount || failCount == 0) {
                    statusMessage.insert(0, rb.getString("admp.mgmt.mod_grp_attribs.statmsg.addtogroup_operation_failed") + " ");
                } else {
                    statusMessage.insert(0, rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.addtogroup_partial_successful") + " ");
                }
            } else if (operation.equals("remove") && counter == 0) {
                if (failCount == totalCount) {
                    statusMessage.insert(0, rb.getString("admp.mgmt.mod_grp_attribs.statmsg.removegroup_operation_failed") + " ");
                } else {
                    statusMessage.insert(0, rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.remove_partial_successful_object_not_belong_to_specified_group") + " ");
                }
            }
        } else if (operation.equals("add")) {
            statusMessage.append(rb.getString("admp.mgmt.mod_grp_attribs.statmsg.addtogroup_operation_success") + " ");
        } else {
            statusMessage.append(rb.getString("admp.mgmt.mod_grp_attribs.statmsg.removegroup_operation_success") + " ");
        }
        return statusMessage.toString();
    }

    public static String setPrimaryGroupStatusMessage(ArrayList<Hashtable> modifyGroupErrorMsgList, String successMsg, AdventNetResourceBundle rb) {
        StringBuilder statusMessage = new StringBuilder(successMsg + ". ");
        ArrayList messageList = new ArrayList();
        boolean counter = false;
        if (modifyGroupErrorMsgList != null && !modifyGroupErrorMsgList.isEmpty()) {
            statusMessage = new StringBuilder();
            for (Hashtable hashtable : modifyGroupErrorMsgList) {
                String message = (String)hashtable.get("NATIVE_ERROR_MESSAGE");
                if (hashtable.get("ERROR_CODE") == null || hashtable.get("ERROR_CODE").equals("0")) continue;
                String errorCode = (String)hashtable.get("ERROR_CODE");
                if (errorCode.equals("80071392")) {
                    statusMessage.append(rb.getString("admp.mgmt.mod_grp_attribs.statmsg.primary_group_object_already_exits"));
                    continue;
                }
                statusMessage.append(rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.error_in_primary_group") + " ");
                statusMessage.append(rb.getString((String)hashtable.get("ERROR_MESSAGE")));
                statusMessage.append(" - ");
                statusMessage.append(message);
                statusMessage.append(" - ");
                statusMessage.append(rb.getString("admp.common.native.error_text.error_code"));
                statusMessage.append(" : ");
                statusMessage.append((String)hashtable.get("ERROR_CODE"));
                statusMessage.append(". ");
            }
            if (!successMsg.equals("")) {
                statusMessage.insert(0, successMsg + ". ");
            }
        }
        return statusMessage.toString();
    }
}

