/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class GroupMgmtUtil {
    public static final int ADS_GROUP_TYPE_GLOBAL_GROUP = 2;
    public static final int ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP = 4;
    public static final int ADS_GROUP_TYPE_LOCAL_GROUP = 4;
    public static final int ADS_GROUP_TYPE_UNIVERSAL_GROUP = 8;
    public static final int ADS_GROUP_TYPE_SECURITY_ENABLED = Integer.MIN_VALUE;

    private static String sidListQuery(DynaValidatorForm bean, String searchText, ArrayList ouList, int startIndex, int range) {
        String domainName = (String)bean.get("domainName");
        String sidTableName = CommonUtil.getSIDTableName((String)domainName);
        String groupScope = (String)bean.get("groupScope");
        SelectQueryImpl firstQuery = new SelectQueryImpl(Table.getTable((String)"ADSMGroupGeneralDetails"));
        firstQuery.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"SID_STRING"));
        firstQuery.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"GROUP_NAME", (String)"name"));
        firstQuery.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"OU_NAME"));
        firstQuery.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DISTINGUISHED_NAME"));
        firstQuery.addSelectColumn(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"OBJECT_CLASS", (String)"objectClass"));
        firstQuery.addJoin(new Join("ADSMGroupGeneralDetails", sidTableName, new String[]{"SID_STRING"}, new String[]{"SID_STRING"}, 2));
        Criteria firstQueryCriteria = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        SelectQueryImpl secondQuery = new SelectQueryImpl(Table.getTable((String)sidTableName));
        secondQuery.addSelectColumn(Column.getColumn((String)sidTableName, (String)"SID_STRING"));
        secondQuery.addSelectColumn(Column.getColumn((String)sidTableName, (String)"DISPLAY_NAME", (String)"name"));
        secondQuery.addSelectColumn(Column.getColumn((String)sidTableName, (String)"OU_NAME"));
        secondQuery.addSelectColumn(Column.getColumn((String)sidTableName, (String)"DN_STRING"));
        secondQuery.addSelectColumn(Column.getColumn((String)sidTableName, (String)"TYPE_STRING", (String)"objectClass"));
        Criteria secondQueryCriteria = new Criteria(Column.getColumn((String)sidTableName, (String)"SID_IDENTIFIER"), (Object)new Integer[]{2, 4}, 9);
        if (groupScope.equals("universal")) {
            firstQueryCriteria = firstQueryCriteria.and(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"GROUP_SCOPE"), (Object)"Domain Local", 1));
        } else if (groupScope.equals("global")) {
            firstQueryCriteria = firstQueryCriteria.and(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"GROUP_SCOPE"), (Object)"Global", 0));
        }
        if (searchText != null) {
            firstQueryCriteria = firstQueryCriteria.and(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"GROUP_NAME"), (Object)searchText, 2));
            secondQueryCriteria = secondQueryCriteria.and(new Criteria(Column.getColumn((String)sidTableName, (String)"DISPLAY_NAME"), (Object)searchText, 2));
        }
        if (ouList != null && !ouList.isEmpty()) {
            Criteria firstQueryOUCriteria = null;
            Criteria secondQueryOUCriteria = null;
            for (int i = 0; i < ouList.size(); ++i) {
                String ouDN = (String)ouList.get(i);
                if (firstQueryOUCriteria == null) {
                    firstQueryOUCriteria = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)ouDN, 12);
                    secondQueryOUCriteria = new Criteria(Column.getColumn((String)sidTableName, (String)"DN_STRING"), (Object)ouDN, 12);
                    continue;
                }
                firstQueryOUCriteria = firstQueryOUCriteria.or(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)ouDN, 12));
                secondQueryOUCriteria = secondQueryOUCriteria.or(new Criteria(Column.getColumn((String)sidTableName, (String)"DN_STRING"), (Object)ouDN, 12));
            }
            firstQueryCriteria = firstQueryCriteria.and(firstQueryOUCriteria);
            secondQueryCriteria = secondQueryCriteria.and(secondQueryOUCriteria);
        }
        firstQuery.setCriteria(firstQueryCriteria);
        secondQuery.setCriteria(secondQueryCriteria);
        String queryString = "";
        Object query = null;
        try {
            ArrayList<String> queryList = new ArrayList<String>();
            queryList.add(RelationalAPI.getInstance().getSelectSQL((Query)firstQuery));
            queryList.add(RelationalAPI.getInstance().getSelectSQL((Query)secondQuery));
            QueryGenerator queryGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
            queryString = queryGen.getUnionQuery(startIndex, range, "name", true, queryList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return queryString;
    }

    public static void updateGroupMembers(String domainName, String[] objectClass, String searchPattern, Long loginId, ArrayList ouList, String updateRequest) {
        if (searchPattern == null) {
            searchPattern = "*";
        }
        DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"User", "Group", "Computer"});
    }

    public static ArrayList getSidList(DynaValidatorForm bean, String searchText, int startIndex, int range, ArrayList ouList) {
        ArrayList<Properties> sidList = new ArrayList<Properties>();
        try {
            String sidListQuery = GroupMgmtUtil.sidListQuery(bean, searchText, ouList, startIndex, range);
            ArrayList sidListFromDB = CommonUtil.getMembers((String)sidListQuery);
            if (sidListFromDB != null && !sidListFromDB.isEmpty()) {
                for (int counter = 0; counter < sidListFromDB.size(); ++counter) {
                    Properties sids = (Properties)sidListFromDB.get(counter);
                    sidList.add(sids);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return sidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSidListCount(DynaValidatorForm bean, String searchText, ArrayList ouList) {
        String sidListQuery = GroupMgmtUtil.sidListQuery(bean, searchText, ouList, 1, 0);
        String countQuery = "select count(*) from (" + sidListQuery + ") as count";
        Long count = 0L;
        Connection con = null;
        ResultSet rs = null;
        Statement stm = null;
        try {
            RelationalAPI rapi = RelationalAPI.getInstance();
            con = rapi.getConnection();
            stm = con.createStatement();
            rs = stm.executeQuery(countQuery);
            while (rs.next()) {
                Object val = rs.getObject(1);
                count = Long.valueOf(val.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            DBUtil.closeStmtAndConnection((Statement)stm, (Connection)con);
        }
        return count.intValue();
    }

    public static ArrayList sidList(DynaValidatorForm bean, String searchText) {
        String domainName = (String)bean.get("domainName");
        String domainName_sids = CommonUtil.getSIDTableName((String)domainName);
        String sq1 = "";
        Object crit1 = null;
        String sq = "select SID_STRING,GROUP_NAME as name,OU_NAME,DISTINGUISHED_NAME,OBJECT_CLASS as objectClass from ADSMGroupGeneralDetails where GROUP_SCOPE!=\"Domain Local\" and DOMAIN_NAME=\"" + domainName + "\"";
        String groupScope = (String)bean.get("groupScope");
        String groupType = (String)bean.get("groupType");
        sq = groupScope.equals("domainLocal") ? "select SID_STRING,GROUP_NAME as name,OU_NAME,DISTINGUISHED_NAME,OBJECT_CLASS as objectClass from ADSMGroupGeneralDetails where DOMAIN_NAME=\"" + domainName + "\"" : (groupScope.equals("global") ? "select SID_STRING,GROUP_NAME as name,OU_NAME,DISTINGUISHED_NAME,OBJECT_CLASS as objectClass from ADSMGroupGeneralDetails where GROUP_SCOPE=\"Global\" and DOMAIN_NAME=\"" + domainName + "\"" : "select SID_STRING,GROUP_NAME as name,OU_NAME,DISTINGUISHED_NAME,OBJECT_CLASS as objectClass from ADSMGroupGeneralDetails where GROUP_SCOPE!=\"Domain Local\" and DOMAIN_NAME=\"" + domainName + "\"");
        if (searchText != null) {
            sq1 = "select SID_STRING,DISPLAY_NAME as name,OU_NAME,DN_STRING,TYPE_STRING as objectClass from " + domainName_sids + " where SID_IDENTIFIER!=\"2\" and SID_IDENTIFIER!=\"4\" and DISPLAY_NAME LIKE '" + searchText + "'";
            sq = sq + " and GROUP_NAME LIKE '" + searchText + "'";
        } else {
            sq1 = "select SID_STRING,DISPLAY_NAME as name,OU_NAME,DN_STRING,TYPE_STRING as objectClass from " + domainName_sids + " where SID_IDENTIFIER!=\"2\" and SID_IDENTIFIER!=\"4\"";
        }
        String query = "(" + sq1 + ") union (" + sq + ")order by name;";
        return CommonUtil.getMembers((String)query);
    }

    public static String getGroupTypeSearchString(DynaValidatorForm bean) {
        String searchString = "( | (&(objectCategory=person)(objectClass=user)) (&(objectCategory=Group)(objectClass=group)) (&(objectCategory=computer)(objectClass=computer)) (&(objectCategory=person)(objectClass=contact)) )";
        String groupType = (String)bean.get("groupType");
        String groupScope = (String)bean.get("groupScope");
        String domainName = (String)bean.get("domainName");
        String membersDomainName = (String)bean.get("membersDomainName");
        String sidTableName = CommonUtil.getSIDTableName((String)membersDomainName);
        if (groupType.equals("security")) {
            if (!groupScope.equals("domainLocal") && groupScope.equals("global")) {
                searchString = domainName.equals(membersDomainName) ? "( | (&(objectCategory=person)(objectClass=user)) (&(objectCategory=computer)(objectClass=computer)) (&(objectCategory=person)(objectClass=contact)))" : "(&(objectCategory=person)(objectClass=contact))";
            }
        } else if (!groupScope.equals("domainLocal") && groupScope.equals("global") && !domainName.equals(membersDomainName)) {
            searchString = "(&(objectCategory=person)(objectClass=contact))";
        }
        return searchString;
    }

    public static int getGroupType(DynaValidatorForm bean) {
        int flag = 0;
        String groupType = (String)bean.get("groupType");
        String groupScope = (String)bean.get("groupScope");
        if (groupType.equals("security")) {
            flag |= Integer.MIN_VALUE;
        }
        flag = groupScope.equals("global") ? (flag |= 2) : (groupScope.equals("domainLocal") ? (flag |= 4) : (flag |= 8));
        System.out.println("flag : " + flag);
        return flag;
    }

    public static void getNonExchPropList(ArrayList<Hashtable> orignalPropList, ArrayList<Hashtable> nonExchPropList) {
        String[] nonExchAttributeArray = new String[]{"groupType", "displayName", "sAMAccountName", "cn", "name"};
        for (Hashtable hashtable2 : orignalPropList) {
            String attributeName = (String)hashtable2.get("ATTRIB_LDAP_NAME");
            for (int counter = 0; counter < nonExchAttributeArray.length; ++counter) {
                if (!attributeName.equalsIgnoreCase(nonExchAttributeArray[counter]) || hashtable2 == null || hashtable2.get("ATTRIB_VALUE") == null) continue;
                hashtable2.put("ATTRIB_VALUE", (String)hashtable2.get("ATTRIB_VALUE"));
                nonExchPropList.add(hashtable2);
            }
        }
    }

    public static void setGroupType(HttpServletRequest request, DynaValidatorForm bean) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String sid = (String)bean.get("sid");
            Criteria crit = new Criteria(new Column("ADSMGroupGeneralDetails", "SID_STRING"), (Object)sid, 0);
            DataObject obj = GroupHandler.getGroupsProps((String)((String)bean.get("domainName")), null, null, null, (int)-1, (int)-1, (Criteria)crit, (Long)loginId);
            Row r = obj.getFirstRow("ADSMGroupGeneralDetails");
            String grT = (String)r.get("GROUP_TYPE");
            String grS = (String)r.get("GROUP_SCOPE");
            String groupType = null;
            String groupScope = null;
            groupType = grT.equals("Security") ? "security" : "distribution";
            groupScope = grS.equals("Global") ? "global" : (grS.equals("Domain Local") ? "domainLocal" : "universal");
            bean.set("groupType", (Object)groupType);
            bean.set("groupScope", (Object)groupScope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getOrganizationNativeProps(DynaValidatorForm bean, Hashtable result) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            String[] props = new String[]{"description", "mail", "info", "managedBy"};
            String[] beanProps = new String[]{"description", "mail", "info", "MANAGER"};
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            BeanMap beanMap = (BeanMap)bean.get("props");
            for (int i = 0; i < beanProps.length; ++i) {
                Properties p = new Properties();
                p.put("ATTRIB_LDAP_NAME", props[i]);
                p.put("DATA_HANDLER_TYPE", (Object)3L);
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                Object value = null;
                value = beanMap.get(beanProps[i]);
                for (int j = 0; j < selectedAttributes.length; ++j) {
                    if (!beanProps[i].equals(selectedAttributes[j])) continue;
                    if (value.equals("")) {
                        p.put("DW_CONTROL_CODE", (Object)1);
                    }
                    p.put("ATTRIB_VALUE", value);
                    list.add(p);
                    if (!beanProps[i].equals("MANAGER")) continue;
                    result.put("manager", value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getExchNativeProps(DynaValidatorForm bean) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            String[] exchBeanProps = new String[]{"ME_IN_MESSAGE_SIZE", "ME_REQUIRE_AUTH"};
            String[] exchProps = new String[]{"delivContLength", "msExchRequireAuthToSendTo"};
            BeanMap beanMap = (BeanMap)bean.get("props");
            for (int i = 0; i < exchProps.length; ++i) {
                Properties p = new Properties();
                String value = null;
                if (exchBeanProps[i].equals("ME_REQUIRE_AUTH")) {
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    if (beanMap.get(exchBeanProps[i]) != null) {
                        value = ((String)beanMap.get(exchBeanProps[i])).toUpperCase();
                    }
                } else {
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    value = beanMap.get(exchProps[i]).equals("false") ? beanMap.get(exchBeanProps[i]) : "";
                }
                if (value == null) continue;
                if (value.equals("")) {
                    p.put("DW_CONTROL_CODE", (Object)1);
                }
                p.put("ATTRIB_VALUE", value);
                p.put("ATTRIB_LDAP_NAME", exchProps[i]);
                p.put("DATA_HANDLER_TYPE", (Object)3L);
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getNativeProps(HttpServletRequest request, DynaValidatorForm bean) {
        Hashtable primaryGroupIDList = (Hashtable)bean.get("primaryGroupIDList");
        ArrayList list = new ArrayList();
        try {
            String[] props = new String[]{"samAccountName", "groupType", "description", "mail", "info", "managedBy", "member"};
            String[] beanProps = new String[]{"samAccountName", "groupType", "description", "mail", "info", "MANAGER", "membersList"};
            String action = (String)bean.get("action");
            String primaryGroupToken = (String)bean.get("primaryGroupToken");
            Hashtable initialValuesTable = (Hashtable)bean.get("initialValuesTable");
            String operation = request.getParameter("operation");
            boolean validationNeeded = true;
            for (int i = 0; i < props.length; ++i) {
                if (props[i].equals("groupType") && action.equals("modify")) continue;
                Properties p = new Properties();
                String deleteExistingMembers = (String)bean.get("deleteExistingMembers");
                String hideDeleteMembers = (String)bean.get("hideDeleteMembers");
                p.put("ATTRIB_LDAP_NAME", props[i]);
                p.put("DATA_HANDLER_TYPE", (Object)3L);
                Object value = null;
                if (props[i].equals("member")) {
                    Hashtable membersList = (Hashtable)bean.get("membersList");
                    int size = membersList.size();
                    Enumeration e = membersList.keys();
                    ArrayList<String> values = new ArrayList<String>();
                    while (e.hasMoreElements()) {
                        String str = (String)e.nextElement();
                        if (primaryGroupIDList.containsKey(str)) {
                            if (!primaryGroupIDList.get(str).equals(primaryGroupToken)) {
                                values.add(str);
                                continue;
                            }
                            initialValuesTable.remove(str);
                            continue;
                        }
                        values.add(str);
                    }
                    size = values.size();
                    if (size == 1) {
                        value = (String)values.get(0);
                    } else if (size != 0) {
                        value = values;
                    }
                    p.put("ATTRIB_VALUE_COUNT", new Long(size));
                    p.put("DATA_HANDLER_TYPE", (Object)1L);
                    if (action.equals("modify") && membersList.size() == 0 && deleteExistingMembers.equalsIgnoreCase("true")) {
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("DW_CONTROL_CODE", new Long(1L));
                        p.put("ATTRIB_VALUE", "");
                        list.add(p);
                        validationNeeded = false;
                    } else if (action.equals("modify") && membersList.size() != 0 && deleteExistingMembers.equalsIgnoreCase("true")) {
                        p.put("DW_CONTROL_CODE", new Long(2L));
                        validationNeeded = false;
                    } else if (action.equals("modify") && membersList.size() == 0 && hideDeleteMembers.equalsIgnoreCase("true")) {
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("DW_CONTROL_CODE", new Long(1L));
                        p.put("ATTRIB_VALUE", "");
                        list.add(p);
                        validationNeeded = false;
                    } else if (action.equals("modify") && membersList.size() != 0 && size == 0 && hideDeleteMembers.equalsIgnoreCase("true")) {
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("DW_CONTROL_CODE", new Long(1L));
                        p.put("ATTRIB_VALUE", "");
                        list.add(p);
                        validationNeeded = false;
                    }
                    if (action.equals("modify") && deleteExistingMembers.equalsIgnoreCase("false") && hideDeleteMembers.equalsIgnoreCase("false")) {
                        p.put("DW_CONTROL_CODE", new Long(3L));
                        validationNeeded = false;
                    }
                } else if (props[i].equals("groupType")) {
                    p.put("DATA_HANDLER_TYPE", (Object)7L);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    value = String.valueOf(GroupMgmtUtil.getGroupType(bean));
                    System.out.println("groupType string value : " + value);
                } else {
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    value = bean.get(beanProps[i]);
                }
                if (value == null || value.equals("")) continue;
                p.put("ATTRIB_VALUE", value);
                list.add(p);
            }
            if (validationNeeded && operation.equals("Update Group")) {
                list = GroupMgmtUtil.processMembersList(list, initialValuesTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getExchPropList(DynaValidatorForm bean, String operation) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            String mailAlias = (String)bean.get("ME_MAIL_ALIAS");
            String[] exchBeanProps = new String[]{"ME_MAIL_ALIAS", "MS_EXCH_ADMIN_GROUP", "ME_SIMPLE_DISPLAY_NAME", "ME_HIDDEN_TO_ADDRESSLISTS", "ME_IN_MESSAGE_SIZE", "ME_REQUIRE_AUTH", "REJECT_MESSAGES_FROM", "ACCEPT_MESSAGES_FROM"};
            String[] exchProps = new String[]{"mailNickName", "legacyExchangeDN", "displayNamePrintable", "msExchHideFromAddressLists", "delivContLength", "msExchRequireAuthToSendTo", "unauthOrig", "authOrig"};
            for (int i = 0; i < exchProps.length; ++i) {
                Properties properties = new Properties();
                ArrayList<String> value = null;
                if (exchBeanProps[i].equals("MS_EXCH_ADMIN_GROUP")) {
                    properties.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    value = bean.get(exchBeanProps[i]) + "/cn=Recipients/cn=" + mailAlias;
                    if (bean.get("LEGACY_EXCHANGE_DN") != "") {
                        value = null;
                    }
                } else if (exchBeanProps[i].equals("REJECT_MESSAGES_FROM") || exchBeanProps[i].equals("ACCEPT_MESSAGES_FROM")) {
                    ArrayList<String> messageList = new ArrayList<String>();
                    ArrayList valueList = (ArrayList)bean.get(exchBeanProps[i]);
                    for (int j = 0; j < valueList.size(); ++j) {
                        Properties props = (Properties)valueList.get(j);
                        String dn = (String)props.get("Distinguished_Name");
                        if (messageList.contains(dn = GroupMgmtUtil.replaceChar(dn))) continue;
                        messageList.add(dn);
                    }
                    properties.put("ATTRIB_VALUE_COUNT", new Long(messageList.size()));
                    if (!messageList.isEmpty()) {
                        value = messageList.size() == 1 ? messageList.get(0) : messageList;
                    }
                } else {
                    properties.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    value = bean.get(exchBeanProps[i]);
                }
                if (value == null) continue;
                if (!((Object)value).equals("")) {
                    properties.put("ATTRIB_VALUE", value);
                    properties.put("ATTRIB_LDAP_NAME", exchProps[i]);
                    properties.put("DATA_HANDLER_TYPE", (Object)3L);
                    list.add(properties);
                    continue;
                }
                if (operation.equals("Create Group")) continue;
                properties.put("DW_CONTROL_CODE", new Long(1L));
                properties.put("ATTRIB_VALUE", value);
                properties.put("ATTRIB_LDAP_NAME", exchProps[i]);
                properties.put("DATA_HANDLER_TYPE", (Object)3L);
                list.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String replaceChar(String string) {
        if (string.contains("&amp;")) {
            string = string.replaceAll("&amp;", "&");
        } else if (string.contains("&lt;")) {
            string = string.replaceAll("&lt;", "<");
        } else if (string.contains("&gt;")) {
            string = string.replaceAll("&gt;", ">");
        }
        return string;
    }

    public static void updateGroup(String domainName, String distinguishedName, String searchString, Long loginId, AdventNetResourceBundle rb) {
        try {
            ObjectClass objClass = SearchProfileHandler.getInstance().getObjectClass("group");
            String baseTable = objClass.getBaseTable();
            Integer endRange = objClass.getEndRange();
            Integer startRange = objClass.getStartRange();
            ArrayList attribDetails = new ArrayList();
            Criteria crit = new Criteria(new Column("ADSMAttributeDetails", "TABLE_NAME"), (Object)baseTable, 0);
            DataObject dataObj = CommonUtil.getCachedPersistence().get("ADSMAttributeDetails", (Criteria)null);
            Iterator it = dataObj.getRows("ADSMAttributeDetails", crit);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("ATTRIB_LDAP_NAME", (String)r.get("ATTRIB_LDAP_NAME"));
                props.put("ATTRIB_COLUMN_NAME", (String)r.get("ATTRIB_COLUMN_NAME"));
                attribDetails.add(props);
            }
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < attribDetails.size(); ++i) {
                Hashtable prop = (Hashtable)attribDetails.get(i);
                String ATTRIB_LDAP_NAME = (String)prop.get("ATTRIB_LDAP_NAME");
                list.add(ATTRIB_LDAP_NAME);
            }
            Properties domainDetails = ADHandler.getDomainDetails((String)domainName, (Long)loginId);
            ArrayList resultList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)distinguishedName, list, (String)searchString);
            DataObject datObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int k = 0; k < resultList.size(); ++k) {
                Row r = new Row(baseTable);
                Properties prop1 = (Properties)resultList.get(k);
                for (int i = 0; i < attribDetails.size(); ++i) {
                    String ldapName;
                    Hashtable prop2 = (Hashtable)attribDetails.get(i);
                    String columnName = (String)prop2.get("ATTRIB_COLUMN_NAME");
                    ArrayList values = ListenerUtil.getDBCustomizedValues(domainName, columnName, ldapName = (String)prop2.get("ATTRIB_LDAP_NAME"), prop1, rb);
                    if (values == null || values.isEmpty()) continue;
                    r.set(columnName, values.get(0));
                }
                datObj.addRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(datObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList processMembersList(ArrayList list, Hashtable initialValuesTable) {
        Hashtable removeMembers = (Hashtable)initialValuesTable.clone();
        for (int index = 0; index < list.size(); ++index) {
            Properties temp = (Properties)list.get(index);
            if (!temp.getProperty("ATTRIB_LDAP_NAME").equalsIgnoreCase("member")) continue;
            int count = Integer.parseInt(temp.get("ATTRIB_VALUE_COUNT").toString());
            ArrayList membersList = new ArrayList();
            if (count > 1) {
                membersList = (ArrayList)temp.get("ATTRIB_VALUE");
            } else if (temp.getProperty("ATTRIB_VALUE").length() != 0) {
                String singleMember = temp.getProperty("ATTRIB_VALUE");
                membersList.add(singleMember);
            } else {
                return list;
            }
            list.remove(index);
            ArrayList addMembers = (ArrayList)membersList.clone();
            for (int i = 0; i < addMembers.size(); ++i) {
                String str = (String)addMembers.get(i);
                if (!removeMembers.containsKey(str)) continue;
                removeMembers.remove(str);
                addMembers.remove(i);
                --i;
            }
            if (addMembers.size() > 0) {
                Properties tempProp = new Properties();
                tempProp.put("ATTRIB_VALUE_COUNT", new Long(addMembers.size()));
                tempProp.put("ATTRIB_LDAP_NAME", "member");
                tempProp.put("DATA_HANDLER_TYPE", (Object)1);
                tempProp.put("DW_CONTROL_CODE", (Object)3);
                if (addMembers.size() == 1) {
                    tempProp.put("ATTRIB_VALUE", addMembers.get(0));
                } else {
                    tempProp.put("ATTRIB_VALUE", addMembers);
                }
                list.add(tempProp);
            }
            if (removeMembers.isEmpty()) break;
            Properties tempProp = new Properties();
            ArrayList<String> tempMemberList = new ArrayList<String>();
            Enumeration tempIter = removeMembers.keys();
            while (tempIter.hasMoreElements()) {
                String str = (String)tempIter.nextElement();
                tempMemberList.add(str);
            }
            tempProp.put("ATTRIB_VALUE_COUNT", new Long(removeMembers.size()));
            tempProp.put("ATTRIB_LDAP_NAME", "member");
            tempProp.put("DATA_HANDLER_TYPE", (Object)1);
            tempProp.put("DW_CONTROL_CODE", (Object)4);
            if (tempMemberList.size() == 1) {
                tempProp.put("ATTRIB_VALUE", tempMemberList.get(0));
            } else {
                tempProp.put("ATTRIB_VALUE", tempMemberList);
            }
            list.add(tempProp);
            break;
        }
        return list;
    }
}

