/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GroupModificationUtil {
    private static final int ADS_GROUP_TYPE_GLOBAL_GROUP = 2;
    private static final int ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP = 4;
    private static final int ADS_GROUP_TYPE_LOCAL_GROUP = 4;
    private static final int ADS_GROUP_TYPE_UNIVERSAL_GROUP = 8;
    private static final int ADS_GROUP_TYPE_SECURITY_ENABLED = Integer.MIN_VALUE;

    public static void setGroupProps(ArrayList groupProps, DynaValidatorForm bean) {
        try {
            GroupModificationUtil.setMemberOf(groupProps, bean);
            GroupModificationUtil.setExchangeProps(groupProps, bean);
            Properties props = (Properties)groupProps.get(0);
            String sid = (String)bean.get("sid");
            String ouName = ReportAttributeHandler.getInstance().getOUName((String)bean.get("domainName"), (String)bean.get("distinguishedName"));
            String ouDn = OUUtil.getOUDNName((String)((String)bean.get("domainName")), (String)ouName);
            if (ouDn != null) {
                bean.set("container", (Object)ouDn);
            }
            if (props.get("mail") != null) {
                String mail = (String)((ArrayList)props.get("mail")).get(0);
                bean.set("mail", (Object)mail);
            }
            if (props.get("description") != null) {
                String description = (String)((ArrayList)props.get("description")).get(0);
                bean.set("description", (Object)description);
            }
            if (props.get("info") != null) {
                String info = (String)((ArrayList)props.get("info")).get(0);
                bean.set("info", (Object)info);
            }
            if (props.get("managedBy") != null) {
                Properties managerProps = (Properties)((ArrayList)props.get("managedBy")).get(0);
                bean.set("managerText", (Object)((String)managerProps.get("cn")));
                bean.set("MANAGER", (Object)((String)managerProps.get("distinguishedName")));
            }
            if (props.get("primaryGroupToken") != null) {
                String primaryGroupToken = (String)((ArrayList)props.get("primaryGroupToken")).get(0);
                bean.set("primaryGroupToken", (Object)primaryGroupToken);
            }
            String grT = null;
            String grS = null;
            String groupType = null;
            String groupScope = null;
            ArrayList values = (ArrayList)props.get("groupType");
            String bitwtype = (String)values.get(0);
            int bitopt = Integer.parseInt(bitwtype);
            grT = (bitopt & Integer.MIN_VALUE) == Integer.MIN_VALUE ? "Security" : "Distribution";
            String bitws = (String)values.get(0);
            int bitops = Integer.parseInt(bitws);
            if ((bitops & 2) == 2) {
                grS = "Global";
            } else if ((bitops & 4) == 4) {
                grS = "Domain Local";
            } else if ((bitops & 8) == 8) {
                grS = "Universal";
            }
            groupType = grT.equals("Security") ? "security" : "distribution";
            groupScope = grS.equals("Global") ? "global" : (grS.equals("Domain Local") ? "domainLocal" : "universal");
            bean.set("groupType", (Object)groupType);
            bean.set("groupScope", (Object)groupScope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMembers(ArrayList groupProps, DynaValidatorForm bean) {
        Hashtable membersList = new Hashtable();
        try {
            Properties prop = (Properties)groupProps.get(0);
            ArrayList members = (ArrayList)prop.get("member");
            for (int i = 0; i < members.size(); ++i) {
                Hashtable hash = (Hashtable)members.get(i);
                membersList.put(hash.get("distinguishedName"), hash.get("cn"));
            }
            bean.set("membersList", membersList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMemberOf(ArrayList groupProps, DynaValidatorForm bean) {
        ArrayList<Properties> memberOfList = new ArrayList<Properties>();
        try {
            Properties prop = (Properties)groupProps.get(0);
            if (prop != null) {
                ArrayList memberOf = (ArrayList)prop.get("memberOf");
                for (int i = 0; i < memberOf.size(); ++i) {
                    Hashtable hash = (Hashtable)memberOf.get(i);
                    Properties props = new Properties();
                    if (hash == null) continue;
                    props.put("Display_Name", hash.get("cn"));
                    props.put("Distinguished_Name", hash.get("distinguishedName"));
                    String distinguishedName = (String)hash.get("distinguishedName");
                    ArrayList groupList = (ArrayList)bean.get("userCreationGroupList");
                    Properties properties = UserMgmtUtil.getPropertiesfromDN((String)distinguishedName, (ArrayList)groupList);
                    if (properties == null) continue;
                    memberOfList.add(props);
                }
            }
            bean.set("MEMBER_OF", memberOfList);
            bean.set("prevMemberOf", memberOfList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setExchangeProps(ArrayList groupProps, DynaValidatorForm bean) {
        try {
            Properties prop = (Properties)groupProps.get(0);
            if (prop != null && prop.get("mailNickname") != null) {
                bean.set("createEmailAddress", (Object)"true");
                bean.set("ME_MAIL_ALIAS", (Object)((String)((ArrayList)prop.get("mailNickname")).get(0)));
                if (prop.get("displayNamePrintable") != null) {
                    bean.set("ME_SIMPLE_DISPLAY_NAME", (Object)((String)((ArrayList)prop.get("displayNamePrintable")).get(0)));
                }
                ArrayList msExchAdminGroupDNList = (ArrayList)bean.get("msExchAdminGroupDNList");
                for (int i = 0; i < msExchAdminGroupDNList.size(); ++i) {
                    if (!((String)((ArrayList)prop.get("legacyExchangeDN")).get(0)).startsWith((String)msExchAdminGroupDNList.get(i))) continue;
                    bean.set("MS_EXCH_ADMIN_GROUP", msExchAdminGroupDNList.get(i));
                    bean.set("LEGACY_EXCHANGE_DN", (Object)((String)((ArrayList)prop.get("legacyExchangeDN")).get(0)));
                }
                if (prop.get("msExchHideFromAddressLists") != null) {
                    if (((String)((ArrayList)prop.get("msExchHideFromAddressLists")).get(0)).equalsIgnoreCase("1")) {
                        bean.set("ME_HIDDEN_TO_ADDRESSLISTS", (Object)"true");
                    } else {
                        bean.set("ME_HIDDEN_TO_ADDRESSLISTS", (Object)"false");
                    }
                }
                if (prop.get("msExchRequireAuthToSendTo") != null) {
                    if (((String)((ArrayList)prop.get("msExchRequireAuthToSendTo")).get(0)).equalsIgnoreCase("1")) {
                        bean.set("ME_REQUIRE_AUTH", (Object)"true");
                    } else {
                        bean.set("ME_REQUIRE_AUTH", (Object)"false");
                    }
                }
                if (prop.get("authOrig") != null) {
                    ArrayList<String> meMRrecipientsDisplayList = new ArrayList<String>();
                    ArrayList<String> meMRrecipientsDNList = new ArrayList<String>();
                    ArrayList authOrig = (ArrayList)prop.get("authOrig");
                    for (int i = 0; i < authOrig.size(); ++i) {
                        Hashtable hash = (Hashtable)authOrig.get(i);
                        if (hash == null) continue;
                        meMRrecipientsDisplayList.add((String)hash.get("cn"));
                        meMRrecipientsDNList.add((String)hash.get("distinguishedName"));
                    }
                    bean.set("meMRrecipientsDisplayList", meMRrecipientsDisplayList);
                    bean.set("meMRrecipientsDNList", meMRrecipientsDNList);
                    bean.set("meMsgRestriction", (Object)"onlyFrom");
                } else if (prop.get("unauthOrig") != null) {
                    ArrayList<String> meMRrecipientsDisplayList = new ArrayList<String>();
                    ArrayList<String> meMRrecipientsDNList = new ArrayList<String>();
                    ArrayList unauthOrig = (ArrayList)prop.get("unauthOrig");
                    for (int i = 0; i < unauthOrig.size(); ++i) {
                        Hashtable hash = (Hashtable)unauthOrig.get(i);
                        if (hash == null) continue;
                        meMRrecipientsDisplayList.add((String)hash.get("cn"));
                        meMRrecipientsDNList.add((String)hash.get("distinguishedName"));
                    }
                    bean.set("meMRrecipientsDisplayList", meMRrecipientsDisplayList);
                    bean.set("meMRrecipientsDNList", meMRrecipientsDNList);
                    bean.set("meMsgRestriction", (Object)"fromExcept");
                } else {
                    bean.set("meMsgRestriction", (Object)"all");
                }
            }
            if (prop.get("delivContLength") != null) {
                bean.set("ME_IN_MESSAGE_SIZE", ((ArrayList)prop.get("delivContLength")).get(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setmeMRrecipientsDNString(DynaValidatorForm bean) {
        String meMRrecipientsDNString = "";
        ArrayList meMRrecipientsDNList = (ArrayList)bean.get("meMRrecipientsDNList");
        for (int i = 0; i < meMRrecipientsDNList.size(); ++i) {
            meMRrecipientsDNString = meMRrecipientsDNString + meMRrecipientsDNList.get(i) + ";";
        }
        bean.set("meMRrecipientsDNString", (Object)meMRrecipientsDNString);
    }

    public static void getXMLMembers(HttpServletRequest request, HttpServletResponse response, TreeMap value) {
        ByteArrayOutputStream outNode = null;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Object[] keySet = value.keySet().toArray();
            for (int k = 0; k < keySet.length; ++k) {
                Element values = document.createElement("Values");
                values.setAttribute("cn", (String)keySet[k]);
                Hashtable hash = (Hashtable)value.get(keySet[k]);
                values.setAttribute("distinguishedName", (String)hash.get("distinguishedName"));
                values.setAttribute("primaryGroupID", (String)hash.get("primaryGroupID"));
                data.appendChild(values);
            }
            if (value.size() == 0) {
                Element Values2 = document.createElement("Error");
                Values2.setAttribute("Message", rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.alert_no_members_for_selected_group"));
                data.appendChild(Values2);
            }
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillAuthUnAuthValues(ArrayList list, String meMRrecipientsDNString, String recipientType, String cn, String domainName, String delimiter, ArrayList meMRrecipientsDNPrevList) {
        try {
            if (recipientType.equals("onlyFrom")) {
                list.add(GroupModificationUtil.getProps(null, "dlMemRejectPerms"));
                list.add(GroupModificationUtil.getProps(null, "unauthOrig"));
                GroupModificationUtil.updatePropsList(list, meMRrecipientsDNString, delimiter, "authOrig", "dlMemSubmitPerms", meMRrecipientsDNPrevList);
            } else if (recipientType.equals("fromExcept")) {
                list.add(GroupModificationUtil.getProps(null, "dlMemSubmitPerms"));
                list.add(GroupModificationUtil.getProps(null, "authOrig"));
                GroupModificationUtil.updatePropsList(list, meMRrecipientsDNString, delimiter, "unauthOrig", "dlMemRejectPerms", meMRrecipientsDNPrevList);
            } else {
                list.add(GroupModificationUtil.getProps(null, "authOrig"));
                list.add(GroupModificationUtil.getProps(null, "unauthOrig"));
                list.add(GroupModificationUtil.getProps(null, "dlMemSubmitPerms"));
                list.add(GroupModificationUtil.getProps(null, "dlMemRejectPerms"));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception Occurs while adding AuthOrig and UnauthOrig attributes");
            exception.printStackTrace();
        }
    }

    public static void updatePropsList(ArrayList list, String meMRrecipientsDNString, String delimiter, String userLdapName, String groupLdapName, ArrayList meMRrecipientsDNPrevList) {
        try {
            JSONObject recipientsDNString = new JSONObject(meMRrecipientsDNString);
            if (recipientsDNString.length() != 0) {
                Iterator stringTokenizer = recipientsDNString.keys();
                ArrayList<String> dnList = new ArrayList<String>();
                while (stringTokenizer.hasNext()) {
                    dnList.add((String)recipientsDNString.get((String)stringTokenizer.next()));
                }
                Hashtable objectList = ClientUtil.getUserGroupList(dnList.toArray(new String[dnList.size()]));
                ArrayList userList = (ArrayList)objectList.get("users");
                ArrayList groupList = (ArrayList)objectList.get("groups");
                for (Object e : dnList) {
                    if (userList.contains(e) || groupList.contains(e)) continue;
                    if (meMRrecipientsDNPrevList.contains(e)) {
                        groupList.add(e);
                        continue;
                    }
                    userList.add(e);
                }
                list.add(GroupModificationUtil.getProps(userList, userLdapName));
                list.add(GroupModificationUtil.getProps(groupList, groupLdapName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getProps(ArrayList objectList, String ldapName) {
        Properties properties = new Properties();
        properties.put("ATTRIB_LDAP_NAME", ldapName);
        properties.put("DATA_HANDLER_TYPE", new Long(1L));
        if (objectList == null || objectList.size() == 0) {
            properties.put("ATTRIB_VALUE", "");
            properties.put("ATTRIB_VALUE_COUNT", new Long(1L));
            properties.put("DW_CONTROL_CODE", new Long(1L));
        } else if (objectList.size() == 1) {
            properties.put("ATTRIB_VALUE", objectList.get(0));
            properties.put("ATTRIB_VALUE_COUNT", new Long(1L));
        } else {
            properties.put("ATTRIB_VALUE", objectList);
            properties.put("ATTRIB_VALUE_COUNT", new Long(objectList.size()));
        }
        return properties;
    }
}

