/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupModificationUtil;
import com.adventnet.sym.adsm.common.webclient.groups.ModifyGroupListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.struts.validator.DynaValidatorForm;

public class ModifyExchangeGroupsListener
extends ModifyGroupListener {
    public ModifyExchangeGroupsListener() {
        this.cks = new String[]{"ME_REQUIRE_AUTH"};
        this.reportId = new Integer(4006);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            logger.log(Level.INFO, "Calling Modify User in the ModifyExchangeGroupsListener");
            ArrayList list = new ArrayList();
            try {
                String sid = this.getValue(result, 2023);
                String dn = this.getValue(result, 2003);
                String cn = this.getValue(result, 2013);
                dn = CommonUtil.escapeDN((String)dn);
                if (HelpdeskUtil.isExcludedGroup((String)dn, (ArrayList)this.groupExcludeList) || !HelpdeskUtil.isAuthorizedGroup((String)dn, (ArrayList)this.groupIncludeList)) {
                    message.append(this.rb.getString("groupmanagement.messages.not_authorized_group"));
                } else {
                    ModifyGroupListener listener = (ModifyGroupListener)bean.getListener();
                    list = this.getExchNativeProps(bean, domainName);
                    BeanMap props = (BeanMap)bean.get("props");
                    String meMRrecipientsDNString = (String)props.get("meMRrecipientsDNString");
                    String recipientType = (String)props.get("meMsgRestriction");
                    if (meMRrecipientsDNString != null) {
                        props.put("meMRrecipientsDNString", GroupMgmtUtil.replaceChar(meMRrecipientsDNString));
                    }
                    this.fillAuthUnAuthValues(list, meMRrecipientsDNString, recipientType, cn, domainName, ";", new ArrayList());
                    logger.log(Level.INFO, "Resultant list: " + list);
                    logger.log(Level.INFO, "Starts modifying the Group,Sid: " + sid + "dn: " + dn);
                    ADHandlerForMgmt.modifyGroup((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)list, null);
                    message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    Properties logProp = new Properties();
                    logProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text_accept_msg"));
                    if (recipientType.equals("onlyFrom")) {
                        logProp.put("ATTRIB_VALUE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.input_only_frm"));
                    } else if (recipientType.equals("fromExcept")) {
                        logProp.put("ATTRIB_VALUE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.input_frm_everyone_except"));
                    } else {
                        logProp.put("ATTRIB_VALUE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.input_frm_every_one"));
                    }
                    list.add(logProp);
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("groupmanagement.messages.error_message_exchange") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("groupmanagement.messages.error_message_exchange") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditGroupModification(loginId, this.rb.getString("admp.mgmt.common.mgmtcategory.modify_exch_attribs"), this.getValue(result, 2001), domainName, list, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }

    private void fillAuthUnAuthValues(ArrayList list, String meMRrecipientsDNString, String recipientType, String cn, String domainName, String delimiter, ArrayList meMRrecipientsDNPrevList) {
        try {
            if (recipientType == null || recipientType.equals("")) {
                return;
            }
            if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1148L) && recipientType.equals("onlyFrom")) {
                GroupModificationUtil.updatePropsList(list, meMRrecipientsDNString, delimiter, "authOrig", "dlMemSubmitPerms", meMRrecipientsDNPrevList);
            } else if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1149L) && recipientType.equals("fromExcept")) {
                GroupModificationUtil.updatePropsList(list, meMRrecipientsDNString, delimiter, "unauthOrig", "dlMemRejectPerms", meMRrecipientsDNPrevList);
            } else if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1148L)) {
                list.add(GroupModificationUtil.getProps(null, "authOrig"));
                list.add(GroupModificationUtil.getProps(null, "unauthOrig"));
                list.add(GroupModificationUtil.getProps(null, "dlMemSubmitPerms"));
                list.add(GroupModificationUtil.getProps(null, "dlMemRejectPerms"));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception Occurs while adding AuthOrig and UnauthOrig attributes");
            exception.printStackTrace();
        }
    }

    private ArrayList getExchNativeProps(DynaValidatorForm bean, String domainName) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            String[] exchBeanProps = new String[]{"ME_IN_MESSAGE_SIZE", "ME_REQUIRE_AUTH"};
            String[] exchProps = new String[]{"delivContLength", "msExchRequireAuthToSendTo"};
            BeanMap beanMap = (BeanMap)bean.get("props");
            for (int i = 0; i < exchProps.length; ++i) {
                Properties p = new Properties();
                Object value = null;
                if (exchBeanProps[i].equals("ME_REQUIRE_AUTH")) {
                    if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1150L)) {
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        if (beanMap.get(exchBeanProps[i]) != null) {
                            value = ((String)beanMap.get(exchBeanProps[i])).toUpperCase();
                        }
                    }
                } else if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1147L)) {
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    value = beanMap.get(exchProps[i]).equals("false") ? beanMap.get(exchBeanProps[i]) : "";
                }
                if (value == null) continue;
                if (value.equals("")) {
                    p.put("DW_CONTROL_CODE", (Object)1);
                }
                p.put("ATTRIB_VALUE", value);
                p.put("ATTRIB_LDAP_NAME", exchProps[i]);
                p.put("DATA_HANDLER_TYPE", (Object)3L);
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

