/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.groups;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.groups.ModifyGroupListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;

public class MoveGroupsListener
extends ModifyGroupListener {
    public MoveGroupsListener() {
        this.reportId = new Integer(4005);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            String dn;
            BeanMap props;
            block10: {
                props = (BeanMap)bean.get("props");
                logger.log(Level.INFO, "Calling Modify User in the MoveGroupsListener");
                dn = this.getValue(result, 2003);
                String sid = this.getValue(result, 2023);
                try {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1054L})) {
                        return this.rb.getString("client.authentication.ADAuthAction.access_is_denied");
                    }
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1054L)) break block10;
                    try {
                        if (HelpdeskUtil.isExcludedGroup((String)dn, (ArrayList)this.groupExcludeList) || !HelpdeskUtil.isAuthorizedGroup((String)dn, (ArrayList)this.groupIncludeList)) {
                            message.append(this.rb.getString("groupmanagement.messages.not_authorized_group"));
                            break block10;
                        }
                        logger.log(Level.INFO, "dn : " + dn + " : domainName : " + domainName + " : moveGroupsDN : " + props.getProperty("moveGroupsDN"));
                        ADHandlerForMgmt.moveObject((String)domainName, (Long)loginId, (String)dn, (String)props.getProperty("moveGroupsDN"));
                        ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                        if (message.length() == 0) {
                            message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                            break block10;
                        }
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error"));
                    }
                    catch (LocalizedException le) {
                        le.printStackTrace();
                        message = new StringBuffer(this.rb.getString("groupmanagement.messages.unable_to_modify") + le.getMessage(this.rb));
                    }
                    catch (Exception e) {
                        message = new StringBuffer(this.rb.getString("groupmanagement.messages.unable_to_modify") + e.getMessage());
                    }
                }
                catch (Exception e) {
                    message = new StringBuffer(this.rb.getString("groupmanagement.messages.unable_to_modify") + e.getMessage());
                }
            }
            String sourceDN = StrUtil.getContainerDNFromDN((String)dn);
            TechAuditAPI.getInstance().auditMoveGroup(loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.move_groups"), this.getValue(result, 2001), domainName, sourceDN, props.getProperty("moveGroupsDN"), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }
}

