/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.clientapi.mgmt.RestAPICreateUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.integration.ActionExecuter;
import com.adventnet.sym.adsm.common.webclient.integration.CrossObjectProvisionController;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import java.util.Hashtable;
import java.util.Locale;
import org.json.JSONArray;

public class ADActionExecuter
extends ActionExecuter {
    private String domainName;
    private String templateName;
    private GenericData userData;
    private Long loginId;
    private int configId;
    private boolean isActionSubmitted;
    private ADExecuterThread executerThread;

    public ADActionExecuter(int configId) {
        this.configId = configId;
        Hashtable<String, String> configData = this.getConfigData();
        this.domainName = configData.get("DOMAIN_NAME");
        this.templateName = configData.get("TEMPLATE_NAME");
        this.loginId = CrossObjectProvisionController.getLoginId(configId);
    }

    @Override
    public int initiateAction(GenericData data) {
        data.setTemplateName(this.templateName);
        this.executerThread = new ADExecuterThread(this.domainName, this.loginId, data);
        this.executerThread.start();
        return generationId;
    }

    @Override
    public boolean isCompletedExecution() {
        return this.executerThread.isCompletedExecution();
    }

    @Override
    public JSONArray getStatus() {
        try {
            return this.executerThread.getStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Hashtable<String, String> getConfigData() {
        Hashtable<String, String> configData = new Hashtable<String, String>();
        try {
            String tableName = "ADActionExecuterConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)this.configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Row r = dataObject.getFirstRow(tableName);
            configData.put("DOMAIN_NAME", (String)r.get("DOMAIN_NAME"));
            configData.put("TEMPLATE_NAME", (String)r.get("TEMPLATE_NAME"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    public class ADExecuterThread
    extends Thread {
        private boolean isStopped;
        private int executionStatus = 0;
        private Long loginId;
        private GenericData userData;
        private String domainName;
        RestAPICreateUserHandler listener;
        JSONArray resultStatus = new JSONArray();
        private static final int NOT_STARTED = 0;
        private static final int STARTED_EXECUTION = 1;
        private static final int COMPLETED_EXECUTION = 2;

        public ADExecuterThread(String domainName, Long loginId, GenericData userData) {
            this.loginId = loginId;
            this.userData = userData;
            this.domainName = domainName;
        }

        @Override
        public void run() {
            this.executionStatus = 1;
            String localeString = CrossObjectProvisionController.getLocale(ADActionExecuter.this.configId);
            AdventNetResourceBundle rb = new AdventNetResourceBundle(new Locale(localeString));
            try {
                this.listener = new RestAPICreateUserHandler(this.domainName, this.loginId, rb);
                if (!this.listener.checkAuthorization()) {
                    this.listener.fillResultFormat();
                    this.resultStatus = this.listener.getFormattedResult();
                    this.executionStatus = 2;
                }
                this.listener.commitAPIRequest(this.userData);
                this.resultStatus = this.listener.getFormattedResult();
                this.executionStatus = 2;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.executionStatus = 2;
            }
        }

        public JSONArray getStatus() {
            try {
                if (this.executionStatus == 1) {
                    return this.listener.getClonedStatus();
                }
                if (this.executionStatus == 2) {
                    return this.resultStatus;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public boolean isCompletedExecution() {
            return this.executionStatus == 2;
        }
    }
}

