/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.integration.ActionExecuter;
import com.adventnet.sym.adsm.common.webclient.integration.DBInputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import com.adventnet.sym.adsm.common.webclient.integration.InputDataSource;
import java.util.Hashtable;
import org.json.JSONArray;

public class CrossObjectProvisionController {
    private static CrossObjectProvisionController handler = null;
    public static final int FULL_SYNC = 1;
    public static final int INCREMENTAL_SYNC = 2;
    public int configId;

    public static CrossObjectProvisionController getInstance() {
        if (handler == null) {
            handler = new CrossObjectProvisionController();
        }
        return handler;
    }

    public static boolean initPrerequisiteActions(int configId) {
        try {
            InputDataSource dataSource = InputDataSource.getDataSourceInstance("db", configId);
            ((DBInputDataSource)dataSource).addCurrentRecordsToDB();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public JSONArray performAction(int configId) {
        JSONArray statusObject = new JSONArray();
        this.configId = configId;
        Hashtable<String, String> configDetails = this.getConfigDetails(configId);
        String inputSource = configDetails.get("INPUT_SOURCE");
        String syncType = configDetails.get("SYNC_TYPE");
        String actionExecutor = configDetails.get("ACTION_EXECUTOR");
        inputSource = "db";
        actionExecutor = "ad";
        syncType = "getModified";
        InputDataSource dataSource = InputDataSource.getDataSourceInstance(inputSource, configId);
        GenericData genericData = dataSource.readData(syncType);
        ActionExecuter executorInstance = ActionExecuter.getExecutorInstance(actionExecutor, configId);
        int executorId = executorInstance.initiateAction(genericData);
        while (!ActionExecuter.isCompleted(executorId)) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        statusObject = ActionExecuter.getStatus(executorId);
        dataSource.postExecutionUpdate(syncType);
        return statusObject;
    }

    public GenericData getGenericData(int configId) {
        Hashtable<String, String> configDetails = this.getConfigDetails(configId);
        String inputSource = configDetails.get("INPUT_SOURCE");
        String syncType = configDetails.get("SYNC_TYPE");
        String actionExecutor = configDetails.get("ACTION_EXECUTOR");
        inputSource = "db";
        actionExecutor = "ad";
        syncType = "getModified";
        InputDataSource dataSource = InputDataSource.getDataSourceInstance(inputSource, configId);
        GenericData genericData = dataSource.readData(syncType);
        return genericData;
    }

    public int initiateAction(int configId) {
        Hashtable<String, String> configDetails = this.getConfigDetails(configId);
        String inputSource = configDetails.get("INPUT_SOURCE");
        String syncType = configDetails.get("SYNC_TYPE");
        String actionExecutor = configDetails.get("ACTION_EXECUTOR");
        inputSource = "db";
        actionExecutor = "ad";
        syncType = "getModified";
        InputDataSource dataSource = InputDataSource.getDataSourceInstance(inputSource, configId);
        GenericData genericData = dataSource.readData(syncType);
        ActionExecuter executorInstance = ActionExecuter.getExecutorInstance(actionExecutor, configId);
        int executionId = executorInstance.initiateAction(genericData);
        return executionId;
    }

    private Hashtable<String, String> getConfigDetails(int configId) {
        Hashtable<String, String> configData = new Hashtable<String, String>();
        try {
            String tableName = "TPIntegrationConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Row r = dataObject.getFirstRow(tableName);
            configData.put("INPUT_SOURCE", (String)r.get("INPUT_SOURCE"));
            configData.put("SYNC_TYPE", (String)r.get("SYNC_TYPE"));
            configData.put("ACTION_EXECUTOR", (String)r.get("ACTION_EXECUTOR"));
            configData.put("LOGIN_ID", (String)r.get("LOGIN_ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    public static Integer addConfigData(Hashtable<String, String> props, Long loginId) {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row = new Row("TPIntegrationConfig");
            row.set("INPUT_SOURCE", (Object)"db");
            row.set("SYNC_TYPE", (Object)"incremental");
            row.set("ACTION_EXECUTOR", (Object)"ad");
            row.set("LOGIN_ID", (Object)loginId);
            row.set("LOCALE", (Object)"en-us");
            dataObject.addRow(row);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            Integer configId = (Integer)row.get("CONFIG_ID");
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row2 = new Row("MsSqlInputConfig");
            row2.set("USER_NAME", (Object)props.get("username"));
            row2.set("PASSWORD", (Object)props.get("pwd"));
            row2.set("SERVER_NAME", (Object)props.get("serverName"));
            row2.set("PORT_NUMBER", (Object)props.get("portNum"));
            row2.set("INSTANCE_NAME", (Object)props.get("instanceName"));
            row2.set("DATABASE_NAME", (Object)props.get("dbName"));
            row2.set("TABLE_NAME", (Object)props.get("tableName"));
            row2.set("CONFIG_ID", (Object)((Integer)row.get("CONFIG_ID")));
            dataObject.addRow(row2);
            Row row3 = new Row("ADActionExecuterConfig");
            row3.set("DOMAIN_NAME", (Object)props.get("domainName"));
            row3.set("TEMPLATE_NAME", (Object)props.get("templateName"));
            row3.set("CONFIG_ID", (Object)((Integer)row.get("CONFIG_ID")));
            dataObject.addRow(row3);
            Row row4 = new Row("DBInputConfig");
            row4.set("DB_TYPE", (Object)"mssql");
            row4.set("CONFIG_ID", (Object)((Integer)row.get("CONFIG_ID")));
            dataObject.addRow(row4);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            return configId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Integer getConfigId(Long scheduleId) {
        try {
            String tableName = "TPIntegrationScheduleMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                return null;
            }
            Row r = dataObject.getFirstRow(tableName);
            Integer configId = (Integer)r.get("CONFIG_ID");
            return configId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isCompleted(int executorId) {
        return true;
    }

    public static Long getLoginId(int configId) {
        Long loginId = null;
        try {
            String tableName = "TPIntegrationConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Row r = dataObject.getFirstRow(tableName);
            loginId = (Long)r.get("LOGIN_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginId;
    }

    public static String getLocale(int configId) {
        String locale = null;
        try {
            String tableName = "TPIntegrationConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Row r = dataObject.getFirstRow(tableName);
            locale = (String)r.get("LOCALE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return locale;
    }
}

