/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ScheduledMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.integration.MSSQLDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.OracleDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.util.CustomAttribUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBDataSourceUtil {
    public static String getLocalTableName(Integer configId, Long scheduleId) {
        if (scheduleId != null) {
            return "IntegrationDBRecords_" + configId + "_" + scheduleId;
        }
        return "IntegrationDBRecords_" + configId;
    }

    public static String getDBType(int configId) {
        try {
            String tableName = "DBInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Row r = dataObject.getFirstRow(tableName);
            String dbType = (String)r.get("DB_TYPE");
            return dbType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Hashtable getConfigDetails(int configId) {
        Hashtable configData = new Hashtable();
        try {
            String tableName = "DBInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                String dbType = (String)r.get("DB_TYPE");
                String configName = (String)r.get("CONFIG_NAME");
                String configDesc = (String)r.get("CONFIG_DESCRIPTION");
                table = Table.getTable((String)"ThirdPartyDBDetails");
                query = new SelectQueryImpl(table);
                criteria = new Criteria(Column.getColumn((String)"ThirdPartyDBDetails", (String)"DB_TYPE"), (Object)dbType, 0);
                query.setCriteria(criteria);
                query.addSelectColumn(Column.getColumn(null, (String)"*"));
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                if (dataObject.isEmpty()) {
                    return configData;
                }
                r = dataObject.getFirstRow("ThirdPartyDBDetails");
                String username = (String)r.get("USER_NAME");
                String password = (String)r.get("PASSWORD");
                String serverName = (String)r.get("SERVER_NAME");
                String portNumber = (String)r.get("PORT_NUMBER");
                String domainName = (String)r.get("DOMAIN_NAME");
                String authenticationType = (String)r.get("AUTHENTICATION_TYPE");
                String instanceName = (String)r.get("INSTANCE_NAME");
                configData = dbType.equals("mssql") ? MSSQLDataSourceUtil.getDBSpecificDetails(configId) : OracleDataSourceUtil.getDBSpecificDetails(configId);
                if (configData.isEmpty()) {
                    return configData;
                }
                configData.put("DB_TYPE", dbType);
                configData.put("CONFIG_NAME", configName);
                configData.put("CONFIG_DESCRIPTION", configDesc);
                configData.put("USER_NAME", username == null ? "" : username);
                configData.put("PASSWORD", password == null ? "" : password);
                configData.put("SERVER_NAME", serverName);
                configData.put("PORT_NUMBER", portNumber == null ? "" : portNumber);
                configData.put("DOMAIN_NAME", domainName == null ? "" : domainName);
                configData.put("AUTHENTICATION_TYPE", authenticationType == null ? "" : authenticationType);
                configData.put("INSTANCE_NAME", instanceName == null ? "" : instanceName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    public static JSONArray getDBAttrMapping(int configId) {
        JSONArray mappingData = new JSONArray();
        try {
            String tableName = "TPIntegrationAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Iterator it = dataObject.getRows(tableName, (Criteria)null);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("dbColumnName", r.get("DB_COLUMN"));
                jsonObj.put("ldapName", r.get("GENERIC_COLUMN"));
                jsonObj.put("isPrimary", r.get("IS_PRIMARY"));
                mappingData.put((Object)jsonObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappingData;
    }

    public static void updateDBAttrMapping(int configId, JSONArray jsonArr) {
        try {
            String tableName = "TPIntegrationAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                dataObject.deleteRows(tableName, (Criteria)null);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            }
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int ii = 0; ii < jsonArr.length(); ++ii) {
                JSONObject jsonObj = (JSONObject)jsonArr.get(ii);
                Row r = new Row("TPIntegrationAttrMapping");
                r.set("CONFIG_ID", (Object)configId);
                r.set("GENERIC_COLUMN", jsonObj.get("ldapName"));
                r.set("DB_COLUMN", jsonObj.get("dbColumnName"));
                r.set("IS_PRIMARY", jsonObj.get("isPrimary"));
                dataObject.addRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Integer addDBConfigData(Hashtable<String, String> props, String dbType, String configName, String configDesc) {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row = new Row("DBInputConfig");
            row.set("DB_TYPE", (Object)dbType);
            row.set("CONFIG_NAME", (Object)configName);
            row.set("CONFIG_DESCRIPTION", (Object)configDesc);
            dataObject.addRow(row);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            Integer configId = (Integer)row.get("CONFIG_ID");
            if (dbType.equals("mssql")) {
                MSSQLDataSourceUtil.addDBConfigData(props, configId);
            } else {
                OracleDataSourceUtil.addDBConfigData(props, configId);
            }
            return configId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean updateDBConfigData(Integer configId, String dbType, Hashtable<String, String> props, String configName, String configDesc) {
        try {
            String tableName = "DBInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                r.set("CONFIG_NAME", (Object)configName);
                r.set("CONFIG_DESCRIPTION", (Object)configDesc);
                dataObject.updateRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            }
            if (dbType.equals("mssql")) {
                return MSSQLDataSourceUtil.updateDBConfigData(configId, props);
            }
            return OracleDataSourceUtil.updateDBConfigData(configId, props);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Integer getConfigId(Long scheduleId) {
        try {
            String tableName = "TPIntegrationScheduleMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                return null;
            }
            Row r = dataObject.getFirstRow(tableName);
            Integer configId = (Integer)r.get("CONFIG_ID");
            return configId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String validateConnection(Hashtable<String, String> props, String dbType) {
        if (dbType.equals("mssql")) {
            return MSSQLDataSourceUtil.validateConnection(props);
        }
        return OracleDataSourceUtil.validateConnection(props);
    }

    public static ArrayList getColumnList(String dbType, String databaseName, String tableName) {
        if (dbType.equals("mssql")) {
            return MSSQLDataSourceUtil.getColumnList(databaseName, tableName);
        }
        return OracleDataSourceUtil.getColumnList(databaseName, tableName);
    }

    public static Hashtable getDBServerDetails(String dbType) {
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        try {
            Table table = Table.getTable((String)"ThirdPartyDBDetails");
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)"ThirdPartyDBDetails", (String)"DB_TYPE"), (Object)dbType, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow("ThirdPartyDBDetails");
                values.put("username", r.get("USER_NAME") == null ? "" : r.get("USER_NAME"));
                values.put("password", r.get("PASSWORD") == null ? "" : r.get("PASSWORD"));
                values.put("serverName", r.get("SERVER_NAME"));
                values.put("portNumber", r.get("PORT_NUMBER") == null ? "" : r.get("PORT_NUMBER"));
                values.put("domainName", r.get("DOMAIN_NAME") == null ? "" : r.get("DOMAIN_NAME"));
                values.put("authenticationType", r.get("AUTHENTICATION_TYPE") == null ? "" : r.get("AUTHENTICATION_TYPE"));
                values.put("instanceName", r.get("INSTANCE_NAME") == null ? "" : r.get("INSTANCE_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public static JSONObject deleteConfig(Integer configId, String sourceType) {
        JSONObject resultObj = new JSONObject();
        try {
            String tableName = sourceType + "InputConfig";
            Criteria checkConfigInUse = new Criteria(Column.getColumn((String)"TPIntegrationScheduleMapping", (String)"CONFIG_TYPE"), (Object)sourceType, 0);
            if (sourceType.equalsIgnoreCase("DB")) {
                checkConfigInUse = checkConfigInUse.or(new Criteria(Column.getColumn((String)"TPIntegrationScheduleMapping", (String)"CONFIG_TYPE"), null, 0));
            }
            checkConfigInUse = checkConfigInUse.and(new Criteria(Column.getColumn((String)"TPIntegrationScheduleMapping", (String)"CONFIG_ID"), (Object)configId, 0));
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("TPIntegrationScheduleMapping", checkConfigInUse);
            Iterator it = obj.getRows("TPIntegrationScheduleMapping");
            if (it.hasNext()) {
                JSONArray configUsedInArray = new JSONArray();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    configUsedInArray.put((Object)ScheduledMgmtUtil.getAutomationName((Long)((Long)r.get("SCHEDULE_ID"))));
                }
                resultObj.put("message", (Object)"failed");
                resultObj.put("configUsedInArray", (Object)configUsedInArray);
            } else {
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
                resultObj.put("message", (Object)"success");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultObj;
    }

    public static boolean duplicateConfigName(String configName, String dbType, Integer configId, String action) {
        try {
            String tableName = "DBInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_NAME"), (Object)configName, 0);
            if (action.equalsIgnoreCase("edit")) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 1));
            }
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"DB_TYPE"), (Object)dbType, 0));
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            return !dataObject.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ArrayList getLdapAttrList() {
        ArrayList<Object> lDAPlist = new ArrayList<Object>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMIntegrationLDAPAttribs"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMIntegrationLDAPAttribs", (String)"LDAP_NAME"), null, 1);
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMIntegrationLDAPAttribs", (String)"LDAP_NAME"), true));
        DataObject dataObject = null;
        try {
            dataObject = DataAccess.get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator lDAPRowsIterator = dataObject.getRows("ADSMIntegrationLDAPAttribs");
                while (lDAPRowsIterator.hasNext()) {
                    Row row = (Row)lDAPRowsIterator.next();
                    lDAPlist.add((String)row.get("LDAP_NAME"));
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        ArrayList customAttributes = CustomAttribUtil.getFieldList();
        for (Properties prop : customAttributes) {
            if (prop.get("DATA_TYPE").toString().equalsIgnoreCase("MULTIVALUE") || !prop.get("MGMT_ACTIONS").toString().contains("userCreation") && !prop.get("MGMT_ACTIONS").toString().contains("userModification")) continue;
            lDAPlist.add(prop.get("LDAP_NAME"));
        }
        return lDAPlist;
    }

    public static String getProcessedWhereCriteria(int matchCriteria, String columnName, String columnValue) {
        String whereCriteria = "";
        columnValue = columnValue.replaceAll("'", "''");
        switch (matchCriteria) {
            case 2: {
                whereCriteria = columnName + " LIKE '" + columnValue + "'";
                break;
            }
            case 3: {
                whereCriteria = columnName + " NOT LIKE '" + columnValue + "'";
                break;
            }
            case 12: {
                whereCriteria = columnName + " LIKE '%" + columnValue + "%'";
                break;
            }
            case 13: {
                whereCriteria = columnName + " NOT LIKE '%" + columnValue + "%'";
                break;
            }
            case 5: {
                whereCriteria = columnName + " > '" + columnValue + "'";
                break;
            }
            case 7: {
                whereCriteria = columnName + " < '" + columnValue + "'";
                break;
            }
            case 4: {
                whereCriteria = columnName + " >= '" + columnValue + "'";
                break;
            }
            case 6: {
                whereCriteria = columnName + " <= '" + columnValue + "'";
                break;
            }
            case 10: {
                whereCriteria = columnName + " LIKE '" + columnValue + "%'";
                break;
            }
            case 11: {
                whereCriteria = columnName + " LIKE '%" + columnValue + "'";
                break;
            }
            case 0: {
                whereCriteria = columnName + " = '" + columnValue + "'";
                System.out.println("whereCriteria :" + whereCriteria);
                break;
            }
            case 1: {
                whereCriteria = columnName + " != '" + columnValue + "'";
            }
        }
        return whereCriteria;
    }

    public static JSONObject getColumnNameVsTypeMapping(int configId) {
        Hashtable configDetails = DBDataSourceUtil.getConfigDetails(configId);
        JSONObject nameVsTypeMap = new JSONObject();
        String dbType = (String)configDetails.get("DB_TYPE");
        String databaseName = "";
        String tableName = "";
        if (dbType.equals("mssql")) {
            databaseName = (String)configDetails.get("DATABASE_NAME");
            tableName = (String)configDetails.get("TABLE_NAME");
            nameVsTypeMap = MSSQLDataSourceUtil.getColumnNameVsTypeMapping(databaseName, tableName);
        } else {
            databaseName = (String)configDetails.get("SID");
            tableName = (String)configDetails.get("TABLE_NAME");
            nameVsTypeMap = OracleDataSourceUtil.getColumnNameVsTypeMapping(databaseName, tableName);
        }
        return nameVsTypeMap;
    }

    public static void deleteCustomAttribMappings(String ldapName) {
        try {
            List<String> tableList = Arrays.asList("TPIntegrationAttrMapping", "WorkdayIntegAttrMapping", "ZohoIntegAttrMapping");
            for (int index = 0; index < tableList.size(); ++index) {
                String tableName = tableList.get(index);
                Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"GENERIC_COLUMN"), (Object)ldapName, 0);
                DataAccess.delete((Criteria)c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

