/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class MSSQLDataSourceUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDBConnection(String serverName, String portNumber, String domainName, String username, String password, String instanceName, String authenticationType) {
        Connection conn = null;
        try {
            String url = "jdbc:jtds:sqlserver://" + serverName + ":" + portNumber + ";instanceName=" + instanceName + ";";
            if ("windows".equals(authenticationType)) {
                url = url + "useNTLMv2=true;domain=" + domainName + "";
            }
            String driverClass = "net.sourceforge.jtds.jdbc.Driver";
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, username, password);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Hashtable getDBSpecificDetails(int configId) {
        Hashtable<String, Object> configData = new Hashtable<String, Object>();
        try {
            String tableName = "MsSqlInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                configData.put("DATABASE_NAME", r.get("DATABASE_NAME"));
                configData.put("TABLE_NAME", r.get("TABLE_NAME"));
                configData.put("IS_VALID", Boolean.toString((Boolean)r.get("IS_VALID")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    public static boolean addDBConfigData(Hashtable<String, String> props, Integer configId) {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row3 = new Row("MsSqlInputConfig");
            row3.set("DATABASE_NAME", (Object)props.get("dbName"));
            row3.set("TABLE_NAME", (Object)props.get("tableName"));
            row3.set("CONFIG_ID", (Object)configId);
            row3.set("IS_VALID", (Object)true);
            dataObject.addRow(row3);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean updateDBConfigData(Integer configId, Hashtable<String, String> props) {
        try {
            String tableName = "MsSqlInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                r.set("DATABASE_NAME", (Object)props.get("dbName"));
                r.set("TABLE_NAME", (Object)props.get("tableName"));
                r.set("IS_VALID", (Object)true);
                dataObject.updateRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ArrayList getColumnList(String databaseName, String tableName) {
        Iterator it = MSSQLDataSourceUtil.getColumnNameVsTypeMapping(databaseName, tableName).keys();
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getColumnNameVsTypeMapping(String databaseName, String tableName) {
        Connection conn = null;
        ResultSet resultSet = null;
        JSONObject columnDataTypeMap = new JSONObject();
        try {
            Hashtable dbDetails = DBDataSourceUtil.getDBServerDetails("mssql");
            String username = (String)dbDetails.get("username");
            String password = (String)dbDetails.get("password");
            String serverName = (String)dbDetails.get("serverName");
            String portNumber = (String)dbDetails.get("portNumber");
            String instanceName = (String)dbDetails.get("instanceName");
            String authenticationType = (String)dbDetails.get("authenticationType");
            String domainName = (String)dbDetails.get("domainName");
            String url = "jdbc:jtds:sqlserver://" + serverName + ":" + portNumber + "/" + instanceName + ";databaseName=" + databaseName + ";";
            if ("windows".equals(authenticationType)) {
                url = url + "useNTLMv2=true;domain=" + domainName;
            }
            String driverClass = "net.sourceforge.jtds.jdbc.Driver";
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, username, password);
            resultSet = conn.getMetaData().getColumns(databaseName, null, tableName, null);
            if (resultSet != null) {
                while (resultSet.next()) {
                    columnDataTypeMap.put(resultSet.getString(4), (Object)Integer.toString(resultSet.getInt(5)));
                }
            }
            JSONObject jSONObject = columnDataTypeMap;
            return jSONObject;
        }
        catch (Exception e) {
            JSONObject jSONObject = columnDataTypeMap;
            return jSONObject;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateConnection(Hashtable<String, String> props) {
        Connection conn = null;
        ResultSet resultSet = null;
        ArrayList list = new ArrayList();
        try {
            Hashtable dbDetails = DBDataSourceUtil.getDBServerDetails("mssql");
            String username = (String)dbDetails.get("username");
            String password = (String)dbDetails.get("password");
            String serverName = (String)dbDetails.get("serverName");
            String portNumber = (String)dbDetails.get("portNumber");
            String instanceName = (String)dbDetails.get("instanceName");
            String authenticationType = (String)dbDetails.get("authenticationType");
            String domainName = (String)dbDetails.get("domainName");
            String databaseName = props.get("dbName");
            String tableName = props.get("tableName");
            String url = "jdbc:jtds:sqlserver://" + serverName + ":" + portNumber + "/" + instanceName + ";databaseName=" + databaseName + ";";
            if ("windows".equals(authenticationType)) {
                url = url + "useNTLMv2=true;domain=" + domainName;
            }
            String driverClass = "net.sourceforge.jtds.jdbc.Driver";
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, username, password);
            resultSet = conn.getMetaData().getColumns(databaseName, null, tableName, null);
            if (resultSet != null && !resultSet.next()) {
                String string = "table_does_not_exists";
                return string;
            }
            resultSet.close();
            DatabaseMetaData meta = conn.getMetaData();
            resultSet = meta.getPrimaryKeys(null, null, tableName);
            if (!resultSet.next()) {
                JSONArray jsonArr = new JSONArray(props.get("attrMapping"));
                for (int ii = 0; ii < jsonArr.length(); ++ii) {
                    JSONObject jsonObj = (JSONObject)jsonArr.get(ii);
                    String isPrimary = (String)jsonObj.get("isPrimary");
                    if (!isPrimary.equalsIgnoreCase("true")) continue;
                    String string = "success";
                    return string;
                }
                String ii = "empty_primary_keys_list";
                return ii;
            }
            String string = "success";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Hashtable getInstanceList(String hostName) {
        byte[] bytBuffer = new byte[1024];
        try {
            DatagramSocket ds = new DatagramSocket();
            ds.setSoTimeout(6000);
            InetAddress iadd = InetAddress.getByName(hostName);
            ds.connect(iadd, 1434);
            byte[] msg = new byte[]{2};
            DatagramPacket dp = new DatagramPacket(msg, msg.length);
            ds.send(dp);
            DatagramPacket dpr = new DatagramPacket(bytBuffer, bytBuffer.length);
            ds.receive(dpr);
        }
        catch (PortUnreachableException ure) {
            System.out.println("unable_to_fetch_sql_server_instances");
            ure.printStackTrace();
        }
        catch (UnknownHostException uhe) {
            System.out.println("unknown_host");
            uhe.printStackTrace();
        }
        catch (SocketTimeoutException ste) {
            System.out.println("socket_timeout_while_fetching_instances_from_host");
            ste.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String instances = new String(bytBuffer);
        String[] instance = instances.split(";;");
        int len = instance.length;
        ArrayList<String> instanceList = new ArrayList<String>();
        ArrayList<String> portNumberList = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            if (instance[i].trim().equals("")) continue;
            String[] temp = instance[i].split(";");
            for (int j = 0; j < temp.length; j += 2) {
                if (temp[j].indexOf("ServerName") >= 0) continue;
                if (temp[j].indexOf("InstanceName") >= 0) {
                    instanceList.add(temp[j + 1].trim());
                    continue;
                }
                if (temp[j].indexOf("tcp") < 0) continue;
                portNumberList.add(temp[j + 1].trim());
            }
        }
        Hashtable instanceHash = new Hashtable();
        for (int i = 0; i < instanceList.size(); ++i) {
            instanceHash.put(instanceList.get(i), portNumberList.get(i));
        }
        return instanceHash;
    }

    public static ArrayList getAvailableDBNames() {
        ArrayList<String> dbList = new ArrayList<String>();
        try {
            Hashtable dbDetails = DBDataSourceUtil.getDBServerDetails("mssql");
            String username = (String)dbDetails.get("username");
            String password = (String)dbDetails.get("password");
            String serverName = (String)dbDetails.get("serverName");
            String portNumber = (String)dbDetails.get("portNumber");
            String instanceName = (String)dbDetails.get("instanceName");
            String authenticationType = (String)dbDetails.get("authenticationType");
            String domainName = (String)dbDetails.get("domainName");
            String url = "jdbc:jtds:sqlserver://" + serverName + ":" + portNumber + ";instanceName=" + instanceName + ";";
            if ("windows".equals(authenticationType)) {
                url = url + "useNTLMv2=true;domain=" + domainName;
            }
            String driverClass = "net.sourceforge.jtds.jdbc.Driver";
            Class.forName(driverClass);
            Connection conn = DriverManager.getConnection(url, username, password);
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet catalogRS = conn.getMetaData().getCatalogs();
            while (catalogRS.next()) {
                dbList.add(catalogRS.getString(1));
            }
        }
        catch (Exception e) {
            System.out.println("Connection exception occurred...");
            e.printStackTrace();
        }
        return dbList;
    }
}

