/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DynamicTableUtil;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import com.adventnet.sym.adsm.common.webclient.integration.InputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.WorkdayUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.json.JSONObject;

public class WorkdayInputDataSource
extends InputDataSource {
    private static Logger out = Logger.getLogger("WFLogger");
    private final String serviceVersion = "v27.2";
    String tenantId;
    String password;
    String syncType;
    String endpointURL;
    GenericData genericResponse;
    Hashtable genericRecord;
    Hashtable inputRecord;
    ArrayList<Properties> parsedUsersList = new ArrayList();
    Properties userProperties = new Properties();
    final String primaryColumn = "worker_id";
    SOAPConnectionFactory soapConnectionFactory;
    SOAPConnection soapConnection;
    static Long scheduleId;
    private static Logger logger;
    Integer totalResponsePages = 1;
    Integer currentResponsePage = 1;
    String currentDate = "";
    String noOfRecordsPerResponse = "1";
    String domainName = "";
    int configId;
    Hashtable<String, String> configData = null;
    DataObject integAdvncCriteriaObj = null;

    public void setIntegAdvncCriteriaId(Long integAdvncCriteriaId) {
        JSONObject json = new JSONObject();
        Criteria c = new Criteria(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"CRITERIA_ID"), (Object)integAdvncCriteriaId, 0);
        SelectQueryImpl critQuery = new SelectQueryImpl(Table.getTable((String)"AutoIntegAdvancCriteriaDetails"));
        critQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        critQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"PROCESSING_ORDER"), true));
        critQuery.setCriteria(c);
        try {
            this.integAdvncCriteriaObj = DataAccess.get((SelectQuery)critQuery);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private boolean checkIntegAdvncCriteria(Hashtable record) {
        boolean satisfied = true;
        if (this.integAdvncCriteriaObj != null) {
            Row row = null;
            HashMap attrMapping = WorkdayUtil.getDisplayVsTableColumnsMapping();
            try {
                Iterator it = this.integAdvncCriteriaObj.getRows("AutoIntegAdvancCriteriaDetails");
                if (it.hasNext()) {
                    row = (Row)it.next();
                    String givenValue = (String)record.get(attrMapping.get((String)row.get("COLUMN_NAME")));
                    satisfied = WorkdayInputDataSource.processSingleCondition(Integer.parseInt((String)row.get("MATCH_CRITERIA")), givenValue, (String)row.get("COLUMN_VALUE"));
                    while (it.hasNext()) {
                        row = (Row)it.next();
                        givenValue = (String)record.get(attrMapping.get((String)row.get("COLUMN_NAME")));
                        if (((String)row.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("or")) {
                            satisfied = satisfied || WorkdayInputDataSource.processSingleCondition(Integer.parseInt((String)row.get("MATCH_CRITERIA")), givenValue, (String)row.get("COLUMN_VALUE"));
                            continue;
                        }
                        satisfied = satisfied && WorkdayInputDataSource.processSingleCondition(Integer.parseInt((String)row.get("MATCH_CRITERIA")), givenValue, (String)row.get("COLUMN_VALUE"));
                    }
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return satisfied;
    }

    public static boolean processSingleCondition(int matchCriteria, String givenValue, String conditionValue) {
        try {
            switch (matchCriteria) {
                case 0: 
                case 2: {
                    if (!givenValue.equals(conditionValue) && !givenValue.replaceFirst("^0*", "").equals(conditionValue)) break;
                    return true;
                }
                case 1: 
                case 3: {
                    if (givenValue.equals(conditionValue) || givenValue.replaceFirst("^0*", "").equals(conditionValue)) break;
                    return true;
                }
                case 10: {
                    if (!givenValue.startsWith(conditionValue)) break;
                    return true;
                }
                case 11: {
                    if (!givenValue.endsWith(conditionValue)) break;
                    return true;
                }
                case 12: {
                    if (!givenValue.contains(conditionValue)) break;
                    return true;
                }
                case 13: {
                    if (givenValue.contains(conditionValue)) break;
                    return true;
                }
                case 5: {
                    if (Integer.parseInt(givenValue.trim()) <= Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
                case 7: {
                    if (Integer.parseInt(givenValue.trim()) >= Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
                case 4: {
                    if (Integer.parseInt(givenValue.trim()) < Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
                case 6: {
                    if (Integer.parseInt(givenValue.trim()) > Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public WorkdayInputDataSource(int confId, Long scheduleId) throws Exception {
        this.configId = confId;
        this.syncType = "all";
        try {
            this.soapConnectionFactory = SOAPConnectionFactory.newInstance();
            this.soapConnection = this.soapConnectionFactory.createConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WorkdayInputDataSource.scheduleId = scheduleId;
        this.configData = WorkdayInputDataSource.getConfigDetails(this.configId);
        this.setCredentials();
        this.createTable();
    }

    public static Hashtable getConfigDetails(int configId) {
        Hashtable<String, String> configData = new Hashtable<String, String>();
        try {
            String tableName = "WorkdayInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                String configName = (String)r.get("CONFIG_NAME");
                String configDesc = (String)r.get("CONFIG_DESCRIPTION");
                configData.put("CONFIG_NAME", configName);
                configData.put("CONFIG_DESCRIPTION", configDesc);
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayAccountDetails", (Criteria)null);
                if (dataObject.isEmpty()) {
                    return configData;
                }
                r = dataObject.getFirstRow("WorkdayAccountDetails");
                String username = (String)r.get("WORKDAY_TENANT_ID");
                String password = (String)r.get("PASSWORD");
                String endPoint = (String)r.get("ENDPOINT_URL");
                configData.put("USER_NAME", username == null ? "" : username);
                configData.put("PASSWORD", password == null ? "" : password);
                configData.put("ENDPOINT", endPoint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    private void setCredentials() {
        try {
            DataObject workdayDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayAccountDetails", (Criteria)null);
            if (!workdayDataObj.isEmpty()) {
                Row wdCredRow = workdayDataObj.getFirstRow("WorkdayAccountDetails");
                this.tenantId = (String)wdCredRow.get("WORKDAY_TENANT_ID");
                this.password = (String)wdCredRow.get("PASSWORD");
                this.endpointURL = (String)wdCredRow.get("ENDPOINT_URL");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public WorkdayInputDataSource(int configId) throws Exception {
        try {
            this.soapConnectionFactory = SOAPConnectionFactory.newInstance();
            this.soapConnection = this.soapConnectionFactory.createConnection();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date();
            this.currentDate = dateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static WorkdayInputDataSource getInstance(int configId, Long scheduleId) throws Exception {
        return new WorkdayInputDataSource(configId, scheduleId);
    }

    @Override
    public GenericData readData(String syncType) {
        return this.readData(this.tenantId, this.password, syncType);
    }

    public GenericData readData(String tenantId, String password, String syncType) {
        this.tenantId = tenantId;
        this.password = password;
        this.syncType = syncType;
        return this.readDataFromWD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericData readDataFromWD() {
        try {
            Object soapResponse;
            this.soapConnection = this.soapConnectionFactory.createConnection();
            this.genericResponse = new GenericData();
            this.totalResponsePages = 1;
            this.currentResponsePage = 1;
            this.noOfRecordsPerResponse = "100";
            while (this.currentResponsePage <= this.totalResponsePages) {
                soapResponse = this.soapConnection.call(this.createGetWorkersRequest(this.tenantId, this.password), (Object)this.endpointURL);
                Serializable dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = new Date();
                this.currentDate = dateFormat.format(date);
                this.parseGetWorkersResponse((SOAPMessage)soapResponse);
                soapResponse = this.currentResponsePage;
                this.currentResponsePage = this.currentResponsePage + 1;
                dateFormat = this.currentResponsePage;
            }
            this.getGenericResponseFromParsedUsersList();
            out.log(Level.INFO, "Workday response users count :" + this.genericResponse.toJSONArray().length());
            soapResponse = this.genericResponse;
            return soapResponse;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error occurred while sending SOAP Request to Server");
            e.printStackTrace();
        }
        finally {
            try {
                this.soapConnection.close();
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericData readDataFromFile() {
        try {
            String line;
            this.genericResponse = new GenericData();
            String fileName = "E:\\Working Product\\Task-4 Workday\\customer_response.xml";
            BufferedReader br = new BufferedReader(new FileReader(new File(fileName)));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
            }
            SOAPMessage soapResponse = MessageFactory.newInstance().createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(sb.toString().getBytes(Charset.forName("UTF-8"))));
            if (this.parsedUsersList.size() == 0) {
                this.parseGetWorkersResponse(soapResponse);
            }
            this.getGenericResponseFromParsedUsersList();
            out.log(Level.INFO, "Workday response users count :" + this.genericResponse.toJSONArray().length());
            GenericData genericData = this.genericResponse;
            return genericData;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error occurred while sending SOAP Request to Server");
            e.printStackTrace();
        }
        finally {
            try {
                this.soapConnection.close();
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void getGenericResponseFromParsedUsersList() {
        this.updateLocalDBColumns();
        HashMap localAttrMapping = WorkdayUtil.getDisplayVsTableColumnsMapping();
        Hashtable configAttrMapping = this.getAttrMapping();
        try {
            if (this.syncType.equalsIgnoreCase(AutomationConstants.GET_DELETED)) {
                Iterator it;
                String tableName = WorkdayInputDataSource.getLocalTableName();
                ArrayList<String> workerIdsFromResponse = new ArrayList<String>();
                for (Properties userProps : this.parsedUsersList) {
                    workerIdsFromResponse.add((String)userProps.get("worker_id"));
                }
                Criteria missingInWorkdayCrit = new Criteria(Column.getColumn((String)tableName, (String)"worker_id"), (Object)workerIdsFromResponse.toArray(), 9);
                if (this.integAdvncCriteriaObj != null) {
                    Criteria advncCriteria = null;
                    it = this.integAdvncCriteriaObj.getRows("AutoIntegAdvancCriteriaDetails");
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Column columnName = Column.getColumn((String)tableName, (String)((String)localAttrMapping.get(r.get("COLUMN_NAME"))));
                        String columnValue = (String)r.get("COLUMN_VALUE");
                        int matchCriteria = Integer.parseInt((String)r.get("MATCH_CRITERIA"));
                        Criteria crit = new Criteria(columnName, (Object)columnValue, matchCriteria);
                        if (advncCriteria == null) {
                            advncCriteria = crit;
                            continue;
                        }
                        if (((String)r.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("or")) {
                            advncCriteria = advncCriteria.or(crit);
                            continue;
                        }
                        if (!((String)r.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("and")) continue;
                        advncCriteria = advncCriteria.and(crit);
                    }
                    if (advncCriteria != null) {
                        missingInWorkdayCrit = missingInWorkdayCrit.and(advncCriteria);
                    }
                }
                DataObject generatedTableObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, missingInWorkdayCrit);
                it = generatedTableObj.getRows(tableName);
                while (it.hasNext()) {
                    Hashtable<String, String> record = new Hashtable<String, String>();
                    Hashtable<String, String> chkRecord = new Hashtable<String, String>();
                    Row r = (Row)it.next();
                    for (String column : this.getAdvncConfigColumns()) {
                        String dbColumnName = column.toLowerCase();
                        if (r.get(dbColumnName) == null) continue;
                        Object colVal = r.get(dbColumnName);
                        String columnValue = this.getUpdatedValue(dbColumnName, colVal.toString().trim());
                        Set keys = configAttrMapping.keySet();
                        for (String key : keys) {
                            if (!((String)configAttrMapping.get(key)).equalsIgnoreCase(dbColumnName)) continue;
                            record.put(key, columnValue);
                        }
                        chkRecord.put(dbColumnName, columnValue);
                    }
                    this.genericResponse.addRecord(record, chkRecord);
                }
            } else {
                for (Properties userProps : this.parsedUsersList) {
                    Hashtable<String, String> record = new Hashtable<String, String>();
                    Hashtable<String, String> chkRecord = new Hashtable<String, String>();
                    ArrayList wdTableColumnList = new ArrayList(WorkdayUtil.getDisplayVsTableColumnsMapping().values());
                    for (String wdColumnName : wdTableColumnList) {
                        if (userProps.get(wdColumnName) != null) {
                            String columnValue = this.getUpdatedValue(wdColumnName, ((String)userProps.get(wdColumnName)).trim());
                            Set keys = configAttrMapping.keySet();
                            for (String key : keys) {
                                if (!((String)configAttrMapping.get(key)).equalsIgnoreCase(wdColumnName)) continue;
                                record.put(key, columnValue);
                            }
                            chkRecord.put(wdColumnName, columnValue);
                            continue;
                        }
                        chkRecord.put(wdColumnName, "");
                    }
                    if (!this.canAddRecordsToDB(chkRecord)) continue;
                    this.genericResponse.addRecord(record, chkRecord);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private String getUpdatedValue(String dbColumnName, String val) {
        Hashtable attrMapping = this.getAttrMapping();
        if (attrMapping.containsKey("userAccountControl") && ((String)attrMapping.get("userAccountControl")).equalsIgnoreCase(dbColumnName)) {
            ArrayList<String> activeState = new ArrayList<String>(Arrays.asList("true", "yes", "1", "active", "activated", "enable", "enabled", "512"));
            if (activeState.contains(val.toLowerCase())) {
                return "0;2";
            }
            return "2;0";
        }
        return val;
    }

    public SOAPMessage createGetWorkersRequest(String tenantId, String password) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration("bsvc", "urn:com.workday/bsvc");
        envelope.addNamespaceDeclaration("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SOAPHeader workersReqHeader = envelope.getHeader();
        WorkdayUtil.addCommonHeader(workersReqHeader);
        WorkdayUtil.addAuthenticationElement(workersReqHeader, tenantId, password);
        SOAPBody workersReqBody = envelope.getBody();
        SOAPElement requestRoot = workersReqBody.addChildElement("Get_Workers_Request", "bsvc");
        requestRoot.addAttribute(new QName("urn:com.workday/bsvc", "version", "bsvc"), "v27.2");
        this.addRequestCriteria(requestRoot);
        this.addResponseFilter(requestRoot);
        this.addResponseGroup(requestRoot);
        MimeHeaders headers = soapMessage.getMimeHeaders();
        headers.addHeader("Content-Type", "text/xml; charset=utf-8");
        headers.addHeader("SOAPAction", "");
        soapMessage.saveChanges();
        return soapMessage;
    }

    private void addRequestCriteria(SOAPElement requestRoot) throws Exception {
        SOAPElement criteriaElement = requestRoot.addChildElement("Request_Criteria", "bsvc");
        criteriaElement.addChildElement("Include_Subordinate_Organizations", "bsvc").addTextNode("true");
        criteriaElement.addChildElement("Exclude_Inactive_Workers", "bsvc").addTextNode("false");
        criteriaElement.addChildElement("Exclude_Employees", "bsvc").addTextNode("false");
        criteriaElement.addChildElement("Exclude_Contingent_Workers", "bsvc").addTextNode("true");
    }

    private void addResponseFilter(SOAPElement requestRoot) throws Exception {
        SOAPElement criteriaElement = requestRoot.addChildElement("Response_Filter", "bsvc");
        criteriaElement.addChildElement("As_Of_Effective_Date", "bsvc").addTextNode(this.currentDate);
        criteriaElement.addChildElement("Page", "bsvc").addTextNode(Integer.toString(this.currentResponsePage));
        criteriaElement.addChildElement("Count", "bsvc").addTextNode(this.noOfRecordsPerResponse);
    }

    private void addResponseGroup(SOAPElement requestRoot) throws Exception {
        SOAPElement responseGroupElement = requestRoot.addChildElement("Response_Group", "bsvc");
        responseGroupElement.addChildElement("Include_Reference", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Include_Personal_Information", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Include_Additional_Jobs", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Employment_Information", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Include_Compensation", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Organizations", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Exclude_Organization_Support_Role_Data", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Location_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Cost_Centers", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Cost_Center_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Companies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Company_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Matrix_Organizations", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Pay_Groups", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Regions", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Exclude_Region_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Supervisory_Organizations", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Exclude_Teams", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Custom_Organizations", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Include_Roles", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Management_Chain_Data", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Multiple_Managers_in_Management_Chain_Data", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Benefit_Enrollments", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Benefit_Eligibility", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Related_Persons", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Qualifications", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Employee_Review", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Goals", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Development_Items", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Skills", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Photo", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Worker_Documents", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Transaction_Log_Data", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Subevents_for_Corrected_Transaction", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Subevents_for_Rescinded_Transaction", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Succession_Profile", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Talent_Assessment", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Employee_Contract_Data", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Collective_Agreement_Data", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Probation_Period_Data", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Feedback_Received", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_User_Account", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Include_Career", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Account_Provisioning", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Background_Check_Data", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Include_Contingent_Worker_Tax_Authority_Form_Information", "bsvc").addTextNode("false");
        responseGroupElement.addChildElement("Exclude_Funds", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Fund_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Grants", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Grant_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Business_Units", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Business_Unit_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Programs", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Program_Hierarchies", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Gifts", "bsvc").addTextNode("true");
        responseGroupElement.addChildElement("Exclude_Gift_Hierarchies", "bsvc").addTextNode("true");
    }

    public void parseGetWorkersResponse(SOAPMessage soapResponse) throws Exception {
        if (this.genericResponse == null) {
            this.genericResponse = new GenericData();
        }
        SOAPBody responseBody = soapResponse.getSOAPBody();
        SOAPElement getWorkersResponse = this.getFirstSOAPElementByName((SOAPElement)responseBody, "Get_Workers_Response");
        SOAPElement responseData = this.getFirstSOAPElementByName(getWorkersResponse, "Response_Data");
        SOAPElement responseResults = this.getFirstSOAPElementByName(getWorkersResponse, "Response_Results");
        if (responseResults != null) {
            String responseResultsVals = this.getFirstSOAPElementByName(responseResults, "Total_Pages").getValue();
            this.totalResponsePages = !responseResultsVals.isEmpty() ? Integer.parseInt(responseResultsVals) : 0;
            responseResultsVals = this.getFirstSOAPElementByName(responseResults, "Page").getValue();
            this.currentResponsePage = !responseResultsVals.isEmpty() ? Integer.parseInt(responseResultsVals) : 0;
        }
        if (responseData != null) {
            Iterator iterator = responseData.getChildElements();
            if (iterator.hasNext()) {
                do {
                    this.userProperties = new Properties();
                    SOAPElement worker = (SOAPElement)iterator.next();
                    SOAPElement workerData = this.getFirstSOAPElementByName(worker, "Worker_Data");
                    if (workerData != null) {
                        SOAPElement employmentData;
                        String workerId = this.getFirstSOAPElementByName(workerData, "Worker_ID").getValue();
                        this.userProperties.put("worker_id", workerId);
                        SOAPElement userIdElement = this.getFirstSOAPElementByName(workerData, "User_ID");
                        if (userIdElement != null) {
                            String userId = userIdElement.getValue();
                            this.userProperties.put("user_id", userId);
                        }
                        this.userProperties.put("password", "Passw0rd!");
                        SOAPElement personalData = this.getFirstSOAPElementByName(workerData, "Personal_Data");
                        if (personalData != null) {
                            this.parsePersonalData(personalData);
                        }
                        if ((employmentData = this.getFirstSOAPElementByName(workerData, "Employment_Data")) != null) {
                            this.parseEmploymentData(employmentData);
                        }
                    }
                    this.parsedUsersList.add(this.userProperties);
                } while (iterator.hasNext());
            } else {
                out.log(Level.INFO, "No worker data available");
            }
            out.log(Level.INFO, "Iteration " + this.currentResponsePage + " of " + this.totalResponsePages);
        }
    }

    private boolean canAddRecordsToDB(Hashtable inputRecord) {
        if (this.syncType.equalsIgnoreCase(AutomationConstants.GET_ADDED)) {
            String generatedTableName = WorkdayInputDataSource.getLocalTableName();
            Criteria crit = new Criteria(Column.getColumn((String)generatedTableName, (String)"worker_id"), (Object)((String)inputRecord.get("worker_id")), 0);
            DataObject dataObject = null;
            try {
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, crit);
                if (dataObject.isEmpty() && this.checkIntegAdvncCriteria(inputRecord)) {
                    return true;
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else if (this.syncType.equalsIgnoreCase(AutomationConstants.GET_MODIFIED)) {
            if (this.isRecordModified(inputRecord) && this.checkIntegAdvncCriteria(inputRecord)) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private SOAPElement getFirstSOAPElementByName(SOAPElement sOAPElement, String elementName) {
        Iterator iterator = sOAPElement.getChildElements(new QName("urn:com.workday/bsvc", elementName));
        if (iterator.hasNext()) {
            return (SOAPElement)iterator.next();
        }
        return null;
    }

    private void parsePersonalData(SOAPElement personalData) {
        SOAPElement contactData;
        SOAPElement nameDetail;
        SOAPElement temp = this.getFirstSOAPElementByName(personalData, "Name_Data");
        if (temp != null && (temp = this.getFirstSOAPElementByName(temp, "Legal_Name_Data")) != null && (nameDetail = this.getFirstSOAPElementByName(temp, "Name_Detail_Data")) != null) {
            String firstName = "";
            String middleName = "";
            String lastName = "";
            if (this.getFirstSOAPElementByName(nameDetail, "First_Name") != null) {
                firstName = this.getFirstSOAPElementByName(nameDetail, "First_Name").getValue();
            }
            if (this.getFirstSOAPElementByName(nameDetail, "Middle_Name") != null) {
                middleName = this.getFirstSOAPElementByName(nameDetail, "Middle_Name").getValue();
            }
            if (this.getFirstSOAPElementByName(nameDetail, "Last_Name") != null) {
                lastName = this.getFirstSOAPElementByName(nameDetail, "Last_Name").getValue();
            }
            if (firstName != null) {
                this.userProperties.put("first_name", firstName);
            }
            if (middleName != null) {
                this.userProperties.put("middle_name", middleName);
            }
            if (lastName != null) {
                this.userProperties.put("last_name", lastName);
            }
        }
        if ((contactData = this.getFirstSOAPElementByName(personalData, "Contact_Data")) != null) {
            String webAddress;
            SOAPElement webAddressData;
            String emailAddress;
            SOAPElement emailAddressData;
            SOAPElement phoneData;
            SOAPElement addressData = this.getFirstSOAPElementByName(contactData, "Address_Data");
            if (addressData != null) {
                Iterator iterator;
                String municipality;
                String postalCode;
                if (this.getFirstSOAPElementByName(addressData, "Postal_Code") != null && (postalCode = this.getFirstSOAPElementByName(addressData, "Postal_Code").getValue()) != null) {
                    this.userProperties.put("postal_code", postalCode);
                }
                if (this.getFirstSOAPElementByName(addressData, "Municipality") != null && (municipality = this.getFirstSOAPElementByName(addressData, "Municipality").getValue()) != null) {
                    this.userProperties.put("municipality", municipality);
                }
                if ((temp = this.getFirstSOAPElementByName(addressData, "Country_Reference")) != null) {
                    iterator = temp.getChildElements(new QName("urn:com.workday/bsvc", "ID"));
                    while (iterator.hasNext()) {
                        SOAPElement countryData = (SOAPElement)iterator.next();
                        if (countryData.getAttributeValue(new QName("urn:com.workday/bsvc", "type")) == null || !countryData.getAttributeValue(new QName("urn:com.workday/bsvc", "type")).equals("ISO_3166-1_Numeric-3_Code")) continue;
                        this.userProperties.put("country_code", countryData.getValue());
                    }
                }
                iterator = addressData.getChildElements(new QName("urn:com.workday/bsvc", "Address_Line_Data"));
                while (iterator.hasNext()) {
                    SOAPElement eachAddressLineData = (SOAPElement)iterator.next();
                    if (eachAddressLineData.getAttributeValue(new QName("urn:com.workday/bsvc", "Type")).equals("ADDRESS_LINE_1") || eachAddressLineData.getAttributeValue(new QName("urn:com.workday/bsvc", "Type")).equalsIgnoreCase("STREET")) {
                        this.userProperties.put("street", eachAddressLineData.getValue());
                    }
                    if (!eachAddressLineData.getAttributeValue(new QName("urn:com.workday/bsvc", "Type")).equalsIgnoreCase("STATE")) continue;
                    this.userProperties.put("state", eachAddressLineData.getValue());
                }
            }
            if ((phoneData = this.getFirstSOAPElementByName(contactData, "Phone_Data")) != null) {
                String phoneNumber = phoneData.getAttributeValue(new QName("urn:com.workday/bsvc", "Formatted_Phone"));
                this.userProperties.put("phone_number", phoneNumber);
            }
            if ((emailAddressData = this.getFirstSOAPElementByName(contactData, "Email_Address_Data")) != null && this.getFirstSOAPElementByName(emailAddressData, "Email_Address") != null && (emailAddress = this.getFirstSOAPElementByName(emailAddressData, "Email_Address").getValue()) != null) {
                this.userProperties.put("email_address", emailAddress);
            }
            if ((webAddressData = this.getFirstSOAPElementByName(contactData, "Web_Address_Data")) != null && this.getFirstSOAPElementByName(webAddressData, "Web_Address") != null && (webAddress = this.getFirstSOAPElementByName(webAddressData, "Web_Address").getValue()) != null) {
                this.userProperties.put("web_address", webAddress);
            }
        }
    }

    private void parseEmploymentData(SOAPElement employmentData) {
        SOAPElement workerStatusData;
        SOAPElement positionData;
        SOAPElement workerJobData = this.getFirstSOAPElementByName(employmentData, "Worker_Job_Data");
        if (workerJobData != null && (positionData = this.getFirstSOAPElementByName(workerJobData, "Position_Data")) != null && this.getFirstSOAPElementByName(positionData, "Position_Title") != null) {
            SOAPElement managerReference;
            String[] splitedPosition;
            String position = this.getFirstSOAPElementByName(positionData, "Position_Title").getValue();
            if (position != null) {
                this.userProperties.put("title", position);
            }
            if ((splitedPosition = position.split(",")).length > 1) {
                this.userProperties.put("department", splitedPosition[splitedPosition.length - 1]);
            }
            if ((managerReference = this.getFirstSOAPElementByName(positionData, "Manager_as_of_last_detected_manager_change_Reference")) != null) {
                Iterator iterator = managerReference.getChildElements(new QName("urn:com.workday/bsvc", "ID"));
                while (iterator.hasNext()) {
                    SOAPElement managerData = (SOAPElement)iterator.next();
                    if (managerData.getAttributeValue(new QName("urn:com.workday/bsvc", "type")) == null || !managerData.getAttributeValue(new QName("urn:com.workday/bsvc", "type")).equals("Employee_ID")) continue;
                    String managerEmployeeId = managerData.getValue();
                    Properties ldapVsValue = new Properties();
                    ldapVsValue.setProperty("EMPLOYEE_ID", managerEmployeeId);
                    String managerDN = UserHandler.getUserDNFromOtherAttribs((Properties)ldapVsValue, (String)this.domainName);
                    this.userProperties.put("manager", managerDN);
                }
            }
        }
        if ((workerStatusData = this.getFirstSOAPElementByName(employmentData, "Worker_Status_Data")) != null) {
            String activeStatus = this.getFirstSOAPElementByName(workerStatusData, "Active").getValue();
            this.userProperties.put("active_status", activeStatus);
        }
    }

    public void addCurrentRecordsToDB() {
        String tableName = WorkdayInputDataSource.getLocalTableName();
        out.log(Level.INFO, "Workday entries are being updated to " + tableName + " table");
        ArrayList columnNames = new ArrayList(WorkdayUtil.getDisplayVsTableColumnsMapping().values());
        try {
            DataAccess.delete((String)tableName, (Criteria)null);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, (Criteria)null);
            if (!this.syncType.equals(AutomationConstants.GET_RETRIEVED)) {
                this.readData(AutomationConstants.GET_ADDED);
            }
            for (Properties userProperties : this.parsedUsersList) {
                Row row = new Row(tableName);
                for (String dbColumnName : columnNames) {
                    String colValue = this.getUpdatedValue(dbColumnName, (String)userProperties.get(dbColumnName));
                    try {
                        if (colValue != null) {
                            row.set(dbColumnName, (Object)colValue.trim());
                            continue;
                        }
                        row.set(dbColumnName, (Object)"");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    dataObject.addRow(row);
                }
                catch (Exception e) {
                    out.log(Level.INFO, "Error in setting details for employee id :" + row.get("worker_id"));
                    e.printStackTrace();
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getLocalTableName(Long scheduleId) {
        return "IntegrationDBRecords_wd_" + scheduleId;
    }

    public static String getLocalTableName() {
        return WorkdayInputDataSource.getLocalTableName(scheduleId);
    }

    private void createTable() {
        String generatedTableName = WorkdayInputDataSource.getLocalTableName();
        this.noOfRecordsPerResponse = "1";
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)generatedTableName);
            if (tableDef == null) {
                tableDef = new TableDefinition();
                tableDef.setTableName(generatedTableName);
                JSONObject columnsObj = WorkdayUtil.getColumnsPropertiesList();
                Iterator keys = columnsObj.keys();
                while (keys.hasNext()) {
                    String colDisplayFormat = (String)keys.next();
                    JSONObject columnObj = columnsObj.getJSONObject(colDisplayFormat);
                    int dataType = columnObj.getInt("DATA_TYPE");
                    ColumnDefinition coldef = new ColumnDefinition();
                    coldef.setColumnName(columnObj.getString("DB_COLUMN"));
                    coldef.setDescription(colDisplayFormat);
                    coldef.setDataType(this.getMickeyColumnType(dataType));
                    if (columnObj.getInt("DATA_TYPE") == 1) {
                        coldef.setMaxLength(columnObj.getInt("LENGTH"));
                    }
                    coldef.setNullable(columnObj.getBoolean("ISNULLABLE"));
                    tableDef.addColumnDefinition(coldef);
                }
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(generatedTableName + "_PK");
                pkDef.addColumnName("worker_id");
                pkDef.setTableName(generatedTableName);
                tableDef.setPrimaryKey(pkDef);
                DynamicTableUtil.createDynamicTable((TableDefinition)tableDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            out.log(Level.INFO, "Exception message :  " + message);
        }
    }

    private String getMickeyColumnType(int sqlType) {
        if (sqlType == -5) {
            return "BIGINT";
        }
        if (sqlType == 1) {
            return "CHAR";
        }
        if (sqlType == 4) {
            return "INTEGER";
        }
        if (sqlType == 16) {
            return "BOOLEAN";
        }
        if (sqlType == 91) {
            return "CHAR";
        }
        if (sqlType == 92) {
            return "TIME";
        }
        if (sqlType == 93) {
            return "TIMESTAMP";
        }
        if (sqlType == 2004) {
            return "BLOB";
        }
        if (sqlType == 6) {
            return "FLOAT";
        }
        if (sqlType == 8) {
            return "DOUBLE";
        }
        if (sqlType == -6) {
            return "TINYINT";
        }
        if (sqlType == 3) {
            return "CHAR";
        }
        if (sqlType == -15) {
            return "NCHAR";
        }
        if (sqlType == -9) {
            return "NCHAR";
        }
        if (sqlType == 12) {
            return "CHAR";
        }
        return "CHAR";
    }

    public Hashtable getAttrMapping() {
        HashMap localColumnMapping = WorkdayUtil.getDisplayVsTableColumnsMapping();
        Hashtable<String, String> customAttribToLDAPMapping = new Hashtable<String, String>();
        customAttribToLDAPMapping.put("accountStatus", "userAccountControl");
        Hashtable mappingData = new Hashtable();
        try {
            String tableName = "WorkdayIntegAttrMapping";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)this.configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (dataObject.isEmpty()) {
                // empty if block
            }
            Iterator it = dataObject.getRows(tableName, (Criteria)null);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String ldapValue = (String)r.get("GENERIC_COLUMN");
                String dbColumn = (String)localColumnMapping.get((String)r.get("WD_COLUMN"));
                if (customAttribToLDAPMapping.containsKey(ldapValue)) {
                    mappingData.put(customAttribToLDAPMapping.get(ldapValue), dbColumn);
                    continue;
                }
                mappingData.put(ldapValue, dbColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappingData;
    }

    private boolean isRecordModified(Hashtable record) {
        try {
            String generatedTableName = WorkdayInputDataSource.getLocalTableName();
            DataObject recordCheckDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            Criteria crit = null;
            crit = new Criteria(Column.getColumn((String)generatedTableName, (String)"worker_id"), (Object)((String)record.get("worker_id")), 0);
            Row result = recordCheckDO.getRow(generatedTableName, crit);
            if (result != null) {
                ArrayList<String> columnList = this.getAdvncConfigColumns();
                columnList.remove("worker_id");
                String colName = "";
                for (int i = 0; i < columnList.size(); ++i) {
                    colName = columnList.get(i);
                    crit = record.get(colName) != null ? crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)((String)record.get(colName)), 0)) : crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)"", 0));
                }
            }
            return (result = recordCheckDO.getRow(generatedTableName, crit)) == null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private ArrayList<String> getAdvncConfigColumns() {
        HashSet colList = new HashSet();
        HashMap localColumnMapping = WorkdayUtil.getDisplayVsTableColumnsMapping();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"WorkdayIntegAttrMapping", (String)"CONFIG_ID"), (Object)this.configId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("WorkdayIntegAttrMapping", criteria);
            if (dataObject != null) {
                Iterator it = dataObject.getRows("WorkdayIntegAttrMapping");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    colList.add(localColumnMapping.get((String)row.get("WD_COLUMN")));
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>(colList);
    }

    @Override
    public void postExecutionUpdate(String syncType) {
        this.postExecutionUpdate();
    }

    public void postExecutionUpdate() {
        this.syncType = AutomationConstants.GET_RETRIEVED;
        this.addCurrentRecordsToDB();
    }

    private void updateLocalDBColumns() {
        String generatedTableName = WorkdayInputDataSource.getLocalTableName();
        ArrayList wdcolumnNames = new ArrayList(WorkdayUtil.getDisplayVsTableColumnsMapping().values());
        Row generatedTableRow = new Row(generatedTableName);
        if (generatedTableRow != null) {
            ArrayList existingColumns = new ArrayList(generatedTableRow.getColumns());
            wdcolumnNames.removeAll(existingColumns);
            for (String columnName : wdcolumnNames) {
                AlterTableQueryImpl alterQuery = new AlterTableQueryImpl(generatedTableName);
                ColumnDefinition coldef = new ColumnDefinition();
                coldef.setColumnName(columnName);
                coldef.setDescription(" ");
                coldef.setDataType(this.getMickeyColumnType(1));
                coldef.setMaxLength(255);
                try {
                    alterQuery.addColumn(coldef);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).alterTable((AlterTableQuery)alterQuery);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!wdcolumnNames.isEmpty()) {
                out.log(Level.INFO, "New columns added to " + generatedTableName + " are :" + wdcolumnNames.toString());
            }
        }
    }

    static {
        logger = Logger.getLogger(WorkdayInputDataSource.class.getName());
    }
}

