/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.integration;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DynamicTableUtil;
import com.adventnet.sym.adsm.common.webclient.integration.GenericData;
import com.adventnet.sym.adsm.common.webclient.integration.InputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.ZPeopleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZPeopleInputDataSource
extends InputDataSource {
    private static Logger out = Logger.getLogger("WFLogger");
    String mailId;
    String authtoken;
    String syncType;
    final String primaryColumn = "employee_id";
    static Long scheduleId;
    int configId;
    private static Logger logger;
    String domainName = "";
    DataObject integAdvncCriteriaObj = null;
    ArrayList<HashMap> parsedUsersList = new ArrayList();

    public void setIntegAdvncCriteriaId(Long integAdvncCriteriaId) {
        JSONObject json = new JSONObject();
        Criteria c = new Criteria(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"CRITERIA_ID"), (Object)integAdvncCriteriaId, 0);
        SelectQueryImpl critQuery = new SelectQueryImpl(Table.getTable((String)"AutoIntegAdvancCriteriaDetails"));
        critQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        critQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"PROCESSING_ORDER"), true));
        critQuery.setCriteria(c);
        try {
            this.integAdvncCriteriaObj = DataAccess.get((SelectQuery)critQuery);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private boolean checkIntegAdvncCriteria(Hashtable record) {
        boolean satisfied = true;
        if (this.integAdvncCriteriaObj != null) {
            Row row = null;
            HashMap attrMapping = ZPeopleUtil.getDisplayVsTableColumnsMapping();
            try {
                Iterator it = this.integAdvncCriteriaObj.getRows("AutoIntegAdvancCriteriaDetails");
                if (it.hasNext()) {
                    row = (Row)it.next();
                    String givenValue = (String)record.get(attrMapping.get((String)row.get("COLUMN_NAME")));
                    satisfied = ZPeopleInputDataSource.processSingleCondition(Integer.parseInt((String)row.get("MATCH_CRITERIA")), givenValue, (String)row.get("COLUMN_VALUE"));
                    while (it.hasNext()) {
                        row = (Row)it.next();
                        givenValue = (String)record.get(attrMapping.get((String)row.get("COLUMN_NAME")));
                        if (((String)row.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("or")) {
                            satisfied = satisfied || ZPeopleInputDataSource.processSingleCondition(Integer.parseInt((String)row.get("MATCH_CRITERIA")), givenValue, (String)row.get("COLUMN_VALUE"));
                            continue;
                        }
                        satisfied = satisfied && ZPeopleInputDataSource.processSingleCondition(Integer.parseInt((String)row.get("MATCH_CRITERIA")), givenValue, (String)row.get("COLUMN_VALUE"));
                    }
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return satisfied;
    }

    public static boolean processSingleCondition(int matchCriteria, String givenValue, String conditionValue) {
        try {
            switch (matchCriteria) {
                case 0: 
                case 2: {
                    if (!givenValue.equals(conditionValue) && !givenValue.replaceFirst("^0*", "").equals(conditionValue)) break;
                    return true;
                }
                case 1: 
                case 3: {
                    if (givenValue.equals(conditionValue) || givenValue.replaceFirst("^0*", "").equals(conditionValue)) break;
                    return true;
                }
                case 10: {
                    if (!givenValue.startsWith(conditionValue)) break;
                    return true;
                }
                case 11: {
                    if (!givenValue.endsWith(conditionValue)) break;
                    return true;
                }
                case 12: {
                    if (!givenValue.contains(conditionValue)) break;
                    return true;
                }
                case 13: {
                    if (givenValue.contains(conditionValue)) break;
                    return true;
                }
                case 5: {
                    if (Integer.parseInt(givenValue.trim()) <= Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
                case 7: {
                    if (Integer.parseInt(givenValue.trim()) >= Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
                case 4: {
                    if (Integer.parseInt(givenValue.trim()) < Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
                case 6: {
                    if (Integer.parseInt(givenValue.trim()) > Integer.parseInt(conditionValue.trim())) break;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public ZPeopleInputDataSource(int confId, Long scheduleId) throws Exception {
        this.configId = confId;
        ZPeopleInputDataSource.scheduleId = scheduleId;
        this.syncType = "all";
        this.setCredentials();
        this.createTable();
    }

    public ZPeopleInputDataSource(int confId) throws Exception {
        this.configId = confId;
    }

    private void setCredentials() {
        try {
            HashMap authDetails = ZPeopleUtil.getAuthDetails();
            this.mailId = (String)authDetails.get("ZOHO_MAIL_ID");
            this.authtoken = (String)authDetails.get("AUTHTOKEN");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ZPeopleInputDataSource getInstance(int configId, Long scheduleId) throws Exception {
        return new ZPeopleInputDataSource(configId, scheduleId);
    }

    @Override
    public GenericData readData(String syncType) {
        block6: {
            this.syncType = syncType;
            this.parsedUsersList = new ArrayList();
            try {
                StringBuilder url = new StringBuilder();
                url.append("https://people.zoho.com/people/api/forms/employee/getRecords?authtoken=" + this.authtoken);
                String response = ZPeopleUtil.getResponse(url.toString());
                Long lastSyncTime = System.currentTimeMillis();
                if (response.equalsIgnoreCase("failed")) break block6;
                try {
                    JSONObject responseJSON = new JSONObject(response);
                    if (responseJSON.has("response") && responseJSON.getJSONObject("response").has("result")) {
                        JSONArray records = responseJSON.getJSONObject("response").getJSONArray("result");
                        for (int i = 0; i < records.length(); ++i) {
                            JSONObject record = records.getJSONObject(i);
                            HashMap parsedUserDetails = new HashMap();
                            this.parseSingleValues(record, parsedUserDetails);
                            this.parseTabularValues(record, parsedUserDetails);
                            this.parsedUsersList.add(parsedUserDetails);
                        }
                        ZPeopleUtil.updateLastSyncTime(scheduleId, lastSyncTime);
                        return this.getGenericResponseFromParsedUsersList();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void parseSingleValues(JSONObject record, HashMap parsedUserDetails) {
        try {
            HashMap localAttrMapping = ZPeopleUtil.getDisplayVsTableColumnsMapping();
            Iterator keys = record.keys();
            while (keys.hasNext()) {
                String zohoId = (String)keys.next();
                for (int i = 0; i < record.getJSONArray(zohoId).length(); ++i) {
                    JSONObject userDetails = record.getJSONArray(zohoId).getJSONObject(i);
                    for (Map.Entry pair : localAttrMapping.entrySet()) {
                        String displayText = (String)pair.getKey();
                        String dbColumn = (String)pair.getValue();
                        if (!userDetails.has(displayText)) continue;
                        if ("Reporting_To".equalsIgnoreCase(displayText)) {
                            String value = userDetails.getString("Reporting_To.MailID");
                            if ("".equals(value)) continue;
                            Properties ldapVsValue = new Properties();
                            ldapVsValue.setProperty("EMAIL_ADDRESS", value);
                            String managerDN = UserHandler.getUserDNFromOtherAttribs((Properties)ldapVsValue, (String)this.domainName);
                            parsedUserDetails.put(dbColumn, managerDN);
                            continue;
                        }
                        parsedUserDetails.put(dbColumn, userDetails.getString(displayText));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTabularValues(JSONObject record, HashMap userDetails) {
    }

    private GenericData getGenericResponseFromParsedUsersList() {
        this.updateLocalDBColumns();
        GenericData genericResponse = new GenericData();
        HashMap localAttrMapping = ZPeopleUtil.getDisplayVsTableColumnsMapping();
        Hashtable configAttrMapping = ZPeopleUtil.getAttrMapping(this.configId);
        try {
            if (this.syncType.equalsIgnoreCase(AutomationConstants.GET_DELETED)) {
                Iterator it;
                String tableName = ZPeopleInputDataSource.getLocalTableName();
                ArrayList<String> employeeIds = new ArrayList<String>();
                for (HashMap userProps : this.parsedUsersList) {
                    employeeIds.add((String)userProps.get("employee_id"));
                }
                Criteria missingInZohoCrit = new Criteria(Column.getColumn((String)tableName, (String)"employee_id"), (Object)employeeIds.toArray(), 9);
                if (this.integAdvncCriteriaObj != null) {
                    Criteria advncCriteria = null;
                    it = this.integAdvncCriteriaObj.getRows("AutoIntegAdvancCriteriaDetails");
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Column columnName = Column.getColumn((String)tableName, (String)((String)localAttrMapping.get(r.get("COLUMN_NAME"))));
                        String columnValue = (String)r.get("COLUMN_VALUE");
                        int matchCriteria = Integer.parseInt((String)r.get("MATCH_CRITERIA"));
                        Criteria crit = new Criteria(columnName, (Object)columnValue, matchCriteria);
                        if (advncCriteria == null) {
                            advncCriteria = crit;
                            continue;
                        }
                        if (((String)r.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("or")) {
                            advncCriteria = advncCriteria.or(crit);
                            continue;
                        }
                        if (!((String)r.get("PROCESS_MATCH_CRITERIA")).equalsIgnoreCase("and")) continue;
                        advncCriteria = advncCriteria.and(crit);
                    }
                    if (advncCriteria != null) {
                        missingInZohoCrit = missingInZohoCrit.and(advncCriteria);
                    }
                }
                DataObject generatedTableObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, missingInZohoCrit);
                it = generatedTableObj.getRows(tableName);
                while (it.hasNext()) {
                    Hashtable<String, String> record = new Hashtable<String, String>();
                    Hashtable<String, String> chkRecord = new Hashtable<String, String>();
                    Row r = (Row)it.next();
                    for (String column : ZPeopleUtil.getAdvncConfigColumns(this.configId)) {
                        String dbColumnName = column.toLowerCase();
                        if (r.get(dbColumnName) == null) continue;
                        Object colVal = r.get(dbColumnName);
                        String columnValue = this.getUpdatedValue(dbColumnName, colVal.toString().trim());
                        Set keys = configAttrMapping.keySet();
                        for (String key : keys) {
                            if (!((String)configAttrMapping.get(key)).equalsIgnoreCase(dbColumnName)) continue;
                            record.put(key, columnValue);
                        }
                        chkRecord.put(dbColumnName, columnValue);
                    }
                    genericResponse.addRecord(record, chkRecord);
                }
            } else {
                for (HashMap userProps : this.parsedUsersList) {
                    Hashtable<String, String> record = new Hashtable<String, String>();
                    Hashtable<String, String> chkRecord = new Hashtable<String, String>();
                    ArrayList zpTableColumnList = new ArrayList(ZPeopleUtil.getDisplayVsTableColumnsMapping().values());
                    for (String zpColumnName : zpTableColumnList) {
                        if (userProps.get(zpColumnName) != null) {
                            String columnValue = this.getUpdatedValue(zpColumnName, ((String)userProps.get(zpColumnName)).trim());
                            Set keys = configAttrMapping.keySet();
                            for (String key : keys) {
                                if (!((String)configAttrMapping.get(key)).equalsIgnoreCase(zpColumnName)) continue;
                                record.put(key, columnValue);
                            }
                            chkRecord.put(zpColumnName, columnValue);
                            continue;
                        }
                        chkRecord.put(zpColumnName, "");
                    }
                    if (!this.canAddRecordsToDB(chkRecord)) continue;
                    genericResponse.addRecord(record, chkRecord);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return genericResponse;
    }

    private String getUpdatedValue(String dbColumnName, String val) {
        Hashtable attrMapping = ZPeopleUtil.getAttrMapping(this.configId);
        if (attrMapping.containsKey("userAccountControl") && ((String)attrMapping.get("userAccountControl")).equalsIgnoreCase(dbColumnName)) {
            ArrayList<String> activeState = new ArrayList<String>(Arrays.asList("true", "yes", "1", "active", "activated", "enable", "enabled", "512"));
            if (activeState.contains(val.toLowerCase())) {
                return "0;2";
            }
            return "2;0";
        }
        return val;
    }

    private boolean canAddRecordsToDB(Hashtable inputRecord) {
        if (this.syncType.equalsIgnoreCase(AutomationConstants.GET_ADDED)) {
            String generatedTableName = ZPeopleInputDataSource.getLocalTableName();
            Criteria crit = new Criteria(Column.getColumn((String)generatedTableName, (String)"employee_id"), (Object)((String)inputRecord.get("employee_id")), 0);
            DataObject dataObject = null;
            try {
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, crit);
                if (dataObject.isEmpty() && this.checkIntegAdvncCriteria(inputRecord)) {
                    return true;
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else if (this.syncType.equalsIgnoreCase(AutomationConstants.GET_MODIFIED)) {
            if (this.isRecordModified(inputRecord) && this.checkIntegAdvncCriteria(inputRecord)) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void addCurrentRecordsToDB() {
        String tableName = ZPeopleInputDataSource.getLocalTableName();
        out.log(Level.INFO, "Zoho People entries are being updated to " + tableName + " table");
        ArrayList columnNames = new ArrayList(ZPeopleUtil.getDisplayVsTableColumnsMapping().values());
        try {
            DataAccess.delete((String)tableName, (Criteria)null);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, (Criteria)null);
            if (!this.syncType.equals(AutomationConstants.GET_RETRIEVED)) {
                this.readData(AutomationConstants.GET_ADDED);
            }
            for (HashMap userProperties : this.parsedUsersList) {
                Row row = new Row(tableName);
                for (String dbColumnName : columnNames) {
                    String colValue = this.getUpdatedValue(dbColumnName, (String)userProperties.get(dbColumnName));
                    try {
                        if (colValue != null) {
                            row.set(dbColumnName, (Object)colValue.trim());
                            continue;
                        }
                        row.set(dbColumnName, (Object)"");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    dataObject.addRow(row);
                }
                catch (Exception e) {
                    out.log(Level.INFO, "Error in setting details for employee id :" + row.get("employee_id"));
                    e.printStackTrace();
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getLocalTableName(Long scheduleId) {
        return "IntegrationDBRecords_zp_" + scheduleId;
    }

    public static String getLocalTableName() {
        return ZPeopleInputDataSource.getLocalTableName(scheduleId);
    }

    private void createTable() {
        String generatedTableName = ZPeopleInputDataSource.getLocalTableName();
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)generatedTableName);
            if (tableDef == null) {
                tableDef = new TableDefinition();
                tableDef.setTableName(generatedTableName);
                JSONObject columnsObj = ZPeopleUtil.getColumnsPropertiesList();
                Iterator keys = columnsObj.keys();
                while (keys.hasNext()) {
                    String colDisplayFormat = (String)keys.next();
                    JSONObject columnObj = columnsObj.getJSONObject(colDisplayFormat);
                    int dataType = columnObj.getInt("DATA_TYPE");
                    ColumnDefinition coldef = new ColumnDefinition();
                    coldef.setColumnName(columnObj.getString("DB_COLUMN"));
                    coldef.setDescription(colDisplayFormat);
                    coldef.setDataType(this.getMickeyColumnType(dataType));
                    if (columnObj.getInt("DATA_TYPE") == 1) {
                        coldef.setMaxLength(columnObj.getInt("LENGTH"));
                    }
                    coldef.setNullable(columnObj.getBoolean("ISNULLABLE"));
                    tableDef.addColumnDefinition(coldef);
                }
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(generatedTableName + "_PK");
                pkDef.addColumnName("employee_id");
                pkDef.setTableName(generatedTableName);
                tableDef.setPrimaryKey(pkDef);
                DynamicTableUtil.createDynamicTable((TableDefinition)tableDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            out.log(Level.INFO, "Exception message :  " + message);
        }
    }

    private String getMickeyColumnType(int sqlType) {
        if (sqlType == -5) {
            return "BIGINT";
        }
        if (sqlType == 1) {
            return "CHAR";
        }
        if (sqlType == 4) {
            return "INTEGER";
        }
        if (sqlType == 16) {
            return "BOOLEAN";
        }
        if (sqlType == 91) {
            return "CHAR";
        }
        if (sqlType == 92) {
            return "TIME";
        }
        if (sqlType == 93) {
            return "TIMESTAMP";
        }
        if (sqlType == 2004) {
            return "BLOB";
        }
        if (sqlType == 6) {
            return "FLOAT";
        }
        if (sqlType == 8) {
            return "DOUBLE";
        }
        if (sqlType == -6) {
            return "TINYINT";
        }
        if (sqlType == 3) {
            return "CHAR";
        }
        if (sqlType == -15) {
            return "NCHAR";
        }
        if (sqlType == -9) {
            return "NCHAR";
        }
        if (sqlType == 12) {
            return "CHAR";
        }
        return "CHAR";
    }

    private boolean isRecordModified(Hashtable record) {
        try {
            String generatedTableName = ZPeopleInputDataSource.getLocalTableName();
            DataObject recordCheckDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(generatedTableName, (Criteria)null);
            Criteria crit = null;
            crit = new Criteria(Column.getColumn((String)generatedTableName, (String)"employee_id"), (Object)((String)record.get("employee_id")), 0);
            Row result = recordCheckDO.getRow(generatedTableName, crit);
            if (result != null) {
                ArrayList<String> columnList = ZPeopleUtil.getAdvncConfigColumns(this.configId);
                columnList.remove("employee_id");
                String colName = "";
                for (int i = 0; i < columnList.size(); ++i) {
                    colName = columnList.get(i);
                    crit = record.get(colName) != null ? crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)((String)record.get(colName)), 0)) : crit.and(new Criteria(Column.getColumn((String)generatedTableName, (String)colName), (Object)"", 0));
                }
            }
            return (result = recordCheckDO.getRow(generatedTableName, crit)) == null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void postExecutionUpdate(String syncType) {
        this.postExecutionUpdate();
    }

    public void postExecutionUpdate() {
        this.syncType = AutomationConstants.GET_RETRIEVED;
        this.addCurrentRecordsToDB();
    }

    private void updateLocalDBColumns() {
        String generatedTableName = ZPeopleInputDataSource.getLocalTableName();
        ArrayList zpcolumnNames = new ArrayList(ZPeopleUtil.getDisplayVsTableColumnsMapping().values());
        Row generatedTableRow = new Row(generatedTableName);
        if (generatedTableRow != null) {
            ArrayList existingColumns = new ArrayList(generatedTableRow.getColumns());
            zpcolumnNames.removeAll(existingColumns);
            for (String columnName : zpcolumnNames) {
                AlterTableQueryImpl alterQuery = new AlterTableQueryImpl(generatedTableName);
                ColumnDefinition coldef = new ColumnDefinition();
                coldef.setColumnName(columnName);
                coldef.setDescription(" ");
                coldef.setDataType(this.getMickeyColumnType(1));
                coldef.setMaxLength(255);
                try {
                    alterQuery.addColumn(coldef);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).alterTable((AlterTableQuery)alterQuery);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!zpcolumnNames.isEmpty()) {
                out.log(Level.INFO, "New columns added to " + generatedTableName + " are :" + zpcolumnNames.toString());
            }
        }
    }

    public Hashtable getAttrMapping() {
        return ZPeopleUtil.getAttrMapping(this.configId);
    }

    public static HashMap getCriteriaMap() {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        Long lastSyncedValue = ZPeopleUtil.getLastSyncTime(scheduleId);
        if (lastSyncedValue != null) {
            searchCriteria.put("searchColumn", "MODIFIEDTIME");
            searchCriteria.put("searchValue", lastSyncedValue);
        }
        return searchCriteria;
    }

    public static Hashtable getConfigDetails(int configId) {
        Hashtable<String, String> configData = new Hashtable<String, String>();
        try {
            String tableName = "ZPeopleInputConfig";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow(tableName);
                String configName = (String)r.get("CONFIG_NAME");
                String configDesc = (String)r.get("CONFIG_DESCRIPTION");
                configData.put("CONFIG_NAME", configName);
                configData.put("CONFIG_DESCRIPTION", configDesc);
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ZohoAccountDetails", (Criteria)null);
                if (dataObject.isEmpty()) {
                    return configData;
                }
                r = dataObject.getFirstRow("ZohoAccountDetails");
                String mailId = (String)r.get("ZOHO_MAIL_ID");
                String authToken = (String)r.get("AUTHTOKEN");
                String authGenTime = (String)r.get("AUTH_GEN_TIME");
                configData.put("ZOHO_MAIL_ID", mailId == null ? "" : mailId);
                configData.put("AUTHTOKEN", authToken == null ? "" : authToken);
                configData.put("AUTH_GEN_TIME", authGenTime);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configData;
    }

    static {
        logger = Logger.getLogger(ZPeopleInputDataSource.class.getName());
    }
}

