/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.formats.FormatUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.component.FcDeliveryRestriction;
import com.adventnet.sym.adsm.common.server.layout.component.FcHomeFolderWithPerm;
import com.adventnet.sym.adsm.common.server.layout.component.FcMailBoxStoreWithPerm;
import com.adventnet.sym.adsm.common.server.layout.component.FcMultiValue;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.layout.component.FcPassword;
import com.adventnet.sym.adsm.common.server.layout.component.FcPermission;
import com.adventnet.sym.adsm.common.server.layout.component.FcPhotoFileUpload;
import com.adventnet.sym.adsm.common.server.layout.component.FcProfilePathWithPerm;
import com.adventnet.sym.adsm.common.server.layout.component.FcTsHomeFolderWithPerm;
import com.adventnet.sym.adsm.common.server.layout.component.FcTsProfilePathWithPerm;
import com.adventnet.sym.adsm.common.server.layout.component.FcWAADLicenseSelection;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.queue.QueueUtil;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteNamingFormat;
import com.adventnet.sym.adsm.common.webclient.layout.FcMgmtListener;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.CustomScript;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.TemplateAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class FcADMgmtListener
extends FcMgmtListener {
    protected static Logger mgmtLog = Logger.getLogger("ADMangLogger");
    NativeError statusObject = null;
    Long userAccountControlValue = 0L;
    ArrayList memberOfList = new ArrayList();
    String adPrimaryGroupDN = "";
    ArrayList toBeRemovedGroupList = new ArrayList();
    ArrayList membersList = new ArrayList();
    ArrayList excludedMembersList = new ArrayList();
    ArrayList toBeRemovedMembersList = new ArrayList();
    ArrayList addedMembersList = new ArrayList();
    ArrayList crossForestMembersList = new ArrayList();
    ArrayList crossForestMembersDNList = new ArrayList();
    FcNativeProperties fcNativeProperties = new FcNativeProperties();
    String primaryGroupDN = "";
    ArrayList<Hashtable> removedProxyAddresses = new ArrayList();
    ArrayList<String> invalidGroups = new ArrayList();
    boolean cantChangePwdValue = false;
    boolean changePwdAtNextLogonValue = false;
    boolean setCantChangePwdValue = false;
    boolean newCantChangePwdValue = false;
    boolean disableAction = false;
    ArrayList essentialAttributes = new ArrayList();
    Hashtable permissionProps = new Hashtable();
    Hashtable lyncDetails = new Hashtable();
    ArrayList<Hashtable> lyncAuditPropList = new ArrayList();
    boolean isLcsEnabled = false;
    boolean isLyncEnabled = false;
    Long lcsOptionFlagsValue = 0L;
    String lyncPoolName = null;
    String rtcHomeServer = null;
    Long lyncServerVersion = 0L;
    String selectedTelephonyType = "";
    boolean stopExecution = false;
    String duplicatedAttribute = "";
    String effectiveMailAddress = "";
    ArrayList existingProxyAddresses = null;
    String existingTargetAddress = null;
    boolean updatePwdInDB = false;
    ArrayList toBeUpdatedInDB = new ArrayList();
    ArrayList extendedRightsGuidList = new ArrayList();
    Properties defaultGroupProps = null;
    boolean isAvoidDuplicationApplied = false;
    Long objectIndexId = null;
    String rusMessage = "";
    String photoFileError = "";
    boolean isPowerShellEnabled = false;
    boolean mailBoxEnabled = false;
    boolean mailEnabled = false;
    boolean msExchPoliciesExcluded = false;
    protected Hashtable groupDetailsTable = new Hashtable();
    protected String defaultGroupRID = "513";
    protected String objectType = "user";
    boolean isBulkMgmt = false;
    boolean isBulkLayoutMgmt = false;
    boolean isSUCWorkflowMode = false;
    int groupType = 0;
    int groupScope = 0;
    ArrayList fullPermissionList = new ArrayList();
    ArrayList toBeRemovedFullPermissionList = new ArrayList();
    ArrayList addedFullPermissionList = new ArrayList();
    Long viewId = 0L;
    boolean isChangesFound = true;
    Hashtable<Long, Hashtable> dpValuesHash = new Hashtable();

    public boolean getIsCreationSuccess() {
        return this.isCreationSuccess;
    }

    public void setIsCreationSuccess(boolean isCreationSuccess) {
        this.isCreationSuccess = isCreationSuccess;
    }

    public String getRusMessage() {
        return this.rusMessage;
    }

    public void setRusMessage(String rusMessage) {
        this.rusMessage = rusMessage;
    }

    public String getErrorCodes(Object key, NativeError errHdlr) {
        StringBuilder errCodeBuilder = new StringBuilder();
        try {
            ArrayList errorList = errHdlr.getErrorList(key);
            if (errorList != null && !errorList.isEmpty()) {
                String errorCode = null;
                for (Hashtable hashtable : errorList) {
                    errorCode = (String)hashtable.get("ERROR_CODE");
                    if (errorCode == null) continue;
                    errCodeBuilder.append(errCodeBuilder.length() > 0 ? "," + errorCode : errorCode);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCodeBuilder.toString();
    }

    public void reInit() {
        this.statusObject = null;
        this.userAccountControlValue = 0L;
        this.disableAction = false;
        this.memberOfList = new ArrayList();
        this.adPrimaryGroupDN = "";
        this.toBeRemovedGroupList = new ArrayList();
        this.membersList = new ArrayList();
        this.excludedMembersList = new ArrayList();
        this.toBeRemovedMembersList = new ArrayList();
        this.addedMembersList = new ArrayList();
        this.crossForestMembersList = new ArrayList();
        this.crossForestMembersDNList = new ArrayList();
        this.newCantChangePwdValue = false;
        this.fcNativeProperties = new FcNativeProperties();
        this.primaryGroupDN = "";
        this.removedProxyAddresses = new ArrayList();
        this.invalidGroups = new ArrayList();
        this.essentialAttributes = new ArrayList();
        this.permissionProps = new Hashtable();
        this.lyncDetails = new Hashtable();
        this.isLcsEnabled = false;
        this.isLyncEnabled = false;
        this.stopExecution = false;
        this.duplicatedAttribute = "";
        this.effectiveMailAddress = "";
        this.existingProxyAddresses = null;
        this.existingTargetAddress = null;
        this.isAvoidDuplicationApplied = false;
        this.isPowerShellEnabled = false;
        this.mailBoxEnabled = false;
        this.mailEnabled = false;
        this.updatePwdInDB = false;
        this.toBeUpdatedInDB = new ArrayList();
        this.objectIndexId = null;
    }

    public String customScriptExecution(Properties customScriptProps) throws Exception {
        String customScriptResult = "";
        if (customScriptProps.containsKey("SCRIPT_ENABLED") && ((Boolean)customScriptProps.get("SCRIPT_ENABLED")).booleanValue()) {
            String scriptCommand = (String)customScriptProps.get("SCRIPT_COMMAND");
            boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
            if (scriptCommand != null && scriptCommand.trim().length() > 0) {
                customScriptResult = this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script");
                CustomScript customScript = new CustomScript(this.rb, 5L, scriptCommand);
                customScriptResult = customScript.runThread();
                if (customScriptResult.indexOf("All rights reserved.") != -1) {
                    customScriptResult.substring(customScriptResult.indexOf("All rights reserved.") + 20);
                }
            }
        }
        return customScriptResult;
    }

    public void updatePreventDeletion(String ouDN, String operation) throws Exception {
        ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
        everyOneTrusteeList.add("S-1-1-0");
        ArrayList aceList = new ArrayList();
        Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
        aceHash.put("ACCESS_MASK", 65600L);
        aceHash.put("PERMISSION_STRING", "Delete,Delete Subtree");
        aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
        aceHash.put("ACE_TYPE", 1L);
        aceHash.put("ACE_ID", new Long(1L));
        aceHash.put("operation", operation);
        aceList.add(aceHash);
        ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)ouDN);
    }

    public void updateParent(String ouDN) throws Exception {
        ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
        everyOneTrusteeList.add("S-1-1-0");
        ArrayList aceList = new ArrayList();
        Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
        aceHash.put("ACCESS_MASK", 2L);
        aceHash.put("PERMISSION_STRING", "Delete all child");
        aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
        aceHash.put("ACE_TYPE", 1L);
        aceHash.put("ACE_ID", new Long(1L));
        aceHash.put("operation", "add");
        aceList.add(aceHash);
        ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)ouDN);
    }

    public void getProperties(boolean modifyObject, FcFormDataContainer fromClientData, FcNativeProperties fcNativeProperties, Properties ldapVsValueProps, String objectClass1) throws Exception {
        ArrayList propList = fcNativeProperties.getPropList();
        ArrayList modifyList = fcNativeProperties.getModifyList();
        ArrayList tsList = fcNativeProperties.getTsList();
        ArrayList winNTAttributeList = fcNativeProperties.getWinNTAttributeList();
        ArrayList nonExchAttrList = fcNativeProperties.getNonExchAttributeList();
        ArrayList essentialPropList = fcNativeProperties.getEssentialPropertiesList();
        PowerShellCommand powerShellCommand = fcNativeProperties.getPowerShellCommand();
        ArrayList groupList = fcNativeProperties.getGroupList();
        Hashtable otherDomainGroupList = fcNativeProperties.getOtherDomainGroupList();
        Properties props = fcNativeProperties.getProps();
        Boolean isGetDpValues = Boolean.FALSE;
        if (!this.dpValuesHash.containsKey(this.loginId)) {
            this.dpValuesHash.put(this.loginId, FcLayoutUtil.getDPValues((Long)this.loginId, (String)this.domainName, (AdventNetResourceBundle)this.rb));
        }
        Hashtable dpValues = this.dpValuesHash.get(this.loginId);
        Hashtable<String, Comparable<Boolean>> requiredProps = new Hashtable<String, Comparable<Boolean>>();
        requiredProps.put("isModification", Boolean.valueOf(modifyObject));
        requiredProps.put("loginId", this.loginId);
        ldapVsValueProps.put("loginId", this.loginId);
        Properties domainDetails = null;
        ArrayList duplicateProxyAddressList = new ArrayList();
        try {
            ArrayList proxyList;
            String mailAlias = "";
            String exchServerName = "";
            String exchAdminGrp = null;
            Integer exchangeType = null;
            this.isPowerShellEnabled = false;
            Long tobeUpdatedValue = 0L;
            int nandValue = 0;
            if (!modifyObject) {
                nandValue = 32;
            }
            int uacValue = 512;
            boolean isUACModified = false;
            boolean isPwdLastSetModified = false;
            domainDetails = ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId);
            if (ldapVsValueProps != null) {
                exchServerName = ldapVsValueProps.getProperty("mailBoxServerName", "");
                exchAdminGrp = ldapVsValueProps.getProperty("msExchAdminGroup");
            }
            if (exchServerName.trim().length() > 0 && !exchServerName.equals("0")) {
                props.put("msExchHomeServerName", exchServerName);
                exchangeType = ExchangeUtil.getExchangeServerType((String)exchServerName);
                requiredProps.put("exchangeType", exchangeType);
                if (exchangeType >= 2007) {
                    this.isPowerShellEnabled = true;
                }
            } else if (modifyObject && exchAdminGrp != null) {
                exchangeType = ExchangeUtil.getAdminGroupType((String)exchAdminGrp, (String)this.domainName);
            }
            String ouName = "";
            ouName = this.isBulkMgmt && this.commonContainerName != null && !this.commonContainerName.equals("") ? this.commonContainerName : FcLayoutUtil.getOUNameFromContainer((FcFormDataContainer)fromClientData);
            ldapVsValueProps.setProperty("OUName", ouName);
            this.checkForDuplicates(fromClientData, ldapVsValueProps, dpValues, ouName, domainDetails, duplicateProxyAddressList, objectClass1);
            if (this.stopExecution) {
                return;
            }
            Enumeration e = fromClientData.elements();
            while (e.hasMoreElements()) {
                Object attribValue;
                String attributeName;
                FcAttributes fcattrib;
                String ldapName;
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                if (fcAttributeList != null && fcAttributeList.size() > 0 && (ldapName = (fcattrib = (FcAttributes)fcAttributeList.get(0)).getAttribLdapName()).equalsIgnoreCase("waadLicenseInfo")) {
                    FcWAADLicenseSelection licenseComponent = (FcWAADLicenseSelection)fcLayoutField.getIComponent();
                    props.put("licenseLimitCheckNeeded", (Object)licenseComponent.licenseLimitCheckNeeded());
                    JSONArray accountSKUDetailsList = licenseComponent.getAccountSKUDetailsList();
                    ArrayList<String> selectedSKUList = new ArrayList<String>();
                    if (accountSKUDetailsList != null && accountSKUDetailsList.length() > 0) {
                        for (int k = 0; k < accountSKUDetailsList.length(); ++k) {
                            JSONObject accountSKUDetails = (JSONObject)accountSKUDetailsList.get(k);
                            if (!accountSKUDetails.has("IS_SELECTED") || !accountSKUDetails.getBoolean("IS_SELECTED")) continue;
                            selectedSKUList.add(accountSKUDetails.getString("ACCOUNT_SKU_ID"));
                        }
                        props.put("selectedSKUList", selectedSKUList);
                    }
                }
                Integer iamAppId = fcLayoutField.getIamAppId();
                if (this.isO365 && iamAppId != null && iamAppId.intValue() == FcLayoutConstants.OFFICE_365_APPID.intValue()) {
                    for (FcAttributes fcAttribute : fcAttributeList) {
                        attributeName = fcAttribute.getAttribLdapName();
                        attribValue = fcAttribute.getAttribValue();
                        if ("fullPermission".equalsIgnoreCase(attributeName)) {
                            if (attribValue == null) continue;
                            props.put("o365FullPermission", attribValue);
                            continue;
                        }
                        if ("GrantSendOnBehalfTo".equalsIgnoreCase(attributeName)) {
                            if (attribValue == null) continue;
                            props.put("o365SendOnBehalf", attribValue);
                            continue;
                        }
                        if ("o365SendAs".equalsIgnoreCase(attributeName) || "sendAs".equalsIgnoreCase(attributeName)) {
                            if (attribValue == null) continue;
                            props.put("o365SendAs", attribValue);
                            continue;
                        }
                        if (!"O365UserPrincipalName".equalsIgnoreCase(attributeName) || attribValue == null) continue;
                        props.put("O365UserPrincipalName", attribValue);
                    }
                    continue;
                }
                if (iamAppId != null && iamAppId.intValue() != FcLayoutConstants.ACTIVE_DIRECTORY_APPID.intValue()) continue;
                for (FcAttributes fcAttribute : fcAttributeList) {
                    attributeName = fcAttribute.getAttribLdapName();
                    attribValue = fcAttribute.getAttribValue();
                    if (attribValue == null || attribValue.toString().equals("")) continue;
                    if (attributeName.equalsIgnoreCase("OUName")) {
                        String container = attribValue.toString();
                        props.put("OUName", container);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("displayName")) {
                        String displayName = (String)attribValue;
                        props.put("displayName", displayName);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("mailNickName")) {
                        mailAlias = (String)attribValue;
                        String newString = FcExecuteNamingFormat.getFormatValue(mailAlias, null, ldapVsValueProps);
                        if (!newString.equals("")) {
                            mailAlias = newString;
                        }
                        props.put("mailAlias", mailAlias);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchHomeServerName")) {
                        exchServerName = (String)attribValue;
                        exchangeType = ExchangeUtil.getExchangeServerType((String)exchServerName);
                        requiredProps.put("exchangeType", exchangeType);
                        this.isPowerShellEnabled = ExchangeUtil.checkExchange2007((String)exchServerName);
                        if (modifyObject) continue;
                        props.put("msExchHomeServerName", exchServerName);
                        continue;
                    }
                    if ("msExchAdminGroup".equalsIgnoreCase(attributeName)) {
                        String adminGroup = (String)attribValue;
                        props.put("adminGroup", adminGroup);
                        exchangeType = ExchangeUtil.getAdminGroupType((String)adminGroup, (String)this.domainName);
                        this.isPowerShellEnabled = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
                        continue;
                    }
                    if ("targetAddress".equalsIgnoreCase(attributeName)) {
                        String value = (String)attribValue;
                        String nfAppliedTargetAddress = FcExecuteNamingFormat.getFormatValue(value, null, ldapVsValueProps);
                        if (!value.equals(nfAppliedTargetAddress)) {
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            hash.put("attr", fcAttribute);
                            hash.put("value", nfAppliedTargetAddress);
                            this.toBeUpdatedInDB.add(hash);
                            fcAttribute.setAttributeValue((Object)nfAppliedTargetAddress);
                        }
                        props.put("targetAddress", nfAppliedTargetAddress);
                        continue;
                    }
                    if ("password".equalsIgnoreCase(attributeName)) {
                        String value = (String)attribValue;
                        props.put("password", value);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("passwordType")) {
                        FcPassword fcpwd = (FcPassword)fcLayoutField.getIComponent();
                        String attribVal = attribValue.toString();
                        String passwordStr = fcpwd.getPasswordString();
                        if ("generatePwd".equals(attribVal)) {
                            if (passwordStr.equals("")) {
                                PasswordPolicy pwdPolicy = new PasswordPolicy();
                                pwdPolicy.setPolicyDetails();
                                passwordStr = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)this.rb);
                            }
                            props.put("password", passwordStr);
                            this.updatePwdInDB = true;
                        } else if ("sameUserNamePwd".equals(attribVal)) {
                            passwordStr = (String)ldapVsValueProps.get("sAMAccountName");
                            if (passwordStr == null || passwordStr.equals("")) {
                                passwordStr = (String)ldapVsValueProps.get("userPrincipalName");
                                if (passwordStr == null || passwordStr.equals("")) {
                                    passwordStr = (String)ldapVsValueProps.get("O365UserPrincipalName");
                                }
                                passwordStr = passwordStr == null || passwordStr.equals("") ? "" : passwordStr.substring(0, passwordStr.indexOf(64));
                            } else if (passwordStr.length() > 19) {
                                passwordStr = passwordStr.substring(0, 20);
                            }
                            props.put("password", passwordStr);
                            this.updatePwdInDB = true;
                        } else if ("blankPwd".equals(attribVal)) {
                            props.put("password", "");
                            passwordStr = "";
                        } else if ("ownPwd".equals(attribVal) && ((passwordStr = (String)ldapVsValueProps.get("password")) == null || passwordStr.equals(""))) {
                            props.remove("password");
                            if (!modifyObject) {
                                props.put("password", "");
                            }
                        }
                        fcpwd.setPasswordString(passwordStr);
                        props.put("passwordType", attribVal);
                        ldapVsValueProps.setProperty("password", passwordStr);
                        String pwdForIAMApps = passwordStr;
                        if (passwordStr == null && !modifyObject) {
                            pwdForIAMApps = "";
                        }
                        if (pwdForIAMApps == null) continue;
                        FcAttributes fcPwdAttribute = (FcAttributes)fcAttributeList.get(2);
                        fcPwdAttribute.setAttributeValue((Object)pwdForIAMApps);
                        continue;
                    }
                    if ("homeDirectory".equalsIgnoreCase(attributeName)) {
                        String value = (String)attribValue;
                        props.put("remoteHomeDir", FcExecuteNamingFormat.getFormatValue(value, null, ldapVsValueProps));
                        continue;
                    }
                    if ("userAccountControl".equalsIgnoreCase(attributeName)) {
                        JSONObject valueObj = (JSONObject)attribValue;
                        Long value = valueObj.getLong("value");
                        Integer intVal = Integer.valueOf(value.toString());
                        if (Integer.valueOf(value.toString()) == 65536 || Integer.valueOf(value.toString()) == 2) {
                            if ((this.userAccountControlValue & (long)intVal.intValue()) == (long)intVal.intValue()) {
                                if (valueObj.getBoolean("isChecked")) continue;
                                nandValue = (int)((long)nandValue | value);
                                isUACModified = true;
                                continue;
                            }
                            if (valueObj.getBoolean("isChecked")) {
                                uacValue = (int)((long)uacValue | value);
                                isUACModified = true;
                                if (intVal != 2) continue;
                                this.disableAction = true;
                                continue;
                            }
                            if (modifyObject) continue;
                            nandValue = (int)((long)nandValue | value);
                            isUACModified = true;
                            continue;
                        }
                        isUACModified = true;
                        if (valueObj.getBoolean("isChecked")) {
                            uacValue |= intVal.intValue();
                            continue;
                        }
                        if (!modifyObject) continue;
                        nandValue |= intVal.intValue();
                        continue;
                    }
                    if (attributeName.equals("tsHomeDir")) {
                        String value = (String)attribValue;
                        props.put("tsRemoteHomeDir", FcExecuteNamingFormat.getFormatValue(value, null, ldapVsValueProps));
                        continue;
                    }
                    if (attributeName.equals("msExchHideFromAddressLists")) {
                        props.put("msExchHideFromAddressLists", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("managerCanUpdateMembers")) {
                        props.put("managerCanUpdate", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("managedBy")) {
                        props.put("manager", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("preventDeletion")) {
                        props.put("preventDeletion", attribValue.toString());
                        continue;
                    }
                    if ("name".equalsIgnoreCase(attributeName)) {
                        if (attribValue.toString().equals("")) continue;
                        props.put("userName", attribValue.toString());
                        props.put("name", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("sAMAccountName")) {
                        if (attribValue.toString().equals("")) continue;
                        String tmpSamAccValue = (String)attribValue;
                        fcAttribute.setAttributeValue((Object)tmpSamAccValue);
                        propList.add(fcAttribute.getHashTableForNative());
                        props.put("samAccountName", tmpSamAccValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("LinkedMasterAccount")) {
                        if (attribValue.toString().equals("")) continue;
                        String tmpSamAccValue = (String)attribValue;
                        props.put("linkedMasterAccount", tmpSamAccValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("LinkedDomainName")) {
                        if (attribValue.toString().equals("")) continue;
                        String tmpSamAccValue = (String)attribValue;
                        props.put("linkedDomainName", tmpSamAccValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msRTCSIP-UserEnabled")) {
                        this.isLcsEnabled = (Boolean)attribValue;
                        props.put("isLcsEnabled", (Object)this.isLcsEnabled);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("lyncRegistrarPoolName")) {
                        this.isLyncEnabled = true;
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msRTCSIP-PrimaryUserAddress") || attributeName.equalsIgnoreCase("lyncSipAddress")) {
                        ArrayList proxyList2 = new ArrayList();
                        if (props.get("proxyAddresses") != null) {
                            proxyList2 = (ArrayList)props.get("proxyAddresses");
                        }
                        proxyList2.add(FcExecuteNamingFormat.getFormatValue((String)attribValue, null, ldapVsValueProps));
                        props.put("proxyAddresses", proxyList2);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("grouptype")) {
                        if ("GROUP_TYPE".equals(fcAttribute.getAttribColumnName())) {
                            props.put("groupType", attribValue.toString());
                            continue;
                        }
                        props.put("groupScope", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("waadRemoteMailbox")) {
                        props.put("waadRemoteMailbox", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("waadRemoteMailboxArchieve")) {
                        props.put("waadRemoteMailboxArchieve", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchQueryFilterMetadata") || attributeName.equalsIgnoreCase("msExchQueryFilter") || attributeName.equalsIgnoreCase("msExchDynamicDLFilter")) {
                        props.put(attributeName, attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("pwdLastSet")) {
                        boolean changePwdAtNextLogonChecked;
                        if (attribValue == null || !(attribValue instanceof Long)) continue;
                        boolean bl = changePwdAtNextLogonChecked = (Long)attribValue == 0L;
                        if (modifyObject && this.changePwdAtNextLogonValue == changePwdAtNextLogonChecked) continue;
                        isPwdLastSetModified = true;
                        continue;
                    }
                    if (!attributeName.equalsIgnoreCase("lyncTelephonyType")) continue;
                    this.selectedTelephonyType = attribValue.toString();
                }
            }
            e = fromClientData.elements();
            String distinguishedName = "";
            String escapeDN = "";
            if (modifyObject) {
                if (props.get("OUName") != null && ldapVsValueProps.containsKey("name")) {
                    distinguishedName = "CN=" + CommonUtil.escapeString((String)((String)ldapVsValueProps.get("name")), (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + props.get("OUName");
                    escapeDN = CommonUtil.escapeDN((String)distinguishedName);
                } else {
                    distinguishedName = this.fcNativeProperties.getDN();
                    escapeDN = CommonUtil.escapeDN((String)distinguishedName);
                    String ou = (String)ldapVsValueProps.get("OUName");
                    if (ou == null || ou.equals("")) {
                        ou = StrUtil.getContainerDNFromDN((String)distinguishedName);
                        ldapVsValueProps.setProperty("OUName", ou);
                    }
                }
            } else if (ldapVsValueProps != null && ldapVsValueProps.containsKey("name") && ldapVsValueProps.containsKey("OUName")) {
                distinguishedName = "CN=" + CommonUtil.escapeString((String)((String)ldapVsValueProps.get("name")), (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + ldapVsValueProps.get("OUName");
                escapeDN = CommonUtil.escapeDN((String)distinguishedName);
            }
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                Integer iamAppId = fcLayoutField.getIamAppId();
                if (iamAppId != null && iamAppId.intValue() != FcLayoutConstants.ACTIVE_DIRECTORY_APPID.intValue()) continue;
                if (fcLayoutField.getComponentId() == 45L || fcLayoutField.getComponentId() == 46L || fcLayoutField.getComponentId() == 47L || fcLayoutField.getComponentId() == 48L || fcLayoutField.getComponentId() == 49L) {
                    this.generatePermissionDetails(fcLayoutField, ldapVsValueProps, exchangeType, dpValues, escapeDN);
                }
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    String attributeName = fcAttribute.getAttribLdapName();
                    Object attribValue = fcAttribute.getAttribValue();
                    if (attribValue == null || attributeName.equalsIgnoreCase("OUName") || attributeName.equalsIgnoreCase("name") || attributeName.equalsIgnoreCase("samAccountName") || attributeName.equalsIgnoreCase("msExchDynamicDLFilter") || attributeName.equalsIgnoreCase("msExchQueryFilter") || attributeName.equalsIgnoreCase("LinkedMasterAccount") || attributeName.equalsIgnoreCase("LinkedDomainName")) continue;
                    if (attributeName.equalsIgnoreCase("description") || attributeName.equalsIgnoreCase("sn") || attributeName.equalsIgnoreCase("mailNickName")) {
                        String string = (String)attribValue;
                        String newString = FcExecuteNamingFormat.getFormatValue(string, null, ldapVsValueProps);
                        if (!string.equals(newString)) {
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            hash.put("attr", fcAttribute);
                            hash.put("value", newString);
                            this.toBeUpdatedInDB.add(hash);
                        }
                        if (!(string = newString).equals("")) {
                            fcAttribute.setAttributeValue((Object)string);
                            fcAttribute.setDataHandlerType(Long.valueOf(3L));
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)string);
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("initials")) {
                        String string = (String)attribValue;
                        if (!string.equals("")) {
                            if (string.length() > 6) {
                                string = string.substring(0, 6);
                            }
                            fcAttribute.setAttributeValue((Object)string);
                            fcAttribute.setDataHandlerType(Long.valueOf(3L));
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("userPhoto")) {
                        try {
                            String string = (String)attribValue;
                            FcPhotoFileUpload iComponent = (FcPhotoFileUpload)fcLayoutField.getIComponent();
                            Boolean removePhoto = iComponent.getIsRemovePhoto();
                            string = FcExecuteNamingFormat.getFormatValue(string, null, ldapVsValueProps);
                            String errorMsg = "";
                            ArrayList<Byte> byteList = new ArrayList<Byte>();
                            if (removePhoto.booleanValue() && iComponent.hasEmptyValue() && modifyObject) {
                                Hashtable hashtable;
                                if (iComponent.getPhotoAttribute().equalsIgnoreCase("exchangePhoto")) {
                                    fcAttribute.setAttributeValue((Object)"");
                                    fcAttribute.setAttribLdapName(iComponent.getPhotoAttribute());
                                    hashtable = fcAttribute.getHashTableForNative();
                                    hashtable.put("UNIQUE_OPERATION_ID", iComponent.getUniqueOperationId());
                                    props.put("exchangePhoto", hashtable);
                                } else {
                                    fcAttribute.setAttributeValue(byteList);
                                    hashtable = fcAttribute.getHashTableForNative();
                                    hashtable.put("ATTRIB_LDAP_NAME", iComponent.getPhotoAttribute());
                                    propList.add(hashtable);
                                }
                            } else if (!iComponent.hasEmptyValue()) {
                                File photoFile = UserPhotoMgmtUtil.getMatchingFileForExecution((String)string, (String)iComponent.getPhotoAttribute(), (String)iComponent.getUniqueOperationId());
                                if (photoFile == null) {
                                    if (iComponent.getIsFileAsInput().booleanValue()) {
                                        string = "";
                                    }
                                    errorMsg = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.file_not_found"), string);
                                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                    hash.put("attr", fcAttribute);
                                    hash.put("value", "");
                                    this.toBeUpdatedInDB.add(hash);
                                } else if (iComponent.getPhotoAttribute().equalsIgnoreCase("exchangePhoto")) {
                                    fcAttribute.setAttributeValue((Object)photoFile.getCanonicalPath());
                                    fcAttribute.setAttribLdapName(iComponent.getPhotoAttribute());
                                    Hashtable hashtable = fcAttribute.getHashTableForNative();
                                    File auditPhoto = UserPhotoMgmtUtil.cachePhotoFileForAudit((File)photoFile);
                                    hashtable.put("PHOTO_FOR_AUDIT", auditPhoto.getCanonicalPath());
                                    hashtable.put("UNIQUE_OPERATION_ID", iComponent.getUniqueOperationId());
                                    props.put("exchangePhoto", hashtable);
                                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                    hash.put("attr", fcAttribute);
                                    hash.put("value", auditPhoto.getCanonicalPath());
                                    this.toBeUpdatedInDB.add(hash);
                                } else {
                                    FileInputStream fileInputStream = new FileInputStream(photoFile);
                                    byte[] bFile = new byte[(int)photoFile.length()];
                                    fileInputStream.read(bFile);
                                    fileInputStream.close();
                                    for (int i = 0; i < (int)photoFile.length(); ++i) {
                                        byteList.add(bFile[i]);
                                    }
                                    fcAttribute.setAttributeValue(byteList);
                                    fcAttribute.setAttribLdapName(iComponent.getPhotoAttribute());
                                    Hashtable hashtable = fcAttribute.getHashTableForNative();
                                    File auditPhoto = UserPhotoMgmtUtil.cachePhotoFileForAudit((File)photoFile);
                                    hashtable.put("PHOTO_FOR_AUDIT", auditPhoto.getCanonicalPath());
                                    propList.add(hashtable);
                                    Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                    hash.put("attr", fcAttribute);
                                    hash.put("value", auditPhoto.getCanonicalPath());
                                    this.toBeUpdatedInDB.add(hash);
                                }
                            }
                            if (modifyObject) {
                                String filePath;
                                File file;
                                String guid = (String)ldapVsValueProps.get("objectGuid");
                                String photoAttrib = iComponent.getPhotoAttribute();
                                if (photoAttrib.equalsIgnoreCase("exchangePhoto")) {
                                    photoAttrib = "thumbnailPhoto";
                                }
                                if ((file = new File(filePath = UserPhotoMgmtUtil.getBulkPhotoFolder((String)this.domainName, (String)guid, (String)photoAttrib))).exists()) {
                                    file.delete();
                                }
                            }
                            this.photoFileError = errorMsg;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            this.photoFileError = this.rb.getString("admp.mgmt.user_mgmt.photo_mgmt.some_error_occured");
                        }
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchSenderHintTranslations")) {
                        String string = (String)attribValue;
                        if (!string.equals("")) {
                            if (string.length() > 175) {
                                string = string.substring(0, 174);
                            }
                            string = "default:<html><body>" + string + "</body></html>";
                            fcAttribute.setAttributeValue((Object)string);
                            fcAttribute.setDataHandlerType(Long.valueOf(3L));
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("givenName") || attributeName.equalsIgnoreCase("displayName")) {
                        if (!attribValue.toString().equals("")) {
                            String stringObj = attribValue.toString();
                            if (stringObj.equals("")) continue;
                            fcAttribute.setAttributeValue((Object)stringObj);
                            if (this.essentialAttributes.contains(attributeName)) {
                                essentialPropList.add(fcAttribute.getHashTableForNative());
                                continue;
                            }
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("memberOf")) {
                        ArrayList list = (ArrayList)attribValue;
                        if (!list.isEmpty()) {
                            if (!modifyObject) {
                                Hashtable grpList = GroupHandler.getGroupsPropFromDN((String)this.domainName, (Long)DelegationUtil.ADMIN_LOGIN_ID, (ArrayList)list);
                                for (String groupDN : list) {
                                    if (groupDN.equalsIgnoreCase("true") || groupDN.equalsIgnoreCase("false")) continue;
                                    Properties prop = (Properties)grpList.get(groupDN.toLowerCase());
                                    if (prop != null) {
                                        String groupDomain = prop.getProperty("DOMAIN_NAME");
                                        String groupRID = (String)prop.get("RID");
                                        if (groupRID == null) continue;
                                        if (!groupRID.equalsIgnoreCase(this.defaultGroupRID)) {
                                            if (groupDomain.equalsIgnoreCase(this.domainName)) {
                                                groupList.add(groupDN);
                                                continue;
                                            }
                                            ArrayList<Properties> groupDNs = (ArrayList<Properties>)otherDomainGroupList.get(groupDomain);
                                            if (groupDNs == null) {
                                                groupDNs = new ArrayList<Properties>();
                                                otherDomainGroupList.put(groupDomain, groupDNs);
                                            }
                                            groupDNs.add(prop);
                                            continue;
                                        }
                                        props.put("domainUsersGroupAvailable", (Object)true);
                                        continue;
                                    }
                                    this.invalidGroups.add(groupDN);
                                }
                            } else {
                                for (String string : list) {
                                    if (this.memberOfList.contains(string) || groupList.contains(string) || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) continue;
                                    groupList.add(string);
                                }
                            }
                        }
                        if (!modifyObject) continue;
                        for (int i = 0; i < this.memberOfList.size(); ++i) {
                            String dn = (String)this.memberOfList.get(i);
                            if (list.contains(dn) || this.toBeRemovedGroupList.contains(dn)) continue;
                            this.toBeRemovedGroupList.add(dn);
                        }
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("primaryGroupID")) {
                        if (attribValue.toString().equals("")) continue;
                        String groupDN = attribValue.toString();
                        if (!this.adPrimaryGroupDN.equals("") && this.adPrimaryGroupDN.equalsIgnoreCase(groupDN)) continue;
                        this.primaryGroupDN = groupDN;
                        String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)this.domainName);
                        Properties prop = GroupHandler.getGroupPropFromDN((String)this.domainName, (Long)DelegationUtil.ADMIN_LOGIN_ID, (String)groupDN);
                        if (prop != null) {
                            String groupRID = (String)prop.get("RID");
                            if (groupRID.equalsIgnoreCase(this.defaultGroupRID)) {
                                props.put("isDomainUsersPrimaryGroup", (Object)true);
                            } else {
                                if (this.defaultGroupProps == null) {
                                    this.defaultGroupProps = GroupHandler.getDefaultGroupProps((String)this.objectType, (String)this.domainName, (Long)DelegationUtil.ADMIN_LOGIN_ID);
                                }
                                if (this.defaultGroupProps != null) {
                                    props.put("domainUserGroupSid", this.defaultGroupProps.getProperty("SID_STRING"));
                                }
                            }
                            fcAttribute.setAttributeValue((Object)groupRID);
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        fcAttribute.setAttributeValue((Object)groupDN);
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("removeMemberOf")) {
                        int i;
                        if (!(attribValue instanceof ArrayList)) continue;
                        ArrayList list = (ArrayList)attribValue;
                        ArrayList<String> lowerCaseMemberOfList = new ArrayList<String>();
                        for (i = 0; i < this.memberOfList.size(); ++i) {
                            lowerCaseMemberOfList.add(((String)this.memberOfList.get(i)).toLowerCase());
                        }
                        if (list.isEmpty() || !modifyObject) continue;
                        for (i = 0; i < list.size(); ++i) {
                            String dn = (String)list.get(i);
                            if (!lowerCaseMemberOfList.contains(dn.toLowerCase()) || this.toBeRemovedGroupList.contains(dn)) continue;
                            this.toBeRemovedGroupList.add(dn);
                        }
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchAdminGroup")) {
                        String string = (String)attribValue;
                        if (string.equals("")) continue;
                        String nameToCreateLegacyDN = null;
                        nameToCreateLegacyDN = props.get("userName") != null ? props.getProperty("userName") : FcExecuteNamingFormat.getFormatValue(ldapVsValueProps.getProperty("userName"), null, ldapVsValueProps);
                        nameToCreateLegacyDN = FormatUtil.deleteSpecialChar((String)nameToCreateLegacyDN);
                        string = string + "/cn=Recipients/cn=" + this.getLegacyExchangeDN(nameToCreateLegacyDN, mailAlias, exchangeType);
                        fcAttribute.setAttribLdapName("legacyExchangeDN");
                        fcAttribute.setAttributeValue((Object)string);
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("proxyAddresses") || attributeName.equalsIgnoreCase("waadproxyAddresses")) {
                        if (attribValue.toString().equals("")) continue;
                        ArrayList list = (ArrayList)attribValue;
                        ArrayList trimmedList = new ArrayList();
                        if (props.get("proxyAddresses") != null && attributeName.equalsIgnoreCase("proxyAddresses")) {
                            trimmedList = (ArrayList)props.get("proxyAddresses");
                        } else if (props.get("waadproxyAddresses") != null && attributeName.equalsIgnoreCase("waadproxyAddresses")) {
                            trimmedList = (ArrayList)props.get("waadproxyAddresses");
                        }
                        boolean isValueChanged = false;
                        for (Object object : list) {
                            String string = (String)object;
                            String newString = FcExecuteNamingFormat.getFormatValue(string = string.trim(), null, ldapVsValueProps);
                            if (!newString.equals(string)) {
                                isValueChanged = true;
                            }
                            string = newString;
                            trimmedList.add(string);
                        }
                        if (!isValueChanged && trimmedList.size() > list.size()) {
                            isValueChanged = true;
                        }
                        if (isValueChanged) {
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            hash.put("attr", fcAttribute);
                            hash.put("value", trimmedList);
                            this.toBeUpdatedInDB.add(hash);
                        }
                        if (attributeName.equalsIgnoreCase("proxyAddresses")) {
                            props.put("proxyAddresses", trimmedList);
                            continue;
                        }
                        if (!attributeName.equalsIgnoreCase("waadproxyAddresses")) continue;
                        props.put("waadproxyAddresses", trimmedList);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("logonHours")) {
                        fcLayoutField.updateFieldValueToAttributeForNative(requiredProps, propList);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchHideFromAddressLists")) {
                        if (attribValue.toString().equals("") || exchangeType == null) continue;
                        String value = attribValue.toString();
                        fcAttribute.setAttributeValue((Object)value.toUpperCase());
                        if (modifyObject) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!value.equalsIgnoreCase("true")) continue;
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("mAPIRecipient")) {
                        if (attribValue.toString().equals("")) continue;
                        String value = attribValue.toString();
                        fcAttribute.setAttributeValue((Object)value.toUpperCase());
                        if (modifyObject) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!value.equalsIgnoreCase("true")) continue;
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchRequireAuthToSendTo")) {
                        if (attribValue.toString().equals("") || exchangeType == null) continue;
                        String value = attribValue.toString();
                        fcAttribute.setAttributeValue((Object)value.toUpperCase());
                        if (modifyObject) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (value.equalsIgnoreCase("true")) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        fcAttribute.setAttributeValue((Object)"NOT SET");
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchPoliciesExcluded")) {
                        if (attribValue.toString().equals("")) continue;
                        String value = attribValue.toString();
                        if (value.equalsIgnoreCase("false")) {
                            fcAttribute.setAttributeValue((Object)"{26491CFC-9E50-4857-861B-0CB8DF22B5D7}");
                            propList.add(fcAttribute.getHashTableForNative());
                            this.msExchPoliciesExcluded = true;
                            props.put("msExchPoliciesExcluded", (Object)this.msExchPoliciesExcluded);
                            continue;
                        }
                        if (!modifyObject || !value.equalsIgnoreCase("true")) continue;
                        fcAttribute.setAttributeValueCount((Object)1L);
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        Hashtable<String, Object> msExchPoliciesIncluded = new Hashtable<String, Object>();
                        msExchPoliciesIncluded.put("ATTRIB_LDAP_NAME", "msExchPoliciesIncluded");
                        msExchPoliciesIncluded.put("ATTRIB_VALUE", "{26491CFC-9E50-4857-861B-0CB8DF22B5D7}");
                        msExchPoliciesIncluded.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        msExchPoliciesIncluded.put("DATA_HANDLER_TYPE", new Long(3L));
                        propList.add(msExchPoliciesIncluded);
                        props.put("msExchPoliciesIncluded", "{26491CFC-9E50-4857-861B-0CB8DF22B5D7}");
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msNPAllowDialin")) {
                        if (!modifyObject) {
                            if (attribValue == null || attribValue.toString().equals("") || attribValue.toString().equals("-1")) continue;
                            String dialInValue = "";
                            String value = attribValue.toString();
                            if (value.equalsIgnoreCase("1")) {
                                value = "true";
                                dialInValue = "TRUE";
                            } else if (value.equalsIgnoreCase("0")) {
                                value = "false";
                                dialInValue = "FALSE";
                            }
                            fcAttribute.setAttributeValue((Object)value.toUpperCase());
                            propList.add(fcAttribute.getHashTableForNative());
                            if (dialInValue.equalsIgnoreCase("")) continue;
                            props.put("dialIn", dialInValue);
                            continue;
                        }
                        if (attribValue == null) continue;
                        String dialInValue = "";
                        String value = attribValue.toString();
                        if (value.equalsIgnoreCase("1")) {
                            dialInValue = "TRUE";
                        } else if (value.equalsIgnoreCase("0")) {
                            dialInValue = "FALSE";
                        }
                        props.put("dialIn", dialInValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("protocolSettings")) {
                        JSONObject protocolObject = (JSONObject)attribValue;
                        ArrayList<String> protocolSettingsValue = new ArrayList<String>();
                        Boolean isOwaEnabled = protocolObject.getBoolean("isOwaEnabled");
                        Boolean isPop3Enabled = protocolObject.getBoolean("isPop3Enabled");
                        Boolean isImap4Enabled = protocolObject.getBoolean("isImap4Enabled");
                        if (exchangeType == null) continue;
                        if (isOwaEnabled.booleanValue()) {
                            if (exchangeType == 2007) {
                                protocolSettingsValue.add(UserMgmtUtil.HTTP_ENABLE_X07);
                            } else if (exchangeType == 2010) {
                                protocolSettingsValue.add(UserMgmtUtil.HTTP_ENABLE_X10);
                            } else if (exchangeType == 2013) {
                                protocolSettingsValue.add(UserMgmtUtil.HTTP_ENABLE_X13);
                            } else if (exchangeType == 2016) {
                                protocolSettingsValue.add(UserMgmtUtil.HTTP_ENABLE_X16);
                            } else {
                                protocolSettingsValue.add(UserMgmtUtil.HTTP_ENABLE);
                            }
                        } else if (exchangeType == 2007) {
                            protocolSettingsValue.add(UserMgmtUtil.HTTP_DISABLE_X07);
                        } else if (exchangeType == 2010) {
                            protocolSettingsValue.add(UserMgmtUtil.HTTP_DISABLE_X10);
                        } else if (exchangeType == 2013) {
                            protocolSettingsValue.add(UserMgmtUtil.HTTP_DISABLE_X13);
                        } else if (exchangeType == 2016) {
                            protocolSettingsValue.add(UserMgmtUtil.HTTP_DISABLE_X16);
                        } else {
                            protocolSettingsValue.add(UserMgmtUtil.HTTP_DISABLE);
                        }
                        if (isPop3Enabled.booleanValue()) {
                            if (exchangeType == 2007) {
                                protocolSettingsValue.add(UserMgmtUtil.POP3_ENABLE_X07);
                            } else if (exchangeType == 2010) {
                                protocolSettingsValue.add(UserMgmtUtil.POP3_ENABLE_X10);
                            } else if (exchangeType == 2013) {
                                protocolSettingsValue.add(UserMgmtUtil.POP3_ENABLE_X13);
                            } else if (exchangeType == 2016) {
                                protocolSettingsValue.add(UserMgmtUtil.POP3_ENABLE_X16);
                            } else {
                                protocolSettingsValue.add(UserMgmtUtil.POP3_ENABLE);
                            }
                        } else if (exchangeType == 2007) {
                            protocolSettingsValue.add(UserMgmtUtil.POP3_DISABLE_X07);
                        } else if (exchangeType == 2010) {
                            protocolSettingsValue.add(UserMgmtUtil.POP3_DISABLE_X10);
                        } else if (exchangeType == 2013) {
                            protocolSettingsValue.add(UserMgmtUtil.POP3_DISABLE_X13);
                        } else if (exchangeType == 2016) {
                            protocolSettingsValue.add(UserMgmtUtil.POP3_DISABLE_X16);
                        } else {
                            protocolSettingsValue.add(UserMgmtUtil.POP3_DISABLE);
                        }
                        if (isImap4Enabled.booleanValue()) {
                            if (exchangeType == 2007) {
                                protocolSettingsValue.add(UserMgmtUtil.IMAP4_ENABLE_X07);
                            } else if (exchangeType == 2010) {
                                protocolSettingsValue.add(UserMgmtUtil.IMAP4_ENABLE_X10);
                            } else if (exchangeType == 2013) {
                                protocolSettingsValue.add(UserMgmtUtil.IMAP4_ENABLE_X13);
                            } else if (exchangeType == 2016) {
                                protocolSettingsValue.add(UserMgmtUtil.IMAP4_ENABLE_X16);
                            } else {
                                protocolSettingsValue.add(UserMgmtUtil.IMAP4_ENABLE);
                            }
                        } else if (exchangeType == 2007) {
                            protocolSettingsValue.add(UserMgmtUtil.IMAP4_DISABLE_X07);
                        } else if (exchangeType == 2010) {
                            protocolSettingsValue.add(UserMgmtUtil.IMAP4_DISABLE_X10);
                        } else if (exchangeType == 2013) {
                            protocolSettingsValue.add(UserMgmtUtil.IMAP4_DISABLE_X13);
                        } else if (exchangeType == 2016) {
                            protocolSettingsValue.add(UserMgmtUtil.IMAP4_DISABLE_X16);
                        } else {
                            protocolSettingsValue.add(UserMgmtUtil.IMAP4_DISABLE);
                        }
                        fcAttribute.setAttributeValueCount((Object)protocolSettingsValue.size());
                        fcAttribute.setAttributeValue(protocolSettingsValue);
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("unauthOrig") || attributeName.equalsIgnoreCase("authOrig") || attributeName.equalsIgnoreCase("msExchBypassModerationLink")) {
                        Hashtable dLTable = (Hashtable)fcAttribute.getHashTableForNative().clone();
                        ArrayList list = (ArrayList)attribValue;
                        ArrayList<String> dLMemRejectList = new ArrayList<String>();
                        ArrayList<String> unauthOrigList = new ArrayList<String>();
                        if (!list.isEmpty()) {
                            for (Object object : list) {
                                String dn = (String)object;
                                String objectClass = UserMgmtUtil.getMailRecipientObjectClass((String)(dn = dn.trim()));
                                if (objectClass.equalsIgnoreCase("group")) {
                                    dLMemRejectList.add(dn);
                                    continue;
                                }
                                unauthOrigList.add(dn);
                            }
                        }
                        if (!unauthOrigList.isEmpty()) {
                            fcAttribute.setAttributeValueCount((Object)unauthOrigList.size());
                            if (unauthOrigList.size() == 1) {
                                fcAttribute.setAttributeValue(unauthOrigList.get(0));
                            } else if (list.size() > 1) {
                                fcAttribute.setAttributeValue(unauthOrigList);
                            }
                            propList.add(fcAttribute.getHashTableForNative());
                        }
                        if (!dLMemRejectList.isEmpty()) {
                            if (attributeName.equalsIgnoreCase("msExchBypassModerationLink")) {
                                dLTable.put("ATTRIB_LDAP_NAME", "msExchBypassModerationFromDLMembersLink");
                            } else if (attributeName.equalsIgnoreCase("authOrig")) {
                                dLTable.put("ATTRIB_LDAP_NAME", "dLMemSubmitPerms");
                            } else {
                                dLTable.put("ATTRIB_LDAP_NAME", "dLMemRejectPerms");
                            }
                            dLTable.put("ATTRIB_VALUE_COUNT", dLMemRejectList.size());
                            if (dLMemRejectList.size() == 1) {
                                dLTable.put("ATTRIB_VALUE", dLMemRejectList.get(0));
                            } else if (dLMemRejectList.size() > 1) {
                                dLTable.put("ATTRIB_VALUE", dLMemRejectList);
                            }
                            propList.add(dLTable);
                        }
                        if (!modifyObject) continue;
                        if (unauthOrigList.isEmpty()) {
                            fcAttribute.setAttributeValueCount((Object)1L);
                            fcAttribute.setAttributeValue((Object)"");
                            fcAttribute.setDWControlCode(Long.valueOf(1L));
                            propList.add(fcAttribute.getHashTableForNative());
                        } else if (fcAttribute.getDWControlCode() != null) {
                            fcAttribute.getHashTableForNative().remove("DW_CONTROL_CODE");
                        }
                        if (!dLMemRejectList.isEmpty()) continue;
                        if (attributeName.equalsIgnoreCase("msExchBypassModerationLink")) {
                            dLTable.put("ATTRIB_LDAP_NAME", "msExchBypassModerationFromDLMembersLink");
                        } else if (attributeName.equalsIgnoreCase("authOrig")) {
                            dLTable.put("ATTRIB_LDAP_NAME", "dLMemSubmitPerms");
                        } else {
                            dLTable.put("ATTRIB_LDAP_NAME", "dLMemRejectPerms");
                        }
                        dLTable.put("ATTRIB_VALUE_COUNT", 1L);
                        dLTable.put("ATTRIB_VALUE", "");
                        dLTable.put("DW_CONTROL_CODE", 1L);
                        propList.add(dLTable);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("password") || attributeName.equalsIgnoreCase("passwordType")) continue;
                    if (attributeName.equalsIgnoreCase("homeDrive") || attributeName.equalsIgnoreCase("homeDirectory")) {
                        String attribVal = attribValue.toString();
                        if (attributeName.equalsIgnoreCase("homeDirectory")) {
                            String newAttribVal = FcExecuteNamingFormat.getFormatValue(attribVal, null, ldapVsValueProps);
                            if (!newAttribVal.equals(attribVal)) {
                                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                hash.put("attr", fcAttribute);
                                hash.put("value", newAttribVal);
                                this.toBeUpdatedInDB.add(hash);
                            }
                            attribVal = newAttribVal;
                            fcAttribute.setAttributeValue((Object)attribVal);
                        }
                        if (attribVal.trim().length() != 0) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("altRecipient")) {
                        String attribVal = attribValue.toString();
                        if (attribVal.trim().length() != 0) {
                            fcAttribute.setDataHandlerType(Long.valueOf(1L));
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("publicDelegates")) {
                        ArrayList sendOnBehalfVals = (ArrayList)attribValue;
                        if (sendOnBehalfVals.size() > 0) {
                            if (sendOnBehalfVals.size() == 1) {
                                fcAttribute.setAttributeValue((Object)((String)sendOnBehalfVals.get(0)));
                            }
                            fcAttribute.setAttributeValueCount((Object)sendOnBehalfVals.size());
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("sendAs")) {
                        ArrayList sendAsVals = (ArrayList)attribValue;
                        props.put("sendAs", sendAsVals);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("fullPermission")) {
                        ArrayList fullPermissionVals = (ArrayList)attribValue;
                        if (!fullPermissionVals.isEmpty()) {
                            if (!modifyObject) {
                                props.put("fullPermission", fullPermissionVals);
                            } else {
                                for (String string : fullPermissionVals) {
                                    if (this.fullPermissionList.contains(string) || this.addedFullPermissionList.contains(string)) continue;
                                    this.addedFullPermissionList.add(string);
                                }
                            }
                        }
                        if (!modifyObject) continue;
                        for (int i = 0; i < this.fullPermissionList.size(); ++i) {
                            String dn = (String)this.fullPermissionList.get(i);
                            if (fullPermissionVals.contains(dn) || this.toBeRemovedFullPermissionList.contains(dn)) continue;
                            this.toBeRemovedFullPermissionList.add(dn);
                        }
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("deletedItemFlags")) {
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchOmaAdminWirelessEnable")) {
                        if (this.isPowerShellEnabled) {
                            int attributeVal = Integer.parseInt(attribValue.toString());
                            attributeVal = exchangeType >= 2013 ? (attributeVal &= 0xC) : (attributeVal &= 4);
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            hash.put("attr", fcAttribute);
                            hash.put("value", String.valueOf(attributeVal));
                            this.toBeUpdatedInDB.add(hash);
                            fcAttribute.setAttributeValue((Object)String.valueOf(attributeVal));
                        }
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("garbageCollPeriod") || attributeName.equalsIgnoreCase("msExchRecipLimit")) {
                        String tmpValue = (String)attribValue;
                        if (tmpValue.equals("-1")) {
                            tmpValue = "";
                        }
                        if (!tmpValue.equals("")) {
                            fcAttribute.setAttributeValue((Object)tmpValue.toString());
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchArchiveDatabaseLink")) {
                        props.put("msExchArchiveDatabaseLink", (String)attribValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchArchiveAddress")) {
                        props.put("msExchArchiveAddress", (String)attribValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("mDBUseDefaults") || attributeName.equalsIgnoreCase("mDBStorageQuota") || attributeName.equalsIgnoreCase("mDBOverQuotaLimit") || attributeName.equalsIgnoreCase("mDBOverHardQuotaLimit")) {
                        if (props.get("msExchHomeServerName") == null) continue;
                        fcLayoutField.updateFieldValueToAttributeForNative(requiredProps, propList);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("deliverAndRedirect")) {
                        Boolean tmpValue = (Boolean)attribValue;
                        if (tmpValue.booleanValue()) {
                            fcAttribute.setAttributeValue((Object)"TRUE");
                        } else {
                            fcAttribute.setAttributeValue((Object)"FALSE");
                        }
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("homeMDB")) {
                        if (modifyObject) continue;
                        String mailBoxStore = (String)attribValue;
                        props.put("homeMDB", mailBoxStore);
                        if (exchangeType != null && exchangeType == 2003) {
                            propList.add(fcAttribute.getHashTableForNative());
                        }
                        if (!mailBoxStore.equalsIgnoreCase("0")) continue;
                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                        hash.put("attr", fcAttribute);
                        hash.put("value", this.rb.getString("admp.mgmt.user_mgmt.cre_template.auto_select_mailbox"));
                        this.toBeUpdatedInDB.add(hash);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("accountExpires")) {
                        String expiryDate = (String)attribValue;
                        if (!expiryDate.equalsIgnoreCase("")) {
                            SimpleDateFormat formatter;
                            Date date = new Date();
                            String regex = "^(1[0-2]|0[1-9])-(3[01]|[12][0-9]|0[1-9])-[0-9]{4}$";
                            Pattern pattern = Pattern.compile(regex);
                            Matcher matcher = pattern.matcher(expiryDate);
                            String regex1 = "^[0-9]{4}/(1[0-2]|0[1-9])/(3[01]|[12][0-9]|0[1-9])$";
                            Pattern pattern1 = Pattern.compile(regex1);
                            Matcher matcher1 = pattern1.matcher(expiryDate);
                            if (matcher.matches()) {
                                formatter = new SimpleDateFormat("MM-dd-yyyy");
                                date = formatter.parse(expiryDate);
                            } else if (matcher1.matches()) {
                                formatter = new SimpleDateFormat("yyyy/MM/dd");
                                date = formatter.parse(expiryDate);
                            }
                            fcAttribute.setAttributeValue((Object)DateTimeUtil.getFileTimeFromSystemTime((Long)date.getTime()));
                            fcAttribute.setDataHandlerType(Long.valueOf(10L));
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setDataHandlerType(Long.valueOf(10L));
                        fcAttribute.setAttributeValue((Object)0L);
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("userWorkstations")) {
                        String workStations = (String)attribValue;
                        if (!workStations.equalsIgnoreCase("")) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("submissionContLength") || attributeName.equalsIgnoreCase("delivContLength")) {
                        Long size = (Long)attribValue;
                        if (!size.equals(new Long(-1L))) {
                            fcAttribute.setAttributeValue((Object)size.toString());
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("userPrincipalName")) {
                        String tmpUPNValue = (String)attribValue;
                        if (!tmpUPNValue.equalsIgnoreCase("")) {
                            if (this.essentialAttributes.contains(attributeName)) {
                                essentialPropList.add(fcAttribute.getHashTableForNative());
                            } else {
                                propList.add(fcAttribute.getHashTableForNative());
                            }
                            if (modifyObject) continue;
                            props.put("upn", tmpUPNValue);
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.startsWith("ts")) {
                        String attribVal = attribValue.toString();
                        if (attributeName.equalsIgnoreCase("tsWorkingDir") || attributeName.equalsIgnoreCase("tsHomeDir") || attributeName.equalsIgnoreCase("tsProfilePath")) {
                            String newAttribVal = FcExecuteNamingFormat.getFormatValue(attribVal, null, ldapVsValueProps);
                            if (!newAttribVal.equals(attribVal)) {
                                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                hash.put("attr", fcAttribute);
                                hash.put("value", newAttribVal);
                                this.toBeUpdatedInDB.add(hash);
                            }
                            attribVal = newAttribVal;
                        }
                        if (!attribVal.equals("")) {
                            if (fcAttribute.getDWControlCode() != null) {
                                fcAttribute.getHashTableForNative().remove("DW_CONTROL_CODE");
                            }
                            fcAttribute.setAttributeValue((Object)attribVal);
                            tsList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)"");
                        tsList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("pwdLastSet")) {
                        if (attribValue != null && attribValue instanceof Long) {
                            boolean changePwdAtNextLogonChecked;
                            boolean bl = changePwdAtNextLogonChecked = (Long)attribValue == 0L;
                            if (!modifyObject || this.changePwdAtNextLogonValue != changePwdAtNextLogonChecked) {
                                fcAttribute.setAttributeValue((Object)((Long)attribValue));
                                propList.add(fcAttribute.getHashTableForNative());
                            }
                        }
                        if (attribValue == null || isPwdLastSetModified || !modifyObject || !this.changePwdAtNextLogonValue || !"mustchangepassword".equals(attribValue)) continue;
                        fcAttribute.setAttributeValue((Object)0L);
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("userFlags")) {
                        String stringObj = attribValue.toString();
                        boolean bl = this.newCantChangePwdValue = stringObj.equalsIgnoreCase("64");
                        if (modifyObject && this.cantChangePwdValue == this.newCantChangePwdValue) continue;
                        this.setCantChangePwdValue = true;
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("userAccountControl")) continue;
                    if (attributeName.equalsIgnoreCase("msRTCSIP-ArchivingEnabled")) {
                        if (!this.isLcsEnabled) continue;
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msRTCSIP-Line") || attributeName.equalsIgnoreCase("msRTCSIP-LineServer") || attributeName.equalsIgnoreCase("msRTCSIP-PrimaryUserAddress")) {
                        if (!this.isLcsEnabled) continue;
                        String value = FcExecuteNamingFormat.getFormatValue((String)attribValue, null, ldapVsValueProps);
                        if (!value.equals((String)attribValue)) {
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            hash.put("attr", fcAttribute);
                            hash.put("value", value);
                            this.toBeUpdatedInDB.add(hash);
                        }
                        fcAttribute.setAttributeValue((Object)value);
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msRTCSIP-FederationEnabled") || attributeName.equalsIgnoreCase("msRTCSIP-InternetAccessEnabled") || attributeName.equalsIgnoreCase("msRTCSIP-UserEnabled")) {
                        if (!this.isLcsEnabled) continue;
                        boolean attributeValue = (Boolean)attribValue;
                        fcAttribute.setAttributeValue((Object)(attributeValue ? "TRUE" : "FALSE"));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msRTCSIP-PrimaryHomeServer")) {
                        if (modifyObject || !this.isLcsEnabled) continue;
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msRTCSIP-OptionFlags")) {
                        if (!this.isLcsEnabled) continue;
                        if (!modifyObject) {
                            if (props.get("LcsOptionFlags") != null) {
                                FcAttributes fcAttrOptionFlags = (FcAttributes)props.get("LcsOptionFlags");
                                long optionFlagsVal = Long.parseLong((String)fcAttrOptionFlags.getAttribValue());
                                long currentVal = (Long)attribValue;
                                fcAttrOptionFlags.setAttributeValue((Object)new Long(optionFlagsVal += currentVal).toString());
                                continue;
                            }
                            fcAttribute.setAttributeValue((Object)attribValue.toString());
                            props.put("LcsOptionFlags", fcAttribute);
                            continue;
                        }
                        FcAttributes fcAttrOptionFlags = null;
                        if (fcLayoutField.getComponentId() == 50L) {
                            if (props.get("LcsOptionFlags") == null) {
                                props.put("LcsOptionFlags", fcAttribute);
                                tobeUpdatedValue = this.lcsOptionFlagsValue;
                            }
                            fcAttrOptionFlags = (FcAttributes)props.get("LcsOptionFlags");
                            Long currentValue = (Long)attribValue;
                            tobeUpdatedValue = currentValue.equals(0L) ? Long.valueOf(tobeUpdatedValue - 1L) : Long.valueOf(tobeUpdatedValue + 1L);
                        } else if (fcLayoutField.getComponentId() == 52L) {
                            boolean alreadyRemoteEnabled;
                            Long currentValue = (Long)attribValue;
                            boolean bl = alreadyRemoteEnabled = (this.lcsOptionFlagsValue & 0x10L) == 16L;
                            if (currentValue.equals(16L) && alreadyRemoteEnabled) continue;
                            if (props.get("LcsOptionFlags") == null) {
                                props.put("LcsOptionFlags", fcAttribute);
                                tobeUpdatedValue = this.lcsOptionFlagsValue;
                            }
                            fcAttrOptionFlags = (FcAttributes)props.get("LcsOptionFlags");
                            if (currentValue.equals(0L)) {
                                tobeUpdatedValue = tobeUpdatedValue - 16L;
                            } else {
                                int ENABLE_ENTERPRISE_FLAG = 128;
                                int ENABLE_PBX_INTEGRATION = 512;
                                if ((new Long(this.lcsOptionFlagsValue) & (long)ENABLE_ENTERPRISE_FLAG) == (long)ENABLE_ENTERPRISE_FLAG) {
                                    tobeUpdatedValue = tobeUpdatedValue - 128L;
                                }
                                if ((new Long(this.lcsOptionFlagsValue) & (long)ENABLE_PBX_INTEGRATION) == (long)ENABLE_PBX_INTEGRATION) {
                                    tobeUpdatedValue = tobeUpdatedValue - 512L;
                                }
                                tobeUpdatedValue = tobeUpdatedValue + 16L;
                            }
                        }
                        if (fcAttrOptionFlags == null) continue;
                        fcAttrOptionFlags.setAttributeValue((Object)tobeUpdatedValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("lyncRegistrarPoolName") || attributeName.equalsIgnoreCase("lyncSipAddress") || attributeName.equalsIgnoreCase("lyncLineUri") || attributeName.equalsIgnoreCase("lyncLineServerUri") || attributeName.equalsIgnoreCase("lyncTelephonyType")) {
                        if (!this.isLyncEnabled) continue;
                        String formattedAttributeValue = FcExecuteNamingFormat.getFormatValue((String)attribValue, null, ldapVsValueProps);
                        if (!formattedAttributeValue.equals((String)attribValue)) {
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            hash.put("attr", fcAttribute);
                            hash.put("value", formattedAttributeValue);
                            this.toBeUpdatedInDB.add(hash);
                        }
                        this.lyncDetails.put(attributeName, formattedAttributeValue);
                        if (!modifyObject || attributeName.equalsIgnoreCase("lyncRegistrarPoolName")) continue;
                        Properties addProps = new Properties();
                        addProps.put("ATTRIB_LDAP_NAME", this.rb.getString(fcAttribute.getAttribDisplayName()));
                        addProps.put("ATTRIB_VALUE", formattedAttributeValue);
                        this.lyncAuditPropList.add(addProps);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("lyncConferencePolicy") || attributeName.equalsIgnoreCase("lyncClientVersionPolicy") || attributeName.equalsIgnoreCase("lyncPinPolicy") || attributeName.equalsIgnoreCase("lyncExternalAccessPolicy") || attributeName.equalsIgnoreCase("lyncArchivingPolicy") || attributeName.equalsIgnoreCase("lyncLocationPolicy") || attributeName.equalsIgnoreCase("lyncClientPolicy") || attributeName.equalsIgnoreCase("lyncDialPlanPolicy") || attributeName.equalsIgnoreCase("lyncVoicePolicy") || attributeName.equalsIgnoreCase("lyncMobilityPolicy")) {
                        ArrayList policiesList;
                        if (attributeName.equalsIgnoreCase("lyncMobilityPolicy") && modifyObject && this.lyncServerVersion.compareTo(327680L) <= 0 || (attributeName.equalsIgnoreCase("lyncDialPlanPolicy") || attributeName.equalsIgnoreCase("lyncVoicePolicy")) && !this.selectedTelephonyType.equalsIgnoreCase("EnterpriseVoiceEnabled") || !this.isLyncEnabled) continue;
                        if (this.lyncDetails.get("lyncPolicies") == null) {
                            policiesList = new ArrayList();
                        } else {
                            policiesList = (ArrayList)this.lyncDetails.get("lyncPolicies");
                            this.lyncDetails.remove("lyncDetails");
                        }
                        Properties policyDetails = (Properties)attribValue;
                        policyDetails.put("policyLdap", attributeName);
                        policiesList.add(policyDetails);
                        this.lyncDetails.put("lyncPolicies", policiesList);
                        if (!modifyObject) continue;
                        Properties addProps = new Properties();
                        String policyName = (String)policyDetails.get("policyName");
                        if (policyName.toLowerCase().startsWith("tag:")) {
                            policyName = policyName.substring(4);
                        }
                        if (policyName.equals("")) {
                            policyName = this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.text.automatic");
                        }
                        addProps.put("ATTRIB_LDAP_NAME", this.rb.getString(fcAttribute.getAttribDisplayName()));
                        addProps.put("ATTRIB_VALUE", policyName);
                        this.lyncAuditPropList.add(addProps);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("lyncPIN")) {
                        if (!modifyObject || !this.isLyncEnabled) continue;
                        this.lyncDetails.put("lyncPIN", (String)attribValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("customScriptDetails")) {
                        if (attribValue == null || attribValue.toString().equals("")) continue;
                        Properties customScriptDetails = (Properties)attribValue;
                        String scriptCommand = customScriptDetails.getProperty("SCRIPT_COMMAND");
                        String nfAppliedScriptCommand = FcExecuteNamingFormat.getFormatValue(scriptCommand, null, ldapVsValueProps, true);
                        customScriptDetails.put("SCRIPT_COMMAND", nfAppliedScriptCommand);
                        props.put("customScriptDetails", customScriptDetails);
                        if (scriptCommand.equals(nfAppliedScriptCommand)) continue;
                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                        hash.put("attr", fcAttribute);
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(nfAppliedScriptCommand);
                        hash.put("value", list);
                        this.toBeUpdatedInDB.add(hash);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("autoMapping")) {
                        props.put("autoMapping", attribValue.toString());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("AutoReply")) {
                        Properties autoReplyDetails = (Properties)attribValue;
                        String internalMsg = autoReplyDetails.getProperty("internalMsg");
                        String externalMsg = autoReplyDetails.getProperty("externalMsg");
                        String autoReplyState = autoReplyDetails.getProperty("autoReplyState");
                        String externalMsgState = autoReplyDetails.getProperty("externalMsgState");
                        props.put("internalmessage", internalMsg);
                        props.put("externalmessage", externalMsg);
                        props.put("autoReplyState", autoReplyState);
                        props.put("externalMsgState", externalMsgState);
                        String startDate = autoReplyDetails.getProperty("sDateValue");
                        String endDate = autoReplyDetails.getProperty("eDateValue");
                        startDate.trim();
                        endDate.trim();
                        props.put("sDateValue", startDate);
                        props.put("eDateValue", endDate);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("upn")) continue;
                    if (attributeName.equalsIgnoreCase("msExchSharingPolicyLink") || attributeName.equalsIgnoreCase("msExchRBACPolicyLink") || attributeName.equalsIgnoreCase("msExchMobileMailboxPolicyLink")) {
                        if (exchangeType != null && exchangeType >= 2010) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                        hash.put("attr", fcAttribute);
                        hash.put("value", "");
                        this.toBeUpdatedInDB.add(hash);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchMailboxTemplateLink")) {
                        if (exchangeType != null && exchangeType >= 2010) {
                            props.put("msExchMailboxTemplateLink", (String)attribValue);
                            continue;
                        }
                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                        hash.put("attr", fcAttribute);
                        hash.put("value", "");
                        this.toBeUpdatedInDB.add(hash);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchMailboxRecipientTemplate")) {
                        if (exchangeType == null || exchangeType != 2010 && exchangeType != 2007) continue;
                        props.put("msExchMailboxRecipientTemplate", (String)attribValue);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("msExchUMMailBoxPolicy")) {
                        Properties exchUMPolicyDetails = (Properties)attribValue;
                        String sipResourceIdentifier = exchUMPolicyDetails.getProperty("SIPResourceIdentifier");
                        String nfAppliedSipIdentifier = FcExecuteNamingFormat.getFormatValue(sipResourceIdentifier, null, ldapVsValueProps);
                        if (exchangeType != null && exchangeType >= 2010) {
                            if (!sipResourceIdentifier.equals(nfAppliedSipIdentifier)) {
                                exchUMPolicyDetails.put("SIPResourceIdentifier", nfAppliedSipIdentifier);
                                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                hash.put("attr", fcAttribute);
                                ArrayList<String> list = new ArrayList<String>();
                                list.add(nfAppliedSipIdentifier);
                                list.add(exchUMPolicyDetails.getProperty("sipType"));
                                hash.put("value", list);
                                this.toBeUpdatedInDB.add(hash);
                            }
                            props.put("msExchUMMailBoxPolicy", exchUMPolicyDetails);
                            continue;
                        }
                        if (sipResourceIdentifier != null && nfAppliedSipIdentifier != null && !sipResourceIdentifier.equals(nfAppliedSipIdentifier)) {
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            hash.put("attr", fcAttribute);
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(nfAppliedSipIdentifier);
                            list.add(exchUMPolicyDetails.getProperty("sipType"));
                            hash.put("value", list);
                            this.toBeUpdatedInDB.add(hash);
                            continue;
                        }
                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                        hash.put("attr", fcAttribute);
                        hash.put("value", new ArrayList());
                        this.toBeUpdatedInDB.add(hash);
                        continue;
                    }
                    if (attributeName.equals("targetAddress")) {
                        if ((exchangeType == null || exchangeType != 2003) && !modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)((String)attribValue));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("mail")) {
                        if (attribValue == null) continue;
                        String nfAppliedEmail = FcExecuteNamingFormat.getFormatValue(attribValue.toString(), null, ldapVsValueProps);
                        props.put("mailAttribtueValue", nfAppliedEmail);
                        if (attribValue.equals(nfAppliedEmail)) continue;
                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                        hash.put("attr", fcAttribute);
                        hash.put("value", nfAppliedEmail);
                        this.toBeUpdatedInDB.add(hash);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("manager") || attributeName.equalsIgnoreCase("managedBy")) {
                        String stringObj = attribValue.toString();
                        if (!stringObj.equals("")) {
                            fcAttribute.setAttributeValue((Object)stringObj);
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setAttributeValue((Object)stringObj);
                        fcAttribute.setAttributeValue((Object)"");
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("grouptype")) {
                        if (props.get("groupType") == null && props.get("groupScope") == null) continue;
                        int flag = 0;
                        int groupType = props.get("groupType") != null ? Integer.parseInt((String)props.remove("groupType")) : this.groupType;
                        int groupScope = props.get("groupScope") != null ? Integer.parseInt((String)props.remove("groupScope")) : this.groupScope;
                        flag |= groupType;
                        fcAttribute.setDataHandlerType(Long.valueOf(7L));
                        fcAttribute.setAttributeValue((Object)String.valueOf(flag |= groupScope));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("member")) {
                        ArrayList<String> list;
                        if (!modifyObject) {
                            ArrayList<String> list2;
                            if (attribValue instanceof String) {
                                list2 = new ArrayList<String>();
                                list2.add((String)attribValue);
                            } else {
                                list2 = (ArrayList<String>)attribValue;
                            }
                            for (String string : list2) {
                                if (this.addedMembersList.contains(string)) continue;
                                if (CommonUtil.isCrossForestMember((String)this.domainName, (String)string)) {
                                    String memberSID = UserMgmtUtil.getSIDFromDN((String)DomainUtil.getDomainNamefromDN((String)string), (String)string);
                                    if (memberSID == null || this.crossForestMembersList.contains(memberSID)) continue;
                                    this.crossForestMembersList.add(memberSID);
                                    this.crossForestMembersDNList.add(string);
                                    continue;
                                }
                                this.addedMembersList.add(string);
                            }
                            if (this.addedMembersList.size() <= 0) continue;
                            this.fillMembersValue(fcAttribute, this.addedMembersList, 3L);
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (attribValue instanceof String) {
                            list = new ArrayList<String>();
                            list.add((String)attribValue);
                        } else {
                            list = (ArrayList<String>)attribValue;
                        }
                        for (String string : list) {
                            if (this.membersList.contains(string) || this.addedMembersList.contains(string)) continue;
                            if (CommonUtil.isCrossForestMember((String)this.domainName, (String)string)) {
                                String memberSID = UserMgmtUtil.getSIDFromDN((String)DomainUtil.getDomainNamefromDN((String)string), (String)string);
                                if (memberSID == null || this.crossForestMembersList.contains(memberSID)) continue;
                                this.crossForestMembersList.add(memberSID);
                                this.crossForestMembersDNList.add(string);
                                continue;
                            }
                            this.addedMembersList.add(string);
                        }
                        if (this.addedMembersList.size() > 0) {
                            this.fillMembersValue(fcAttribute, this.addedMembersList, 3L);
                            propList.add(fcAttribute.getHashTableForNative());
                        }
                        for (int i = 0; i < this.membersList.size(); ++i) {
                            String dn = (String)this.membersList.get(i);
                            if (this.excludedMembersList.contains(dn) || list.contains(dn) || this.toBeRemovedMembersList.contains(dn)) continue;
                            this.toBeRemovedMembersList.add(dn);
                        }
                        if (this.toBeRemovedMembersList.size() <= 0) continue;
                        this.fillMembersValue(fcAttribute, this.toBeRemovedMembersList, 4L);
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("managerCanUpdateMembers") || attributeName.equalsIgnoreCase("waadRemoteMailbox") || attributeName.equalsIgnoreCase("waadRemoteRoutingAddress") || attributeName.equalsIgnoreCase("waadRemoteMailboxArchieve") || attributeName.equalsIgnoreCase("waadproxyAddresses") || attributeName.equalsIgnoreCase("preventDeletion")) continue;
                    if (attributeName.equalsIgnoreCase("AutomateProcessing")) {
                        if (attribValue.toString().equals("")) continue;
                        String value = attribValue.toString();
                        String param = "None";
                        if (value.equalsIgnoreCase("true")) {
                            param = "AutoAccept";
                        }
                        powerShellCommand.addParameter(attributeName, param);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("ResourceDelegates")) {
                        ArrayList resourceDelegates = (ArrayList)attribValue;
                        if (modifyObject) {
                            powerShellCommand.addParameter(attributeName, resourceDelegates);
                            continue;
                        }
                        if (resourceDelegates.size() <= 0) continue;
                        powerShellCommand.addParameter(attributeName, resourceDelegates);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("AllowConflicts") || attributeName.equalsIgnoreCase("ScheduleOnlyDuringWorkHours") || attributeName.equalsIgnoreCase("ForwardRequestsToDelegates") || attributeName.equalsIgnoreCase("DeleteAttachments") || attributeName.equalsIgnoreCase("DeleteComments") || attributeName.equalsIgnoreCase("RemovePrivateProperty") || attributeName.equalsIgnoreCase("DeleteSubject") || attributeName.equalsIgnoreCase("AddOrganizerToSubject") || attributeName.equalsIgnoreCase("TentativePendingApproval") || attributeName.equalsIgnoreCase("OrganizerInfo") || attributeName.equalsIgnoreCase("DeleteNonCalendarItems") || attributeName.equalsIgnoreCase("AddAdditionalResponse") || attributeName.equalsIgnoreCase("TentativePendingApproval") || attributeName.equalsIgnoreCase("AllowRecurringMeetings") || attributeName.equalsIgnoreCase("EnforceSchedulingHorizon")) {
                        if (attribValue.toString().equals("")) continue;
                        String value = attribValue.toString();
                        boolean param = false;
                        if (value.equalsIgnoreCase("true")) {
                            param = true;
                        }
                        powerShellCommand.addParameter(attributeName, param);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("BookingWindowInDays") || attributeName.equalsIgnoreCase("MaximumDurationInMinutes") || attributeName.equalsIgnoreCase("MaximumConflictInstances") || attributeName.equalsIgnoreCase("ConflictPercentageAllowed") || attributeName.equalsIgnoreCase("AdditionalResponse")) {
                        if (attribValue == null) continue;
                        String value = attribValue.toString();
                        value = value.replaceAll("'", "''");
                        powerShellCommand.addParameter(attributeName, value);
                        continue;
                    }
                    if (attributeName.equalsIgnoreCase("AllBookInPolicy") || attributeName.equalsIgnoreCase("AllRequestInPolicy") || attributeName.equalsIgnoreCase("AllRequestOutOfPolicy")) {
                        ArrayList list = (ArrayList)attribValue;
                        if (list.size() > 0 || ((FcDeliveryRestriction)fcLayoutField.getIComponent()).getIsOnlyFrom()) {
                            powerShellCommand.addParameter(attributeName, false);
                            FcAttributes fcAttribute1 = (FcAttributes)fcAttributeList.get(1);
                            String multiValueAttribute = fcAttribute1.getAttribLdapName();
                            if (list.size() == 0) {
                                powerShellCommand.addParameterNull(multiValueAttribute);
                                continue;
                            }
                            powerShellCommand.addParameter(multiValueAttribute, list);
                            continue;
                        }
                        powerShellCommand.addParameter(attributeName, true);
                        continue;
                    }
                    if (attributeName.equals("")) continue;
                    if (!attribValue.toString().equals("")) {
                        String stringObj = attribValue.toString();
                        if (stringObj.equals("")) continue;
                        Long dataHandlerType = fcAttribute.getDataHandlerType();
                        if (dataHandlerType.intValue() == 6) {
                            if (stringObj.equals("true")) {
                                stringObj = "TRUE";
                            } else if (stringObj.equals("false")) {
                                stringObj = "FALSE";
                            } else if (stringObj.equals("false") && modifyObject) {
                                stringObj = "-1";
                            }
                            fcAttribute.setAttributeValue((Object)stringObj);
                        } else if (dataHandlerType.intValue() == 10) {
                            fcAttribute.setAttributeValue((Object)AddUserClientUtil.getLongValue(stringObj));
                        } else {
                            String newStringObj = FcExecuteNamingFormat.getFormatValue(stringObj, null, ldapVsValueProps);
                            if (!newStringObj.equals(stringObj)) {
                                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                hash.put("attr", fcAttribute);
                                hash.put("value", newStringObj);
                                this.toBeUpdatedInDB.add(hash);
                            }
                            stringObj = newStringObj;
                            fcAttribute.setAttributeValue((Object)stringObj);
                        }
                        if (!stringObj.equals("")) {
                            propList.add(fcAttribute.getHashTableForNative());
                            continue;
                        }
                        if (!modifyObject) continue;
                        fcAttribute.setDWControlCode(Long.valueOf(1L));
                        propList.add(fcAttribute.getHashTableForNative());
                        continue;
                    }
                    if (!modifyObject) continue;
                    fcAttribute.setAttributeValue((Object)"");
                    fcAttribute.setDWControlCode(Long.valueOf(1L));
                    propList.add(fcAttribute.getHashTableForNative());
                }
            }
            if (props.get("LcsOptionFlags") != null && this.isLcsEnabled) {
                propList.add(((FcAttributes)props.get("LcsOptionFlags")).getHashTableForNative());
            }
            if ((this.isLyncEnabled || this.isLcsEnabled) && (proxyList = (ArrayList)props.get("proxyAddresses")) != null && proxyList.size() == 1) {
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                FcAttributes fcAttr = new FcAttributes();
                fcAttr.setRelationalType(Integer.valueOf(1));
                fcAttr.setAttribColumnName("EMAIL_PROXY_ADDRESSES");
                fcAttr.setAttribLdapName("proxyAddresses");
                fcAttr.setBulkLayoutTableName("FcBulkUserProxyAddressesVals");
                hash.put("attr", fcAttr);
                hash.put("value", proxyList);
                this.toBeUpdatedInDB.add(hash);
            }
            this.setMailRelatedAttributes(modifyObject, exchangeType, domainDetails, duplicateProxyAddressList);
            int uacDiff = Integer.valueOf(this.userAccountControlValue.toString()) - uacValue;
            if (uacDiff != 0 && isUACModified) {
                Hashtable<String, Object> uacHash = new Hashtable<String, Object>();
                uacHash.put("ATTRIB_AND_VALUE", new Integer(~nandValue).toString());
                uacHash.put("ATTRIB_LDAP_NAME", "userAccountControl");
                uacHash.put("ATTRIB_VALUE", new Integer(uacValue).toString());
                uacHash.put("ATTRIB_UAC_VALUE", new Long((this.userAccountControlValue | (long)uacValue) & (long)(~nandValue)).toString());
                uacHash.put("ATTRIB_VALUE_COUNT", new Long(1L));
                uacHash.put("DATA_HANDLER_TYPE", new Long(7L));
                modifyList.add(uacHash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList removeDuplicateProxyAddresses(ArrayList newProxyAddressesList, boolean modifyObject, Properties domainDetails, ArrayList duplicateProxyDetailsList) {
        String proxyToCompare;
        int index;
        ArrayList<String> listToCompareWithAD = new ArrayList<String>();
        if (modifyObject) {
            for (index = 0; index < newProxyAddressesList.size(); ++index) {
                proxyToCompare = (String)newProxyAddressesList.get(index);
                if (this.existingProxyAddresses != null && this.existingProxyAddresses.contains(proxyToCompare)) continue;
                listToCompareWithAD.add(proxyToCompare);
            }
        } else {
            for (index = 0; index < newProxyAddressesList.size(); ++index) {
                proxyToCompare = (String)newProxyAddressesList.get(index);
                listToCompareWithAD.add(proxyToCompare);
            }
        }
        try {
            if (listToCompareWithAD.size() > 0) {
                String searchDN = this.fcNativeProperties.getDN();
                if (searchDN != null && modifyObject && (duplicateProxyDetailsList == null || duplicateProxyDetailsList.isEmpty())) {
                    ArrayList<String> attribList = new ArrayList<String>();
                    attribList.add("name");
                    attribList.add("proxyAddresses");
                    String searchString = "(&(!(distinguishedName=" + CommonUtil.escapeSpecialCharacters((String)searchDN) + "))(objectClass=*)(|";
                    for (int index2 = 0; index2 < listToCompareWithAD.size(); ++index2) {
                        searchString = searchString + "(proxyAddresses=*:" + ((String)listToCompareWithAD.get(index2)).substring(5) + ")";
                    }
                    searchString = searchString + "))";
                    duplicateProxyDetailsList = ADHandler.getObjectsWithOutListenerFromGC((Properties)domainDetails, (String)((String)domainDetails.get("ROOT_DOMAIN_NAMING_CONTEXT")), attribList, (String)searchString);
                }
                for (int index3 = 0; index3 < duplicateProxyDetailsList.size(); ++index3) {
                    Hashtable userData = (Hashtable)duplicateProxyDetailsList.get(index3);
                    ArrayList userProxyVals = (ArrayList)userData.get("proxyAddresses");
                    for (int innerIndex = 0; innerIndex < listToCompareWithAD.size(); ++innerIndex) {
                        String proxyAddressVal = (String)listToCompareWithAD.get(innerIndex);
                        boolean doesProxyExists = false;
                        for (int indexVal = 0; indexVal < userProxyVals.size(); ++indexVal) {
                            if (!((String)userProxyVals.get(indexVal)).equalsIgnoreCase(proxyAddressVal)) continue;
                            doesProxyExists = true;
                            break;
                        }
                        if (!doesProxyExists) continue;
                        newProxyAddressesList.remove(proxyAddressVal);
                        Hashtable<String, String> hash = new Hashtable<String, String>();
                        hash.put("PROXY_ADDRESS", proxyAddressVal);
                        hash.put("USER_NAME", (String)((ArrayList)userData.get("name")).get(0));
                        this.removedProxyAddresses.add(hash);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newProxyAddressesList;
    }

    public void setMailRelatedAttributes(boolean modifyObject, Integer exchangeType, Properties domainDetails, ArrayList duplicateProxyAddressList) {
        ArrayList propList = this.fcNativeProperties.getPropList();
        Properties props = this.fcNativeProperties.getProps();
        boolean isTargetAddressChanged = props.get("targetAddress") != null;
        boolean isProxyAddressChanged = props.get("proxyAddresses") != null;
        boolean hasPrimarySmtp = false;
        boolean isProxyAddressChangedByTargetAddress = false;
        if (isTargetAddressChanged || isProxyAddressChanged) {
            ArrayList newProxyAddressList = new ArrayList();
            if (isProxyAddressChanged) {
                newProxyAddressList = (ArrayList)props.get("proxyAddresses");
            } else if (modifyObject && this.existingProxyAddresses != null) {
                newProxyAddressList = this.existingProxyAddresses;
            }
            if (isTargetAddressChanged && modifyObject && this.existingTargetAddress != null) {
                newProxyAddressList.remove(this.existingTargetAddress);
            }
            for (int index = 0; index < newProxyAddressList.size(); ++index) {
                String proxyAddr = (String)newProxyAddressList.get(index);
                if (!proxyAddr.startsWith("SMTP:")) continue;
                hasPrimarySmtp = true;
                if (this.effectiveMailAddress.length() != 0) continue;
                this.effectiveMailAddress = proxyAddr.substring(5);
            }
            String newTargetAddress = "";
            if (this.existingTargetAddress != null || !modifyObject) {
                if (isTargetAddressChanged && (modifyObject || !modifyObject && this.msExchPoliciesExcluded && exchangeType != null)) {
                    newTargetAddress = (String)props.get("targetAddress");
                } else if (modifyObject) {
                    newTargetAddress = this.existingTargetAddress;
                }
                if (!newTargetAddress.equals("")) {
                    String targetAddressToAdd;
                    if (!newProxyAddressList.contains("smtp:" + newTargetAddress.substring(5)) && !newProxyAddressList.contains("SMTP:" + newTargetAddress.substring(5))) {
                        targetAddressToAdd = "";
                        isProxyAddressChangedByTargetAddress = true;
                        if (hasPrimarySmtp) {
                            targetAddressToAdd = "smtp:" + newTargetAddress.substring(5);
                        } else {
                            targetAddressToAdd = "SMTP:" + newTargetAddress.substring(5);
                            if (this.effectiveMailAddress.length() == 0) {
                                this.effectiveMailAddress = targetAddressToAdd.substring(5);
                            }
                        }
                        newProxyAddressList.add(targetAddressToAdd);
                    } else if (newProxyAddressList.contains("smtp:" + newTargetAddress.substring(5)) && !hasPrimarySmtp) {
                        targetAddressToAdd = "";
                        isProxyAddressChangedByTargetAddress = true;
                        targetAddressToAdd = "SMTP:" + newTargetAddress.substring(5);
                        if (this.effectiveMailAddress.length() == 0) {
                            this.effectiveMailAddress = targetAddressToAdd.substring(5);
                        }
                        newProxyAddressList.remove("smtp:" + newTargetAddress.substring(5));
                        newProxyAddressList.add(targetAddressToAdd);
                    }
                }
            }
            newProxyAddressList = this.removeDuplicateProxyAddresses(newProxyAddressList, modifyObject, domainDetails, duplicateProxyAddressList);
            if ((isProxyAddressChanged || isProxyAddressChangedByTargetAddress) && newProxyAddressList.size() > 0) {
                Hashtable<String, Object> proxyAddresses = new Hashtable<String, Object>();
                proxyAddresses.put("ATTRIB_LDAP_NAME", "proxyAddresses");
                if (newProxyAddressList.size() > 1) {
                    proxyAddresses.put("ATTRIB_VALUE", newProxyAddressList);
                } else {
                    proxyAddresses.put("ATTRIB_VALUE", (String)newProxyAddressList.get(0));
                }
                proxyAddresses.put("ATTRIB_VALUE_COUNT", newProxyAddressList.size());
                proxyAddresses.put("ATTRIB_COLUMN_NAME", "EMAIL_PROXY_ADDRESSES");
                proxyAddresses.put("DW_CONTROL_CODE", new Long(2L));
                proxyAddresses.put("DATA_HANDLER_TYPE", new Long(3L));
                propList.add(proxyAddresses);
            }
        }
        if (this.effectiveMailAddress.length() > 0) {
            props.put("mailAttribtueValue", this.effectiveMailAddress);
        }
        if (props.get("mailAttribtueValue") != null && (modifyObject || exchangeType == null || this.msExchPoliciesExcluded)) {
            Hashtable<String, Object> mailAttrHash = new Hashtable<String, Object>();
            mailAttrHash.put("ATTRIB_VALUE", (String)props.get("mailAttribtueValue"));
            mailAttrHash.put("ATTRIB_COLUMN_NAME", "EMAIL_ADDRESS");
            mailAttrHash.put("ATTRIB_LDAP_NAME", "mail");
            mailAttrHash.put("ATTRIB_DATA_TYPE", new Integer(1));
            mailAttrHash.put("DATA_HANDLER_TYPE", new Long(3L));
            mailAttrHash.put("ATTRIB_VALUE_COUNT", new Long(1L));
            mailAttrHash.put("DW_CONTROL_CODE", ((String)props.get("mailAttribtueValue")).length() > 0 ? 2L : 1L);
            propList.add(mailAttrHash);
        }
    }

    public ArrayList<Hashtable> getCustomAttribsProperties(FcFormDataContainer customFieldsContainer, boolean modifyObject, Properties ldapVsValueProps, String objectClass) {
        ArrayList<Hashtable> customList = new ArrayList<Hashtable>();
        try {
            if (!this.dpValuesHash.containsKey(this.loginId)) {
                this.dpValuesHash.put(this.loginId, FcLayoutUtil.getDPValues((Long)this.loginId, (String)this.domainName, (AdventNetResourceBundle)this.rb));
            }
            Hashtable dpValues = this.dpValuesHash.get(this.loginId);
            String ouName = ldapVsValueProps.getProperty("OUName");
            this.checkForDuplicates(customFieldsContainer, ldapVsValueProps, dpValues, ouName, ADHandler.getDomainDetails((String)this.domainName, (Long)this.loginId), new ArrayList(), objectClass);
            if (this.stopExecution) {
                return customList;
            }
            Enumeration e = customFieldsContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                Long componentId = fcLayoutField.getComponentId();
                ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
                for (FcAttributes fcAttribute : fcAttributeList) {
                    Hashtable<String, Object> customTable;
                    Object attribValue;
                    block37: {
                        Object value;
                        String attributeName = fcAttribute.getAttribLdapName();
                        attribValue = fcAttribute.getAttribValue();
                        Integer relationalType = fcAttribute.getRelationalType();
                        if (attribValue == null || !modifyObject && attribValue.toString().equals("")) continue;
                        customTable = new Hashtable<String, Object>();
                        customTable.put("ATTRIB_LDAP_NAME", attributeName);
                        customTable.put("DATA_HANDLER_TYPE", 3L);
                        customTable.put("ATTRIB_VALUE_COUNT", 1L);
                        if (componentId.intValue() == 17) {
                            value = attribValue.toString();
                            value = ((String)value).equalsIgnoreCase("true") ? "TRUE" : (((String)value).equalsIgnoreCase("false") ? "FALSE" : "");
                            customTable.put("ATTRIB_VALUE", value);
                        } else {
                            if (fcAttribute.getDataHandlerType() == 9L) {
                                try {
                                    value = Long.valueOf(attribValue.toString());
                                    customTable.put("ATTRIB_VALUE", value);
                                    customTable.put("DATA_HANDLER_TYPE", 9L);
                                    break block37;
                                }
                                catch (Exception ee) {
                                    continue;
                                }
                            }
                            if (attributeName.equalsIgnoreCase("proxyAddresses") && !attribValue.toString().equals("")) {
                                ArrayList escapedList = new ArrayList();
                                if (componentId.intValue() == 79) {
                                    FcMultiValue fcMultiValue = (FcMultiValue)fcLayoutField.getIComponent();
                                    ArrayList<String> valueList = new ArrayList<String>();
                                    Boolean valueChanged = false;
                                    for (FcOption fcOption : fcMultiValue.getFcOptionList()) {
                                        String multiValue = fcOption.getValue();
                                        if (ldapVsValueProps != null && !(multiValue = FcExecuteNamingFormat.getFormatValue(multiValue, null, ldapVsValueProps)).equals(fcOption.getValue())) {
                                            valueChanged = true;
                                        }
                                        valueList.add(multiValue);
                                    }
                                    if (valueChanged.booleanValue()) {
                                        Hashtable<String, Object> hashValue = new Hashtable<String, Object>();
                                        hashValue.put("attr", fcAttribute);
                                        hashValue.put("value", valueList);
                                        hashValue.put("isCustom", true);
                                        this.toBeUpdatedInDB.add(hashValue);
                                    }
                                    if (modifyObject && valueList.size() == 0) {
                                        customTable.put("DW_CONTROL_CODE", 1L);
                                        customTable.put("ATTRIB_VALUE", "");
                                    } else {
                                        escapedList = FcLayoutUtil.getEscapedList(valueList, (String)"EMAIL_PROXY_ADDRESSES");
                                    }
                                } else {
                                    String[] multiValuesArray;
                                    String value2;
                                    String newValue = value2 = attribValue.toString();
                                    if (ldapVsValueProps != null && !(newValue = FcExecuteNamingFormat.getFormatValue(value2, null, ldapVsValueProps)).equals(value2)) {
                                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                                        hash.put("attr", fcAttribute);
                                        hash.put("value", newValue);
                                        hash.put("isCustom", true);
                                        this.toBeUpdatedInDB.add(hash);
                                    }
                                    if ((multiValuesArray = FcLayoutUtil.getMultiValuesFromCSV((String)newValue)).length > 1) {
                                        ArrayList<String> list = new ArrayList<String>();
                                        for (String string : multiValuesArray) {
                                            list.add(string.trim());
                                        }
                                        escapedList = FcLayoutUtil.getEscapedList(list, (String)"EMAIL_PROXY_ADDRESSES");
                                    } else {
                                        customTable.put("ATTRIB_VALUE", newValue);
                                    }
                                }
                                if (escapedList.size() > 1) {
                                    customTable.put("ATTRIB_VALUE", escapedList);
                                    customTable.put("ATTRIB_VALUE_COUNT", new Long(escapedList.size()));
                                } else if (escapedList.size() == 1) {
                                    customTable.put("ATTRIB_VALUE", escapedList.get(0));
                                }
                            } else if (relationalType == 1 && !attribValue.toString().equals("")) {
                                value = attribValue.toString();
                                ArrayList multiValuesArray = new ArrayList((ArrayList)fcAttribute.getAttribValue());
                                if (multiValuesArray.size() > 1) {
                                    ArrayList<String> list = new ArrayList<String>();
                                    for (Object string : multiValuesArray) {
                                        list.add(string.toString().trim());
                                    }
                                    customTable.put("ATTRIB_VALUE", list);
                                    customTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                                } else if (multiValuesArray.size() == 0) {
                                    attribValue = "";
                                } else {
                                    if (multiValuesArray.size() == 1) {
                                        value = (String)multiValuesArray.get(0);
                                    }
                                    customTable.put("ATTRIB_VALUE", value);
                                }
                            } else {
                                if (ldapVsValueProps != null && attribValue instanceof String) {
                                    attribValue = FcExecuteNamingFormat.getFormatValue(attribValue.toString(), null, ldapVsValueProps);
                                }
                                customTable.put("ATTRIB_VALUE", attribValue);
                            }
                        }
                    }
                    if (attribValue.toString().equals("")) {
                        if (!modifyObject) continue;
                        customTable.put("DW_CONTROL_CODE", 1L);
                        customTable.put("ATTRIB_VALUE", "");
                        customList.add(customTable);
                        continue;
                    }
                    customList.add(customTable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return customList;
    }

    public void generatePermissionDetails(FcLayoutField fcLayoutField, Properties ldapVsValueProps, Integer exchangeType, Hashtable dpValues, String distinguishedName) {
        if (!distinguishedName.equalsIgnoreCase("")) {
            if (fcLayoutField.getComponentId() == 45L) {
                FcProfilePathWithPerm componentObj = (FcProfilePathWithPerm)fcLayoutField.getIComponent();
                String profilePath = componentObj.getValue();
                if (!componentObj.hasEmptyValue() && profilePath.startsWith("\\\\") && componentObj.getCreateProfile()) {
                    Properties permsProp = new Properties();
                    profilePath = FcExecuteNamingFormat.getFormatValue(profilePath, null, ldapVsValueProps);
                    permsProp.put("folderpath", profilePath);
                    permsProp.put("createProfile", (Object)componentObj.getCreateProfile());
                    permsProp.put("createVistaProfile", componentObj.getCreateVistaProfile());
                    permsProp.put("inheritPermissions", (Object)componentObj.getInheritPermissions());
                    permsProp.put("folderPermissions", this.getPermissionList(componentObj.getFolderPermission(), distinguishedName));
                    this.permissionProps.put("profilePath", permsProp);
                }
            } else if (fcLayoutField.getComponentId() == 46L) {
                FcTsProfilePathWithPerm componentObj = (FcTsProfilePathWithPerm)fcLayoutField.getIComponent();
                String tsProfilePath = componentObj.getValue();
                if (!componentObj.hasEmptyValue() && tsProfilePath.startsWith("\\\\") && componentObj.getCreateProfile()) {
                    tsProfilePath = FcExecuteNamingFormat.getFormatValue(tsProfilePath, null, ldapVsValueProps);
                    Properties permsProp = new Properties();
                    permsProp.put("folderpath", tsProfilePath);
                    permsProp.put("createProfile", (Object)componentObj.getCreateProfile());
                    permsProp.put("inheritPermissions", (Object)componentObj.getInheritPermissions());
                    permsProp.put("folderPermissions", this.getPermissionList(componentObj.getFolderPermission(), distinguishedName));
                    this.permissionProps.put("tsProfilePath", permsProp);
                }
            } else if (fcLayoutField.getComponentId() == 47L) {
                FcHomeFolderWithPerm componentObj = (FcHomeFolderWithPerm)fcLayoutField.getIComponent();
                if (!componentObj.hasEmptyValue()) {
                    String localPath = componentObj.getLocalDirPath();
                    String homePath = componentObj.getHomeDirectory();
                    localPath = FcExecuteNamingFormat.getFormatValue(localPath, null, ldapVsValueProps);
                    homePath = FcExecuteNamingFormat.getFormatValue(homePath, null, ldapVsValueProps);
                    String serverName = componentObj.getServerName();
                    String remoteHomeDir = homePath;
                    if (componentObj.getCreateShare() && localPath.indexOf(":") == 1) {
                        String localDriveLetter = localPath.substring(0, 1);
                        localDriveLetter = localDriveLetter.toLowerCase();
                        remoteHomeDir = "\\\\" + serverName + "\\" + localDriveLetter + "$" + localPath.substring(2);
                    }
                    String shareName = homePath.substring(homePath.lastIndexOf("\\") + 1, homePath.length());
                    Properties permsProp = new Properties();
                    permsProp.put("remoteHomeDir", remoteHomeDir);
                    permsProp.put("serverName", serverName);
                    permsProp.put("shareName", shareName);
                    permsProp.put("localPath", localPath);
                    permsProp.put("createShare", (Object)componentObj.getCreateShare());
                    permsProp.put("inheritPermissions", (Object)componentObj.getInheritPermissions());
                    permsProp.put("folderPermissions", this.getPermissionList(componentObj.getFolderPermission(), distinguishedName));
                    permsProp.put("sharePermissions", this.getPermissionList(componentObj.getSharePermission(), distinguishedName));
                    this.permissionProps.put("homeFolder", permsProp);
                }
            } else if (fcLayoutField.getComponentId() == 48L) {
                FcTsHomeFolderWithPerm componentObj = (FcTsHomeFolderWithPerm)fcLayoutField.getIComponent();
                if (!componentObj.hasEmptyValue()) {
                    String localPath = componentObj.getLocalDirPath();
                    String homePath = componentObj.getHomeDirectory();
                    localPath = FcExecuteNamingFormat.getFormatValue(localPath, null, ldapVsValueProps);
                    homePath = FcExecuteNamingFormat.getFormatValue(homePath, null, ldapVsValueProps);
                    String serverName = componentObj.getServerName();
                    String remoteHomeDir = homePath;
                    if (componentObj.getCreateShare() && localPath.indexOf(":") == 1) {
                        String localDriveLetter = localPath.substring(0, 1);
                        localDriveLetter = localDriveLetter.toLowerCase();
                        remoteHomeDir = "\\\\" + serverName + "\\" + localDriveLetter + "$" + localPath.substring(2);
                    }
                    String shareName = homePath.substring(homePath.lastIndexOf("\\") + 1, homePath.length());
                    Properties permsProp = new Properties();
                    permsProp.put("remoteHomeDir", remoteHomeDir);
                    permsProp.put("serverName", serverName);
                    permsProp.put("shareName", shareName);
                    permsProp.put("localPath", localPath);
                    permsProp.put("createShare", (Object)componentObj.getCreateShare());
                    permsProp.put("inheritPermissions", (Object)componentObj.getInheritPermissions());
                    permsProp.put("folderPermissions", this.getPermissionList(componentObj.getFolderPermission(), distinguishedName));
                    permsProp.put("sharePermissions", this.getPermissionList(componentObj.getSharePermission(), distinguishedName));
                    this.permissionProps.put("tsHomeFolder", permsProp);
                }
            } else if (fcLayoutField.getComponentId() == 49L) {
                Hashtable allPermissions;
                ArrayList mailboxDefaultPerms;
                FcMailBoxStoreWithPerm componentObj = (FcMailBoxStoreWithPerm)fcLayoutField.getIComponent();
                Properties permsProp = new Properties();
                ArrayList mailBoxPermissionList = componentObj.getFolderPermission();
                if (exchangeType != null && exchangeType == 2003 && (mailboxDefaultPerms = (ArrayList)(allPermissions = (Hashtable)dpValues.get("defaultPermissions")).get("MBR_ACL")) != null) {
                    for (int index = 0; index < mailboxDefaultPerms.size(); ++index) {
                        String appliesToStr;
                        long appliesToVal;
                        String accessMaskStr;
                        long accessMaskVal;
                        String objectName;
                        String objectDN;
                        String aceTypeStr;
                        Properties permissionProp = (Properties)mailboxDefaultPerms.get(index);
                        long aceTypeVal = (Long)permissionProp.get("ACE_TYPE");
                        FcPermission permissionObj = new FcPermission(aceTypeVal, aceTypeStr = (String)permissionProp.get("ACE_TYPE_STRING"), objectDN = (String)permissionProp.get("DN"), objectName = (String)permissionProp.get("OBJECT_NAME"), accessMaskVal = ((Long)permissionProp.get("ACCESS_MASK")).longValue(), accessMaskStr = (String)permissionProp.get("ACCESS_MASK_STRING"), appliesToVal = ((Long)permissionProp.get("INHERIT_TYPE_FLAG")).longValue(), appliesToStr = (String)permissionProp.get("APPLIES_TO_STRING"), false);
                        if (mailBoxPermissionList.contains(permissionObj)) continue;
                        mailBoxPermissionList.add(permissionObj);
                    }
                }
                permsProp.put("folderPermissions", this.getPermissionList(mailBoxPermissionList, distinguishedName));
                this.permissionProps.put("mailBox", permsProp);
            }
        }
    }

    public ArrayList<Properties> getPermissionList(ArrayList<FcPermission> permissionList, String distinguishedName) {
        ArrayList<Properties> returnList = new ArrayList<Properties>();
        for (int index = 0; index < permissionList.size(); ++index) {
            FcPermission permission = permissionList.get(index);
            Properties properties = permission.getPermissionProperties();
            String objectDN = properties.getProperty("DN");
            objectDN = objectDN.equalsIgnoreCase("%userName%") ? distinguishedName : CommonUtil.escapeDN((String)objectDN);
            properties.put("DN", objectDN);
            returnList.add(properties);
        }
        return returnList;
    }

    public void updateModifiedFieldValuesinDB(Long templateCategoryId) {
        try {
            for (int i = 0; i < this.toBeUpdatedInDB.size(); ++i) {
                Hashtable hash = (Hashtable)this.toBeUpdatedInDB.get(i);
                FcAttributes fcAttr = (FcAttributes)hash.get("attr");
                Object newValue = hash.get("value");
                if (fcAttr.getRelationalType().compareTo(new Integer(1)) == 0) {
                    ArrayList list;
                    if (fcAttr.getAttribLdapName().equalsIgnoreCase("proxyAddresses") || fcAttr.getAttribLdapName().equalsIgnoreCase("waadproxyaddresses")) {
                        list = (ArrayList)newValue;
                        if (hash.get("isCustom") != null) {
                            FcLayoutUpdateHandler.updateBulkMgmtMultiValueFieldEntry((Long)this.objectIndexId, (String)FcLayoutUtil.getFcBulkCustomAttrTableName((Long)templateCategoryId), (String)"CUSTOM_ATTRIB_VALUE", (ArrayList)list);
                            continue;
                        }
                        FcLayoutUpdateHandler.updateBulkMgmtMultiValueFieldEntry((Long)this.objectIndexId, (String)fcAttr.getBulkLayoutTableName(), (String)fcAttr.getAttribColumnName(), (ArrayList)list);
                        continue;
                    }
                    if (fcAttr.getAttribLdapName().equalsIgnoreCase("customScriptDetails")) {
                        list = (ArrayList)newValue;
                        FcLayoutUpdateHandler.updateBulkMgmtMultiValueFieldEntry((Long)this.objectIndexId, (String)fcAttr.getBulkLayoutTableName(), (String)"SCRIPT_COMMAND", (ArrayList)list);
                        continue;
                    }
                    if (!fcAttr.getAttribLdapName().equalsIgnoreCase("msExchUMMailBoxPolicy")) continue;
                    list = (ArrayList)newValue;
                    if (list.size() > 0) {
                        String valueToUpdate = (String)list.get(0);
                        String sipType = (String)list.get(1);
                        if (sipType.equals("SIP")) {
                            FcLayoutUpdateHandler.updateBulkMgmtMultiValueFieldEntry((Long)this.objectIndexId, (String)fcAttr.getBulkLayoutTableName(), (String)"SIP_ADDRESS", (ArrayList)list);
                            continue;
                        }
                        FcLayoutUpdateHandler.updateBulkMgmtMultiValueFieldEntry((Long)this.objectIndexId, (String)fcAttr.getBulkLayoutTableName(), (String)"EUM_ADDRESS", (ArrayList)list);
                        continue;
                    }
                    list.add("");
                    FcLayoutUpdateHandler.updateBulkMgmtMultiValueFieldEntry((Long)this.objectIndexId, (String)fcAttr.getBulkLayoutTableName(), (String)"POLICY_NAME", (ArrayList)list);
                    continue;
                }
                if (fcAttr.getAttribLdapName().equalsIgnoreCase("proxyAddresses") && hash.get("isCustom") != null) {
                    ArrayList customValue = new ArrayList();
                    customValue.add(newValue);
                    FcLayoutUpdateHandler.updateBulkMgmtMultiValueFieldEntry((Long)this.objectIndexId, (String)FcLayoutUtil.getFcBulkCustomAttrTableName((Long)templateCategoryId), (String)"CUSTOM_ATTRIB_VALUE", customValue);
                    continue;
                }
                FcLayoutUpdateHandler.updateBulkMgmtFieldEntry((Long)this.objectIndexId, (Long)templateCategoryId, (String)fcAttr.getAttribColumnName(), (String)((String)newValue));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList<String> getSendAsList(String distinguishedName) {
        ArrayList<String> resultSIDList = new ArrayList<String>();
        try {
            ArrayList aceList;
            Properties aclProp = ADHandler.getACLsFromDNWithoutLookup((String)this.domainName, (Long)this.loginId, (String)distinguishedName);
            if (aclProp != null && (aceList = (ArrayList)aclProp.get("acls")) != null && !aceList.isEmpty()) {
                for (int index = 0; index < aceList.size(); ++index) {
                    String trusteeSid;
                    Properties aceProps = (Properties)aceList.get(index);
                    String objectTypeGUID = (String)aceProps.get("objectTypeGUID");
                    if (!"{AB721A54-1E2F-11D0-9819-00AA0040529B}".equalsIgnoreCase(objectTypeGUID) || "S-1-5-10".equalsIgnoreCase(trusteeSid = (String)aceProps.get("sid"))) continue;
                    resultSIDList.add(trusteeSid);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultSIDList;
    }

    public Hashtable updateSendAsAttribute(ArrayList SIDList, String distinguishedName, String operation) {
        ArrayList nativeResult = new ArrayList();
        Hashtable resultSendAs = new Hashtable();
        try {
            ArrayList aceList = new ArrayList();
            Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
            aceHash.put("ACCESS_MASK", 256L);
            aceHash.put("PERMISSION_GUID", "{ab721a54-1e2f-11d0-9819-00aa0040529b}");
            aceHash.put("INHERIT_TYPE_FLAG", new Long(2L));
            aceHash.put("ACE_ID", new Long(1L));
            aceHash.put("ACE_TYPE", 5L);
            aceHash.put("operation", operation);
            aceList.add(aceHash);
            nativeResult = ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, (ArrayList)SIDList, (String)distinguishedName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < nativeResult.size(); ++i) {
            Hashtable resultProp = (Hashtable)nativeResult.get(i);
            resultSendAs.put(SIDList.get(i), resultProp.get(new Long(1L)));
        }
        return resultSendAs;
    }

    public String getErrorStringForSendAs(Hashtable resultHash, String prevErrorMsg) {
        String resultString = "";
        ArrayList<String> errorList = new ArrayList<String>();
        Enumeration itr = resultHash.keys();
        while (itr.hasMoreElements()) {
            String sID = (String)itr.nextElement();
            Integer resultCode = Integer.parseInt((String)resultHash.get(sID));
            String errorString = TemplateAction.getErrorCodeString(resultCode);
            if (resultCode == 0) continue;
            if (!errorList.contains(errorString)) {
                errorList.add(errorString);
            }
            mgmtLog.log(Level.INFO, "Error while trying to update sendAs Attribute for : " + sID + " - " + this.rb.getString(errorString));
        }
        if (!errorList.isEmpty()) {
            resultString = prevErrorMsg.equals("") ? this.rb.getString("admp.ad_mgmt.create_user.error_send_as") : prevErrorMsg;
            for (int i = 0; i < errorList.size(); ++i) {
                resultString = i == 0 && prevErrorMsg.equals("") ? resultString + this.rb.getString((String)errorList.get(i)) : resultString + ", " + this.rb.getString((String)errorList.get(i));
            }
        }
        return resultString;
    }

    private String getLegacyExchangeDN(String userName, String mailAlias, Integer exchangeType) {
        String legacyDN = mailAlias;
        if (exchangeType >= 2013) {
            legacyDN = UUID.randomUUID().toString().replaceAll("-", "") + "-" + userName;
        } else if (exchangeType >= 2010) {
            legacyDN = userName + UUID.randomUUID().toString().substring(0, 8);
        } else if (exchangeType >= 2007) {
            // empty if block
        }
        return legacyDN;
    }

    private void fillMembersValue(FcAttributes fcAttribute, ArrayList members, Long dwCode) {
        if (members.size() == 1) {
            fcAttribute.setAttributeValue((Object)((String)members.get(0)));
        } else {
            fcAttribute.setAttributeValue((Object)members);
        }
        fcAttribute.setDWControlCode(dwCode);
        fcAttribute.setAttributeValueCount((Object)members.size());
    }

    protected void updateManagerCanUpdateMembers(String managerDN, String groupDN, String operation) throws Exception {
        ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
        String sid = UserMgmtUtil.getSIDFromDN((String)this.domainName, (String)managerDN);
        if (sid != null) {
            everyOneTrusteeList.add(sid);
            ArrayList aceList = new ArrayList();
            Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
            aceHash.put("ACCESS_MASK", 32L);
            aceHash.put("PERMISSION_GUID", "{BF9679C0-0DE6-11D0-A285-00AA003049E2}");
            aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
            aceHash.put("ACE_ID", new Long(1L));
            aceHash.put("ACE_TYPE", 5L);
            aceHash.put("operation", operation);
            aceList.add(aceHash);
            ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)groupDN);
        }
    }

    public ArrayList setFullPermissionToNative(ArrayList fullPermissionList, boolean allowAccess) {
        ArrayList<Properties> fullPermissionToNative = new ArrayList<Properties>();
        for (int i = 0; i < fullPermissionList.size(); ++i) {
            Properties prop = new Properties();
            prop.put("DN", fullPermissionList.get(i));
            prop.put("ACCESS_MASK", (Object)1L);
            prop.put("INHERIT_TYPE_FLAG", (Object)0L);
            prop.put("ACE_TYPE", (Object)(allowAccess ? 0L : 1L));
            fullPermissionToNative.add(prop);
        }
        return fullPermissionToNative;
    }

    public Hashtable addCrossForestMembers(String distinguishedName, Properties nativeStatusProps) {
        Hashtable errHash = null;
        try {
            NativeError errHandler = ADHandler.addCrossForestMembers((String)this.domainName, (Long)this.loginId, (String)distinguishedName, (ArrayList)this.crossForestMembersList);
            errHash = this.getCrossForestErrorHash(errHandler, distinguishedName);
            if (errHash != null) {
                nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
                messageList = (ArrayList<Hashtable>)nativeStatusProps.get("CREATION_MESSAGE");
                if (messageList == null) {
                    messageList = new ArrayList<Hashtable>();
                }
                messageList.add(errHash);
                nativeStatusProps.put("CREATION_MESSAGE", messageList);
                nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errHash;
    }

    public Hashtable getCrossForestErrorHash(NativeError errHandler, String key) {
        ArrayList errList;
        Hashtable errHash = null;
        Hashtable error = errHandler.getErrors();
        if (error != null && (errList = (ArrayList)error.get(key)) != null && errList.size() > 0) {
            errHash = (Hashtable)errList.get(0);
        }
        return errHash;
    }

    protected boolean isFieldModified(String ldapName, FcFormDataContainer modifiedFieldsContainer) {
        try {
            if (modifiedFieldsContainer == null) {
                return false;
            }
            Enumeration e = modifiedFieldsContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                for (FcAttributes fcAttribute : fcLayoutField.getFcAttributeList()) {
                    if (!fcAttribute.getAttribLdapName().equalsIgnoreCase(ldapName)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void getADValue(String guid, String domainName, Long loginId, ArrayList ldapList) {
        try {
            Properties valueList = FcExecuteFormFlow.getObjectProperties(guid, domainName, loginId, ldapList);
            this.fillMandatoryFields(valueList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable loadMemberOfData(ArrayList memberOfGroupList) {
        String[] columns = new String[]{"DOMAIN_NAME", "OBJECT_GUID", "DISTINGUISHED_NAME", "GROUPTYPE", "GROUP_NAME"};
        Hashtable authGroupsDetails = new Hashtable();
        String tempTableName = "";
        File tempFile = null;
        try {
            QueryGenerator qGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
            DataObject groupDetails = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long time = System.currentTimeMillis();
            List<String> columnsList = Arrays.asList(columns);
            tempTableName = QueueUtil.createTempTableWithID((String)"ADSMGroupGeneralDetails", (Long)time, columnsList);
            String dirName = System.getProperty("server.home") + File.separator + "temp" + File.separator;
            StringBuilder sb = new StringBuilder();
            sb.append("TEMP_ID" + time.toString());
            for (int i = 0; i < columnsList.size(); ++i) {
                sb.append(",");
                sb.append(columnsList.get(i));
            }
            String columnOrder = sb.toString();
            FileOutputStream fStream = new FileOutputStream(dirName + "" + tempTableName + ".txt", false);
            OutputStreamWriter oStreamWriter = new OutputStreamWriter((OutputStream)fStream, QueueUtil.getFileEncoding());
            PrintWriter writer = new PrintWriter((Writer)oStreamWriter, false);
            for (int i = 0; i < memberOfGroupList.size(); ++i) {
                String dN = (String)memberOfGroupList.get(i);
                String rowString = qGen.getEscapedString((Object)i);
                for (int j = 0; j < columnsList.size(); ++j) {
                    rowString = columnsList.get(j).equalsIgnoreCase("DISTINGUISHED_NAME") ? rowString + qGen.getFieldDelimiter() + qGen.getEscapedString((Object)dN) : rowString + qGen.getFieldDelimiter() + qGen.getDBNullValue();
                }
                writer.println(rowString);
            }
            writer.close();
            tempFile = new File(dirName + "" + tempTableName + ".txt");
            dirName = tempFile.getCanonicalPath();
            dirName = dirName.replace('\\', '/');
            String sql = qGen.loadDataQuery(tempTableName, columnOrder, dirName, qGen.getFieldDelimiter(), "\r\n", "\"", null);
            FcLayoutUtil.updateGroupDetails((String)tempTableName, (String)"DISTINGUISHED_NAME", null, (boolean)false, columnsList);
            Criteria cri = GroupHandler.getOUCriteria((String)this.domainName, (Long)this.loginId, (String)"domain", (String)tempTableName);
            groupDetails = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tempTableName, cri);
            authGroupsDetails = GroupHandler.groupDOtoHashTable((DataObject)groupDetails, (String)tempTableName, (String)"DISTINGUISHED_NAME", (String[])columns);
        }
        catch (Exception e) {
            mgmtLog.log(Level.INFO, "Exception while getting memberOf data by file write process... Using In Operation.");
            e.printStackTrace();
            authGroupsDetails = GroupHandler.getGroupsPropFromDN((String)this.domainName, (Long)this.loginId, (ArrayList)memberOfGroupList, (String)"domain", (String[])columns);
        }
        finally {
            if (tempTableName != null && !tempTableName.isEmpty()) {
                QueueUtil.dropTempTable((String)tempTableName);
                tempFile.delete();
            }
        }
        return authGroupsDetails;
    }

    private void checkForDuplicates(FcFormDataContainer fromClientData, Properties ldapVsValueProps, Hashtable dpValues, String ouName, Properties domainDetails, ArrayList duplicateProxyAddressList, String objectClass) {
        Enumeration fieldIdsEnum = fromClientData.keys();
        ArrayList sortedFieldIds = Collections.list(fieldIdsEnum);
        Collections.sort(sortedFieldIds);
        ArrayList<Long> fcNamingFormatFields = FcExecuteFormFlow.getNamingFormatFields(fromClientData);
        int namingFormatFieldCount = sortedFieldIds.size();
        for (int ind1 = 0; ind1 < namingFormatFieldCount; ++ind1) {
            FcLayoutField fcLayoutField = (FcLayoutField)fromClientData.get(sortedFieldIds.get(ind1));
            Integer iamAppId = fcLayoutField.getIamAppId();
            if (iamAppId != null && iamAppId.intValue() != FcLayoutConstants.ACTIVE_DIRECTORY_APPID.intValue()) continue;
            ArrayList fcAttributeList = fcLayoutField.getFcAttributeList();
            for (FcAttributes fcAttribute : fcAttributeList) {
                String attribToDisplay;
                String attributeName = fcAttribute.getAttribLdapName();
                Object attribValue = fcAttribute.getAttribValue();
                if (attribValue == null || !fcLayoutField.getIsAvoidDuplication().booleanValue() || this.getIsWorkFlowMode()) continue;
                this.isAvoidDuplicationApplied = true;
                Hashtable newAttribHash = FcExecuteFormFlow.getNewValueToAvoidDuplication(fcLayoutField, fcAttribute, ldapVsValueProps, ouName, domainDetails, duplicateProxyAddressList, objectClass);
                this.stopExecution = (Boolean)newAttribHash.get("stopExecution");
                Object newAttribValue = newAttribHash.get("newAttributeValue");
                if (newAttribValue != null && !attribValue.toString().equalsIgnoreCase(newAttribValue.toString())) {
                    mgmtLog.log(Level.FINE, "Duplicate attribute value check: User data " + attribValue + " newAttributeValue " + newAttribValue + " for the LdapField " + attributeName);
                    if (this.userData == null) {
                        this.userData = FcBulkExecuteFormFlow.getSingleObjUserDataContainer(this.objectIndexId, FcExecuteActionConstants.userCreationTemplateCategoryId, this.domainName, this.loginId, this.rb, dpValues);
                    }
                    fcNamingFormatFields.remove(fcLayoutField.getFieldId());
                    if (ldapVsValueProps.get("sAMAccountName") != null) {
                        ldapVsValueProps.setProperty("userName", ldapVsValueProps.getProperty("sAMAccountName"));
                        ldapVsValueProps.setProperty("username", ldapVsValueProps.getProperty("sAMAccountName"));
                        ldapVsValueProps.setProperty("LogonName", ldapVsValueProps.getProperty("sAMAccountName"));
                        ldapVsValueProps.setProperty("logonName", ldapVsValueProps.getProperty("sAMAccountName"));
                    }
                    ArrayList<Hashtable> updatedFcAttributes = FcExecuteFormFlow.applyNamingFormatAndUpdateFcAttributes(ldapVsValueProps, fcNamingFormatFields, fromClientData, this.userData);
                    if (ldapVsValueProps.get("sAMAccountName") != null) {
                        ldapVsValueProps.setProperty("userName", ldapVsValueProps.getProperty("sAMAccountName"));
                        ldapVsValueProps.setProperty("username", ldapVsValueProps.getProperty("sAMAccountName"));
                        ldapVsValueProps.setProperty("LogonName", ldapVsValueProps.getProperty("sAMAccountName"));
                        ldapVsValueProps.setProperty("logonName", ldapVsValueProps.getProperty("sAMAccountName"));
                    }
                    if (!fcAttribute.getAttribLdapName().equalsIgnoreCase("upn")) {
                        Hashtable<String, Object> hash = new Hashtable<String, Object>();
                        hash.put("attr", fcAttribute);
                        hash.put("value", newAttribValue);
                        this.toBeUpdatedInDB.add(hash);
                        this.toBeUpdatedInDB.addAll(updatedFcAttributes);
                        fcAttribute.setAttributeValue(newAttribValue);
                    }
                }
                if (!this.stopExecution) continue;
                this.duplicatedAttribute = fcAttributeList.size() > 1 ? attributeName : ((attribToDisplay = fcLayoutField.getAttribDisplayText()) != null || attribToDisplay.length() >= 0 ? attribToDisplay : attributeName);
                System.out.println("Duplication occurred for the attribute '" + this.duplicatedAttribute + "'. Hence, Execution is stopped");
                return;
            }
        }
    }

    public void triggerNotifiation(Long auditId, Long auditObjectId, String name, String manager, String password, Integer objectId, Integer reportId, String domainName, AdventNetResourceBundle rb) {
        this.triggerNotifiation(auditId, auditObjectId, name, manager, password, objectId, reportId, domainName, rb, null);
    }

    public void triggerNotifiation(Long auditId, Long auditObjectId, String name, String manager, String password, Integer objectId, Integer reportId, String domainName, AdventNetResourceBundle rb, ArrayList objectOUList) {
        MgmtNotificationListener notifyListener = new MgmtNotificationListener();
        Hashtable nameVsDetails = new Hashtable();
        Hashtable<String, String> managerAndPwd = new Hashtable<String, String>();
        if (manager != null && !manager.equals("")) {
            managerAndPwd.put("manager", manager);
        }
        if (password != null && !password.equals("")) {
            managerAndPwd.put("password", password);
        }
        if (name != null && !name.equals("")) {
            nameVsDetails.put(name, managerAndPwd);
        }
        ArrayList<Long> auditIdList = new ArrayList<Long>();
        auditIdList.add(auditId);
        ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
        auditObjectIdList.add(auditObjectId);
        notifyListener.triggerNotification(auditIdList, auditObjectIdList, objectId, nameVsDetails, this.loginId, reportId, domainName, rb, this.getViewColumnList(this.viewId), this.wfRequestId, objectOUList);
    }

    private ArrayList getViewColumnList(Long viewId) {
        ArrayList columnList = null;
        try {
            if (viewId.equals(FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID) || viewId.equals(FcExecuteActionConstants.BCC_LAYOUT_VIEW_ID)) {
                columnList = ColumnConfiguration.getColumnList((long)viewId, (int)2);
            } else if (viewId.equals(FcExecuteActionConstants.BCPC_LAYOUT_VIEW_ID)) {
                columnList = new ArrayList();
                HashMap<String, String> attributeProp1 = new HashMap<String, String>();
                attributeProp1.put("COLUMN_NAME", "admp.common.attrib_disp_name.full_name");
                attributeProp1.put("COL_NAME", "FULL_NAME");
                columnList.add(attributeProp1);
                HashMap<String, String> attributeProp2 = new HashMap<String, String>();
                attributeProp2.put("COLUMN_NAME", "admp.common.attrib_disp_name.desc");
                attributeProp2.put("COL_NAME", "DESCRIPTION");
                columnList.add(attributeProp2);
                HashMap<String, String> attributeProp3 = new HashMap<String, String>();
                attributeProp3.put("COLUMN_NAME", "admp.common.attrib_disp_name.manager");
                attributeProp3.put("COL_NAME", "MANAGER");
                columnList.add(attributeProp3);
            } else if (viewId.equals(FcExecuteActionConstants.BOC_LAYOUT_VIEW_ID)) {
                columnList = new ArrayList();
                HashMap<String, String> attributeProp1 = new HashMap<String, String>();
                attributeProp1.put("COLUMN_NAME", this.rb.getString("admp.common.attrib_disp_name.name"));
                attributeProp1.put("COL_NAME", "NAME");
                columnList.add(attributeProp1);
                HashMap<String, String> attributeProp2 = new HashMap<String, String>();
                attributeProp2.put("COLUMN_NAME", this.rb.getString("admp.common.attrib_disp_name.desc"));
                attributeProp2.put("COL_NAME", "DESCRIPTION");
                columnList.add(attributeProp2);
                HashMap<String, String> attributeProp3 = new HashMap<String, String>();
                attributeProp3.put("COLUMN_NAME", this.rb.getString("admp.common.attrib_disp_name.managed_by"));
                attributeProp3.put("COL_NAME", "MANAGED_BY");
                columnList.add(attributeProp3);
            } else if (viewId.equals(FcExecuteActionConstants.BGC_LAYOUT_VIEW_ID)) {
                columnList = new ArrayList();
                HashMap<String, String> attributeProp1 = new HashMap<String, String>();
                attributeProp1.put("COLUMN_NAME", "admp.common.attrib_disp_name.group_name");
                attributeProp1.put("COL_NAME", "DISPLAY_NAME");
                columnList.add(attributeProp1);
                HashMap<String, String> attributeProp2 = new HashMap<String, String>();
                attributeProp2.put("COLUMN_NAME", "admp.common.attrib_disp_name.group_type");
                attributeProp2.put("COL_NAME", "GROUP_TYPE");
                columnList.add(attributeProp2);
                HashMap<String, String> attributeProp3 = new HashMap<String, String>();
                attributeProp3.put("COLUMN_NAME", "admp.common.attrib_disp_name.group_scope");
                attributeProp3.put("COL_NAME", "GROUP_SCOPE");
                columnList.add(attributeProp3);
            } else if (viewId.equals(FcExecuteActionConstants.SMB_LAYOUT_VIEW_ID)) {
                columnList = new ArrayList();
                HashMap<String, String> attributeProp1 = new HashMap<String, String>();
                attributeProp1.put("COLUMN_NAME", "admp.common.attrib_disp_name.full_name");
                attributeProp1.put("COL_NAME", "FULL_NAME");
                columnList.add(attributeProp1);
                HashMap<String, String> attributeProp2 = new HashMap<String, String>();
                attributeProp2.put("COLUMN_NAME", "admp.common.attrib_disp_name.simple_display_name");
                attributeProp2.put("COL_NAME", "DESCRIPTION");
                columnList.add(attributeProp2);
                HashMap<String, String> attributeProp3 = new HashMap<String, String>();
                attributeProp3.put("COLUMN_NAME", "admp.common.attrib_disp_name.mail_alias");
                attributeProp3.put("COL_NAME", "MAIL_ALIAS");
                HashMap<String, String> attributeProp4 = new HashMap<String, String>();
                attributeProp4.put("COLUMN_NAME", "admp.common.attrib_disp_name.e_mail_address");
                attributeProp4.put("COL_NAME", "EMAIL_ADDRESS");
                columnList.add(attributeProp3);
            } else if (viewId.equals(FcExecuteActionConstants.RMB_LAYOUT_VIEW_ID)) {
                columnList = new ArrayList();
                HashMap<String, String> attributeProp1 = new HashMap<String, String>();
                attributeProp1.put("COLUMN_NAME", "admp.common.attrib_disp_name.full_name");
                attributeProp1.put("COL_NAME", "FULL_NAME");
                columnList.add(attributeProp1);
                HashMap<String, String> attributeProp2 = new HashMap<String, String>();
                attributeProp2.put("COLUMN_NAME", "admp.common.attrib_disp_name.simple_display_name");
                attributeProp2.put("COL_NAME", "DESCRIPTION");
                columnList.add(attributeProp2);
                HashMap<String, String> attributeProp3 = new HashMap<String, String>();
                attributeProp3.put("COLUMN_NAME", "admp.common.attrib_disp_name.mail_alias");
                attributeProp3.put("COL_NAME", "MAIL_ALIAS");
                HashMap<String, String> attributeProp4 = new HashMap<String, String>();
                attributeProp4.put("COLUMN_NAME", "admp.common.attrib_disp_name.e_mail_address");
                attributeProp4.put("COL_NAME", "EMAIL_ADDRESS");
                columnList.add(attributeProp3);
            } else if (viewId.equals(FcExecuteActionConstants.LMB_LAYOUT_VIEW_ID)) {
                columnList = new ArrayList();
                HashMap<String, String> attributeProp1 = new HashMap<String, String>();
                attributeProp1.put("COLUMN_NAME", "admp.common.attrib_disp_name.full_name");
                attributeProp1.put("COL_NAME", "FULL_NAME");
                columnList.add(attributeProp1);
                HashMap<String, String> attributeProp2 = new HashMap<String, String>();
                attributeProp2.put("COLUMN_NAME", "admp.common.attrib_disp_name.simple_display_name");
                attributeProp2.put("COL_NAME", "DESCRIPTION");
                columnList.add(attributeProp2);
                HashMap<String, String> attributeProp3 = new HashMap<String, String>();
                attributeProp3.put("COLUMN_NAME", "admp.common.attrib_disp_name.mail_alias");
                attributeProp3.put("COL_NAME", "MAIL_ALIAS");
                HashMap<String, String> attributeProp4 = new HashMap<String, String>();
                attributeProp4.put("COLUMN_NAME", "admp.common.attrib_disp_name.e_mail_address");
                attributeProp4.put("COL_NAME", "EMAIL_ADDRESS");
                columnList.add(attributeProp3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    protected String getValidDCForLyncOperations(String domainName, Long loginId, String ouName) {
        String dcFqdn = ADHandler.getValidDcFQDN((String)domainName, (long)loginId, (String)ouName);
        try {
            if (dcFqdn == null || dcFqdn.trim().length() == 0) {
                Properties domainDetails = ADHandler.getDomainDetails((String)domainName, (Long)loginId, (String)ouName);
                ArrayList domainControllersList = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
                dcFqdn = (String)domainControllersList.get(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            dcFqdn = "";
        }
        return dcFqdn;
    }

    public String getStringFromMaskIDs(String maskID) {
        switch (maskID) {
            case "65536": {
                return "Delete Mailbox";
            }
            case "131072": {
                return "Read Permissions";
            }
            case "524288": {
                return "Take Ownership";
            }
            case "262144": {
                return "Change Permissions";
            }
        }
        return "Full Mailbox Access";
    }
}

