/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcComputerMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class FcComputerCreationListener
extends FcADMgmtListener {
    String userName = null;
    String ouName = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    ArrayList<Hashtable> customList;
    String customScriptResult = "";

    public FcComputerCreationListener() {
        this.defaultGroupRID = "515";
        this.objectType = "computer";
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.loginId = loginId;
        this.createComputer();
    }

    public void createComputer() {
        try {
            mgmtLog.log(Level.INFO, " FcComputerCreation Started ");
            FcComputerMgmtHandler.getInstance().updateFieldsTableName(this.fromClientData);
            FcComputerMgmtHandler.getInstance().initDataObjForFieldsToAttributes();
            FcComputerMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcComputerMgmtHandler.getInstance().updateFieldsActionId(this.fromClientData);
            FcComputerMgmtHandler.getInstance().updateDefaultComponentId(this.fromClientData);
            FcComputerMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            FcNativeProperties fcNativeProperties = this.fcNativeProperties;
            this.customList = this.updateCustomAttributeProperties(this.fromClientData);
            this.addAttributeToNativeProps(this.fromClientData, fcNativeProperties);
            Properties props = fcNativeProperties.getProps();
            this.userName = props.getProperty("userName");
            this.ouName = props.getProperty("OUName");
            if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)this.ouName)) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                return;
            }
            ArrayList groupList = fcNativeProperties.getGroupList();
            String CREATION_STATUS = "";
            String escapedUserName = CommonUtil.escapeString((String)this.userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            mgmtLog.log(Level.INFO, " Computer Creation : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " OU Name :" + this.ouName);
            mgmtLog.log(Level.INFO, " User Name :" + this.userName);
            mgmtLog.log(Level.INFO, " getPropsList " + fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " modifyList " + fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " GroupsList " + groupList);
            this.auditLogProps.put("domainName", this.domainName);
            this.auditLogProps.put("userName", this.userName);
            this.auditLogProps.put("propList", fcNativeProperties.getPropList());
            this.auditLogProps.put("modifyList", fcNativeProperties.getModifyList());
            this.auditLogProps.put("groupList", groupList);
            if (props.get("customScriptDetails") != null) {
                this.auditLogProps.put("CustomScriptDetails", (Properties)props.get("customScriptDetails"));
            }
            if (props.get("preventDeletion") != null) {
                this.auditLogProps.put("preventDeletion", (String)props.get("preventDeletion"));
            }
            String computerName = "";
            if (props.get("userName") != null) {
                computerName = props.getProperty("userName");
            }
            String samAccountName = "";
            samAccountName = props.get("samAccountName") != null ? props.getProperty("samAccountName") : computerName;
            if (samAccountName.length() > 15) {
                samAccountName = samAccountName.substring(0, 15);
            }
            if (!samAccountName.endsWith("$")) {
                samAccountName = samAccountName.concat("$");
            }
            String password = computerName.toLowerCase();
            ArrayList propList = fcNativeProperties.getPropList();
            ArrayList modPropList = (ArrayList)propList.clone();
            for (int i = 0; i < modPropList.size(); ++i) {
                Hashtable details = (Hashtable)modPropList.get(i);
                Integer attribId = (Integer)details.get("ATTRIB_ID");
                if (!attribId.equals(3032)) continue;
                modPropList.remove(i);
            }
            boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"computerMgmt");
            if (isLicenseExceeded) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.bulk_creation.common.statmsg.could_not_upd_more_than_100_lic_level_exceed"));
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            this.statusObject = ADHandler.addComputer((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)computerName, (String)samAccountName, (String)password, (ArrayList)modPropList, new ArrayList(), (ArrayList)groupList);
            this.nativeStatusProps = this.getBulkUserErrorMessage(computerName);
            CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            String searchString = "(&(objectClass=computer)(objectCategory=computer)(name=" + computerName + "))";
            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE") && !this.customList.isEmpty()) {
                NativeError customError = ADHandler.searchAndModifyComputer((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, this.customList, new ArrayList(), (boolean)false);
                if (!this.isBulkMgmt) {
                    AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                } else {
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)customError, (String)searchString);
                }
            }
            if (CREATION_STATUS != null && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                Properties customScriptProps;
                String distinguishedName = "CN=" + computerName + "," + this.ouName;
                boolean isDomainUserAMember = false;
                boolean isDomainUserPrimaryGrp = false;
                if (props.get("domainUsersGroupAvailable") != null) {
                    isDomainUserAMember = (Boolean)props.get("domainUsersGroupAvailable");
                }
                if (props.get("isDomainUsersPrimaryGroup") != null) {
                    isDomainUserPrimaryGrp = (Boolean)props.get("isDomainUsersPrimaryGroup");
                }
                if (!isDomainUserAMember && !isDomainUserPrimaryGrp && props.get("domainUserGroupSid") != null) {
                    ArrayList<Properties> list = new ArrayList<Properties>();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", distinguishedName);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(4L));
                    list.add(p);
                    ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)((String)props.get("domainUserGroupSid")), (String)distinguishedName, list, null);
                }
                if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                    boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                    if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                        this.customScriptResult = this.customScriptExecution(customScriptProps);
                    }
                }
            }
            mgmtLog.log(Level.SEVERE, "Create Computer Error Message properties are " + this.nativeStatusProps);
            CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!CREATION_STATUS.equals("SEVERE") && props.get("preventDeletion") != null) {
                String preventDeletion = (String)props.get("preventDeletion");
                if (preventDeletion.equalsIgnoreCase("true")) {
                    this.updatePreventDeletion("CN=" + this.userName + "," + this.ouName, "add");
                    String defaultNamingcontext = DomainUtil.getDefaultNamingContext((String)this.domainName);
                    if (!this.ouName.equalsIgnoreCase(defaultNamingcontext)) {
                        this.updateParent(this.ouName);
                    }
                }
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                grpList.put("ATTRIB_VALUE", (String)props.get("preventDeletion"));
                propList.add(grpList);
            }
            mgmtLog.log(Level.INFO, " FcComputerCreation Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void addAttributeToNativeProps(FcFormDataContainer fromClientData, FcNativeProperties fcNativeProperties) throws Exception {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcComputerMgmtHandler.getInstance().getLdapVsValues(fromClientData, prop);
        this.getProperties(false, fromClientData, fcNativeProperties, ldapVsValueProps, "computer");
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("userName", (Object)this.userName);
        request.setAttribute("customScriptResult", (Object)this.customScriptResult);
        try {
            Properties grpList;
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"Computer"}, (boolean)false);
            }
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)2010, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.userName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList propList = this.fcNativeProperties.getPropList();
            Properties props = this.fcNativeProperties.getProps();
            ArrayList groupList = this.fcNativeProperties.getGroupList();
            if (props.get("customScriptDetails") != null) {
                grpList = new Properties();
                Properties customscript = (Properties)props.get("customScriptDetails");
                grpList.put("ATTRIB_LDAP_NAME", "Custom Script");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)1L);
                grpList.put("ATTRIB_VALUE", (String)((Hashtable)customscript).get("SCRIPT_COMMAND"));
                propList.add(grpList);
            }
            if (props.get("domainUsersGroupAvailable") != null || props.get("isDomainUsersPrimaryGroup") != null) {
                if (this.defaultGroupProps == null) {
                    this.defaultGroupProps = GroupHandler.getDefaultGroupProps((String)this.objectType, (String)this.domainName, (Long)DelegationUtil.ADMIN_LOGIN_ID);
                }
                if (this.defaultGroupProps != null) {
                    groupList.add(this.defaultGroupProps.getProperty("DISTINGUISHED_NAME"));
                }
            }
            if (groupList != null && !groupList.isEmpty()) {
                grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", groupList);
                propList.add(grpList);
            }
            Properties ouProp = new Properties();
            ouProp.put("ATTRIB_LDAP_NAME", "ouName");
            ouProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
            ouProp.put("ATTRIB_VALUE", this.ouName);
            propList.add(ouProp);
            ArrayList<String> objectOUList = new ArrayList<String>();
            objectOUList.add(this.ouName);
            for (int ijk = 0; ijk < this.customList.size(); ++ijk) {
                Hashtable customHash = this.customList.get(ijk);
                Properties customProp = new Properties();
                customProp.put("ATTRIB_LDAP_NAME", customHash.get("ATTRIB_LDAP_NAME"));
                customProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                customProp.put("ATTRIB_VALUE", customHash.get("ATTRIB_VALUE"));
                propList.add(customProp);
            }
            Long tid = new Long(request.getParameter("templateId"));
            Properties propToAudit = new Properties();
            propToAudit.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
            propToAudit.put("ATTRIB_VALUE", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
            propList.add(propToAudit);
            ArrayList creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (creationMsg != null && !creationMsg.isEmpty()) {
                creationStatus = "";
                for (int i = 0; i < creationMsg.size(); ++i) {
                    Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                    String errorCode = (String)creationMessage.get("ERROR_CODE");
                    if (errorCode != null && !errorCode.equalsIgnoreCase("0")) {
                        creationStatus = creationStatus + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " - " + errorCode + " : ";
                    }
                    creationStatus = creationStatus + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE")) + creationMessage.get("NATIVE_ERROR_MESSAGE");
                }
            } else {
                creationStatus = this.rb.getString("admp.mgmt.comp_mgmt.cre_bulk_comp.statmsg.success_created_comp");
            }
            TechAuditAPI.getInstance().auditComputerModification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.cre_single_comp"), this.userName, this.domainName, propList, this.fcNativeProperties.getModifyList(), this.fcNativeProperties.getWinNTAttributeList(), creationStatus, object_id, auditDataObj, this.rb);
            String statusMessage = "";
            statusMessage = this.nativeStatusProps.get("CREATION_MESSAGE") == null ? this.rb.getString("admp.mgmt.comp_mgmt.cre_bulk_comp.statmsg.success_created_comp") : creationStatus;
            audit_info.put("error_msg", creationStatus);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (this.workFlowType != 0L && !this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 3;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.COMPUTER_CREATION_MANAGED_BY_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.COMPUTER_CREATION_MANAGED_BY_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.COMPUTER_CREATION_MANAGED_BY_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BCPC_LAYOUT_VIEW_ID;
                this.triggerNotifiation(audit_id, object_id, this.userName, manager, null, userObjectId, ReportsUtil.SINGLE_COMPUTER_CREATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    private Properties getBulkUserErrorMessage(String computerName) {
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        String ouName = CommonUtil.escapeDN((String)this.ouName);
        if (this.statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = this.statusObject.getErrorList((Object)this.domainName);
            errorSeverity = this.statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        } else if (this.statusObject.getErrorMessage((Object)ouName, this.rb) != null) {
            System.out.println(ouName);
            errorList = this.statusObject.getErrorList((Object)ouName);
            errorSeverity = this.statusObject.getSeverityLevel((Object)ouName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        } else if (this.statusObject.getErrorMessage((Object)computerName, this.rb) != null) {
            errorList = this.statusObject.getErrorList((Object)computerName);
            errorSeverity = this.statusObject.getSeverityLevel((Object)computerName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        ArrayList groupList = this.fcNativeProperties.getGroupList();
        for (Object object : groupList) {
            if (this.statusObject.getErrorMessage(object, this.rb) == null || (errorList = this.statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.comp_mgmt.cre_bulk_comp.statmsg.success_created_comp"));
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.comp_mgmt.cre_bulk_comp.statmsg.success_created_comp"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    private ArrayList<Hashtable> updateCustomAttributeProperties(FcFormDataContainer fromClientData) {
        ArrayList<Hashtable> customListTemp = new ArrayList<Hashtable>();
        try {
            FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
            Properties prop = new Properties();
            prop.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcComputerMgmtHandler.getInstance().getLdapVsValues(fromClientData, prop);
            customFieldsContainer.splitCustomFields(fromClientData);
            FcComputerMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
            FcComputerMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
            customListTemp = this.getCustomAttribsProperties(customFieldsContainer, false, ldapVsValueProps, "computer");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return customListTemp;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setFieldValueList(Properties fieldValue) {
    }

    public void setSingleUserErrorMessage(String appsResult) {
    }
}

