/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.CopyObjectUtil;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApp;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcRecipientFilterUtil;
import com.adventnet.sym.adsm.common.server.layout.IMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtListener;
import com.adventnet.sym.adsm.common.server.layout.behaviour.FlowBehaviour;
import com.adventnet.sym.adsm.common.server.layout.behaviour.WorkflowBehaviour;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleHandler;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.layout.CopyObjectExecuteFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcUserCreationListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcUserModificationListener;
import com.adventnet.sym.adsm.common.webclient.layout.MgmtRuleFlow;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FcExecuteFormAction
extends DispatchAction {
    private Logger log = Logger.getLogger("FcLogger");

    public ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String templateCategoryId = request.getParameter("templateCategoryId") != null ? request.getParameter("templateCategoryId") : FcExecuteActionConstants.defaultTemplateCategoryId.toString();
        String operation = request.getParameter("operation");
        request.setAttribute("templateCategoryId", (Object)templateCategoryId);
        request.setAttribute("operation", (Object)operation);
        request.setAttribute("mode", (Object)request.getParameter("mode"));
        request.setAttribute("guid", (Object)request.getParameter("guid"));
        request.setAttribute("domainName", (Object)request.getParameter("domainName"));
        if (FcLayoutUtil.isModifyObjectCategory((Long)new Long(templateCategoryId))) {
            return mapping.findForward("singleModifyLayoutPage");
        }
        if (operation.equalsIgnoreCase("bulkMgmt")) {
            return mapping.findForward("singleModifyLayoutPage");
        }
        if (operation.equalsIgnoreCase("copyObject")) {
            return mapping.findForward("copyObjectPage");
        }
        return mapping.findForward("layoutPage");
    }

    public ActionForward templateExecution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, " Template Execution page started");
        try {
            HttpSession session = request.getSession();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            FcExecuteFormBean fcExecuteFormBean = new FcExecuteFormBean();
            session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
            fcExecuteFormBean.initForExecution(request, false);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            fcExecuteFormBean.getExecuteFormLayout().setSelectedIamApps(fcExecuteFormBean.getIamApps(), null);
            FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
            fcFormDataContainer.init(fcExecuteFormBean.getExecuteFormLayout());
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
            iMgmtHandler.updateFieldValuesToAttributes(fcFormDataContainer);
            String objectGUID = request.getParameter("objectGUID");
            if (objectGUID != null) {
                FcFormDataContainer copiedDataContainer = CopyObjectExecuteFlow.getCopyObjectValues(fcFormDataContainer, true, loginId, fcExecuteFormBean, objectGUID);
                FcExecuteFormFlow.applyTemplate(fcFormDataContainer, copiedDataContainer);
                request.setAttribute("isDirectCopyObject", (Object)"true");
            }
            Properties prop = new Properties();
            prop.put("domainName", fcExecuteFormBean.getDomainName());
            prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fcFormDataContainer, prop);
            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), fcFormDataContainer, fcExecuteFormBean.getUserData());
            if (fcExecuteFormBean.getMgmtRuleConditionFields() != null && fcExecuteFormBean.getMgmtRuleConditionFields().size() > 0) {
                MgmtRuleFlow.applyMgmtRulesInLayout(fcExecuteFormBean.getExecuteFormLayout().getLayoutId(), fcFormDataContainer, rb, fcExecuteFormBean.getTemplateData(), fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData());
            }
            fcExecuteFormBean.setToClientData(fcFormDataContainer);
            Long defaultLayoutId = FcExecuteFormFlow.getDefaultLayoutId(loginId, fcExecuteFormBean.getTemplateCategoryId(), fcExecuteFormBean.getDomainName(), true, fcExecuteFormBean.getIsWorkFlowMode());
            ArrayList list = null;
            list = fcExecuteFormBean.getIsWorkFlowMode() ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"") : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"");
            String selectedLayoutName = FcLayoutUtil.getLayoutName((ArrayList)list, (Long)defaultLayoutId);
            request.setAttribute("selectedDomainName", (Object)fcExecuteFormBean.getDomainName());
            request.setAttribute("selectedTemplateId", (Object)defaultLayoutId.toString());
            request.setAttribute("selectedTemplateName", (Object)selectedLayoutName);
            request.setAttribute("templateListSize", (Object)list.size());
            this.log.log(Level.INFO, " Template Execution page finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("renderLayout");
    }

    public ActionForward singleModify(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String message = "";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long templateCategoryId = 1L;
        try {
            boolean isAuthorizedObject;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            if (fcExecuteFormBean == null) {
                fcExecuteFormBean = new FcExecuteFormBean();
                session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
            }
            fcExecuteFormBean.initForExecution(request, false);
            templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            IMgmtListener iMgmtListener = fcExecuteFormBean.getIMgmtListener();
            if (request.getParameter("guid") != null) {
                iMgmtListener.setGuid(request.getParameter("guid"));
            }
            iMgmtListener.setDomainName(fcExecuteFormBean.getDomainName());
            iMgmtListener.setLoginId(loginId);
            FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
            fcFormDataContainer.init(fcExecuteFormBean.getExecuteFormLayout());
            FcExecuteFormFlow.setTemplateData(fcExecuteFormBean);
            boolean isWorkFlowMode = fcExecuteFormBean.getIsWorkFlowMode();
            ArrayList authorizedOUList = new ArrayList();
            authorizedOUList = !isWorkFlowMode ? ClientAuthorizationUtil.getAuthorizedOUList(request, fcExecuteFormBean.getDomainName()) : WorkFlowUserHandler.getOUList((String)fcExecuteFormBean.getDomainName(), (Long)loginId);
            iMgmtListener.setAuthorizedOUList(authorizedOUList);
            if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)fcExecuteFormBean.getDomainName());
                iMgmtListener.setIncludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU"));
                iMgmtListener.setExcludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU"));
            }
            if (request.getParameter("guid") != null) {
                String guid = request.getParameter("guid");
                ArrayList mandatoryFieldsArray = iMgmtListener.getMandatoryFields();
                FcExecuteFormFlow.addRuleFieldsLdapNames(fcExecuteFormBean, mandatoryFieldsArray);
                FcExecuteFormFlow.addNamingFormatFieldsLdapNames(fcFormDataContainer, mandatoryFieldsArray);
                FcExecuteFormFlow.addTemplateMandatoryLdapNames(fcFormDataContainer, mandatoryFieldsArray);
                FcExecuteFormFlow.addFirstDisplyTabLdapNames(fcExecuteFormBean.getExecuteFormLayout(), mandatoryFieldsArray, true, templateCategoryId);
                Properties mandatoryFieldsvaluesList = new Properties();
                iMgmtListener.removeLyncAttributes(mandatoryFieldsArray);
                if (!mandatoryFieldsArray.isEmpty()) {
                    mandatoryFieldsvaluesList = FcExecuteFormFlow.getObjectProperties(guid, fcExecuteFormBean.getDomainName(), loginId, mandatoryFieldsArray);
                }
                if (templateCategoryId.compareTo(FcExecuteActionConstants.o365DistGroupModificationTemplateCategoryId) == 0 && mandatoryFieldsvaluesList.get("ERROR_MESSAGE") != null) {
                    message = rb.getString("admp.mgmt.office365.error.mod_o365_dist_group");
                    request.setAttribute("tipsMessage", (Object)rb.getString((String)mandatoryFieldsvaluesList.get("ERROR_MESSAGE")));
                }
                iMgmtListener.fillMandatoryFields(mandatoryFieldsvaluesList);
                Properties lyncAttribValuesList = iMgmtListener.getLyncAttributeValues();
                if (lyncAttribValuesList != null) {
                    mandatoryFieldsvaluesList.putAll((Map<?, ?>)lyncAttribValuesList);
                }
                iMgmtListener.fillADValues(fcFormDataContainer, fcExecuteFormBean.getADData(), mandatoryFieldsvaluesList, loginId, true);
                iMgmtListener.restrictFieldsFromEditing(fcFormDataContainer);
                IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
                iMgmtHandler.updateFieldValuesToAttributes(fcFormDataContainer);
                Properties prop = new Properties();
                prop.put("domainName", fcExecuteFormBean.getDomainName());
                if (fcExecuteFormBean.getDomainDNSName() != null) {
                    prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
                }
                Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fcFormDataContainer, prop);
                FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), fcFormDataContainer, fcExecuteFormBean.getUserData());
                MgmtRuleFlow.applyMgmtRulesInLayout(fcExecuteFormBean.getExecuteFormLayout().getLayoutId(), fcFormDataContainer, rb, fcExecuteFormBean.getTemplateData(), fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData());
                fcExecuteFormBean.setToClientData(fcFormDataContainer);
            }
            if (!(isAuthorizedObject = iMgmtListener.isAuthorizedObject())) {
                if (templateCategoryId.compareTo(FcExecuteActionConstants.contactModificationTemplateCategoryId) == 0) {
                    message = rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_contact_not_authorized");
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_contact_exists_in_delegated_ous"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                    message = rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_user_not_authorized");
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_user_exists_in_delegated_ous"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                    message = rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_group_not_authorized");
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_group_exists_in_delegated_ous"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.ouModificationTemplateCategoryId) == 0) {
                    message = rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_ou_not_authorized");
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_ou_exists_in_delegated_ous"));
                }
            }
            if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)fcExecuteFormBean.getDomainName());
                iMgmtListener.setIncludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU"));
                iMgmtListener.setExcludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU"));
            }
            ArrayList list = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"");
            String selectedLayoutName = fcExecuteFormBean.getExecuteFormLayout().getLayoutName();
            request.setAttribute("selectedDomainName", (Object)fcExecuteFormBean.getDomainName());
            request.setAttribute("selectedTemplateId", (Object)fcExecuteFormBean.getExecuteFormLayout().getLayoutId().toString());
            request.setAttribute("selectedTemplateName", (Object)selectedLayoutName);
            request.setAttribute("templateListSize", (Object)list.size());
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = le.getMessage(rb);
            if (message != null) {
                String errorMsgKey = "";
                if (templateCategoryId.compareTo(FcExecuteActionConstants.contactModificationTemplateCategoryId) == 0) {
                    errorMsgKey = "admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_contact";
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_contact_exists_in_active_directory"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                    errorMsgKey = "admp.mgmt.user_mgmt.mod_sing_user.statmsg_error_in_modifying_user";
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_user_exists_in_active_directory"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                    errorMsgKey = "admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_group";
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_group_exists_in_active_directory"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.ouModificationTemplateCategoryId) == 0) {
                    errorMsgKey = "admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_ou";
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_ou_not_authorized"));
                }
                message = MessageFormat.format(rb.getString(errorMsgKey), message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        request.setAttribute("message", (Object)message);
        request.setAttribute("guid", (Object)request.getParameter("guid"));
        return mapping.findForward("modifyObject");
    }

    public ActionForward bulkMgmtPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, " Bulk Mgmt page started");
        try {
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = new FcExecuteFormBean();
            session.setAttribute("FcExecuteFormBean", (Object)fcExecuteFormBean);
            fcExecuteFormBean.initForExecution(request, false, true);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            fcExecuteFormBean.getExecuteFormLayout().setSelectedIamApps(fcExecuteFormBean.getIamApps(), null);
            FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
            fcFormDataContainer.init(fcExecuteFormBean.getExecuteFormLayout());
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
            iMgmtHandler.updateFieldValuesToAttributes(fcFormDataContainer);
            Properties prop = new Properties();
            prop.put("domainName", fcExecuteFormBean.getDomainName());
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fcFormDataContainer, prop);
            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), fcFormDataContainer, new FcFormDataContainer());
            fcExecuteFormBean.setToClientData(fcFormDataContainer);
            Long defaultLayoutId = FcExecuteFormFlow.getDefaultLayoutId(loginId, fcExecuteFormBean.getTemplateCategoryId(), fcExecuteFormBean.getDomainName(), true, fcExecuteFormBean.getIsWorkFlowMode());
            ArrayList list = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"");
            String selectedLayoutName = FcLayoutUtil.getLayoutName((ArrayList)list, (Long)defaultLayoutId);
            request.setAttribute("selectedDomainName", (Object)fcExecuteFormBean.getDomainName());
            request.setAttribute("selectedTemplateId", (Object)defaultLayoutId.toString());
            request.setAttribute("selectedTemplateName", (Object)selectedLayoutName);
            request.setAttribute("templateListSize", (Object)list.size());
            this.log.log(Level.INFO, " Bulk Mgmt page finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("bulkMgmtPage");
    }

    public ActionForward getSummaryViewPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String jsonString = request.getParameter("FcExecuteLayout");
            JSONObject fcLayoutJsonObj = new JSONObject();
            fcLayoutJsonObj = new JSONObject(jsonString);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            FcLayout fcLayout = new FcLayout();
            fcLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientDataContainer = new FcFormDataContainer();
            fromClientDataContainer.init(fcLayout, true);
            boolean isOverWriteADValue = Boolean.parseBoolean(request.getParameter("isOverWriteADValue"));
            boolean isCopyObjectApplied = Boolean.parseBoolean(request.getParameter("isCopyObjectApplied"));
            JSONArray resultFieldsJsonArray = FcExecuteFormFlow.getModifiedFieldsList(templateCategoryId, fromClientDataContainer, fcExecuteFormBean.getADData(), rb, true, fcExecuteFormBean, loginId, isOverWriteADValue, isCopyObjectApplied);
            request.setAttribute("templateCategoryId", (Object)templateCategoryId);
            request.setAttribute("fieldsSummaryArray", (Object)resultFieldsJsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("summaryPage");
    }

    public ActionForward getObjectProperties(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String jsonString = request.getParameter("FcExecuteLayout");
            JSONObject fcLayoutJsonObj = new JSONObject();
            fcLayoutJsonObj = new JSONObject(jsonString);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            FcLayout fcLayout = new FcLayout();
            fcLayout.init(fcLayoutJsonObj);
            JSONArray objectPropertiesArray = fcLayout.getObjectProperties(rb);
            request.setAttribute("templateCategoryId", (Object)templateCategoryId);
            request.setAttribute("objectPropertiesArray", (Object)objectPropertiesArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("viewObjectProp");
    }

    public ActionForward submitExecuteLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        boolean isModifyObject = false;
        String reqGuid = "";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            int k;
            this.log.log(Level.INFO, " FcExecuteFormAction submitExecuteLayout starts");
            String jsonString = request.getParameter("FcExecuteLayout");
            JSONObject fcLayoutJsonObj = new JSONObject();
            fcLayoutJsonObj = new JSONObject(jsonString);
            FcLayout executeFormLayout = new FcLayout();
            executeFormLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeFormLayout);
            FcFormDataContainer fromClientDatatoAD = new FcFormDataContainer();
            fromClientDatatoAD.init(executeFormLayout, true);
            isModifyObject = FcLayoutUtil.isModifyObjectCategory((Long)templateCategoryId);
            FcFormDataContainer userData = fcExecuteFormBean.getUserData();
            FcExecuteFormFlow.updateUserData(templateCategoryId, fromClientDatatoAD, fcExecuteFormBean.getToClientData(), userData);
            Long templateId = new Long(request.getParameter("templateId"));
            boolean isOverWriteADValue = Boolean.parseBoolean(request.getParameter("isOverWriteADValue"));
            boolean isCopyObjectApplied = Boolean.parseBoolean(request.getParameter("isCopiedObject"));
            ArrayList templateList = null;
            templateList = fcExecuteFormBean.getIsWorkFlowMode() ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"") : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"");
            IMgmtListener listener = fcExecuteFormBean.getIMgmtListener();
            this.log.log(Level.INFO, " Object Listener is initialized.. Template Category Id : " + templateCategoryId);
            listener.init(request);
            if (isModifyObject) {
                reqGuid = listener.getGuid();
            }
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            boolean isWorkFlowMode = fcExecuteFormBean.getIsWorkFlowMode();
            boolean isBulkMgmtAction = fcExecuteFormBean.getIsBulkMgmtAction();
            boolean isExecutionSuceeded = false;
            Long requestId = -1L;
            listener.setIsWorkFlowMode(isWorkFlowMode);
            JSONArray selectedIamAppJsonArray = executeFormLayout.getSelectedIamAppsJsonArray();
            boolean isADSelected = false;
            boolean isO365Selected = false;
            for (k = 0; k < selectedIamAppJsonArray.length(); ++k) {
                if (selectedIamAppJsonArray.getInt(k) == FcLayoutConstants.ACTIVE_DIRECTORY_APPID.intValue()) {
                    isADSelected = true;
                    continue;
                }
                if (selectedIamAppJsonArray.getInt(k) != FcLayoutConstants.OFFICE_365_APPID.intValue()) continue;
                isO365Selected = true;
            }
            listener.setisADSelected(isADSelected);
            listener.setIsO365(isO365Selected);
            listener.setisCopyObjectApplied(isCopyObjectApplied);
            listener.setisOverWriteADValue(isOverWriteADValue);
            if (isWorkFlowMode) {
                String wfCreateRequestProp = request.getParameter("createRequest");
                JSONObject wfCreateRequestJson = new JSONObject(wfCreateRequestProp);
                listener.setBehaviourObject((FlowBehaviour)new WorkflowBehaviour());
                if (fcExecuteFormBean.getTemplateCategoryId().compareTo(6L) != 0) {
                    requestId = listener.createRequest(executeFormLayout.getDomainName(), wfCreateRequestJson, fromClientDatatoAD, fcExecuteFormBean.getUserData(), loginId, executeFormLayout.getLayoutId(), executeFormLayout, templateCategoryId);
                } else {
                    FcExecuteFormFlow.updateToBeRemovedGroupListForUserData(fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData());
                    requestId = ((FcUserModificationListener)listener).createRequest(executeFormLayout.getDomainName(), wfCreateRequestJson, fromClientDatatoAD, fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData(), loginId, executeFormLayout.getLayoutId(), executeFormLayout, templateCategoryId);
                }
                listener.setStatusMsgForWorkFlowResponse(request, requestId);
                if (requestId.compareTo(-1L) != 0) {
                    isExecutionSuceeded = true;
                }
            } else {
                if (isBulkMgmtAction) {
                    String inputJson = request.getParameter("inputJson");
                    JSONObject inputObj = new JSONObject(inputJson);
                    String hostId = request.getRemoteHost();
                    JSONObject rvcJsonObject = listener.doBulkMgmtAction(executeFormLayout.getDomainName(), executeFormLayout, fromClientDatatoAD, fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData(), fcExecuteFormBean.getIamApps(), loginId, inputObj, hostId, request);
                    response.setContentType("application/json");
                    PrintWriter writer = response.getWriter();
                    writer.print(rvcJsonObject.toString());
                    return null;
                }
                if (isModifyObject) {
                    listener.doAction(fcExecuteFormBean.getCreationId(), executeFormLayout.getDomainName(), executeFormLayout, fromClientDatatoAD, fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData(), fcExecuteFormBean.getIamApps(), loginId, fcExecuteFormBean.getExecuteFormLayout());
                } else {
                    listener.doAction(fcExecuteFormBean.getCreationId(), executeFormLayout.getDomainName(), executeFormLayout, fromClientDatatoAD, fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData(), fcExecuteFormBean.getIamApps(), loginId);
                }
                listener.setIsCreationSuccess();
                isExecutionSuceeded = listener.getIsCreationSuccess();
                if (isExecutionSuceeded) {
                    for (k = 0; k < selectedIamAppJsonArray.length(); ++k) {
                        FcIamApp fcIamApp = fcExecuteFormBean.getFcIamApp(selectedIamAppJsonArray.getInt(k));
                        if (fcIamApp.getIamAppId().intValue() == FcLayoutConstants.ACTIVE_DIRECTORY_APPID.intValue()) continue;
                        IMgmtListener iamAppListener = fcIamApp.getIMgmtListener();
                        if (iamAppListener != null) {
                            String appsResult;
                            iamAppListener.init(request);
                            this.log.log(Level.INFO, " IamApps Listener is initialized.. Template Category Id : " + fcIamApp.getIamAppName());
                            if (isWorkFlowMode) continue;
                            iamAppListener.setisADSelected(isADSelected);
                            iamAppListener.setSourceAction(listener.getSourceAction());
                            if (isModifyObject) {
                                iamAppListener.doAction(fcExecuteFormBean.getCreationId(), fcExecuteFormBean.getDomainName(), executeFormLayout, fromClientDatatoAD, fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData(), fcExecuteFormBean.getIamApps(), loginId, fcExecuteFormBean.getExecuteFormLayout());
                            } else {
                                iamAppListener.doAction(fcExecuteFormBean.getCreationId(), fcExecuteFormBean.getDomainName(), executeFormLayout, fromClientDatatoAD, fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData(), fcExecuteFormBean.getIamApps(), loginId);
                            }
                            Properties resultProps = iamAppListener.getNativeStatusProps();
                            if (resultProps == null || (appsResult = (String)resultProps.get("message")) == null || appsResult.trim().length() <= 0) continue;
                            boolean isAppsCreationSuccess = (Boolean)resultProps.get("isSuccess");
                            if (isAppsCreationSuccess) {
                                if (iamAppListener.getIsGApps()) {
                                    listener.setIsGApps(true);
                                    ((FcMgmtListener)listener).sAMAccVsGAppsId = iamAppListener.getSAMAccVsGAppsId(((FcUserCreationListener)listener).samAccountName);
                                }
                                if (listener.getRusMessage() != null && !"".equals(listener.getRusMessage())) {
                                    listener.setRusMessage(listener.getRusMessage() + ", " + rb.getString(appsResult));
                                    continue;
                                }
                                listener.setRusMessage(rb.getString(appsResult));
                                continue;
                            }
                            if (!listener.getIsBulkMgmt()) {
                                listener.setSingleUserErrorMessage(rb.getString(appsResult));
                            } else {
                                listener.getNativeStatusProps().setProperty("CREATION_MESSAGE", listener.getNativeStatusProps().getProperty("CREATION_MESSAGE") + ", " + rb.getString(appsResult));
                            }
                            if (isADSelected) continue;
                            isExecutionSuceeded = false;
                            continue;
                        }
                        System.out.println(" Please specify listener class name for user  creation listener for IamApp");
                    }
                }
                listener.setStatusMsgForResponse(request);
            }
            if (isExecutionSuceeded) {
                this.log.log(Level.INFO, " Execution of the object is succeeded... ");
                if (!(templateId != null && FcLayoutViewHandler.isLayoutValid((Long)templateId) || (templateId = FcLayoutViewHandler.getAuthorizedDefaultLayoutId((Long)loginId, (Long)templateCategoryId, (boolean)isWorkFlowMode, (String)executeFormLayout.getDomainName())) != null)) {
                    templateId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)true);
                }
                FcExecuteFormBean newFcExecuteFormBean = new FcExecuteFormBean();
                session.setAttribute("FcExecuteFormBean", (Object)newFcExecuteFormBean);
                newFcExecuteFormBean.setTemplateCategoryId(templateCategoryId);
                newFcExecuteFormBean.setIsWorkFlowMode(isWorkFlowMode);
                newFcExecuteFormBean.initForExecution(request, false, false);
                FcLayout toClientExecuteLayout = new FcLayout(templateId, rb, executeFormLayout.getDomainName());
                FcFormDataContainer fcFormDataContainer = new FcFormDataContainer();
                fcFormDataContainer.init(toClientExecuteLayout);
                if (FcLayoutViewHandler.isDomainNameEmpty((Long)templateId) && FcLayoutUtil.getIsADDomain((String)executeFormLayout.getDomainName())) {
                    Hashtable dpValues = FcLayoutUtil.getDPValues((Long)templateCategoryId, (Long)loginId, (String)executeFormLayout.getDomainName(), (AdventNetResourceBundle)rb, (boolean)isWorkFlowMode);
                    FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, fcFormDataContainer, executeFormLayout.getDomainName(), rb, loginId, templateCategoryId);
                }
                newFcExecuteFormBean.setExecuteFormLayout(toClientExecuteLayout);
                FcExecuteFormFlow.setTemplateData(newFcExecuteFormBean);
                FcExecuteFormFlow.initDataContainerData(request, toClientExecuteLayout);
                newFcExecuteFormBean.setDomainName(executeFormLayout.getDomainName());
                newFcExecuteFormBean.setNamingFormatFields(FcExecuteFormFlow.getNamingFormatFields(fcFormDataContainer));
                newFcExecuteFormBean.setFormatParticipatingFields(FcExecuteFormFlow.getFormatParticipatingFields(templateCategoryId, fcFormDataContainer, newFcExecuteFormBean.getNamingFormatFields()));
                newFcExecuteFormBean.setMgmtRuleResultFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)templateId, (boolean)false));
                newFcExecuteFormBean.setMgmtRuleConditionFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)templateId, (boolean)true));
                newFcExecuteFormBean.setImmediateDupliationCheckFields(FcExecuteFormFlow.getImmediateDupliationCheckFields(fcFormDataContainer));
                if (!newFcExecuteFormBean.getIsWorkFlowMode()) {
                    FcExecuteFormFlow.fillAuthorizedFields(request, fcFormDataContainer, templateCategoryId, executeFormLayout.getDomainName(), newFcExecuteFormBean.getActionId());
                }
                iMgmtHandler.updateFieldsAttributes(fcFormDataContainer);
                iMgmtHandler.updateFieldValuesToAttributes(fcFormDataContainer);
                if (isModifyObject) {
                    FcFormDataContainer adData = new FcFormDataContainer();
                    newFcExecuteFormBean.setADData(adData);
                    toClientExecuteLayout.setDomainName(executeFormLayout.getDomainName());
                    IMgmtListener iMgmtListener = null;
                    Properties prop = FcLayoutViewHandler.getTemplateCategoryDetails((Long)templateCategoryId);
                    Class<?> listenerClass = Class.forName((String)prop.get("LISTENER_CLASS_NAME"));
                    iMgmtListener = (IMgmtListener)listenerClass.newInstance();
                    iMgmtListener.setGuid(listener.getGuid());
                    iMgmtListener.setDomainName(newFcExecuteFormBean.getDomainName());
                    iMgmtListener.setLoginId(loginId);
                    ArrayList authorizedOUList = ClientAuthorizationUtil.getAuthorizedOUList(request, newFcExecuteFormBean.getDomainName());
                    iMgmtListener.setAuthorizedOUList(authorizedOUList);
                    if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                        Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)fcExecuteFormBean.getDomainName());
                        iMgmtListener.setIncludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU"));
                        iMgmtListener.setExcludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU"));
                    }
                    newFcExecuteFormBean.setIMgmtListener(iMgmtListener);
                    ArrayList mandatoryFieldsArray = iMgmtListener.getMandatoryFields();
                    FcExecuteFormFlow.addRuleFieldsLdapNames(fcExecuteFormBean, mandatoryFieldsArray);
                    FcExecuteFormFlow.addNamingFormatFieldsLdapNames(fcFormDataContainer, mandatoryFieldsArray);
                    FcExecuteFormFlow.addFirstDisplyTabLdapNames(toClientExecuteLayout, mandatoryFieldsArray, true, templateCategoryId);
                    Properties mandatoryFieldsvaluesList = new Properties();
                    iMgmtListener.removeLyncAttributes(mandatoryFieldsArray);
                    if (!mandatoryFieldsArray.isEmpty()) {
                        mandatoryFieldsvaluesList = FcExecuteFormFlow.getObjectProperties(iMgmtListener.getGuid(), newFcExecuteFormBean.getDomainName(), loginId, mandatoryFieldsArray);
                    }
                    iMgmtListener.fillMandatoryFields(mandatoryFieldsvaluesList);
                    Properties lyncAttribValuesList = iMgmtListener.getLyncAttributeValues();
                    if (lyncAttribValuesList != null) {
                        mandatoryFieldsvaluesList.putAll((Map<?, ?>)lyncAttribValuesList);
                    }
                    iMgmtListener.fillADValues(fcFormDataContainer, newFcExecuteFormBean.getADData(), mandatoryFieldsvaluesList, loginId, true);
                }
                iMgmtHandler.updateFieldValuesToAttributes(fcFormDataContainer);
                Properties prop = new Properties();
                prop.put("domainName", newFcExecuteFormBean.getDomainName());
                if (newFcExecuteFormBean.getDomainDNSName() != null) {
                    prop.put("domainDNSName", newFcExecuteFormBean.getDomainDNSName());
                }
                Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fcFormDataContainer, prop);
                FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, newFcExecuteFormBean.getNamingFormatFields(), fcFormDataContainer, newFcExecuteFormBean.getUserData());
                MgmtRuleFlow.applyMgmtRulesInLayout(toClientExecuteLayout.getLayoutId(), fcFormDataContainer, rb, newFcExecuteFormBean.getTemplateData(), newFcExecuteFormBean.getUserData(), newFcExecuteFormBean.getADData());
                if (isModifyObject) {
                    FcExecuteFormFlow.applyTemplate(fcFormDataContainer, newFcExecuteFormBean.getADData());
                }
                newFcExecuteFormBean.setToClientData(fcFormDataContainer);
            } else {
                this.log.log(Level.INFO, "Execution of the object is failed... ");
                fcExecuteFormBean.setExecuteFormLayout(executeFormLayout);
                listener.reInit();
            }
            String isDirectCopyObject = request.getParameter("isDirectCopyObject");
            if (isDirectCopyObject.equalsIgnoreCase("true")) {
                request.setAttribute("isDirectCopyObject", (Object)"true");
            }
            request.setAttribute("selectedTemplateId", (Object)templateId.toString());
            String selectedLayoutName = FcLayoutUtil.getLayoutName((ArrayList)templateList, (Long)templateId);
            request.setAttribute("selectedTemplateName", (Object)selectedLayoutName);
            request.setAttribute("templateListSize", (Object)templateList.size());
            request.setAttribute("selectedDomainName", (Object)executeFormLayout.getDomainName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fcExecuteFormBean.getIsCopyAvailable()) {
            request.setAttribute("copyObjectDetails", (Object)FcLayoutViewHandler.getCopyObjectDetails((Long)fcExecuteFormBean.getTemplateCategoryId(), (AdventNetResourceBundle)rb).toString());
        }
        if (!fcExecuteFormBean.getIsTemplateAvailable()) {
            request.setAttribute("isTemplateAvailable", (Object)fcExecuteFormBean.getIsTemplateAvailable());
        }
        if (isModifyObject) {
            request.setAttribute("guid", (Object)reqGuid);
            return mapping.findForward("modifyObject");
        }
        return mapping.findForward("renderLayout");
    }

    public ActionForward applyTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, "Apply Template Started ");
        String message = "";
        String forwardString = "renderLayout";
        Long templateCategoryId = 1L;
        String reqGuid = "";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        try {
            boolean isModifyObject;
            String jsonString = request.getParameter("FcExecuteLayout");
            JSONObject fcLayoutJsonObj = new JSONObject();
            fcLayoutJsonObj = new JSONObject(jsonString);
            FcLayout executeLayout = new FcLayout();
            executeLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeLayout);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            boolean isWorkFlowMode = fcExecuteFormBean.getIsWorkFlowMode();
            templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            FcFormDataContainer userData = fcExecuteFormBean.getUserData();
            FcExecuteFormFlow.updateUserData(templateCategoryId, fromClientData, fcExecuteFormBean.getToClientData(), userData);
            Long templateId = new Long(request.getParameter("templateId"));
            FcLayout toClientExecuteLayout = new FcLayout(templateId, rb, fcExecuteFormBean.getDomainName());
            FcFormDataContainer newToClientData = new FcFormDataContainer();
            newToClientData.init(toClientExecuteLayout);
            if (FcLayoutViewHandler.isDomainNameEmpty((Long)templateId)) {
                Hashtable dpValues = FcLayoutUtil.getDPValues((Long)templateCategoryId, (Long)loginId, (String)fcExecuteFormBean.getDomainName(), (AdventNetResourceBundle)rb, (boolean)fcExecuteFormBean.getIsWorkFlowMode());
                FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, newToClientData, fcExecuteFormBean.getDomainName(), rb, loginId, templateCategoryId);
            }
            fcExecuteFormBean.setExecuteFormLayout(toClientExecuteLayout);
            FcExecuteFormFlow.setTemplateData(fcExecuteFormBean);
            fcExecuteFormBean.setNamingFormatFields(FcExecuteFormFlow.getNamingFormatFields(newToClientData));
            fcExecuteFormBean.setFormatParticipatingFields(FcExecuteFormFlow.getFormatParticipatingFields(templateCategoryId, newToClientData, fcExecuteFormBean.getNamingFormatFields()));
            fcExecuteFormBean.setMgmtRuleResultFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)templateId, (boolean)false));
            fcExecuteFormBean.setMgmtRuleConditionFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)templateId, (boolean)true));
            fcExecuteFormBean.setImmediateDupliationCheckFields(FcExecuteFormFlow.getImmediateDupliationCheckFields(newToClientData));
            if (!fcExecuteFormBean.getIsWorkFlowMode()) {
                FcExecuteFormFlow.fillAuthorizedFields(request, newToClientData, templateCategoryId, fcExecuteFormBean.getDomainName(), fcExecuteFormBean.getActionId());
            }
            if (isModifyObject = FcLayoutUtil.isModifyObjectCategory((Long)templateCategoryId)) {
                FcFormDataContainer adData = new FcFormDataContainer();
                fcExecuteFormBean.setADData(adData);
                IMgmtListener iMgmtListener = fcExecuteFormBean.getIMgmtListener();
                reqGuid = iMgmtListener.getGuid();
                ArrayList authorizedOUList = ClientAuthorizationUtil.getAuthorizedOUList(request, fcExecuteFormBean.getDomainName());
                iMgmtListener.setAuthorizedOUList(authorizedOUList);
                if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                    Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)fcExecuteFormBean.getDomainName());
                    iMgmtListener.setIncludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU"));
                    iMgmtListener.setExcludeGroupOuList((ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU"));
                }
                ArrayList fieldLdapNamesArray = iMgmtListener.getMandatoryFields();
                FcExecuteFormFlow.addRuleFieldsLdapNames(fcExecuteFormBean, fieldLdapNamesArray);
                FcExecuteFormFlow.addNamingFormatFieldsLdapNames(newToClientData, fieldLdapNamesArray);
                FcExecuteFormFlow.addTemplateMandatoryLdapNames(newToClientData, fieldLdapNamesArray);
                FcExecuteFormFlow.addFirstDisplyTabLdapNames(toClientExecuteLayout, fieldLdapNamesArray, true, templateCategoryId);
                Properties basicFieldsvaluesList = new Properties();
                iMgmtListener.removeLyncAttributes(fieldLdapNamesArray);
                if (!fieldLdapNamesArray.isEmpty()) {
                    basicFieldsvaluesList = FcExecuteFormFlow.getObjectProperties(iMgmtListener.getGuid(), toClientExecuteLayout.getDomainName(), loginId, fieldLdapNamesArray);
                }
                iMgmtListener.fillMandatoryFields(basicFieldsvaluesList);
                Properties lyncAttribValuesList = iMgmtListener.getLyncAttributeValues();
                if (lyncAttribValuesList != null) {
                    basicFieldsvaluesList.putAll((Map<?, ?>)lyncAttribValuesList);
                }
                iMgmtListener.fillADValues(newToClientData, fcExecuteFormBean.getADData(), basicFieldsvaluesList, loginId, true);
                userData = new FcFormDataContainer();
                fcExecuteFormBean.setUserData(userData);
            }
            FcExecuteFormFlow.applyTemplate(newToClientData, userData);
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
            iMgmtHandler.updateFieldValuesToAttributes(newToClientData);
            String isDirectCopyObject = request.getParameter("isDirectCopyObject");
            if (isDirectCopyObject.equalsIgnoreCase("true")) {
                request.setAttribute("isDirectCopyObject", (Object)"true");
            }
            Properties prop = new Properties();
            prop.put("domainName", fcExecuteFormBean.getDomainName());
            prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(newToClientData, prop);
            FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), newToClientData, userData);
            MgmtRuleFlow.applyMgmtRulesInLayout(toClientExecuteLayout.getLayoutId(), newToClientData, rb, fcExecuteFormBean.getTemplateData(), userData, fcExecuteFormBean.getADData());
            ArrayList addedCustomFields = FcLayoutUtil.addAdditionalCustomFields((FcLayout)toClientExecuteLayout, (FcFormDataContainer)userData);
            newToClientData.put(addedCustomFields);
            fcExecuteFormBean.setToClientData(newToClientData);
            fcExecuteFormBean.getIMgmtListener().restrictFieldsFromEditing(newToClientData);
            String LAYOUT_NAME = "LAYOUT_NAME";
            ArrayList list = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)toClientExecuteLayout.getDomainName(), (int)-1, (String)"");
            list = isWorkFlowMode ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)toClientExecuteLayout.getDomainName(), (int)-1, (String)"") : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)toClientExecuteLayout.getDomainName(), (int)-1, (String)"");
            if (fcExecuteFormBean.getIsCopyAvailable()) {
                request.setAttribute("copyObjectDetails", (Object)FcLayoutViewHandler.getCopyObjectDetails((Long)templateCategoryId, (AdventNetResourceBundle)rb).toString());
            }
            String selectedLayoutName = FcLayoutUtil.getLayoutName((ArrayList)list, (Long)templateId);
            request.setAttribute("selectedTemplateName", (Object)selectedLayoutName);
            request.setAttribute("templateListSize", (Object)list.size());
            request.setAttribute("selectedTemplateId", (Object)templateId.toString());
            request.setAttribute("selectedDomainName", (Object)toClientExecuteLayout.getDomainName());
            this.log.log(Level.INFO, "Apply Template finished ");
            if (FcLayoutUtil.isModifyObjectCategory((Long)fcExecuteFormBean.getTemplateCategoryId())) {
                request.setAttribute("guid", (Object)reqGuid);
                forwardString = "modifyObject";
            }
        }
        catch (LocalizedException le) {
            message = le.getMessage(rb);
            if (message != null) {
                String errorMsgKey = "";
                if (templateCategoryId.compareTo(FcExecuteActionConstants.contactModificationTemplateCategoryId) == 0) {
                    errorMsgKey = "admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_contact";
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_contact_exists_in_active_directory"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.userModificationTemplateCategoryId) == 0) {
                    errorMsgKey = "admp.mgmt.user_mgmt.mod_sing_user.statmsg_error_in_modifying_user";
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_user_exists_in_active_directory"));
                } else if (templateCategoryId.compareTo(FcExecuteActionConstants.groupModificationTemplateCategoryId) == 0) {
                    errorMsgKey = "admp.deleg.hdt_deleg.mod_hdt.statmsg_error_in_modifying_group";
                    request.setAttribute("tipsMessage", (Object)rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_check_whether_group_exists_in_active_directory"));
                }
                message = MessageFormat.format(rb.getString(errorMsgKey), message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fcExecuteFormBean.getIsCopyAvailable()) {
            request.setAttribute("copyObjectDetails", (Object)FcLayoutViewHandler.getCopyObjectDetails((Long)templateCategoryId, (AdventNetResourceBundle)rb).toString());
        }
        return mapping.findForward(forwardString);
    }

    public ActionForward applyNamingFormat(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, "Apply Naming Format Started ");
        try {
            String formattedNameJSONString = FcExecuteFormAction.getFormattedNameJSONString(request);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(EscapeUtil.escSplCharsAsHTML((Object)formattedNameJSONString));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward applyMgmtRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String jsonString = request.getParameter("FcExecuteLayout");
        JSONObject fcLayoutJsonObj = new JSONObject();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            fcLayoutJsonObj = new JSONObject(jsonString);
            FcLayout executeLayout = new FcLayout();
            executeLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeLayout);
            HttpSession session = request.getSession();
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            FcFormDataContainer userData = fcExecuteFormBean.getUserData();
            FcExecuteFormFlow.updateUserData(fcExecuteFormBean.getTemplateCategoryId(), fromClientData, fcExecuteFormBean.getToClientData(), userData);
            String modifiedFieldsDetailsString = MgmtRuleFlow.applyMgmtRulesInLayout(executeLayout.getLayoutId(), fromClientData, rb, fcExecuteFormBean.getTemplateData(), userData, fcExecuteFormBean.getADData());
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(templateCategoryId);
            iMgmtHandler.updateFieldsAttributes(fromClientData);
            fcExecuteFormBean.setToClientData(fromClientData);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(modifiedFieldsDetailsString);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward changeDomain(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, " Setting Domain Specific fields started");
        String LAYOUT_NAME = "LAYOUT_NAME";
        String domainName = request.getParameter("domainName");
        String jsonString = request.getParameter("FcLayoutJsonStr");
        JSONObject fcLayoutJsonObj = new JSONObject();
        try {
            fcLayoutJsonObj = new JSONObject(jsonString);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        FcLayout executeLayout = new FcLayout();
        executeLayout.init(fcLayoutJsonObj);
        FcFormDataContainer fromClientData = new FcFormDataContainer();
        fromClientData.init(executeLayout);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        fcExecuteFormBean.setDomainName(domainName);
        FcFormDataContainer userData = fcExecuteFormBean.getUserData();
        FcExecuteFormFlow.updateUserData(fcExecuteFormBean.getTemplateCategoryId(), fromClientData, fcExecuteFormBean.getToClientData(), userData);
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Hashtable dpValues = FcLayoutUtil.getDPValues((Long)fcExecuteFormBean.getTemplateCategoryId(), (Long)loginId, (String)fcExecuteFormBean.getDomainName(), (AdventNetResourceBundle)rb, (boolean)fcExecuteFormBean.getIsWorkFlowMode());
        fcExecuteFormBean.setDPValues(dpValues);
        FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, userData, fcExecuteFormBean.getDomainName(), rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
        Long defaultLayoutId_HDT = FcExecuteFormFlow.getDefaultLayoutId(loginId, fcExecuteFormBean.getTemplateCategoryId(), domainName, true, fcExecuteFormBean.getIsWorkFlowMode());
        FcLayout toClientExecuteLayout = new FcLayout(defaultLayoutId_HDT, rb, domainName);
        toClientExecuteLayout.removeUnConfiguredIamAppsFieldsList(authObject.getDelegatedLinkedDomains());
        toClientExecuteLayout.removeEmptyTab();
        FcFormDataContainer newToClientData = new FcFormDataContainer();
        newToClientData.init(toClientExecuteLayout);
        fcExecuteFormBean.setExecuteFormLayout(toClientExecuteLayout);
        if (FcLayoutViewHandler.isDomainNameEmpty((Long)defaultLayoutId_HDT)) {
            FcExecuteFormFlow.setDomainSpecificFieldValues(dpValues, newToClientData, fcExecuteFormBean.getDomainName(), rb, loginId, fcExecuteFormBean.getTemplateCategoryId());
        }
        FcExecuteFormFlow.setTemplateData(fcExecuteFormBean);
        if (!fcExecuteFormBean.getIsWorkFlowMode()) {
            FcExecuteFormFlow.fillAuthorizedFields(request, newToClientData, fcExecuteFormBean.getTemplateCategoryId(), domainName, fcExecuteFormBean.getActionId());
        }
        fcExecuteFormBean.setNamingFormatFields(FcExecuteFormFlow.getNamingFormatFields(newToClientData));
        fcExecuteFormBean.setFormatParticipatingFields(FcExecuteFormFlow.getFormatParticipatingFields(fcExecuteFormBean.getTemplateCategoryId(), newToClientData, fcExecuteFormBean.getNamingFormatFields()));
        fcExecuteFormBean.setMgmtRuleResultFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)defaultLayoutId_HDT, (boolean)false));
        fcExecuteFormBean.setMgmtRuleConditionFields(MgmtRuleHandler.getMgmtRuleFieldIds((Long)defaultLayoutId_HDT, (boolean)true));
        fcExecuteFormBean.setImmediateDupliationCheckFields(FcExecuteFormFlow.getImmediateDupliationCheckFields(newToClientData));
        FcExecuteFormFlow.applyTemplate(newToClientData, userData);
        fcExecuteFormBean.setToClientData(newToClientData);
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
        iMgmtHandler.updateFieldValuesToAttributes(newToClientData);
        Properties prop = new Properties();
        prop.put("domainName", fcExecuteFormBean.getDomainName());
        prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
        Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(newToClientData, prop);
        FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, fcExecuteFormBean.getNamingFormatFields(), newToClientData, userData);
        MgmtRuleFlow.applyMgmtRulesInLayout(toClientExecuteLayout.getLayoutId(), newToClientData, rb, fcExecuteFormBean.getTemplateData(), userData, fcExecuteFormBean.getADData());
        ArrayList list = null;
        list = fcExecuteFormBean.getIsWorkFlowMode() ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"") : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)fcExecuteFormBean.getTemplateCategoryId(), (String)fcExecuteFormBean.getDomainName(), (int)-1, (String)"");
        if (fcExecuteFormBean.getIsCopyAvailable()) {
            request.setAttribute("copyObjectDetails", (Object)FcLayoutViewHandler.getCopyObjectDetails((Long)fcExecuteFormBean.getTemplateCategoryId(), (AdventNetResourceBundle)rb).toString());
        }
        if (!fcExecuteFormBean.getIsTemplateAvailable()) {
            request.setAttribute("isTemplateAvailable", (Object)fcExecuteFormBean.getIsTemplateAvailable());
        }
        request.setAttribute("selectedTemplateId", (Object)defaultLayoutId_HDT.toString());
        String selectedLayoutName = FcLayoutUtil.getLayoutName((ArrayList)list, (Long)defaultLayoutId_HDT);
        request.setAttribute("selectedTemplateName", (Object)selectedLayoutName);
        request.setAttribute("templateListSize", (Object)list.size());
        request.setAttribute("selectedDomainName", (Object)domainName);
        this.log.log(Level.INFO, " Setting Domain Specific fields finished");
        return mapping.findForward("renderLayout");
    }

    public ActionForward setSelectedSubTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        IMgmtListener iMgmtListener = fcExecuteFormBean.getIMgmtListener();
        response.setContentType("application/json");
        try {
            int selectedSubTab = iMgmtListener.getSelectedSubTab();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("selectedSubTab", selectedSubTab);
            int lyncSelectedSubTab = iMgmtListener.getLyncSelectedSubTab();
            jsonObj.put("lyncSelectedSubTab", lyncSelectedSubTab);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getADValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, " Getting AD values for the Single Tab.");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        response.setContentType("application/json");
        try {
            String jsonString = request.getParameter("FcExecuteLayout");
            JSONObject fcLayoutJsonObj = new JSONObject();
            fcLayoutJsonObj = new JSONObject(jsonString);
            FcLayout executeLayout = new FcLayout();
            executeLayout.init(fcLayoutJsonObj);
            Long tabId = Long.parseLong(request.getParameter("tab"));
            FcLayoutTab fcRhsLayoutTab = executeLayout.getTabObject(tabId);
            FcExecuteFormFlow.getADValues(fcRhsLayoutTab, loginId, fcExecuteFormBean, request);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeLayout);
            FcFormDataContainer userData = fcExecuteFormBean.getUserData();
            IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
            iMgmtHandler.updateFieldsAttributes(fcExecuteFormBean.getToClientData());
            FcExecuteFormFlow.updateUserData(fcExecuteFormBean.getTemplateCategoryId(), fromClientData, fcExecuteFormBean.getToClientData(), userData);
            iMgmtHandler.updateFieldValuesToAttributes(fcExecuteFormBean.getToClientData());
            Properties prop = new Properties();
            prop.put("domainName", fcExecuteFormBean.getDomainName());
            if (fcExecuteFormBean.getDomainDNSName() != null) {
                prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
            }
            Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fcExecuteFormBean.getToClientData(), prop);
            ArrayList<Long> namingFormatFields = fcExecuteFormBean.getNamingFormatFields();
            String formattedNameJSONString = FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, namingFormatFields, fcExecuteFormBean.getToClientData(), fcExecuteFormBean.getUserData());
            String modifiedFieldsDetailsString = MgmtRuleFlow.applyMgmtRulesInLayout(fcExecuteFormBean.getExecuteFormLayout().getLayoutId(), fcExecuteFormBean.getToClientData(), rb, fcExecuteFormBean.getTemplateData(), fcExecuteFormBean.getUserData(), fcExecuteFormBean.getADData());
            iMgmtHandler.updateFieldsAttributes(fromClientData);
            fcExecuteFormBean.setToClientData(fromClientData);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("Tab", (Object)fcRhsLayoutTab.serializeToJsonString());
            jsonObj.put("namingFormatResult", (Object)formattedNameJSONString);
            jsonObj.put("mgmtRuleResult", (Object)modifiedFieldsDetailsString);
            PrintWriter writer = response.getWriter();
            writer.print(EscapeUtil.escSplCharsAsHTML((Object)jsonObj.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward searchTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            int totalTemplateCount;
            String workflowStatusString;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Boolean isWorkFlowMode = new Boolean(request.getParameter("isWorkFlowMode"));
            Integer workflowStaus = -1;
            if (isWorkFlowMode.booleanValue() && (workflowStatusString = request.getParameter("workflowStatus")) != null && !workflowStatusString.equals("-1")) {
                workflowStaus = Integer.parseInt(request.getParameter("workflowStatus"));
            }
            Long taskDetailsId = null;
            if (request.getParameter("taskDetailsId") != null && !request.getParameter("taskDetailsId").equals("null")) {
                taskDetailsId = Long.parseLong(request.getParameter("taskDetailsId"));
            }
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String domainName = request.getParameter("domainName");
            Long templateCategoryId = new Long(request.getParameter("templateCategoryId"));
            Long pageNumber = 1L;
            if (request.getParameter("pageNumber") != null) {
                pageNumber = Long.parseLong(request.getParameter("pageNumber"));
            }
            ArrayList list = null;
            list = isWorkFlowMode != false ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)-1, (String)"", (Integer)workflowStaus, (Long)taskDetailsId) : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)-1, (String)"");
            int searchTemplateCount = totalTemplateCount = list.size();
            String searchText = request.getParameter("searchText");
            if (searchText != null && !searchText.equals("")) {
                searchText = request.getParameter("searchText");
                list = isWorkFlowMode != false ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)-1, (String)searchText, (Integer)workflowStaus, (Long)taskDetailsId) : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)-1, (String)searchText);
                searchTemplateCount = list.size();
            }
            int range = 10;
            Long startIndex = (pageNumber - 1L) * (long)range + 1L;
            int totalPages = searchTemplateCount / range;
            if (searchTemplateCount % range != 0) {
                ++totalPages;
            }
            if (searchText == null) {
                searchText = "";
            }
            ArrayList templateList = null;
            templateList = isWorkFlowMode != false ? FcLayoutViewHandler.getTemplateNamesForWorkflow((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)startIndex.intValue(), (String)searchText, (Integer)workflowStaus, (Long)taskDetailsId) : FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)templateCategoryId, (String)domainName, (int)startIndex.intValue(), (String)searchText);
            ByteArrayOutputStream outNode = this.searchTemplateXMLElement(templateList, rb, totalPages, totalTemplateCount, searchTemplateCount);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ByteArrayOutputStream searchTemplateXMLElement(ArrayList<Properties> templateList, AdventNetResourceBundle rb, int totalPages, int totalRecordsCount, int searchRecordsCount) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            String searchTemplateResult = "";
            if (templateList != null && !templateList.isEmpty()) {
                searchTemplateResult = searchTemplateResult + "<table width='300' border='0' cellspacing='0' cellpadding='5' bgcolor='#ECF3F8'> ";
                for (Properties templateDetailProp : templateList) {
                    Long tempID = (Long)templateDetailProp.get("LAYOUT_ID");
                    String tempName = ClientUtil.htmlEscape(rb.getString((String)templateDetailProp.get("LAYOUT_NAME")));
                    searchTemplateResult = searchTemplateResult + "<tr> <td><input type='radio' name='templates' value='" + tempID + "'><span class='blacktxt1'>" + tempName + "</span></td><td>&nbsp;</td></tr>";
                }
                searchTemplateResult = searchTemplateResult + "</table>";
            }
            Element templateResultElt = document.createElement("templateResultElt");
            templateResultElt.setAttribute("searchTemplateResult", searchTemplateResult);
            data.appendChild(templateResultElt);
            Element templateSizeElt = document.createElement("templateSizeElt");
            templateSizeElt.setAttribute("templateListSize", Integer.toString(searchRecordsCount));
            data.appendChild(templateSizeElt);
            Element totalPagesElt = document.createElement("totalPagesElt");
            totalPagesElt.setAttribute("totalPages", Integer.toString(totalPages));
            data.appendChild(totalPagesElt);
            Element totalRecordsCountElt = document.createElement("totalRecordsCountElt");
            totalRecordsCountElt.setAttribute("totalRecordsCount", Integer.toString(totalRecordsCount));
            data.appendChild(totalRecordsCountElt);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public ActionForward members(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "members";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String operation = request.getParameter("operation");
            String domainName = request.getParameter("domainName");
            String groupType = request.getParameter("groupType");
            String groupScope = request.getParameter("groupScope");
            String fieldId = request.getParameter("fieldId");
            if (operation != null && operation.equals("csvImport")) {
                forward = "csvList";
                FcExecuteFormFlow.csvImport(request, rb);
            }
            if (domainName != null) {
                request.setAttribute("domainName", (Object)domainName);
            }
            request.setAttribute("groupType", (Object)groupType);
            request.setAttribute("groupScope", (Object)groupScope);
            if (fieldId != null) {
                request.setAttribute("fieldId", (Object)fieldId);
            }
            if (request.getParameter("componentId") != null) {
                request.setAttribute("componentId", (Object)Long.parseLong(request.getParameter("componentId")));
            }
        }
        catch (Exception e) {
            request.setAttribute("csvList", new ArrayList());
            request.setAttribute("errorMessage", (Object)e.getMessage());
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward validateSelected(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        boolean isWorkFlowMode = fcExecuteFormBean.getIsWorkFlowMode();
        String keyLdapName = request.getParameter("keyLdapName");
        String domainName = request.getParameter("domainName");
        String selectedDomain = request.getParameter("selectedDomain");
        String groupType = request.getParameter("groupType");
        String groupScope = request.getParameter("groupScope");
        String[] validSelected = request.getParameterValues("validSelected" + keyLdapName);
        Properties prop = new Properties();
        prop.put("validList", new ArrayList());
        prop.put("notExistsList", new ArrayList());
        prop.put("membersList", new Hashtable());
        prop.put("componentId", new Long(request.getParameter("componentId")));
        boolean crossDomain = false;
        if (!domainName.equals(selectedDomain)) {
            crossDomain = true;
        }
        if (validSelected != null && keyLdapName != null) {
            FcExecuteFormFlow.validateAndFillList(prop, validSelected, keyLdapName, loginId, selectedDomain, groupType, groupScope, crossDomain, isWorkFlowMode);
        }
        request.setAttribute("validList", (Object)((ArrayList)prop.get("validList")));
        request.setAttribute("notExistsList", (Object)((ArrayList)prop.get("notExistsList")));
        request.setAttribute("membersList", (Object)((Hashtable)prop.get("membersList")));
        return mapping.findForward("validatedList");
    }

    public ActionForward copyObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, "Copy Object Started ");
        Long templateCategoryId = 1L;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String objectGUID = request.getParameter("objectGUID");
            String jsonString = request.getParameter("FcExecuteLayout");
            Boolean isExecutionPage = Boolean.valueOf(request.getParameter("isExecutionPage"));
            JSONObject fcLayoutJsonObj = new JSONObject(jsonString);
            FcLayout executeLayout = new FcLayout();
            executeLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeLayout);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            FcFormDataContainer copiedDataContainer = CopyObjectExecuteFlow.getCopyObjectValues(fromClientData, isExecutionPage, loginId, fcExecuteFormBean, objectGUID);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(copiedDataContainer.serializeToJsonObject().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getCopyObjectPreviewPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.log.log(Level.INFO, "Copy Object Preview started ");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String returnString = "CustomizePage";
        try {
            String objectGUID = request.getParameter("objectGUID");
            Boolean isExecutionPage = Boolean.valueOf(request.getParameter("isExecutionPage"));
            String jsonString = request.getParameter("FcExecuteLayout");
            JSONObject fcLayoutJsonObj = new JSONObject(jsonString);
            FcLayout executeLayout = new FcLayout();
            executeLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeLayout);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            String attributeList = request.getParameter("AttributeList");
            if (attributeList != null) {
                returnString = "previewPage";
                ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(attributeList.split(",")));
                CopyObjectUtil.saveCopyFields((Long)templateCategoryId, (Long)loginId, fieldList);
            } else {
                JSONArray layoutTabFieldsJsonArray = CopyObjectUtil.getFieldOptionsList((String)jsonString, (Boolean)isExecutionPage, (Long)templateCategoryId, (Long)loginId);
                request.setAttribute("layoutTabFieldsJsonArray", (Object)layoutTabFieldsJsonArray);
            }
            FcFormDataContainer copiedDataContainer = CopyObjectExecuteFlow.getCopyObjectValues(fromClientData, isExecutionPage, loginId, fcExecuteFormBean, objectGUID);
            JSONArray fieldsPreviewJsonArray = CopyObjectExecuteFlow.getCopyObjectPreivewPageView(copiedDataContainer, rb);
            request.setAttribute("fieldsPreviewArray", (Object)fieldsPreviewJsonArray);
            request.setAttribute("fieldsArray", (Object)copiedDataContainer.serializeToJsonObject().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(returnString);
    }

    public ActionForward getMemberList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] validSelected = request.getParameterValues("validSelected");
        String[] notExistsSelected = request.getParameterValues("notExistsSelected");
        String[] moreNosSelected = request.getParameterValues("moreNosSelected");
        Hashtable members = new Hashtable();
        if (validSelected != null) {
            FcExecuteFormFlow.setMembersList(request, members, validSelected, true);
        }
        if (notExistsSelected != null) {
            FcExecuteFormFlow.setMembersList(request, members, notExistsSelected, false);
        }
        if (moreNosSelected != null) {
            FcExecuteFormFlow.setMembersList(request, members, moreNosSelected, false);
        }
        request.setAttribute("members", members);
        return mapping.findForward("validatedList");
    }

    public ActionForward getNewFilterField(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("fieldId", (Object)new Long(request.getParameter("fieldId")));
        request.setAttribute("fieldOrder", (Object)new Integer(request.getParameter("fieldOrder")));
        request.setAttribute("filterFieldId", (Object)new Long(request.getParameter("filterFieldId")));
        return mapping.findForward("createFilterField");
    }

    public ActionForward getSupportedMatchCriterias(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long fieldId = new Long(request.getParameter("fieldId"));
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        response.setContentType("application/json");
        try {
            JSONArray supportedMatchCriteriasArray = new JSONArray();
            supportedMatchCriteriasArray = fieldId.compareTo(-1L) == 0 ? FcRecipientFilterUtil.getAllMatchCriterias((AdventNetResourceBundle)rb) : FcRecipientFilterUtil.getSupportedMatchCriterias((Long)fieldId, (AdventNetResourceBundle)rb);
            PrintWriter writer = response.getWriter();
            writer.print(supportedMatchCriteriasArray.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(null);
    }

    public ActionForward getFilterFieldComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String fieldDetailsStr = request.getParameter("fieldDetailsStr");
        String domainName = request.getParameter("domainName");
        Long filterFieldId = new Long(request.getParameter("filterFieldId"));
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            JSONObject fieldDetailsJsonObj = new JSONObject(fieldDetailsStr);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject componentDetailsObj = FcRecipientFilterUtil.getComponentDetails((JSONObject)fieldDetailsJsonObj, (String)domainName, (Long)loginId, (AdventNetResourceBundle)rb);
            request.setAttribute("componentDetails", (Object)componentDetailsObj.toString());
            request.setAttribute("filterFieldId", (Object)filterFieldId);
            request.setAttribute("defaultComponentId", (Object)fieldDetailsJsonObj.getLong("defaultComponentId"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("filterFieldValue");
    }

    public ActionForward checkForDuplicate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String jsonString = request.getParameter("FcExecuteLayout");
        JSONObject fcLayoutJsonObj = new JSONObject();
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            fcLayoutJsonObj = new JSONObject(jsonString);
            String templaateCategoryId = (String)fcLayoutJsonObj.get("templateCategoryId");
            FcLayout executeLayout = new FcLayout();
            executeLayout.init(fcLayoutJsonObj);
            FcFormDataContainer fromClientData = new FcFormDataContainer();
            fromClientData.init(executeLayout);
            FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
            Long templateCategoryId = fcExecuteFormBean.getTemplateCategoryId();
            Map m = FcExecuteFormFlow.getDuplicateList(fcExecuteFormBean, fromClientData, loginId, rb, templaateCategoryId);
            JSONObject jsonObject = new JSONObject(m);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getFormattedNameJSONString(HttpServletRequest request) throws Exception, JSONException {
        String jsonString = request.getParameter("FcExecuteLayout");
        JSONObject fcLayoutJsonObj = new JSONObject();
        fcLayoutJsonObj = new JSONObject(jsonString);
        FcLayout executeLayout = new FcLayout();
        executeLayout.init(fcLayoutJsonObj);
        FcFormDataContainer fromClientData = new FcFormDataContainer();
        fromClientData.init(executeLayout);
        HttpSession session = request.getSession();
        FcExecuteFormBean fcExecuteFormBean = (FcExecuteFormBean)session.getAttribute("FcExecuteFormBean");
        FcFormDataContainer userData = fcExecuteFormBean.getUserData();
        FcExecuteFormFlow.updateUserData(fcExecuteFormBean.getTemplateCategoryId(), fromClientData, fcExecuteFormBean.getToClientData(), userData);
        IMgmtHandler iMgmtHandler = FcExecuteFormFlow.getMgmtHandlerInstance(fcExecuteFormBean.getTemplateCategoryId());
        iMgmtHandler.updateFieldsAttributes(fromClientData);
        iMgmtHandler.updateFieldValuesToAttributes(fromClientData);
        Properties prop = new Properties();
        prop.put("domainName", fcExecuteFormBean.getDomainName());
        prop.put("domainDNSName", fcExecuteFormBean.getDomainDNSName());
        Properties ldapVsValueProps = iMgmtHandler.getLdapVsValues(fromClientData, prop);
        ArrayList<Long> namingFormatFields = fcExecuteFormBean.getNamingFormatFields();
        String formattedNameJSONString = FcExecuteFormFlow.applyNamingFormat(ldapVsValueProps, namingFormatFields, fromClientData, userData);
        fcExecuteFormBean.setToClientData(fromClientData);
        return formattedNameJSONString;
    }
}

