/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.component.FcLogonName;
import com.adventnet.sym.adsm.common.server.layout.component.FcNamingFormat;
import com.adventnet.sym.adsm.common.server.layout.component.FcSamAccountName;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class FcFormatClientUtil {
    public static void setFcNamingFormats(HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long templateCategoryId = null;
        if (request.getParameter("templateCategoryId") != null) {
            templateCategoryId = new Long(request.getParameter("templateCategoryId"));
        }
        FcFormatClientUtil.setFcNamingFormats(templateCategoryId, rb);
    }

    public static void setFcNamingFormats(Long templateCategoryId, AdventNetResourceBundle rb) {
        Hashtable<String, ArrayList> hashtable = FcFormatClientUtil.getNamingFormats(templateCategoryId, rb);
        ArrayList formatDisplayList = hashtable.get("displayList");
        ArrayList formatValueList = hashtable.get("valueList");
        Hashtable<String, ArrayList> ruleHashtable = FormatClientUtil.getNamingFormatRules(rb);
        ArrayList ruleDisplayList = ruleHashtable.get("displayList");
        ArrayList ruleValueList = ruleHashtable.get("valueList");
        ArrayList list = new ArrayList();
        Hashtable<String, ArrayList> formatListTable = new Hashtable<String, ArrayList>();
        ArrayList formatList = (ArrayList)formatDisplayList.clone();
        formatList.add(0, rb.getString("admp.common.text.Empty"));
        formatListTable.put("format", formatList);
        list.add(formatListTable);
        Hashtable<String, ArrayList> ruleListTable = new Hashtable<String, ArrayList>();
        ArrayList ruleList = (ArrayList)ruleDisplayList.clone();
        ruleListTable.put("rule", ruleList);
        list.add(ruleListTable);
        FcNamingFormat.setFormatNames(list);
        list = new ArrayList();
        formatListTable = new Hashtable();
        formatList = (ArrayList)formatValueList.clone();
        formatList.add(0, -1L);
        formatListTable.put("format", formatList);
        list.add(formatListTable);
        ruleListTable = new Hashtable();
        ruleList = (ArrayList)ruleValueList.clone();
        ruleListTable.put("rule", ruleList);
        list.add(ruleListTable);
        FcNamingFormat.setFormatValues(list);
        Hashtable<Long, String> formatIdVsName = new Hashtable<Long, String>();
        Hashtable<Long, String> formatIdVsValue = new Hashtable<Long, String>();
        FcFormatClientUtil.getFormatIdVsNameAndValues(rb, formatIdVsName, formatIdVsValue);
        FcNamingFormat.setFormatIdVsName(formatIdVsName);
        FcNamingFormat.setFormatIdVsValue(formatIdVsValue);
    }

    public static Hashtable<Long, String> getFormatIdVsNameAndValues(AdventNetResourceBundle rb, Hashtable<Long, String> formatIdVsName, Hashtable<Long, String> formatIdVsValue) {
        try {
            Row row;
            Iterator ite;
            Criteria crit = null;
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormats", crit);
            if (!dataObj.isEmpty()) {
                ite = dataObj.getRows("ADSMFormats");
                while (ite.hasNext()) {
                    row = (Row)ite.next();
                    formatIdVsName.put((Long)row.get("FORMAT_ID"), rb.getString(row.get("FORMAT_DISPLAY_NAME").toString()));
                    formatIdVsValue.put((Long)row.get("FORMAT_ID"), rb.getString(row.get("FORMAT_VALUE").toString()));
                }
            }
            formatIdVsName.put(-1L, rb.getString("admp.common.text.Empty"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatRules", crit);
            if (!dataObj.isEmpty()) {
                ite = dataObj.getRows("ADSMFormatRules");
                while (ite.hasNext()) {
                    row = (Row)ite.next();
                    formatIdVsName.put((Long)row.get("FORMAT_ID"), rb.getString(row.get("RULE_NAME").toString()));
                    formatIdVsValue.put((Long)row.get("FORMAT_ID"), "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formatIdVsName;
    }

    public static Hashtable<String, ArrayList> getNamingFormats(Long templateCategoryId, AdventNetResourceBundle rb) {
        DataObject dataobject = null;
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        ArrayList<String> displayList = new ArrayList<String>();
        ArrayList<Long> valueList = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMFormats", (String)"FORMAT_ID"), (Object)0L, 5);
            if (templateCategoryId != null) {
                if (templateCategoryId.equals(FcExecuteActionConstants.groupCreationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.dlGroupCreationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.groupModificationTemplateCategoryId)) {
                    criteria = criteria.or(new Criteria(Column.getColumn((String)"ADSMFormats", (String)"FORMAT_ID"), (Object)-2L, 0));
                } else if (templateCategoryId.equals(FcExecuteActionConstants.userCreationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.userModificationTemplateCategoryId)) {
                    criteria = criteria.or(new Criteria(Column.getColumn((String)"ADSMFormats", (String)"FORMAT_ID"), (Object)0L, 0));
                } else if (templateCategoryId.equals(FcExecuteActionConstants.sharedMailboxCreationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.linkedMailboxCreationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.sharedMailboxModificationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.roomMailboxCreationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.roomMailboxModificationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.equipmentMailboxCreationTemplateCategoryId) || templateCategoryId.equals(FcExecuteActionConstants.equipmentMailboxModificationTemplateCategoryId)) {
                    criteria = criteria.or(new Criteria(Column.getColumn((String)"ADSMFormats", (String)"FORMAT_ID"), (Object)-3L, 0));
                }
            }
            dataobject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormats", criteria);
            Iterator iterator = dataobject.getRows("ADSMFormats");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                displayList.add(rb.getString((String)row.get("FORMAT_DISPLAY_NAME")));
                Long formatId = (Long)row.get("FORMAT_ID");
                valueList.add(formatId);
            }
            hashtable.put("displayList", displayList);
            hashtable.put("valueList", valueList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashtable;
    }

    public static Long getMathcingField(String ldapName, FcFormDataContainer toClientData) {
        Enumeration e = toClientData.elements();
        while (e.hasMoreElements()) {
            FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
            ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
            for (FcAttributes fcAttribute : fcAttributesList) {
                if (!ldapName.equalsIgnoreCase(fcAttribute.getAttribLdapName())) continue;
                return fcLayoutField.getFieldId();
            }
        }
        return null;
    }

    public static ArrayList getNamingFormatLdapNames(FcFormDataContainer fcFormDataContainer) {
        ArrayList<String> ldapNamesArray = new ArrayList<String>();
        try {
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                String format = "";
                if (fcLayoutField.getComponentId().intValue() == 9) {
                    FcNamingFormat fcNamingFormat = (FcNamingFormat)fcLayoutField.getIComponent();
                    format = fcNamingFormat.getFormatValue();
                } else if (fcLayoutField.getComponentId().intValue() == 24) {
                    FcLogonName fcLogonName = (FcLogonName)fcLayoutField.getIComponent();
                    format = fcLogonName.getFormatValue();
                } else if (fcLayoutField.getComponentId().intValue() == 25) {
                    FcSamAccountName fcSamAccountName = (FcSamAccountName)fcLayoutField.getIComponent();
                    format = fcSamAccountName.getFormatValue();
                }
                boolean prevIndex = false;
                int index = format.indexOf("%");
                while (index != -1) {
                    int nextIndex = format.indexOf("%", index + 1);
                    if (nextIndex != -1) {
                        String ldapName = format.substring(index + 1, nextIndex);
                        if (!ldapNamesArray.contains(ldapName)) {
                            ldapNamesArray.add(ldapName);
                        }
                        index = format.indexOf("%", nextIndex + 1);
                        continue;
                    }
                    index = nextIndex;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ldapNamesArray;
    }
}

