/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcGroupMgmtHandler;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcNativeProperties;
import com.adventnet.sym.adsm.common.server.layout.component.FcManager;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcADMgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class FcGroupCreationListener
extends FcADMgmtListener {
    String groupName = null;
    String groupType = null;
    String ouName = null;
    ArrayList groupList = null;
    ArrayList membersList = null;
    Properties nativeStatusProps = new Properties();
    Hashtable auditLogProps = new Hashtable();
    ArrayList<Hashtable> customList;
    String customScriptResult = "";

    public FcGroupCreationListener() {
        this.defaultGroupRID = "";
        this.objectType = "group";
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.doAction(creationId, domainName, executeLayout, fromClientData, userData, adData, fcIamApps, loginId);
    }

    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.createGroup();
    }

    private ArrayList<Hashtable> updateCustomAttributeProperties(FcFormDataContainer fromClientData) {
        ArrayList<Hashtable> customListTemp = new ArrayList<Hashtable>();
        try {
            FcFormDataContainer customFieldsContainer = new FcFormDataContainer();
            Properties prop = new Properties();
            prop.put("domainName", this.domainName);
            Properties ldapVsValueProps = FcGroupMgmtHandler.getInstance().getLdapVsValues(fromClientData, prop);
            customFieldsContainer.splitCustomFields(fromClientData);
            FcGroupMgmtHandler.getInstance().updateFieldsAttributes(customFieldsContainer);
            FcGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(customFieldsContainer);
            customListTemp = this.getCustomAttribsProperties(customFieldsContainer, false, ldapVsValueProps, "group");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return customListTemp;
    }

    public void createGroup() {
        try {
            Properties customScriptProps;
            boolean isLicenseExceeded;
            mgmtLog.log(Level.INFO, " FcGroupCreation Started ");
            FcGroupMgmtHandler.getInstance().updateFieldsTableName(this.fromClientData);
            FcGroupMgmtHandler.getInstance().initDataObjForFieldsToAttributes();
            FcGroupMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
            FcGroupMgmtHandler.getInstance().updateFieldsActionId(this.fromClientData);
            FcGroupMgmtHandler.getInstance().updateDefaultComponentId(this.fromClientData);
            FcGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
            this.customList = this.updateCustomAttributeProperties(this.fromClientData);
            this.addAttributeToNativeProps(this.fromClientData);
            Properties props = this.fcNativeProperties.getProps();
            this.groupName = props.getProperty("name");
            this.ouName = props.getProperty("OUName");
            if (this.isBulkMgmt && this.commonContainerName != null && !this.commonContainerName.equals("")) {
                this.ouName = this.commonContainerName;
            }
            if (!HelpdeskUtil.isAuthorizedOU((String)this.domainName, (Long)this.loginId, (String)this.ouName)) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), this.ouName));
                return;
            }
            this.groupList = this.fcNativeProperties.getGroupList();
            if (this.groupName == null) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occurred"));
                return;
            }
            String escapedGroupName = CommonUtil.escapeString((String)this.groupName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
            String distinguishedName = "CN=" + escapedGroupName + "," + this.ouName;
            String adminGroup = null;
            String mailAlias = null;
            boolean isMailEnabled = false;
            Boolean isPowerShellEnabled = false;
            if (props.get("adminGroup") != null || props.get("adminGroup") != "") {
                adminGroup = props.getProperty("adminGroup");
            }
            if (props.get("mailAlias") != null) {
                mailAlias = props.getProperty("mailAlias");
            }
            if (adminGroup != null && mailAlias != null) {
                isMailEnabled = true;
                isPowerShellEnabled = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
            }
            if (isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"groupMgmt")) {
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                return;
            }
            if (isMailEnabled) {
                ArrayList<String> nonExchAttrList = new ArrayList<String>();
                nonExchAttrList.add("groupType");
                nonExchAttrList.add("name");
                nonExchAttrList.add("sAMAccountName");
                nonExchAttrList.add("cn");
                nonExchAttrList.add("name");
                ArrayList propList = this.fcNativeProperties.getPropList();
                ArrayList nonExchPropList = this.fcNativeProperties.getNonExchAttributeList();
                int propCount = propList.size();
                for (int ind1 = 0; ind1 < propCount; ++ind1) {
                    String ldapName = (String)((Hashtable)propList.get(ind1)).get("ATTRIB_LDAP_NAME");
                    if (nonExchAttrList.contains(ldapName)) {
                        nonExchPropList.add(propList.get(ind1));
                        continue;
                    }
                    if (this.msExchPoliciesExcluded || !ldapName.equalsIgnoreCase("proxyAddresses")) continue;
                    nonExchPropList.add(propList.get(ind1));
                    propList.remove(ind1);
                    --propCount;
                    --ind1;
                }
            }
            mgmtLog.log(Level.INFO, " Group Creation : domainName " + this.domainName);
            mgmtLog.log(Level.INFO, " LoginId  " + this.loginId);
            mgmtLog.log(Level.INFO, " OU Name :" + this.ouName);
            mgmtLog.log(Level.INFO, " User Name :" + this.groupName);
            mgmtLog.log(Level.INFO, " getPropsList " + this.fcNativeProperties.getPropList());
            mgmtLog.log(Level.INFO, " nonExchPropList " + this.fcNativeProperties.getNonExchAttributeList());
            mgmtLog.log(Level.INFO, " modifyList " + this.fcNativeProperties.getModifyList());
            mgmtLog.log(Level.INFO, " GroupsList " + this.groupList);
            mgmtLog.log(Level.INFO, " crossForestMembersList " + this.crossForestMembersList);
            this.statusObject = isMailEnabled ? ADHandler.addGroup((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)escapedGroupName, (ArrayList)this.fcNativeProperties.getNonExchAttributeList(), (ArrayList)this.groupList) : ADHandler.addGroup((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)escapedGroupName, (ArrayList)this.fcNativeProperties.getPropList(), (ArrayList)this.groupList);
            this.nativeStatusProps = this.isBulkMgmt ? this.getBulkGroupErrorMessage(this.statusObject, escapedGroupName) : this.getSingleGroupErrorMessage(this.statusObject, escapedGroupName);
            String CREATION_STATUS = this.nativeStatusProps.getProperty("CREATION_STATUS");
            String searchName = CommonUtil.escapeSpecialCharacters((String)this.groupName);
            String searchString = "(&(objectClass=group)(objectCategory=Group)(name=" + searchName + "))";
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && !this.customList.isEmpty()) {
                NativeError modifyCustomPropError = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, this.customList, null, (boolean)false);
                if (!this.isBulkMgmt) {
                    AddUserErrorHandler.setSingleUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)modifyCustomPropError, (String)searchString);
                } else {
                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)this.rb, (Properties)this.nativeStatusProps, (NativeError)modifyCustomPropError, (String)searchString);
                }
            }
            if (props.get("sendAs") != null) {
                Hashtable sendAsResultHash = new Hashtable();
                String sendAsErrorMsg = "";
                ArrayList sendAsSidList = (ArrayList)props.get("sendAs");
                sendAsResultHash = this.updateSendAsAttribute(sendAsSidList, distinguishedName, "add");
                sendAsErrorMsg = this.getErrorStringForSendAs(sendAsResultHash, sendAsErrorMsg);
                if (sendAsErrorMsg.trim().length() > 0) {
                    if (!this.isBulkMgmt) {
                        this.setSingleUserErrorMessage(sendAsErrorMsg);
                    } else {
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.rb.getString(sendAsErrorMsg));
                    }
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                String managerDN;
                String managerCanUpdate;
                distinguishedName = "CN=" + escapedGroupName + "," + this.ouName;
                if (!this.crossForestMembersList.isEmpty()) {
                    Hashtable errHash = this.addCrossForestMembers(distinguishedName, this.nativeStatusProps);
                }
                if (isMailEnabled) {
                    if (isPowerShellEnabled.booleanValue()) {
                        String hideFromAddrListErr;
                        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)this.domainName, (String)adminGroup, (Long)this.loginId);
                        String createDistGroupErr = ADHandler.createDistributionGroup2007((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)mailAlias, (Properties)exchangeServerDetails);
                        if (createDistGroupErr.trim().length() > 0) {
                            this.rusMessage = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.mail_enabled"), this.rb.getString(createDistGroupErr)) + this.rb.getString("admp.mgmt.common.statmsg.click_here_trobuleshoot");
                        } else if (props.get("msExchHideFromAddressLists") != null && props.getProperty("msExchHideFromAddressLists").equalsIgnoreCase("true") && (hideFromAddrListErr = ADHandler.setExchangeAttribute((String)this.domainName, (long)this.loginId, (String)distinguishedName, (String)"group", (String)"true", (Properties)exchangeServerDetails)).trim().length() > 0) {
                            ArrayList messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                            if (messageList == null) {
                                messageList = new ArrayList();
                            }
                            Hashtable<String, String> errorHash = new Hashtable<String, String>();
                            errorHash.put("ERROR_MESSAGE", hideFromAddrListErr);
                            messageList.add(errorHash);
                            this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
                            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                        }
                    }
                    NativeError modifyExchPropError = ADHandler.searchAndModifyGroup((String)this.domainName, (Long)this.loginId, (String)this.ouName, (String)searchString, null, (ArrayList)this.fcNativeProperties.getPropList(), null, (boolean)false);
                    this.setSingleGroupErrorMessage(modifyExchPropError, searchString);
                }
                if ("true".equalsIgnoreCase(managerCanUpdate = (String)props.get("managerCanUpdate")) && (managerDN = (String)props.get("manager")) != null) {
                    ArrayList<String> everyOneTrusteeList = new ArrayList<String>();
                    everyOneTrusteeList.add(UserMgmtUtil.getSIDFromDN((String)DomainUtil.getDomainNamefromDN((String)managerDN), (String)managerDN));
                    ArrayList aceList = new ArrayList();
                    Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
                    aceHash.put("ACCESS_MASK", 32L);
                    aceHash.put("PERMISSION_GUID", "{BF9679C0-0DE6-11D0-A285-00AA003049E2}");
                    aceHash.put("INHERIT_TYPE_FLAG", new Long(0L));
                    aceHash.put("ACE_ID", new Long(1L));
                    aceHash.put("ACE_TYPE", 5L);
                    aceHash.put("operation", "add");
                    aceList.add(aceHash);
                    ADHandler.delegateTemplate((String)this.domainName, (Long)this.loginId, aceList, everyOneTrusteeList, (String)distinguishedName);
                }
            }
            if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && this.removedProxyAddresses.size() > 0) {
                StringBuilder proxyError = new StringBuilder();
                for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                    Hashtable hash = (Hashtable)this.removedProxyAddresses.get(index);
                    if (index > 0) {
                        proxyError.append(", ");
                    }
                    String proxyAddress = (String)hash.get("PROXY_ADDRESS");
                    String assignedUserName = (String)hash.get("USER_NAME");
                    proxyError.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_proxy_already_exist_for_the_user"), proxyAddress, assignedUserName));
                }
                String proxyErrorString = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.error_str.error_removed_proxy_addresses"), proxyError.toString());
                if (this.isBulkMgmt) {
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + proxyErrorString);
                } else {
                    Hashtable<String, String> errorHash = new Hashtable<String, String>();
                    errorHash.put("ERROR_MESSAGE", proxyErrorString);
                    errorHash.put("NATIVE_ERROR_MESSAGE", ".");
                    if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                        ArrayList<Hashtable<String, String>> errorList = new ArrayList<Hashtable<String, String>>();
                        errorList.add(errorHash);
                        this.nativeStatusProps.put("CREATION_MESSAGE", errorList);
                    } else {
                        for (int index = 0; index < this.removedProxyAddresses.size(); ++index) {
                            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(errorHash);
                        }
                    }
                }
                this.nativeStatusProps.setProperty("CREATION_STATUS", "WARNING");
                this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
                this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            }
            ArrayList propList = this.fcNativeProperties.getPropList();
            if (!CREATION_STATUS.equals("SEVERE") && props.get("preventDeletion") != null) {
                String preventDeletion = (String)props.get("preventDeletion");
                if (preventDeletion.equalsIgnoreCase("true")) {
                    this.updatePreventDeletion(distinguishedName, "add");
                    String defaultNamingcontext = DomainUtil.getDefaultNamingContext((String)this.domainName);
                    if (!this.ouName.equalsIgnoreCase(defaultNamingcontext)) {
                        this.updateParent(this.ouName);
                    }
                }
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                grpList.put("ATTRIB_VALUE", (String)props.get("preventDeletion"));
                propList.add(grpList);
            }
            if ((customScriptProps = (Properties)props.get("customScriptDetails")) != null) {
                boolean ignoreWarning = (Boolean)customScriptProps.get("IGNORE_WARNING");
                if (CREATION_STATUS.equalsIgnoreCase("SUCCESS") || ignoreWarning && CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                    this.customScriptResult = this.customScriptExecution(customScriptProps);
                    if (this.isBulkMgmt && this.customScriptResult != null && !this.customScriptResult.equals("")) {
                        this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.nativeStatusProps.getProperty("CREATION_MESSAGE") + " " + this.customScriptResult);
                    }
                }
            }
            mgmtLog.log(Level.INFO, " FcGroupCreation Listener finished ");
        }
        catch (Exception e) {
            mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
            e.printStackTrace();
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            this.nativeStatusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            if (this.isBulkMgmt) {
                this.nativeStatusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.internal_error"));
            }
            Hashtable<String, String> exceptionHash = new Hashtable<String, String>();
            exceptionHash.put("ERROR_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.internal_error"));
            exceptionHash.put("NATIVE_ERROR_MESSAGE", ".");
            ((ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE")).add(exceptionHash);
        }
    }

    public void preMgmtActions() throws Exception {
        FcGroupMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
        FcGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcGroupMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        this.customFieldsContainer = new FcFormDataContainer();
        this.customFieldsContainer.splitCustomFields(this.fromClientData);
        FcGroupMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
        FcGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
        FcNativeProperties fcNativeProperties = this.fcNativeProperties;
        this.getProperties(false, this.fromClientData, fcNativeProperties, ldapVsValueProps, "group");
        Properties props = fcNativeProperties.getProps();
        this.groupName = props.getProperty("userName");
        this.ouName = props.getProperty("OUName");
    }

    @Override
    public Long createRequest(String domainName, JSONObject wfCreateRequestJson, FcFormDataContainer fromClientData, FcFormDataContainer userData, Long loginId, Long layoutId, FcLayout executeFormLayout, Long templateCategoryId) {
        boolean isRequestCreated = false;
        Long requestId = -1L;
        try {
            this.domainName = domainName;
            this.fromClientData = fromClientData;
            this.userData = userData;
            this.loginId = loginId;
            Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
            if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
                return -1L;
            }
            this.preMgmtActions();
            Long objectCreationId = FcExecuteFormFlow.getNewObjectCreationId();
            Long objectIndexId = FcExecuteFormFlow.getNewObjectIndexId(objectCreationId, layoutId);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            this.creationId = objectCreationId;
            this.objectIndexId = objectIndexId;
            FcGroupMgmtHandler.getInstance().updateFieldsAttributes(fromClientData);
            FcGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(fromClientData);
            FcGroupMgmtHandler.getInstance().updateFieldsAttributes(this.customFieldsContainer);
            FcGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(this.customFieldsContainer);
            FcGroupMgmtHandler.getInstance().updateFieldsAttributes(userData);
            FcGroupMgmtHandler.getInstance().updateFieldValuesToAttributes(userData);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.userDataId, userData, FcExecuteActionConstants.groupCreationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, fromClientData, FcExecuteActionConstants.groupCreationTemplateCategoryId);
            FcBulkExecuteFormFlow.fillDataObject(dataObj, objectIndexId, FcExecuteActionConstants.resultDataId, this.customFieldsContainer, FcExecuteActionConstants.groupCreationTemplateCategoryId);
            JSONArray selectedIamAppsJsonArray = executeFormLayout.getSelectedIamAppsJsonArray();
            FcLayoutBulkViewHandler.addSelectedIamAppsRow((DataObject)dataObj, (Long)objectIndexId, (int)FcExecuteActionConstants.resultDataId, (JSONArray)selectedIamAppsJsonArray, (Long)templateCategoryId);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            String containerName = FcLayoutUtil.getOUNameFromContainer((FcFormDataContainer)fromClientData);
            ArrayList ouList = WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
            if (ouList.size() > 0 && !ouList.contains(containerName)) {
                boolean isExcludeChildOu = WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId);
                Criteria c = null;
                c = isExcludeChildOu ? OUUtil.getOUCriteriaWithEquals((String)"ADSMOUDetails", (ArrayList)ouList) : OUUtil.getOUCriteriaWithEndsWITH((String)"ADSMOUDetails", (ArrayList)ouList);
                ouList = OUUtil.getOUList((String)domainName, (Criteria)c);
                if (!ouList.contains(containerName)) {
                    return -2L;
                }
            }
            FcLayoutUpdateHandler.updateObjectCreationIdDetails((Long)objectCreationId, (String)domainName, (String)containerName, (Long)layoutId);
            requestId = FcExecuteFormFlow.createWorkFlowRequest(objectCreationId, FcExecuteActionConstants.groupCreationTemplateCategoryId, loginId, domainName, wfCreateRequestJson, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return requestId;
    }

    @Override
    public String getErrorCodes(Object key, NativeError errHdlr) {
        StringBuilder errCodeBuilder = new StringBuilder();
        try {
            ArrayList errorList = errHdlr.getErrorList(key);
            if (errorList != null && !errorList.isEmpty()) {
                String errorCode = null;
                for (Hashtable hashtable : errorList) {
                    errorCode = (String)hashtable.get("ERROR_CODE");
                    if (errorCode == null) continue;
                    errCodeBuilder.append(errCodeBuilder.length() > 0 ? "," + errorCode : errorCode);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCodeBuilder.toString();
    }

    public Properties getBulkGroupErrorMessage(NativeError statusObject, String escapedUserName) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        StringBuilder errCodeBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.domainName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            errCodeBuilder.append(this.getErrorCodes(this.domainName, statusObject));
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", message);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.ouName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.ouName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.ouName);
            errCodeBuilder.append(this.getErrorCodes(this.domainName, statusObject));
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.setProperty("CREATION_MESSAGE", message);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)this.groupName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)this.groupName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)this.groupName);
            errCodeBuilder.append(this.getErrorCodes(this.groupName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        if (!this.groupName.equals(escapedUserName) && statusObject.getErrorMessage((Object)escapedUserName, this.rb) != null) {
            message = statusObject.getErrorMessage((Object)escapedUserName, this.rb);
            errorSeverity = statusObject.getSeverityLevel((Object)escapedUserName);
            errCodeBuilder.append(this.getErrorCodes(escapedUserName, statusObject));
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) != null) {
                messageBuilder.append(statusObject.getErrorMessage(object, this.rb));
            }
            errCodeBuilder.append(this.getErrorCodes(object, statusObject));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", MessageFormat.format(this.rb.getString("admp.ad_mgmt.create_user.successfully_created_group_but_following_errors_occured"), messageBuilder.toString()));
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.msg_sucessfully_created_group"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        statusProps.setProperty("ERROR_CODE", errCodeBuilder.toString());
        return statusProps;
    }

    @Override
    public void setStatusMsgForWorkFlowResponse(HttpServletRequest request, Long requestId) {
        request.setAttribute("userName", (Object)this.fcNativeProperties.getProps().getProperty("name"));
        request.setAttribute("ouName", (Object)this.ouName);
        Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
        if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
            this.nativeStatusProps.setProperty("STATUS_MESSAGE", LicenseMgr.getInstance().getlicenseMessage("Workflow", this.rb));
            this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
        } else if (!this.isBulkMgmt) {
            if (requestId.compareTo(-2L) == 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.message_OU_failure"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            } else if (requestId.compareTo(-1L) != 0) {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.message_success"), requestId.toString()));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SUCCESS");
            } else {
                this.nativeStatusProps.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.message_failure"));
                this.nativeStatusProps.setProperty("CREATION_STATUS", "SEVERE");
            }
        }
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
    }

    public void addAttributeToNativeProps(FcFormDataContainer fromClientData) throws Exception {
        Properties prop = new Properties();
        prop.put("domainName", this.domainName);
        Properties ldapVsValueProps = FcGroupMgmtHandler.getInstance().getLdapVsValues(this.fromClientData, prop);
        this.getProperties(false, fromClientData, this.fcNativeProperties, ldapVsValueProps, "group");
    }

    @Override
    public boolean importCSVDetailsForAutomation(Long objectCreationId, DataObject dataObj, JSONObject errorDetailsObj, Vector headerVector, ArrayList<Vector> list, Long loginId, AdventNetResourceBundle rb, String domainName, Long selectedLayoutId, boolean isTemplateHeaderAvailable, int templateHeaderIndex) {
        boolean isnamefound = false;
        int i = 0;
        int pos = 0;
        if (headerVector != null) {
            for (Object object : headerVector) {
                if (object.toString() == "name") {
                    isnamefound = true;
                }
                if (object.toString() == "displayName") {
                    pos = i;
                }
                ++i;
            }
        }
        if (!isnamefound) {
            headerVector.add("name");
            try {
                for (Vector vector : list) {
                    vector.add((String)vector.get(pos));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, null, dataObj, errorDetailsObj, headerVector, list, FcExecuteActionConstants.groupCreationTemplateCategoryId, loginId, rb, domainName, isTemplateHeaderAvailable, templateHeaderIndex, selectedLayoutId, false, FcLayoutUtil.getDPValues((Long)loginId, (String)domainName, (AdventNetResourceBundle)rb));
        return status;
    }

    public void setStatusMsgForResponse(HttpServletRequest request) {
        request.setAttribute("statusProps", (Object)this.nativeStatusProps);
        request.setAttribute("userName", (Object)this.groupName);
        request.setAttribute("rusMessage", (Object)this.rusMessage);
        request.setAttribute("customScriptResult", (Object)this.customScriptResult);
        this.hostId = request.getRemoteHost();
        Long tid = new Long(request.getParameter("templateId"));
        Properties toAudit = new Properties();
        toAudit.setProperty("TEMPLATE_NAME", FcLayoutViewHandler.getLayoutName((Long)tid, (AdventNetResourceBundle)this.rb));
        this.updateAuditEntries(null, toAudit);
    }

    public Long updateAuditEntries() {
        return this.updateAuditEntries(null);
    }

    public Long updateAuditEntries(ArrayList<Long> auditObjectIdList) {
        return this.updateAuditEntries(auditObjectIdList, null);
    }

    public Long updateAuditEntries(ArrayList<Long> auditObjectIdList, Properties toAudit) {
        Long audit_id = 0L;
        Long object_id = 0L;
        this.auditLogProps.put("domainName", this.domainName);
        if (this.groupName != null) {
            this.auditLogProps.put("userName", this.groupName);
        } else {
            this.groupName = "";
        }
        this.auditLogProps.put("propList", this.fcNativeProperties.getPropList());
        this.auditLogProps.put("nonExchPropList", this.fcNativeProperties.getNonExchAttributeList());
        this.auditLogProps.put("modifyList", this.fcNativeProperties.getModifyList());
        this.auditLogProps.put("groupList", this.groupList);
        this.auditLogProps.put("crossForestMembersList", this.crossForestMembersList);
        String statusMessage = "";
        try {
            Integer reportId = 4007;
            if (!this.isBulkMgmt) {
                reportId = 4001;
                String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
                if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                    DomainHandler.updateDomainDatas((String)this.domainName, (Long)this.loginId, (String[])new String[]{"Group"}, (boolean)false);
                }
            }
            if (this.isWorkflowExcution && this.workFlowType.compareTo(0L) == 0) {
                reportId = 4001;
            } else if (this.isWorkflowExcution) {
                reportId = 4007;
            }
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleName = "";
            moduleName = this.workFlowType == 2L ? this.rb.getString("admp.workflow.listrequest.request_mode.ssp_api_request") : (this.workFlowType == 1L ? this.rb.getString("admp.auto.automation.heading.automation") : (this.workFlowType == 0L ? this.rb.getString("admp.home.feature.heading.workflow") : ""));
            audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleName, (Long)this.requestId);
            object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (Long)this.objectIndexId, (Long)FcExecuteActionConstants.groupCreationTemplateCategoryId, (String)this.groupName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            if (auditObjectIdList != null && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                auditObjectIdList.add(object_id);
            }
            ArrayList propList = this.fcNativeProperties.getPropList();
            Properties props = this.fcNativeProperties.getProps();
            if (!this.crossForestMembersList.isEmpty()) {
                boolean propAdded = false;
                for (int i = 0; i < propList.size(); ++i) {
                    Hashtable attHash = (Hashtable)propList.get(i);
                    if (!((String)attHash.get("ATTRIB_LDAP_NAME")).equalsIgnoreCase("member")) continue;
                    ArrayList memberValues = new ArrayList();
                    if (((Long)attHash.get("ATTRIB_VALUE_COUNT")).equals(1L)) {
                        memberValues.add((String)attHash.get("ATTRIB_VALUE"));
                    } else {
                        memberValues = (ArrayList)attHash.get("ATTRIB_VALUE");
                    }
                    memberValues.addAll(this.crossForestMembersDNList);
                    attHash.put("ATTRIB_VALUE", memberValues);
                    attHash.put("ATTRIB_VALUE_COUNT", new Long(memberValues.size()));
                    propAdded = true;
                }
                if (!propAdded) {
                    Properties memList = new Properties();
                    memList.put("ATTRIB_LDAP_NAME", "member");
                    memList.put("ATTRIB_VALUE_COUNT", new Long(this.crossForestMembersDNList.size()));
                    memList.put("ATTRIB_VALUE", this.crossForestMembersDNList);
                    propList.add(memList);
                }
            }
            if (this.groupList != null && !this.groupList.isEmpty()) {
                Properties grpList = new Properties();
                grpList.put("ATTRIB_LDAP_NAME", "memberOf");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)2L);
                grpList.put("ATTRIB_VALUE", this.groupList);
                propList.add(grpList);
            }
            Properties ouProp = new Properties();
            ouProp.put("ATTRIB_LDAP_NAME", "ouName");
            ouProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
            ouProp.put("ATTRIB_VALUE", this.ouName);
            propList.add(ouProp);
            ArrayList<String> objectOUList = new ArrayList<String>();
            objectOUList.add(this.ouName);
            if (props.get("customScriptDetails") != null) {
                Properties grpList = new Properties();
                Properties customscript = (Properties)props.get("customScriptDetails");
                grpList.put("ATTRIB_LDAP_NAME", "Custom Script");
                grpList.put("ATTRIB_VALUE_COUNT", (Object)1L);
                grpList.put("ATTRIB_VALUE", (String)((Hashtable)customscript).get("SCRIPT_COMMAND"));
                propList.add(grpList);
            }
            for (int ijk = 0; ijk < this.customList.size(); ++ijk) {
                Hashtable customHash = this.customList.get(ijk);
                Properties customProp = new Properties();
                customProp.put("ATTRIB_LDAP_NAME", customHash.get("ATTRIB_LDAP_NAME"));
                customProp.put("ATTRIB_VALUE_COUNT", (Object)1L);
                customProp.put("ATTRIB_VALUE", customHash.get("ATTRIB_VALUE"));
                propList.add(customProp);
            }
            if (toAudit != null) {
                Properties propToAud = new Properties();
                propToAud.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.text_template_name"));
                propToAud.put("ATTRIB_VALUE", toAudit.getProperty("TEMPLATE_NAME"));
                propList.add(propToAud);
            }
            if (!this.isBulkMgmt) {
                if (this.nativeStatusProps.get("CREATION_MESSAGE") == null) {
                    statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.success_created_group");
                } else {
                    ArrayList creationMsg = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
                    if (creationMsg != null && !creationMsg.isEmpty()) {
                        for (int i = 0; i < creationMsg.size(); ++i) {
                            Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                            String errorCode = (String)creationMessage.get("ERROR_CODE");
                            if (errorCode != null) {
                                statusMessage = statusMessage + this.rb.getString("admp.mgmt.user_mgmt.mod_single_user.text_error_code") + " -  : " + statusMessage;
                            }
                            statusMessage = statusMessage + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE")) + creationMessage.get("NATIVE_ERROR_MESSAGE");
                        }
                    }
                }
                if (!this.rusMessage.equals("")) {
                    statusMessage = statusMessage + this.rusMessage;
                }
            } else {
                statusMessage = (String)this.nativeStatusProps.get("CREATION_MESSAGE");
                if (this.rusMessage.trim().length() > 0) {
                    statusMessage = statusMessage + " " + this.rusMessage;
                    this.nativeStatusProps.setProperty("CREATION_MESSAGE", statusMessage);
                }
            }
            if (props.get("sendAs") != null) {
                ArrayList sIDList = (ArrayList)props.get("sendAs");
                ArrayList<String> dNList = new ArrayList<String>();
                ArrayList remainingSIDs = (ArrayList)sIDList.clone();
                String[] tableArray = new String[]{"ADSMGroupGeneralDetails"};
                String[] requiredColumns = new String[]{"DISTINGUISHED_NAME", "SID_STRING"};
                String criteriaColumn = "SID_STRING";
                ArrayList dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)sIDList);
                for (int i = 0; i < dbValuesList.size(); ++i) {
                    Properties dbValueProp = (Properties)dbValuesList.get(i);
                    dNList.add(dbValueProp.getProperty("DISTINGUISHED_NAME"));
                    remainingSIDs.remove(dbValueProp.getProperty("SID_STRING"));
                }
                if (!remainingSIDs.isEmpty()) {
                    dNList.addAll(remainingSIDs);
                }
                Properties sendAsProps = new Properties();
                sendAsProps.put("ATTRIB_LDAP_NAME", "sendAs");
                sendAsProps.put("ATTRIB_DISP_NAME", this.rb.getString("admp.common.attrib_disp_name.send_as"));
                sendAsProps.put("ATTRIB_VALUE", dNList);
                propList.add(sendAsProps);
            }
            TechAuditAPI.getInstance().auditGroupModification(this.loginId, this.rb.getString("admp.mgmt.grp_mgmt.cre_single_grp.mgmtname.group_creation"), this.groupName, this.domainName, propList, this.rb.getString(statusMessage), object_id, auditDataObj, this.rb);
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (this.workFlowType != 0L && !this.isBulkMgmt && this.nativeStatusProps.getProperty("CREATION_STATUS") != null && !this.nativeStatusProps.getProperty("CREATION_STATUS").equals("SEVERE")) {
                Integer userObjectId = 2;
                String manager = "";
                FcLayoutField field = this.userData.get((Object)FcExecuteActionConstants.GROUP_CREATION_MANAGED_BY_FIELD_ID) != null ? (FcLayoutField)this.userData.get((Object)FcExecuteActionConstants.GROUP_CREATION_MANAGED_BY_FIELD_ID) : (FcLayoutField)this.fromClientData.get((Object)FcExecuteActionConstants.GROUP_CREATION_MANAGED_BY_FIELD_ID);
                if (field != null) {
                    FcManager fcManager = (FcManager)field.getIComponent();
                    manager = fcManager.getUserName() != null ? fcManager.getUserName() : "";
                }
                this.viewId = FcExecuteActionConstants.BGC_LAYOUT_VIEW_ID;
                this.triggerNotifiation(audit_id, object_id, this.groupName, manager, null, userObjectId, ReportsUtil.SINGLE_GROUP_CREATION_REPORT_ID, this.domainName, this.rb, objectOUList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return audit_id;
    }

    public void setIsCreationSuccess() {
        if (this.nativeStatusProps != null) {
            String creationStatus = this.nativeStatusProps.getProperty("CREATION_STATUS");
            if (!creationStatus.equalsIgnoreCase("SEVERE")) {
                this.setIsCreationSuccess(true);
            }
        } else {
            this.setIsCreationSuccess(false);
        }
    }

    public void setSingleGroupErrorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.length() == 0) {
            return;
        }
        ArrayList messageList = new ArrayList();
        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", errorMessage);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
    }

    public void setSingleGroupErrorMessage(NativeError errHdlr, String searchString) {
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        if (errHdlr.getErrorMessage((Object)searchString, this.rb) != null) {
            messageList = (ArrayList<Hashtable>)this.nativeStatusProps.get("CREATION_MESSAGE");
            if (messageList == null) {
                messageList = new ArrayList<Hashtable>();
            }
            errorList = errHdlr.getErrorList((Object)searchString);
            for (Hashtable hashtable : errorList) {
                String message = this.rb.getString((String)hashtable.get("ERROR_MESSAGE"));
                hashtable.put("ERROR_MESSAGE", message);
                messageList.add(hashtable);
            }
            this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
            this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
        }
    }

    public Properties getSingleGroupErrorMessage(NativeError statusObject, String escapedGroupName) {
        String statusMessage = this.rb.getString("admp.mgmt.user_mgmt.cre_single_group.statmsg.success_created_group");
        Properties statusProps = new Properties();
        ArrayList<Hashtable> messageList = new ArrayList<Hashtable>();
        ArrayList errorList = new ArrayList();
        String errorSeverity = null;
        String ouName = CommonUtil.escapeDN((String)this.ouName);
        if (statusObject.getErrorMessage((Object)this.domainName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)this.domainName);
            errorSeverity = statusObject.getSeverityLevel((Object)this.domainName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)ouName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)ouName);
            errorSeverity = statusObject.getSeverityLevel((Object)ouName);
            if (errorSeverity != null) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
            }
            statusProps.put("CREATION_MESSAGE", errorList);
            statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            return statusProps;
        }
        if (statusObject.getErrorMessage((Object)escapedGroupName, this.rb) != null) {
            errorList = statusObject.getErrorList((Object)escapedGroupName);
            errorSeverity = statusObject.getSeverityLevel((Object)escapedGroupName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.put("CREATION_MESSAGE", errorList);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            if (!errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    messageList.add(hashtable);
                }
            }
        }
        for (Object object : this.groupList) {
            if (statusObject.getErrorMessage(object, this.rb) == null || (errorList = statusObject.getErrorList(object)).isEmpty()) continue;
            for (Hashtable hashtable : errorList) {
                messageList.add(hashtable);
            }
        }
        if (messageList.size() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("STATUS_MESSAGE", statusMessage);
            statusProps.put("CREATION_MESSAGE", messageList);
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("STATUS_MESSAGE", statusMessage);
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    public boolean getIsBulkMgmt() {
        return false;
    }

    public void setFieldValueList(Properties fieldValue) {
    }

    public Properties getNativeStatusProps() {
        return null;
    }

    public void setSingleUserErrorMessage(String errorMessage) {
        ArrayList messageList = new ArrayList();
        messageList = (ArrayList)this.nativeStatusProps.get("CREATION_MESSAGE");
        if (messageList == null) {
            messageList = new ArrayList();
        }
        Hashtable<String, String> errorHash = new Hashtable<String, String>();
        errorHash.put("ERROR_MESSAGE", errorMessage);
        messageList.add(errorHash);
        this.nativeStatusProps.put("CREATION_MESSAGE", messageList);
        this.nativeStatusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
    }
}

