/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.layout;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcAttributes;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcFormDataContainer;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcO365DistGroupModificationMgmtHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcO365MgmtListener;
import com.adventnet.sym.adsm.common.webclient.layout.o365.O365MgmtUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class FcO365DistGroupModificationListener
extends FcO365MgmtListener {
    String[] mandatoryFields = new String[]{"DisplayName", "EmailAddresses", "Alias", "ManagedBy", "o365SendAs"};
    String displayName = null;
    String guid = "";
    String domainName = "";
    boolean applyOURestriction = false;
    String tempTableName = "";
    boolean isChangesFound = true;
    FcLayout executeFormLayout = null;
    Properties fieldValueList = new Properties();

    @Override
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public void setFieldValueList(Properties fieldValue) {
        this.fieldValueList = fieldValue;
    }

    @Override
    public ArrayList getMandatoryFields() {
        ArrayList ar = new ArrayList();
        Collections.addAll(ar, this.mandatoryFields);
        return ar;
    }

    @Override
    public void doAction(Long creationId, String domainName, FcLayout executeLayout, FcFormDataContainer fromClientData, FcFormDataContainer userData, FcFormDataContainer adData, FcIamApps fcIamApps, Long loginId, FcLayout executeLayoutForm) {
        this.creationId = creationId;
        this.domainName = domainName;
        this.executeLayout = executeLayout;
        this.fromClientData = fromClientData;
        this.userData = userData;
        this.adData = adData;
        this.fcIamApps = fcIamApps;
        this.loginId = loginId;
        this.executeFormLayout = executeLayoutForm;
        this.nativeStatusProperties = new Properties();
        this.modifyO365DistGroup();
    }

    private void modifyO365DistGroup() {
        this.attribListToNative = new ArrayList();
        this.attributeList = new ArrayList();
        this.propList = new ArrayList();
        this.o365ConfigProp = O365MgmtHandler.getO365ConfigDataWithTenantId((String)this.domainName, (Long)this.loginId);
        if (this.o365ConfigProp == null) {
            ArrayList messageList = new ArrayList();
            Hashtable<String, String> errorHash = new Hashtable<String, String>();
            errorHash.put("ERROR_MESSAGE", this.rb.getString("admp.mgmt.fc_layout.no_office365_credentials"));
            messageList.add(errorHash);
            this.nativeStatusProperties.put("CREATION_MESSAGE", messageList);
            this.nativeStatusProperties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            this.nativeStatusProperties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            this.nativeStatusProperties.put("CREATION_STATUS", "SEVERE");
            return;
        }
        this.convertO365DomainsListToLowerCase();
        String o365TenantId = this.o365ConfigProp.getProperty("username");
        String o365TenantPass = this.o365ConfigProp.getProperty("password");
        FcFormDataContainer modifiedFieldsContainer = new FcFormDataContainer();
        FcExecuteFormFlow.fillModifiedFields(FcExecuteActionConstants.o365DistGroupModificationTemplateCategoryId, modifiedFieldsContainer, this.fromClientData, this.adData, this.rb, null, this.loginId, this.guid, this.domainName, this.executeFormLayout, this);
        FcO365DistGroupModificationMgmtHandler.getInstance().updateFieldsAttributes(modifiedFieldsContainer);
        FcO365DistGroupModificationMgmtHandler.getInstance().updateFieldsAttributes(this.fromClientData);
        FcO365DistGroupModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(modifiedFieldsContainer);
        FcO365DistGroupModificationMgmtHandler.getInstance().updateFieldValuesToAttributes(this.fromClientData);
        if (modifiedFieldsContainer != null && modifiedFieldsContainer.size() > 0) {
            this.getProperties(modifiedFieldsContainer);
        } else {
            this.nativeStatusProperties.setProperty("CREATION_STATUS", "SUCCESS");
            this.nativeStatusProperties.setProperty("STATUS_MESSAGE", this.rb.getString("admp.mgmt.fc_layout_title.text_no_changes_found"));
            this.isChangesFound = false;
        }
        if (!this.isAuthorized) {
            ArrayList messageList = new ArrayList();
            Hashtable<String, String> errorHash = new Hashtable<String, String>();
            errorHash.put("ERROR_MESSAGE", MessageFormat.format(this.rb.getString("admp.deleg.hdt_deleg.mod_hdt.domain_unauthorized"), this.unAuthorizedDomainName));
            messageList.add(errorHash);
            this.nativeStatusProperties.put("CREATION_MESSAGE", messageList);
            this.nativeStatusProperties.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
            this.nativeStatusProperties.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
            this.nativeStatusProperties.put("CREATION_STATUS", "SEVERE");
            return;
        }
        boolean isSuccess = false;
        if (this.isChangesFound) {
            isSuccess = O365MgmtUtil.modifyO365DistGroup(this.nativeStatusProperties, o365TenantId, o365TenantPass, this.guid, this.attribListToNative, this.rb);
        }
        if (isSuccess) {
            this.nativeStatusProperties.put("STATUS_MESSAGE", this.rb.getString("admp.mgmt.office365.group_success_mod"));
            this.nativeStatusProperties.put("CREATION_STATUS", "SUCCESS");
        }
    }

    @Override
    public void getADValues(Long templateCategoryId, FcFormDataContainer fcLayoutTabFields, FcFormDataContainer adDataContainer, Long loginId) {
        try {
            ArrayList attribList = FcExecuteFormFlow.getLDAPNames(templateCategoryId, fcLayoutTabFields);
            Properties valuesList = FcExecuteFormFlow.getObjectProperties(this.guid, this.domainName, loginId, attribList);
            this.fillMandatoryFields(valuesList);
            this.fillADValues(fcLayoutTabFields, adDataContainer, valuesList, loginId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillMandatoryFields(Properties valuesList) {
        try {
            ArrayList displayNameList = (ArrayList)valuesList.get("DisplayName");
            if (displayNameList != null) {
                this.displayName = (String)displayNameList.get(0);
            }
            if (valuesList.get("o365SendAs") != null) {
                ArrayList temp = (ArrayList)valuesList.get("o365SendAs");
                this.sendAsList = new ArrayList();
                ArrayList waadDomainList = O365MgmtHandler.getWAADDomainList((String)this.domainName);
                for (int i = 0; i < temp.size(); ++i) {
                    String value = (String)temp.get(i);
                    for (int j = 0; j < waadDomainList.size(); ++j) {
                        if (!value.endsWith("@" + (String)waadDomainList.get(j))) continue;
                        value = value.substring(0, value.indexOf(64));
                    }
                    this.sendAsList.add(value);
                }
                valuesList.put("o365SendAs", this.sendAsList);
            }
            if (valuesList.get("ManagedBy") != null) {
                this.managedByList = (ArrayList)valuesList.get("ManagedBy");
            }
            if (valuesList.get("Members") != null) {
                this.membersList = (ArrayList)valuesList.get("Members");
            }
            if (valuesList.get("AcceptMessagesOnlyFromSendersOrMembers") != null) {
                this.acceptMessagesFromList = (ArrayList)valuesList.get("AcceptMessagesOnlyFromSendersOrMembers");
            }
            if (valuesList.get("ModeratedBy") != null) {
                this.moderatedByList = (ArrayList)valuesList.get("ModeratedBy");
            }
            if (valuesList.get("GrantSendOnBehalfTo") != null) {
                this.sendOnBehalfList = (ArrayList)valuesList.get("GrantSendOnBehalfTo");
            }
            if (valuesList.get("EmailAddresses") != null) {
                this.emailAddressList = (ArrayList)valuesList.get("EmailAddresses");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fillADValues(FcFormDataContainer fcFormDataContainer, FcFormDataContainer adDataContainer, Properties valuesList, Long loginId, boolean showADValue) {
        try {
            Properties prop = new Properties();
            prop.put("domainName", this.domainName);
            prop.put("loginId", loginId);
            Enumeration e = fcFormDataContainer.elements();
            while (e.hasMoreElements()) {
                FcLayoutField fcLayoutField = (FcLayoutField)e.nextElement();
                ArrayList fcAttributesList = fcLayoutField.getFcAttributeList();
                FcAttributes fcAttribute = (FcAttributes)fcAttributesList.get(0);
                String ldapName = fcAttribute.getAttribLdapName();
                fcLayoutField.getIComponent().setValuesFromAD(fcLayoutField, adDataContainer, valuesList, prop, showADValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setStatusMsgForResponse(HttpServletRequest request) {
        try {
            ArrayList creationMsg;
            String statusMessage;
            request.setAttribute("statusProps", (Object)this.nativeStatusProperties);
            if (!this.isChangesFound) {
                return;
            }
            String hostId = request.getRemoteHost();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)8053, (DataObject)auditDataObj, null, (AdventNetResourceBundle)this.rb, (String)this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"), (Long)0L, null, (String)this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.o365_mgmt"));
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)this.displayName, (String)this.domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            if (this.byPassModerationList.size() > 0) {
                ArrayList<String> auditList = new ArrayList<String>();
                String[] tableArray = new String[]{"O365UserGeneralDetails", "O365GroupGeneralDetails", "O365ContactGeneralDetails"};
                String[] requiredColumns = new String[]{"DISPLAY_NAME"};
                String criteriaColumn = "OBJECT_ID";
                ArrayList dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)this.byPassModerationList, (boolean)true);
                for (int i = 0; i < dbValuesList.size(); ++i) {
                    Properties dbValueProp = (Properties)dbValuesList.get(i);
                    auditList.add(dbValueProp.getProperty("DISPLAY_NAME"));
                }
                if (auditList.size() > 0) {
                    Properties props = new Properties();
                    props.put("ATTRIB_LDAP_NAME", "BypassModerationFromSendersOrMembers");
                    props.put("ATTRIB_VALUE", auditList);
                    this.propList.add(props);
                }
            }
            if ((statusMessage = this.nativeStatusProperties.getProperty("STATUS_MESSAGE")) == null) {
                statusMessage = "";
            }
            if (this.nativeStatusProperties.get("CREATION_MESSAGE") == null) {
                this.nativeStatusProperties.put("CREATION_MESSAGE", new ArrayList());
            }
            if ((creationMsg = (ArrayList)this.nativeStatusProperties.get("CREATION_MESSAGE")) != null && !creationMsg.isEmpty()) {
                for (int i = 0; i < creationMsg.size(); ++i) {
                    Hashtable creationMessage = (Hashtable)creationMsg.get(i);
                    statusMessage = statusMessage + this.rb.getString((String)creationMessage.get("ERROR_MESSAGE"));
                }
            }
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.grp_mgmt.single_grp_mod.mgmtname.mod_sing_group"), this.displayName, this.domainName, this.propList, null, null, this.nativeStatusProperties.getProperty("STATUS_MESSAGE"), object_id, auditDataObj, this.rb);
            audit_info.put("error_msg", statusMessage);
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getIsCreationSuccess() {
        String CREATION_STATUS = (String)this.nativeStatusProperties.get("CREATION_STATUS");
        return CREATION_STATUS.equalsIgnoreCase("SUCCESS");
    }
}

